/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkmanagement/v1beta1/trace.proto

package com.google.cloud.networkmanagement.v1beta1;

/**
 *
 *
 * <pre>
 * For display only. Metadata associated with a load balancer.
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkmanagement.v1beta1.LoadBalancerInfo}
 */
public final class LoadBalancerInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkmanagement.v1beta1.LoadBalancerInfo)
    LoadBalancerInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LoadBalancerInfo.newBuilder() to construct.
  private LoadBalancerInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LoadBalancerInfo() {
    loadBalancerType_ = 0;
    healthCheckUri_ = "";
    backends_ = java.util.Collections.emptyList();
    backendType_ = 0;
    backendUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LoadBalancerInfo();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkmanagement.v1beta1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1beta1_LoadBalancerInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkmanagement.v1beta1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1beta1_LoadBalancerInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.class,
            com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type definition for a load balancer:
   * </pre>
   *
   * Protobuf enum {@code google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.LoadBalancerType}
   */
  public enum LoadBalancerType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Type is unspecified.
     * </pre>
     *
     * <code>LOAD_BALANCER_TYPE_UNSPECIFIED = 0;</code>
     */
    LOAD_BALANCER_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Internal TCP/UDP load balancer.
     * </pre>
     *
     * <code>INTERNAL_TCP_UDP = 1;</code>
     */
    INTERNAL_TCP_UDP(1),
    /**
     *
     *
     * <pre>
     * Network TCP/UDP load balancer.
     * </pre>
     *
     * <code>NETWORK_TCP_UDP = 2;</code>
     */
    NETWORK_TCP_UDP(2),
    /**
     *
     *
     * <pre>
     * HTTP(S) proxy load balancer.
     * </pre>
     *
     * <code>HTTP_PROXY = 3;</code>
     */
    HTTP_PROXY(3),
    /**
     *
     *
     * <pre>
     * TCP proxy load balancer.
     * </pre>
     *
     * <code>TCP_PROXY = 4;</code>
     */
    TCP_PROXY(4),
    /**
     *
     *
     * <pre>
     * SSL proxy load balancer.
     * </pre>
     *
     * <code>SSL_PROXY = 5;</code>
     */
    SSL_PROXY(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Type is unspecified.
     * </pre>
     *
     * <code>LOAD_BALANCER_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int LOAD_BALANCER_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Internal TCP/UDP load balancer.
     * </pre>
     *
     * <code>INTERNAL_TCP_UDP = 1;</code>
     */
    public static final int INTERNAL_TCP_UDP_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Network TCP/UDP load balancer.
     * </pre>
     *
     * <code>NETWORK_TCP_UDP = 2;</code>
     */
    public static final int NETWORK_TCP_UDP_VALUE = 2;
    /**
     *
     *
     * <pre>
     * HTTP(S) proxy load balancer.
     * </pre>
     *
     * <code>HTTP_PROXY = 3;</code>
     */
    public static final int HTTP_PROXY_VALUE = 3;
    /**
     *
     *
     * <pre>
     * TCP proxy load balancer.
     * </pre>
     *
     * <code>TCP_PROXY = 4;</code>
     */
    public static final int TCP_PROXY_VALUE = 4;
    /**
     *
     *
     * <pre>
     * SSL proxy load balancer.
     * </pre>
     *
     * <code>SSL_PROXY = 5;</code>
     */
    public static final int SSL_PROXY_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LoadBalancerType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static LoadBalancerType forNumber(int value) {
      switch (value) {
        case 0:
          return LOAD_BALANCER_TYPE_UNSPECIFIED;
        case 1:
          return INTERNAL_TCP_UDP;
        case 2:
          return NETWORK_TCP_UDP;
        case 3:
          return HTTP_PROXY;
        case 4:
          return TCP_PROXY;
        case 5:
          return SSL_PROXY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<LoadBalancerType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<LoadBalancerType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<LoadBalancerType>() {
              public LoadBalancerType findValueByNumber(int number) {
                return LoadBalancerType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final LoadBalancerType[] VALUES = values();

    public static LoadBalancerType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private LoadBalancerType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.LoadBalancerType)
  }

  /**
   *
   *
   * <pre>
   * The type definition for a load balancer backend configuration:
   * </pre>
   *
   * Protobuf enum {@code google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.BackendType}
   */
  public enum BackendType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Type is unspecified.
     * </pre>
     *
     * <code>BACKEND_TYPE_UNSPECIFIED = 0;</code>
     */
    BACKEND_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Backend Service as the load balancer's backend.
     * </pre>
     *
     * <code>BACKEND_SERVICE = 1;</code>
     */
    BACKEND_SERVICE(1),
    /**
     *
     *
     * <pre>
     * Target Pool as the load balancer's backend.
     * </pre>
     *
     * <code>TARGET_POOL = 2;</code>
     */
    TARGET_POOL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Type is unspecified.
     * </pre>
     *
     * <code>BACKEND_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int BACKEND_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Backend Service as the load balancer's backend.
     * </pre>
     *
     * <code>BACKEND_SERVICE = 1;</code>
     */
    public static final int BACKEND_SERVICE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Target Pool as the load balancer's backend.
     * </pre>
     *
     * <code>TARGET_POOL = 2;</code>
     */
    public static final int TARGET_POOL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BackendType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static BackendType forNumber(int value) {
      switch (value) {
        case 0:
          return BACKEND_TYPE_UNSPECIFIED;
        case 1:
          return BACKEND_SERVICE;
        case 2:
          return TARGET_POOL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<BackendType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<BackendType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<BackendType>() {
          public BackendType findValueByNumber(int number) {
            return BackendType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final BackendType[] VALUES = values();

    public static BackendType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private BackendType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.BackendType)
  }

  public static final int LOAD_BALANCER_TYPE_FIELD_NUMBER = 1;
  private int loadBalancerType_;
  /**
   *
   *
   * <pre>
   * Type of the load balancer.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.LoadBalancerType load_balancer_type = 1;
   * </code>
   *
   * @return The enum numeric value on the wire for loadBalancerType.
   */
  @java.lang.Override
  public int getLoadBalancerTypeValue() {
    return loadBalancerType_;
  }
  /**
   *
   *
   * <pre>
   * Type of the load balancer.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.LoadBalancerType load_balancer_type = 1;
   * </code>
   *
   * @return The loadBalancerType.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.LoadBalancerType
      getLoadBalancerType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.LoadBalancerType result =
        com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.LoadBalancerType.valueOf(
            loadBalancerType_);
    return result == null
        ? com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.LoadBalancerType.UNRECOGNIZED
        : result;
  }

  public static final int HEALTH_CHECK_URI_FIELD_NUMBER = 2;
  private volatile java.lang.Object healthCheckUri_;
  /**
   *
   *
   * <pre>
   * URI of the health check for the load balancer.
   * </pre>
   *
   * <code>string health_check_uri = 2;</code>
   *
   * @return The healthCheckUri.
   */
  @java.lang.Override
  public java.lang.String getHealthCheckUri() {
    java.lang.Object ref = healthCheckUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      healthCheckUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of the health check for the load balancer.
   * </pre>
   *
   * <code>string health_check_uri = 2;</code>
   *
   * @return The bytes for healthCheckUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHealthCheckUriBytes() {
    java.lang.Object ref = healthCheckUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      healthCheckUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BACKENDS_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend> backends_;
  /**
   *
   *
   * <pre>
   * Information for the loadbalancer backends.
   * </pre>
   *
   * <code>repeated .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend backends = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend>
      getBackendsList() {
    return backends_;
  }
  /**
   *
   *
   * <pre>
   * Information for the loadbalancer backends.
   * </pre>
   *
   * <code>repeated .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend backends = 3;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackendOrBuilder>
      getBackendsOrBuilderList() {
    return backends_;
  }
  /**
   *
   *
   * <pre>
   * Information for the loadbalancer backends.
   * </pre>
   *
   * <code>repeated .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend backends = 3;</code>
   */
  @java.lang.Override
  public int getBackendsCount() {
    return backends_.size();
  }
  /**
   *
   *
   * <pre>
   * Information for the loadbalancer backends.
   * </pre>
   *
   * <code>repeated .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend backends = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend getBackends(int index) {
    return backends_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Information for the loadbalancer backends.
   * </pre>
   *
   * <code>repeated .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend backends = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackendOrBuilder
      getBackendsOrBuilder(int index) {
    return backends_.get(index);
  }

  public static final int BACKEND_TYPE_FIELD_NUMBER = 4;
  private int backendType_;
  /**
   *
   *
   * <pre>
   * Type of load balancer's backend configuration.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.BackendType backend_type = 4;
   * </code>
   *
   * @return The enum numeric value on the wire for backendType.
   */
  @java.lang.Override
  public int getBackendTypeValue() {
    return backendType_;
  }
  /**
   *
   *
   * <pre>
   * Type of load balancer's backend configuration.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.BackendType backend_type = 4;
   * </code>
   *
   * @return The backendType.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.BackendType getBackendType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.BackendType result =
        com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.BackendType.valueOf(
            backendType_);
    return result == null
        ? com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.BackendType.UNRECOGNIZED
        : result;
  }

  public static final int BACKEND_URI_FIELD_NUMBER = 5;
  private volatile java.lang.Object backendUri_;
  /**
   *
   *
   * <pre>
   * Backend configuration URI.
   * </pre>
   *
   * <code>string backend_uri = 5;</code>
   *
   * @return The backendUri.
   */
  @java.lang.Override
  public java.lang.String getBackendUri() {
    java.lang.Object ref = backendUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      backendUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Backend configuration URI.
   * </pre>
   *
   * <code>string backend_uri = 5;</code>
   *
   * @return The bytes for backendUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBackendUriBytes() {
    java.lang.Object ref = backendUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      backendUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (loadBalancerType_
        != com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.LoadBalancerType
            .LOAD_BALANCER_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, loadBalancerType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(healthCheckUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, healthCheckUri_);
    }
    for (int i = 0; i < backends_.size(); i++) {
      output.writeMessage(3, backends_.get(i));
    }
    if (backendType_
        != com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.BackendType
            .BACKEND_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, backendType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(backendUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, backendUri_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (loadBalancerType_
        != com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.LoadBalancerType
            .LOAD_BALANCER_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, loadBalancerType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(healthCheckUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, healthCheckUri_);
    }
    for (int i = 0; i < backends_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, backends_.get(i));
    }
    if (backendType_
        != com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.BackendType
            .BACKEND_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, backendType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(backendUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, backendUri_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo other =
        (com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo) obj;

    if (loadBalancerType_ != other.loadBalancerType_) return false;
    if (!getHealthCheckUri().equals(other.getHealthCheckUri())) return false;
    if (!getBackendsList().equals(other.getBackendsList())) return false;
    if (backendType_ != other.backendType_) return false;
    if (!getBackendUri().equals(other.getBackendUri())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + LOAD_BALANCER_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + loadBalancerType_;
    hash = (37 * hash) + HEALTH_CHECK_URI_FIELD_NUMBER;
    hash = (53 * hash) + getHealthCheckUri().hashCode();
    if (getBackendsCount() > 0) {
      hash = (37 * hash) + BACKENDS_FIELD_NUMBER;
      hash = (53 * hash) + getBackendsList().hashCode();
    }
    hash = (37 * hash) + BACKEND_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + backendType_;
    hash = (37 * hash) + BACKEND_URI_FIELD_NUMBER;
    hash = (53 * hash) + getBackendUri().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * For display only. Metadata associated with a load balancer.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkmanagement.v1beta1.LoadBalancerInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkmanagement.v1beta1.LoadBalancerInfo)
      com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1beta1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1beta1_LoadBalancerInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkmanagement.v1beta1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1beta1_LoadBalancerInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.class,
              com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.Builder.class);
    }

    // Construct using com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      loadBalancerType_ = 0;

      healthCheckUri_ = "";

      if (backendsBuilder_ == null) {
        backends_ = java.util.Collections.emptyList();
      } else {
        backends_ = null;
        backendsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      backendType_ = 0;

      backendUri_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkmanagement.v1beta1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1beta1_LoadBalancerInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo getDefaultInstanceForType() {
      return com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo build() {
      com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo buildPartial() {
      com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo result =
          new com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo(this);
      int from_bitField0_ = bitField0_;
      result.loadBalancerType_ = loadBalancerType_;
      result.healthCheckUri_ = healthCheckUri_;
      if (backendsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          backends_ = java.util.Collections.unmodifiableList(backends_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.backends_ = backends_;
      } else {
        result.backends_ = backendsBuilder_.build();
      }
      result.backendType_ = backendType_;
      result.backendUri_ = backendUri_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo) {
        return mergeFrom((com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo other) {
      if (other == com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.getDefaultInstance())
        return this;
      if (other.loadBalancerType_ != 0) {
        setLoadBalancerTypeValue(other.getLoadBalancerTypeValue());
      }
      if (!other.getHealthCheckUri().isEmpty()) {
        healthCheckUri_ = other.healthCheckUri_;
        onChanged();
      }
      if (backendsBuilder_ == null) {
        if (!other.backends_.isEmpty()) {
          if (backends_.isEmpty()) {
            backends_ = other.backends_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureBackendsIsMutable();
            backends_.addAll(other.backends_);
          }
          onChanged();
        }
      } else {
        if (!other.backends_.isEmpty()) {
          if (backendsBuilder_.isEmpty()) {
            backendsBuilder_.dispose();
            backendsBuilder_ = null;
            backends_ = other.backends_;
            bitField0_ = (bitField0_ & ~0x00000001);
            backendsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBackendsFieldBuilder()
                    : null;
          } else {
            backendsBuilder_.addAllMessages(other.backends_);
          }
        }
      }
      if (other.backendType_ != 0) {
        setBackendTypeValue(other.getBackendTypeValue());
      }
      if (!other.getBackendUri().isEmpty()) {
        backendUri_ = other.backendUri_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                loadBalancerType_ = input.readEnum();

                break;
              } // case 8
            case 18:
              {
                healthCheckUri_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend m =
                    input.readMessage(
                        com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.parser(),
                        extensionRegistry);
                if (backendsBuilder_ == null) {
                  ensureBackendsIsMutable();
                  backends_.add(m);
                } else {
                  backendsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 32:
              {
                backendType_ = input.readEnum();

                break;
              } // case 32
            case 42:
              {
                backendUri_ = input.readStringRequireUtf8();

                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int loadBalancerType_ = 0;
    /**
     *
     *
     * <pre>
     * Type of the load balancer.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.LoadBalancerType load_balancer_type = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for loadBalancerType.
     */
    @java.lang.Override
    public int getLoadBalancerTypeValue() {
      return loadBalancerType_;
    }
    /**
     *
     *
     * <pre>
     * Type of the load balancer.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.LoadBalancerType load_balancer_type = 1;
     * </code>
     *
     * @param value The enum numeric value on the wire for loadBalancerType to set.
     * @return This builder for chaining.
     */
    public Builder setLoadBalancerTypeValue(int value) {

      loadBalancerType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of the load balancer.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.LoadBalancerType load_balancer_type = 1;
     * </code>
     *
     * @return The loadBalancerType.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.LoadBalancerType
        getLoadBalancerType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.LoadBalancerType result =
          com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.LoadBalancerType.valueOf(
              loadBalancerType_);
      return result == null
          ? com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.LoadBalancerType
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Type of the load balancer.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.LoadBalancerType load_balancer_type = 1;
     * </code>
     *
     * @param value The loadBalancerType to set.
     * @return This builder for chaining.
     */
    public Builder setLoadBalancerType(
        com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.LoadBalancerType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      loadBalancerType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of the load balancer.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.LoadBalancerType load_balancer_type = 1;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLoadBalancerType() {

      loadBalancerType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object healthCheckUri_ = "";
    /**
     *
     *
     * <pre>
     * URI of the health check for the load balancer.
     * </pre>
     *
     * <code>string health_check_uri = 2;</code>
     *
     * @return The healthCheckUri.
     */
    public java.lang.String getHealthCheckUri() {
      java.lang.Object ref = healthCheckUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        healthCheckUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the health check for the load balancer.
     * </pre>
     *
     * <code>string health_check_uri = 2;</code>
     *
     * @return The bytes for healthCheckUri.
     */
    public com.google.protobuf.ByteString getHealthCheckUriBytes() {
      java.lang.Object ref = healthCheckUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        healthCheckUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the health check for the load balancer.
     * </pre>
     *
     * <code>string health_check_uri = 2;</code>
     *
     * @param value The healthCheckUri to set.
     * @return This builder for chaining.
     */
    public Builder setHealthCheckUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      healthCheckUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the health check for the load balancer.
     * </pre>
     *
     * <code>string health_check_uri = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHealthCheckUri() {

      healthCheckUri_ = getDefaultInstance().getHealthCheckUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the health check for the load balancer.
     * </pre>
     *
     * <code>string health_check_uri = 2;</code>
     *
     * @param value The bytes for healthCheckUri to set.
     * @return This builder for chaining.
     */
    public Builder setHealthCheckUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      healthCheckUri_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend>
        backends_ = java.util.Collections.emptyList();

    private void ensureBackendsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        backends_ =
            new java.util.ArrayList<com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend>(
                backends_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend,
            com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.Builder,
            com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackendOrBuilder>
        backendsBuilder_;

    /**
     *
     *
     * <pre>
     * Information for the loadbalancer backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend backends = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend>
        getBackendsList() {
      if (backendsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(backends_);
      } else {
        return backendsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Information for the loadbalancer backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend backends = 3;
     * </code>
     */
    public int getBackendsCount() {
      if (backendsBuilder_ == null) {
        return backends_.size();
      } else {
        return backendsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Information for the loadbalancer backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend backends = 3;
     * </code>
     */
    public com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend getBackends(int index) {
      if (backendsBuilder_ == null) {
        return backends_.get(index);
      } else {
        return backendsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Information for the loadbalancer backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend backends = 3;
     * </code>
     */
    public Builder setBackends(
        int index, com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend value) {
      if (backendsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBackendsIsMutable();
        backends_.set(index, value);
        onChanged();
      } else {
        backendsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information for the loadbalancer backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend backends = 3;
     * </code>
     */
    public Builder setBackends(
        int index,
        com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.Builder builderForValue) {
      if (backendsBuilder_ == null) {
        ensureBackendsIsMutable();
        backends_.set(index, builderForValue.build());
        onChanged();
      } else {
        backendsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information for the loadbalancer backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend backends = 3;
     * </code>
     */
    public Builder addBackends(
        com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend value) {
      if (backendsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBackendsIsMutable();
        backends_.add(value);
        onChanged();
      } else {
        backendsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information for the loadbalancer backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend backends = 3;
     * </code>
     */
    public Builder addBackends(
        int index, com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend value) {
      if (backendsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBackendsIsMutable();
        backends_.add(index, value);
        onChanged();
      } else {
        backendsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information for the loadbalancer backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend backends = 3;
     * </code>
     */
    public Builder addBackends(
        com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.Builder builderForValue) {
      if (backendsBuilder_ == null) {
        ensureBackendsIsMutable();
        backends_.add(builderForValue.build());
        onChanged();
      } else {
        backendsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information for the loadbalancer backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend backends = 3;
     * </code>
     */
    public Builder addBackends(
        int index,
        com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.Builder builderForValue) {
      if (backendsBuilder_ == null) {
        ensureBackendsIsMutable();
        backends_.add(index, builderForValue.build());
        onChanged();
      } else {
        backendsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information for the loadbalancer backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend backends = 3;
     * </code>
     */
    public Builder addAllBackends(
        java.lang.Iterable<? extends com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend>
            values) {
      if (backendsBuilder_ == null) {
        ensureBackendsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, backends_);
        onChanged();
      } else {
        backendsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information for the loadbalancer backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend backends = 3;
     * </code>
     */
    public Builder clearBackends() {
      if (backendsBuilder_ == null) {
        backends_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        backendsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information for the loadbalancer backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend backends = 3;
     * </code>
     */
    public Builder removeBackends(int index) {
      if (backendsBuilder_ == null) {
        ensureBackendsIsMutable();
        backends_.remove(index);
        onChanged();
      } else {
        backendsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information for the loadbalancer backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend backends = 3;
     * </code>
     */
    public com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.Builder
        getBackendsBuilder(int index) {
      return getBackendsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Information for the loadbalancer backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend backends = 3;
     * </code>
     */
    public com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackendOrBuilder
        getBackendsOrBuilder(int index) {
      if (backendsBuilder_ == null) {
        return backends_.get(index);
      } else {
        return backendsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Information for the loadbalancer backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend backends = 3;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackendOrBuilder>
        getBackendsOrBuilderList() {
      if (backendsBuilder_ != null) {
        return backendsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(backends_);
      }
    }
    /**
     *
     *
     * <pre>
     * Information for the loadbalancer backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend backends = 3;
     * </code>
     */
    public com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.Builder
        addBackendsBuilder() {
      return getBackendsFieldBuilder()
          .addBuilder(
              com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Information for the loadbalancer backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend backends = 3;
     * </code>
     */
    public com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.Builder
        addBackendsBuilder(int index) {
      return getBackendsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Information for the loadbalancer backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend backends = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.Builder>
        getBackendsBuilderList() {
      return getBackendsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend,
            com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.Builder,
            com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackendOrBuilder>
        getBackendsFieldBuilder() {
      if (backendsBuilder_ == null) {
        backendsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend,
                com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.Builder,
                com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackendOrBuilder>(
                backends_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        backends_ = null;
      }
      return backendsBuilder_;
    }

    private int backendType_ = 0;
    /**
     *
     *
     * <pre>
     * Type of load balancer's backend configuration.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.BackendType backend_type = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for backendType.
     */
    @java.lang.Override
    public int getBackendTypeValue() {
      return backendType_;
    }
    /**
     *
     *
     * <pre>
     * Type of load balancer's backend configuration.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.BackendType backend_type = 4;
     * </code>
     *
     * @param value The enum numeric value on the wire for backendType to set.
     * @return This builder for chaining.
     */
    public Builder setBackendTypeValue(int value) {

      backendType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of load balancer's backend configuration.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.BackendType backend_type = 4;
     * </code>
     *
     * @return The backendType.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.BackendType
        getBackendType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.BackendType result =
          com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.BackendType.valueOf(
              backendType_);
      return result == null
          ? com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.BackendType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Type of load balancer's backend configuration.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.BackendType backend_type = 4;
     * </code>
     *
     * @param value The backendType to set.
     * @return This builder for chaining.
     */
    public Builder setBackendType(
        com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.BackendType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      backendType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of load balancer's backend configuration.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.BackendType backend_type = 4;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBackendType() {

      backendType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object backendUri_ = "";
    /**
     *
     *
     * <pre>
     * Backend configuration URI.
     * </pre>
     *
     * <code>string backend_uri = 5;</code>
     *
     * @return The backendUri.
     */
    public java.lang.String getBackendUri() {
      java.lang.Object ref = backendUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        backendUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Backend configuration URI.
     * </pre>
     *
     * <code>string backend_uri = 5;</code>
     *
     * @return The bytes for backendUri.
     */
    public com.google.protobuf.ByteString getBackendUriBytes() {
      java.lang.Object ref = backendUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        backendUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Backend configuration URI.
     * </pre>
     *
     * <code>string backend_uri = 5;</code>
     *
     * @param value The backendUri to set.
     * @return This builder for chaining.
     */
    public Builder setBackendUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      backendUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Backend configuration URI.
     * </pre>
     *
     * <code>string backend_uri = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBackendUri() {

      backendUri_ = getDefaultInstance().getBackendUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Backend configuration URI.
     * </pre>
     *
     * <code>string backend_uri = 5;</code>
     *
     * @param value The bytes for backendUri to set.
     * @return This builder for chaining.
     */
    public Builder setBackendUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      backendUri_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkmanagement.v1beta1.LoadBalancerInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkmanagement.v1beta1.LoadBalancerInfo)
  private static final com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo();
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LoadBalancerInfo> PARSER =
      new com.google.protobuf.AbstractParser<LoadBalancerInfo>() {
        @java.lang.Override
        public LoadBalancerInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LoadBalancerInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LoadBalancerInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
