/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkmanagement/v1beta1/trace.proto

package com.google.cloud.networkmanagement.v1beta1;

/**
 *
 *
 * <pre>
 * For display only. Metadata associated with a specific load balancer backend.
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkmanagement.v1beta1.LoadBalancerBackend}
 */
public final class LoadBalancerBackend extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkmanagement.v1beta1.LoadBalancerBackend)
    LoadBalancerBackendOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LoadBalancerBackend.newBuilder() to construct.
  private LoadBalancerBackend(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LoadBalancerBackend() {
    displayName_ = "";
    uri_ = "";
    healthCheckFirewallState_ = 0;
    healthCheckAllowingFirewallRules_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    healthCheckBlockingFirewallRules_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LoadBalancerBackend();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkmanagement.v1beta1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1beta1_LoadBalancerBackend_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkmanagement.v1beta1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1beta1_LoadBalancerBackend_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.class,
            com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * State of a health check firewall configuration:
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.HealthCheckFirewallState}
   */
  public enum HealthCheckFirewallState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * State is unspecified. Default state if not populated.
     * </pre>
     *
     * <code>HEALTH_CHECK_FIREWALL_STATE_UNSPECIFIED = 0;</code>
     */
    HEALTH_CHECK_FIREWALL_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * There are configured firewall rules to allow health check probes to the
     * backend.
     * </pre>
     *
     * <code>CONFIGURED = 1;</code>
     */
    CONFIGURED(1),
    /**
     *
     *
     * <pre>
     * There are firewall rules configured to allow partial health check ranges
     * or block all health check ranges.
     * If a health check probe is sent from denied IP ranges,
     * the health check to the backend will fail. Then, the backend will be
     * marked unhealthy and will not receive traffic sent to the load balancer.
     * </pre>
     *
     * <code>MISCONFIGURED = 2;</code>
     */
    MISCONFIGURED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * State is unspecified. Default state if not populated.
     * </pre>
     *
     * <code>HEALTH_CHECK_FIREWALL_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int HEALTH_CHECK_FIREWALL_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * There are configured firewall rules to allow health check probes to the
     * backend.
     * </pre>
     *
     * <code>CONFIGURED = 1;</code>
     */
    public static final int CONFIGURED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * There are firewall rules configured to allow partial health check ranges
     * or block all health check ranges.
     * If a health check probe is sent from denied IP ranges,
     * the health check to the backend will fail. Then, the backend will be
     * marked unhealthy and will not receive traffic sent to the load balancer.
     * </pre>
     *
     * <code>MISCONFIGURED = 2;</code>
     */
    public static final int MISCONFIGURED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static HealthCheckFirewallState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static HealthCheckFirewallState forNumber(int value) {
      switch (value) {
        case 0:
          return HEALTH_CHECK_FIREWALL_STATE_UNSPECIFIED;
        case 1:
          return CONFIGURED;
        case 2:
          return MISCONFIGURED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<HealthCheckFirewallState>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<HealthCheckFirewallState>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<HealthCheckFirewallState>() {
              public HealthCheckFirewallState findValueByNumber(int number) {
                return HealthCheckFirewallState.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final HealthCheckFirewallState[] VALUES = values();

    public static HealthCheckFirewallState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private HealthCheckFirewallState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.HealthCheckFirewallState)
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Name of a Compute Engine instance or network endpoint.
   * </pre>
   *
   * <code>string display_name = 1;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of a Compute Engine instance or network endpoint.
   * </pre>
   *
   * <code>string display_name = 1;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int URI_FIELD_NUMBER = 2;
  private volatile java.lang.Object uri_;
  /**
   *
   *
   * <pre>
   * URI of a Compute Engine instance or network endpoint.
   * </pre>
   *
   * <code>string uri = 2;</code>
   *
   * @return The uri.
   */
  @java.lang.Override
  public java.lang.String getUri() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of a Compute Engine instance or network endpoint.
   * </pre>
   *
   * <code>string uri = 2;</code>
   *
   * @return The bytes for uri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HEALTH_CHECK_FIREWALL_STATE_FIELD_NUMBER = 3;
  private int healthCheckFirewallState_;
  /**
   *
   *
   * <pre>
   * State of the health check firewall configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.HealthCheckFirewallState health_check_firewall_state = 3;
   * </code>
   *
   * @return The enum numeric value on the wire for healthCheckFirewallState.
   */
  @java.lang.Override
  public int getHealthCheckFirewallStateValue() {
    return healthCheckFirewallState_;
  }
  /**
   *
   *
   * <pre>
   * State of the health check firewall configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.HealthCheckFirewallState health_check_firewall_state = 3;
   * </code>
   *
   * @return The healthCheckFirewallState.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.HealthCheckFirewallState
      getHealthCheckFirewallState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.HealthCheckFirewallState result =
        com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.HealthCheckFirewallState
            .valueOf(healthCheckFirewallState_);
    return result == null
        ? com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.HealthCheckFirewallState
            .UNRECOGNIZED
        : result;
  }

  public static final int HEALTH_CHECK_ALLOWING_FIREWALL_RULES_FIELD_NUMBER = 4;
  private com.google.protobuf.LazyStringList healthCheckAllowingFirewallRules_;
  /**
   *
   *
   * <pre>
   * A list of firewall rule URIs allowing probes from health check IP ranges.
   * </pre>
   *
   * <code>repeated string health_check_allowing_firewall_rules = 4;</code>
   *
   * @return A list containing the healthCheckAllowingFirewallRules.
   */
  public com.google.protobuf.ProtocolStringList getHealthCheckAllowingFirewallRulesList() {
    return healthCheckAllowingFirewallRules_;
  }
  /**
   *
   *
   * <pre>
   * A list of firewall rule URIs allowing probes from health check IP ranges.
   * </pre>
   *
   * <code>repeated string health_check_allowing_firewall_rules = 4;</code>
   *
   * @return The count of healthCheckAllowingFirewallRules.
   */
  public int getHealthCheckAllowingFirewallRulesCount() {
    return healthCheckAllowingFirewallRules_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of firewall rule URIs allowing probes from health check IP ranges.
   * </pre>
   *
   * <code>repeated string health_check_allowing_firewall_rules = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The healthCheckAllowingFirewallRules at the given index.
   */
  public java.lang.String getHealthCheckAllowingFirewallRules(int index) {
    return healthCheckAllowingFirewallRules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of firewall rule URIs allowing probes from health check IP ranges.
   * </pre>
   *
   * <code>repeated string health_check_allowing_firewall_rules = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the healthCheckAllowingFirewallRules at the given index.
   */
  public com.google.protobuf.ByteString getHealthCheckAllowingFirewallRulesBytes(int index) {
    return healthCheckAllowingFirewallRules_.getByteString(index);
  }

  public static final int HEALTH_CHECK_BLOCKING_FIREWALL_RULES_FIELD_NUMBER = 5;
  private com.google.protobuf.LazyStringList healthCheckBlockingFirewallRules_;
  /**
   *
   *
   * <pre>
   * A list of firewall rule URIs blocking probes from health check IP ranges.
   * </pre>
   *
   * <code>repeated string health_check_blocking_firewall_rules = 5;</code>
   *
   * @return A list containing the healthCheckBlockingFirewallRules.
   */
  public com.google.protobuf.ProtocolStringList getHealthCheckBlockingFirewallRulesList() {
    return healthCheckBlockingFirewallRules_;
  }
  /**
   *
   *
   * <pre>
   * A list of firewall rule URIs blocking probes from health check IP ranges.
   * </pre>
   *
   * <code>repeated string health_check_blocking_firewall_rules = 5;</code>
   *
   * @return The count of healthCheckBlockingFirewallRules.
   */
  public int getHealthCheckBlockingFirewallRulesCount() {
    return healthCheckBlockingFirewallRules_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of firewall rule URIs blocking probes from health check IP ranges.
   * </pre>
   *
   * <code>repeated string health_check_blocking_firewall_rules = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The healthCheckBlockingFirewallRules at the given index.
   */
  public java.lang.String getHealthCheckBlockingFirewallRules(int index) {
    return healthCheckBlockingFirewallRules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of firewall rule URIs blocking probes from health check IP ranges.
   * </pre>
   *
   * <code>repeated string health_check_blocking_firewall_rules = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the healthCheckBlockingFirewallRules at the given index.
   */
  public com.google.protobuf.ByteString getHealthCheckBlockingFirewallRulesBytes(int index) {
    return healthCheckBlockingFirewallRules_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uri_);
    }
    if (healthCheckFirewallState_
        != com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.HealthCheckFirewallState
            .HEALTH_CHECK_FIREWALL_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, healthCheckFirewallState_);
    }
    for (int i = 0; i < healthCheckAllowingFirewallRules_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 4, healthCheckAllowingFirewallRules_.getRaw(i));
    }
    for (int i = 0; i < healthCheckBlockingFirewallRules_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 5, healthCheckBlockingFirewallRules_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uri_);
    }
    if (healthCheckFirewallState_
        != com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.HealthCheckFirewallState
            .HEALTH_CHECK_FIREWALL_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, healthCheckFirewallState_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < healthCheckAllowingFirewallRules_.size(); i++) {
        dataSize += computeStringSizeNoTag(healthCheckAllowingFirewallRules_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getHealthCheckAllowingFirewallRulesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < healthCheckBlockingFirewallRules_.size(); i++) {
        dataSize += computeStringSizeNoTag(healthCheckBlockingFirewallRules_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getHealthCheckBlockingFirewallRulesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend)) {
      return super.equals(obj);
    }
    com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend other =
        (com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend) obj;

    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getUri().equals(other.getUri())) return false;
    if (healthCheckFirewallState_ != other.healthCheckFirewallState_) return false;
    if (!getHealthCheckAllowingFirewallRulesList()
        .equals(other.getHealthCheckAllowingFirewallRulesList())) return false;
    if (!getHealthCheckBlockingFirewallRulesList()
        .equals(other.getHealthCheckBlockingFirewallRulesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + URI_FIELD_NUMBER;
    hash = (53 * hash) + getUri().hashCode();
    hash = (37 * hash) + HEALTH_CHECK_FIREWALL_STATE_FIELD_NUMBER;
    hash = (53 * hash) + healthCheckFirewallState_;
    if (getHealthCheckAllowingFirewallRulesCount() > 0) {
      hash = (37 * hash) + HEALTH_CHECK_ALLOWING_FIREWALL_RULES_FIELD_NUMBER;
      hash = (53 * hash) + getHealthCheckAllowingFirewallRulesList().hashCode();
    }
    if (getHealthCheckBlockingFirewallRulesCount() > 0) {
      hash = (37 * hash) + HEALTH_CHECK_BLOCKING_FIREWALL_RULES_FIELD_NUMBER;
      hash = (53 * hash) + getHealthCheckBlockingFirewallRulesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * For display only. Metadata associated with a specific load balancer backend.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkmanagement.v1beta1.LoadBalancerBackend}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkmanagement.v1beta1.LoadBalancerBackend)
      com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackendOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1beta1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1beta1_LoadBalancerBackend_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkmanagement.v1beta1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1beta1_LoadBalancerBackend_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.class,
              com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.Builder.class);
    }

    // Construct using com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      displayName_ = "";

      uri_ = "";

      healthCheckFirewallState_ = 0;

      healthCheckAllowingFirewallRules_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      healthCheckBlockingFirewallRules_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkmanagement.v1beta1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1beta1_LoadBalancerBackend_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend
        getDefaultInstanceForType() {
      return com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend build() {
      com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend buildPartial() {
      com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend result =
          new com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend(this);
      int from_bitField0_ = bitField0_;
      result.displayName_ = displayName_;
      result.uri_ = uri_;
      result.healthCheckFirewallState_ = healthCheckFirewallState_;
      if (((bitField0_ & 0x00000001) != 0)) {
        healthCheckAllowingFirewallRules_ = healthCheckAllowingFirewallRules_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.healthCheckAllowingFirewallRules_ = healthCheckAllowingFirewallRules_;
      if (((bitField0_ & 0x00000002) != 0)) {
        healthCheckBlockingFirewallRules_ = healthCheckBlockingFirewallRules_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.healthCheckBlockingFirewallRules_ = healthCheckBlockingFirewallRules_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend) {
        return mergeFrom((com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend other) {
      if (other
          == com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.getDefaultInstance())
        return this;
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (!other.getUri().isEmpty()) {
        uri_ = other.uri_;
        onChanged();
      }
      if (other.healthCheckFirewallState_ != 0) {
        setHealthCheckFirewallStateValue(other.getHealthCheckFirewallStateValue());
      }
      if (!other.healthCheckAllowingFirewallRules_.isEmpty()) {
        if (healthCheckAllowingFirewallRules_.isEmpty()) {
          healthCheckAllowingFirewallRules_ = other.healthCheckAllowingFirewallRules_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureHealthCheckAllowingFirewallRulesIsMutable();
          healthCheckAllowingFirewallRules_.addAll(other.healthCheckAllowingFirewallRules_);
        }
        onChanged();
      }
      if (!other.healthCheckBlockingFirewallRules_.isEmpty()) {
        if (healthCheckBlockingFirewallRules_.isEmpty()) {
          healthCheckBlockingFirewallRules_ = other.healthCheckBlockingFirewallRules_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureHealthCheckBlockingFirewallRulesIsMutable();
          healthCheckBlockingFirewallRules_.addAll(other.healthCheckBlockingFirewallRules_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                displayName_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                uri_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 24:
              {
                healthCheckFirewallState_ = input.readEnum();

                break;
              } // case 24
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureHealthCheckAllowingFirewallRulesIsMutable();
                healthCheckAllowingFirewallRules_.add(s);
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureHealthCheckBlockingFirewallRulesIsMutable();
                healthCheckBlockingFirewallRules_.add(s);
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Name of a Compute Engine instance or network endpoint.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of a Compute Engine instance or network endpoint.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of a Compute Engine instance or network endpoint.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of a Compute Engine instance or network endpoint.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of a Compute Engine instance or network endpoint.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine instance or network endpoint.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine instance or network endpoint.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine instance or network endpoint.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      uri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine instance or network endpoint.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {

      uri_ = getDefaultInstance().getUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine instance or network endpoint.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      uri_ = value;
      onChanged();
      return this;
    }

    private int healthCheckFirewallState_ = 0;
    /**
     *
     *
     * <pre>
     * State of the health check firewall configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.HealthCheckFirewallState health_check_firewall_state = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for healthCheckFirewallState.
     */
    @java.lang.Override
    public int getHealthCheckFirewallStateValue() {
      return healthCheckFirewallState_;
    }
    /**
     *
     *
     * <pre>
     * State of the health check firewall configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.HealthCheckFirewallState health_check_firewall_state = 3;
     * </code>
     *
     * @param value The enum numeric value on the wire for healthCheckFirewallState to set.
     * @return This builder for chaining.
     */
    public Builder setHealthCheckFirewallStateValue(int value) {

      healthCheckFirewallState_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * State of the health check firewall configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.HealthCheckFirewallState health_check_firewall_state = 3;
     * </code>
     *
     * @return The healthCheckFirewallState.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.HealthCheckFirewallState
        getHealthCheckFirewallState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.HealthCheckFirewallState
          result =
              com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend
                  .HealthCheckFirewallState.valueOf(healthCheckFirewallState_);
      return result == null
          ? com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.HealthCheckFirewallState
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * State of the health check firewall configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.HealthCheckFirewallState health_check_firewall_state = 3;
     * </code>
     *
     * @param value The healthCheckFirewallState to set.
     * @return This builder for chaining.
     */
    public Builder setHealthCheckFirewallState(
        com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.HealthCheckFirewallState
            value) {
      if (value == null) {
        throw new NullPointerException();
      }

      healthCheckFirewallState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * State of the health check firewall configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.LoadBalancerBackend.HealthCheckFirewallState health_check_firewall_state = 3;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHealthCheckFirewallState() {

      healthCheckFirewallState_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList healthCheckAllowingFirewallRules_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureHealthCheckAllowingFirewallRulesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        healthCheckAllowingFirewallRules_ =
            new com.google.protobuf.LazyStringArrayList(healthCheckAllowingFirewallRules_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of firewall rule URIs allowing probes from health check IP ranges.
     * </pre>
     *
     * <code>repeated string health_check_allowing_firewall_rules = 4;</code>
     *
     * @return A list containing the healthCheckAllowingFirewallRules.
     */
    public com.google.protobuf.ProtocolStringList getHealthCheckAllowingFirewallRulesList() {
      return healthCheckAllowingFirewallRules_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * A list of firewall rule URIs allowing probes from health check IP ranges.
     * </pre>
     *
     * <code>repeated string health_check_allowing_firewall_rules = 4;</code>
     *
     * @return The count of healthCheckAllowingFirewallRules.
     */
    public int getHealthCheckAllowingFirewallRulesCount() {
      return healthCheckAllowingFirewallRules_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of firewall rule URIs allowing probes from health check IP ranges.
     * </pre>
     *
     * <code>repeated string health_check_allowing_firewall_rules = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The healthCheckAllowingFirewallRules at the given index.
     */
    public java.lang.String getHealthCheckAllowingFirewallRules(int index) {
      return healthCheckAllowingFirewallRules_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of firewall rule URIs allowing probes from health check IP ranges.
     * </pre>
     *
     * <code>repeated string health_check_allowing_firewall_rules = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the healthCheckAllowingFirewallRules at the given index.
     */
    public com.google.protobuf.ByteString getHealthCheckAllowingFirewallRulesBytes(int index) {
      return healthCheckAllowingFirewallRules_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of firewall rule URIs allowing probes from health check IP ranges.
     * </pre>
     *
     * <code>repeated string health_check_allowing_firewall_rules = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The healthCheckAllowingFirewallRules to set.
     * @return This builder for chaining.
     */
    public Builder setHealthCheckAllowingFirewallRules(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureHealthCheckAllowingFirewallRulesIsMutable();
      healthCheckAllowingFirewallRules_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of firewall rule URIs allowing probes from health check IP ranges.
     * </pre>
     *
     * <code>repeated string health_check_allowing_firewall_rules = 4;</code>
     *
     * @param value The healthCheckAllowingFirewallRules to add.
     * @return This builder for chaining.
     */
    public Builder addHealthCheckAllowingFirewallRules(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureHealthCheckAllowingFirewallRulesIsMutable();
      healthCheckAllowingFirewallRules_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of firewall rule URIs allowing probes from health check IP ranges.
     * </pre>
     *
     * <code>repeated string health_check_allowing_firewall_rules = 4;</code>
     *
     * @param values The healthCheckAllowingFirewallRules to add.
     * @return This builder for chaining.
     */
    public Builder addAllHealthCheckAllowingFirewallRules(
        java.lang.Iterable<java.lang.String> values) {
      ensureHealthCheckAllowingFirewallRulesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, healthCheckAllowingFirewallRules_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of firewall rule URIs allowing probes from health check IP ranges.
     * </pre>
     *
     * <code>repeated string health_check_allowing_firewall_rules = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHealthCheckAllowingFirewallRules() {
      healthCheckAllowingFirewallRules_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of firewall rule URIs allowing probes from health check IP ranges.
     * </pre>
     *
     * <code>repeated string health_check_allowing_firewall_rules = 4;</code>
     *
     * @param value The bytes of the healthCheckAllowingFirewallRules to add.
     * @return This builder for chaining.
     */
    public Builder addHealthCheckAllowingFirewallRulesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureHealthCheckAllowingFirewallRulesIsMutable();
      healthCheckAllowingFirewallRules_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList healthCheckBlockingFirewallRules_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureHealthCheckBlockingFirewallRulesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        healthCheckBlockingFirewallRules_ =
            new com.google.protobuf.LazyStringArrayList(healthCheckBlockingFirewallRules_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of firewall rule URIs blocking probes from health check IP ranges.
     * </pre>
     *
     * <code>repeated string health_check_blocking_firewall_rules = 5;</code>
     *
     * @return A list containing the healthCheckBlockingFirewallRules.
     */
    public com.google.protobuf.ProtocolStringList getHealthCheckBlockingFirewallRulesList() {
      return healthCheckBlockingFirewallRules_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * A list of firewall rule URIs blocking probes from health check IP ranges.
     * </pre>
     *
     * <code>repeated string health_check_blocking_firewall_rules = 5;</code>
     *
     * @return The count of healthCheckBlockingFirewallRules.
     */
    public int getHealthCheckBlockingFirewallRulesCount() {
      return healthCheckBlockingFirewallRules_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of firewall rule URIs blocking probes from health check IP ranges.
     * </pre>
     *
     * <code>repeated string health_check_blocking_firewall_rules = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The healthCheckBlockingFirewallRules at the given index.
     */
    public java.lang.String getHealthCheckBlockingFirewallRules(int index) {
      return healthCheckBlockingFirewallRules_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of firewall rule URIs blocking probes from health check IP ranges.
     * </pre>
     *
     * <code>repeated string health_check_blocking_firewall_rules = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the healthCheckBlockingFirewallRules at the given index.
     */
    public com.google.protobuf.ByteString getHealthCheckBlockingFirewallRulesBytes(int index) {
      return healthCheckBlockingFirewallRules_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of firewall rule URIs blocking probes from health check IP ranges.
     * </pre>
     *
     * <code>repeated string health_check_blocking_firewall_rules = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The healthCheckBlockingFirewallRules to set.
     * @return This builder for chaining.
     */
    public Builder setHealthCheckBlockingFirewallRules(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureHealthCheckBlockingFirewallRulesIsMutable();
      healthCheckBlockingFirewallRules_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of firewall rule URIs blocking probes from health check IP ranges.
     * </pre>
     *
     * <code>repeated string health_check_blocking_firewall_rules = 5;</code>
     *
     * @param value The healthCheckBlockingFirewallRules to add.
     * @return This builder for chaining.
     */
    public Builder addHealthCheckBlockingFirewallRules(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureHealthCheckBlockingFirewallRulesIsMutable();
      healthCheckBlockingFirewallRules_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of firewall rule URIs blocking probes from health check IP ranges.
     * </pre>
     *
     * <code>repeated string health_check_blocking_firewall_rules = 5;</code>
     *
     * @param values The healthCheckBlockingFirewallRules to add.
     * @return This builder for chaining.
     */
    public Builder addAllHealthCheckBlockingFirewallRules(
        java.lang.Iterable<java.lang.String> values) {
      ensureHealthCheckBlockingFirewallRulesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, healthCheckBlockingFirewallRules_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of firewall rule URIs blocking probes from health check IP ranges.
     * </pre>
     *
     * <code>repeated string health_check_blocking_firewall_rules = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHealthCheckBlockingFirewallRules() {
      healthCheckBlockingFirewallRules_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of firewall rule URIs blocking probes from health check IP ranges.
     * </pre>
     *
     * <code>repeated string health_check_blocking_firewall_rules = 5;</code>
     *
     * @param value The bytes of the healthCheckBlockingFirewallRules to add.
     * @return This builder for chaining.
     */
    public Builder addHealthCheckBlockingFirewallRulesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureHealthCheckBlockingFirewallRulesIsMutable();
      healthCheckBlockingFirewallRules_.add(value);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkmanagement.v1beta1.LoadBalancerBackend)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkmanagement.v1beta1.LoadBalancerBackend)
  private static final com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend();
  }

  public static com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LoadBalancerBackend> PARSER =
      new com.google.protobuf.AbstractParser<LoadBalancerBackend>() {
        @java.lang.Override
        public LoadBalancerBackend parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LoadBalancerBackend> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LoadBalancerBackend> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.LoadBalancerBackend
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
