/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkmanagement/v1beta1/trace.proto

package com.google.cloud.networkmanagement.v1beta1;

/**
 *
 *
 * <pre>
 * For display only. Metadata associated with a Compute Engine forwarding rule.
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo}
 */
public final class ForwardingRuleInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo)
    ForwardingRuleInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ForwardingRuleInfo.newBuilder() to construct.
  private ForwardingRuleInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ForwardingRuleInfo() {
    displayName_ = "";
    uri_ = "";
    matchedProtocol_ = "";
    matchedPortRange_ = "";
    vip_ = "";
    target_ = "";
    networkUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ForwardingRuleInfo();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkmanagement.v1beta1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1beta1_ForwardingRuleInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkmanagement.v1beta1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1beta1_ForwardingRuleInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo.class,
            com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo.Builder.class);
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Name of a Compute Engine forwarding rule.
   * </pre>
   *
   * <code>string display_name = 1;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of a Compute Engine forwarding rule.
   * </pre>
   *
   * <code>string display_name = 1;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int URI_FIELD_NUMBER = 2;
  private volatile java.lang.Object uri_;
  /**
   *
   *
   * <pre>
   * URI of a Compute Engine forwarding rule.
   * </pre>
   *
   * <code>string uri = 2;</code>
   *
   * @return The uri.
   */
  @java.lang.Override
  public java.lang.String getUri() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of a Compute Engine forwarding rule.
   * </pre>
   *
   * <code>string uri = 2;</code>
   *
   * @return The bytes for uri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MATCHED_PROTOCOL_FIELD_NUMBER = 3;
  private volatile java.lang.Object matchedProtocol_;
  /**
   *
   *
   * <pre>
   * Protocol defined in the forwarding rule that matches the test.
   * </pre>
   *
   * <code>string matched_protocol = 3;</code>
   *
   * @return The matchedProtocol.
   */
  @java.lang.Override
  public java.lang.String getMatchedProtocol() {
    java.lang.Object ref = matchedProtocol_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      matchedProtocol_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Protocol defined in the forwarding rule that matches the test.
   * </pre>
   *
   * <code>string matched_protocol = 3;</code>
   *
   * @return The bytes for matchedProtocol.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMatchedProtocolBytes() {
    java.lang.Object ref = matchedProtocol_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      matchedProtocol_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MATCHED_PORT_RANGE_FIELD_NUMBER = 6;
  private volatile java.lang.Object matchedPortRange_;
  /**
   *
   *
   * <pre>
   * Port range defined in the forwarding rule that matches the test.
   * </pre>
   *
   * <code>string matched_port_range = 6;</code>
   *
   * @return The matchedPortRange.
   */
  @java.lang.Override
  public java.lang.String getMatchedPortRange() {
    java.lang.Object ref = matchedPortRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      matchedPortRange_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Port range defined in the forwarding rule that matches the test.
   * </pre>
   *
   * <code>string matched_port_range = 6;</code>
   *
   * @return The bytes for matchedPortRange.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMatchedPortRangeBytes() {
    java.lang.Object ref = matchedPortRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      matchedPortRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VIP_FIELD_NUMBER = 4;
  private volatile java.lang.Object vip_;
  /**
   *
   *
   * <pre>
   * VIP of the forwarding rule.
   * </pre>
   *
   * <code>string vip = 4;</code>
   *
   * @return The vip.
   */
  @java.lang.Override
  public java.lang.String getVip() {
    java.lang.Object ref = vip_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      vip_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * VIP of the forwarding rule.
   * </pre>
   *
   * <code>string vip = 4;</code>
   *
   * @return The bytes for vip.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVipBytes() {
    java.lang.Object ref = vip_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      vip_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_FIELD_NUMBER = 5;
  private volatile java.lang.Object target_;
  /**
   *
   *
   * <pre>
   * Target type of the forwarding rule.
   * </pre>
   *
   * <code>string target = 5;</code>
   *
   * @return The target.
   */
  @java.lang.Override
  public java.lang.String getTarget() {
    java.lang.Object ref = target_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      target_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Target type of the forwarding rule.
   * </pre>
   *
   * <code>string target = 5;</code>
   *
   * @return The bytes for target.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetBytes() {
    java.lang.Object ref = target_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      target_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_URI_FIELD_NUMBER = 7;
  private volatile java.lang.Object networkUri_;
  /**
   *
   *
   * <pre>
   * Network URI. Only valid for Internal Load Balancer.
   * </pre>
   *
   * <code>string network_uri = 7;</code>
   *
   * @return The networkUri.
   */
  @java.lang.Override
  public java.lang.String getNetworkUri() {
    java.lang.Object ref = networkUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      networkUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Network URI. Only valid for Internal Load Balancer.
   * </pre>
   *
   * <code>string network_uri = 7;</code>
   *
   * @return The bytes for networkUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkUriBytes() {
    java.lang.Object ref = networkUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      networkUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(matchedProtocol_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, matchedProtocol_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vip_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, vip_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(target_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, target_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(matchedPortRange_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, matchedPortRange_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, networkUri_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(matchedProtocol_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, matchedProtocol_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vip_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, vip_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(target_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, target_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(matchedPortRange_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, matchedPortRange_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, networkUri_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo other =
        (com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo) obj;

    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getUri().equals(other.getUri())) return false;
    if (!getMatchedProtocol().equals(other.getMatchedProtocol())) return false;
    if (!getMatchedPortRange().equals(other.getMatchedPortRange())) return false;
    if (!getVip().equals(other.getVip())) return false;
    if (!getTarget().equals(other.getTarget())) return false;
    if (!getNetworkUri().equals(other.getNetworkUri())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + URI_FIELD_NUMBER;
    hash = (53 * hash) + getUri().hashCode();
    hash = (37 * hash) + MATCHED_PROTOCOL_FIELD_NUMBER;
    hash = (53 * hash) + getMatchedProtocol().hashCode();
    hash = (37 * hash) + MATCHED_PORT_RANGE_FIELD_NUMBER;
    hash = (53 * hash) + getMatchedPortRange().hashCode();
    hash = (37 * hash) + VIP_FIELD_NUMBER;
    hash = (53 * hash) + getVip().hashCode();
    hash = (37 * hash) + TARGET_FIELD_NUMBER;
    hash = (53 * hash) + getTarget().hashCode();
    hash = (37 * hash) + NETWORK_URI_FIELD_NUMBER;
    hash = (53 * hash) + getNetworkUri().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * For display only. Metadata associated with a Compute Engine forwarding rule.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo)
      com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1beta1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1beta1_ForwardingRuleInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkmanagement.v1beta1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1beta1_ForwardingRuleInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo.class,
              com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo.Builder.class);
    }

    // Construct using com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      displayName_ = "";

      uri_ = "";

      matchedProtocol_ = "";

      matchedPortRange_ = "";

      vip_ = "";

      target_ = "";

      networkUri_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkmanagement.v1beta1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1beta1_ForwardingRuleInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo
        getDefaultInstanceForType() {
      return com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo build() {
      com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo buildPartial() {
      com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo result =
          new com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo(this);
      result.displayName_ = displayName_;
      result.uri_ = uri_;
      result.matchedProtocol_ = matchedProtocol_;
      result.matchedPortRange_ = matchedPortRange_;
      result.vip_ = vip_;
      result.target_ = target_;
      result.networkUri_ = networkUri_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo) {
        return mergeFrom((com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo other) {
      if (other
          == com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo.getDefaultInstance())
        return this;
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (!other.getUri().isEmpty()) {
        uri_ = other.uri_;
        onChanged();
      }
      if (!other.getMatchedProtocol().isEmpty()) {
        matchedProtocol_ = other.matchedProtocol_;
        onChanged();
      }
      if (!other.getMatchedPortRange().isEmpty()) {
        matchedPortRange_ = other.matchedPortRange_;
        onChanged();
      }
      if (!other.getVip().isEmpty()) {
        vip_ = other.vip_;
        onChanged();
      }
      if (!other.getTarget().isEmpty()) {
        target_ = other.target_;
        onChanged();
      }
      if (!other.getNetworkUri().isEmpty()) {
        networkUri_ = other.networkUri_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                displayName_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                uri_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                matchedProtocol_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 34:
              {
                vip_ = input.readStringRequireUtf8();

                break;
              } // case 34
            case 42:
              {
                target_ = input.readStringRequireUtf8();

                break;
              } // case 42
            case 50:
              {
                matchedPortRange_ = input.readStringRequireUtf8();

                break;
              } // case 50
            case 58:
              {
                networkUri_ = input.readStringRequireUtf8();

                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Name of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      uri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {

      uri_ = getDefaultInstance().getUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      uri_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object matchedProtocol_ = "";
    /**
     *
     *
     * <pre>
     * Protocol defined in the forwarding rule that matches the test.
     * </pre>
     *
     * <code>string matched_protocol = 3;</code>
     *
     * @return The matchedProtocol.
     */
    public java.lang.String getMatchedProtocol() {
      java.lang.Object ref = matchedProtocol_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        matchedProtocol_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Protocol defined in the forwarding rule that matches the test.
     * </pre>
     *
     * <code>string matched_protocol = 3;</code>
     *
     * @return The bytes for matchedProtocol.
     */
    public com.google.protobuf.ByteString getMatchedProtocolBytes() {
      java.lang.Object ref = matchedProtocol_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        matchedProtocol_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Protocol defined in the forwarding rule that matches the test.
     * </pre>
     *
     * <code>string matched_protocol = 3;</code>
     *
     * @param value The matchedProtocol to set.
     * @return This builder for chaining.
     */
    public Builder setMatchedProtocol(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      matchedProtocol_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Protocol defined in the forwarding rule that matches the test.
     * </pre>
     *
     * <code>string matched_protocol = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMatchedProtocol() {

      matchedProtocol_ = getDefaultInstance().getMatchedProtocol();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Protocol defined in the forwarding rule that matches the test.
     * </pre>
     *
     * <code>string matched_protocol = 3;</code>
     *
     * @param value The bytes for matchedProtocol to set.
     * @return This builder for chaining.
     */
    public Builder setMatchedProtocolBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      matchedProtocol_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object matchedPortRange_ = "";
    /**
     *
     *
     * <pre>
     * Port range defined in the forwarding rule that matches the test.
     * </pre>
     *
     * <code>string matched_port_range = 6;</code>
     *
     * @return The matchedPortRange.
     */
    public java.lang.String getMatchedPortRange() {
      java.lang.Object ref = matchedPortRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        matchedPortRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Port range defined in the forwarding rule that matches the test.
     * </pre>
     *
     * <code>string matched_port_range = 6;</code>
     *
     * @return The bytes for matchedPortRange.
     */
    public com.google.protobuf.ByteString getMatchedPortRangeBytes() {
      java.lang.Object ref = matchedPortRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        matchedPortRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Port range defined in the forwarding rule that matches the test.
     * </pre>
     *
     * <code>string matched_port_range = 6;</code>
     *
     * @param value The matchedPortRange to set.
     * @return This builder for chaining.
     */
    public Builder setMatchedPortRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      matchedPortRange_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Port range defined in the forwarding rule that matches the test.
     * </pre>
     *
     * <code>string matched_port_range = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMatchedPortRange() {

      matchedPortRange_ = getDefaultInstance().getMatchedPortRange();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Port range defined in the forwarding rule that matches the test.
     * </pre>
     *
     * <code>string matched_port_range = 6;</code>
     *
     * @param value The bytes for matchedPortRange to set.
     * @return This builder for chaining.
     */
    public Builder setMatchedPortRangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      matchedPortRange_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object vip_ = "";
    /**
     *
     *
     * <pre>
     * VIP of the forwarding rule.
     * </pre>
     *
     * <code>string vip = 4;</code>
     *
     * @return The vip.
     */
    public java.lang.String getVip() {
      java.lang.Object ref = vip_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        vip_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * VIP of the forwarding rule.
     * </pre>
     *
     * <code>string vip = 4;</code>
     *
     * @return The bytes for vip.
     */
    public com.google.protobuf.ByteString getVipBytes() {
      java.lang.Object ref = vip_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        vip_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * VIP of the forwarding rule.
     * </pre>
     *
     * <code>string vip = 4;</code>
     *
     * @param value The vip to set.
     * @return This builder for chaining.
     */
    public Builder setVip(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      vip_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * VIP of the forwarding rule.
     * </pre>
     *
     * <code>string vip = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVip() {

      vip_ = getDefaultInstance().getVip();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * VIP of the forwarding rule.
     * </pre>
     *
     * <code>string vip = 4;</code>
     *
     * @param value The bytes for vip to set.
     * @return This builder for chaining.
     */
    public Builder setVipBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      vip_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object target_ = "";
    /**
     *
     *
     * <pre>
     * Target type of the forwarding rule.
     * </pre>
     *
     * <code>string target = 5;</code>
     *
     * @return The target.
     */
    public java.lang.String getTarget() {
      java.lang.Object ref = target_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        target_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Target type of the forwarding rule.
     * </pre>
     *
     * <code>string target = 5;</code>
     *
     * @return The bytes for target.
     */
    public com.google.protobuf.ByteString getTargetBytes() {
      java.lang.Object ref = target_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        target_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Target type of the forwarding rule.
     * </pre>
     *
     * <code>string target = 5;</code>
     *
     * @param value The target to set.
     * @return This builder for chaining.
     */
    public Builder setTarget(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      target_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target type of the forwarding rule.
     * </pre>
     *
     * <code>string target = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTarget() {

      target_ = getDefaultInstance().getTarget();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target type of the forwarding rule.
     * </pre>
     *
     * <code>string target = 5;</code>
     *
     * @param value The bytes for target to set.
     * @return This builder for chaining.
     */
    public Builder setTargetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      target_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object networkUri_ = "";
    /**
     *
     *
     * <pre>
     * Network URI. Only valid for Internal Load Balancer.
     * </pre>
     *
     * <code>string network_uri = 7;</code>
     *
     * @return The networkUri.
     */
    public java.lang.String getNetworkUri() {
      java.lang.Object ref = networkUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        networkUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Network URI. Only valid for Internal Load Balancer.
     * </pre>
     *
     * <code>string network_uri = 7;</code>
     *
     * @return The bytes for networkUri.
     */
    public com.google.protobuf.ByteString getNetworkUriBytes() {
      java.lang.Object ref = networkUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        networkUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Network URI. Only valid for Internal Load Balancer.
     * </pre>
     *
     * <code>string network_uri = 7;</code>
     *
     * @param value The networkUri to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      networkUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network URI. Only valid for Internal Load Balancer.
     * </pre>
     *
     * <code>string network_uri = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetworkUri() {

      networkUri_ = getDefaultInstance().getNetworkUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network URI. Only valid for Internal Load Balancer.
     * </pre>
     *
     * <code>string network_uri = 7;</code>
     *
     * @param value The bytes for networkUri to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      networkUri_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo)
  private static final com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo();
  }

  public static com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ForwardingRuleInfo> PARSER =
      new com.google.protobuf.AbstractParser<ForwardingRuleInfo>() {
        @java.lang.Override
        public ForwardingRuleInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ForwardingRuleInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ForwardingRuleInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
