/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkmanagement/v1beta1/connectivity_test.proto

package com.google.cloud.networkmanagement.v1beta1;

/**
 *
 *
 * <pre>
 * Source or destination of the Connectivity Test.
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkmanagement.v1beta1.Endpoint}
 */
public final class Endpoint extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkmanagement.v1beta1.Endpoint)
    EndpointOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Endpoint.newBuilder() to construct.
  private Endpoint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Endpoint() {
    ipAddress_ = "";
    instance_ = "";
    gkeMasterCluster_ = "";
    cloudSqlInstance_ = "";
    network_ = "";
    networkType_ = 0;
    projectId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Endpoint();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
        .internal_static_google_cloud_networkmanagement_v1beta1_Endpoint_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
        .internal_static_google_cloud_networkmanagement_v1beta1_Endpoint_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkmanagement.v1beta1.Endpoint.class,
            com.google.cloud.networkmanagement.v1beta1.Endpoint.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type definition of an endpoint's network. Use one of the
   * following choices:
   * </pre>
   *
   * Protobuf enum {@code google.cloud.networkmanagement.v1beta1.Endpoint.NetworkType}
   */
  public enum NetworkType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default type if unspecified.
     * </pre>
     *
     * <code>NETWORK_TYPE_UNSPECIFIED = 0;</code>
     */
    NETWORK_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * A network hosted within Google Cloud Platform.
     * To receive more detailed output, specify the URI for the source or
     * destination network.
     * </pre>
     *
     * <code>GCP_NETWORK = 1;</code>
     */
    GCP_NETWORK(1),
    /**
     *
     *
     * <pre>
     * A network hosted outside of Google Cloud Platform.
     * This can be an on-premises network, or a network hosted by another cloud
     * provider.
     * </pre>
     *
     * <code>NON_GCP_NETWORK = 2;</code>
     */
    NON_GCP_NETWORK(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default type if unspecified.
     * </pre>
     *
     * <code>NETWORK_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int NETWORK_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * A network hosted within Google Cloud Platform.
     * To receive more detailed output, specify the URI for the source or
     * destination network.
     * </pre>
     *
     * <code>GCP_NETWORK = 1;</code>
     */
    public static final int GCP_NETWORK_VALUE = 1;
    /**
     *
     *
     * <pre>
     * A network hosted outside of Google Cloud Platform.
     * This can be an on-premises network, or a network hosted by another cloud
     * provider.
     * </pre>
     *
     * <code>NON_GCP_NETWORK = 2;</code>
     */
    public static final int NON_GCP_NETWORK_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static NetworkType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static NetworkType forNumber(int value) {
      switch (value) {
        case 0:
          return NETWORK_TYPE_UNSPECIFIED;
        case 1:
          return GCP_NETWORK;
        case 2:
          return NON_GCP_NETWORK;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<NetworkType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<NetworkType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<NetworkType>() {
          public NetworkType findValueByNumber(int number) {
            return NetworkType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1beta1.Endpoint.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final NetworkType[] VALUES = values();

    public static NetworkType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private NetworkType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.networkmanagement.v1beta1.Endpoint.NetworkType)
  }

  public interface CloudFunctionEndpointOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A [Cloud function](https://cloud.google.com/functions) name.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The uri.
     */
    java.lang.String getUri();
    /**
     *
     *
     * <pre>
     * A [Cloud function](https://cloud.google.com/functions) name.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The bytes for uri.
     */
    com.google.protobuf.ByteString getUriBytes();
  }
  /**
   *
   *
   * <pre>
   * Wrapper for cloud function attributes.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint}
   */
  public static final class CloudFunctionEndpoint extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint)
      CloudFunctionEndpointOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CloudFunctionEndpoint.newBuilder() to construct.
    private CloudFunctionEndpoint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CloudFunctionEndpoint() {
      uri_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CloudFunctionEndpoint();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
          .internal_static_google_cloud_networkmanagement_v1beta1_Endpoint_CloudFunctionEndpoint_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
          .internal_static_google_cloud_networkmanagement_v1beta1_Endpoint_CloudFunctionEndpoint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint.class,
              com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint.Builder
                  .class);
    }

    public static final int URI_FIELD_NUMBER = 1;
    private volatile java.lang.Object uri_;
    /**
     *
     *
     * <pre>
     * A [Cloud function](https://cloud.google.com/functions) name.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The uri.
     */
    @java.lang.Override
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A [Cloud function](https://cloud.google.com/functions) name.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The bytes for uri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uri_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uri_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint)) {
        return super.equals(obj);
      }
      com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint other =
          (com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint) obj;

      if (!getUri().equals(other.getUri())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + URI_FIELD_NUMBER;
      hash = (53 * hash) + getUri().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Wrapper for cloud function attributes.
     * </pre>
     *
     * Protobuf type {@code google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint)
        com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpointOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
            .internal_static_google_cloud_networkmanagement_v1beta1_Endpoint_CloudFunctionEndpoint_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
            .internal_static_google_cloud_networkmanagement_v1beta1_Endpoint_CloudFunctionEndpoint_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint.class,
                com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        uri_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
            .internal_static_google_cloud_networkmanagement_v1beta1_Endpoint_CloudFunctionEndpoint_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
          getDefaultInstanceForType() {
        return com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint build() {
        com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
          buildPartial() {
        com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint result =
            new com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint(this);
        result.uri_ = uri_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint) {
          return mergeFrom(
              (com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint other) {
        if (other
            == com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
                .getDefaultInstance()) return this;
        if (!other.getUri().isEmpty()) {
          uri_ = other.uri_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  uri_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object uri_ = "";
      /**
       *
       *
       * <pre>
       * A [Cloud function](https://cloud.google.com/functions) name.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return The uri.
       */
      public java.lang.String getUri() {
        java.lang.Object ref = uri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A [Cloud function](https://cloud.google.com/functions) name.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return The bytes for uri.
       */
      public com.google.protobuf.ByteString getUriBytes() {
        java.lang.Object ref = uri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          uri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A [Cloud function](https://cloud.google.com/functions) name.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @param value The uri to set.
       * @return This builder for chaining.
       */
      public Builder setUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        uri_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A [Cloud function](https://cloud.google.com/functions) name.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUri() {

        uri_ = getDefaultInstance().getUri();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A [Cloud function](https://cloud.google.com/functions) name.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @param value The bytes for uri to set.
       * @return This builder for chaining.
       */
      public Builder setUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        uri_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint)
    private static final com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint();
    }

    public static com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CloudFunctionEndpoint> PARSER =
        new com.google.protobuf.AbstractParser<CloudFunctionEndpoint>() {
          @java.lang.Override
          public CloudFunctionEndpoint parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CloudFunctionEndpoint> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CloudFunctionEndpoint> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int IP_ADDRESS_FIELD_NUMBER = 1;
  private volatile java.lang.Object ipAddress_;
  /**
   *
   *
   * <pre>
   * The IP address of the endpoint, which can be an external or internal IP.
   * An IPv6 address is only allowed when the test's destination is a
   * [global load balancer
   * VIP](https://cloud.google.com/load-balancing/docs/load-balancing-overview).
   * </pre>
   *
   * <code>string ip_address = 1;</code>
   *
   * @return The ipAddress.
   */
  @java.lang.Override
  public java.lang.String getIpAddress() {
    java.lang.Object ref = ipAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ipAddress_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The IP address of the endpoint, which can be an external or internal IP.
   * An IPv6 address is only allowed when the test's destination is a
   * [global load balancer
   * VIP](https://cloud.google.com/load-balancing/docs/load-balancing-overview).
   * </pre>
   *
   * <code>string ip_address = 1;</code>
   *
   * @return The bytes for ipAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIpAddressBytes() {
    java.lang.Object ref = ipAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ipAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PORT_FIELD_NUMBER = 2;
  private int port_;
  /**
   *
   *
   * <pre>
   * The IP protocol port of the endpoint.
   * Only applicable when protocol is TCP or UDP.
   * </pre>
   *
   * <code>int32 port = 2;</code>
   *
   * @return The port.
   */
  @java.lang.Override
  public int getPort() {
    return port_;
  }

  public static final int INSTANCE_FIELD_NUMBER = 3;
  private volatile java.lang.Object instance_;
  /**
   *
   *
   * <pre>
   * A Compute Engine instance URI.
   * </pre>
   *
   * <code>string instance = 3;</code>
   *
   * @return The instance.
   */
  @java.lang.Override
  public java.lang.String getInstance() {
    java.lang.Object ref = instance_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instance_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A Compute Engine instance URI.
   * </pre>
   *
   * <code>string instance = 3;</code>
   *
   * @return The bytes for instance.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceBytes() {
    java.lang.Object ref = instance_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instance_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GKE_MASTER_CLUSTER_FIELD_NUMBER = 7;
  private volatile java.lang.Object gkeMasterCluster_;
  /**
   *
   *
   * <pre>
   * A cluster URI for [Google Kubernetes Engine
   * master](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture).
   * </pre>
   *
   * <code>string gke_master_cluster = 7;</code>
   *
   * @return The gkeMasterCluster.
   */
  @java.lang.Override
  public java.lang.String getGkeMasterCluster() {
    java.lang.Object ref = gkeMasterCluster_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      gkeMasterCluster_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A cluster URI for [Google Kubernetes Engine
   * master](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture).
   * </pre>
   *
   * <code>string gke_master_cluster = 7;</code>
   *
   * @return The bytes for gkeMasterCluster.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGkeMasterClusterBytes() {
    java.lang.Object ref = gkeMasterCluster_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      gkeMasterCluster_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLOUD_SQL_INSTANCE_FIELD_NUMBER = 8;
  private volatile java.lang.Object cloudSqlInstance_;
  /**
   *
   *
   * <pre>
   * A [Cloud SQL](https://cloud.google.com/sql) instance URI.
   * </pre>
   *
   * <code>string cloud_sql_instance = 8;</code>
   *
   * @return The cloudSqlInstance.
   */
  @java.lang.Override
  public java.lang.String getCloudSqlInstance() {
    java.lang.Object ref = cloudSqlInstance_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cloudSqlInstance_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A [Cloud SQL](https://cloud.google.com/sql) instance URI.
   * </pre>
   *
   * <code>string cloud_sql_instance = 8;</code>
   *
   * @return The bytes for cloudSqlInstance.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCloudSqlInstanceBytes() {
    java.lang.Object ref = cloudSqlInstance_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cloudSqlInstance_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLOUD_FUNCTION_FIELD_NUMBER = 10;
  private com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint cloudFunction_;
  /**
   *
   *
   * <pre>
   * A [Cloud function](https://cloud.google.com/functions).
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint cloud_function = 10;
   * </code>
   *
   * @return Whether the cloudFunction field is set.
   */
  @java.lang.Override
  public boolean hasCloudFunction() {
    return cloudFunction_ != null;
  }
  /**
   *
   *
   * <pre>
   * A [Cloud function](https://cloud.google.com/functions).
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint cloud_function = 10;
   * </code>
   *
   * @return The cloudFunction.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
      getCloudFunction() {
    return cloudFunction_ == null
        ? com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
            .getDefaultInstance()
        : cloudFunction_;
  }
  /**
   *
   *
   * <pre>
   * A [Cloud function](https://cloud.google.com/functions).
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint cloud_function = 10;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpointOrBuilder
      getCloudFunctionOrBuilder() {
    return getCloudFunction();
  }

  public static final int NETWORK_FIELD_NUMBER = 4;
  private volatile java.lang.Object network_;
  /**
   *
   *
   * <pre>
   * A Compute Engine network URI.
   * </pre>
   *
   * <code>string network = 4;</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A Compute Engine network URI.
   * </pre>
   *
   * <code>string network = 4;</code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_TYPE_FIELD_NUMBER = 5;
  private int networkType_;
  /**
   *
   *
   * <pre>
   * Type of the network where the endpoint is located.
   * Applicable only to source endpoint, as destination network type can be
   * inferred from the source.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.Endpoint.NetworkType network_type = 5;</code>
   *
   * @return The enum numeric value on the wire for networkType.
   */
  @java.lang.Override
  public int getNetworkTypeValue() {
    return networkType_;
  }
  /**
   *
   *
   * <pre>
   * Type of the network where the endpoint is located.
   * Applicable only to source endpoint, as destination network type can be
   * inferred from the source.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.Endpoint.NetworkType network_type = 5;</code>
   *
   * @return The networkType.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.Endpoint.NetworkType getNetworkType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.networkmanagement.v1beta1.Endpoint.NetworkType result =
        com.google.cloud.networkmanagement.v1beta1.Endpoint.NetworkType.valueOf(networkType_);
    return result == null
        ? com.google.cloud.networkmanagement.v1beta1.Endpoint.NetworkType.UNRECOGNIZED
        : result;
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 6;
  private volatile java.lang.Object projectId_;
  /**
   *
   *
   * <pre>
   * Project ID where the endpoint is located.
   * The Project ID can be derived from the URI if you provide a VM instance or
   * network URI.
   * The following are two cases where you must provide the project ID:
   * 1. Only the IP address is specified, and the IP address is within a GCP
   * project.
   * 2. When you are using Shared VPC and the IP address that you provide is
   * from the service project. In this case, the network that the IP address
   * resides in is defined in the host project.
   * </pre>
   *
   * <code>string project_id = 6;</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Project ID where the endpoint is located.
   * The Project ID can be derived from the URI if you provide a VM instance or
   * network URI.
   * The following are two cases where you must provide the project ID:
   * 1. Only the IP address is specified, and the IP address is within a GCP
   * project.
   * 2. When you are using Shared VPC and the IP address that you provide is
   * from the service project. In this case, the network that the IP address
   * resides in is defined in the host project.
   * </pre>
   *
   * <code>string project_id = 6;</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ipAddress_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, ipAddress_);
    }
    if (port_ != 0) {
      output.writeInt32(2, port_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instance_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, instance_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, network_);
    }
    if (networkType_
        != com.google.cloud.networkmanagement.v1beta1.Endpoint.NetworkType.NETWORK_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, networkType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gkeMasterCluster_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, gkeMasterCluster_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cloudSqlInstance_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, cloudSqlInstance_);
    }
    if (cloudFunction_ != null) {
      output.writeMessage(10, getCloudFunction());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ipAddress_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, ipAddress_);
    }
    if (port_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, port_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instance_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, instance_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, network_);
    }
    if (networkType_
        != com.google.cloud.networkmanagement.v1beta1.Endpoint.NetworkType.NETWORK_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, networkType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gkeMasterCluster_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, gkeMasterCluster_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cloudSqlInstance_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, cloudSqlInstance_);
    }
    if (cloudFunction_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getCloudFunction());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkmanagement.v1beta1.Endpoint)) {
      return super.equals(obj);
    }
    com.google.cloud.networkmanagement.v1beta1.Endpoint other =
        (com.google.cloud.networkmanagement.v1beta1.Endpoint) obj;

    if (!getIpAddress().equals(other.getIpAddress())) return false;
    if (getPort() != other.getPort()) return false;
    if (!getInstance().equals(other.getInstance())) return false;
    if (!getGkeMasterCluster().equals(other.getGkeMasterCluster())) return false;
    if (!getCloudSqlInstance().equals(other.getCloudSqlInstance())) return false;
    if (hasCloudFunction() != other.hasCloudFunction()) return false;
    if (hasCloudFunction()) {
      if (!getCloudFunction().equals(other.getCloudFunction())) return false;
    }
    if (!getNetwork().equals(other.getNetwork())) return false;
    if (networkType_ != other.networkType_) return false;
    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + IP_ADDRESS_FIELD_NUMBER;
    hash = (53 * hash) + getIpAddress().hashCode();
    hash = (37 * hash) + PORT_FIELD_NUMBER;
    hash = (53 * hash) + getPort();
    hash = (37 * hash) + INSTANCE_FIELD_NUMBER;
    hash = (53 * hash) + getInstance().hashCode();
    hash = (37 * hash) + GKE_MASTER_CLUSTER_FIELD_NUMBER;
    hash = (53 * hash) + getGkeMasterCluster().hashCode();
    hash = (37 * hash) + CLOUD_SQL_INSTANCE_FIELD_NUMBER;
    hash = (53 * hash) + getCloudSqlInstance().hashCode();
    if (hasCloudFunction()) {
      hash = (37 * hash) + CLOUD_FUNCTION_FIELD_NUMBER;
      hash = (53 * hash) + getCloudFunction().hashCode();
    }
    hash = (37 * hash) + NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getNetwork().hashCode();
    hash = (37 * hash) + NETWORK_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + networkType_;
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkmanagement.v1beta1.Endpoint parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.Endpoint parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.Endpoint parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.Endpoint parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.Endpoint parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.Endpoint parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.Endpoint parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.Endpoint parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.Endpoint parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.Endpoint parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.Endpoint parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.Endpoint parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.networkmanagement.v1beta1.Endpoint prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Source or destination of the Connectivity Test.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkmanagement.v1beta1.Endpoint}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkmanagement.v1beta1.Endpoint)
      com.google.cloud.networkmanagement.v1beta1.EndpointOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
          .internal_static_google_cloud_networkmanagement_v1beta1_Endpoint_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
          .internal_static_google_cloud_networkmanagement_v1beta1_Endpoint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkmanagement.v1beta1.Endpoint.class,
              com.google.cloud.networkmanagement.v1beta1.Endpoint.Builder.class);
    }

    // Construct using com.google.cloud.networkmanagement.v1beta1.Endpoint.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      ipAddress_ = "";

      port_ = 0;

      instance_ = "";

      gkeMasterCluster_ = "";

      cloudSqlInstance_ = "";

      if (cloudFunctionBuilder_ == null) {
        cloudFunction_ = null;
      } else {
        cloudFunction_ = null;
        cloudFunctionBuilder_ = null;
      }
      network_ = "";

      networkType_ = 0;

      projectId_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
          .internal_static_google_cloud_networkmanagement_v1beta1_Endpoint_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.Endpoint getDefaultInstanceForType() {
      return com.google.cloud.networkmanagement.v1beta1.Endpoint.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.Endpoint build() {
      com.google.cloud.networkmanagement.v1beta1.Endpoint result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.Endpoint buildPartial() {
      com.google.cloud.networkmanagement.v1beta1.Endpoint result =
          new com.google.cloud.networkmanagement.v1beta1.Endpoint(this);
      result.ipAddress_ = ipAddress_;
      result.port_ = port_;
      result.instance_ = instance_;
      result.gkeMasterCluster_ = gkeMasterCluster_;
      result.cloudSqlInstance_ = cloudSqlInstance_;
      if (cloudFunctionBuilder_ == null) {
        result.cloudFunction_ = cloudFunction_;
      } else {
        result.cloudFunction_ = cloudFunctionBuilder_.build();
      }
      result.network_ = network_;
      result.networkType_ = networkType_;
      result.projectId_ = projectId_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkmanagement.v1beta1.Endpoint) {
        return mergeFrom((com.google.cloud.networkmanagement.v1beta1.Endpoint) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networkmanagement.v1beta1.Endpoint other) {
      if (other == com.google.cloud.networkmanagement.v1beta1.Endpoint.getDefaultInstance())
        return this;
      if (!other.getIpAddress().isEmpty()) {
        ipAddress_ = other.ipAddress_;
        onChanged();
      }
      if (other.getPort() != 0) {
        setPort(other.getPort());
      }
      if (!other.getInstance().isEmpty()) {
        instance_ = other.instance_;
        onChanged();
      }
      if (!other.getGkeMasterCluster().isEmpty()) {
        gkeMasterCluster_ = other.gkeMasterCluster_;
        onChanged();
      }
      if (!other.getCloudSqlInstance().isEmpty()) {
        cloudSqlInstance_ = other.cloudSqlInstance_;
        onChanged();
      }
      if (other.hasCloudFunction()) {
        mergeCloudFunction(other.getCloudFunction());
      }
      if (!other.getNetwork().isEmpty()) {
        network_ = other.network_;
        onChanged();
      }
      if (other.networkType_ != 0) {
        setNetworkTypeValue(other.getNetworkTypeValue());
      }
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                ipAddress_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 16:
              {
                port_ = input.readInt32();

                break;
              } // case 16
            case 26:
              {
                instance_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 34:
              {
                network_ = input.readStringRequireUtf8();

                break;
              } // case 34
            case 40:
              {
                networkType_ = input.readEnum();

                break;
              } // case 40
            case 50:
              {
                projectId_ = input.readStringRequireUtf8();

                break;
              } // case 50
            case 58:
              {
                gkeMasterCluster_ = input.readStringRequireUtf8();

                break;
              } // case 58
            case 66:
              {
                cloudSqlInstance_ = input.readStringRequireUtf8();

                break;
              } // case 66
            case 82:
              {
                input.readMessage(getCloudFunctionFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private java.lang.Object ipAddress_ = "";
    /**
     *
     *
     * <pre>
     * The IP address of the endpoint, which can be an external or internal IP.
     * An IPv6 address is only allowed when the test's destination is a
     * [global load balancer
     * VIP](https://cloud.google.com/load-balancing/docs/load-balancing-overview).
     * </pre>
     *
     * <code>string ip_address = 1;</code>
     *
     * @return The ipAddress.
     */
    public java.lang.String getIpAddress() {
      java.lang.Object ref = ipAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP address of the endpoint, which can be an external or internal IP.
     * An IPv6 address is only allowed when the test's destination is a
     * [global load balancer
     * VIP](https://cloud.google.com/load-balancing/docs/load-balancing-overview).
     * </pre>
     *
     * <code>string ip_address = 1;</code>
     *
     * @return The bytes for ipAddress.
     */
    public com.google.protobuf.ByteString getIpAddressBytes() {
      java.lang.Object ref = ipAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ipAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP address of the endpoint, which can be an external or internal IP.
     * An IPv6 address is only allowed when the test's destination is a
     * [global load balancer
     * VIP](https://cloud.google.com/load-balancing/docs/load-balancing-overview).
     * </pre>
     *
     * <code>string ip_address = 1;</code>
     *
     * @param value The ipAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIpAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      ipAddress_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP address of the endpoint, which can be an external or internal IP.
     * An IPv6 address is only allowed when the test's destination is a
     * [global load balancer
     * VIP](https://cloud.google.com/load-balancing/docs/load-balancing-overview).
     * </pre>
     *
     * <code>string ip_address = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpAddress() {

      ipAddress_ = getDefaultInstance().getIpAddress();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP address of the endpoint, which can be an external or internal IP.
     * An IPv6 address is only allowed when the test's destination is a
     * [global load balancer
     * VIP](https://cloud.google.com/load-balancing/docs/load-balancing-overview).
     * </pre>
     *
     * <code>string ip_address = 1;</code>
     *
     * @param value The bytes for ipAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIpAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      ipAddress_ = value;
      onChanged();
      return this;
    }

    private int port_;
    /**
     *
     *
     * <pre>
     * The IP protocol port of the endpoint.
     * Only applicable when protocol is TCP or UDP.
     * </pre>
     *
     * <code>int32 port = 2;</code>
     *
     * @return The port.
     */
    @java.lang.Override
    public int getPort() {
      return port_;
    }
    /**
     *
     *
     * <pre>
     * The IP protocol port of the endpoint.
     * Only applicable when protocol is TCP or UDP.
     * </pre>
     *
     * <code>int32 port = 2;</code>
     *
     * @param value The port to set.
     * @return This builder for chaining.
     */
    public Builder setPort(int value) {

      port_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP protocol port of the endpoint.
     * Only applicable when protocol is TCP or UDP.
     * </pre>
     *
     * <code>int32 port = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPort() {

      port_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object instance_ = "";
    /**
     *
     *
     * <pre>
     * A Compute Engine instance URI.
     * </pre>
     *
     * <code>string instance = 3;</code>
     *
     * @return The instance.
     */
    public java.lang.String getInstance() {
      java.lang.Object ref = instance_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instance_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A Compute Engine instance URI.
     * </pre>
     *
     * <code>string instance = 3;</code>
     *
     * @return The bytes for instance.
     */
    public com.google.protobuf.ByteString getInstanceBytes() {
      java.lang.Object ref = instance_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instance_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A Compute Engine instance URI.
     * </pre>
     *
     * <code>string instance = 3;</code>
     *
     * @param value The instance to set.
     * @return This builder for chaining.
     */
    public Builder setInstance(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      instance_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Compute Engine instance URI.
     * </pre>
     *
     * <code>string instance = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstance() {

      instance_ = getDefaultInstance().getInstance();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Compute Engine instance URI.
     * </pre>
     *
     * <code>string instance = 3;</code>
     *
     * @param value The bytes for instance to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      instance_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object gkeMasterCluster_ = "";
    /**
     *
     *
     * <pre>
     * A cluster URI for [Google Kubernetes Engine
     * master](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture).
     * </pre>
     *
     * <code>string gke_master_cluster = 7;</code>
     *
     * @return The gkeMasterCluster.
     */
    public java.lang.String getGkeMasterCluster() {
      java.lang.Object ref = gkeMasterCluster_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gkeMasterCluster_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A cluster URI for [Google Kubernetes Engine
     * master](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture).
     * </pre>
     *
     * <code>string gke_master_cluster = 7;</code>
     *
     * @return The bytes for gkeMasterCluster.
     */
    public com.google.protobuf.ByteString getGkeMasterClusterBytes() {
      java.lang.Object ref = gkeMasterCluster_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gkeMasterCluster_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A cluster URI for [Google Kubernetes Engine
     * master](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture).
     * </pre>
     *
     * <code>string gke_master_cluster = 7;</code>
     *
     * @param value The gkeMasterCluster to set.
     * @return This builder for chaining.
     */
    public Builder setGkeMasterCluster(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      gkeMasterCluster_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A cluster URI for [Google Kubernetes Engine
     * master](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture).
     * </pre>
     *
     * <code>string gke_master_cluster = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGkeMasterCluster() {

      gkeMasterCluster_ = getDefaultInstance().getGkeMasterCluster();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A cluster URI for [Google Kubernetes Engine
     * master](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture).
     * </pre>
     *
     * <code>string gke_master_cluster = 7;</code>
     *
     * @param value The bytes for gkeMasterCluster to set.
     * @return This builder for chaining.
     */
    public Builder setGkeMasterClusterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      gkeMasterCluster_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object cloudSqlInstance_ = "";
    /**
     *
     *
     * <pre>
     * A [Cloud SQL](https://cloud.google.com/sql) instance URI.
     * </pre>
     *
     * <code>string cloud_sql_instance = 8;</code>
     *
     * @return The cloudSqlInstance.
     */
    public java.lang.String getCloudSqlInstance() {
      java.lang.Object ref = cloudSqlInstance_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cloudSqlInstance_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A [Cloud SQL](https://cloud.google.com/sql) instance URI.
     * </pre>
     *
     * <code>string cloud_sql_instance = 8;</code>
     *
     * @return The bytes for cloudSqlInstance.
     */
    public com.google.protobuf.ByteString getCloudSqlInstanceBytes() {
      java.lang.Object ref = cloudSqlInstance_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cloudSqlInstance_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A [Cloud SQL](https://cloud.google.com/sql) instance URI.
     * </pre>
     *
     * <code>string cloud_sql_instance = 8;</code>
     *
     * @param value The cloudSqlInstance to set.
     * @return This builder for chaining.
     */
    public Builder setCloudSqlInstance(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      cloudSqlInstance_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A [Cloud SQL](https://cloud.google.com/sql) instance URI.
     * </pre>
     *
     * <code>string cloud_sql_instance = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCloudSqlInstance() {

      cloudSqlInstance_ = getDefaultInstance().getCloudSqlInstance();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A [Cloud SQL](https://cloud.google.com/sql) instance URI.
     * </pre>
     *
     * <code>string cloud_sql_instance = 8;</code>
     *
     * @param value The bytes for cloudSqlInstance to set.
     * @return This builder for chaining.
     */
    public Builder setCloudSqlInstanceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      cloudSqlInstance_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
        cloudFunction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint,
            com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint.Builder,
            com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpointOrBuilder>
        cloudFunctionBuilder_;
    /**
     *
     *
     * <pre>
     * A [Cloud function](https://cloud.google.com/functions).
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint cloud_function = 10;
     * </code>
     *
     * @return Whether the cloudFunction field is set.
     */
    public boolean hasCloudFunction() {
      return cloudFunctionBuilder_ != null || cloudFunction_ != null;
    }
    /**
     *
     *
     * <pre>
     * A [Cloud function](https://cloud.google.com/functions).
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint cloud_function = 10;
     * </code>
     *
     * @return The cloudFunction.
     */
    public com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
        getCloudFunction() {
      if (cloudFunctionBuilder_ == null) {
        return cloudFunction_ == null
            ? com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
                .getDefaultInstance()
            : cloudFunction_;
      } else {
        return cloudFunctionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A [Cloud function](https://cloud.google.com/functions).
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint cloud_function = 10;
     * </code>
     */
    public Builder setCloudFunction(
        com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint value) {
      if (cloudFunctionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cloudFunction_ = value;
        onChanged();
      } else {
        cloudFunctionBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A [Cloud function](https://cloud.google.com/functions).
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint cloud_function = 10;
     * </code>
     */
    public Builder setCloudFunction(
        com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint.Builder
            builderForValue) {
      if (cloudFunctionBuilder_ == null) {
        cloudFunction_ = builderForValue.build();
        onChanged();
      } else {
        cloudFunctionBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A [Cloud function](https://cloud.google.com/functions).
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint cloud_function = 10;
     * </code>
     */
    public Builder mergeCloudFunction(
        com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint value) {
      if (cloudFunctionBuilder_ == null) {
        if (cloudFunction_ != null) {
          cloudFunction_ =
              com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint.newBuilder(
                      cloudFunction_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          cloudFunction_ = value;
        }
        onChanged();
      } else {
        cloudFunctionBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A [Cloud function](https://cloud.google.com/functions).
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint cloud_function = 10;
     * </code>
     */
    public Builder clearCloudFunction() {
      if (cloudFunctionBuilder_ == null) {
        cloudFunction_ = null;
        onChanged();
      } else {
        cloudFunction_ = null;
        cloudFunctionBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A [Cloud function](https://cloud.google.com/functions).
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint cloud_function = 10;
     * </code>
     */
    public com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint.Builder
        getCloudFunctionBuilder() {

      onChanged();
      return getCloudFunctionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A [Cloud function](https://cloud.google.com/functions).
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint cloud_function = 10;
     * </code>
     */
    public com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpointOrBuilder
        getCloudFunctionOrBuilder() {
      if (cloudFunctionBuilder_ != null) {
        return cloudFunctionBuilder_.getMessageOrBuilder();
      } else {
        return cloudFunction_ == null
            ? com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint
                .getDefaultInstance()
            : cloudFunction_;
      }
    }
    /**
     *
     *
     * <pre>
     * A [Cloud function](https://cloud.google.com/functions).
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint cloud_function = 10;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint,
            com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint.Builder,
            com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpointOrBuilder>
        getCloudFunctionFieldBuilder() {
      if (cloudFunctionBuilder_ == null) {
        cloudFunctionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint,
                com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpoint.Builder,
                com.google.cloud.networkmanagement.v1beta1.Endpoint.CloudFunctionEndpointOrBuilder>(
                getCloudFunction(), getParentForChildren(), isClean());
        cloudFunction_ = null;
      }
      return cloudFunctionBuilder_;
    }

    private java.lang.Object network_ = "";
    /**
     *
     *
     * <pre>
     * A Compute Engine network URI.
     * </pre>
     *
     * <code>string network = 4;</code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A Compute Engine network URI.
     * </pre>
     *
     * <code>string network = 4;</code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A Compute Engine network URI.
     * </pre>
     *
     * <code>string network = 4;</code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      network_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Compute Engine network URI.
     * </pre>
     *
     * <code>string network = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {

      network_ = getDefaultInstance().getNetwork();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Compute Engine network URI.
     * </pre>
     *
     * <code>string network = 4;</code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      network_ = value;
      onChanged();
      return this;
    }

    private int networkType_ = 0;
    /**
     *
     *
     * <pre>
     * Type of the network where the endpoint is located.
     * Applicable only to source endpoint, as destination network type can be
     * inferred from the source.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.Endpoint.NetworkType network_type = 5;</code>
     *
     * @return The enum numeric value on the wire for networkType.
     */
    @java.lang.Override
    public int getNetworkTypeValue() {
      return networkType_;
    }
    /**
     *
     *
     * <pre>
     * Type of the network where the endpoint is located.
     * Applicable only to source endpoint, as destination network type can be
     * inferred from the source.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.Endpoint.NetworkType network_type = 5;</code>
     *
     * @param value The enum numeric value on the wire for networkType to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkTypeValue(int value) {

      networkType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of the network where the endpoint is located.
     * Applicable only to source endpoint, as destination network type can be
     * inferred from the source.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.Endpoint.NetworkType network_type = 5;</code>
     *
     * @return The networkType.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.Endpoint.NetworkType getNetworkType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.networkmanagement.v1beta1.Endpoint.NetworkType result =
          com.google.cloud.networkmanagement.v1beta1.Endpoint.NetworkType.valueOf(networkType_);
      return result == null
          ? com.google.cloud.networkmanagement.v1beta1.Endpoint.NetworkType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Type of the network where the endpoint is located.
     * Applicable only to source endpoint, as destination network type can be
     * inferred from the source.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.Endpoint.NetworkType network_type = 5;</code>
     *
     * @param value The networkType to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkType(
        com.google.cloud.networkmanagement.v1beta1.Endpoint.NetworkType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      networkType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of the network where the endpoint is located.
     * Applicable only to source endpoint, as destination network type can be
     * inferred from the source.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.Endpoint.NetworkType network_type = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetworkType() {

      networkType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Project ID where the endpoint is located.
     * The Project ID can be derived from the URI if you provide a VM instance or
     * network URI.
     * The following are two cases where you must provide the project ID:
     * 1. Only the IP address is specified, and the IP address is within a GCP
     * project.
     * 2. When you are using Shared VPC and the IP address that you provide is
     * from the service project. In this case, the network that the IP address
     * resides in is defined in the host project.
     * </pre>
     *
     * <code>string project_id = 6;</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Project ID where the endpoint is located.
     * The Project ID can be derived from the URI if you provide a VM instance or
     * network URI.
     * The following are two cases where you must provide the project ID:
     * 1. Only the IP address is specified, and the IP address is within a GCP
     * project.
     * 2. When you are using Shared VPC and the IP address that you provide is
     * from the service project. In this case, the network that the IP address
     * resides in is defined in the host project.
     * </pre>
     *
     * <code>string project_id = 6;</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Project ID where the endpoint is located.
     * The Project ID can be derived from the URI if you provide a VM instance or
     * network URI.
     * The following are two cases where you must provide the project ID:
     * 1. Only the IP address is specified, and the IP address is within a GCP
     * project.
     * 2. When you are using Shared VPC and the IP address that you provide is
     * from the service project. In this case, the network that the IP address
     * resides in is defined in the host project.
     * </pre>
     *
     * <code>string project_id = 6;</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      projectId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Project ID where the endpoint is located.
     * The Project ID can be derived from the URI if you provide a VM instance or
     * network URI.
     * The following are two cases where you must provide the project ID:
     * 1. Only the IP address is specified, and the IP address is within a GCP
     * project.
     * 2. When you are using Shared VPC and the IP address that you provide is
     * from the service project. In this case, the network that the IP address
     * resides in is defined in the host project.
     * </pre>
     *
     * <code>string project_id = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {

      projectId_ = getDefaultInstance().getProjectId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Project ID where the endpoint is located.
     * The Project ID can be derived from the URI if you provide a VM instance or
     * network URI.
     * The following are two cases where you must provide the project ID:
     * 1. Only the IP address is specified, and the IP address is within a GCP
     * project.
     * 2. When you are using Shared VPC and the IP address that you provide is
     * from the service project. In this case, the network that the IP address
     * resides in is defined in the host project.
     * </pre>
     *
     * <code>string project_id = 6;</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      projectId_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkmanagement.v1beta1.Endpoint)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkmanagement.v1beta1.Endpoint)
  private static final com.google.cloud.networkmanagement.v1beta1.Endpoint DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkmanagement.v1beta1.Endpoint();
  }

  public static com.google.cloud.networkmanagement.v1beta1.Endpoint getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Endpoint> PARSER =
      new com.google.protobuf.AbstractParser<Endpoint>() {
        @java.lang.Override
        public Endpoint parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Endpoint> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Endpoint> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.Endpoint getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
