/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkmanagement/v1beta1/connectivity_test.proto

package com.google.cloud.networkmanagement.v1beta1;

/**
 *
 *
 * <pre>
 * A Connectivity Test for a network reachability analysis.
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkmanagement.v1beta1.ConnectivityTest}
 */
public final class ConnectivityTest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkmanagement.v1beta1.ConnectivityTest)
    ConnectivityTestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ConnectivityTest.newBuilder() to construct.
  private ConnectivityTest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ConnectivityTest() {
    name_ = "";
    description_ = "";
    protocol_ = "";
    relatedProjects_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ConnectivityTest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
        .internal_static_google_cloud_networkmanagement_v1beta1_ConnectivityTest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 8:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
        .internal_static_google_cloud_networkmanagement_v1beta1_ConnectivityTest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkmanagement.v1beta1.ConnectivityTest.class,
            com.google.cloud.networkmanagement.v1beta1.ConnectivityTest.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Required. Unique name of the resource using the form:
   *     `projects/{project_id}/locations/global/connectivityTests/{test}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Unique name of the resource using the form:
   *     `projects/{project_id}/locations/global/connectivityTests/{test}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * The user-supplied description of the Connectivity Test.
   * Maximum of 512 characters.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The user-supplied description of the Connectivity Test.
   * Maximum of 512 characters.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_FIELD_NUMBER = 3;
  private com.google.cloud.networkmanagement.v1beta1.Endpoint source_;
  /**
   *
   *
   * <pre>
   * Required. Source specification of the Connectivity Test.
   * You can use a combination of source IP address, virtual machine
   * (VM) instance, or Compute Engine network to uniquely identify
   * the source location.
   * Examples:
   * If the source IP address is an internal IP address within a Google Cloud
   * Virtual Private Cloud (VPC) network, then you must also specify the VPC
   * network. Otherwise, specify the VM instance, which already contains its
   * internal IP address and VPC network information.
   * If the source of the test is within an on-premises network, then you must
   * provide the destination VPC network.
   * If the source endpoint is a Compute Engine VM instance with multiple
   * network interfaces, the instance itself is not sufficient to identify the
   * endpoint. So, you must also specify the source IP address or VPC network.
   * A reachability analysis proceeds even if the source location is
   * ambiguous. However, the test result may include endpoints that you don't
   * intend to test.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1beta1.Endpoint source = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the source field is set.
   */
  @java.lang.Override
  public boolean hasSource() {
    return source_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Source specification of the Connectivity Test.
   * You can use a combination of source IP address, virtual machine
   * (VM) instance, or Compute Engine network to uniquely identify
   * the source location.
   * Examples:
   * If the source IP address is an internal IP address within a Google Cloud
   * Virtual Private Cloud (VPC) network, then you must also specify the VPC
   * network. Otherwise, specify the VM instance, which already contains its
   * internal IP address and VPC network information.
   * If the source of the test is within an on-premises network, then you must
   * provide the destination VPC network.
   * If the source endpoint is a Compute Engine VM instance with multiple
   * network interfaces, the instance itself is not sufficient to identify the
   * endpoint. So, you must also specify the source IP address or VPC network.
   * A reachability analysis proceeds even if the source location is
   * ambiguous. However, the test result may include endpoints that you don't
   * intend to test.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1beta1.Endpoint source = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The source.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.Endpoint getSource() {
    return source_ == null
        ? com.google.cloud.networkmanagement.v1beta1.Endpoint.getDefaultInstance()
        : source_;
  }
  /**
   *
   *
   * <pre>
   * Required. Source specification of the Connectivity Test.
   * You can use a combination of source IP address, virtual machine
   * (VM) instance, or Compute Engine network to uniquely identify
   * the source location.
   * Examples:
   * If the source IP address is an internal IP address within a Google Cloud
   * Virtual Private Cloud (VPC) network, then you must also specify the VPC
   * network. Otherwise, specify the VM instance, which already contains its
   * internal IP address and VPC network information.
   * If the source of the test is within an on-premises network, then you must
   * provide the destination VPC network.
   * If the source endpoint is a Compute Engine VM instance with multiple
   * network interfaces, the instance itself is not sufficient to identify the
   * endpoint. So, you must also specify the source IP address or VPC network.
   * A reachability analysis proceeds even if the source location is
   * ambiguous. However, the test result may include endpoints that you don't
   * intend to test.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1beta1.Endpoint source = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.EndpointOrBuilder getSourceOrBuilder() {
    return getSource();
  }

  public static final int DESTINATION_FIELD_NUMBER = 4;
  private com.google.cloud.networkmanagement.v1beta1.Endpoint destination_;
  /**
   *
   *
   * <pre>
   * Required. Destination specification of the Connectivity Test.
   * You can use a combination of destination IP address, Compute Engine
   * VM instance, or VPC network to uniquely identify the destination
   * location.
   * Even if the destination IP address is not unique, the source IP
   * location is unique. Usually, the analysis can infer the destination
   * endpoint from route information.
   * If the destination you specify is a VM instance and the instance has
   * multiple network interfaces, then you must also specify either
   * a destination IP address  or VPC network to identify the destination
   * interface.
   * A reachability analysis proceeds even if the destination location is
   * ambiguous. However, the result can include endpoints that you don't
   * intend to test.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1beta1.Endpoint destination = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the destination field is set.
   */
  @java.lang.Override
  public boolean hasDestination() {
    return destination_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Destination specification of the Connectivity Test.
   * You can use a combination of destination IP address, Compute Engine
   * VM instance, or VPC network to uniquely identify the destination
   * location.
   * Even if the destination IP address is not unique, the source IP
   * location is unique. Usually, the analysis can infer the destination
   * endpoint from route information.
   * If the destination you specify is a VM instance and the instance has
   * multiple network interfaces, then you must also specify either
   * a destination IP address  or VPC network to identify the destination
   * interface.
   * A reachability analysis proceeds even if the destination location is
   * ambiguous. However, the result can include endpoints that you don't
   * intend to test.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1beta1.Endpoint destination = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The destination.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.Endpoint getDestination() {
    return destination_ == null
        ? com.google.cloud.networkmanagement.v1beta1.Endpoint.getDefaultInstance()
        : destination_;
  }
  /**
   *
   *
   * <pre>
   * Required. Destination specification of the Connectivity Test.
   * You can use a combination of destination IP address, Compute Engine
   * VM instance, or VPC network to uniquely identify the destination
   * location.
   * Even if the destination IP address is not unique, the source IP
   * location is unique. Usually, the analysis can infer the destination
   * endpoint from route information.
   * If the destination you specify is a VM instance and the instance has
   * multiple network interfaces, then you must also specify either
   * a destination IP address  or VPC network to identify the destination
   * interface.
   * A reachability analysis proceeds even if the destination location is
   * ambiguous. However, the result can include endpoints that you don't
   * intend to test.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1beta1.Endpoint destination = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.EndpointOrBuilder getDestinationOrBuilder() {
    return getDestination();
  }

  public static final int PROTOCOL_FIELD_NUMBER = 5;
  private volatile java.lang.Object protocol_;
  /**
   *
   *
   * <pre>
   * IP Protocol of the test. When not provided, "TCP" is assumed.
   * </pre>
   *
   * <code>string protocol = 5;</code>
   *
   * @return The protocol.
   */
  @java.lang.Override
  public java.lang.String getProtocol() {
    java.lang.Object ref = protocol_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      protocol_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * IP Protocol of the test. When not provided, "TCP" is assumed.
   * </pre>
   *
   * <code>string protocol = 5;</code>
   *
   * @return The bytes for protocol.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProtocolBytes() {
    java.lang.Object ref = protocol_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      protocol_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RELATED_PROJECTS_FIELD_NUMBER = 6;
  private com.google.protobuf.LazyStringList relatedProjects_;
  /**
   *
   *
   * <pre>
   * Other projects that may be relevant for reachability analysis.
   * This is applicable to scenarios where a test can cross project boundaries.
   * </pre>
   *
   * <code>repeated string related_projects = 6;</code>
   *
   * @return A list containing the relatedProjects.
   */
  public com.google.protobuf.ProtocolStringList getRelatedProjectsList() {
    return relatedProjects_;
  }
  /**
   *
   *
   * <pre>
   * Other projects that may be relevant for reachability analysis.
   * This is applicable to scenarios where a test can cross project boundaries.
   * </pre>
   *
   * <code>repeated string related_projects = 6;</code>
   *
   * @return The count of relatedProjects.
   */
  public int getRelatedProjectsCount() {
    return relatedProjects_.size();
  }
  /**
   *
   *
   * <pre>
   * Other projects that may be relevant for reachability analysis.
   * This is applicable to scenarios where a test can cross project boundaries.
   * </pre>
   *
   * <code>repeated string related_projects = 6;</code>
   *
   * @param index The index of the element to return.
   * @return The relatedProjects at the given index.
   */
  public java.lang.String getRelatedProjects(int index) {
    return relatedProjects_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Other projects that may be relevant for reachability analysis.
   * This is applicable to scenarios where a test can cross project boundaries.
   * </pre>
   *
   * <code>repeated string related_projects = 6;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the relatedProjects at the given index.
   */
  public com.google.protobuf.ByteString getRelatedProjectsBytes(int index) {
    return relatedProjects_.getByteString(index);
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 7;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Output only. The display name of a Connectivity Test.
   * </pre>
   *
   * <code>string display_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The display name of a Connectivity Test.
   * </pre>
   *
   * <code>string display_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 8;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.networkmanagement.v1beta1.TestOuterClass
                .internal_static_google_cloud_networkmanagement_v1beta1_ConnectivityTest_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Resource labels to represent user-provided metadata.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Resource labels to represent user-provided metadata.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Resource labels to represent user-provided metadata.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Resource labels to represent user-provided metadata.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the test was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the test was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the test was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the test's configuration was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the test's configuration was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the test's configuration was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int REACHABILITY_DETAILS_FIELD_NUMBER = 12;
  private com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails reachabilityDetails_;
  /**
   *
   *
   * <pre>
   * Output only. The reachability details of this test from the latest run.
   * The details are updated when creating a new test, updating an
   * existing test, or triggering a one-time rerun of an existing test.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1beta1.ReachabilityDetails reachability_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the reachabilityDetails field is set.
   */
  @java.lang.Override
  public boolean hasReachabilityDetails() {
    return reachabilityDetails_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The reachability details of this test from the latest run.
   * The details are updated when creating a new test, updating an
   * existing test, or triggering a one-time rerun of an existing test.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1beta1.ReachabilityDetails reachability_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The reachabilityDetails.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails getReachabilityDetails() {
    return reachabilityDetails_ == null
        ? com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.getDefaultInstance()
        : reachabilityDetails_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The reachability details of this test from the latest run.
   * The details are updated when creating a new test, updating an
   * existing test, or triggering a one-time rerun of an existing test.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1beta1.ReachabilityDetails reachability_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.ReachabilityDetailsOrBuilder
      getReachabilityDetailsOrBuilder() {
    return getReachabilityDetails();
  }

  public static final int PROBING_DETAILS_FIELD_NUMBER = 14;
  private com.google.cloud.networkmanagement.v1beta1.ProbingDetails probingDetails_;
  /**
   *
   *
   * <pre>
   * Output only. The probing details of this test from the latest run, present
   * for applicable tests only. The details are updated when creating a new
   * test, updating an existing test, or triggering a one-time rerun of an
   * existing test.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1beta1.ProbingDetails probing_details = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the probingDetails field is set.
   */
  @java.lang.Override
  public boolean hasProbingDetails() {
    return probingDetails_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The probing details of this test from the latest run, present
   * for applicable tests only. The details are updated when creating a new
   * test, updating an existing test, or triggering a one-time rerun of an
   * existing test.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1beta1.ProbingDetails probing_details = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The probingDetails.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.ProbingDetails getProbingDetails() {
    return probingDetails_ == null
        ? com.google.cloud.networkmanagement.v1beta1.ProbingDetails.getDefaultInstance()
        : probingDetails_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The probing details of this test from the latest run, present
   * for applicable tests only. The details are updated when creating a new
   * test, updating an existing test, or triggering a one-time rerun of an
   * existing test.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1beta1.ProbingDetails probing_details = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.ProbingDetailsOrBuilder
      getProbingDetailsOrBuilder() {
    return getProbingDetails();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (source_ != null) {
      output.writeMessage(3, getSource());
    }
    if (destination_ != null) {
      output.writeMessage(4, getDestination());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(protocol_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, protocol_);
    }
    for (int i = 0; i < relatedProjects_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, relatedProjects_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, displayName_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 8);
    if (createTime_ != null) {
      output.writeMessage(10, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(11, getUpdateTime());
    }
    if (reachabilityDetails_ != null) {
      output.writeMessage(12, getReachabilityDetails());
    }
    if (probingDetails_ != null) {
      output.writeMessage(14, getProbingDetails());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (source_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getSource());
    }
    if (destination_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDestination());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(protocol_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, protocol_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < relatedProjects_.size(); i++) {
        dataSize += computeStringSizeNoTag(relatedProjects_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getRelatedProjectsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, displayName_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, labels__);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getUpdateTime());
    }
    if (reachabilityDetails_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(12, getReachabilityDetails());
    }
    if (probingDetails_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getProbingDetails());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkmanagement.v1beta1.ConnectivityTest)) {
      return super.equals(obj);
    }
    com.google.cloud.networkmanagement.v1beta1.ConnectivityTest other =
        (com.google.cloud.networkmanagement.v1beta1.ConnectivityTest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasSource() != other.hasSource()) return false;
    if (hasSource()) {
      if (!getSource().equals(other.getSource())) return false;
    }
    if (hasDestination() != other.hasDestination()) return false;
    if (hasDestination()) {
      if (!getDestination().equals(other.getDestination())) return false;
    }
    if (!getProtocol().equals(other.getProtocol())) return false;
    if (!getRelatedProjectsList().equals(other.getRelatedProjectsList())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasReachabilityDetails() != other.hasReachabilityDetails()) return false;
    if (hasReachabilityDetails()) {
      if (!getReachabilityDetails().equals(other.getReachabilityDetails())) return false;
    }
    if (hasProbingDetails() != other.hasProbingDetails()) return false;
    if (hasProbingDetails()) {
      if (!getProbingDetails().equals(other.getProbingDetails())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasSource()) {
      hash = (37 * hash) + SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getSource().hashCode();
    }
    if (hasDestination()) {
      hash = (37 * hash) + DESTINATION_FIELD_NUMBER;
      hash = (53 * hash) + getDestination().hashCode();
    }
    hash = (37 * hash) + PROTOCOL_FIELD_NUMBER;
    hash = (53 * hash) + getProtocol().hashCode();
    if (getRelatedProjectsCount() > 0) {
      hash = (37 * hash) + RELATED_PROJECTS_FIELD_NUMBER;
      hash = (53 * hash) + getRelatedProjectsList().hashCode();
    }
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasReachabilityDetails()) {
      hash = (37 * hash) + REACHABILITY_DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getReachabilityDetails().hashCode();
    }
    if (hasProbingDetails()) {
      hash = (37 * hash) + PROBING_DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getProbingDetails().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkmanagement.v1beta1.ConnectivityTest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ConnectivityTest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ConnectivityTest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ConnectivityTest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ConnectivityTest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ConnectivityTest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ConnectivityTest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ConnectivityTest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ConnectivityTest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ConnectivityTest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ConnectivityTest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ConnectivityTest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.networkmanagement.v1beta1.ConnectivityTest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Connectivity Test for a network reachability analysis.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkmanagement.v1beta1.ConnectivityTest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkmanagement.v1beta1.ConnectivityTest)
      com.google.cloud.networkmanagement.v1beta1.ConnectivityTestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
          .internal_static_google_cloud_networkmanagement_v1beta1_ConnectivityTest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 8:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 8:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
          .internal_static_google_cloud_networkmanagement_v1beta1_ConnectivityTest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkmanagement.v1beta1.ConnectivityTest.class,
              com.google.cloud.networkmanagement.v1beta1.ConnectivityTest.Builder.class);
    }

    // Construct using com.google.cloud.networkmanagement.v1beta1.ConnectivityTest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      description_ = "";

      if (sourceBuilder_ == null) {
        source_ = null;
      } else {
        source_ = null;
        sourceBuilder_ = null;
      }
      if (destinationBuilder_ == null) {
        destination_ = null;
      } else {
        destination_ = null;
        destinationBuilder_ = null;
      }
      protocol_ = "";

      relatedProjects_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      displayName_ = "";

      internalGetMutableLabels().clear();
      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      if (reachabilityDetailsBuilder_ == null) {
        reachabilityDetails_ = null;
      } else {
        reachabilityDetails_ = null;
        reachabilityDetailsBuilder_ = null;
      }
      if (probingDetailsBuilder_ == null) {
        probingDetails_ = null;
      } else {
        probingDetails_ = null;
        probingDetailsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
          .internal_static_google_cloud_networkmanagement_v1beta1_ConnectivityTest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.ConnectivityTest getDefaultInstanceForType() {
      return com.google.cloud.networkmanagement.v1beta1.ConnectivityTest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.ConnectivityTest build() {
      com.google.cloud.networkmanagement.v1beta1.ConnectivityTest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.ConnectivityTest buildPartial() {
      com.google.cloud.networkmanagement.v1beta1.ConnectivityTest result =
          new com.google.cloud.networkmanagement.v1beta1.ConnectivityTest(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.description_ = description_;
      if (sourceBuilder_ == null) {
        result.source_ = source_;
      } else {
        result.source_ = sourceBuilder_.build();
      }
      if (destinationBuilder_ == null) {
        result.destination_ = destination_;
      } else {
        result.destination_ = destinationBuilder_.build();
      }
      result.protocol_ = protocol_;
      if (((bitField0_ & 0x00000001) != 0)) {
        relatedProjects_ = relatedProjects_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.relatedProjects_ = relatedProjects_;
      result.displayName_ = displayName_;
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      if (reachabilityDetailsBuilder_ == null) {
        result.reachabilityDetails_ = reachabilityDetails_;
      } else {
        result.reachabilityDetails_ = reachabilityDetailsBuilder_.build();
      }
      if (probingDetailsBuilder_ == null) {
        result.probingDetails_ = probingDetails_;
      } else {
        result.probingDetails_ = probingDetailsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkmanagement.v1beta1.ConnectivityTest) {
        return mergeFrom((com.google.cloud.networkmanagement.v1beta1.ConnectivityTest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networkmanagement.v1beta1.ConnectivityTest other) {
      if (other == com.google.cloud.networkmanagement.v1beta1.ConnectivityTest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (other.hasSource()) {
        mergeSource(other.getSource());
      }
      if (other.hasDestination()) {
        mergeDestination(other.getDestination());
      }
      if (!other.getProtocol().isEmpty()) {
        protocol_ = other.protocol_;
        onChanged();
      }
      if (!other.relatedProjects_.isEmpty()) {
        if (relatedProjects_.isEmpty()) {
          relatedProjects_ = other.relatedProjects_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureRelatedProjectsIsMutable();
          relatedProjects_.addAll(other.relatedProjects_);
        }
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasReachabilityDetails()) {
        mergeReachabilityDetails(other.getReachabilityDetails());
      }
      if (other.hasProbingDetails()) {
        mergeProbingDetails(other.getProbingDetails());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getSourceFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                input.readMessage(getDestinationFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 42:
              {
                protocol_ = input.readStringRequireUtf8();

                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureRelatedProjectsIsMutable();
                relatedProjects_.add(s);
                break;
              } // case 50
            case 58:
              {
                displayName_ = input.readStringRequireUtf8();

                break;
              } // case 58
            case 66:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                break;
              } // case 66
            case 82:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 82
            case 90:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    getReachabilityDetailsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 98
            case 114:
              {
                input.readMessage(getProbingDetailsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Unique name of the resource using the form:
     *     `projects/{project_id}/locations/global/connectivityTests/{test}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Unique name of the resource using the form:
     *     `projects/{project_id}/locations/global/connectivityTests/{test}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Unique name of the resource using the form:
     *     `projects/{project_id}/locations/global/connectivityTests/{test}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Unique name of the resource using the form:
     *     `projects/{project_id}/locations/global/connectivityTests/{test}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Unique name of the resource using the form:
     *     `projects/{project_id}/locations/global/connectivityTests/{test}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * The user-supplied description of the Connectivity Test.
     * Maximum of 512 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The user-supplied description of the Connectivity Test.
     * Maximum of 512 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The user-supplied description of the Connectivity Test.
     * Maximum of 512 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user-supplied description of the Connectivity Test.
     * Maximum of 512 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user-supplied description of the Connectivity Test.
     * Maximum of 512 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.networkmanagement.v1beta1.Endpoint source_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.Endpoint,
            com.google.cloud.networkmanagement.v1beta1.Endpoint.Builder,
            com.google.cloud.networkmanagement.v1beta1.EndpointOrBuilder>
        sourceBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Source specification of the Connectivity Test.
     * You can use a combination of source IP address, virtual machine
     * (VM) instance, or Compute Engine network to uniquely identify
     * the source location.
     * Examples:
     * If the source IP address is an internal IP address within a Google Cloud
     * Virtual Private Cloud (VPC) network, then you must also specify the VPC
     * network. Otherwise, specify the VM instance, which already contains its
     * internal IP address and VPC network information.
     * If the source of the test is within an on-premises network, then you must
     * provide the destination VPC network.
     * If the source endpoint is a Compute Engine VM instance with multiple
     * network interfaces, the instance itself is not sufficient to identify the
     * endpoint. So, you must also specify the source IP address or VPC network.
     * A reachability analysis proceeds even if the source location is
     * ambiguous. However, the test result may include endpoints that you don't
     * intend to test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint source = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the source field is set.
     */
    public boolean hasSource() {
      return sourceBuilder_ != null || source_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Source specification of the Connectivity Test.
     * You can use a combination of source IP address, virtual machine
     * (VM) instance, or Compute Engine network to uniquely identify
     * the source location.
     * Examples:
     * If the source IP address is an internal IP address within a Google Cloud
     * Virtual Private Cloud (VPC) network, then you must also specify the VPC
     * network. Otherwise, specify the VM instance, which already contains its
     * internal IP address and VPC network information.
     * If the source of the test is within an on-premises network, then you must
     * provide the destination VPC network.
     * If the source endpoint is a Compute Engine VM instance with multiple
     * network interfaces, the instance itself is not sufficient to identify the
     * endpoint. So, you must also specify the source IP address or VPC network.
     * A reachability analysis proceeds even if the source location is
     * ambiguous. However, the test result may include endpoints that you don't
     * intend to test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint source = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The source.
     */
    public com.google.cloud.networkmanagement.v1beta1.Endpoint getSource() {
      if (sourceBuilder_ == null) {
        return source_ == null
            ? com.google.cloud.networkmanagement.v1beta1.Endpoint.getDefaultInstance()
            : source_;
      } else {
        return sourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Source specification of the Connectivity Test.
     * You can use a combination of source IP address, virtual machine
     * (VM) instance, or Compute Engine network to uniquely identify
     * the source location.
     * Examples:
     * If the source IP address is an internal IP address within a Google Cloud
     * Virtual Private Cloud (VPC) network, then you must also specify the VPC
     * network. Otherwise, specify the VM instance, which already contains its
     * internal IP address and VPC network information.
     * If the source of the test is within an on-premises network, then you must
     * provide the destination VPC network.
     * If the source endpoint is a Compute Engine VM instance with multiple
     * network interfaces, the instance itself is not sufficient to identify the
     * endpoint. So, you must also specify the source IP address or VPC network.
     * A reachability analysis proceeds even if the source location is
     * ambiguous. However, the test result may include endpoints that you don't
     * intend to test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint source = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setSource(com.google.cloud.networkmanagement.v1beta1.Endpoint value) {
      if (sourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        sourceBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Source specification of the Connectivity Test.
     * You can use a combination of source IP address, virtual machine
     * (VM) instance, or Compute Engine network to uniquely identify
     * the source location.
     * Examples:
     * If the source IP address is an internal IP address within a Google Cloud
     * Virtual Private Cloud (VPC) network, then you must also specify the VPC
     * network. Otherwise, specify the VM instance, which already contains its
     * internal IP address and VPC network information.
     * If the source of the test is within an on-premises network, then you must
     * provide the destination VPC network.
     * If the source endpoint is a Compute Engine VM instance with multiple
     * network interfaces, the instance itself is not sufficient to identify the
     * endpoint. So, you must also specify the source IP address or VPC network.
     * A reachability analysis proceeds even if the source location is
     * ambiguous. However, the test result may include endpoints that you don't
     * intend to test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint source = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setSource(
        com.google.cloud.networkmanagement.v1beta1.Endpoint.Builder builderForValue) {
      if (sourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        sourceBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Source specification of the Connectivity Test.
     * You can use a combination of source IP address, virtual machine
     * (VM) instance, or Compute Engine network to uniquely identify
     * the source location.
     * Examples:
     * If the source IP address is an internal IP address within a Google Cloud
     * Virtual Private Cloud (VPC) network, then you must also specify the VPC
     * network. Otherwise, specify the VM instance, which already contains its
     * internal IP address and VPC network information.
     * If the source of the test is within an on-premises network, then you must
     * provide the destination VPC network.
     * If the source endpoint is a Compute Engine VM instance with multiple
     * network interfaces, the instance itself is not sufficient to identify the
     * endpoint. So, you must also specify the source IP address or VPC network.
     * A reachability analysis proceeds even if the source location is
     * ambiguous. However, the test result may include endpoints that you don't
     * intend to test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint source = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeSource(com.google.cloud.networkmanagement.v1beta1.Endpoint value) {
      if (sourceBuilder_ == null) {
        if (source_ != null) {
          source_ =
              com.google.cloud.networkmanagement.v1beta1.Endpoint.newBuilder(source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        sourceBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Source specification of the Connectivity Test.
     * You can use a combination of source IP address, virtual machine
     * (VM) instance, or Compute Engine network to uniquely identify
     * the source location.
     * Examples:
     * If the source IP address is an internal IP address within a Google Cloud
     * Virtual Private Cloud (VPC) network, then you must also specify the VPC
     * network. Otherwise, specify the VM instance, which already contains its
     * internal IP address and VPC network information.
     * If the source of the test is within an on-premises network, then you must
     * provide the destination VPC network.
     * If the source endpoint is a Compute Engine VM instance with multiple
     * network interfaces, the instance itself is not sufficient to identify the
     * endpoint. So, you must also specify the source IP address or VPC network.
     * A reachability analysis proceeds even if the source location is
     * ambiguous. However, the test result may include endpoints that you don't
     * intend to test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint source = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearSource() {
      if (sourceBuilder_ == null) {
        source_ = null;
        onChanged();
      } else {
        source_ = null;
        sourceBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Source specification of the Connectivity Test.
     * You can use a combination of source IP address, virtual machine
     * (VM) instance, or Compute Engine network to uniquely identify
     * the source location.
     * Examples:
     * If the source IP address is an internal IP address within a Google Cloud
     * Virtual Private Cloud (VPC) network, then you must also specify the VPC
     * network. Otherwise, specify the VM instance, which already contains its
     * internal IP address and VPC network information.
     * If the source of the test is within an on-premises network, then you must
     * provide the destination VPC network.
     * If the source endpoint is a Compute Engine VM instance with multiple
     * network interfaces, the instance itself is not sufficient to identify the
     * endpoint. So, you must also specify the source IP address or VPC network.
     * A reachability analysis proceeds even if the source location is
     * ambiguous. However, the test result may include endpoints that you don't
     * intend to test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint source = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.networkmanagement.v1beta1.Endpoint.Builder getSourceBuilder() {

      onChanged();
      return getSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Source specification of the Connectivity Test.
     * You can use a combination of source IP address, virtual machine
     * (VM) instance, or Compute Engine network to uniquely identify
     * the source location.
     * Examples:
     * If the source IP address is an internal IP address within a Google Cloud
     * Virtual Private Cloud (VPC) network, then you must also specify the VPC
     * network. Otherwise, specify the VM instance, which already contains its
     * internal IP address and VPC network information.
     * If the source of the test is within an on-premises network, then you must
     * provide the destination VPC network.
     * If the source endpoint is a Compute Engine VM instance with multiple
     * network interfaces, the instance itself is not sufficient to identify the
     * endpoint. So, you must also specify the source IP address or VPC network.
     * A reachability analysis proceeds even if the source location is
     * ambiguous. However, the test result may include endpoints that you don't
     * intend to test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint source = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.networkmanagement.v1beta1.EndpointOrBuilder getSourceOrBuilder() {
      if (sourceBuilder_ != null) {
        return sourceBuilder_.getMessageOrBuilder();
      } else {
        return source_ == null
            ? com.google.cloud.networkmanagement.v1beta1.Endpoint.getDefaultInstance()
            : source_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Source specification of the Connectivity Test.
     * You can use a combination of source IP address, virtual machine
     * (VM) instance, or Compute Engine network to uniquely identify
     * the source location.
     * Examples:
     * If the source IP address is an internal IP address within a Google Cloud
     * Virtual Private Cloud (VPC) network, then you must also specify the VPC
     * network. Otherwise, specify the VM instance, which already contains its
     * internal IP address and VPC network information.
     * If the source of the test is within an on-premises network, then you must
     * provide the destination VPC network.
     * If the source endpoint is a Compute Engine VM instance with multiple
     * network interfaces, the instance itself is not sufficient to identify the
     * endpoint. So, you must also specify the source IP address or VPC network.
     * A reachability analysis proceeds even if the source location is
     * ambiguous. However, the test result may include endpoints that you don't
     * intend to test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint source = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.Endpoint,
            com.google.cloud.networkmanagement.v1beta1.Endpoint.Builder,
            com.google.cloud.networkmanagement.v1beta1.EndpointOrBuilder>
        getSourceFieldBuilder() {
      if (sourceBuilder_ == null) {
        sourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.Endpoint,
                com.google.cloud.networkmanagement.v1beta1.Endpoint.Builder,
                com.google.cloud.networkmanagement.v1beta1.EndpointOrBuilder>(
                getSource(), getParentForChildren(), isClean());
        source_ = null;
      }
      return sourceBuilder_;
    }

    private com.google.cloud.networkmanagement.v1beta1.Endpoint destination_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.Endpoint,
            com.google.cloud.networkmanagement.v1beta1.Endpoint.Builder,
            com.google.cloud.networkmanagement.v1beta1.EndpointOrBuilder>
        destinationBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Destination specification of the Connectivity Test.
     * You can use a combination of destination IP address, Compute Engine
     * VM instance, or VPC network to uniquely identify the destination
     * location.
     * Even if the destination IP address is not unique, the source IP
     * location is unique. Usually, the analysis can infer the destination
     * endpoint from route information.
     * If the destination you specify is a VM instance and the instance has
     * multiple network interfaces, then you must also specify either
     * a destination IP address  or VPC network to identify the destination
     * interface.
     * A reachability analysis proceeds even if the destination location is
     * ambiguous. However, the result can include endpoints that you don't
     * intend to test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint destination = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the destination field is set.
     */
    public boolean hasDestination() {
      return destinationBuilder_ != null || destination_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Destination specification of the Connectivity Test.
     * You can use a combination of destination IP address, Compute Engine
     * VM instance, or VPC network to uniquely identify the destination
     * location.
     * Even if the destination IP address is not unique, the source IP
     * location is unique. Usually, the analysis can infer the destination
     * endpoint from route information.
     * If the destination you specify is a VM instance and the instance has
     * multiple network interfaces, then you must also specify either
     * a destination IP address  or VPC network to identify the destination
     * interface.
     * A reachability analysis proceeds even if the destination location is
     * ambiguous. However, the result can include endpoints that you don't
     * intend to test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint destination = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The destination.
     */
    public com.google.cloud.networkmanagement.v1beta1.Endpoint getDestination() {
      if (destinationBuilder_ == null) {
        return destination_ == null
            ? com.google.cloud.networkmanagement.v1beta1.Endpoint.getDefaultInstance()
            : destination_;
      } else {
        return destinationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Destination specification of the Connectivity Test.
     * You can use a combination of destination IP address, Compute Engine
     * VM instance, or VPC network to uniquely identify the destination
     * location.
     * Even if the destination IP address is not unique, the source IP
     * location is unique. Usually, the analysis can infer the destination
     * endpoint from route information.
     * If the destination you specify is a VM instance and the instance has
     * multiple network interfaces, then you must also specify either
     * a destination IP address  or VPC network to identify the destination
     * interface.
     * A reachability analysis proceeds even if the destination location is
     * ambiguous. However, the result can include endpoints that you don't
     * intend to test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint destination = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDestination(com.google.cloud.networkmanagement.v1beta1.Endpoint value) {
      if (destinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
        onChanged();
      } else {
        destinationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Destination specification of the Connectivity Test.
     * You can use a combination of destination IP address, Compute Engine
     * VM instance, or VPC network to uniquely identify the destination
     * location.
     * Even if the destination IP address is not unique, the source IP
     * location is unique. Usually, the analysis can infer the destination
     * endpoint from route information.
     * If the destination you specify is a VM instance and the instance has
     * multiple network interfaces, then you must also specify either
     * a destination IP address  or VPC network to identify the destination
     * interface.
     * A reachability analysis proceeds even if the destination location is
     * ambiguous. However, the result can include endpoints that you don't
     * intend to test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint destination = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDestination(
        com.google.cloud.networkmanagement.v1beta1.Endpoint.Builder builderForValue) {
      if (destinationBuilder_ == null) {
        destination_ = builderForValue.build();
        onChanged();
      } else {
        destinationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Destination specification of the Connectivity Test.
     * You can use a combination of destination IP address, Compute Engine
     * VM instance, or VPC network to uniquely identify the destination
     * location.
     * Even if the destination IP address is not unique, the source IP
     * location is unique. Usually, the analysis can infer the destination
     * endpoint from route information.
     * If the destination you specify is a VM instance and the instance has
     * multiple network interfaces, then you must also specify either
     * a destination IP address  or VPC network to identify the destination
     * interface.
     * A reachability analysis proceeds even if the destination location is
     * ambiguous. However, the result can include endpoints that you don't
     * intend to test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint destination = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeDestination(com.google.cloud.networkmanagement.v1beta1.Endpoint value) {
      if (destinationBuilder_ == null) {
        if (destination_ != null) {
          destination_ =
              com.google.cloud.networkmanagement.v1beta1.Endpoint.newBuilder(destination_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destination_ = value;
        }
        onChanged();
      } else {
        destinationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Destination specification of the Connectivity Test.
     * You can use a combination of destination IP address, Compute Engine
     * VM instance, or VPC network to uniquely identify the destination
     * location.
     * Even if the destination IP address is not unique, the source IP
     * location is unique. Usually, the analysis can infer the destination
     * endpoint from route information.
     * If the destination you specify is a VM instance and the instance has
     * multiple network interfaces, then you must also specify either
     * a destination IP address  or VPC network to identify the destination
     * interface.
     * A reachability analysis proceeds even if the destination location is
     * ambiguous. However, the result can include endpoints that you don't
     * intend to test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint destination = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDestination() {
      if (destinationBuilder_ == null) {
        destination_ = null;
        onChanged();
      } else {
        destination_ = null;
        destinationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Destination specification of the Connectivity Test.
     * You can use a combination of destination IP address, Compute Engine
     * VM instance, or VPC network to uniquely identify the destination
     * location.
     * Even if the destination IP address is not unique, the source IP
     * location is unique. Usually, the analysis can infer the destination
     * endpoint from route information.
     * If the destination you specify is a VM instance and the instance has
     * multiple network interfaces, then you must also specify either
     * a destination IP address  or VPC network to identify the destination
     * interface.
     * A reachability analysis proceeds even if the destination location is
     * ambiguous. However, the result can include endpoints that you don't
     * intend to test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint destination = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.networkmanagement.v1beta1.Endpoint.Builder getDestinationBuilder() {

      onChanged();
      return getDestinationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Destination specification of the Connectivity Test.
     * You can use a combination of destination IP address, Compute Engine
     * VM instance, or VPC network to uniquely identify the destination
     * location.
     * Even if the destination IP address is not unique, the source IP
     * location is unique. Usually, the analysis can infer the destination
     * endpoint from route information.
     * If the destination you specify is a VM instance and the instance has
     * multiple network interfaces, then you must also specify either
     * a destination IP address  or VPC network to identify the destination
     * interface.
     * A reachability analysis proceeds even if the destination location is
     * ambiguous. However, the result can include endpoints that you don't
     * intend to test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint destination = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.networkmanagement.v1beta1.EndpointOrBuilder getDestinationOrBuilder() {
      if (destinationBuilder_ != null) {
        return destinationBuilder_.getMessageOrBuilder();
      } else {
        return destination_ == null
            ? com.google.cloud.networkmanagement.v1beta1.Endpoint.getDefaultInstance()
            : destination_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Destination specification of the Connectivity Test.
     * You can use a combination of destination IP address, Compute Engine
     * VM instance, or VPC network to uniquely identify the destination
     * location.
     * Even if the destination IP address is not unique, the source IP
     * location is unique. Usually, the analysis can infer the destination
     * endpoint from route information.
     * If the destination you specify is a VM instance and the instance has
     * multiple network interfaces, then you must also specify either
     * a destination IP address  or VPC network to identify the destination
     * interface.
     * A reachability analysis proceeds even if the destination location is
     * ambiguous. However, the result can include endpoints that you don't
     * intend to test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.Endpoint destination = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.Endpoint,
            com.google.cloud.networkmanagement.v1beta1.Endpoint.Builder,
            com.google.cloud.networkmanagement.v1beta1.EndpointOrBuilder>
        getDestinationFieldBuilder() {
      if (destinationBuilder_ == null) {
        destinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.Endpoint,
                com.google.cloud.networkmanagement.v1beta1.Endpoint.Builder,
                com.google.cloud.networkmanagement.v1beta1.EndpointOrBuilder>(
                getDestination(), getParentForChildren(), isClean());
        destination_ = null;
      }
      return destinationBuilder_;
    }

    private java.lang.Object protocol_ = "";
    /**
     *
     *
     * <pre>
     * IP Protocol of the test. When not provided, "TCP" is assumed.
     * </pre>
     *
     * <code>string protocol = 5;</code>
     *
     * @return The protocol.
     */
    public java.lang.String getProtocol() {
      java.lang.Object ref = protocol_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        protocol_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * IP Protocol of the test. When not provided, "TCP" is assumed.
     * </pre>
     *
     * <code>string protocol = 5;</code>
     *
     * @return The bytes for protocol.
     */
    public com.google.protobuf.ByteString getProtocolBytes() {
      java.lang.Object ref = protocol_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        protocol_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * IP Protocol of the test. When not provided, "TCP" is assumed.
     * </pre>
     *
     * <code>string protocol = 5;</code>
     *
     * @param value The protocol to set.
     * @return This builder for chaining.
     */
    public Builder setProtocol(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      protocol_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IP Protocol of the test. When not provided, "TCP" is assumed.
     * </pre>
     *
     * <code>string protocol = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtocol() {

      protocol_ = getDefaultInstance().getProtocol();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IP Protocol of the test. When not provided, "TCP" is assumed.
     * </pre>
     *
     * <code>string protocol = 5;</code>
     *
     * @param value The bytes for protocol to set.
     * @return This builder for chaining.
     */
    public Builder setProtocolBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      protocol_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList relatedProjects_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureRelatedProjectsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        relatedProjects_ = new com.google.protobuf.LazyStringArrayList(relatedProjects_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Other projects that may be relevant for reachability analysis.
     * This is applicable to scenarios where a test can cross project boundaries.
     * </pre>
     *
     * <code>repeated string related_projects = 6;</code>
     *
     * @return A list containing the relatedProjects.
     */
    public com.google.protobuf.ProtocolStringList getRelatedProjectsList() {
      return relatedProjects_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Other projects that may be relevant for reachability analysis.
     * This is applicable to scenarios where a test can cross project boundaries.
     * </pre>
     *
     * <code>repeated string related_projects = 6;</code>
     *
     * @return The count of relatedProjects.
     */
    public int getRelatedProjectsCount() {
      return relatedProjects_.size();
    }
    /**
     *
     *
     * <pre>
     * Other projects that may be relevant for reachability analysis.
     * This is applicable to scenarios where a test can cross project boundaries.
     * </pre>
     *
     * <code>repeated string related_projects = 6;</code>
     *
     * @param index The index of the element to return.
     * @return The relatedProjects at the given index.
     */
    public java.lang.String getRelatedProjects(int index) {
      return relatedProjects_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Other projects that may be relevant for reachability analysis.
     * This is applicable to scenarios where a test can cross project boundaries.
     * </pre>
     *
     * <code>repeated string related_projects = 6;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the relatedProjects at the given index.
     */
    public com.google.protobuf.ByteString getRelatedProjectsBytes(int index) {
      return relatedProjects_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Other projects that may be relevant for reachability analysis.
     * This is applicable to scenarios where a test can cross project boundaries.
     * </pre>
     *
     * <code>repeated string related_projects = 6;</code>
     *
     * @param index The index to set the value at.
     * @param value The relatedProjects to set.
     * @return This builder for chaining.
     */
    public Builder setRelatedProjects(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRelatedProjectsIsMutable();
      relatedProjects_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other projects that may be relevant for reachability analysis.
     * This is applicable to scenarios where a test can cross project boundaries.
     * </pre>
     *
     * <code>repeated string related_projects = 6;</code>
     *
     * @param value The relatedProjects to add.
     * @return This builder for chaining.
     */
    public Builder addRelatedProjects(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRelatedProjectsIsMutable();
      relatedProjects_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other projects that may be relevant for reachability analysis.
     * This is applicable to scenarios where a test can cross project boundaries.
     * </pre>
     *
     * <code>repeated string related_projects = 6;</code>
     *
     * @param values The relatedProjects to add.
     * @return This builder for chaining.
     */
    public Builder addAllRelatedProjects(java.lang.Iterable<java.lang.String> values) {
      ensureRelatedProjectsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, relatedProjects_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other projects that may be relevant for reachability analysis.
     * This is applicable to scenarios where a test can cross project boundaries.
     * </pre>
     *
     * <code>repeated string related_projects = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRelatedProjects() {
      relatedProjects_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other projects that may be relevant for reachability analysis.
     * This is applicable to scenarios where a test can cross project boundaries.
     * </pre>
     *
     * <code>repeated string related_projects = 6;</code>
     *
     * @param value The bytes of the relatedProjects to add.
     * @return This builder for chaining.
     */
    public Builder addRelatedProjectsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureRelatedProjectsIsMutable();
      relatedProjects_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The display name of a Connectivity Test.
     * </pre>
     *
     * <code>string display_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of a Connectivity Test.
     * </pre>
     *
     * <code>string display_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of a Connectivity Test.
     * </pre>
     *
     * <code>string display_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of a Connectivity Test.
     * </pre>
     *
     * <code>string display_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of a Connectivity Test.
     * </pre>
     *
     * <code>string display_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user-provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user-provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user-provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user-provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user-provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user-provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user-provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the test was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the test was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the test was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the test was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the test was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the test was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the test was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the test was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the test was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the test's configuration was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the test's configuration was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the test's configuration was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the test's configuration was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the test's configuration was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the test's configuration was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the test's configuration was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the test's configuration was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the test's configuration was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails reachabilityDetails_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails,
            com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Builder,
            com.google.cloud.networkmanagement.v1beta1.ReachabilityDetailsOrBuilder>
        reachabilityDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The reachability details of this test from the latest run.
     * The details are updated when creating a new test, updating an
     * existing test, or triggering a one-time rerun of an existing test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ReachabilityDetails reachability_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the reachabilityDetails field is set.
     */
    public boolean hasReachabilityDetails() {
      return reachabilityDetailsBuilder_ != null || reachabilityDetails_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The reachability details of this test from the latest run.
     * The details are updated when creating a new test, updating an
     * existing test, or triggering a one-time rerun of an existing test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ReachabilityDetails reachability_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The reachabilityDetails.
     */
    public com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails getReachabilityDetails() {
      if (reachabilityDetailsBuilder_ == null) {
        return reachabilityDetails_ == null
            ? com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.getDefaultInstance()
            : reachabilityDetails_;
      } else {
        return reachabilityDetailsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The reachability details of this test from the latest run.
     * The details are updated when creating a new test, updating an
     * existing test, or triggering a one-time rerun of an existing test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ReachabilityDetails reachability_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setReachabilityDetails(
        com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails value) {
      if (reachabilityDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        reachabilityDetails_ = value;
        onChanged();
      } else {
        reachabilityDetailsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The reachability details of this test from the latest run.
     * The details are updated when creating a new test, updating an
     * existing test, or triggering a one-time rerun of an existing test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ReachabilityDetails reachability_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setReachabilityDetails(
        com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Builder builderForValue) {
      if (reachabilityDetailsBuilder_ == null) {
        reachabilityDetails_ = builderForValue.build();
        onChanged();
      } else {
        reachabilityDetailsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The reachability details of this test from the latest run.
     * The details are updated when creating a new test, updating an
     * existing test, or triggering a one-time rerun of an existing test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ReachabilityDetails reachability_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeReachabilityDetails(
        com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails value) {
      if (reachabilityDetailsBuilder_ == null) {
        if (reachabilityDetails_ != null) {
          reachabilityDetails_ =
              com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.newBuilder(
                      reachabilityDetails_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          reachabilityDetails_ = value;
        }
        onChanged();
      } else {
        reachabilityDetailsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The reachability details of this test from the latest run.
     * The details are updated when creating a new test, updating an
     * existing test, or triggering a one-time rerun of an existing test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ReachabilityDetails reachability_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearReachabilityDetails() {
      if (reachabilityDetailsBuilder_ == null) {
        reachabilityDetails_ = null;
        onChanged();
      } else {
        reachabilityDetails_ = null;
        reachabilityDetailsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The reachability details of this test from the latest run.
     * The details are updated when creating a new test, updating an
     * existing test, or triggering a one-time rerun of an existing test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ReachabilityDetails reachability_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Builder
        getReachabilityDetailsBuilder() {

      onChanged();
      return getReachabilityDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The reachability details of this test from the latest run.
     * The details are updated when creating a new test, updating an
     * existing test, or triggering a one-time rerun of an existing test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ReachabilityDetails reachability_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.networkmanagement.v1beta1.ReachabilityDetailsOrBuilder
        getReachabilityDetailsOrBuilder() {
      if (reachabilityDetailsBuilder_ != null) {
        return reachabilityDetailsBuilder_.getMessageOrBuilder();
      } else {
        return reachabilityDetails_ == null
            ? com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.getDefaultInstance()
            : reachabilityDetails_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The reachability details of this test from the latest run.
     * The details are updated when creating a new test, updating an
     * existing test, or triggering a one-time rerun of an existing test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ReachabilityDetails reachability_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails,
            com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Builder,
            com.google.cloud.networkmanagement.v1beta1.ReachabilityDetailsOrBuilder>
        getReachabilityDetailsFieldBuilder() {
      if (reachabilityDetailsBuilder_ == null) {
        reachabilityDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails,
                com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Builder,
                com.google.cloud.networkmanagement.v1beta1.ReachabilityDetailsOrBuilder>(
                getReachabilityDetails(), getParentForChildren(), isClean());
        reachabilityDetails_ = null;
      }
      return reachabilityDetailsBuilder_;
    }

    private com.google.cloud.networkmanagement.v1beta1.ProbingDetails probingDetails_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.ProbingDetails,
            com.google.cloud.networkmanagement.v1beta1.ProbingDetails.Builder,
            com.google.cloud.networkmanagement.v1beta1.ProbingDetailsOrBuilder>
        probingDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The probing details of this test from the latest run, present
     * for applicable tests only. The details are updated when creating a new
     * test, updating an existing test, or triggering a one-time rerun of an
     * existing test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ProbingDetails probing_details = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the probingDetails field is set.
     */
    public boolean hasProbingDetails() {
      return probingDetailsBuilder_ != null || probingDetails_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The probing details of this test from the latest run, present
     * for applicable tests only. The details are updated when creating a new
     * test, updating an existing test, or triggering a one-time rerun of an
     * existing test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ProbingDetails probing_details = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The probingDetails.
     */
    public com.google.cloud.networkmanagement.v1beta1.ProbingDetails getProbingDetails() {
      if (probingDetailsBuilder_ == null) {
        return probingDetails_ == null
            ? com.google.cloud.networkmanagement.v1beta1.ProbingDetails.getDefaultInstance()
            : probingDetails_;
      } else {
        return probingDetailsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The probing details of this test from the latest run, present
     * for applicable tests only. The details are updated when creating a new
     * test, updating an existing test, or triggering a one-time rerun of an
     * existing test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ProbingDetails probing_details = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setProbingDetails(
        com.google.cloud.networkmanagement.v1beta1.ProbingDetails value) {
      if (probingDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        probingDetails_ = value;
        onChanged();
      } else {
        probingDetailsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The probing details of this test from the latest run, present
     * for applicable tests only. The details are updated when creating a new
     * test, updating an existing test, or triggering a one-time rerun of an
     * existing test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ProbingDetails probing_details = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setProbingDetails(
        com.google.cloud.networkmanagement.v1beta1.ProbingDetails.Builder builderForValue) {
      if (probingDetailsBuilder_ == null) {
        probingDetails_ = builderForValue.build();
        onChanged();
      } else {
        probingDetailsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The probing details of this test from the latest run, present
     * for applicable tests only. The details are updated when creating a new
     * test, updating an existing test, or triggering a one-time rerun of an
     * existing test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ProbingDetails probing_details = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeProbingDetails(
        com.google.cloud.networkmanagement.v1beta1.ProbingDetails value) {
      if (probingDetailsBuilder_ == null) {
        if (probingDetails_ != null) {
          probingDetails_ =
              com.google.cloud.networkmanagement.v1beta1.ProbingDetails.newBuilder(probingDetails_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          probingDetails_ = value;
        }
        onChanged();
      } else {
        probingDetailsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The probing details of this test from the latest run, present
     * for applicable tests only. The details are updated when creating a new
     * test, updating an existing test, or triggering a one-time rerun of an
     * existing test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ProbingDetails probing_details = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearProbingDetails() {
      if (probingDetailsBuilder_ == null) {
        probingDetails_ = null;
        onChanged();
      } else {
        probingDetails_ = null;
        probingDetailsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The probing details of this test from the latest run, present
     * for applicable tests only. The details are updated when creating a new
     * test, updating an existing test, or triggering a one-time rerun of an
     * existing test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ProbingDetails probing_details = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.networkmanagement.v1beta1.ProbingDetails.Builder
        getProbingDetailsBuilder() {

      onChanged();
      return getProbingDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The probing details of this test from the latest run, present
     * for applicable tests only. The details are updated when creating a new
     * test, updating an existing test, or triggering a one-time rerun of an
     * existing test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ProbingDetails probing_details = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.networkmanagement.v1beta1.ProbingDetailsOrBuilder
        getProbingDetailsOrBuilder() {
      if (probingDetailsBuilder_ != null) {
        return probingDetailsBuilder_.getMessageOrBuilder();
      } else {
        return probingDetails_ == null
            ? com.google.cloud.networkmanagement.v1beta1.ProbingDetails.getDefaultInstance()
            : probingDetails_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The probing details of this test from the latest run, present
     * for applicable tests only. The details are updated when creating a new
     * test, updating an existing test, or triggering a one-time rerun of an
     * existing test.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ProbingDetails probing_details = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.ProbingDetails,
            com.google.cloud.networkmanagement.v1beta1.ProbingDetails.Builder,
            com.google.cloud.networkmanagement.v1beta1.ProbingDetailsOrBuilder>
        getProbingDetailsFieldBuilder() {
      if (probingDetailsBuilder_ == null) {
        probingDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.ProbingDetails,
                com.google.cloud.networkmanagement.v1beta1.ProbingDetails.Builder,
                com.google.cloud.networkmanagement.v1beta1.ProbingDetailsOrBuilder>(
                getProbingDetails(), getParentForChildren(), isClean());
        probingDetails_ = null;
      }
      return probingDetailsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkmanagement.v1beta1.ConnectivityTest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkmanagement.v1beta1.ConnectivityTest)
  private static final com.google.cloud.networkmanagement.v1beta1.ConnectivityTest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkmanagement.v1beta1.ConnectivityTest();
  }

  public static com.google.cloud.networkmanagement.v1beta1.ConnectivityTest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ConnectivityTest> PARSER =
      new com.google.protobuf.AbstractParser<ConnectivityTest>() {
        @java.lang.Override
        public ConnectivityTest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ConnectivityTest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ConnectivityTest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.ConnectivityTest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
