/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datastream/v1/datastream_resources.proto

package com.google.cloud.datastream.v1;

/**
 *
 *
 * <pre>
 * A specific stream object (e.g a specific DB table).
 * </pre>
 *
 * Protobuf type {@code google.cloud.datastream.v1.StreamObject}
 */
public final class StreamObject extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datastream.v1.StreamObject)
    StreamObjectOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StreamObject.newBuilder() to construct.
  private StreamObject(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StreamObject() {
    name_ = "";
    displayName_ = "";
    errors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StreamObject();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datastream.v1.DatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1_StreamObject_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datastream.v1.DatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1_StreamObject_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datastream.v1.StreamObject.class,
            com.google.cloud.datastream.v1.StreamObject.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. The object resource's name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The object resource's name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The creation time of the object.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation time of the object.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation time of the object.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last update time of the object.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update time of the object.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update time of the object.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 5;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Required. Display name.
   * </pre>
   *
   * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Display name.
   * </pre>
   *
   * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ERRORS_FIELD_NUMBER = 6;
  private java.util.List<com.google.cloud.datastream.v1.Error> errors_;
  /**
   *
   *
   * <pre>
   * Output only. Active errors on the object.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datastream.v1.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.datastream.v1.Error> getErrorsList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Active errors on the object.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datastream.v1.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.datastream.v1.ErrorOrBuilder>
      getErrorsOrBuilderList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Active errors on the object.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datastream.v1.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getErrorsCount() {
    return errors_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Active errors on the object.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datastream.v1.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.Error getErrors(int index) {
    return errors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Active errors on the object.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datastream.v1.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.ErrorOrBuilder getErrorsOrBuilder(int index) {
    return errors_.get(index);
  }

  public static final int BACKFILL_JOB_FIELD_NUMBER = 7;
  private com.google.cloud.datastream.v1.BackfillJob backfillJob_;
  /**
   *
   *
   * <pre>
   * The latest backfill job that was initiated for the stream object.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.BackfillJob backfill_job = 7;</code>
   *
   * @return Whether the backfillJob field is set.
   */
  @java.lang.Override
  public boolean hasBackfillJob() {
    return backfillJob_ != null;
  }
  /**
   *
   *
   * <pre>
   * The latest backfill job that was initiated for the stream object.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.BackfillJob backfill_job = 7;</code>
   *
   * @return The backfillJob.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.BackfillJob getBackfillJob() {
    return backfillJob_ == null
        ? com.google.cloud.datastream.v1.BackfillJob.getDefaultInstance()
        : backfillJob_;
  }
  /**
   *
   *
   * <pre>
   * The latest backfill job that was initiated for the stream object.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.BackfillJob backfill_job = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.BackfillJobOrBuilder getBackfillJobOrBuilder() {
    return getBackfillJob();
  }

  public static final int SOURCE_OBJECT_FIELD_NUMBER = 8;
  private com.google.cloud.datastream.v1.SourceObjectIdentifier sourceObject_;
  /**
   *
   *
   * <pre>
   * The object identifier in the data source.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.SourceObjectIdentifier source_object = 8;</code>
   *
   * @return Whether the sourceObject field is set.
   */
  @java.lang.Override
  public boolean hasSourceObject() {
    return sourceObject_ != null;
  }
  /**
   *
   *
   * <pre>
   * The object identifier in the data source.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.SourceObjectIdentifier source_object = 8;</code>
   *
   * @return The sourceObject.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.SourceObjectIdentifier getSourceObject() {
    return sourceObject_ == null
        ? com.google.cloud.datastream.v1.SourceObjectIdentifier.getDefaultInstance()
        : sourceObject_;
  }
  /**
   *
   *
   * <pre>
   * The object identifier in the data source.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.SourceObjectIdentifier source_object = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.SourceObjectIdentifierOrBuilder getSourceObjectOrBuilder() {
    return getSourceObject();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(3, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, displayName_);
    }
    for (int i = 0; i < errors_.size(); i++) {
      output.writeMessage(6, errors_.get(i));
    }
    if (backfillJob_ != null) {
      output.writeMessage(7, getBackfillJob());
    }
    if (sourceObject_ != null) {
      output.writeMessage(8, getSourceObject());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, displayName_);
    }
    for (int i = 0; i < errors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, errors_.get(i));
    }
    if (backfillJob_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getBackfillJob());
    }
    if (sourceObject_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getSourceObject());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datastream.v1.StreamObject)) {
      return super.equals(obj);
    }
    com.google.cloud.datastream.v1.StreamObject other =
        (com.google.cloud.datastream.v1.StreamObject) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getErrorsList().equals(other.getErrorsList())) return false;
    if (hasBackfillJob() != other.hasBackfillJob()) return false;
    if (hasBackfillJob()) {
      if (!getBackfillJob().equals(other.getBackfillJob())) return false;
    }
    if (hasSourceObject() != other.hasSourceObject()) return false;
    if (hasSourceObject()) {
      if (!getSourceObject().equals(other.getSourceObject())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (getErrorsCount() > 0) {
      hash = (37 * hash) + ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getErrorsList().hashCode();
    }
    if (hasBackfillJob()) {
      hash = (37 * hash) + BACKFILL_JOB_FIELD_NUMBER;
      hash = (53 * hash) + getBackfillJob().hashCode();
    }
    if (hasSourceObject()) {
      hash = (37 * hash) + SOURCE_OBJECT_FIELD_NUMBER;
      hash = (53 * hash) + getSourceObject().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datastream.v1.StreamObject parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.StreamObject parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.StreamObject parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.StreamObject parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.StreamObject parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.StreamObject parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.StreamObject parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.StreamObject parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.StreamObject parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.StreamObject parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.StreamObject parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.StreamObject parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datastream.v1.StreamObject prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A specific stream object (e.g a specific DB table).
   * </pre>
   *
   * Protobuf type {@code google.cloud.datastream.v1.StreamObject}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datastream.v1.StreamObject)
      com.google.cloud.datastream.v1.StreamObjectOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_StreamObject_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_StreamObject_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datastream.v1.StreamObject.class,
              com.google.cloud.datastream.v1.StreamObject.Builder.class);
    }

    // Construct using com.google.cloud.datastream.v1.StreamObject.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      displayName_ = "";

      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
      } else {
        errors_ = null;
        errorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (backfillJobBuilder_ == null) {
        backfillJob_ = null;
      } else {
        backfillJob_ = null;
        backfillJobBuilder_ = null;
      }
      if (sourceObjectBuilder_ == null) {
        sourceObject_ = null;
      } else {
        sourceObject_ = null;
        sourceObjectBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_StreamObject_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.StreamObject getDefaultInstanceForType() {
      return com.google.cloud.datastream.v1.StreamObject.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.StreamObject build() {
      com.google.cloud.datastream.v1.StreamObject result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.StreamObject buildPartial() {
      com.google.cloud.datastream.v1.StreamObject result =
          new com.google.cloud.datastream.v1.StreamObject(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      result.displayName_ = displayName_;
      if (errorsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          errors_ = java.util.Collections.unmodifiableList(errors_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.errors_ = errors_;
      } else {
        result.errors_ = errorsBuilder_.build();
      }
      if (backfillJobBuilder_ == null) {
        result.backfillJob_ = backfillJob_;
      } else {
        result.backfillJob_ = backfillJobBuilder_.build();
      }
      if (sourceObjectBuilder_ == null) {
        result.sourceObject_ = sourceObject_;
      } else {
        result.sourceObject_ = sourceObjectBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datastream.v1.StreamObject) {
        return mergeFrom((com.google.cloud.datastream.v1.StreamObject) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datastream.v1.StreamObject other) {
      if (other == com.google.cloud.datastream.v1.StreamObject.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (errorsBuilder_ == null) {
        if (!other.errors_.isEmpty()) {
          if (errors_.isEmpty()) {
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureErrorsIsMutable();
            errors_.addAll(other.errors_);
          }
          onChanged();
        }
      } else {
        if (!other.errors_.isEmpty()) {
          if (errorsBuilder_.isEmpty()) {
            errorsBuilder_.dispose();
            errorsBuilder_ = null;
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000001);
            errorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getErrorsFieldBuilder()
                    : null;
          } else {
            errorsBuilder_.addAllMessages(other.errors_);
          }
        }
      }
      if (other.hasBackfillJob()) {
        mergeBackfillJob(other.getBackfillJob());
      }
      if (other.hasSourceObject()) {
        mergeSourceObject(other.getSourceObject());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 42:
              {
                displayName_ = input.readStringRequireUtf8();

                break;
              } // case 42
            case 50:
              {
                com.google.cloud.datastream.v1.Error m =
                    input.readMessage(
                        com.google.cloud.datastream.v1.Error.parser(), extensionRegistry);
                if (errorsBuilder_ == null) {
                  ensureErrorsIsMutable();
                  errors_.add(m);
                } else {
                  errorsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getBackfillJobFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 58
            case 66:
              {
                input.readMessage(getSourceObjectFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The object resource's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The object resource's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The object resource's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The object resource's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The object resource's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last update time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. Display name.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Display name.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Display name.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Display name.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Display name.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.datastream.v1.Error> errors_ =
        java.util.Collections.emptyList();

    private void ensureErrorsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        errors_ = new java.util.ArrayList<com.google.cloud.datastream.v1.Error>(errors_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datastream.v1.Error,
            com.google.cloud.datastream.v1.Error.Builder,
            com.google.cloud.datastream.v1.ErrorOrBuilder>
        errorsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Active errors on the object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.datastream.v1.Error> getErrorsList() {
      if (errorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(errors_);
      } else {
        return errorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Active errors on the object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getErrorsCount() {
      if (errorsBuilder_ == null) {
        return errors_.size();
      } else {
        return errorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Active errors on the object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datastream.v1.Error getErrors(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Active errors on the object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setErrors(int index, com.google.cloud.datastream.v1.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.set(index, value);
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Active errors on the object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setErrors(
        int index, com.google.cloud.datastream.v1.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.set(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Active errors on the object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrors(com.google.cloud.datastream.v1.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Active errors on the object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrors(int index, com.google.cloud.datastream.v1.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(index, value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Active errors on the object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrors(com.google.cloud.datastream.v1.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Active errors on the object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrors(
        int index, com.google.cloud.datastream.v1.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Active errors on the object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllErrors(
        java.lang.Iterable<? extends com.google.cloud.datastream.v1.Error> values) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, errors_);
        onChanged();
      } else {
        errorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Active errors on the object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearErrors() {
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        errorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Active errors on the object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeErrors(int index) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.remove(index);
        onChanged();
      } else {
        errorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Active errors on the object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datastream.v1.Error.Builder getErrorsBuilder(int index) {
      return getErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Active errors on the object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datastream.v1.ErrorOrBuilder getErrorsOrBuilder(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Active errors on the object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.datastream.v1.ErrorOrBuilder>
        getErrorsOrBuilderList() {
      if (errorsBuilder_ != null) {
        return errorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(errors_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Active errors on the object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datastream.v1.Error.Builder addErrorsBuilder() {
      return getErrorsFieldBuilder()
          .addBuilder(com.google.cloud.datastream.v1.Error.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Active errors on the object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datastream.v1.Error.Builder addErrorsBuilder(int index) {
      return getErrorsFieldBuilder()
          .addBuilder(index, com.google.cloud.datastream.v1.Error.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Active errors on the object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.datastream.v1.Error.Builder> getErrorsBuilderList() {
      return getErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datastream.v1.Error,
            com.google.cloud.datastream.v1.Error.Builder,
            com.google.cloud.datastream.v1.ErrorOrBuilder>
        getErrorsFieldBuilder() {
      if (errorsBuilder_ == null) {
        errorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datastream.v1.Error,
                com.google.cloud.datastream.v1.Error.Builder,
                com.google.cloud.datastream.v1.ErrorOrBuilder>(
                errors_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        errors_ = null;
      }
      return errorsBuilder_;
    }

    private com.google.cloud.datastream.v1.BackfillJob backfillJob_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.BackfillJob,
            com.google.cloud.datastream.v1.BackfillJob.Builder,
            com.google.cloud.datastream.v1.BackfillJobOrBuilder>
        backfillJobBuilder_;
    /**
     *
     *
     * <pre>
     * The latest backfill job that was initiated for the stream object.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.BackfillJob backfill_job = 7;</code>
     *
     * @return Whether the backfillJob field is set.
     */
    public boolean hasBackfillJob() {
      return backfillJobBuilder_ != null || backfillJob_ != null;
    }
    /**
     *
     *
     * <pre>
     * The latest backfill job that was initiated for the stream object.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.BackfillJob backfill_job = 7;</code>
     *
     * @return The backfillJob.
     */
    public com.google.cloud.datastream.v1.BackfillJob getBackfillJob() {
      if (backfillJobBuilder_ == null) {
        return backfillJob_ == null
            ? com.google.cloud.datastream.v1.BackfillJob.getDefaultInstance()
            : backfillJob_;
      } else {
        return backfillJobBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The latest backfill job that was initiated for the stream object.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.BackfillJob backfill_job = 7;</code>
     */
    public Builder setBackfillJob(com.google.cloud.datastream.v1.BackfillJob value) {
      if (backfillJobBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        backfillJob_ = value;
        onChanged();
      } else {
        backfillJobBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The latest backfill job that was initiated for the stream object.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.BackfillJob backfill_job = 7;</code>
     */
    public Builder setBackfillJob(
        com.google.cloud.datastream.v1.BackfillJob.Builder builderForValue) {
      if (backfillJobBuilder_ == null) {
        backfillJob_ = builderForValue.build();
        onChanged();
      } else {
        backfillJobBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The latest backfill job that was initiated for the stream object.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.BackfillJob backfill_job = 7;</code>
     */
    public Builder mergeBackfillJob(com.google.cloud.datastream.v1.BackfillJob value) {
      if (backfillJobBuilder_ == null) {
        if (backfillJob_ != null) {
          backfillJob_ =
              com.google.cloud.datastream.v1.BackfillJob.newBuilder(backfillJob_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          backfillJob_ = value;
        }
        onChanged();
      } else {
        backfillJobBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The latest backfill job that was initiated for the stream object.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.BackfillJob backfill_job = 7;</code>
     */
    public Builder clearBackfillJob() {
      if (backfillJobBuilder_ == null) {
        backfillJob_ = null;
        onChanged();
      } else {
        backfillJob_ = null;
        backfillJobBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The latest backfill job that was initiated for the stream object.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.BackfillJob backfill_job = 7;</code>
     */
    public com.google.cloud.datastream.v1.BackfillJob.Builder getBackfillJobBuilder() {

      onChanged();
      return getBackfillJobFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The latest backfill job that was initiated for the stream object.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.BackfillJob backfill_job = 7;</code>
     */
    public com.google.cloud.datastream.v1.BackfillJobOrBuilder getBackfillJobOrBuilder() {
      if (backfillJobBuilder_ != null) {
        return backfillJobBuilder_.getMessageOrBuilder();
      } else {
        return backfillJob_ == null
            ? com.google.cloud.datastream.v1.BackfillJob.getDefaultInstance()
            : backfillJob_;
      }
    }
    /**
     *
     *
     * <pre>
     * The latest backfill job that was initiated for the stream object.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.BackfillJob backfill_job = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.BackfillJob,
            com.google.cloud.datastream.v1.BackfillJob.Builder,
            com.google.cloud.datastream.v1.BackfillJobOrBuilder>
        getBackfillJobFieldBuilder() {
      if (backfillJobBuilder_ == null) {
        backfillJobBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1.BackfillJob,
                com.google.cloud.datastream.v1.BackfillJob.Builder,
                com.google.cloud.datastream.v1.BackfillJobOrBuilder>(
                getBackfillJob(), getParentForChildren(), isClean());
        backfillJob_ = null;
      }
      return backfillJobBuilder_;
    }

    private com.google.cloud.datastream.v1.SourceObjectIdentifier sourceObject_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.SourceObjectIdentifier,
            com.google.cloud.datastream.v1.SourceObjectIdentifier.Builder,
            com.google.cloud.datastream.v1.SourceObjectIdentifierOrBuilder>
        sourceObjectBuilder_;
    /**
     *
     *
     * <pre>
     * The object identifier in the data source.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.SourceObjectIdentifier source_object = 8;</code>
     *
     * @return Whether the sourceObject field is set.
     */
    public boolean hasSourceObject() {
      return sourceObjectBuilder_ != null || sourceObject_ != null;
    }
    /**
     *
     *
     * <pre>
     * The object identifier in the data source.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.SourceObjectIdentifier source_object = 8;</code>
     *
     * @return The sourceObject.
     */
    public com.google.cloud.datastream.v1.SourceObjectIdentifier getSourceObject() {
      if (sourceObjectBuilder_ == null) {
        return sourceObject_ == null
            ? com.google.cloud.datastream.v1.SourceObjectIdentifier.getDefaultInstance()
            : sourceObject_;
      } else {
        return sourceObjectBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The object identifier in the data source.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.SourceObjectIdentifier source_object = 8;</code>
     */
    public Builder setSourceObject(com.google.cloud.datastream.v1.SourceObjectIdentifier value) {
      if (sourceObjectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceObject_ = value;
        onChanged();
      } else {
        sourceObjectBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The object identifier in the data source.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.SourceObjectIdentifier source_object = 8;</code>
     */
    public Builder setSourceObject(
        com.google.cloud.datastream.v1.SourceObjectIdentifier.Builder builderForValue) {
      if (sourceObjectBuilder_ == null) {
        sourceObject_ = builderForValue.build();
        onChanged();
      } else {
        sourceObjectBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The object identifier in the data source.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.SourceObjectIdentifier source_object = 8;</code>
     */
    public Builder mergeSourceObject(com.google.cloud.datastream.v1.SourceObjectIdentifier value) {
      if (sourceObjectBuilder_ == null) {
        if (sourceObject_ != null) {
          sourceObject_ =
              com.google.cloud.datastream.v1.SourceObjectIdentifier.newBuilder(sourceObject_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sourceObject_ = value;
        }
        onChanged();
      } else {
        sourceObjectBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The object identifier in the data source.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.SourceObjectIdentifier source_object = 8;</code>
     */
    public Builder clearSourceObject() {
      if (sourceObjectBuilder_ == null) {
        sourceObject_ = null;
        onChanged();
      } else {
        sourceObject_ = null;
        sourceObjectBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The object identifier in the data source.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.SourceObjectIdentifier source_object = 8;</code>
     */
    public com.google.cloud.datastream.v1.SourceObjectIdentifier.Builder getSourceObjectBuilder() {

      onChanged();
      return getSourceObjectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The object identifier in the data source.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.SourceObjectIdentifier source_object = 8;</code>
     */
    public com.google.cloud.datastream.v1.SourceObjectIdentifierOrBuilder
        getSourceObjectOrBuilder() {
      if (sourceObjectBuilder_ != null) {
        return sourceObjectBuilder_.getMessageOrBuilder();
      } else {
        return sourceObject_ == null
            ? com.google.cloud.datastream.v1.SourceObjectIdentifier.getDefaultInstance()
            : sourceObject_;
      }
    }
    /**
     *
     *
     * <pre>
     * The object identifier in the data source.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.SourceObjectIdentifier source_object = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.SourceObjectIdentifier,
            com.google.cloud.datastream.v1.SourceObjectIdentifier.Builder,
            com.google.cloud.datastream.v1.SourceObjectIdentifierOrBuilder>
        getSourceObjectFieldBuilder() {
      if (sourceObjectBuilder_ == null) {
        sourceObjectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1.SourceObjectIdentifier,
                com.google.cloud.datastream.v1.SourceObjectIdentifier.Builder,
                com.google.cloud.datastream.v1.SourceObjectIdentifierOrBuilder>(
                getSourceObject(), getParentForChildren(), isClean());
        sourceObject_ = null;
      }
      return sourceObjectBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datastream.v1.StreamObject)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datastream.v1.StreamObject)
  private static final com.google.cloud.datastream.v1.StreamObject DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datastream.v1.StreamObject();
  }

  public static com.google.cloud.datastream.v1.StreamObject getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StreamObject> PARSER =
      new com.google.protobuf.AbstractParser<StreamObject>() {
        @java.lang.Override
        public StreamObject parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StreamObject> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StreamObject> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datastream.v1.StreamObject getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
