/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datastream/v1/datastream_resources.proto

package com.google.cloud.datastream.v1;

/**
 *
 *
 * <pre>
 * Represents an identifier of an object in the data source.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datastream.v1.SourceObjectIdentifier}
 */
public final class SourceObjectIdentifier extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datastream.v1.SourceObjectIdentifier)
    SourceObjectIdentifierOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SourceObjectIdentifier.newBuilder() to construct.
  private SourceObjectIdentifier(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SourceObjectIdentifier() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SourceObjectIdentifier();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datastream.v1.DatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1_SourceObjectIdentifier_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datastream.v1.DatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1_SourceObjectIdentifier_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datastream.v1.SourceObjectIdentifier.class,
            com.google.cloud.datastream.v1.SourceObjectIdentifier.Builder.class);
  }

  public interface OracleObjectIdentifierOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The schema name.
     * </pre>
     *
     * <code>string schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The schema.
     */
    java.lang.String getSchema();
    /**
     *
     *
     * <pre>
     * Required. The schema name.
     * </pre>
     *
     * <code>string schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for schema.
     */
    com.google.protobuf.ByteString getSchemaBytes();

    /**
     *
     *
     * <pre>
     * Required. The table name.
     * </pre>
     *
     * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The table.
     */
    java.lang.String getTable();
    /**
     *
     *
     * <pre>
     * Required. The table name.
     * </pre>
     *
     * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for table.
     */
    com.google.protobuf.ByteString getTableBytes();
  }
  /**
   *
   *
   * <pre>
   * Oracle data source object identifier.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier}
   */
  public static final class OracleObjectIdentifier extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier)
      OracleObjectIdentifierOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OracleObjectIdentifier.newBuilder() to construct.
    private OracleObjectIdentifier(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OracleObjectIdentifier() {
      schema_ = "";
      table_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OracleObjectIdentifier();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_SourceObjectIdentifier_OracleObjectIdentifier_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_SourceObjectIdentifier_OracleObjectIdentifier_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier.class,
              com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier.Builder
                  .class);
    }

    public static final int SCHEMA_FIELD_NUMBER = 1;
    private volatile java.lang.Object schema_;
    /**
     *
     *
     * <pre>
     * Required. The schema name.
     * </pre>
     *
     * <code>string schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The schema.
     */
    @java.lang.Override
    public java.lang.String getSchema() {
      java.lang.Object ref = schema_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schema_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The schema name.
     * </pre>
     *
     * <code>string schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for schema.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSchemaBytes() {
      java.lang.Object ref = schema_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        schema_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TABLE_FIELD_NUMBER = 2;
    private volatile java.lang.Object table_;
    /**
     *
     *
     * <pre>
     * Required. The table name.
     * </pre>
     *
     * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The table.
     */
    @java.lang.Override
    public java.lang.String getTable() {
      java.lang.Object ref = table_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        table_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The table name.
     * </pre>
     *
     * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for table.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTableBytes() {
      java.lang.Object ref = table_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        table_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schema_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, schema_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, table_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schema_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, schema_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, table_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier)) {
        return super.equals(obj);
      }
      com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier other =
          (com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier) obj;

      if (!getSchema().equals(other.getSchema())) return false;
      if (!getTable().equals(other.getTable())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SCHEMA_FIELD_NUMBER;
      hash = (53 * hash) + getSchema().hashCode();
      hash = (37 * hash) + TABLE_FIELD_NUMBER;
      hash = (53 * hash) + getTable().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Oracle data source object identifier.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier)
        com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifierOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datastream.v1.DatastreamResourcesProto
            .internal_static_google_cloud_datastream_v1_SourceObjectIdentifier_OracleObjectIdentifier_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datastream.v1.DatastreamResourcesProto
            .internal_static_google_cloud_datastream_v1_SourceObjectIdentifier_OracleObjectIdentifier_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier.class,
                com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        schema_ = "";

        table_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.datastream.v1.DatastreamResourcesProto
            .internal_static_google_cloud_datastream_v1_SourceObjectIdentifier_OracleObjectIdentifier_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
          getDefaultInstanceForType() {
        return com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier build() {
        com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
          buildPartial() {
        com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier result =
            new com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier(this);
        result.schema_ = schema_;
        result.table_ = table_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier) {
          return mergeFrom(
              (com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier other) {
        if (other
            == com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
                .getDefaultInstance()) return this;
        if (!other.getSchema().isEmpty()) {
          schema_ = other.schema_;
          onChanged();
        }
        if (!other.getTable().isEmpty()) {
          table_ = other.table_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  schema_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  table_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object schema_ = "";
      /**
       *
       *
       * <pre>
       * Required. The schema name.
       * </pre>
       *
       * <code>string schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The schema.
       */
      public java.lang.String getSchema() {
        java.lang.Object ref = schema_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          schema_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The schema name.
       * </pre>
       *
       * <code>string schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for schema.
       */
      public com.google.protobuf.ByteString getSchemaBytes() {
        java.lang.Object ref = schema_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          schema_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The schema name.
       * </pre>
       *
       * <code>string schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The schema to set.
       * @return This builder for chaining.
       */
      public Builder setSchema(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        schema_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The schema name.
       * </pre>
       *
       * <code>string schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSchema() {

        schema_ = getDefaultInstance().getSchema();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The schema name.
       * </pre>
       *
       * <code>string schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for schema to set.
       * @return This builder for chaining.
       */
      public Builder setSchemaBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        schema_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object table_ = "";
      /**
       *
       *
       * <pre>
       * Required. The table name.
       * </pre>
       *
       * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The table.
       */
      public java.lang.String getTable() {
        java.lang.Object ref = table_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          table_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The table name.
       * </pre>
       *
       * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for table.
       */
      public com.google.protobuf.ByteString getTableBytes() {
        java.lang.Object ref = table_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          table_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The table name.
       * </pre>
       *
       * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The table to set.
       * @return This builder for chaining.
       */
      public Builder setTable(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        table_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The table name.
       * </pre>
       *
       * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTable() {

        table_ = getDefaultInstance().getTable();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The table name.
       * </pre>
       *
       * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for table to set.
       * @return This builder for chaining.
       */
      public Builder setTableBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        table_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier)
    private static final com.google.cloud.datastream.v1.SourceObjectIdentifier
            .OracleObjectIdentifier
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier();
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OracleObjectIdentifier> PARSER =
        new com.google.protobuf.AbstractParser<OracleObjectIdentifier>() {
          @java.lang.Override
          public OracleObjectIdentifier parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OracleObjectIdentifier> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OracleObjectIdentifier> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PostgresqlObjectIdentifierOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The schema name.
     * </pre>
     *
     * <code>string schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The schema.
     */
    java.lang.String getSchema();
    /**
     *
     *
     * <pre>
     * Required. The schema name.
     * </pre>
     *
     * <code>string schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for schema.
     */
    com.google.protobuf.ByteString getSchemaBytes();

    /**
     *
     *
     * <pre>
     * Required. The table name.
     * </pre>
     *
     * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The table.
     */
    java.lang.String getTable();
    /**
     *
     *
     * <pre>
     * Required. The table name.
     * </pre>
     *
     * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for table.
     */
    com.google.protobuf.ByteString getTableBytes();
  }
  /**
   *
   *
   * <pre>
   * PostgreSQL data source object identifier.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier}
   */
  public static final class PostgresqlObjectIdentifier
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier)
      PostgresqlObjectIdentifierOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PostgresqlObjectIdentifier.newBuilder() to construct.
    private PostgresqlObjectIdentifier(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PostgresqlObjectIdentifier() {
      schema_ = "";
      table_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PostgresqlObjectIdentifier();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_SourceObjectIdentifier_PostgresqlObjectIdentifier_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_SourceObjectIdentifier_PostgresqlObjectIdentifier_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
                  .class,
              com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
                  .Builder.class);
    }

    public static final int SCHEMA_FIELD_NUMBER = 1;
    private volatile java.lang.Object schema_;
    /**
     *
     *
     * <pre>
     * Required. The schema name.
     * </pre>
     *
     * <code>string schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The schema.
     */
    @java.lang.Override
    public java.lang.String getSchema() {
      java.lang.Object ref = schema_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schema_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The schema name.
     * </pre>
     *
     * <code>string schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for schema.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSchemaBytes() {
      java.lang.Object ref = schema_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        schema_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TABLE_FIELD_NUMBER = 2;
    private volatile java.lang.Object table_;
    /**
     *
     *
     * <pre>
     * Required. The table name.
     * </pre>
     *
     * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The table.
     */
    @java.lang.Override
    public java.lang.String getTable() {
      java.lang.Object ref = table_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        table_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The table name.
     * </pre>
     *
     * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for table.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTableBytes() {
      java.lang.Object ref = table_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        table_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schema_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, schema_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, table_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schema_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, schema_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, table_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier)) {
        return super.equals(obj);
      }
      com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier other =
          (com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier) obj;

      if (!getSchema().equals(other.getSchema())) return false;
      if (!getTable().equals(other.getTable())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SCHEMA_FIELD_NUMBER;
      hash = (53 * hash) + getSchema().hashCode();
      hash = (37 * hash) + TABLE_FIELD_NUMBER;
      hash = (53 * hash) + getTable().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL data source object identifier.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier)
        com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifierOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datastream.v1.DatastreamResourcesProto
            .internal_static_google_cloud_datastream_v1_SourceObjectIdentifier_PostgresqlObjectIdentifier_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datastream.v1.DatastreamResourcesProto
            .internal_static_google_cloud_datastream_v1_SourceObjectIdentifier_PostgresqlObjectIdentifier_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
                    .class,
                com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        schema_ = "";

        table_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.datastream.v1.DatastreamResourcesProto
            .internal_static_google_cloud_datastream_v1_SourceObjectIdentifier_PostgresqlObjectIdentifier_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
          getDefaultInstanceForType() {
        return com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
          build() {
        com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
          buildPartial() {
        com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier result =
            new com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier(
                this);
        result.schema_ = schema_;
        result.table_ = table_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier) {
          return mergeFrom(
              (com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier other) {
        if (other
            == com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
                .getDefaultInstance()) return this;
        if (!other.getSchema().isEmpty()) {
          schema_ = other.schema_;
          onChanged();
        }
        if (!other.getTable().isEmpty()) {
          table_ = other.table_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  schema_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  table_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object schema_ = "";
      /**
       *
       *
       * <pre>
       * Required. The schema name.
       * </pre>
       *
       * <code>string schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The schema.
       */
      public java.lang.String getSchema() {
        java.lang.Object ref = schema_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          schema_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The schema name.
       * </pre>
       *
       * <code>string schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for schema.
       */
      public com.google.protobuf.ByteString getSchemaBytes() {
        java.lang.Object ref = schema_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          schema_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The schema name.
       * </pre>
       *
       * <code>string schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The schema to set.
       * @return This builder for chaining.
       */
      public Builder setSchema(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        schema_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The schema name.
       * </pre>
       *
       * <code>string schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSchema() {

        schema_ = getDefaultInstance().getSchema();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The schema name.
       * </pre>
       *
       * <code>string schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for schema to set.
       * @return This builder for chaining.
       */
      public Builder setSchemaBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        schema_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object table_ = "";
      /**
       *
       *
       * <pre>
       * Required. The table name.
       * </pre>
       *
       * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The table.
       */
      public java.lang.String getTable() {
        java.lang.Object ref = table_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          table_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The table name.
       * </pre>
       *
       * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for table.
       */
      public com.google.protobuf.ByteString getTableBytes() {
        java.lang.Object ref = table_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          table_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The table name.
       * </pre>
       *
       * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The table to set.
       * @return This builder for chaining.
       */
      public Builder setTable(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        table_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The table name.
       * </pre>
       *
       * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTable() {

        table_ = getDefaultInstance().getTable();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The table name.
       * </pre>
       *
       * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for table to set.
       * @return This builder for chaining.
       */
      public Builder setTableBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        table_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier)
    private static final com.google.cloud.datastream.v1.SourceObjectIdentifier
            .PostgresqlObjectIdentifier
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier();
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PostgresqlObjectIdentifier> PARSER =
        new com.google.protobuf.AbstractParser<PostgresqlObjectIdentifier>() {
          @java.lang.Override
          public PostgresqlObjectIdentifier parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PostgresqlObjectIdentifier> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PostgresqlObjectIdentifier> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MysqlObjectIdentifierOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The database name.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The database.
     */
    java.lang.String getDatabase();
    /**
     *
     *
     * <pre>
     * Required. The database name.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for database.
     */
    com.google.protobuf.ByteString getDatabaseBytes();

    /**
     *
     *
     * <pre>
     * Required. The table name.
     * </pre>
     *
     * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The table.
     */
    java.lang.String getTable();
    /**
     *
     *
     * <pre>
     * Required. The table name.
     * </pre>
     *
     * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for table.
     */
    com.google.protobuf.ByteString getTableBytes();
  }
  /**
   *
   *
   * <pre>
   * Mysql data source object identifier.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier}
   */
  public static final class MysqlObjectIdentifier extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier)
      MysqlObjectIdentifierOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MysqlObjectIdentifier.newBuilder() to construct.
    private MysqlObjectIdentifier(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MysqlObjectIdentifier() {
      database_ = "";
      table_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MysqlObjectIdentifier();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_SourceObjectIdentifier_MysqlObjectIdentifier_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_SourceObjectIdentifier_MysqlObjectIdentifier_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier.class,
              com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier.Builder
                  .class);
    }

    public static final int DATABASE_FIELD_NUMBER = 1;
    private volatile java.lang.Object database_;
    /**
     *
     *
     * <pre>
     * Required. The database name.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The database.
     */
    @java.lang.Override
    public java.lang.String getDatabase() {
      java.lang.Object ref = database_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        database_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The database name.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for database.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDatabaseBytes() {
      java.lang.Object ref = database_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        database_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TABLE_FIELD_NUMBER = 2;
    private volatile java.lang.Object table_;
    /**
     *
     *
     * <pre>
     * Required. The table name.
     * </pre>
     *
     * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The table.
     */
    @java.lang.Override
    public java.lang.String getTable() {
      java.lang.Object ref = table_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        table_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The table name.
     * </pre>
     *
     * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for table.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTableBytes() {
      java.lang.Object ref = table_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        table_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(database_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, database_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, table_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(database_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, database_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, table_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier)) {
        return super.equals(obj);
      }
      com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier other =
          (com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier) obj;

      if (!getDatabase().equals(other.getDatabase())) return false;
      if (!getTable().equals(other.getTable())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DATABASE_FIELD_NUMBER;
      hash = (53 * hash) + getDatabase().hashCode();
      hash = (37 * hash) + TABLE_FIELD_NUMBER;
      hash = (53 * hash) + getTable().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Mysql data source object identifier.
     * </pre>
     *
     * Protobuf type {@code google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier)
        com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifierOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datastream.v1.DatastreamResourcesProto
            .internal_static_google_cloud_datastream_v1_SourceObjectIdentifier_MysqlObjectIdentifier_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datastream.v1.DatastreamResourcesProto
            .internal_static_google_cloud_datastream_v1_SourceObjectIdentifier_MysqlObjectIdentifier_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier.class,
                com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        database_ = "";

        table_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.datastream.v1.DatastreamResourcesProto
            .internal_static_google_cloud_datastream_v1_SourceObjectIdentifier_MysqlObjectIdentifier_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
          getDefaultInstanceForType() {
        return com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier build() {
        com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
          buildPartial() {
        com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier result =
            new com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier(this);
        result.database_ = database_;
        result.table_ = table_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier) {
          return mergeFrom(
              (com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier other) {
        if (other
            == com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
                .getDefaultInstance()) return this;
        if (!other.getDatabase().isEmpty()) {
          database_ = other.database_;
          onChanged();
        }
        if (!other.getTable().isEmpty()) {
          table_ = other.table_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  database_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  table_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object database_ = "";
      /**
       *
       *
       * <pre>
       * Required. The database name.
       * </pre>
       *
       * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The database.
       */
      public java.lang.String getDatabase() {
        java.lang.Object ref = database_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          database_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The database name.
       * </pre>
       *
       * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for database.
       */
      public com.google.protobuf.ByteString getDatabaseBytes() {
        java.lang.Object ref = database_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          database_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The database name.
       * </pre>
       *
       * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The database to set.
       * @return This builder for chaining.
       */
      public Builder setDatabase(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        database_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The database name.
       * </pre>
       *
       * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDatabase() {

        database_ = getDefaultInstance().getDatabase();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The database name.
       * </pre>
       *
       * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for database to set.
       * @return This builder for chaining.
       */
      public Builder setDatabaseBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        database_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object table_ = "";
      /**
       *
       *
       * <pre>
       * Required. The table name.
       * </pre>
       *
       * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The table.
       */
      public java.lang.String getTable() {
        java.lang.Object ref = table_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          table_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The table name.
       * </pre>
       *
       * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for table.
       */
      public com.google.protobuf.ByteString getTableBytes() {
        java.lang.Object ref = table_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          table_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The table name.
       * </pre>
       *
       * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The table to set.
       * @return This builder for chaining.
       */
      public Builder setTable(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        table_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The table name.
       * </pre>
       *
       * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTable() {

        table_ = getDefaultInstance().getTable();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The table name.
       * </pre>
       *
       * <code>string table = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for table to set.
       * @return This builder for chaining.
       */
      public Builder setTableBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        table_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier)
    private static final com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier();
    }

    public static com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MysqlObjectIdentifier> PARSER =
        new com.google.protobuf.AbstractParser<MysqlObjectIdentifier>() {
          @java.lang.Override
          public MysqlObjectIdentifier parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MysqlObjectIdentifier> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MysqlObjectIdentifier> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int sourceIdentifierCase_ = 0;
  private java.lang.Object sourceIdentifier_;

  public enum SourceIdentifierCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ORACLE_IDENTIFIER(1),
    MYSQL_IDENTIFIER(2),
    POSTGRESQL_IDENTIFIER(3),
    SOURCEIDENTIFIER_NOT_SET(0);
    private final int value;

    private SourceIdentifierCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceIdentifierCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceIdentifierCase forNumber(int value) {
      switch (value) {
        case 1:
          return ORACLE_IDENTIFIER;
        case 2:
          return MYSQL_IDENTIFIER;
        case 3:
          return POSTGRESQL_IDENTIFIER;
        case 0:
          return SOURCEIDENTIFIER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceIdentifierCase getSourceIdentifierCase() {
    return SourceIdentifierCase.forNumber(sourceIdentifierCase_);
  }

  public static final int ORACLE_IDENTIFIER_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Oracle data source object identifier.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier oracle_identifier = 1;
   * </code>
   *
   * @return Whether the oracleIdentifier field is set.
   */
  @java.lang.Override
  public boolean hasOracleIdentifier() {
    return sourceIdentifierCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Oracle data source object identifier.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier oracle_identifier = 1;
   * </code>
   *
   * @return The oracleIdentifier.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
      getOracleIdentifier() {
    if (sourceIdentifierCase_ == 1) {
      return (com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier)
          sourceIdentifier_;
    }
    return com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Oracle data source object identifier.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier oracle_identifier = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifierOrBuilder
      getOracleIdentifierOrBuilder() {
    if (sourceIdentifierCase_ == 1) {
      return (com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier)
          sourceIdentifier_;
    }
    return com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
        .getDefaultInstance();
  }

  public static final int MYSQL_IDENTIFIER_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Mysql data source object identifier.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier mysql_identifier = 2;
   * </code>
   *
   * @return Whether the mysqlIdentifier field is set.
   */
  @java.lang.Override
  public boolean hasMysqlIdentifier() {
    return sourceIdentifierCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Mysql data source object identifier.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier mysql_identifier = 2;
   * </code>
   *
   * @return The mysqlIdentifier.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
      getMysqlIdentifier() {
    if (sourceIdentifierCase_ == 2) {
      return (com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier)
          sourceIdentifier_;
    }
    return com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Mysql data source object identifier.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier mysql_identifier = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifierOrBuilder
      getMysqlIdentifierOrBuilder() {
    if (sourceIdentifierCase_ == 2) {
      return (com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier)
          sourceIdentifier_;
    }
    return com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
        .getDefaultInstance();
  }

  public static final int POSTGRESQL_IDENTIFIER_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * PostgreSQL data source object identifier.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier postgresql_identifier = 3;
   * </code>
   *
   * @return Whether the postgresqlIdentifier field is set.
   */
  @java.lang.Override
  public boolean hasPostgresqlIdentifier() {
    return sourceIdentifierCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * PostgreSQL data source object identifier.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier postgresql_identifier = 3;
   * </code>
   *
   * @return The postgresqlIdentifier.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
      getPostgresqlIdentifier() {
    if (sourceIdentifierCase_ == 3) {
      return (com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier)
          sourceIdentifier_;
    }
    return com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * PostgreSQL data source object identifier.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier postgresql_identifier = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifierOrBuilder
      getPostgresqlIdentifierOrBuilder() {
    if (sourceIdentifierCase_ == 3) {
      return (com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier)
          sourceIdentifier_;
    }
    return com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
        .getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (sourceIdentifierCase_ == 1) {
      output.writeMessage(
          1,
          (com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier)
              sourceIdentifier_);
    }
    if (sourceIdentifierCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier)
              sourceIdentifier_);
    }
    if (sourceIdentifierCase_ == 3) {
      output.writeMessage(
          3,
          (com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier)
              sourceIdentifier_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (sourceIdentifierCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1,
              (com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier)
                  sourceIdentifier_);
    }
    if (sourceIdentifierCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier)
                  sourceIdentifier_);
    }
    if (sourceIdentifierCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3,
              (com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier)
                  sourceIdentifier_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datastream.v1.SourceObjectIdentifier)) {
      return super.equals(obj);
    }
    com.google.cloud.datastream.v1.SourceObjectIdentifier other =
        (com.google.cloud.datastream.v1.SourceObjectIdentifier) obj;

    if (!getSourceIdentifierCase().equals(other.getSourceIdentifierCase())) return false;
    switch (sourceIdentifierCase_) {
      case 1:
        if (!getOracleIdentifier().equals(other.getOracleIdentifier())) return false;
        break;
      case 2:
        if (!getMysqlIdentifier().equals(other.getMysqlIdentifier())) return false;
        break;
      case 3:
        if (!getPostgresqlIdentifier().equals(other.getPostgresqlIdentifier())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (sourceIdentifierCase_) {
      case 1:
        hash = (37 * hash) + ORACLE_IDENTIFIER_FIELD_NUMBER;
        hash = (53 * hash) + getOracleIdentifier().hashCode();
        break;
      case 2:
        hash = (37 * hash) + MYSQL_IDENTIFIER_FIELD_NUMBER;
        hash = (53 * hash) + getMysqlIdentifier().hashCode();
        break;
      case 3:
        hash = (37 * hash) + POSTGRESQL_IDENTIFIER_FIELD_NUMBER;
        hash = (53 * hash) + getPostgresqlIdentifier().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datastream.v1.SourceObjectIdentifier parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.SourceObjectIdentifier parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.SourceObjectIdentifier parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.SourceObjectIdentifier parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.SourceObjectIdentifier parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.SourceObjectIdentifier parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.SourceObjectIdentifier parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.SourceObjectIdentifier parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.SourceObjectIdentifier parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.SourceObjectIdentifier parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.SourceObjectIdentifier parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.SourceObjectIdentifier parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datastream.v1.SourceObjectIdentifier prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents an identifier of an object in the data source.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datastream.v1.SourceObjectIdentifier}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datastream.v1.SourceObjectIdentifier)
      com.google.cloud.datastream.v1.SourceObjectIdentifierOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_SourceObjectIdentifier_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_SourceObjectIdentifier_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datastream.v1.SourceObjectIdentifier.class,
              com.google.cloud.datastream.v1.SourceObjectIdentifier.Builder.class);
    }

    // Construct using com.google.cloud.datastream.v1.SourceObjectIdentifier.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (oracleIdentifierBuilder_ != null) {
        oracleIdentifierBuilder_.clear();
      }
      if (mysqlIdentifierBuilder_ != null) {
        mysqlIdentifierBuilder_.clear();
      }
      if (postgresqlIdentifierBuilder_ != null) {
        postgresqlIdentifierBuilder_.clear();
      }
      sourceIdentifierCase_ = 0;
      sourceIdentifier_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_SourceObjectIdentifier_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.SourceObjectIdentifier getDefaultInstanceForType() {
      return com.google.cloud.datastream.v1.SourceObjectIdentifier.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.SourceObjectIdentifier build() {
      com.google.cloud.datastream.v1.SourceObjectIdentifier result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.SourceObjectIdentifier buildPartial() {
      com.google.cloud.datastream.v1.SourceObjectIdentifier result =
          new com.google.cloud.datastream.v1.SourceObjectIdentifier(this);
      if (sourceIdentifierCase_ == 1) {
        if (oracleIdentifierBuilder_ == null) {
          result.sourceIdentifier_ = sourceIdentifier_;
        } else {
          result.sourceIdentifier_ = oracleIdentifierBuilder_.build();
        }
      }
      if (sourceIdentifierCase_ == 2) {
        if (mysqlIdentifierBuilder_ == null) {
          result.sourceIdentifier_ = sourceIdentifier_;
        } else {
          result.sourceIdentifier_ = mysqlIdentifierBuilder_.build();
        }
      }
      if (sourceIdentifierCase_ == 3) {
        if (postgresqlIdentifierBuilder_ == null) {
          result.sourceIdentifier_ = sourceIdentifier_;
        } else {
          result.sourceIdentifier_ = postgresqlIdentifierBuilder_.build();
        }
      }
      result.sourceIdentifierCase_ = sourceIdentifierCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datastream.v1.SourceObjectIdentifier) {
        return mergeFrom((com.google.cloud.datastream.v1.SourceObjectIdentifier) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datastream.v1.SourceObjectIdentifier other) {
      if (other == com.google.cloud.datastream.v1.SourceObjectIdentifier.getDefaultInstance())
        return this;
      switch (other.getSourceIdentifierCase()) {
        case ORACLE_IDENTIFIER:
          {
            mergeOracleIdentifier(other.getOracleIdentifier());
            break;
          }
        case MYSQL_IDENTIFIER:
          {
            mergeMysqlIdentifier(other.getMysqlIdentifier());
            break;
          }
        case POSTGRESQL_IDENTIFIER:
          {
            mergePostgresqlIdentifier(other.getPostgresqlIdentifier());
            break;
          }
        case SOURCEIDENTIFIER_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getOracleIdentifierFieldBuilder().getBuilder(), extensionRegistry);
                sourceIdentifierCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getMysqlIdentifierFieldBuilder().getBuilder(), extensionRegistry);
                sourceIdentifierCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getPostgresqlIdentifierFieldBuilder().getBuilder(), extensionRegistry);
                sourceIdentifierCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceIdentifierCase_ = 0;
    private java.lang.Object sourceIdentifier_;

    public SourceIdentifierCase getSourceIdentifierCase() {
      return SourceIdentifierCase.forNumber(sourceIdentifierCase_);
    }

    public Builder clearSourceIdentifier() {
      sourceIdentifierCase_ = 0;
      sourceIdentifier_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier,
            com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier.Builder,
            com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifierOrBuilder>
        oracleIdentifierBuilder_;
    /**
     *
     *
     * <pre>
     * Oracle data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier oracle_identifier = 1;
     * </code>
     *
     * @return Whether the oracleIdentifier field is set.
     */
    @java.lang.Override
    public boolean hasOracleIdentifier() {
      return sourceIdentifierCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Oracle data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier oracle_identifier = 1;
     * </code>
     *
     * @return The oracleIdentifier.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
        getOracleIdentifier() {
      if (oracleIdentifierBuilder_ == null) {
        if (sourceIdentifierCase_ == 1) {
          return (com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier)
              sourceIdentifier_;
        }
        return com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
            .getDefaultInstance();
      } else {
        if (sourceIdentifierCase_ == 1) {
          return oracleIdentifierBuilder_.getMessage();
        }
        return com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Oracle data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier oracle_identifier = 1;
     * </code>
     */
    public Builder setOracleIdentifier(
        com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier value) {
      if (oracleIdentifierBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceIdentifier_ = value;
        onChanged();
      } else {
        oracleIdentifierBuilder_.setMessage(value);
      }
      sourceIdentifierCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Oracle data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier oracle_identifier = 1;
     * </code>
     */
    public Builder setOracleIdentifier(
        com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier.Builder
            builderForValue) {
      if (oracleIdentifierBuilder_ == null) {
        sourceIdentifier_ = builderForValue.build();
        onChanged();
      } else {
        oracleIdentifierBuilder_.setMessage(builderForValue.build());
      }
      sourceIdentifierCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Oracle data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier oracle_identifier = 1;
     * </code>
     */
    public Builder mergeOracleIdentifier(
        com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier value) {
      if (oracleIdentifierBuilder_ == null) {
        if (sourceIdentifierCase_ == 1
            && sourceIdentifier_
                != com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
                    .getDefaultInstance()) {
          sourceIdentifier_ =
              com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
                  .newBuilder(
                      (com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier)
                          sourceIdentifier_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sourceIdentifier_ = value;
        }
        onChanged();
      } else {
        if (sourceIdentifierCase_ == 1) {
          oracleIdentifierBuilder_.mergeFrom(value);
        } else {
          oracleIdentifierBuilder_.setMessage(value);
        }
      }
      sourceIdentifierCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Oracle data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier oracle_identifier = 1;
     * </code>
     */
    public Builder clearOracleIdentifier() {
      if (oracleIdentifierBuilder_ == null) {
        if (sourceIdentifierCase_ == 1) {
          sourceIdentifierCase_ = 0;
          sourceIdentifier_ = null;
          onChanged();
        }
      } else {
        if (sourceIdentifierCase_ == 1) {
          sourceIdentifierCase_ = 0;
          sourceIdentifier_ = null;
        }
        oracleIdentifierBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Oracle data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier oracle_identifier = 1;
     * </code>
     */
    public com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier.Builder
        getOracleIdentifierBuilder() {
      return getOracleIdentifierFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Oracle data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier oracle_identifier = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifierOrBuilder
        getOracleIdentifierOrBuilder() {
      if ((sourceIdentifierCase_ == 1) && (oracleIdentifierBuilder_ != null)) {
        return oracleIdentifierBuilder_.getMessageOrBuilder();
      } else {
        if (sourceIdentifierCase_ == 1) {
          return (com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier)
              sourceIdentifier_;
        }
        return com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Oracle data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier oracle_identifier = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier,
            com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier.Builder,
            com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifierOrBuilder>
        getOracleIdentifierFieldBuilder() {
      if (oracleIdentifierBuilder_ == null) {
        if (!(sourceIdentifierCase_ == 1)) {
          sourceIdentifier_ =
              com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
                  .getDefaultInstance();
        }
        oracleIdentifierBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier,
                com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
                    .Builder,
                com.google.cloud.datastream.v1.SourceObjectIdentifier
                    .OracleObjectIdentifierOrBuilder>(
                (com.google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier)
                    sourceIdentifier_,
                getParentForChildren(),
                isClean());
        sourceIdentifier_ = null;
      }
      sourceIdentifierCase_ = 1;
      onChanged();
      ;
      return oracleIdentifierBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier,
            com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier.Builder,
            com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifierOrBuilder>
        mysqlIdentifierBuilder_;
    /**
     *
     *
     * <pre>
     * Mysql data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier mysql_identifier = 2;
     * </code>
     *
     * @return Whether the mysqlIdentifier field is set.
     */
    @java.lang.Override
    public boolean hasMysqlIdentifier() {
      return sourceIdentifierCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Mysql data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier mysql_identifier = 2;
     * </code>
     *
     * @return The mysqlIdentifier.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
        getMysqlIdentifier() {
      if (mysqlIdentifierBuilder_ == null) {
        if (sourceIdentifierCase_ == 2) {
          return (com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier)
              sourceIdentifier_;
        }
        return com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
            .getDefaultInstance();
      } else {
        if (sourceIdentifierCase_ == 2) {
          return mysqlIdentifierBuilder_.getMessage();
        }
        return com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Mysql data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier mysql_identifier = 2;
     * </code>
     */
    public Builder setMysqlIdentifier(
        com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier value) {
      if (mysqlIdentifierBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceIdentifier_ = value;
        onChanged();
      } else {
        mysqlIdentifierBuilder_.setMessage(value);
      }
      sourceIdentifierCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mysql data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier mysql_identifier = 2;
     * </code>
     */
    public Builder setMysqlIdentifier(
        com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier.Builder
            builderForValue) {
      if (mysqlIdentifierBuilder_ == null) {
        sourceIdentifier_ = builderForValue.build();
        onChanged();
      } else {
        mysqlIdentifierBuilder_.setMessage(builderForValue.build());
      }
      sourceIdentifierCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mysql data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier mysql_identifier = 2;
     * </code>
     */
    public Builder mergeMysqlIdentifier(
        com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier value) {
      if (mysqlIdentifierBuilder_ == null) {
        if (sourceIdentifierCase_ == 2
            && sourceIdentifier_
                != com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
                    .getDefaultInstance()) {
          sourceIdentifier_ =
              com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
                  .newBuilder(
                      (com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier)
                          sourceIdentifier_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sourceIdentifier_ = value;
        }
        onChanged();
      } else {
        if (sourceIdentifierCase_ == 2) {
          mysqlIdentifierBuilder_.mergeFrom(value);
        } else {
          mysqlIdentifierBuilder_.setMessage(value);
        }
      }
      sourceIdentifierCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mysql data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier mysql_identifier = 2;
     * </code>
     */
    public Builder clearMysqlIdentifier() {
      if (mysqlIdentifierBuilder_ == null) {
        if (sourceIdentifierCase_ == 2) {
          sourceIdentifierCase_ = 0;
          sourceIdentifier_ = null;
          onChanged();
        }
      } else {
        if (sourceIdentifierCase_ == 2) {
          sourceIdentifierCase_ = 0;
          sourceIdentifier_ = null;
        }
        mysqlIdentifierBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mysql data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier mysql_identifier = 2;
     * </code>
     */
    public com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier.Builder
        getMysqlIdentifierBuilder() {
      return getMysqlIdentifierFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Mysql data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier mysql_identifier = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifierOrBuilder
        getMysqlIdentifierOrBuilder() {
      if ((sourceIdentifierCase_ == 2) && (mysqlIdentifierBuilder_ != null)) {
        return mysqlIdentifierBuilder_.getMessageOrBuilder();
      } else {
        if (sourceIdentifierCase_ == 2) {
          return (com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier)
              sourceIdentifier_;
        }
        return com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Mysql data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier mysql_identifier = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier,
            com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier.Builder,
            com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifierOrBuilder>
        getMysqlIdentifierFieldBuilder() {
      if (mysqlIdentifierBuilder_ == null) {
        if (!(sourceIdentifierCase_ == 2)) {
          sourceIdentifier_ =
              com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
                  .getDefaultInstance();
        }
        mysqlIdentifierBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier,
                com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier.Builder,
                com.google.cloud.datastream.v1.SourceObjectIdentifier
                    .MysqlObjectIdentifierOrBuilder>(
                (com.google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier)
                    sourceIdentifier_,
                getParentForChildren(),
                isClean());
        sourceIdentifier_ = null;
      }
      sourceIdentifierCase_ = 2;
      onChanged();
      ;
      return mysqlIdentifierBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier,
            com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
                .Builder,
            com.google.cloud.datastream.v1.SourceObjectIdentifier
                .PostgresqlObjectIdentifierOrBuilder>
        postgresqlIdentifierBuilder_;
    /**
     *
     *
     * <pre>
     * PostgreSQL data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier postgresql_identifier = 3;
     * </code>
     *
     * @return Whether the postgresqlIdentifier field is set.
     */
    @java.lang.Override
    public boolean hasPostgresqlIdentifier() {
      return sourceIdentifierCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier postgresql_identifier = 3;
     * </code>
     *
     * @return The postgresqlIdentifier.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
        getPostgresqlIdentifier() {
      if (postgresqlIdentifierBuilder_ == null) {
        if (sourceIdentifierCase_ == 3) {
          return (com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier)
              sourceIdentifier_;
        }
        return com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
            .getDefaultInstance();
      } else {
        if (sourceIdentifierCase_ == 3) {
          return postgresqlIdentifierBuilder_.getMessage();
        }
        return com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier postgresql_identifier = 3;
     * </code>
     */
    public Builder setPostgresqlIdentifier(
        com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier value) {
      if (postgresqlIdentifierBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceIdentifier_ = value;
        onChanged();
      } else {
        postgresqlIdentifierBuilder_.setMessage(value);
      }
      sourceIdentifierCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier postgresql_identifier = 3;
     * </code>
     */
    public Builder setPostgresqlIdentifier(
        com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier.Builder
            builderForValue) {
      if (postgresqlIdentifierBuilder_ == null) {
        sourceIdentifier_ = builderForValue.build();
        onChanged();
      } else {
        postgresqlIdentifierBuilder_.setMessage(builderForValue.build());
      }
      sourceIdentifierCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier postgresql_identifier = 3;
     * </code>
     */
    public Builder mergePostgresqlIdentifier(
        com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier value) {
      if (postgresqlIdentifierBuilder_ == null) {
        if (sourceIdentifierCase_ == 3
            && sourceIdentifier_
                != com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
                    .getDefaultInstance()) {
          sourceIdentifier_ =
              com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
                  .newBuilder(
                      (com.google.cloud.datastream.v1.SourceObjectIdentifier
                              .PostgresqlObjectIdentifier)
                          sourceIdentifier_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sourceIdentifier_ = value;
        }
        onChanged();
      } else {
        if (sourceIdentifierCase_ == 3) {
          postgresqlIdentifierBuilder_.mergeFrom(value);
        } else {
          postgresqlIdentifierBuilder_.setMessage(value);
        }
      }
      sourceIdentifierCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier postgresql_identifier = 3;
     * </code>
     */
    public Builder clearPostgresqlIdentifier() {
      if (postgresqlIdentifierBuilder_ == null) {
        if (sourceIdentifierCase_ == 3) {
          sourceIdentifierCase_ = 0;
          sourceIdentifier_ = null;
          onChanged();
        }
      } else {
        if (sourceIdentifierCase_ == 3) {
          sourceIdentifierCase_ = 0;
          sourceIdentifier_ = null;
        }
        postgresqlIdentifierBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier postgresql_identifier = 3;
     * </code>
     */
    public com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier.Builder
        getPostgresqlIdentifierBuilder() {
      return getPostgresqlIdentifierFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier postgresql_identifier = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifierOrBuilder
        getPostgresqlIdentifierOrBuilder() {
      if ((sourceIdentifierCase_ == 3) && (postgresqlIdentifierBuilder_ != null)) {
        return postgresqlIdentifierBuilder_.getMessageOrBuilder();
      } else {
        if (sourceIdentifierCase_ == 3) {
          return (com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier)
              sourceIdentifier_;
        }
        return com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL data source object identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier postgresql_identifier = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier,
            com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
                .Builder,
            com.google.cloud.datastream.v1.SourceObjectIdentifier
                .PostgresqlObjectIdentifierOrBuilder>
        getPostgresqlIdentifierFieldBuilder() {
      if (postgresqlIdentifierBuilder_ == null) {
        if (!(sourceIdentifierCase_ == 3)) {
          sourceIdentifier_ =
              com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
                  .getDefaultInstance();
        }
        postgresqlIdentifierBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier,
                com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
                    .Builder,
                com.google.cloud.datastream.v1.SourceObjectIdentifier
                    .PostgresqlObjectIdentifierOrBuilder>(
                (com.google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier)
                    sourceIdentifier_,
                getParentForChildren(),
                isClean());
        sourceIdentifier_ = null;
      }
      sourceIdentifierCase_ = 3;
      onChanged();
      ;
      return postgresqlIdentifierBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datastream.v1.SourceObjectIdentifier)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datastream.v1.SourceObjectIdentifier)
  private static final com.google.cloud.datastream.v1.SourceObjectIdentifier DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datastream.v1.SourceObjectIdentifier();
  }

  public static com.google.cloud.datastream.v1.SourceObjectIdentifier getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SourceObjectIdentifier> PARSER =
      new com.google.protobuf.AbstractParser<SourceObjectIdentifier>() {
        @java.lang.Override
        public SourceObjectIdentifier parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SourceObjectIdentifier> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SourceObjectIdentifier> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datastream.v1.SourceObjectIdentifier getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
