/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datastream/v1/datastream_resources.proto

package com.google.cloud.datastream.v1;

/**
 *
 *
 * <pre>
 * PostgreSQL data source configuration
 * </pre>
 *
 * Protobuf type {@code google.cloud.datastream.v1.PostgresqlSourceConfig}
 */
public final class PostgresqlSourceConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datastream.v1.PostgresqlSourceConfig)
    PostgresqlSourceConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PostgresqlSourceConfig.newBuilder() to construct.
  private PostgresqlSourceConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PostgresqlSourceConfig() {
    replicationSlot_ = "";
    publication_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PostgresqlSourceConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datastream.v1.DatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1_PostgresqlSourceConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datastream.v1.DatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1_PostgresqlSourceConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datastream.v1.PostgresqlSourceConfig.class,
            com.google.cloud.datastream.v1.PostgresqlSourceConfig.Builder.class);
  }

  public static final int INCLUDE_OBJECTS_FIELD_NUMBER = 1;
  private com.google.cloud.datastream.v1.PostgresqlRdbms includeObjects_;
  /**
   *
   *
   * <pre>
   * PostgreSQL objects to include in the stream.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.PostgresqlRdbms include_objects = 1;</code>
   *
   * @return Whether the includeObjects field is set.
   */
  @java.lang.Override
  public boolean hasIncludeObjects() {
    return includeObjects_ != null;
  }
  /**
   *
   *
   * <pre>
   * PostgreSQL objects to include in the stream.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.PostgresqlRdbms include_objects = 1;</code>
   *
   * @return The includeObjects.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.PostgresqlRdbms getIncludeObjects() {
    return includeObjects_ == null
        ? com.google.cloud.datastream.v1.PostgresqlRdbms.getDefaultInstance()
        : includeObjects_;
  }
  /**
   *
   *
   * <pre>
   * PostgreSQL objects to include in the stream.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.PostgresqlRdbms include_objects = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.PostgresqlRdbmsOrBuilder getIncludeObjectsOrBuilder() {
    return getIncludeObjects();
  }

  public static final int EXCLUDE_OBJECTS_FIELD_NUMBER = 2;
  private com.google.cloud.datastream.v1.PostgresqlRdbms excludeObjects_;
  /**
   *
   *
   * <pre>
   * PostgreSQL objects to exclude from the stream.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.PostgresqlRdbms exclude_objects = 2;</code>
   *
   * @return Whether the excludeObjects field is set.
   */
  @java.lang.Override
  public boolean hasExcludeObjects() {
    return excludeObjects_ != null;
  }
  /**
   *
   *
   * <pre>
   * PostgreSQL objects to exclude from the stream.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.PostgresqlRdbms exclude_objects = 2;</code>
   *
   * @return The excludeObjects.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.PostgresqlRdbms getExcludeObjects() {
    return excludeObjects_ == null
        ? com.google.cloud.datastream.v1.PostgresqlRdbms.getDefaultInstance()
        : excludeObjects_;
  }
  /**
   *
   *
   * <pre>
   * PostgreSQL objects to exclude from the stream.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.PostgresqlRdbms exclude_objects = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.PostgresqlRdbmsOrBuilder getExcludeObjectsOrBuilder() {
    return getExcludeObjects();
  }

  public static final int REPLICATION_SLOT_FIELD_NUMBER = 3;
  private volatile java.lang.Object replicationSlot_;
  /**
   *
   *
   * <pre>
   * Required. The name of the logical replication slot that's configured with the
   * pgoutput plugin.
   * </pre>
   *
   * <code>string replication_slot = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The replicationSlot.
   */
  @java.lang.Override
  public java.lang.String getReplicationSlot() {
    java.lang.Object ref = replicationSlot_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      replicationSlot_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the logical replication slot that's configured with the
   * pgoutput plugin.
   * </pre>
   *
   * <code>string replication_slot = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for replicationSlot.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getReplicationSlotBytes() {
    java.lang.Object ref = replicationSlot_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      replicationSlot_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PUBLICATION_FIELD_NUMBER = 4;
  private volatile java.lang.Object publication_;
  /**
   *
   *
   * <pre>
   * Required. The name of the publication that includes the set of all tables that are
   * defined in the stream's include_objects.
   * </pre>
   *
   * <code>string publication = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The publication.
   */
  @java.lang.Override
  public java.lang.String getPublication() {
    java.lang.Object ref = publication_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      publication_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the publication that includes the set of all tables that are
   * defined in the stream's include_objects.
   * </pre>
   *
   * <code>string publication = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for publication.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPublicationBytes() {
    java.lang.Object ref = publication_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      publication_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (includeObjects_ != null) {
      output.writeMessage(1, getIncludeObjects());
    }
    if (excludeObjects_ != null) {
      output.writeMessage(2, getExcludeObjects());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(replicationSlot_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, replicationSlot_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publication_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, publication_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (includeObjects_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getIncludeObjects());
    }
    if (excludeObjects_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getExcludeObjects());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(replicationSlot_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, replicationSlot_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publication_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, publication_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datastream.v1.PostgresqlSourceConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.datastream.v1.PostgresqlSourceConfig other =
        (com.google.cloud.datastream.v1.PostgresqlSourceConfig) obj;

    if (hasIncludeObjects() != other.hasIncludeObjects()) return false;
    if (hasIncludeObjects()) {
      if (!getIncludeObjects().equals(other.getIncludeObjects())) return false;
    }
    if (hasExcludeObjects() != other.hasExcludeObjects()) return false;
    if (hasExcludeObjects()) {
      if (!getExcludeObjects().equals(other.getExcludeObjects())) return false;
    }
    if (!getReplicationSlot().equals(other.getReplicationSlot())) return false;
    if (!getPublication().equals(other.getPublication())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasIncludeObjects()) {
      hash = (37 * hash) + INCLUDE_OBJECTS_FIELD_NUMBER;
      hash = (53 * hash) + getIncludeObjects().hashCode();
    }
    if (hasExcludeObjects()) {
      hash = (37 * hash) + EXCLUDE_OBJECTS_FIELD_NUMBER;
      hash = (53 * hash) + getExcludeObjects().hashCode();
    }
    hash = (37 * hash) + REPLICATION_SLOT_FIELD_NUMBER;
    hash = (53 * hash) + getReplicationSlot().hashCode();
    hash = (37 * hash) + PUBLICATION_FIELD_NUMBER;
    hash = (53 * hash) + getPublication().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datastream.v1.PostgresqlSourceConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.PostgresqlSourceConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.PostgresqlSourceConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.PostgresqlSourceConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.PostgresqlSourceConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.PostgresqlSourceConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.PostgresqlSourceConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.PostgresqlSourceConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.PostgresqlSourceConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.PostgresqlSourceConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.PostgresqlSourceConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.PostgresqlSourceConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datastream.v1.PostgresqlSourceConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * PostgreSQL data source configuration
   * </pre>
   *
   * Protobuf type {@code google.cloud.datastream.v1.PostgresqlSourceConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datastream.v1.PostgresqlSourceConfig)
      com.google.cloud.datastream.v1.PostgresqlSourceConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_PostgresqlSourceConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_PostgresqlSourceConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datastream.v1.PostgresqlSourceConfig.class,
              com.google.cloud.datastream.v1.PostgresqlSourceConfig.Builder.class);
    }

    // Construct using com.google.cloud.datastream.v1.PostgresqlSourceConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (includeObjectsBuilder_ == null) {
        includeObjects_ = null;
      } else {
        includeObjects_ = null;
        includeObjectsBuilder_ = null;
      }
      if (excludeObjectsBuilder_ == null) {
        excludeObjects_ = null;
      } else {
        excludeObjects_ = null;
        excludeObjectsBuilder_ = null;
      }
      replicationSlot_ = "";

      publication_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_PostgresqlSourceConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.PostgresqlSourceConfig getDefaultInstanceForType() {
      return com.google.cloud.datastream.v1.PostgresqlSourceConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.PostgresqlSourceConfig build() {
      com.google.cloud.datastream.v1.PostgresqlSourceConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.PostgresqlSourceConfig buildPartial() {
      com.google.cloud.datastream.v1.PostgresqlSourceConfig result =
          new com.google.cloud.datastream.v1.PostgresqlSourceConfig(this);
      if (includeObjectsBuilder_ == null) {
        result.includeObjects_ = includeObjects_;
      } else {
        result.includeObjects_ = includeObjectsBuilder_.build();
      }
      if (excludeObjectsBuilder_ == null) {
        result.excludeObjects_ = excludeObjects_;
      } else {
        result.excludeObjects_ = excludeObjectsBuilder_.build();
      }
      result.replicationSlot_ = replicationSlot_;
      result.publication_ = publication_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datastream.v1.PostgresqlSourceConfig) {
        return mergeFrom((com.google.cloud.datastream.v1.PostgresqlSourceConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datastream.v1.PostgresqlSourceConfig other) {
      if (other == com.google.cloud.datastream.v1.PostgresqlSourceConfig.getDefaultInstance())
        return this;
      if (other.hasIncludeObjects()) {
        mergeIncludeObjects(other.getIncludeObjects());
      }
      if (other.hasExcludeObjects()) {
        mergeExcludeObjects(other.getExcludeObjects());
      }
      if (!other.getReplicationSlot().isEmpty()) {
        replicationSlot_ = other.replicationSlot_;
        onChanged();
      }
      if (!other.getPublication().isEmpty()) {
        publication_ = other.publication_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getIncludeObjectsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getExcludeObjectsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                replicationSlot_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 34:
              {
                publication_ = input.readStringRequireUtf8();

                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private com.google.cloud.datastream.v1.PostgresqlRdbms includeObjects_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.PostgresqlRdbms,
            com.google.cloud.datastream.v1.PostgresqlRdbms.Builder,
            com.google.cloud.datastream.v1.PostgresqlRdbmsOrBuilder>
        includeObjectsBuilder_;
    /**
     *
     *
     * <pre>
     * PostgreSQL objects to include in the stream.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlRdbms include_objects = 1;</code>
     *
     * @return Whether the includeObjects field is set.
     */
    public boolean hasIncludeObjects() {
      return includeObjectsBuilder_ != null || includeObjects_ != null;
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL objects to include in the stream.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlRdbms include_objects = 1;</code>
     *
     * @return The includeObjects.
     */
    public com.google.cloud.datastream.v1.PostgresqlRdbms getIncludeObjects() {
      if (includeObjectsBuilder_ == null) {
        return includeObjects_ == null
            ? com.google.cloud.datastream.v1.PostgresqlRdbms.getDefaultInstance()
            : includeObjects_;
      } else {
        return includeObjectsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL objects to include in the stream.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlRdbms include_objects = 1;</code>
     */
    public Builder setIncludeObjects(com.google.cloud.datastream.v1.PostgresqlRdbms value) {
      if (includeObjectsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        includeObjects_ = value;
        onChanged();
      } else {
        includeObjectsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL objects to include in the stream.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlRdbms include_objects = 1;</code>
     */
    public Builder setIncludeObjects(
        com.google.cloud.datastream.v1.PostgresqlRdbms.Builder builderForValue) {
      if (includeObjectsBuilder_ == null) {
        includeObjects_ = builderForValue.build();
        onChanged();
      } else {
        includeObjectsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL objects to include in the stream.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlRdbms include_objects = 1;</code>
     */
    public Builder mergeIncludeObjects(com.google.cloud.datastream.v1.PostgresqlRdbms value) {
      if (includeObjectsBuilder_ == null) {
        if (includeObjects_ != null) {
          includeObjects_ =
              com.google.cloud.datastream.v1.PostgresqlRdbms.newBuilder(includeObjects_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          includeObjects_ = value;
        }
        onChanged();
      } else {
        includeObjectsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL objects to include in the stream.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlRdbms include_objects = 1;</code>
     */
    public Builder clearIncludeObjects() {
      if (includeObjectsBuilder_ == null) {
        includeObjects_ = null;
        onChanged();
      } else {
        includeObjects_ = null;
        includeObjectsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL objects to include in the stream.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlRdbms include_objects = 1;</code>
     */
    public com.google.cloud.datastream.v1.PostgresqlRdbms.Builder getIncludeObjectsBuilder() {

      onChanged();
      return getIncludeObjectsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL objects to include in the stream.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlRdbms include_objects = 1;</code>
     */
    public com.google.cloud.datastream.v1.PostgresqlRdbmsOrBuilder getIncludeObjectsOrBuilder() {
      if (includeObjectsBuilder_ != null) {
        return includeObjectsBuilder_.getMessageOrBuilder();
      } else {
        return includeObjects_ == null
            ? com.google.cloud.datastream.v1.PostgresqlRdbms.getDefaultInstance()
            : includeObjects_;
      }
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL objects to include in the stream.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlRdbms include_objects = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.PostgresqlRdbms,
            com.google.cloud.datastream.v1.PostgresqlRdbms.Builder,
            com.google.cloud.datastream.v1.PostgresqlRdbmsOrBuilder>
        getIncludeObjectsFieldBuilder() {
      if (includeObjectsBuilder_ == null) {
        includeObjectsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1.PostgresqlRdbms,
                com.google.cloud.datastream.v1.PostgresqlRdbms.Builder,
                com.google.cloud.datastream.v1.PostgresqlRdbmsOrBuilder>(
                getIncludeObjects(), getParentForChildren(), isClean());
        includeObjects_ = null;
      }
      return includeObjectsBuilder_;
    }

    private com.google.cloud.datastream.v1.PostgresqlRdbms excludeObjects_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.PostgresqlRdbms,
            com.google.cloud.datastream.v1.PostgresqlRdbms.Builder,
            com.google.cloud.datastream.v1.PostgresqlRdbmsOrBuilder>
        excludeObjectsBuilder_;
    /**
     *
     *
     * <pre>
     * PostgreSQL objects to exclude from the stream.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlRdbms exclude_objects = 2;</code>
     *
     * @return Whether the excludeObjects field is set.
     */
    public boolean hasExcludeObjects() {
      return excludeObjectsBuilder_ != null || excludeObjects_ != null;
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL objects to exclude from the stream.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlRdbms exclude_objects = 2;</code>
     *
     * @return The excludeObjects.
     */
    public com.google.cloud.datastream.v1.PostgresqlRdbms getExcludeObjects() {
      if (excludeObjectsBuilder_ == null) {
        return excludeObjects_ == null
            ? com.google.cloud.datastream.v1.PostgresqlRdbms.getDefaultInstance()
            : excludeObjects_;
      } else {
        return excludeObjectsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL objects to exclude from the stream.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlRdbms exclude_objects = 2;</code>
     */
    public Builder setExcludeObjects(com.google.cloud.datastream.v1.PostgresqlRdbms value) {
      if (excludeObjectsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        excludeObjects_ = value;
        onChanged();
      } else {
        excludeObjectsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL objects to exclude from the stream.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlRdbms exclude_objects = 2;</code>
     */
    public Builder setExcludeObjects(
        com.google.cloud.datastream.v1.PostgresqlRdbms.Builder builderForValue) {
      if (excludeObjectsBuilder_ == null) {
        excludeObjects_ = builderForValue.build();
        onChanged();
      } else {
        excludeObjectsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL objects to exclude from the stream.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlRdbms exclude_objects = 2;</code>
     */
    public Builder mergeExcludeObjects(com.google.cloud.datastream.v1.PostgresqlRdbms value) {
      if (excludeObjectsBuilder_ == null) {
        if (excludeObjects_ != null) {
          excludeObjects_ =
              com.google.cloud.datastream.v1.PostgresqlRdbms.newBuilder(excludeObjects_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          excludeObjects_ = value;
        }
        onChanged();
      } else {
        excludeObjectsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL objects to exclude from the stream.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlRdbms exclude_objects = 2;</code>
     */
    public Builder clearExcludeObjects() {
      if (excludeObjectsBuilder_ == null) {
        excludeObjects_ = null;
        onChanged();
      } else {
        excludeObjects_ = null;
        excludeObjectsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL objects to exclude from the stream.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlRdbms exclude_objects = 2;</code>
     */
    public com.google.cloud.datastream.v1.PostgresqlRdbms.Builder getExcludeObjectsBuilder() {

      onChanged();
      return getExcludeObjectsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL objects to exclude from the stream.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlRdbms exclude_objects = 2;</code>
     */
    public com.google.cloud.datastream.v1.PostgresqlRdbmsOrBuilder getExcludeObjectsOrBuilder() {
      if (excludeObjectsBuilder_ != null) {
        return excludeObjectsBuilder_.getMessageOrBuilder();
      } else {
        return excludeObjects_ == null
            ? com.google.cloud.datastream.v1.PostgresqlRdbms.getDefaultInstance()
            : excludeObjects_;
      }
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL objects to exclude from the stream.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlRdbms exclude_objects = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.PostgresqlRdbms,
            com.google.cloud.datastream.v1.PostgresqlRdbms.Builder,
            com.google.cloud.datastream.v1.PostgresqlRdbmsOrBuilder>
        getExcludeObjectsFieldBuilder() {
      if (excludeObjectsBuilder_ == null) {
        excludeObjectsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1.PostgresqlRdbms,
                com.google.cloud.datastream.v1.PostgresqlRdbms.Builder,
                com.google.cloud.datastream.v1.PostgresqlRdbmsOrBuilder>(
                getExcludeObjects(), getParentForChildren(), isClean());
        excludeObjects_ = null;
      }
      return excludeObjectsBuilder_;
    }

    private java.lang.Object replicationSlot_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the logical replication slot that's configured with the
     * pgoutput plugin.
     * </pre>
     *
     * <code>string replication_slot = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The replicationSlot.
     */
    public java.lang.String getReplicationSlot() {
      java.lang.Object ref = replicationSlot_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        replicationSlot_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the logical replication slot that's configured with the
     * pgoutput plugin.
     * </pre>
     *
     * <code>string replication_slot = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for replicationSlot.
     */
    public com.google.protobuf.ByteString getReplicationSlotBytes() {
      java.lang.Object ref = replicationSlot_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        replicationSlot_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the logical replication slot that's configured with the
     * pgoutput plugin.
     * </pre>
     *
     * <code>string replication_slot = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The replicationSlot to set.
     * @return This builder for chaining.
     */
    public Builder setReplicationSlot(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      replicationSlot_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the logical replication slot that's configured with the
     * pgoutput plugin.
     * </pre>
     *
     * <code>string replication_slot = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReplicationSlot() {

      replicationSlot_ = getDefaultInstance().getReplicationSlot();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the logical replication slot that's configured with the
     * pgoutput plugin.
     * </pre>
     *
     * <code>string replication_slot = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for replicationSlot to set.
     * @return This builder for chaining.
     */
    public Builder setReplicationSlotBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      replicationSlot_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object publication_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the publication that includes the set of all tables that are
     * defined in the stream's include_objects.
     * </pre>
     *
     * <code>string publication = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The publication.
     */
    public java.lang.String getPublication() {
      java.lang.Object ref = publication_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        publication_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the publication that includes the set of all tables that are
     * defined in the stream's include_objects.
     * </pre>
     *
     * <code>string publication = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for publication.
     */
    public com.google.protobuf.ByteString getPublicationBytes() {
      java.lang.Object ref = publication_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        publication_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the publication that includes the set of all tables that are
     * defined in the stream's include_objects.
     * </pre>
     *
     * <code>string publication = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The publication to set.
     * @return This builder for chaining.
     */
    public Builder setPublication(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      publication_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the publication that includes the set of all tables that are
     * defined in the stream's include_objects.
     * </pre>
     *
     * <code>string publication = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPublication() {

      publication_ = getDefaultInstance().getPublication();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the publication that includes the set of all tables that are
     * defined in the stream's include_objects.
     * </pre>
     *
     * <code>string publication = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for publication to set.
     * @return This builder for chaining.
     */
    public Builder setPublicationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      publication_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datastream.v1.PostgresqlSourceConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datastream.v1.PostgresqlSourceConfig)
  private static final com.google.cloud.datastream.v1.PostgresqlSourceConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datastream.v1.PostgresqlSourceConfig();
  }

  public static com.google.cloud.datastream.v1.PostgresqlSourceConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PostgresqlSourceConfig> PARSER =
      new com.google.protobuf.AbstractParser<PostgresqlSourceConfig>() {
        @java.lang.Override
        public PostgresqlSourceConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PostgresqlSourceConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PostgresqlSourceConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datastream.v1.PostgresqlSourceConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
