/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datastream/v1/datastream_resources.proto

package com.google.cloud.datastream.v1;

/**
 *
 *
 * <pre>
 * Forward SSH Tunnel connectivity.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datastream.v1.ForwardSshTunnelConnectivity}
 */
public final class ForwardSshTunnelConnectivity extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datastream.v1.ForwardSshTunnelConnectivity)
    ForwardSshTunnelConnectivityOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ForwardSshTunnelConnectivity.newBuilder() to construct.
  private ForwardSshTunnelConnectivity(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ForwardSshTunnelConnectivity() {
    hostname_ = "";
    username_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ForwardSshTunnelConnectivity();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datastream.v1.DatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1_ForwardSshTunnelConnectivity_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datastream.v1.DatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1_ForwardSshTunnelConnectivity_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity.class,
            com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity.Builder.class);
  }

  private int authenticationMethodCase_ = 0;
  private java.lang.Object authenticationMethod_;

  public enum AuthenticationMethodCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PASSWORD(100),
    PRIVATE_KEY(101),
    AUTHENTICATIONMETHOD_NOT_SET(0);
    private final int value;

    private AuthenticationMethodCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AuthenticationMethodCase valueOf(int value) {
      return forNumber(value);
    }

    public static AuthenticationMethodCase forNumber(int value) {
      switch (value) {
        case 100:
          return PASSWORD;
        case 101:
          return PRIVATE_KEY;
        case 0:
          return AUTHENTICATIONMETHOD_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AuthenticationMethodCase getAuthenticationMethodCase() {
    return AuthenticationMethodCase.forNumber(authenticationMethodCase_);
  }

  public static final int HOSTNAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object hostname_;
  /**
   *
   *
   * <pre>
   * Required. Hostname for the SSH tunnel.
   * </pre>
   *
   * <code>string hostname = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The hostname.
   */
  @java.lang.Override
  public java.lang.String getHostname() {
    java.lang.Object ref = hostname_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      hostname_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Hostname for the SSH tunnel.
   * </pre>
   *
   * <code>string hostname = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for hostname.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHostnameBytes() {
    java.lang.Object ref = hostname_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      hostname_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USERNAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object username_;
  /**
   *
   *
   * <pre>
   * Required. Username for the SSH tunnel.
   * </pre>
   *
   * <code>string username = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The username.
   */
  @java.lang.Override
  public java.lang.String getUsername() {
    java.lang.Object ref = username_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      username_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Username for the SSH tunnel.
   * </pre>
   *
   * <code>string username = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for username.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUsernameBytes() {
    java.lang.Object ref = username_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      username_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PORT_FIELD_NUMBER = 3;
  private int port_;
  /**
   *
   *
   * <pre>
   * Port for the SSH tunnel, default value is 22.
   * </pre>
   *
   * <code>int32 port = 3;</code>
   *
   * @return The port.
   */
  @java.lang.Override
  public int getPort() {
    return port_;
  }

  public static final int PASSWORD_FIELD_NUMBER = 100;
  /**
   *
   *
   * <pre>
   * Input only. SSH password.
   * </pre>
   *
   * <code>string password = 100 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return Whether the password field is set.
   */
  public boolean hasPassword() {
    return authenticationMethodCase_ == 100;
  }
  /**
   *
   *
   * <pre>
   * Input only. SSH password.
   * </pre>
   *
   * <code>string password = 100 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The password.
   */
  public java.lang.String getPassword() {
    java.lang.Object ref = "";
    if (authenticationMethodCase_ == 100) {
      ref = authenticationMethod_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (authenticationMethodCase_ == 100) {
        authenticationMethod_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Input only. SSH password.
   * </pre>
   *
   * <code>string password = 100 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The bytes for password.
   */
  public com.google.protobuf.ByteString getPasswordBytes() {
    java.lang.Object ref = "";
    if (authenticationMethodCase_ == 100) {
      ref = authenticationMethod_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (authenticationMethodCase_ == 100) {
        authenticationMethod_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRIVATE_KEY_FIELD_NUMBER = 101;
  /**
   *
   *
   * <pre>
   * Input only. SSH private key.
   * </pre>
   *
   * <code>string private_key = 101 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return Whether the privateKey field is set.
   */
  public boolean hasPrivateKey() {
    return authenticationMethodCase_ == 101;
  }
  /**
   *
   *
   * <pre>
   * Input only. SSH private key.
   * </pre>
   *
   * <code>string private_key = 101 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The privateKey.
   */
  public java.lang.String getPrivateKey() {
    java.lang.Object ref = "";
    if (authenticationMethodCase_ == 101) {
      ref = authenticationMethod_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (authenticationMethodCase_ == 101) {
        authenticationMethod_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Input only. SSH private key.
   * </pre>
   *
   * <code>string private_key = 101 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The bytes for privateKey.
   */
  public com.google.protobuf.ByteString getPrivateKeyBytes() {
    java.lang.Object ref = "";
    if (authenticationMethodCase_ == 101) {
      ref = authenticationMethod_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (authenticationMethodCase_ == 101) {
        authenticationMethod_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostname_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, hostname_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, username_);
    }
    if (port_ != 0) {
      output.writeInt32(3, port_);
    }
    if (authenticationMethodCase_ == 100) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 100, authenticationMethod_);
    }
    if (authenticationMethodCase_ == 101) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 101, authenticationMethod_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostname_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, hostname_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, username_);
    }
    if (port_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, port_);
    }
    if (authenticationMethodCase_ == 100) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(100, authenticationMethod_);
    }
    if (authenticationMethodCase_ == 101) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(101, authenticationMethod_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity)) {
      return super.equals(obj);
    }
    com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity other =
        (com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity) obj;

    if (!getHostname().equals(other.getHostname())) return false;
    if (!getUsername().equals(other.getUsername())) return false;
    if (getPort() != other.getPort()) return false;
    if (!getAuthenticationMethodCase().equals(other.getAuthenticationMethodCase())) return false;
    switch (authenticationMethodCase_) {
      case 100:
        if (!getPassword().equals(other.getPassword())) return false;
        break;
      case 101:
        if (!getPrivateKey().equals(other.getPrivateKey())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + HOSTNAME_FIELD_NUMBER;
    hash = (53 * hash) + getHostname().hashCode();
    hash = (37 * hash) + USERNAME_FIELD_NUMBER;
    hash = (53 * hash) + getUsername().hashCode();
    hash = (37 * hash) + PORT_FIELD_NUMBER;
    hash = (53 * hash) + getPort();
    switch (authenticationMethodCase_) {
      case 100:
        hash = (37 * hash) + PASSWORD_FIELD_NUMBER;
        hash = (53 * hash) + getPassword().hashCode();
        break;
      case 101:
        hash = (37 * hash) + PRIVATE_KEY_FIELD_NUMBER;
        hash = (53 * hash) + getPrivateKey().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Forward SSH Tunnel connectivity.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datastream.v1.ForwardSshTunnelConnectivity}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datastream.v1.ForwardSshTunnelConnectivity)
      com.google.cloud.datastream.v1.ForwardSshTunnelConnectivityOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_ForwardSshTunnelConnectivity_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_ForwardSshTunnelConnectivity_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity.class,
              com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity.Builder.class);
    }

    // Construct using com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      hostname_ = "";

      username_ = "";

      port_ = 0;

      authenticationMethodCase_ = 0;
      authenticationMethod_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_ForwardSshTunnelConnectivity_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity getDefaultInstanceForType() {
      return com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity build() {
      com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity buildPartial() {
      com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity result =
          new com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity(this);
      result.hostname_ = hostname_;
      result.username_ = username_;
      result.port_ = port_;
      if (authenticationMethodCase_ == 100) {
        result.authenticationMethod_ = authenticationMethod_;
      }
      if (authenticationMethodCase_ == 101) {
        result.authenticationMethod_ = authenticationMethod_;
      }
      result.authenticationMethodCase_ = authenticationMethodCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity) {
        return mergeFrom((com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity other) {
      if (other == com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity.getDefaultInstance())
        return this;
      if (!other.getHostname().isEmpty()) {
        hostname_ = other.hostname_;
        onChanged();
      }
      if (!other.getUsername().isEmpty()) {
        username_ = other.username_;
        onChanged();
      }
      if (other.getPort() != 0) {
        setPort(other.getPort());
      }
      switch (other.getAuthenticationMethodCase()) {
        case PASSWORD:
          {
            authenticationMethodCase_ = 100;
            authenticationMethod_ = other.authenticationMethod_;
            onChanged();
            break;
          }
        case PRIVATE_KEY:
          {
            authenticationMethodCase_ = 101;
            authenticationMethod_ = other.authenticationMethod_;
            onChanged();
            break;
          }
        case AUTHENTICATIONMETHOD_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                hostname_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                username_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 24:
              {
                port_ = input.readInt32();

                break;
              } // case 24
            case 802:
              {
                java.lang.String s = input.readStringRequireUtf8();
                authenticationMethodCase_ = 100;
                authenticationMethod_ = s;
                break;
              } // case 802
            case 810:
              {
                java.lang.String s = input.readStringRequireUtf8();
                authenticationMethodCase_ = 101;
                authenticationMethod_ = s;
                break;
              } // case 810
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int authenticationMethodCase_ = 0;
    private java.lang.Object authenticationMethod_;

    public AuthenticationMethodCase getAuthenticationMethodCase() {
      return AuthenticationMethodCase.forNumber(authenticationMethodCase_);
    }

    public Builder clearAuthenticationMethod() {
      authenticationMethodCase_ = 0;
      authenticationMethod_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object hostname_ = "";
    /**
     *
     *
     * <pre>
     * Required. Hostname for the SSH tunnel.
     * </pre>
     *
     * <code>string hostname = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The hostname.
     */
    public java.lang.String getHostname() {
      java.lang.Object ref = hostname_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        hostname_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Hostname for the SSH tunnel.
     * </pre>
     *
     * <code>string hostname = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for hostname.
     */
    public com.google.protobuf.ByteString getHostnameBytes() {
      java.lang.Object ref = hostname_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        hostname_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Hostname for the SSH tunnel.
     * </pre>
     *
     * <code>string hostname = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The hostname to set.
     * @return This builder for chaining.
     */
    public Builder setHostname(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      hostname_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Hostname for the SSH tunnel.
     * </pre>
     *
     * <code>string hostname = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHostname() {

      hostname_ = getDefaultInstance().getHostname();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Hostname for the SSH tunnel.
     * </pre>
     *
     * <code>string hostname = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for hostname to set.
     * @return This builder for chaining.
     */
    public Builder setHostnameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      hostname_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object username_ = "";
    /**
     *
     *
     * <pre>
     * Required. Username for the SSH tunnel.
     * </pre>
     *
     * <code>string username = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The username.
     */
    public java.lang.String getUsername() {
      java.lang.Object ref = username_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        username_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Username for the SSH tunnel.
     * </pre>
     *
     * <code>string username = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for username.
     */
    public com.google.protobuf.ByteString getUsernameBytes() {
      java.lang.Object ref = username_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        username_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Username for the SSH tunnel.
     * </pre>
     *
     * <code>string username = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The username to set.
     * @return This builder for chaining.
     */
    public Builder setUsername(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      username_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Username for the SSH tunnel.
     * </pre>
     *
     * <code>string username = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUsername() {

      username_ = getDefaultInstance().getUsername();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Username for the SSH tunnel.
     * </pre>
     *
     * <code>string username = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for username to set.
     * @return This builder for chaining.
     */
    public Builder setUsernameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      username_ = value;
      onChanged();
      return this;
    }

    private int port_;
    /**
     *
     *
     * <pre>
     * Port for the SSH tunnel, default value is 22.
     * </pre>
     *
     * <code>int32 port = 3;</code>
     *
     * @return The port.
     */
    @java.lang.Override
    public int getPort() {
      return port_;
    }
    /**
     *
     *
     * <pre>
     * Port for the SSH tunnel, default value is 22.
     * </pre>
     *
     * <code>int32 port = 3;</code>
     *
     * @param value The port to set.
     * @return This builder for chaining.
     */
    public Builder setPort(int value) {

      port_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Port for the SSH tunnel, default value is 22.
     * </pre>
     *
     * <code>int32 port = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPort() {

      port_ = 0;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input only. SSH password.
     * </pre>
     *
     * <code>string password = 100 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return Whether the password field is set.
     */
    @java.lang.Override
    public boolean hasPassword() {
      return authenticationMethodCase_ == 100;
    }
    /**
     *
     *
     * <pre>
     * Input only. SSH password.
     * </pre>
     *
     * <code>string password = 100 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The password.
     */
    @java.lang.Override
    public java.lang.String getPassword() {
      java.lang.Object ref = "";
      if (authenticationMethodCase_ == 100) {
        ref = authenticationMethod_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (authenticationMethodCase_ == 100) {
          authenticationMethod_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. SSH password.
     * </pre>
     *
     * <code>string password = 100 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The bytes for password.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPasswordBytes() {
      java.lang.Object ref = "";
      if (authenticationMethodCase_ == 100) {
        ref = authenticationMethod_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (authenticationMethodCase_ == 100) {
          authenticationMethod_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. SSH password.
     * </pre>
     *
     * <code>string password = 100 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The password to set.
     * @return This builder for chaining.
     */
    public Builder setPassword(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      authenticationMethodCase_ = 100;
      authenticationMethod_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. SSH password.
     * </pre>
     *
     * <code>string password = 100 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPassword() {
      if (authenticationMethodCase_ == 100) {
        authenticationMethodCase_ = 0;
        authenticationMethod_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. SSH password.
     * </pre>
     *
     * <code>string password = 100 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The bytes for password to set.
     * @return This builder for chaining.
     */
    public Builder setPasswordBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      authenticationMethodCase_ = 100;
      authenticationMethod_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input only. SSH private key.
     * </pre>
     *
     * <code>string private_key = 101 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return Whether the privateKey field is set.
     */
    @java.lang.Override
    public boolean hasPrivateKey() {
      return authenticationMethodCase_ == 101;
    }
    /**
     *
     *
     * <pre>
     * Input only. SSH private key.
     * </pre>
     *
     * <code>string private_key = 101 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The privateKey.
     */
    @java.lang.Override
    public java.lang.String getPrivateKey() {
      java.lang.Object ref = "";
      if (authenticationMethodCase_ == 101) {
        ref = authenticationMethod_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (authenticationMethodCase_ == 101) {
          authenticationMethod_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. SSH private key.
     * </pre>
     *
     * <code>string private_key = 101 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The bytes for privateKey.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPrivateKeyBytes() {
      java.lang.Object ref = "";
      if (authenticationMethodCase_ == 101) {
        ref = authenticationMethod_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (authenticationMethodCase_ == 101) {
          authenticationMethod_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. SSH private key.
     * </pre>
     *
     * <code>string private_key = 101 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The privateKey to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      authenticationMethodCase_ = 101;
      authenticationMethod_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. SSH private key.
     * </pre>
     *
     * <code>string private_key = 101 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrivateKey() {
      if (authenticationMethodCase_ == 101) {
        authenticationMethodCase_ = 0;
        authenticationMethod_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. SSH private key.
     * </pre>
     *
     * <code>string private_key = 101 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The bytes for privateKey to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      authenticationMethodCase_ = 101;
      authenticationMethod_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datastream.v1.ForwardSshTunnelConnectivity)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datastream.v1.ForwardSshTunnelConnectivity)
  private static final com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity();
  }

  public static com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ForwardSshTunnelConnectivity> PARSER =
      new com.google.protobuf.AbstractParser<ForwardSshTunnelConnectivity>() {
        @java.lang.Override
        public ForwardSshTunnelConnectivity parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ForwardSshTunnelConnectivity> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ForwardSshTunnelConnectivity> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datastream.v1.ForwardSshTunnelConnectivity getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
