/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datastream/v1/datastream.proto

package com.google.cloud.datastream.v1;

/**
 *
 *
 * <pre>
 * Request message for creating a connection profile.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datastream.v1.CreateConnectionProfileRequest}
 */
public final class CreateConnectionProfileRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datastream.v1.CreateConnectionProfileRequest)
    CreateConnectionProfileRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CreateConnectionProfileRequest.newBuilder() to construct.
  private CreateConnectionProfileRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateConnectionProfileRequest() {
    parent_ = "";
    connectionProfileId_ = "";
    requestId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateConnectionProfileRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datastream.v1.DatastreamProto
        .internal_static_google_cloud_datastream_v1_CreateConnectionProfileRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datastream.v1.DatastreamProto
        .internal_static_google_cloud_datastream_v1_CreateConnectionProfileRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datastream.v1.CreateConnectionProfileRequest.class,
            com.google.cloud.datastream.v1.CreateConnectionProfileRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * Required. The parent that owns the collection of ConnectionProfiles.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The parent that owns the collection of ConnectionProfiles.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONNECTION_PROFILE_ID_FIELD_NUMBER = 2;
  private volatile java.lang.Object connectionProfileId_;
  /**
   *
   *
   * <pre>
   * Required. The connection profile identifier.
   * </pre>
   *
   * <code>string connection_profile_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The connectionProfileId.
   */
  @java.lang.Override
  public java.lang.String getConnectionProfileId() {
    java.lang.Object ref = connectionProfileId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      connectionProfileId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The connection profile identifier.
   * </pre>
   *
   * <code>string connection_profile_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for connectionProfileId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConnectionProfileIdBytes() {
    java.lang.Object ref = connectionProfileId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      connectionProfileId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONNECTION_PROFILE_FIELD_NUMBER = 3;
  private com.google.cloud.datastream.v1.ConnectionProfile connectionProfile_;
  /**
   *
   *
   * <pre>
   * Required. The connection profile resource to create.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1.ConnectionProfile connection_profile = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the connectionProfile field is set.
   */
  @java.lang.Override
  public boolean hasConnectionProfile() {
    return connectionProfile_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The connection profile resource to create.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1.ConnectionProfile connection_profile = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The connectionProfile.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.ConnectionProfile getConnectionProfile() {
    return connectionProfile_ == null
        ? com.google.cloud.datastream.v1.ConnectionProfile.getDefaultInstance()
        : connectionProfile_;
  }
  /**
   *
   *
   * <pre>
   * Required. The connection profile resource to create.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1.ConnectionProfile connection_profile = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.ConnectionProfileOrBuilder getConnectionProfileOrBuilder() {
    return getConnectionProfile();
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 4;
  private volatile java.lang.Object requestId_;
  /**
   *
   *
   * <pre>
   * Optional. A request ID to identify requests. Specify a unique request ID
   * so that if you must retry your request, the server will know to ignore
   * the request if it has already been completed. The server will guarantee
   * that for at least 60 minutes since the first request.
   * For example, consider a situation where you make an initial request and the
   * request times out. If you make the request again with the same request ID,
   * the server can check if original operation with the same request ID was
   * received, and if so, will ignore the second request. This prevents clients
   * from accidentally creating duplicate commitments.
   * The request ID must be a valid UUID with the exception that zero UUID is
   * not supported (00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A request ID to identify requests. Specify a unique request ID
   * so that if you must retry your request, the server will know to ignore
   * the request if it has already been completed. The server will guarantee
   * that for at least 60 minutes since the first request.
   * For example, consider a situation where you make an initial request and the
   * request times out. If you make the request again with the same request ID,
   * the server can check if original operation with the same request ID was
   * received, and if so, will ignore the second request. This prevents clients
   * from accidentally creating duplicate commitments.
   * The request ID must be a valid UUID with the exception that zero UUID is
   * not supported (00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALIDATE_ONLY_FIELD_NUMBER = 5;
  private boolean validateOnly_;
  /**
   *
   *
   * <pre>
   * Optional. Only validate the connection profile, but don't create any resources.
   * The default is false.
   * </pre>
   *
   * <code>bool validate_only = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The validateOnly.
   */
  @java.lang.Override
  public boolean getValidateOnly() {
    return validateOnly_;
  }

  public static final int FORCE_FIELD_NUMBER = 6;
  private boolean force_;
  /**
   *
   *
   * <pre>
   * Optional. Create the connection profile without validating it.
   * </pre>
   *
   * <code>bool force = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The force.
   */
  @java.lang.Override
  public boolean getForce() {
    return force_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(connectionProfileId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, connectionProfileId_);
    }
    if (connectionProfile_ != null) {
      output.writeMessage(3, getConnectionProfile());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, requestId_);
    }
    if (validateOnly_ != false) {
      output.writeBool(5, validateOnly_);
    }
    if (force_ != false) {
      output.writeBool(6, force_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(connectionProfileId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, connectionProfileId_);
    }
    if (connectionProfile_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getConnectionProfile());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, requestId_);
    }
    if (validateOnly_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, validateOnly_);
    }
    if (force_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, force_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datastream.v1.CreateConnectionProfileRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.datastream.v1.CreateConnectionProfileRequest other =
        (com.google.cloud.datastream.v1.CreateConnectionProfileRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getConnectionProfileId().equals(other.getConnectionProfileId())) return false;
    if (hasConnectionProfile() != other.hasConnectionProfile()) return false;
    if (hasConnectionProfile()) {
      if (!getConnectionProfile().equals(other.getConnectionProfile())) return false;
    }
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (getValidateOnly() != other.getValidateOnly()) return false;
    if (getForce() != other.getForce()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + CONNECTION_PROFILE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getConnectionProfileId().hashCode();
    if (hasConnectionProfile()) {
      hash = (37 * hash) + CONNECTION_PROFILE_FIELD_NUMBER;
      hash = (53 * hash) + getConnectionProfile().hashCode();
    }
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    hash = (37 * hash) + VALIDATE_ONLY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getValidateOnly());
    hash = (37 * hash) + FORCE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getForce());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datastream.v1.CreateConnectionProfileRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.CreateConnectionProfileRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.CreateConnectionProfileRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.CreateConnectionProfileRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.CreateConnectionProfileRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.CreateConnectionProfileRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.CreateConnectionProfileRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.CreateConnectionProfileRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.CreateConnectionProfileRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.CreateConnectionProfileRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.CreateConnectionProfileRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.CreateConnectionProfileRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datastream.v1.CreateConnectionProfileRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for creating a connection profile.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datastream.v1.CreateConnectionProfileRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datastream.v1.CreateConnectionProfileRequest)
      com.google.cloud.datastream.v1.CreateConnectionProfileRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datastream.v1.DatastreamProto
          .internal_static_google_cloud_datastream_v1_CreateConnectionProfileRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datastream.v1.DatastreamProto
          .internal_static_google_cloud_datastream_v1_CreateConnectionProfileRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datastream.v1.CreateConnectionProfileRequest.class,
              com.google.cloud.datastream.v1.CreateConnectionProfileRequest.Builder.class);
    }

    // Construct using com.google.cloud.datastream.v1.CreateConnectionProfileRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      connectionProfileId_ = "";

      if (connectionProfileBuilder_ == null) {
        connectionProfile_ = null;
      } else {
        connectionProfile_ = null;
        connectionProfileBuilder_ = null;
      }
      requestId_ = "";

      validateOnly_ = false;

      force_ = false;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datastream.v1.DatastreamProto
          .internal_static_google_cloud_datastream_v1_CreateConnectionProfileRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.CreateConnectionProfileRequest
        getDefaultInstanceForType() {
      return com.google.cloud.datastream.v1.CreateConnectionProfileRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.CreateConnectionProfileRequest build() {
      com.google.cloud.datastream.v1.CreateConnectionProfileRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.CreateConnectionProfileRequest buildPartial() {
      com.google.cloud.datastream.v1.CreateConnectionProfileRequest result =
          new com.google.cloud.datastream.v1.CreateConnectionProfileRequest(this);
      result.parent_ = parent_;
      result.connectionProfileId_ = connectionProfileId_;
      if (connectionProfileBuilder_ == null) {
        result.connectionProfile_ = connectionProfile_;
      } else {
        result.connectionProfile_ = connectionProfileBuilder_.build();
      }
      result.requestId_ = requestId_;
      result.validateOnly_ = validateOnly_;
      result.force_ = force_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datastream.v1.CreateConnectionProfileRequest) {
        return mergeFrom((com.google.cloud.datastream.v1.CreateConnectionProfileRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datastream.v1.CreateConnectionProfileRequest other) {
      if (other
          == com.google.cloud.datastream.v1.CreateConnectionProfileRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (!other.getConnectionProfileId().isEmpty()) {
        connectionProfileId_ = other.connectionProfileId_;
        onChanged();
      }
      if (other.hasConnectionProfile()) {
        mergeConnectionProfile(other.getConnectionProfile());
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        onChanged();
      }
      if (other.getValidateOnly() != false) {
        setValidateOnly(other.getValidateOnly());
      }
      if (other.getForce() != false) {
        setForce(other.getForce());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                connectionProfileId_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getConnectionProfileFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                requestId_ = input.readStringRequireUtf8();

                break;
              } // case 34
            case 40:
              {
                validateOnly_ = input.readBool();

                break;
              } // case 40
            case 48:
              {
                force_ = input.readBool();

                break;
              } // case 48
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent that owns the collection of ConnectionProfiles.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent that owns the collection of ConnectionProfiles.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent that owns the collection of ConnectionProfiles.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent that owns the collection of ConnectionProfiles.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent that owns the collection of ConnectionProfiles.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object connectionProfileId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The connection profile identifier.
     * </pre>
     *
     * <code>string connection_profile_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The connectionProfileId.
     */
    public java.lang.String getConnectionProfileId() {
      java.lang.Object ref = connectionProfileId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        connectionProfileId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The connection profile identifier.
     * </pre>
     *
     * <code>string connection_profile_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for connectionProfileId.
     */
    public com.google.protobuf.ByteString getConnectionProfileIdBytes() {
      java.lang.Object ref = connectionProfileId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        connectionProfileId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The connection profile identifier.
     * </pre>
     *
     * <code>string connection_profile_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The connectionProfileId to set.
     * @return This builder for chaining.
     */
    public Builder setConnectionProfileId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      connectionProfileId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The connection profile identifier.
     * </pre>
     *
     * <code>string connection_profile_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConnectionProfileId() {

      connectionProfileId_ = getDefaultInstance().getConnectionProfileId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The connection profile identifier.
     * </pre>
     *
     * <code>string connection_profile_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for connectionProfileId to set.
     * @return This builder for chaining.
     */
    public Builder setConnectionProfileIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      connectionProfileId_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.datastream.v1.ConnectionProfile connectionProfile_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.ConnectionProfile,
            com.google.cloud.datastream.v1.ConnectionProfile.Builder,
            com.google.cloud.datastream.v1.ConnectionProfileOrBuilder>
        connectionProfileBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The connection profile resource to create.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.ConnectionProfile connection_profile = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the connectionProfile field is set.
     */
    public boolean hasConnectionProfile() {
      return connectionProfileBuilder_ != null || connectionProfile_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The connection profile resource to create.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.ConnectionProfile connection_profile = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The connectionProfile.
     */
    public com.google.cloud.datastream.v1.ConnectionProfile getConnectionProfile() {
      if (connectionProfileBuilder_ == null) {
        return connectionProfile_ == null
            ? com.google.cloud.datastream.v1.ConnectionProfile.getDefaultInstance()
            : connectionProfile_;
      } else {
        return connectionProfileBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The connection profile resource to create.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.ConnectionProfile connection_profile = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setConnectionProfile(com.google.cloud.datastream.v1.ConnectionProfile value) {
      if (connectionProfileBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectionProfile_ = value;
        onChanged();
      } else {
        connectionProfileBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The connection profile resource to create.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.ConnectionProfile connection_profile = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setConnectionProfile(
        com.google.cloud.datastream.v1.ConnectionProfile.Builder builderForValue) {
      if (connectionProfileBuilder_ == null) {
        connectionProfile_ = builderForValue.build();
        onChanged();
      } else {
        connectionProfileBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The connection profile resource to create.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.ConnectionProfile connection_profile = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeConnectionProfile(com.google.cloud.datastream.v1.ConnectionProfile value) {
      if (connectionProfileBuilder_ == null) {
        if (connectionProfile_ != null) {
          connectionProfile_ =
              com.google.cloud.datastream.v1.ConnectionProfile.newBuilder(connectionProfile_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          connectionProfile_ = value;
        }
        onChanged();
      } else {
        connectionProfileBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The connection profile resource to create.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.ConnectionProfile connection_profile = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearConnectionProfile() {
      if (connectionProfileBuilder_ == null) {
        connectionProfile_ = null;
        onChanged();
      } else {
        connectionProfile_ = null;
        connectionProfileBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The connection profile resource to create.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.ConnectionProfile connection_profile = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.datastream.v1.ConnectionProfile.Builder getConnectionProfileBuilder() {

      onChanged();
      return getConnectionProfileFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The connection profile resource to create.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.ConnectionProfile connection_profile = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.datastream.v1.ConnectionProfileOrBuilder
        getConnectionProfileOrBuilder() {
      if (connectionProfileBuilder_ != null) {
        return connectionProfileBuilder_.getMessageOrBuilder();
      } else {
        return connectionProfile_ == null
            ? com.google.cloud.datastream.v1.ConnectionProfile.getDefaultInstance()
            : connectionProfile_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The connection profile resource to create.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.ConnectionProfile connection_profile = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.ConnectionProfile,
            com.google.cloud.datastream.v1.ConnectionProfile.Builder,
            com.google.cloud.datastream.v1.ConnectionProfileOrBuilder>
        getConnectionProfileFieldBuilder() {
      if (connectionProfileBuilder_ == null) {
        connectionProfileBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1.ConnectionProfile,
                com.google.cloud.datastream.v1.ConnectionProfile.Builder,
                com.google.cloud.datastream.v1.ConnectionProfileOrBuilder>(
                getConnectionProfile(), getParentForChildren(), isClean());
        connectionProfile_ = null;
      }
      return connectionProfileBuilder_;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A request ID to identify requests. Specify a unique request ID
     * so that if you must retry your request, the server will know to ignore
     * the request if it has already been completed. The server will guarantee
     * that for at least 60 minutes since the first request.
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request ID,
     * the server can check if original operation with the same request ID was
     * received, and if so, will ignore the second request. This prevents clients
     * from accidentally creating duplicate commitments.
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A request ID to identify requests. Specify a unique request ID
     * so that if you must retry your request, the server will know to ignore
     * the request if it has already been completed. The server will guarantee
     * that for at least 60 minutes since the first request.
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request ID,
     * the server can check if original operation with the same request ID was
     * received, and if so, will ignore the second request. This prevents clients
     * from accidentally creating duplicate commitments.
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A request ID to identify requests. Specify a unique request ID
     * so that if you must retry your request, the server will know to ignore
     * the request if it has already been completed. The server will guarantee
     * that for at least 60 minutes since the first request.
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request ID,
     * the server can check if original operation with the same request ID was
     * received, and if so, will ignore the second request. This prevents clients
     * from accidentally creating duplicate commitments.
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      requestId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A request ID to identify requests. Specify a unique request ID
     * so that if you must retry your request, the server will know to ignore
     * the request if it has already been completed. The server will guarantee
     * that for at least 60 minutes since the first request.
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request ID,
     * the server can check if original operation with the same request ID was
     * received, and if so, will ignore the second request. This prevents clients
     * from accidentally creating duplicate commitments.
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {

      requestId_ = getDefaultInstance().getRequestId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A request ID to identify requests. Specify a unique request ID
     * so that if you must retry your request, the server will know to ignore
     * the request if it has already been completed. The server will guarantee
     * that for at least 60 minutes since the first request.
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request ID,
     * the server can check if original operation with the same request ID was
     * received, and if so, will ignore the second request. This prevents clients
     * from accidentally creating duplicate commitments.
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      requestId_ = value;
      onChanged();
      return this;
    }

    private boolean validateOnly_;
    /**
     *
     *
     * <pre>
     * Optional. Only validate the connection profile, but don't create any resources.
     * The default is false.
     * </pre>
     *
     * <code>bool validate_only = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The validateOnly.
     */
    @java.lang.Override
    public boolean getValidateOnly() {
      return validateOnly_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Only validate the connection profile, but don't create any resources.
     * The default is false.
     * </pre>
     *
     * <code>bool validate_only = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The validateOnly to set.
     * @return This builder for chaining.
     */
    public Builder setValidateOnly(boolean value) {

      validateOnly_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Only validate the connection profile, but don't create any resources.
     * The default is false.
     * </pre>
     *
     * <code>bool validate_only = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidateOnly() {

      validateOnly_ = false;
      onChanged();
      return this;
    }

    private boolean force_;
    /**
     *
     *
     * <pre>
     * Optional. Create the connection profile without validating it.
     * </pre>
     *
     * <code>bool force = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The force.
     */
    @java.lang.Override
    public boolean getForce() {
      return force_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Create the connection profile without validating it.
     * </pre>
     *
     * <code>bool force = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The force to set.
     * @return This builder for chaining.
     */
    public Builder setForce(boolean value) {

      force_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Create the connection profile without validating it.
     * </pre>
     *
     * <code>bool force = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearForce() {

      force_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datastream.v1.CreateConnectionProfileRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datastream.v1.CreateConnectionProfileRequest)
  private static final com.google.cloud.datastream.v1.CreateConnectionProfileRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datastream.v1.CreateConnectionProfileRequest();
  }

  public static com.google.cloud.datastream.v1.CreateConnectionProfileRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateConnectionProfileRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreateConnectionProfileRequest>() {
        @java.lang.Override
        public CreateConnectionProfileRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateConnectionProfileRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateConnectionProfileRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datastream.v1.CreateConnectionProfileRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
