/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datastream/v1/datastream_resources.proto

package com.google.cloud.datastream.v1;

/** Protobuf type {@code google.cloud.datastream.v1.BigQueryDestinationConfig} */
public final class BigQueryDestinationConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datastream.v1.BigQueryDestinationConfig)
    BigQueryDestinationConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BigQueryDestinationConfig.newBuilder() to construct.
  private BigQueryDestinationConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BigQueryDestinationConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BigQueryDestinationConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datastream.v1.DatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1_BigQueryDestinationConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datastream.v1.DatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1_BigQueryDestinationConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datastream.v1.BigQueryDestinationConfig.class,
            com.google.cloud.datastream.v1.BigQueryDestinationConfig.Builder.class);
  }

  public interface SingleTargetDatasetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>string dataset_id = 1;</code>
     *
     * @return The datasetId.
     */
    java.lang.String getDatasetId();
    /**
     * <code>string dataset_id = 1;</code>
     *
     * @return The bytes for datasetId.
     */
    com.google.protobuf.ByteString getDatasetIdBytes();
  }
  /**
   *
   *
   * <pre>
   * A single target dataset to which all data will be streamed.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset}
   */
  public static final class SingleTargetDataset extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset)
      SingleTargetDatasetOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SingleTargetDataset.newBuilder() to construct.
    private SingleTargetDataset(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SingleTargetDataset() {
      datasetId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SingleTargetDataset();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_BigQueryDestinationConfig_SingleTargetDataset_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_BigQueryDestinationConfig_SingleTargetDataset_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset.class,
              com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset.Builder
                  .class);
    }

    public static final int DATASET_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object datasetId_;
    /**
     * <code>string dataset_id = 1;</code>
     *
     * @return The datasetId.
     */
    @java.lang.Override
    public java.lang.String getDatasetId() {
      java.lang.Object ref = datasetId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        datasetId_ = s;
        return s;
      }
    }
    /**
     * <code>string dataset_id = 1;</code>
     *
     * @return The bytes for datasetId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDatasetIdBytes() {
      java.lang.Object ref = datasetId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        datasetId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, datasetId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, datasetId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset)) {
        return super.equals(obj);
      }
      com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset other =
          (com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset) obj;

      if (!getDatasetId().equals(other.getDatasetId())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DATASET_ID_FIELD_NUMBER;
      hash = (53 * hash) + getDatasetId().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A single target dataset to which all data will be streamed.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset)
        com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDatasetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datastream.v1.DatastreamResourcesProto
            .internal_static_google_cloud_datastream_v1_BigQueryDestinationConfig_SingleTargetDataset_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datastream.v1.DatastreamResourcesProto
            .internal_static_google_cloud_datastream_v1_BigQueryDestinationConfig_SingleTargetDataset_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset.class,
                com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        datasetId_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.datastream.v1.DatastreamResourcesProto
            .internal_static_google_cloud_datastream_v1_BigQueryDestinationConfig_SingleTargetDataset_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
          getDefaultInstanceForType() {
        return com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset build() {
        com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
          buildPartial() {
        com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset result =
            new com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset(this);
        result.datasetId_ = datasetId_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset) {
          return mergeFrom(
              (com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset other) {
        if (other
            == com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
                .getDefaultInstance()) return this;
        if (!other.getDatasetId().isEmpty()) {
          datasetId_ = other.datasetId_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  datasetId_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object datasetId_ = "";
      /**
       * <code>string dataset_id = 1;</code>
       *
       * @return The datasetId.
       */
      public java.lang.String getDatasetId() {
        java.lang.Object ref = datasetId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          datasetId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string dataset_id = 1;</code>
       *
       * @return The bytes for datasetId.
       */
      public com.google.protobuf.ByteString getDatasetIdBytes() {
        java.lang.Object ref = datasetId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          datasetId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string dataset_id = 1;</code>
       *
       * @param value The datasetId to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        datasetId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string dataset_id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDatasetId() {

        datasetId_ = getDefaultInstance().getDatasetId();
        onChanged();
        return this;
      }
      /**
       * <code>string dataset_id = 1;</code>
       *
       * @param value The bytes for datasetId to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        datasetId_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset)
    private static final com.google.cloud.datastream.v1.BigQueryDestinationConfig
            .SingleTargetDataset
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset();
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SingleTargetDataset> PARSER =
        new com.google.protobuf.AbstractParser<SingleTargetDataset>() {
          @java.lang.Override
          public SingleTargetDataset parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SingleTargetDataset> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SingleTargetDataset> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SourceHierarchyDatasetsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>
     * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate dataset_template = 2;
     * </code>
     *
     * @return Whether the datasetTemplate field is set.
     */
    boolean hasDatasetTemplate();
    /**
     * <code>
     * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate dataset_template = 2;
     * </code>
     *
     * @return The datasetTemplate.
     */
    com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate
        getDatasetTemplate();
    /**
     * <code>
     * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate dataset_template = 2;
     * </code>
     */
    com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
            .DatasetTemplateOrBuilder
        getDatasetTemplateOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Destination datasets are created so that hierarchy of the destination data
   * objects matches the source hierarchy.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets}
   */
  public static final class SourceHierarchyDatasets extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets)
      SourceHierarchyDatasetsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SourceHierarchyDatasets.newBuilder() to construct.
    private SourceHierarchyDatasets(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SourceHierarchyDatasets() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SourceHierarchyDatasets();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_BigQueryDestinationConfig_SourceHierarchyDatasets_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_BigQueryDestinationConfig_SourceHierarchyDatasets_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                  .class,
              com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                  .Builder.class);
    }

    public interface DatasetTemplateOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The geographic location where the dataset should reside. See
       * https://cloud.google.com/bigquery/docs/locations for supported
       * locations.
       * </pre>
       *
       * <code>string location = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The location.
       */
      java.lang.String getLocation();
      /**
       *
       *
       * <pre>
       * Required. The geographic location where the dataset should reside. See
       * https://cloud.google.com/bigquery/docs/locations for supported
       * locations.
       * </pre>
       *
       * <code>string location = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for location.
       */
      com.google.protobuf.ByteString getLocationBytes();

      /**
       *
       *
       * <pre>
       * If supplied, every created dataset will have its name prefixed by the
       * provided value. The prefix and name will be separated by an underscore.
       * i.e. &lt;prefix&gt;_&lt;dataset_name&gt;.
       * </pre>
       *
       * <code>string dataset_id_prefix = 2;</code>
       *
       * @return The datasetIdPrefix.
       */
      java.lang.String getDatasetIdPrefix();
      /**
       *
       *
       * <pre>
       * If supplied, every created dataset will have its name prefixed by the
       * provided value. The prefix and name will be separated by an underscore.
       * i.e. &lt;prefix&gt;_&lt;dataset_name&gt;.
       * </pre>
       *
       * <code>string dataset_id_prefix = 2;</code>
       *
       * @return The bytes for datasetIdPrefix.
       */
      com.google.protobuf.ByteString getDatasetIdPrefixBytes();

      /**
       *
       *
       * <pre>
       * Describes the Cloud KMS encryption key that will be used to
       * protect destination BigQuery table. The BigQuery Service Account
       * associated with your project requires access to this encryption key.
       * i.e.
       * projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{cryptoKey}.
       * See https://cloud.google.com/bigquery/docs/customer-managed-encryption
       * for more information.
       * </pre>
       *
       * <code>string kms_key_name = 3;</code>
       *
       * @return The kmsKeyName.
       */
      java.lang.String getKmsKeyName();
      /**
       *
       *
       * <pre>
       * Describes the Cloud KMS encryption key that will be used to
       * protect destination BigQuery table. The BigQuery Service Account
       * associated with your project requires access to this encryption key.
       * i.e.
       * projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{cryptoKey}.
       * See https://cloud.google.com/bigquery/docs/customer-managed-encryption
       * for more information.
       * </pre>
       *
       * <code>string kms_key_name = 3;</code>
       *
       * @return The bytes for kmsKeyName.
       */
      com.google.protobuf.ByteString getKmsKeyNameBytes();
    }
    /**
     *
     *
     * <pre>
     * Dataset template used for dynamic dataset creation.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate}
     */
    public static final class DatasetTemplate extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate)
        DatasetTemplateOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use DatasetTemplate.newBuilder() to construct.
      private DatasetTemplate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private DatasetTemplate() {
        location_ = "";
        datasetIdPrefix_ = "";
        kmsKeyName_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new DatasetTemplate();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datastream.v1.DatastreamResourcesProto
            .internal_static_google_cloud_datastream_v1_BigQueryDestinationConfig_SourceHierarchyDatasets_DatasetTemplate_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datastream.v1.DatastreamResourcesProto
            .internal_static_google_cloud_datastream_v1_BigQueryDestinationConfig_SourceHierarchyDatasets_DatasetTemplate_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                    .DatasetTemplate.class,
                com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                    .DatasetTemplate.Builder.class);
      }

      public static final int LOCATION_FIELD_NUMBER = 1;
      private volatile java.lang.Object location_;
      /**
       *
       *
       * <pre>
       * Required. The geographic location where the dataset should reside. See
       * https://cloud.google.com/bigquery/docs/locations for supported
       * locations.
       * </pre>
       *
       * <code>string location = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The location.
       */
      @java.lang.Override
      public java.lang.String getLocation() {
        java.lang.Object ref = location_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          location_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The geographic location where the dataset should reside. See
       * https://cloud.google.com/bigquery/docs/locations for supported
       * locations.
       * </pre>
       *
       * <code>string location = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for location.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getLocationBytes() {
        java.lang.Object ref = location_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          location_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int DATASET_ID_PREFIX_FIELD_NUMBER = 2;
      private volatile java.lang.Object datasetIdPrefix_;
      /**
       *
       *
       * <pre>
       * If supplied, every created dataset will have its name prefixed by the
       * provided value. The prefix and name will be separated by an underscore.
       * i.e. &lt;prefix&gt;_&lt;dataset_name&gt;.
       * </pre>
       *
       * <code>string dataset_id_prefix = 2;</code>
       *
       * @return The datasetIdPrefix.
       */
      @java.lang.Override
      public java.lang.String getDatasetIdPrefix() {
        java.lang.Object ref = datasetIdPrefix_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          datasetIdPrefix_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * If supplied, every created dataset will have its name prefixed by the
       * provided value. The prefix and name will be separated by an underscore.
       * i.e. &lt;prefix&gt;_&lt;dataset_name&gt;.
       * </pre>
       *
       * <code>string dataset_id_prefix = 2;</code>
       *
       * @return The bytes for datasetIdPrefix.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDatasetIdPrefixBytes() {
        java.lang.Object ref = datasetIdPrefix_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          datasetIdPrefix_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int KMS_KEY_NAME_FIELD_NUMBER = 3;
      private volatile java.lang.Object kmsKeyName_;
      /**
       *
       *
       * <pre>
       * Describes the Cloud KMS encryption key that will be used to
       * protect destination BigQuery table. The BigQuery Service Account
       * associated with your project requires access to this encryption key.
       * i.e.
       * projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{cryptoKey}.
       * See https://cloud.google.com/bigquery/docs/customer-managed-encryption
       * for more information.
       * </pre>
       *
       * <code>string kms_key_name = 3;</code>
       *
       * @return The kmsKeyName.
       */
      @java.lang.Override
      public java.lang.String getKmsKeyName() {
        java.lang.Object ref = kmsKeyName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          kmsKeyName_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Describes the Cloud KMS encryption key that will be used to
       * protect destination BigQuery table. The BigQuery Service Account
       * associated with your project requires access to this encryption key.
       * i.e.
       * projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{cryptoKey}.
       * See https://cloud.google.com/bigquery/docs/customer-managed-encryption
       * for more information.
       * </pre>
       *
       * <code>string kms_key_name = 3;</code>
       *
       * @return The bytes for kmsKeyName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getKmsKeyNameBytes() {
        java.lang.Object ref = kmsKeyName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          kmsKeyName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, location_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetIdPrefix_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, datasetIdPrefix_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, kmsKeyName_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, location_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetIdPrefix_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, datasetIdPrefix_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, kmsKeyName_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                .DatasetTemplate)) {
          return super.equals(obj);
        }
        com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                .DatasetTemplate
            other =
                (com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                        .DatasetTemplate)
                    obj;

        if (!getLocation().equals(other.getLocation())) return false;
        if (!getDatasetIdPrefix().equals(other.getDatasetIdPrefix())) return false;
        if (!getKmsKeyName().equals(other.getKmsKeyName())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + LOCATION_FIELD_NUMBER;
        hash = (53 * hash) + getLocation().hashCode();
        hash = (37 * hash) + DATASET_ID_PREFIX_FIELD_NUMBER;
        hash = (53 * hash) + getDatasetIdPrefix().hashCode();
        hash = (37 * hash) + KMS_KEY_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getKmsKeyName().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
              .DatasetTemplate
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
              .DatasetTemplate
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
              .DatasetTemplate
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
              .DatasetTemplate
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
              .DatasetTemplate
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
              .DatasetTemplate
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
              .DatasetTemplate
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
              .DatasetTemplate
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
              .DatasetTemplate
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
              .DatasetTemplate
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
              .DatasetTemplate
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
              .DatasetTemplate
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                  .DatasetTemplate
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Dataset template used for dynamic dataset creation.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate)
          com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
              .DatasetTemplateOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.datastream.v1.DatastreamResourcesProto
              .internal_static_google_cloud_datastream_v1_BigQueryDestinationConfig_SourceHierarchyDatasets_DatasetTemplate_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.datastream.v1.DatastreamResourcesProto
              .internal_static_google_cloud_datastream_v1_BigQueryDestinationConfig_SourceHierarchyDatasets_DatasetTemplate_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                      .DatasetTemplate.class,
                  com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                      .DatasetTemplate.Builder.class);
        }

        // Construct using
        // com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          location_ = "";

          datasetIdPrefix_ = "";

          kmsKeyName_ = "";

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.datastream.v1.DatastreamResourcesProto
              .internal_static_google_cloud_datastream_v1_BigQueryDestinationConfig_SourceHierarchyDatasets_DatasetTemplate_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                .DatasetTemplate
            getDefaultInstanceForType() {
          return com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
              .DatasetTemplate.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                .DatasetTemplate
            build() {
          com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                  .DatasetTemplate
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                .DatasetTemplate
            buildPartial() {
          com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                  .DatasetTemplate
              result =
                  new com.google.cloud.datastream.v1.BigQueryDestinationConfig
                      .SourceHierarchyDatasets.DatasetTemplate(this);
          result.location_ = location_;
          result.datasetIdPrefix_ = datasetIdPrefix_;
          result.kmsKeyName_ = kmsKeyName_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                  .DatasetTemplate) {
            return mergeFrom(
                (com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                        .DatasetTemplate)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                    .DatasetTemplate
                other) {
          if (other
              == com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                  .DatasetTemplate.getDefaultInstance()) return this;
          if (!other.getLocation().isEmpty()) {
            location_ = other.location_;
            onChanged();
          }
          if (!other.getDatasetIdPrefix().isEmpty()) {
            datasetIdPrefix_ = other.datasetIdPrefix_;
            onChanged();
          }
          if (!other.getKmsKeyName().isEmpty()) {
            kmsKeyName_ = other.kmsKeyName_;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    location_ = input.readStringRequireUtf8();

                    break;
                  } // case 10
                case 18:
                  {
                    datasetIdPrefix_ = input.readStringRequireUtf8();

                    break;
                  } // case 18
                case 26:
                  {
                    kmsKeyName_ = input.readStringRequireUtf8();

                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private java.lang.Object location_ = "";
        /**
         *
         *
         * <pre>
         * Required. The geographic location where the dataset should reside. See
         * https://cloud.google.com/bigquery/docs/locations for supported
         * locations.
         * </pre>
         *
         * <code>string location = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The location.
         */
        public java.lang.String getLocation() {
          java.lang.Object ref = location_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            location_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The geographic location where the dataset should reside. See
         * https://cloud.google.com/bigquery/docs/locations for supported
         * locations.
         * </pre>
         *
         * <code>string location = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for location.
         */
        public com.google.protobuf.ByteString getLocationBytes() {
          java.lang.Object ref = location_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            location_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The geographic location where the dataset should reside. See
         * https://cloud.google.com/bigquery/docs/locations for supported
         * locations.
         * </pre>
         *
         * <code>string location = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The location to set.
         * @return This builder for chaining.
         */
        public Builder setLocation(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          location_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The geographic location where the dataset should reside. See
         * https://cloud.google.com/bigquery/docs/locations for supported
         * locations.
         * </pre>
         *
         * <code>string location = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearLocation() {

          location_ = getDefaultInstance().getLocation();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The geographic location where the dataset should reside. See
         * https://cloud.google.com/bigquery/docs/locations for supported
         * locations.
         * </pre>
         *
         * <code>string location = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for location to set.
         * @return This builder for chaining.
         */
        public Builder setLocationBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          location_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object datasetIdPrefix_ = "";
        /**
         *
         *
         * <pre>
         * If supplied, every created dataset will have its name prefixed by the
         * provided value. The prefix and name will be separated by an underscore.
         * i.e. &lt;prefix&gt;_&lt;dataset_name&gt;.
         * </pre>
         *
         * <code>string dataset_id_prefix = 2;</code>
         *
         * @return The datasetIdPrefix.
         */
        public java.lang.String getDatasetIdPrefix() {
          java.lang.Object ref = datasetIdPrefix_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            datasetIdPrefix_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * If supplied, every created dataset will have its name prefixed by the
         * provided value. The prefix and name will be separated by an underscore.
         * i.e. &lt;prefix&gt;_&lt;dataset_name&gt;.
         * </pre>
         *
         * <code>string dataset_id_prefix = 2;</code>
         *
         * @return The bytes for datasetIdPrefix.
         */
        public com.google.protobuf.ByteString getDatasetIdPrefixBytes() {
          java.lang.Object ref = datasetIdPrefix_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            datasetIdPrefix_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * If supplied, every created dataset will have its name prefixed by the
         * provided value. The prefix and name will be separated by an underscore.
         * i.e. &lt;prefix&gt;_&lt;dataset_name&gt;.
         * </pre>
         *
         * <code>string dataset_id_prefix = 2;</code>
         *
         * @param value The datasetIdPrefix to set.
         * @return This builder for chaining.
         */
        public Builder setDatasetIdPrefix(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          datasetIdPrefix_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * If supplied, every created dataset will have its name prefixed by the
         * provided value. The prefix and name will be separated by an underscore.
         * i.e. &lt;prefix&gt;_&lt;dataset_name&gt;.
         * </pre>
         *
         * <code>string dataset_id_prefix = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDatasetIdPrefix() {

          datasetIdPrefix_ = getDefaultInstance().getDatasetIdPrefix();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * If supplied, every created dataset will have its name prefixed by the
         * provided value. The prefix and name will be separated by an underscore.
         * i.e. &lt;prefix&gt;_&lt;dataset_name&gt;.
         * </pre>
         *
         * <code>string dataset_id_prefix = 2;</code>
         *
         * @param value The bytes for datasetIdPrefix to set.
         * @return This builder for chaining.
         */
        public Builder setDatasetIdPrefixBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          datasetIdPrefix_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object kmsKeyName_ = "";
        /**
         *
         *
         * <pre>
         * Describes the Cloud KMS encryption key that will be used to
         * protect destination BigQuery table. The BigQuery Service Account
         * associated with your project requires access to this encryption key.
         * i.e.
         * projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{cryptoKey}.
         * See https://cloud.google.com/bigquery/docs/customer-managed-encryption
         * for more information.
         * </pre>
         *
         * <code>string kms_key_name = 3;</code>
         *
         * @return The kmsKeyName.
         */
        public java.lang.String getKmsKeyName() {
          java.lang.Object ref = kmsKeyName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            kmsKeyName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Describes the Cloud KMS encryption key that will be used to
         * protect destination BigQuery table. The BigQuery Service Account
         * associated with your project requires access to this encryption key.
         * i.e.
         * projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{cryptoKey}.
         * See https://cloud.google.com/bigquery/docs/customer-managed-encryption
         * for more information.
         * </pre>
         *
         * <code>string kms_key_name = 3;</code>
         *
         * @return The bytes for kmsKeyName.
         */
        public com.google.protobuf.ByteString getKmsKeyNameBytes() {
          java.lang.Object ref = kmsKeyName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            kmsKeyName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Describes the Cloud KMS encryption key that will be used to
         * protect destination BigQuery table. The BigQuery Service Account
         * associated with your project requires access to this encryption key.
         * i.e.
         * projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{cryptoKey}.
         * See https://cloud.google.com/bigquery/docs/customer-managed-encryption
         * for more information.
         * </pre>
         *
         * <code>string kms_key_name = 3;</code>
         *
         * @param value The kmsKeyName to set.
         * @return This builder for chaining.
         */
        public Builder setKmsKeyName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          kmsKeyName_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Describes the Cloud KMS encryption key that will be used to
         * protect destination BigQuery table. The BigQuery Service Account
         * associated with your project requires access to this encryption key.
         * i.e.
         * projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{cryptoKey}.
         * See https://cloud.google.com/bigquery/docs/customer-managed-encryption
         * for more information.
         * </pre>
         *
         * <code>string kms_key_name = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearKmsKeyName() {

          kmsKeyName_ = getDefaultInstance().getKmsKeyName();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Describes the Cloud KMS encryption key that will be used to
         * protect destination BigQuery table. The BigQuery Service Account
         * associated with your project requires access to this encryption key.
         * i.e.
         * projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{cryptoKey}.
         * See https://cloud.google.com/bigquery/docs/customer-managed-encryption
         * for more information.
         * </pre>
         *
         * <code>string kms_key_name = 3;</code>
         *
         * @param value The bytes for kmsKeyName to set.
         * @return This builder for chaining.
         */
        public Builder setKmsKeyNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          kmsKeyName_ = value;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate)
      private static final com.google.cloud.datastream.v1.BigQueryDestinationConfig
              .SourceHierarchyDatasets.DatasetTemplate
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                .DatasetTemplate();
      }

      public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
              .DatasetTemplate
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<DatasetTemplate> PARSER =
          new com.google.protobuf.AbstractParser<DatasetTemplate>() {
            @java.lang.Override
            public DatasetTemplate parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<DatasetTemplate> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<DatasetTemplate> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
              .DatasetTemplate
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int DATASET_TEMPLATE_FIELD_NUMBER = 2;
    private com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
            .DatasetTemplate
        datasetTemplate_;
    /**
     * <code>
     * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate dataset_template = 2;
     * </code>
     *
     * @return Whether the datasetTemplate field is set.
     */
    @java.lang.Override
    public boolean hasDatasetTemplate() {
      return datasetTemplate_ != null;
    }
    /**
     * <code>
     * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate dataset_template = 2;
     * </code>
     *
     * @return The datasetTemplate.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
            .DatasetTemplate
        getDatasetTemplate() {
      return datasetTemplate_ == null
          ? com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
              .DatasetTemplate.getDefaultInstance()
          : datasetTemplate_;
    }
    /**
     * <code>
     * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate dataset_template = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
            .DatasetTemplateOrBuilder
        getDatasetTemplateOrBuilder() {
      return getDatasetTemplate();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (datasetTemplate_ != null) {
        output.writeMessage(2, getDatasetTemplate());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (datasetTemplate_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDatasetTemplate());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets)) {
        return super.equals(obj);
      }
      com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets other =
          (com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets) obj;

      if (hasDatasetTemplate() != other.hasDatasetTemplate()) return false;
      if (hasDatasetTemplate()) {
        if (!getDatasetTemplate().equals(other.getDatasetTemplate())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasDatasetTemplate()) {
        hash = (37 * hash) + DATASET_TEMPLATE_FIELD_NUMBER;
        hash = (53 * hash) + getDatasetTemplate().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Destination datasets are created so that hierarchy of the destination data
     * objects matches the source hierarchy.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets)
        com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasetsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datastream.v1.DatastreamResourcesProto
            .internal_static_google_cloud_datastream_v1_BigQueryDestinationConfig_SourceHierarchyDatasets_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datastream.v1.DatastreamResourcesProto
            .internal_static_google_cloud_datastream_v1_BigQueryDestinationConfig_SourceHierarchyDatasets_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                    .class,
                com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (datasetTemplateBuilder_ == null) {
          datasetTemplate_ = null;
        } else {
          datasetTemplate_ = null;
          datasetTemplateBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.datastream.v1.DatastreamResourcesProto
            .internal_static_google_cloud_datastream_v1_BigQueryDestinationConfig_SourceHierarchyDatasets_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
          getDefaultInstanceForType() {
        return com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
          build() {
        com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
          buildPartial() {
        com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets result =
            new com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets(
                this);
        if (datasetTemplateBuilder_ == null) {
          result.datasetTemplate_ = datasetTemplate_;
        } else {
          result.datasetTemplate_ = datasetTemplateBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets) {
          return mergeFrom(
              (com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets other) {
        if (other
            == com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                .getDefaultInstance()) return this;
        if (other.hasDatasetTemplate()) {
          mergeDatasetTemplate(other.getDatasetTemplate());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  input.readMessage(
                      getDatasetTemplateFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
              .DatasetTemplate
          datasetTemplate_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                  .DatasetTemplate,
              com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                  .DatasetTemplate.Builder,
              com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                  .DatasetTemplateOrBuilder>
          datasetTemplateBuilder_;
      /**
       * <code>
       * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate dataset_template = 2;
       * </code>
       *
       * @return Whether the datasetTemplate field is set.
       */
      public boolean hasDatasetTemplate() {
        return datasetTemplateBuilder_ != null || datasetTemplate_ != null;
      }
      /**
       * <code>
       * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate dataset_template = 2;
       * </code>
       *
       * @return The datasetTemplate.
       */
      public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
              .DatasetTemplate
          getDatasetTemplate() {
        if (datasetTemplateBuilder_ == null) {
          return datasetTemplate_ == null
              ? com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                  .DatasetTemplate.getDefaultInstance()
              : datasetTemplate_;
        } else {
          return datasetTemplateBuilder_.getMessage();
        }
      }
      /**
       * <code>
       * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate dataset_template = 2;
       * </code>
       */
      public Builder setDatasetTemplate(
          com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                  .DatasetTemplate
              value) {
        if (datasetTemplateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          datasetTemplate_ = value;
          onChanged();
        } else {
          datasetTemplateBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <code>
       * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate dataset_template = 2;
       * </code>
       */
      public Builder setDatasetTemplate(
          com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                  .DatasetTemplate.Builder
              builderForValue) {
        if (datasetTemplateBuilder_ == null) {
          datasetTemplate_ = builderForValue.build();
          onChanged();
        } else {
          datasetTemplateBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <code>
       * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate dataset_template = 2;
       * </code>
       */
      public Builder mergeDatasetTemplate(
          com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                  .DatasetTemplate
              value) {
        if (datasetTemplateBuilder_ == null) {
          if (datasetTemplate_ != null) {
            datasetTemplate_ =
                com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                    .DatasetTemplate.newBuilder(datasetTemplate_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            datasetTemplate_ = value;
          }
          onChanged();
        } else {
          datasetTemplateBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <code>
       * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate dataset_template = 2;
       * </code>
       */
      public Builder clearDatasetTemplate() {
        if (datasetTemplateBuilder_ == null) {
          datasetTemplate_ = null;
          onChanged();
        } else {
          datasetTemplate_ = null;
          datasetTemplateBuilder_ = null;
        }

        return this;
      }
      /**
       * <code>
       * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate dataset_template = 2;
       * </code>
       */
      public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
              .DatasetTemplate.Builder
          getDatasetTemplateBuilder() {

        onChanged();
        return getDatasetTemplateFieldBuilder().getBuilder();
      }
      /**
       * <code>
       * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate dataset_template = 2;
       * </code>
       */
      public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
              .DatasetTemplateOrBuilder
          getDatasetTemplateOrBuilder() {
        if (datasetTemplateBuilder_ != null) {
          return datasetTemplateBuilder_.getMessageOrBuilder();
        } else {
          return datasetTemplate_ == null
              ? com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                  .DatasetTemplate.getDefaultInstance()
              : datasetTemplate_;
        }
      }
      /**
       * <code>
       * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate dataset_template = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                  .DatasetTemplate,
              com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                  .DatasetTemplate.Builder,
              com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                  .DatasetTemplateOrBuilder>
          getDatasetTemplateFieldBuilder() {
        if (datasetTemplateBuilder_ == null) {
          datasetTemplateBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                      .DatasetTemplate,
                  com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                      .DatasetTemplate.Builder,
                  com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                      .DatasetTemplateOrBuilder>(
                  getDatasetTemplate(), getParentForChildren(), isClean());
          datasetTemplate_ = null;
        }
        return datasetTemplateBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets)
    private static final com.google.cloud.datastream.v1.BigQueryDestinationConfig
            .SourceHierarchyDatasets
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets();
    }

    public static com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SourceHierarchyDatasets> PARSER =
        new com.google.protobuf.AbstractParser<SourceHierarchyDatasets>() {
          @java.lang.Override
          public SourceHierarchyDatasets parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SourceHierarchyDatasets> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SourceHierarchyDatasets> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int datasetConfigCase_ = 0;
  private java.lang.Object datasetConfig_;

  public enum DatasetConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SINGLE_TARGET_DATASET(201),
    SOURCE_HIERARCHY_DATASETS(202),
    DATASETCONFIG_NOT_SET(0);
    private final int value;

    private DatasetConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DatasetConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static DatasetConfigCase forNumber(int value) {
      switch (value) {
        case 201:
          return SINGLE_TARGET_DATASET;
        case 202:
          return SOURCE_HIERARCHY_DATASETS;
        case 0:
          return DATASETCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DatasetConfigCase getDatasetConfigCase() {
    return DatasetConfigCase.forNumber(datasetConfigCase_);
  }

  public static final int SINGLE_TARGET_DATASET_FIELD_NUMBER = 201;
  /**
   *
   *
   * <pre>
   * Single destination dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset single_target_dataset = 201;
   * </code>
   *
   * @return Whether the singleTargetDataset field is set.
   */
  @java.lang.Override
  public boolean hasSingleTargetDataset() {
    return datasetConfigCase_ == 201;
  }
  /**
   *
   *
   * <pre>
   * Single destination dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset single_target_dataset = 201;
   * </code>
   *
   * @return The singleTargetDataset.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
      getSingleTargetDataset() {
    if (datasetConfigCase_ == 201) {
      return (com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset)
          datasetConfig_;
    }
    return com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Single destination dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset single_target_dataset = 201;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDatasetOrBuilder
      getSingleTargetDatasetOrBuilder() {
    if (datasetConfigCase_ == 201) {
      return (com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset)
          datasetConfig_;
    }
    return com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
        .getDefaultInstance();
  }

  public static final int SOURCE_HIERARCHY_DATASETS_FIELD_NUMBER = 202;
  /**
   *
   *
   * <pre>
   * Source hierarchy datasets.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets source_hierarchy_datasets = 202;
   * </code>
   *
   * @return Whether the sourceHierarchyDatasets field is set.
   */
  @java.lang.Override
  public boolean hasSourceHierarchyDatasets() {
    return datasetConfigCase_ == 202;
  }
  /**
   *
   *
   * <pre>
   * Source hierarchy datasets.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets source_hierarchy_datasets = 202;
   * </code>
   *
   * @return The sourceHierarchyDatasets.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
      getSourceHierarchyDatasets() {
    if (datasetConfigCase_ == 202) {
      return (com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets)
          datasetConfig_;
    }
    return com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Source hierarchy datasets.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets source_hierarchy_datasets = 202;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasetsOrBuilder
      getSourceHierarchyDatasetsOrBuilder() {
    if (datasetConfigCase_ == 202) {
      return (com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets)
          datasetConfig_;
    }
    return com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
        .getDefaultInstance();
  }

  public static final int DATA_FRESHNESS_FIELD_NUMBER = 300;
  private com.google.protobuf.Duration dataFreshness_;
  /**
   *
   *
   * <pre>
   * The guaranteed data freshness (in seconds) when querying tables created by
   * the stream. Editing this field will only affect new tables created in the
   * future, but existing tables will not be impacted. Lower values mean that
   * queries will return fresher data, but may result in higher cost.
   * </pre>
   *
   * <code>.google.protobuf.Duration data_freshness = 300;</code>
   *
   * @return Whether the dataFreshness field is set.
   */
  @java.lang.Override
  public boolean hasDataFreshness() {
    return dataFreshness_ != null;
  }
  /**
   *
   *
   * <pre>
   * The guaranteed data freshness (in seconds) when querying tables created by
   * the stream. Editing this field will only affect new tables created in the
   * future, but existing tables will not be impacted. Lower values mean that
   * queries will return fresher data, but may result in higher cost.
   * </pre>
   *
   * <code>.google.protobuf.Duration data_freshness = 300;</code>
   *
   * @return The dataFreshness.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getDataFreshness() {
    return dataFreshness_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : dataFreshness_;
  }
  /**
   *
   *
   * <pre>
   * The guaranteed data freshness (in seconds) when querying tables created by
   * the stream. Editing this field will only affect new tables created in the
   * future, but existing tables will not be impacted. Lower values mean that
   * queries will return fresher data, but may result in higher cost.
   * </pre>
   *
   * <code>.google.protobuf.Duration data_freshness = 300;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getDataFreshnessOrBuilder() {
    return getDataFreshness();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (datasetConfigCase_ == 201) {
      output.writeMessage(
          201,
          (com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset)
              datasetConfig_);
    }
    if (datasetConfigCase_ == 202) {
      output.writeMessage(
          202,
          (com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets)
              datasetConfig_);
    }
    if (dataFreshness_ != null) {
      output.writeMessage(300, getDataFreshness());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (datasetConfigCase_ == 201) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              201,
              (com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset)
                  datasetConfig_);
    }
    if (datasetConfigCase_ == 202) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              202,
              (com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets)
                  datasetConfig_);
    }
    if (dataFreshness_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(300, getDataFreshness());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datastream.v1.BigQueryDestinationConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.datastream.v1.BigQueryDestinationConfig other =
        (com.google.cloud.datastream.v1.BigQueryDestinationConfig) obj;

    if (hasDataFreshness() != other.hasDataFreshness()) return false;
    if (hasDataFreshness()) {
      if (!getDataFreshness().equals(other.getDataFreshness())) return false;
    }
    if (!getDatasetConfigCase().equals(other.getDatasetConfigCase())) return false;
    switch (datasetConfigCase_) {
      case 201:
        if (!getSingleTargetDataset().equals(other.getSingleTargetDataset())) return false;
        break;
      case 202:
        if (!getSourceHierarchyDatasets().equals(other.getSourceHierarchyDatasets())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDataFreshness()) {
      hash = (37 * hash) + DATA_FRESHNESS_FIELD_NUMBER;
      hash = (53 * hash) + getDataFreshness().hashCode();
    }
    switch (datasetConfigCase_) {
      case 201:
        hash = (37 * hash) + SINGLE_TARGET_DATASET_FIELD_NUMBER;
        hash = (53 * hash) + getSingleTargetDataset().hashCode();
        break;
      case 202:
        hash = (37 * hash) + SOURCE_HIERARCHY_DATASETS_FIELD_NUMBER;
        hash = (53 * hash) + getSourceHierarchyDatasets().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datastream.v1.BigQueryDestinationConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.BigQueryDestinationConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.BigQueryDestinationConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.BigQueryDestinationConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.BigQueryDestinationConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.BigQueryDestinationConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.BigQueryDestinationConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.BigQueryDestinationConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.BigQueryDestinationConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.BigQueryDestinationConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.BigQueryDestinationConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.BigQueryDestinationConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datastream.v1.BigQueryDestinationConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /** Protobuf type {@code google.cloud.datastream.v1.BigQueryDestinationConfig} */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datastream.v1.BigQueryDestinationConfig)
      com.google.cloud.datastream.v1.BigQueryDestinationConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_BigQueryDestinationConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_BigQueryDestinationConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datastream.v1.BigQueryDestinationConfig.class,
              com.google.cloud.datastream.v1.BigQueryDestinationConfig.Builder.class);
    }

    // Construct using com.google.cloud.datastream.v1.BigQueryDestinationConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (singleTargetDatasetBuilder_ != null) {
        singleTargetDatasetBuilder_.clear();
      }
      if (sourceHierarchyDatasetsBuilder_ != null) {
        sourceHierarchyDatasetsBuilder_.clear();
      }
      if (dataFreshnessBuilder_ == null) {
        dataFreshness_ = null;
      } else {
        dataFreshness_ = null;
        dataFreshnessBuilder_ = null;
      }
      datasetConfigCase_ = 0;
      datasetConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_BigQueryDestinationConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.BigQueryDestinationConfig getDefaultInstanceForType() {
      return com.google.cloud.datastream.v1.BigQueryDestinationConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.BigQueryDestinationConfig build() {
      com.google.cloud.datastream.v1.BigQueryDestinationConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.BigQueryDestinationConfig buildPartial() {
      com.google.cloud.datastream.v1.BigQueryDestinationConfig result =
          new com.google.cloud.datastream.v1.BigQueryDestinationConfig(this);
      if (datasetConfigCase_ == 201) {
        if (singleTargetDatasetBuilder_ == null) {
          result.datasetConfig_ = datasetConfig_;
        } else {
          result.datasetConfig_ = singleTargetDatasetBuilder_.build();
        }
      }
      if (datasetConfigCase_ == 202) {
        if (sourceHierarchyDatasetsBuilder_ == null) {
          result.datasetConfig_ = datasetConfig_;
        } else {
          result.datasetConfig_ = sourceHierarchyDatasetsBuilder_.build();
        }
      }
      if (dataFreshnessBuilder_ == null) {
        result.dataFreshness_ = dataFreshness_;
      } else {
        result.dataFreshness_ = dataFreshnessBuilder_.build();
      }
      result.datasetConfigCase_ = datasetConfigCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datastream.v1.BigQueryDestinationConfig) {
        return mergeFrom((com.google.cloud.datastream.v1.BigQueryDestinationConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datastream.v1.BigQueryDestinationConfig other) {
      if (other == com.google.cloud.datastream.v1.BigQueryDestinationConfig.getDefaultInstance())
        return this;
      if (other.hasDataFreshness()) {
        mergeDataFreshness(other.getDataFreshness());
      }
      switch (other.getDatasetConfigCase()) {
        case SINGLE_TARGET_DATASET:
          {
            mergeSingleTargetDataset(other.getSingleTargetDataset());
            break;
          }
        case SOURCE_HIERARCHY_DATASETS:
          {
            mergeSourceHierarchyDatasets(other.getSourceHierarchyDatasets());
            break;
          }
        case DATASETCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 1610:
              {
                input.readMessage(
                    getSingleTargetDatasetFieldBuilder().getBuilder(), extensionRegistry);
                datasetConfigCase_ = 201;
                break;
              } // case 1610
            case 1618:
              {
                input.readMessage(
                    getSourceHierarchyDatasetsFieldBuilder().getBuilder(), extensionRegistry);
                datasetConfigCase_ = 202;
                break;
              } // case 1618
            case 2402:
              {
                input.readMessage(getDataFreshnessFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 2402
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int datasetConfigCase_ = 0;
    private java.lang.Object datasetConfig_;

    public DatasetConfigCase getDatasetConfigCase() {
      return DatasetConfigCase.forNumber(datasetConfigCase_);
    }

    public Builder clearDatasetConfig() {
      datasetConfigCase_ = 0;
      datasetConfig_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset,
            com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset.Builder,
            com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDatasetOrBuilder>
        singleTargetDatasetBuilder_;
    /**
     *
     *
     * <pre>
     * Single destination dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset single_target_dataset = 201;
     * </code>
     *
     * @return Whether the singleTargetDataset field is set.
     */
    @java.lang.Override
    public boolean hasSingleTargetDataset() {
      return datasetConfigCase_ == 201;
    }
    /**
     *
     *
     * <pre>
     * Single destination dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset single_target_dataset = 201;
     * </code>
     *
     * @return The singleTargetDataset.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
        getSingleTargetDataset() {
      if (singleTargetDatasetBuilder_ == null) {
        if (datasetConfigCase_ == 201) {
          return (com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset)
              datasetConfig_;
        }
        return com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
            .getDefaultInstance();
      } else {
        if (datasetConfigCase_ == 201) {
          return singleTargetDatasetBuilder_.getMessage();
        }
        return com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Single destination dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset single_target_dataset = 201;
     * </code>
     */
    public Builder setSingleTargetDataset(
        com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset value) {
      if (singleTargetDatasetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        datasetConfig_ = value;
        onChanged();
      } else {
        singleTargetDatasetBuilder_.setMessage(value);
      }
      datasetConfigCase_ = 201;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Single destination dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset single_target_dataset = 201;
     * </code>
     */
    public Builder setSingleTargetDataset(
        com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset.Builder
            builderForValue) {
      if (singleTargetDatasetBuilder_ == null) {
        datasetConfig_ = builderForValue.build();
        onChanged();
      } else {
        singleTargetDatasetBuilder_.setMessage(builderForValue.build());
      }
      datasetConfigCase_ = 201;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Single destination dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset single_target_dataset = 201;
     * </code>
     */
    public Builder mergeSingleTargetDataset(
        com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset value) {
      if (singleTargetDatasetBuilder_ == null) {
        if (datasetConfigCase_ == 201
            && datasetConfig_
                != com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
                    .getDefaultInstance()) {
          datasetConfig_ =
              com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
                  .newBuilder(
                      (com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset)
                          datasetConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          datasetConfig_ = value;
        }
        onChanged();
      } else {
        if (datasetConfigCase_ == 201) {
          singleTargetDatasetBuilder_.mergeFrom(value);
        } else {
          singleTargetDatasetBuilder_.setMessage(value);
        }
      }
      datasetConfigCase_ = 201;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Single destination dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset single_target_dataset = 201;
     * </code>
     */
    public Builder clearSingleTargetDataset() {
      if (singleTargetDatasetBuilder_ == null) {
        if (datasetConfigCase_ == 201) {
          datasetConfigCase_ = 0;
          datasetConfig_ = null;
          onChanged();
        }
      } else {
        if (datasetConfigCase_ == 201) {
          datasetConfigCase_ = 0;
          datasetConfig_ = null;
        }
        singleTargetDatasetBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Single destination dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset single_target_dataset = 201;
     * </code>
     */
    public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset.Builder
        getSingleTargetDatasetBuilder() {
      return getSingleTargetDatasetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Single destination dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset single_target_dataset = 201;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDatasetOrBuilder
        getSingleTargetDatasetOrBuilder() {
      if ((datasetConfigCase_ == 201) && (singleTargetDatasetBuilder_ != null)) {
        return singleTargetDatasetBuilder_.getMessageOrBuilder();
      } else {
        if (datasetConfigCase_ == 201) {
          return (com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset)
              datasetConfig_;
        }
        return com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Single destination dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset single_target_dataset = 201;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset,
            com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset.Builder,
            com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDatasetOrBuilder>
        getSingleTargetDatasetFieldBuilder() {
      if (singleTargetDatasetBuilder_ == null) {
        if (!(datasetConfigCase_ == 201)) {
          datasetConfig_ =
              com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
                  .getDefaultInstance();
        }
        singleTargetDatasetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset,
                com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
                    .Builder,
                com.google.cloud.datastream.v1.BigQueryDestinationConfig
                    .SingleTargetDatasetOrBuilder>(
                (com.google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset)
                    datasetConfig_,
                getParentForChildren(),
                isClean());
        datasetConfig_ = null;
      }
      datasetConfigCase_ = 201;
      onChanged();
      ;
      return singleTargetDatasetBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets,
            com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                .Builder,
            com.google.cloud.datastream.v1.BigQueryDestinationConfig
                .SourceHierarchyDatasetsOrBuilder>
        sourceHierarchyDatasetsBuilder_;
    /**
     *
     *
     * <pre>
     * Source hierarchy datasets.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets source_hierarchy_datasets = 202;
     * </code>
     *
     * @return Whether the sourceHierarchyDatasets field is set.
     */
    @java.lang.Override
    public boolean hasSourceHierarchyDatasets() {
      return datasetConfigCase_ == 202;
    }
    /**
     *
     *
     * <pre>
     * Source hierarchy datasets.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets source_hierarchy_datasets = 202;
     * </code>
     *
     * @return The sourceHierarchyDatasets.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
        getSourceHierarchyDatasets() {
      if (sourceHierarchyDatasetsBuilder_ == null) {
        if (datasetConfigCase_ == 202) {
          return (com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets)
              datasetConfig_;
        }
        return com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
            .getDefaultInstance();
      } else {
        if (datasetConfigCase_ == 202) {
          return sourceHierarchyDatasetsBuilder_.getMessage();
        }
        return com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Source hierarchy datasets.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets source_hierarchy_datasets = 202;
     * </code>
     */
    public Builder setSourceHierarchyDatasets(
        com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets value) {
      if (sourceHierarchyDatasetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        datasetConfig_ = value;
        onChanged();
      } else {
        sourceHierarchyDatasetsBuilder_.setMessage(value);
      }
      datasetConfigCase_ = 202;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source hierarchy datasets.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets source_hierarchy_datasets = 202;
     * </code>
     */
    public Builder setSourceHierarchyDatasets(
        com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.Builder
            builderForValue) {
      if (sourceHierarchyDatasetsBuilder_ == null) {
        datasetConfig_ = builderForValue.build();
        onChanged();
      } else {
        sourceHierarchyDatasetsBuilder_.setMessage(builderForValue.build());
      }
      datasetConfigCase_ = 202;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source hierarchy datasets.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets source_hierarchy_datasets = 202;
     * </code>
     */
    public Builder mergeSourceHierarchyDatasets(
        com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets value) {
      if (sourceHierarchyDatasetsBuilder_ == null) {
        if (datasetConfigCase_ == 202
            && datasetConfig_
                != com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                    .getDefaultInstance()) {
          datasetConfig_ =
              com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                  .newBuilder(
                      (com.google.cloud.datastream.v1.BigQueryDestinationConfig
                              .SourceHierarchyDatasets)
                          datasetConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          datasetConfig_ = value;
        }
        onChanged();
      } else {
        if (datasetConfigCase_ == 202) {
          sourceHierarchyDatasetsBuilder_.mergeFrom(value);
        } else {
          sourceHierarchyDatasetsBuilder_.setMessage(value);
        }
      }
      datasetConfigCase_ = 202;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source hierarchy datasets.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets source_hierarchy_datasets = 202;
     * </code>
     */
    public Builder clearSourceHierarchyDatasets() {
      if (sourceHierarchyDatasetsBuilder_ == null) {
        if (datasetConfigCase_ == 202) {
          datasetConfigCase_ = 0;
          datasetConfig_ = null;
          onChanged();
        }
      } else {
        if (datasetConfigCase_ == 202) {
          datasetConfigCase_ = 0;
          datasetConfig_ = null;
        }
        sourceHierarchyDatasetsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source hierarchy datasets.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets source_hierarchy_datasets = 202;
     * </code>
     */
    public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.Builder
        getSourceHierarchyDatasetsBuilder() {
      return getSourceHierarchyDatasetsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Source hierarchy datasets.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets source_hierarchy_datasets = 202;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasetsOrBuilder
        getSourceHierarchyDatasetsOrBuilder() {
      if ((datasetConfigCase_ == 202) && (sourceHierarchyDatasetsBuilder_ != null)) {
        return sourceHierarchyDatasetsBuilder_.getMessageOrBuilder();
      } else {
        if (datasetConfigCase_ == 202) {
          return (com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets)
              datasetConfig_;
        }
        return com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Source hierarchy datasets.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets source_hierarchy_datasets = 202;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets,
            com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                .Builder,
            com.google.cloud.datastream.v1.BigQueryDestinationConfig
                .SourceHierarchyDatasetsOrBuilder>
        getSourceHierarchyDatasetsFieldBuilder() {
      if (sourceHierarchyDatasetsBuilder_ == null) {
        if (!(datasetConfigCase_ == 202)) {
          datasetConfig_ =
              com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                  .getDefaultInstance();
        }
        sourceHierarchyDatasetsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets,
                com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
                    .Builder,
                com.google.cloud.datastream.v1.BigQueryDestinationConfig
                    .SourceHierarchyDatasetsOrBuilder>(
                (com.google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets)
                    datasetConfig_,
                getParentForChildren(),
                isClean());
        datasetConfig_ = null;
      }
      datasetConfigCase_ = 202;
      onChanged();
      ;
      return sourceHierarchyDatasetsBuilder_;
    }

    private com.google.protobuf.Duration dataFreshness_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        dataFreshnessBuilder_;
    /**
     *
     *
     * <pre>
     * The guaranteed data freshness (in seconds) when querying tables created by
     * the stream. Editing this field will only affect new tables created in the
     * future, but existing tables will not be impacted. Lower values mean that
     * queries will return fresher data, but may result in higher cost.
     * </pre>
     *
     * <code>.google.protobuf.Duration data_freshness = 300;</code>
     *
     * @return Whether the dataFreshness field is set.
     */
    public boolean hasDataFreshness() {
      return dataFreshnessBuilder_ != null || dataFreshness_ != null;
    }
    /**
     *
     *
     * <pre>
     * The guaranteed data freshness (in seconds) when querying tables created by
     * the stream. Editing this field will only affect new tables created in the
     * future, but existing tables will not be impacted. Lower values mean that
     * queries will return fresher data, but may result in higher cost.
     * </pre>
     *
     * <code>.google.protobuf.Duration data_freshness = 300;</code>
     *
     * @return The dataFreshness.
     */
    public com.google.protobuf.Duration getDataFreshness() {
      if (dataFreshnessBuilder_ == null) {
        return dataFreshness_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : dataFreshness_;
      } else {
        return dataFreshnessBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The guaranteed data freshness (in seconds) when querying tables created by
     * the stream. Editing this field will only affect new tables created in the
     * future, but existing tables will not be impacted. Lower values mean that
     * queries will return fresher data, but may result in higher cost.
     * </pre>
     *
     * <code>.google.protobuf.Duration data_freshness = 300;</code>
     */
    public Builder setDataFreshness(com.google.protobuf.Duration value) {
      if (dataFreshnessBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataFreshness_ = value;
        onChanged();
      } else {
        dataFreshnessBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The guaranteed data freshness (in seconds) when querying tables created by
     * the stream. Editing this field will only affect new tables created in the
     * future, but existing tables will not be impacted. Lower values mean that
     * queries will return fresher data, but may result in higher cost.
     * </pre>
     *
     * <code>.google.protobuf.Duration data_freshness = 300;</code>
     */
    public Builder setDataFreshness(com.google.protobuf.Duration.Builder builderForValue) {
      if (dataFreshnessBuilder_ == null) {
        dataFreshness_ = builderForValue.build();
        onChanged();
      } else {
        dataFreshnessBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The guaranteed data freshness (in seconds) when querying tables created by
     * the stream. Editing this field will only affect new tables created in the
     * future, but existing tables will not be impacted. Lower values mean that
     * queries will return fresher data, but may result in higher cost.
     * </pre>
     *
     * <code>.google.protobuf.Duration data_freshness = 300;</code>
     */
    public Builder mergeDataFreshness(com.google.protobuf.Duration value) {
      if (dataFreshnessBuilder_ == null) {
        if (dataFreshness_ != null) {
          dataFreshness_ =
              com.google.protobuf.Duration.newBuilder(dataFreshness_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dataFreshness_ = value;
        }
        onChanged();
      } else {
        dataFreshnessBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The guaranteed data freshness (in seconds) when querying tables created by
     * the stream. Editing this field will only affect new tables created in the
     * future, but existing tables will not be impacted. Lower values mean that
     * queries will return fresher data, but may result in higher cost.
     * </pre>
     *
     * <code>.google.protobuf.Duration data_freshness = 300;</code>
     */
    public Builder clearDataFreshness() {
      if (dataFreshnessBuilder_ == null) {
        dataFreshness_ = null;
        onChanged();
      } else {
        dataFreshness_ = null;
        dataFreshnessBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The guaranteed data freshness (in seconds) when querying tables created by
     * the stream. Editing this field will only affect new tables created in the
     * future, but existing tables will not be impacted. Lower values mean that
     * queries will return fresher data, but may result in higher cost.
     * </pre>
     *
     * <code>.google.protobuf.Duration data_freshness = 300;</code>
     */
    public com.google.protobuf.Duration.Builder getDataFreshnessBuilder() {

      onChanged();
      return getDataFreshnessFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The guaranteed data freshness (in seconds) when querying tables created by
     * the stream. Editing this field will only affect new tables created in the
     * future, but existing tables will not be impacted. Lower values mean that
     * queries will return fresher data, but may result in higher cost.
     * </pre>
     *
     * <code>.google.protobuf.Duration data_freshness = 300;</code>
     */
    public com.google.protobuf.DurationOrBuilder getDataFreshnessOrBuilder() {
      if (dataFreshnessBuilder_ != null) {
        return dataFreshnessBuilder_.getMessageOrBuilder();
      } else {
        return dataFreshness_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : dataFreshness_;
      }
    }
    /**
     *
     *
     * <pre>
     * The guaranteed data freshness (in seconds) when querying tables created by
     * the stream. Editing this field will only affect new tables created in the
     * future, but existing tables will not be impacted. Lower values mean that
     * queries will return fresher data, but may result in higher cost.
     * </pre>
     *
     * <code>.google.protobuf.Duration data_freshness = 300;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getDataFreshnessFieldBuilder() {
      if (dataFreshnessBuilder_ == null) {
        dataFreshnessBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getDataFreshness(), getParentForChildren(), isClean());
        dataFreshness_ = null;
      }
      return dataFreshnessBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datastream.v1.BigQueryDestinationConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datastream.v1.BigQueryDestinationConfig)
  private static final com.google.cloud.datastream.v1.BigQueryDestinationConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datastream.v1.BigQueryDestinationConfig();
  }

  public static com.google.cloud.datastream.v1.BigQueryDestinationConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BigQueryDestinationConfig> PARSER =
      new com.google.protobuf.AbstractParser<BigQueryDestinationConfig>() {
        @java.lang.Override
        public BigQueryDestinationConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BigQueryDestinationConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BigQueryDestinationConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datastream.v1.BigQueryDestinationConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
