/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/metastore/v1beta/metastore.proto

package com.google.cloud.metastore.v1beta;

/**
 *
 *
 * <pre>
 * A managed metastore service that serves metadata queries.
 * </pre>
 *
 * Protobuf type {@code google.cloud.metastore.v1beta.Service}
 */
public final class Service extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.metastore.v1beta.Service)
    ServiceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Service.newBuilder() to construct.
  private Service(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Service() {
    name_ = "";
    network_ = "";
    endpointUri_ = "";
    state_ = 0;
    stateMessage_ = "";
    artifactGcsUri_ = "";
    tier_ = 0;
    uid_ = "";
    releaseChannel_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Service();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.metastore.v1beta.MetastoreProto
        .internal_static_google_cloud_metastore_v1beta_Service_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.metastore.v1beta.MetastoreProto
        .internal_static_google_cloud_metastore_v1beta_Service_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.metastore.v1beta.Service.class,
            com.google.cloud.metastore.v1beta.Service.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The current state of the metastore service.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.metastore.v1beta.Service.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The state of the metastore service is unknown.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The metastore service is in the process of being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * The metastore service is running and ready to serve queries.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    ACTIVE(2),
    /**
     *
     *
     * <pre>
     * The metastore service is entering suspension. Its query-serving
     * availability may cease unexpectedly.
     * </pre>
     *
     * <code>SUSPENDING = 3;</code>
     */
    SUSPENDING(3),
    /**
     *
     *
     * <pre>
     * The metastore service is suspended and unable to serve queries.
     * </pre>
     *
     * <code>SUSPENDED = 4;</code>
     */
    SUSPENDED(4),
    /**
     *
     *
     * <pre>
     * The metastore service is being updated. It remains usable but cannot
     * accept additional update requests or be deleted at this time.
     * </pre>
     *
     * <code>UPDATING = 5;</code>
     */
    UPDATING(5),
    /**
     *
     *
     * <pre>
     * The metastore service is undergoing deletion. It cannot be used.
     * </pre>
     *
     * <code>DELETING = 6;</code>
     */
    DELETING(6),
    /**
     *
     *
     * <pre>
     * The metastore service has encountered an error and cannot be used. The
     * metastore service should be deleted.
     * </pre>
     *
     * <code>ERROR = 7;</code>
     */
    ERROR(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The state of the metastore service is unknown.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The metastore service is in the process of being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The metastore service is running and ready to serve queries.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    public static final int ACTIVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The metastore service is entering suspension. Its query-serving
     * availability may cease unexpectedly.
     * </pre>
     *
     * <code>SUSPENDING = 3;</code>
     */
    public static final int SUSPENDING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The metastore service is suspended and unable to serve queries.
     * </pre>
     *
     * <code>SUSPENDED = 4;</code>
     */
    public static final int SUSPENDED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The metastore service is being updated. It remains usable but cannot
     * accept additional update requests or be deleted at this time.
     * </pre>
     *
     * <code>UPDATING = 5;</code>
     */
    public static final int UPDATING_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The metastore service is undergoing deletion. It cannot be used.
     * </pre>
     *
     * <code>DELETING = 6;</code>
     */
    public static final int DELETING_VALUE = 6;
    /**
     *
     *
     * <pre>
     * The metastore service has encountered an error and cannot be used. The
     * metastore service should be deleted.
     * </pre>
     *
     * <code>ERROR = 7;</code>
     */
    public static final int ERROR_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return ACTIVE;
        case 3:
          return SUSPENDING;
        case 4:
          return SUSPENDED;
        case 5:
          return UPDATING;
        case 6:
          return DELETING;
        case 7:
          return ERROR;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.metastore.v1beta.Service.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.metastore.v1beta.Service.State)
  }

  /**
   *
   *
   * <pre>
   * Available service tiers.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.metastore.v1beta.Service.Tier}
   */
  public enum Tier implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The tier is not set.
     * </pre>
     *
     * <code>TIER_UNSPECIFIED = 0;</code>
     */
    TIER_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The developer tier provides limited scalability and no fault tolerance.
     * Good for low-cost proof-of-concept.
     * </pre>
     *
     * <code>DEVELOPER = 1;</code>
     */
    DEVELOPER(1),
    /**
     *
     *
     * <pre>
     * The enterprise tier provides multi-zone high availability, and sufficient
     * scalability for enterprise-level Dataproc Metastore workloads.
     * </pre>
     *
     * <code>ENTERPRISE = 3;</code>
     */
    ENTERPRISE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The tier is not set.
     * </pre>
     *
     * <code>TIER_UNSPECIFIED = 0;</code>
     */
    public static final int TIER_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The developer tier provides limited scalability and no fault tolerance.
     * Good for low-cost proof-of-concept.
     * </pre>
     *
     * <code>DEVELOPER = 1;</code>
     */
    public static final int DEVELOPER_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The enterprise tier provides multi-zone high availability, and sufficient
     * scalability for enterprise-level Dataproc Metastore workloads.
     * </pre>
     *
     * <code>ENTERPRISE = 3;</code>
     */
    public static final int ENTERPRISE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Tier valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Tier forNumber(int value) {
      switch (value) {
        case 0:
          return TIER_UNSPECIFIED;
        case 1:
          return DEVELOPER;
        case 3:
          return ENTERPRISE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Tier> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Tier> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Tier>() {
          public Tier findValueByNumber(int number) {
            return Tier.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.metastore.v1beta.Service.getDescriptor().getEnumTypes().get(1);
    }

    private static final Tier[] VALUES = values();

    public static Tier valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Tier(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.metastore.v1beta.Service.Tier)
  }

  /**
   *
   *
   * <pre>
   * Release channels bundle features of varying levels of stability. Newer
   * features may be introduced initially into less stable release channels and
   * can be automatically promoted into more stable release channels.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.metastore.v1beta.Service.ReleaseChannel}
   */
  public enum ReleaseChannel implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Release channel is not specified.
     * </pre>
     *
     * <code>RELEASE_CHANNEL_UNSPECIFIED = 0;</code>
     */
    RELEASE_CHANNEL_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The `CANARY` release channel contains the newest features, which may be
     * unstable and subject to unresolved issues with no known workarounds.
     * Services using the `CANARY` release channel are not subject to any SLAs.
     * </pre>
     *
     * <code>CANARY = 1;</code>
     */
    CANARY(1),
    /**
     *
     *
     * <pre>
     * The `STABLE` release channel contains features that are considered stable
     * and have been validated for production use.
     * </pre>
     *
     * <code>STABLE = 2;</code>
     */
    STABLE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Release channel is not specified.
     * </pre>
     *
     * <code>RELEASE_CHANNEL_UNSPECIFIED = 0;</code>
     */
    public static final int RELEASE_CHANNEL_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The `CANARY` release channel contains the newest features, which may be
     * unstable and subject to unresolved issues with no known workarounds.
     * Services using the `CANARY` release channel are not subject to any SLAs.
     * </pre>
     *
     * <code>CANARY = 1;</code>
     */
    public static final int CANARY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The `STABLE` release channel contains features that are considered stable
     * and have been validated for production use.
     * </pre>
     *
     * <code>STABLE = 2;</code>
     */
    public static final int STABLE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ReleaseChannel valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ReleaseChannel forNumber(int value) {
      switch (value) {
        case 0:
          return RELEASE_CHANNEL_UNSPECIFIED;
        case 1:
          return CANARY;
        case 2:
          return STABLE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ReleaseChannel> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ReleaseChannel> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ReleaseChannel>() {
          public ReleaseChannel findValueByNumber(int number) {
            return ReleaseChannel.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.metastore.v1beta.Service.getDescriptor().getEnumTypes().get(2);
    }

    private static final ReleaseChannel[] VALUES = values();

    public static ReleaseChannel valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ReleaseChannel(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.metastore.v1beta.Service.ReleaseChannel)
  }

  private int metastoreConfigCase_ = 0;
  private java.lang.Object metastoreConfig_;

  public enum MetastoreConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    HIVE_METASTORE_CONFIG(5),
    METASTORECONFIG_NOT_SET(0);
    private final int value;

    private MetastoreConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MetastoreConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static MetastoreConfigCase forNumber(int value) {
      switch (value) {
        case 5:
          return HIVE_METASTORE_CONFIG;
        case 0:
          return METASTORECONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public MetastoreConfigCase getMetastoreConfigCase() {
    return MetastoreConfigCase.forNumber(metastoreConfigCase_);
  }

  public static final int HIVE_METASTORE_CONFIG_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Configuration information specific to running Hive metastore
   * software as the metastore service.
   * </pre>
   *
   * <code>.google.cloud.metastore.v1beta.HiveMetastoreConfig hive_metastore_config = 5;</code>
   *
   * @return Whether the hiveMetastoreConfig field is set.
   */
  @java.lang.Override
  public boolean hasHiveMetastoreConfig() {
    return metastoreConfigCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Configuration information specific to running Hive metastore
   * software as the metastore service.
   * </pre>
   *
   * <code>.google.cloud.metastore.v1beta.HiveMetastoreConfig hive_metastore_config = 5;</code>
   *
   * @return The hiveMetastoreConfig.
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.HiveMetastoreConfig getHiveMetastoreConfig() {
    if (metastoreConfigCase_ == 5) {
      return (com.google.cloud.metastore.v1beta.HiveMetastoreConfig) metastoreConfig_;
    }
    return com.google.cloud.metastore.v1beta.HiveMetastoreConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration information specific to running Hive metastore
   * software as the metastore service.
   * </pre>
   *
   * <code>.google.cloud.metastore.v1beta.HiveMetastoreConfig hive_metastore_config = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.HiveMetastoreConfigOrBuilder
      getHiveMetastoreConfigOrBuilder() {
    if (metastoreConfigCase_ == 5) {
      return (com.google.cloud.metastore.v1beta.HiveMetastoreConfig) metastoreConfig_;
    }
    return com.google.cloud.metastore.v1beta.HiveMetastoreConfig.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Immutable. The relative resource name of the metastore service, of the
   * form:
   * `projects/{project_number}/locations/{location_id}/services/{service_id}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The relative resource name of the metastore service, of the
   * form:
   * `projects/{project_number}/locations/{location_id}/services/{service_id}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the metastore service was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the metastore service was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the metastore service was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the metastore service was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the metastore service was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the metastore service was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.metastore.v1beta.MetastoreProto
                .internal_static_google_cloud_metastore_v1beta_Service_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * User-defined labels for the metastore service.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * User-defined labels for the metastore service.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * User-defined labels for the metastore service.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * User-defined labels for the metastore service.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int NETWORK_FIELD_NUMBER = 7;
  private volatile java.lang.Object network_;
  /**
   *
   *
   * <pre>
   * Immutable. The relative resource name of the VPC network on which the
   * instance can be accessed. It is specified in the following form:
   * `projects/{project_number}/global/networks/{network_id}`.
   * </pre>
   *
   * <code>
   * string network = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The relative resource name of the VPC network on which the
   * instance can be accessed. It is specified in the following form:
   * `projects/{project_number}/global/networks/{network_id}`.
   * </pre>
   *
   * <code>
   * string network = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENDPOINT_URI_FIELD_NUMBER = 8;
  private volatile java.lang.Object endpointUri_;
  /**
   *
   *
   * <pre>
   * Output only. The URI of the endpoint used to access the metastore service.
   * </pre>
   *
   * <code>string endpoint_uri = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The endpointUri.
   */
  @java.lang.Override
  public java.lang.String getEndpointUri() {
    java.lang.Object ref = endpointUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      endpointUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The URI of the endpoint used to access the metastore service.
   * </pre>
   *
   * <code>string endpoint_uri = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for endpointUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEndpointUriBytes() {
    java.lang.Object ref = endpointUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      endpointUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PORT_FIELD_NUMBER = 9;
  private int port_;
  /**
   *
   *
   * <pre>
   * The TCP port at which the metastore service is reached. Default: 9083.
   * </pre>
   *
   * <code>int32 port = 9;</code>
   *
   * @return The port.
   */
  @java.lang.Override
  public int getPort() {
    return port_;
  }

  public static final int STATE_FIELD_NUMBER = 10;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. The current state of the metastore service.
   * </pre>
   *
   * <code>
   * .google.cloud.metastore.v1beta.Service.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of the metastore service.
   * </pre>
   *
   * <code>
   * .google.cloud.metastore.v1beta.Service.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.Service.State getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.metastore.v1beta.Service.State result =
        com.google.cloud.metastore.v1beta.Service.State.valueOf(state_);
    return result == null ? com.google.cloud.metastore.v1beta.Service.State.UNRECOGNIZED : result;
  }

  public static final int STATE_MESSAGE_FIELD_NUMBER = 11;
  private volatile java.lang.Object stateMessage_;
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the current state of the
   * metastore service, if available.
   * </pre>
   *
   * <code>string state_message = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The stateMessage.
   */
  @java.lang.Override
  public java.lang.String getStateMessage() {
    java.lang.Object ref = stateMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      stateMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the current state of the
   * metastore service, if available.
   * </pre>
   *
   * <code>string state_message = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for stateMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateMessageBytes() {
    java.lang.Object ref = stateMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      stateMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ARTIFACT_GCS_URI_FIELD_NUMBER = 12;
  private volatile java.lang.Object artifactGcsUri_;
  /**
   *
   *
   * <pre>
   * Output only. A Cloud Storage URI (starting with `gs://`) that specifies
   * where artifacts related to the metastore service are stored.
   * </pre>
   *
   * <code>string artifact_gcs_uri = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The artifactGcsUri.
   */
  @java.lang.Override
  public java.lang.String getArtifactGcsUri() {
    java.lang.Object ref = artifactGcsUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      artifactGcsUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. A Cloud Storage URI (starting with `gs://`) that specifies
   * where artifacts related to the metastore service are stored.
   * </pre>
   *
   * <code>string artifact_gcs_uri = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for artifactGcsUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getArtifactGcsUriBytes() {
    java.lang.Object ref = artifactGcsUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      artifactGcsUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TIER_FIELD_NUMBER = 13;
  private int tier_;
  /**
   *
   *
   * <pre>
   * The tier of the service.
   * </pre>
   *
   * <code>.google.cloud.metastore.v1beta.Service.Tier tier = 13;</code>
   *
   * @return The enum numeric value on the wire for tier.
   */
  @java.lang.Override
  public int getTierValue() {
    return tier_;
  }
  /**
   *
   *
   * <pre>
   * The tier of the service.
   * </pre>
   *
   * <code>.google.cloud.metastore.v1beta.Service.Tier tier = 13;</code>
   *
   * @return The tier.
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.Service.Tier getTier() {
    @SuppressWarnings("deprecation")
    com.google.cloud.metastore.v1beta.Service.Tier result =
        com.google.cloud.metastore.v1beta.Service.Tier.valueOf(tier_);
    return result == null ? com.google.cloud.metastore.v1beta.Service.Tier.UNRECOGNIZED : result;
  }

  public static final int METADATA_INTEGRATION_FIELD_NUMBER = 14;
  private com.google.cloud.metastore.v1beta.MetadataIntegration metadataIntegration_;
  /**
   *
   *
   * <pre>
   * The setting that defines how metastore metadata should be integrated with
   * external services and systems.
   * </pre>
   *
   * <code>.google.cloud.metastore.v1beta.MetadataIntegration metadata_integration = 14;</code>
   *
   * @return Whether the metadataIntegration field is set.
   */
  @java.lang.Override
  public boolean hasMetadataIntegration() {
    return metadataIntegration_ != null;
  }
  /**
   *
   *
   * <pre>
   * The setting that defines how metastore metadata should be integrated with
   * external services and systems.
   * </pre>
   *
   * <code>.google.cloud.metastore.v1beta.MetadataIntegration metadata_integration = 14;</code>
   *
   * @return The metadataIntegration.
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.MetadataIntegration getMetadataIntegration() {
    return metadataIntegration_ == null
        ? com.google.cloud.metastore.v1beta.MetadataIntegration.getDefaultInstance()
        : metadataIntegration_;
  }
  /**
   *
   *
   * <pre>
   * The setting that defines how metastore metadata should be integrated with
   * external services and systems.
   * </pre>
   *
   * <code>.google.cloud.metastore.v1beta.MetadataIntegration metadata_integration = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.MetadataIntegrationOrBuilder
      getMetadataIntegrationOrBuilder() {
    return getMetadataIntegration();
  }

  public static final int MAINTENANCE_WINDOW_FIELD_NUMBER = 15;
  private com.google.cloud.metastore.v1beta.MaintenanceWindow maintenanceWindow_;
  /**
   *
   *
   * <pre>
   * The one hour maintenance window of the metastore service. This specifies
   * when the service can be restarted for maintenance purposes in UTC time.
   * </pre>
   *
   * <code>.google.cloud.metastore.v1beta.MaintenanceWindow maintenance_window = 15;</code>
   *
   * @return Whether the maintenanceWindow field is set.
   */
  @java.lang.Override
  public boolean hasMaintenanceWindow() {
    return maintenanceWindow_ != null;
  }
  /**
   *
   *
   * <pre>
   * The one hour maintenance window of the metastore service. This specifies
   * when the service can be restarted for maintenance purposes in UTC time.
   * </pre>
   *
   * <code>.google.cloud.metastore.v1beta.MaintenanceWindow maintenance_window = 15;</code>
   *
   * @return The maintenanceWindow.
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.MaintenanceWindow getMaintenanceWindow() {
    return maintenanceWindow_ == null
        ? com.google.cloud.metastore.v1beta.MaintenanceWindow.getDefaultInstance()
        : maintenanceWindow_;
  }
  /**
   *
   *
   * <pre>
   * The one hour maintenance window of the metastore service. This specifies
   * when the service can be restarted for maintenance purposes in UTC time.
   * </pre>
   *
   * <code>.google.cloud.metastore.v1beta.MaintenanceWindow maintenance_window = 15;</code>
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.MaintenanceWindowOrBuilder
      getMaintenanceWindowOrBuilder() {
    return getMaintenanceWindow();
  }

  public static final int UID_FIELD_NUMBER = 16;
  private volatile java.lang.Object uid_;
  /**
   *
   *
   * <pre>
   * Output only. The globally unique resource identifier of the metastore
   * service.
   * </pre>
   *
   * <code>string uid = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The globally unique resource identifier of the metastore
   * service.
   * </pre>
   *
   * <code>string uid = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METADATA_MANAGEMENT_ACTIVITY_FIELD_NUMBER = 17;
  private com.google.cloud.metastore.v1beta.MetadataManagementActivity metadataManagementActivity_;
  /**
   *
   *
   * <pre>
   * Output only. The metadata management activities of the metastore service.
   * </pre>
   *
   * <code>
   * .google.cloud.metastore.v1beta.MetadataManagementActivity metadata_management_activity = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the metadataManagementActivity field is set.
   */
  @java.lang.Override
  public boolean hasMetadataManagementActivity() {
    return metadataManagementActivity_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The metadata management activities of the metastore service.
   * </pre>
   *
   * <code>
   * .google.cloud.metastore.v1beta.MetadataManagementActivity metadata_management_activity = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The metadataManagementActivity.
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.MetadataManagementActivity
      getMetadataManagementActivity() {
    return metadataManagementActivity_ == null
        ? com.google.cloud.metastore.v1beta.MetadataManagementActivity.getDefaultInstance()
        : metadataManagementActivity_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The metadata management activities of the metastore service.
   * </pre>
   *
   * <code>
   * .google.cloud.metastore.v1beta.MetadataManagementActivity metadata_management_activity = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.MetadataManagementActivityOrBuilder
      getMetadataManagementActivityOrBuilder() {
    return getMetadataManagementActivity();
  }

  public static final int RELEASE_CHANNEL_FIELD_NUMBER = 19;
  private int releaseChannel_;
  /**
   *
   *
   * <pre>
   * Immutable. The release channel of the service.
   * If unspecified, defaults to `STABLE`.
   * </pre>
   *
   * <code>
   * .google.cloud.metastore.v1beta.Service.ReleaseChannel release_channel = 19 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for releaseChannel.
   */
  @java.lang.Override
  public int getReleaseChannelValue() {
    return releaseChannel_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. The release channel of the service.
   * If unspecified, defaults to `STABLE`.
   * </pre>
   *
   * <code>
   * .google.cloud.metastore.v1beta.Service.ReleaseChannel release_channel = 19 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The releaseChannel.
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.Service.ReleaseChannel getReleaseChannel() {
    @SuppressWarnings("deprecation")
    com.google.cloud.metastore.v1beta.Service.ReleaseChannel result =
        com.google.cloud.metastore.v1beta.Service.ReleaseChannel.valueOf(releaseChannel_);
    return result == null
        ? com.google.cloud.metastore.v1beta.Service.ReleaseChannel.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(3, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    if (metastoreConfigCase_ == 5) {
      output.writeMessage(
          5, (com.google.cloud.metastore.v1beta.HiveMetastoreConfig) metastoreConfig_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpointUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, endpointUri_);
    }
    if (port_ != 0) {
      output.writeInt32(9, port_);
    }
    if (state_ != com.google.cloud.metastore.v1beta.Service.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(10, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, stateMessage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(artifactGcsUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, artifactGcsUri_);
    }
    if (tier_ != com.google.cloud.metastore.v1beta.Service.Tier.TIER_UNSPECIFIED.getNumber()) {
      output.writeEnum(13, tier_);
    }
    if (metadataIntegration_ != null) {
      output.writeMessage(14, getMetadataIntegration());
    }
    if (maintenanceWindow_ != null) {
      output.writeMessage(15, getMaintenanceWindow());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, uid_);
    }
    if (metadataManagementActivity_ != null) {
      output.writeMessage(17, getMetadataManagementActivity());
    }
    if (releaseChannel_
        != com.google.cloud.metastore.v1beta.Service.ReleaseChannel.RELEASE_CHANNEL_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(19, releaseChannel_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    if (metastoreConfigCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.metastore.v1beta.HiveMetastoreConfig) metastoreConfig_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpointUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, endpointUri_);
    }
    if (port_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(9, port_);
    }
    if (state_ != com.google.cloud.metastore.v1beta.Service.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, stateMessage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(artifactGcsUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, artifactGcsUri_);
    }
    if (tier_ != com.google.cloud.metastore.v1beta.Service.Tier.TIER_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(13, tier_);
    }
    if (metadataIntegration_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(14, getMetadataIntegration());
    }
    if (maintenanceWindow_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getMaintenanceWindow());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, uid_);
    }
    if (metadataManagementActivity_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17, getMetadataManagementActivity());
    }
    if (releaseChannel_
        != com.google.cloud.metastore.v1beta.Service.ReleaseChannel.RELEASE_CHANNEL_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(19, releaseChannel_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.metastore.v1beta.Service)) {
      return super.equals(obj);
    }
    com.google.cloud.metastore.v1beta.Service other =
        (com.google.cloud.metastore.v1beta.Service) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getNetwork().equals(other.getNetwork())) return false;
    if (!getEndpointUri().equals(other.getEndpointUri())) return false;
    if (getPort() != other.getPort()) return false;
    if (state_ != other.state_) return false;
    if (!getStateMessage().equals(other.getStateMessage())) return false;
    if (!getArtifactGcsUri().equals(other.getArtifactGcsUri())) return false;
    if (tier_ != other.tier_) return false;
    if (hasMetadataIntegration() != other.hasMetadataIntegration()) return false;
    if (hasMetadataIntegration()) {
      if (!getMetadataIntegration().equals(other.getMetadataIntegration())) return false;
    }
    if (hasMaintenanceWindow() != other.hasMaintenanceWindow()) return false;
    if (hasMaintenanceWindow()) {
      if (!getMaintenanceWindow().equals(other.getMaintenanceWindow())) return false;
    }
    if (!getUid().equals(other.getUid())) return false;
    if (hasMetadataManagementActivity() != other.hasMetadataManagementActivity()) return false;
    if (hasMetadataManagementActivity()) {
      if (!getMetadataManagementActivity().equals(other.getMetadataManagementActivity()))
        return false;
    }
    if (releaseChannel_ != other.releaseChannel_) return false;
    if (!getMetastoreConfigCase().equals(other.getMetastoreConfigCase())) return false;
    switch (metastoreConfigCase_) {
      case 5:
        if (!getHiveMetastoreConfig().equals(other.getHiveMetastoreConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getNetwork().hashCode();
    hash = (37 * hash) + ENDPOINT_URI_FIELD_NUMBER;
    hash = (53 * hash) + getEndpointUri().hashCode();
    hash = (37 * hash) + PORT_FIELD_NUMBER;
    hash = (53 * hash) + getPort();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + STATE_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getStateMessage().hashCode();
    hash = (37 * hash) + ARTIFACT_GCS_URI_FIELD_NUMBER;
    hash = (53 * hash) + getArtifactGcsUri().hashCode();
    hash = (37 * hash) + TIER_FIELD_NUMBER;
    hash = (53 * hash) + tier_;
    if (hasMetadataIntegration()) {
      hash = (37 * hash) + METADATA_INTEGRATION_FIELD_NUMBER;
      hash = (53 * hash) + getMetadataIntegration().hashCode();
    }
    if (hasMaintenanceWindow()) {
      hash = (37 * hash) + MAINTENANCE_WINDOW_FIELD_NUMBER;
      hash = (53 * hash) + getMaintenanceWindow().hashCode();
    }
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    if (hasMetadataManagementActivity()) {
      hash = (37 * hash) + METADATA_MANAGEMENT_ACTIVITY_FIELD_NUMBER;
      hash = (53 * hash) + getMetadataManagementActivity().hashCode();
    }
    hash = (37 * hash) + RELEASE_CHANNEL_FIELD_NUMBER;
    hash = (53 * hash) + releaseChannel_;
    switch (metastoreConfigCase_) {
      case 5:
        hash = (37 * hash) + HIVE_METASTORE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getHiveMetastoreConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.metastore.v1beta.Service parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.Service parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.Service parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.Service parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.Service parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.Service parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.Service parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.Service parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.Service parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.Service parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.Service parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.Service parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.metastore.v1beta.Service prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A managed metastore service that serves metadata queries.
   * </pre>
   *
   * Protobuf type {@code google.cloud.metastore.v1beta.Service}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.metastore.v1beta.Service)
      com.google.cloud.metastore.v1beta.ServiceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_Service_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_Service_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.metastore.v1beta.Service.class,
              com.google.cloud.metastore.v1beta.Service.Builder.class);
    }

    // Construct using com.google.cloud.metastore.v1beta.Service.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (hiveMetastoreConfigBuilder_ != null) {
        hiveMetastoreConfigBuilder_.clear();
      }
      name_ = "";

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      network_ = "";

      endpointUri_ = "";

      port_ = 0;

      state_ = 0;

      stateMessage_ = "";

      artifactGcsUri_ = "";

      tier_ = 0;

      if (metadataIntegrationBuilder_ == null) {
        metadataIntegration_ = null;
      } else {
        metadataIntegration_ = null;
        metadataIntegrationBuilder_ = null;
      }
      if (maintenanceWindowBuilder_ == null) {
        maintenanceWindow_ = null;
      } else {
        maintenanceWindow_ = null;
        maintenanceWindowBuilder_ = null;
      }
      uid_ = "";

      if (metadataManagementActivityBuilder_ == null) {
        metadataManagementActivity_ = null;
      } else {
        metadataManagementActivity_ = null;
        metadataManagementActivityBuilder_ = null;
      }
      releaseChannel_ = 0;

      metastoreConfigCase_ = 0;
      metastoreConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_Service_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.Service getDefaultInstanceForType() {
      return com.google.cloud.metastore.v1beta.Service.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.Service build() {
      com.google.cloud.metastore.v1beta.Service result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.Service buildPartial() {
      com.google.cloud.metastore.v1beta.Service result =
          new com.google.cloud.metastore.v1beta.Service(this);
      int from_bitField0_ = bitField0_;
      if (metastoreConfigCase_ == 5) {
        if (hiveMetastoreConfigBuilder_ == null) {
          result.metastoreConfig_ = metastoreConfig_;
        } else {
          result.metastoreConfig_ = hiveMetastoreConfigBuilder_.build();
        }
      }
      result.name_ = name_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      result.network_ = network_;
      result.endpointUri_ = endpointUri_;
      result.port_ = port_;
      result.state_ = state_;
      result.stateMessage_ = stateMessage_;
      result.artifactGcsUri_ = artifactGcsUri_;
      result.tier_ = tier_;
      if (metadataIntegrationBuilder_ == null) {
        result.metadataIntegration_ = metadataIntegration_;
      } else {
        result.metadataIntegration_ = metadataIntegrationBuilder_.build();
      }
      if (maintenanceWindowBuilder_ == null) {
        result.maintenanceWindow_ = maintenanceWindow_;
      } else {
        result.maintenanceWindow_ = maintenanceWindowBuilder_.build();
      }
      result.uid_ = uid_;
      if (metadataManagementActivityBuilder_ == null) {
        result.metadataManagementActivity_ = metadataManagementActivity_;
      } else {
        result.metadataManagementActivity_ = metadataManagementActivityBuilder_.build();
      }
      result.releaseChannel_ = releaseChannel_;
      result.metastoreConfigCase_ = metastoreConfigCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.metastore.v1beta.Service) {
        return mergeFrom((com.google.cloud.metastore.v1beta.Service) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.metastore.v1beta.Service other) {
      if (other == com.google.cloud.metastore.v1beta.Service.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (!other.getNetwork().isEmpty()) {
        network_ = other.network_;
        onChanged();
      }
      if (!other.getEndpointUri().isEmpty()) {
        endpointUri_ = other.endpointUri_;
        onChanged();
      }
      if (other.getPort() != 0) {
        setPort(other.getPort());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getStateMessage().isEmpty()) {
        stateMessage_ = other.stateMessage_;
        onChanged();
      }
      if (!other.getArtifactGcsUri().isEmpty()) {
        artifactGcsUri_ = other.artifactGcsUri_;
        onChanged();
      }
      if (other.tier_ != 0) {
        setTierValue(other.getTierValue());
      }
      if (other.hasMetadataIntegration()) {
        mergeMetadataIntegration(other.getMetadataIntegration());
      }
      if (other.hasMaintenanceWindow()) {
        mergeMaintenanceWindow(other.getMaintenanceWindow());
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        onChanged();
      }
      if (other.hasMetadataManagementActivity()) {
        mergeMetadataManagementActivity(other.getMetadataManagementActivity());
      }
      if (other.releaseChannel_ != 0) {
        setReleaseChannelValue(other.getReleaseChannelValue());
      }
      switch (other.getMetastoreConfigCase()) {
        case HIVE_METASTORE_CONFIG:
          {
            mergeHiveMetastoreConfig(other.getHiveMetastoreConfig());
            break;
          }
        case METASTORECONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getHiveMetastoreConfigFieldBuilder().getBuilder(), extensionRegistry);
                metastoreConfigCase_ = 5;
                break;
              } // case 42
            case 58:
              {
                network_ = input.readStringRequireUtf8();

                break;
              } // case 58
            case 66:
              {
                endpointUri_ = input.readStringRequireUtf8();

                break;
              } // case 66
            case 72:
              {
                port_ = input.readInt32();

                break;
              } // case 72
            case 80:
              {
                state_ = input.readEnum();

                break;
              } // case 80
            case 90:
              {
                stateMessage_ = input.readStringRequireUtf8();

                break;
              } // case 90
            case 98:
              {
                artifactGcsUri_ = input.readStringRequireUtf8();

                break;
              } // case 98
            case 104:
              {
                tier_ = input.readEnum();

                break;
              } // case 104
            case 114:
              {
                input.readMessage(
                    getMetadataIntegrationFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 114
            case 122:
              {
                input.readMessage(
                    getMaintenanceWindowFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 122
            case 130:
              {
                uid_ = input.readStringRequireUtf8();

                break;
              } // case 130
            case 138:
              {
                input.readMessage(
                    getMetadataManagementActivityFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 138
            case 152:
              {
                releaseChannel_ = input.readEnum();

                break;
              } // case 152
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int metastoreConfigCase_ = 0;
    private java.lang.Object metastoreConfig_;

    public MetastoreConfigCase getMetastoreConfigCase() {
      return MetastoreConfigCase.forNumber(metastoreConfigCase_);
    }

    public Builder clearMetastoreConfig() {
      metastoreConfigCase_ = 0;
      metastoreConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.metastore.v1beta.HiveMetastoreConfig,
            com.google.cloud.metastore.v1beta.HiveMetastoreConfig.Builder,
            com.google.cloud.metastore.v1beta.HiveMetastoreConfigOrBuilder>
        hiveMetastoreConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration information specific to running Hive metastore
     * software as the metastore service.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.HiveMetastoreConfig hive_metastore_config = 5;</code>
     *
     * @return Whether the hiveMetastoreConfig field is set.
     */
    @java.lang.Override
    public boolean hasHiveMetastoreConfig() {
      return metastoreConfigCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Configuration information specific to running Hive metastore
     * software as the metastore service.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.HiveMetastoreConfig hive_metastore_config = 5;</code>
     *
     * @return The hiveMetastoreConfig.
     */
    @java.lang.Override
    public com.google.cloud.metastore.v1beta.HiveMetastoreConfig getHiveMetastoreConfig() {
      if (hiveMetastoreConfigBuilder_ == null) {
        if (metastoreConfigCase_ == 5) {
          return (com.google.cloud.metastore.v1beta.HiveMetastoreConfig) metastoreConfig_;
        }
        return com.google.cloud.metastore.v1beta.HiveMetastoreConfig.getDefaultInstance();
      } else {
        if (metastoreConfigCase_ == 5) {
          return hiveMetastoreConfigBuilder_.getMessage();
        }
        return com.google.cloud.metastore.v1beta.HiveMetastoreConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration information specific to running Hive metastore
     * software as the metastore service.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.HiveMetastoreConfig hive_metastore_config = 5;</code>
     */
    public Builder setHiveMetastoreConfig(
        com.google.cloud.metastore.v1beta.HiveMetastoreConfig value) {
      if (hiveMetastoreConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metastoreConfig_ = value;
        onChanged();
      } else {
        hiveMetastoreConfigBuilder_.setMessage(value);
      }
      metastoreConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration information specific to running Hive metastore
     * software as the metastore service.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.HiveMetastoreConfig hive_metastore_config = 5;</code>
     */
    public Builder setHiveMetastoreConfig(
        com.google.cloud.metastore.v1beta.HiveMetastoreConfig.Builder builderForValue) {
      if (hiveMetastoreConfigBuilder_ == null) {
        metastoreConfig_ = builderForValue.build();
        onChanged();
      } else {
        hiveMetastoreConfigBuilder_.setMessage(builderForValue.build());
      }
      metastoreConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration information specific to running Hive metastore
     * software as the metastore service.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.HiveMetastoreConfig hive_metastore_config = 5;</code>
     */
    public Builder mergeHiveMetastoreConfig(
        com.google.cloud.metastore.v1beta.HiveMetastoreConfig value) {
      if (hiveMetastoreConfigBuilder_ == null) {
        if (metastoreConfigCase_ == 5
            && metastoreConfig_
                != com.google.cloud.metastore.v1beta.HiveMetastoreConfig.getDefaultInstance()) {
          metastoreConfig_ =
              com.google.cloud.metastore.v1beta.HiveMetastoreConfig.newBuilder(
                      (com.google.cloud.metastore.v1beta.HiveMetastoreConfig) metastoreConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metastoreConfig_ = value;
        }
        onChanged();
      } else {
        if (metastoreConfigCase_ == 5) {
          hiveMetastoreConfigBuilder_.mergeFrom(value);
        } else {
          hiveMetastoreConfigBuilder_.setMessage(value);
        }
      }
      metastoreConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration information specific to running Hive metastore
     * software as the metastore service.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.HiveMetastoreConfig hive_metastore_config = 5;</code>
     */
    public Builder clearHiveMetastoreConfig() {
      if (hiveMetastoreConfigBuilder_ == null) {
        if (metastoreConfigCase_ == 5) {
          metastoreConfigCase_ = 0;
          metastoreConfig_ = null;
          onChanged();
        }
      } else {
        if (metastoreConfigCase_ == 5) {
          metastoreConfigCase_ = 0;
          metastoreConfig_ = null;
        }
        hiveMetastoreConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration information specific to running Hive metastore
     * software as the metastore service.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.HiveMetastoreConfig hive_metastore_config = 5;</code>
     */
    public com.google.cloud.metastore.v1beta.HiveMetastoreConfig.Builder
        getHiveMetastoreConfigBuilder() {
      return getHiveMetastoreConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration information specific to running Hive metastore
     * software as the metastore service.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.HiveMetastoreConfig hive_metastore_config = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.metastore.v1beta.HiveMetastoreConfigOrBuilder
        getHiveMetastoreConfigOrBuilder() {
      if ((metastoreConfigCase_ == 5) && (hiveMetastoreConfigBuilder_ != null)) {
        return hiveMetastoreConfigBuilder_.getMessageOrBuilder();
      } else {
        if (metastoreConfigCase_ == 5) {
          return (com.google.cloud.metastore.v1beta.HiveMetastoreConfig) metastoreConfig_;
        }
        return com.google.cloud.metastore.v1beta.HiveMetastoreConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration information specific to running Hive metastore
     * software as the metastore service.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.HiveMetastoreConfig hive_metastore_config = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.metastore.v1beta.HiveMetastoreConfig,
            com.google.cloud.metastore.v1beta.HiveMetastoreConfig.Builder,
            com.google.cloud.metastore.v1beta.HiveMetastoreConfigOrBuilder>
        getHiveMetastoreConfigFieldBuilder() {
      if (hiveMetastoreConfigBuilder_ == null) {
        if (!(metastoreConfigCase_ == 5)) {
          metastoreConfig_ =
              com.google.cloud.metastore.v1beta.HiveMetastoreConfig.getDefaultInstance();
        }
        hiveMetastoreConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.metastore.v1beta.HiveMetastoreConfig,
                com.google.cloud.metastore.v1beta.HiveMetastoreConfig.Builder,
                com.google.cloud.metastore.v1beta.HiveMetastoreConfigOrBuilder>(
                (com.google.cloud.metastore.v1beta.HiveMetastoreConfig) metastoreConfig_,
                getParentForChildren(),
                isClean());
        metastoreConfig_ = null;
      }
      metastoreConfigCase_ = 5;
      onChanged();
      ;
      return hiveMetastoreConfigBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The relative resource name of the metastore service, of the
     * form:
     * `projects/{project_number}/locations/{location_id}/services/{service_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The relative resource name of the metastore service, of the
     * form:
     * `projects/{project_number}/locations/{location_id}/services/{service_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The relative resource name of the metastore service, of the
     * form:
     * `projects/{project_number}/locations/{location_id}/services/{service_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The relative resource name of the metastore service, of the
     * form:
     * `projects/{project_number}/locations/{location_id}/services/{service_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The relative resource name of the metastore service, of the
     * form:
     * `projects/{project_number}/locations/{location_id}/services/{service_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore service was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore service was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore service was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore service was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore service was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore service was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore service was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore service was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore service was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore service was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore service was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore service was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore service was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore service was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore service was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore service was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore service was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore service was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * User-defined labels for the metastore service.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * User-defined labels for the metastore service.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * User-defined labels for the metastore service.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * User-defined labels for the metastore service.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined labels for the metastore service.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * User-defined labels for the metastore service.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined labels for the metastore service.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private java.lang.Object network_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The relative resource name of the VPC network on which the
     * instance can be accessed. It is specified in the following form:
     * `projects/{project_number}/global/networks/{network_id}`.
     * </pre>
     *
     * <code>
     * string network = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The relative resource name of the VPC network on which the
     * instance can be accessed. It is specified in the following form:
     * `projects/{project_number}/global/networks/{network_id}`.
     * </pre>
     *
     * <code>
     * string network = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The relative resource name of the VPC network on which the
     * instance can be accessed. It is specified in the following form:
     * `projects/{project_number}/global/networks/{network_id}`.
     * </pre>
     *
     * <code>
     * string network = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      network_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The relative resource name of the VPC network on which the
     * instance can be accessed. It is specified in the following form:
     * `projects/{project_number}/global/networks/{network_id}`.
     * </pre>
     *
     * <code>
     * string network = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {

      network_ = getDefaultInstance().getNetwork();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The relative resource name of the VPC network on which the
     * instance can be accessed. It is specified in the following form:
     * `projects/{project_number}/global/networks/{network_id}`.
     * </pre>
     *
     * <code>
     * string network = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      network_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object endpointUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The URI of the endpoint used to access the metastore service.
     * </pre>
     *
     * <code>string endpoint_uri = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The endpointUri.
     */
    public java.lang.String getEndpointUri() {
      java.lang.Object ref = endpointUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endpointUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The URI of the endpoint used to access the metastore service.
     * </pre>
     *
     * <code>string endpoint_uri = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for endpointUri.
     */
    public com.google.protobuf.ByteString getEndpointUriBytes() {
      java.lang.Object ref = endpointUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endpointUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The URI of the endpoint used to access the metastore service.
     * </pre>
     *
     * <code>string endpoint_uri = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The endpointUri to set.
     * @return This builder for chaining.
     */
    public Builder setEndpointUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      endpointUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The URI of the endpoint used to access the metastore service.
     * </pre>
     *
     * <code>string endpoint_uri = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndpointUri() {

      endpointUri_ = getDefaultInstance().getEndpointUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The URI of the endpoint used to access the metastore service.
     * </pre>
     *
     * <code>string endpoint_uri = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for endpointUri to set.
     * @return This builder for chaining.
     */
    public Builder setEndpointUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      endpointUri_ = value;
      onChanged();
      return this;
    }

    private int port_;
    /**
     *
     *
     * <pre>
     * The TCP port at which the metastore service is reached. Default: 9083.
     * </pre>
     *
     * <code>int32 port = 9;</code>
     *
     * @return The port.
     */
    @java.lang.Override
    public int getPort() {
      return port_;
    }
    /**
     *
     *
     * <pre>
     * The TCP port at which the metastore service is reached. Default: 9083.
     * </pre>
     *
     * <code>int32 port = 9;</code>
     *
     * @param value The port to set.
     * @return This builder for chaining.
     */
    public Builder setPort(int value) {

      port_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The TCP port at which the metastore service is reached. Default: 9083.
     * </pre>
     *
     * <code>int32 port = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPort() {

      port_ = 0;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state of the metastore service.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.Service.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the metastore service.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.Service.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the metastore service.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.Service.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.metastore.v1beta.Service.State getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.metastore.v1beta.Service.State result =
          com.google.cloud.metastore.v1beta.Service.State.valueOf(state_);
      return result == null ? com.google.cloud.metastore.v1beta.Service.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the metastore service.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.Service.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.metastore.v1beta.Service.State value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the metastore service.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.Service.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object stateMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current state of the
     * metastore service, if available.
     * </pre>
     *
     * <code>string state_message = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The stateMessage.
     */
    public java.lang.String getStateMessage() {
      java.lang.Object ref = stateMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stateMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current state of the
     * metastore service, if available.
     * </pre>
     *
     * <code>string state_message = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for stateMessage.
     */
    public com.google.protobuf.ByteString getStateMessageBytes() {
      java.lang.Object ref = stateMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stateMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current state of the
     * metastore service, if available.
     * </pre>
     *
     * <code>string state_message = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The stateMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStateMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      stateMessage_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current state of the
     * metastore service, if available.
     * </pre>
     *
     * <code>string state_message = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStateMessage() {

      stateMessage_ = getDefaultInstance().getStateMessage();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current state of the
     * metastore service, if available.
     * </pre>
     *
     * <code>string state_message = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for stateMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStateMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      stateMessage_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object artifactGcsUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. A Cloud Storage URI (starting with `gs://`) that specifies
     * where artifacts related to the metastore service are stored.
     * </pre>
     *
     * <code>string artifact_gcs_uri = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The artifactGcsUri.
     */
    public java.lang.String getArtifactGcsUri() {
      java.lang.Object ref = artifactGcsUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        artifactGcsUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A Cloud Storage URI (starting with `gs://`) that specifies
     * where artifacts related to the metastore service are stored.
     * </pre>
     *
     * <code>string artifact_gcs_uri = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for artifactGcsUri.
     */
    public com.google.protobuf.ByteString getArtifactGcsUriBytes() {
      java.lang.Object ref = artifactGcsUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        artifactGcsUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A Cloud Storage URI (starting with `gs://`) that specifies
     * where artifacts related to the metastore service are stored.
     * </pre>
     *
     * <code>string artifact_gcs_uri = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The artifactGcsUri to set.
     * @return This builder for chaining.
     */
    public Builder setArtifactGcsUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      artifactGcsUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A Cloud Storage URI (starting with `gs://`) that specifies
     * where artifacts related to the metastore service are stored.
     * </pre>
     *
     * <code>string artifact_gcs_uri = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArtifactGcsUri() {

      artifactGcsUri_ = getDefaultInstance().getArtifactGcsUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A Cloud Storage URI (starting with `gs://`) that specifies
     * where artifacts related to the metastore service are stored.
     * </pre>
     *
     * <code>string artifact_gcs_uri = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for artifactGcsUri to set.
     * @return This builder for chaining.
     */
    public Builder setArtifactGcsUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      artifactGcsUri_ = value;
      onChanged();
      return this;
    }

    private int tier_ = 0;
    /**
     *
     *
     * <pre>
     * The tier of the service.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.Service.Tier tier = 13;</code>
     *
     * @return The enum numeric value on the wire for tier.
     */
    @java.lang.Override
    public int getTierValue() {
      return tier_;
    }
    /**
     *
     *
     * <pre>
     * The tier of the service.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.Service.Tier tier = 13;</code>
     *
     * @param value The enum numeric value on the wire for tier to set.
     * @return This builder for chaining.
     */
    public Builder setTierValue(int value) {

      tier_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tier of the service.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.Service.Tier tier = 13;</code>
     *
     * @return The tier.
     */
    @java.lang.Override
    public com.google.cloud.metastore.v1beta.Service.Tier getTier() {
      @SuppressWarnings("deprecation")
      com.google.cloud.metastore.v1beta.Service.Tier result =
          com.google.cloud.metastore.v1beta.Service.Tier.valueOf(tier_);
      return result == null ? com.google.cloud.metastore.v1beta.Service.Tier.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The tier of the service.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.Service.Tier tier = 13;</code>
     *
     * @param value The tier to set.
     * @return This builder for chaining.
     */
    public Builder setTier(com.google.cloud.metastore.v1beta.Service.Tier value) {
      if (value == null) {
        throw new NullPointerException();
      }

      tier_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tier of the service.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.Service.Tier tier = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTier() {

      tier_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.metastore.v1beta.MetadataIntegration metadataIntegration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.metastore.v1beta.MetadataIntegration,
            com.google.cloud.metastore.v1beta.MetadataIntegration.Builder,
            com.google.cloud.metastore.v1beta.MetadataIntegrationOrBuilder>
        metadataIntegrationBuilder_;
    /**
     *
     *
     * <pre>
     * The setting that defines how metastore metadata should be integrated with
     * external services and systems.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.MetadataIntegration metadata_integration = 14;</code>
     *
     * @return Whether the metadataIntegration field is set.
     */
    public boolean hasMetadataIntegration() {
      return metadataIntegrationBuilder_ != null || metadataIntegration_ != null;
    }
    /**
     *
     *
     * <pre>
     * The setting that defines how metastore metadata should be integrated with
     * external services and systems.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.MetadataIntegration metadata_integration = 14;</code>
     *
     * @return The metadataIntegration.
     */
    public com.google.cloud.metastore.v1beta.MetadataIntegration getMetadataIntegration() {
      if (metadataIntegrationBuilder_ == null) {
        return metadataIntegration_ == null
            ? com.google.cloud.metastore.v1beta.MetadataIntegration.getDefaultInstance()
            : metadataIntegration_;
      } else {
        return metadataIntegrationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The setting that defines how metastore metadata should be integrated with
     * external services and systems.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.MetadataIntegration metadata_integration = 14;</code>
     */
    public Builder setMetadataIntegration(
        com.google.cloud.metastore.v1beta.MetadataIntegration value) {
      if (metadataIntegrationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadataIntegration_ = value;
        onChanged();
      } else {
        metadataIntegrationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The setting that defines how metastore metadata should be integrated with
     * external services and systems.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.MetadataIntegration metadata_integration = 14;</code>
     */
    public Builder setMetadataIntegration(
        com.google.cloud.metastore.v1beta.MetadataIntegration.Builder builderForValue) {
      if (metadataIntegrationBuilder_ == null) {
        metadataIntegration_ = builderForValue.build();
        onChanged();
      } else {
        metadataIntegrationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The setting that defines how metastore metadata should be integrated with
     * external services and systems.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.MetadataIntegration metadata_integration = 14;</code>
     */
    public Builder mergeMetadataIntegration(
        com.google.cloud.metastore.v1beta.MetadataIntegration value) {
      if (metadataIntegrationBuilder_ == null) {
        if (metadataIntegration_ != null) {
          metadataIntegration_ =
              com.google.cloud.metastore.v1beta.MetadataIntegration.newBuilder(metadataIntegration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metadataIntegration_ = value;
        }
        onChanged();
      } else {
        metadataIntegrationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The setting that defines how metastore metadata should be integrated with
     * external services and systems.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.MetadataIntegration metadata_integration = 14;</code>
     */
    public Builder clearMetadataIntegration() {
      if (metadataIntegrationBuilder_ == null) {
        metadataIntegration_ = null;
        onChanged();
      } else {
        metadataIntegration_ = null;
        metadataIntegrationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The setting that defines how metastore metadata should be integrated with
     * external services and systems.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.MetadataIntegration metadata_integration = 14;</code>
     */
    public com.google.cloud.metastore.v1beta.MetadataIntegration.Builder
        getMetadataIntegrationBuilder() {

      onChanged();
      return getMetadataIntegrationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The setting that defines how metastore metadata should be integrated with
     * external services and systems.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.MetadataIntegration metadata_integration = 14;</code>
     */
    public com.google.cloud.metastore.v1beta.MetadataIntegrationOrBuilder
        getMetadataIntegrationOrBuilder() {
      if (metadataIntegrationBuilder_ != null) {
        return metadataIntegrationBuilder_.getMessageOrBuilder();
      } else {
        return metadataIntegration_ == null
            ? com.google.cloud.metastore.v1beta.MetadataIntegration.getDefaultInstance()
            : metadataIntegration_;
      }
    }
    /**
     *
     *
     * <pre>
     * The setting that defines how metastore metadata should be integrated with
     * external services and systems.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.MetadataIntegration metadata_integration = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.metastore.v1beta.MetadataIntegration,
            com.google.cloud.metastore.v1beta.MetadataIntegration.Builder,
            com.google.cloud.metastore.v1beta.MetadataIntegrationOrBuilder>
        getMetadataIntegrationFieldBuilder() {
      if (metadataIntegrationBuilder_ == null) {
        metadataIntegrationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.metastore.v1beta.MetadataIntegration,
                com.google.cloud.metastore.v1beta.MetadataIntegration.Builder,
                com.google.cloud.metastore.v1beta.MetadataIntegrationOrBuilder>(
                getMetadataIntegration(), getParentForChildren(), isClean());
        metadataIntegration_ = null;
      }
      return metadataIntegrationBuilder_;
    }

    private com.google.cloud.metastore.v1beta.MaintenanceWindow maintenanceWindow_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.metastore.v1beta.MaintenanceWindow,
            com.google.cloud.metastore.v1beta.MaintenanceWindow.Builder,
            com.google.cloud.metastore.v1beta.MaintenanceWindowOrBuilder>
        maintenanceWindowBuilder_;
    /**
     *
     *
     * <pre>
     * The one hour maintenance window of the metastore service. This specifies
     * when the service can be restarted for maintenance purposes in UTC time.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.MaintenanceWindow maintenance_window = 15;</code>
     *
     * @return Whether the maintenanceWindow field is set.
     */
    public boolean hasMaintenanceWindow() {
      return maintenanceWindowBuilder_ != null || maintenanceWindow_ != null;
    }
    /**
     *
     *
     * <pre>
     * The one hour maintenance window of the metastore service. This specifies
     * when the service can be restarted for maintenance purposes in UTC time.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.MaintenanceWindow maintenance_window = 15;</code>
     *
     * @return The maintenanceWindow.
     */
    public com.google.cloud.metastore.v1beta.MaintenanceWindow getMaintenanceWindow() {
      if (maintenanceWindowBuilder_ == null) {
        return maintenanceWindow_ == null
            ? com.google.cloud.metastore.v1beta.MaintenanceWindow.getDefaultInstance()
            : maintenanceWindow_;
      } else {
        return maintenanceWindowBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The one hour maintenance window of the metastore service. This specifies
     * when the service can be restarted for maintenance purposes in UTC time.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.MaintenanceWindow maintenance_window = 15;</code>
     */
    public Builder setMaintenanceWindow(com.google.cloud.metastore.v1beta.MaintenanceWindow value) {
      if (maintenanceWindowBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maintenanceWindow_ = value;
        onChanged();
      } else {
        maintenanceWindowBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The one hour maintenance window of the metastore service. This specifies
     * when the service can be restarted for maintenance purposes in UTC time.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.MaintenanceWindow maintenance_window = 15;</code>
     */
    public Builder setMaintenanceWindow(
        com.google.cloud.metastore.v1beta.MaintenanceWindow.Builder builderForValue) {
      if (maintenanceWindowBuilder_ == null) {
        maintenanceWindow_ = builderForValue.build();
        onChanged();
      } else {
        maintenanceWindowBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The one hour maintenance window of the metastore service. This specifies
     * when the service can be restarted for maintenance purposes in UTC time.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.MaintenanceWindow maintenance_window = 15;</code>
     */
    public Builder mergeMaintenanceWindow(
        com.google.cloud.metastore.v1beta.MaintenanceWindow value) {
      if (maintenanceWindowBuilder_ == null) {
        if (maintenanceWindow_ != null) {
          maintenanceWindow_ =
              com.google.cloud.metastore.v1beta.MaintenanceWindow.newBuilder(maintenanceWindow_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          maintenanceWindow_ = value;
        }
        onChanged();
      } else {
        maintenanceWindowBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The one hour maintenance window of the metastore service. This specifies
     * when the service can be restarted for maintenance purposes in UTC time.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.MaintenanceWindow maintenance_window = 15;</code>
     */
    public Builder clearMaintenanceWindow() {
      if (maintenanceWindowBuilder_ == null) {
        maintenanceWindow_ = null;
        onChanged();
      } else {
        maintenanceWindow_ = null;
        maintenanceWindowBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The one hour maintenance window of the metastore service. This specifies
     * when the service can be restarted for maintenance purposes in UTC time.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.MaintenanceWindow maintenance_window = 15;</code>
     */
    public com.google.cloud.metastore.v1beta.MaintenanceWindow.Builder
        getMaintenanceWindowBuilder() {

      onChanged();
      return getMaintenanceWindowFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The one hour maintenance window of the metastore service. This specifies
     * when the service can be restarted for maintenance purposes in UTC time.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.MaintenanceWindow maintenance_window = 15;</code>
     */
    public com.google.cloud.metastore.v1beta.MaintenanceWindowOrBuilder
        getMaintenanceWindowOrBuilder() {
      if (maintenanceWindowBuilder_ != null) {
        return maintenanceWindowBuilder_.getMessageOrBuilder();
      } else {
        return maintenanceWindow_ == null
            ? com.google.cloud.metastore.v1beta.MaintenanceWindow.getDefaultInstance()
            : maintenanceWindow_;
      }
    }
    /**
     *
     *
     * <pre>
     * The one hour maintenance window of the metastore service. This specifies
     * when the service can be restarted for maintenance purposes in UTC time.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.MaintenanceWindow maintenance_window = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.metastore.v1beta.MaintenanceWindow,
            com.google.cloud.metastore.v1beta.MaintenanceWindow.Builder,
            com.google.cloud.metastore.v1beta.MaintenanceWindowOrBuilder>
        getMaintenanceWindowFieldBuilder() {
      if (maintenanceWindowBuilder_ == null) {
        maintenanceWindowBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.metastore.v1beta.MaintenanceWindow,
                com.google.cloud.metastore.v1beta.MaintenanceWindow.Builder,
                com.google.cloud.metastore.v1beta.MaintenanceWindowOrBuilder>(
                getMaintenanceWindow(), getParentForChildren(), isClean());
        maintenanceWindow_ = null;
      }
      return maintenanceWindowBuilder_;
    }

    private java.lang.Object uid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The globally unique resource identifier of the metastore
     * service.
     * </pre>
     *
     * <code>string uid = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The globally unique resource identifier of the metastore
     * service.
     * </pre>
     *
     * <code>string uid = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The globally unique resource identifier of the metastore
     * service.
     * </pre>
     *
     * <code>string uid = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      uid_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The globally unique resource identifier of the metastore
     * service.
     * </pre>
     *
     * <code>string uid = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {

      uid_ = getDefaultInstance().getUid();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The globally unique resource identifier of the metastore
     * service.
     * </pre>
     *
     * <code>string uid = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      uid_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.metastore.v1beta.MetadataManagementActivity
        metadataManagementActivity_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.metastore.v1beta.MetadataManagementActivity,
            com.google.cloud.metastore.v1beta.MetadataManagementActivity.Builder,
            com.google.cloud.metastore.v1beta.MetadataManagementActivityOrBuilder>
        metadataManagementActivityBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The metadata management activities of the metastore service.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataManagementActivity metadata_management_activity = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the metadataManagementActivity field is set.
     */
    public boolean hasMetadataManagementActivity() {
      return metadataManagementActivityBuilder_ != null || metadataManagementActivity_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metadata management activities of the metastore service.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataManagementActivity metadata_management_activity = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The metadataManagementActivity.
     */
    public com.google.cloud.metastore.v1beta.MetadataManagementActivity
        getMetadataManagementActivity() {
      if (metadataManagementActivityBuilder_ == null) {
        return metadataManagementActivity_ == null
            ? com.google.cloud.metastore.v1beta.MetadataManagementActivity.getDefaultInstance()
            : metadataManagementActivity_;
      } else {
        return metadataManagementActivityBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The metadata management activities of the metastore service.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataManagementActivity metadata_management_activity = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMetadataManagementActivity(
        com.google.cloud.metastore.v1beta.MetadataManagementActivity value) {
      if (metadataManagementActivityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadataManagementActivity_ = value;
        onChanged();
      } else {
        metadataManagementActivityBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metadata management activities of the metastore service.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataManagementActivity metadata_management_activity = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMetadataManagementActivity(
        com.google.cloud.metastore.v1beta.MetadataManagementActivity.Builder builderForValue) {
      if (metadataManagementActivityBuilder_ == null) {
        metadataManagementActivity_ = builderForValue.build();
        onChanged();
      } else {
        metadataManagementActivityBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metadata management activities of the metastore service.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataManagementActivity metadata_management_activity = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeMetadataManagementActivity(
        com.google.cloud.metastore.v1beta.MetadataManagementActivity value) {
      if (metadataManagementActivityBuilder_ == null) {
        if (metadataManagementActivity_ != null) {
          metadataManagementActivity_ =
              com.google.cloud.metastore.v1beta.MetadataManagementActivity.newBuilder(
                      metadataManagementActivity_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metadataManagementActivity_ = value;
        }
        onChanged();
      } else {
        metadataManagementActivityBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metadata management activities of the metastore service.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataManagementActivity metadata_management_activity = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMetadataManagementActivity() {
      if (metadataManagementActivityBuilder_ == null) {
        metadataManagementActivity_ = null;
        onChanged();
      } else {
        metadataManagementActivity_ = null;
        metadataManagementActivityBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metadata management activities of the metastore service.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataManagementActivity metadata_management_activity = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.metastore.v1beta.MetadataManagementActivity.Builder
        getMetadataManagementActivityBuilder() {

      onChanged();
      return getMetadataManagementActivityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The metadata management activities of the metastore service.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataManagementActivity metadata_management_activity = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.metastore.v1beta.MetadataManagementActivityOrBuilder
        getMetadataManagementActivityOrBuilder() {
      if (metadataManagementActivityBuilder_ != null) {
        return metadataManagementActivityBuilder_.getMessageOrBuilder();
      } else {
        return metadataManagementActivity_ == null
            ? com.google.cloud.metastore.v1beta.MetadataManagementActivity.getDefaultInstance()
            : metadataManagementActivity_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The metadata management activities of the metastore service.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataManagementActivity metadata_management_activity = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.metastore.v1beta.MetadataManagementActivity,
            com.google.cloud.metastore.v1beta.MetadataManagementActivity.Builder,
            com.google.cloud.metastore.v1beta.MetadataManagementActivityOrBuilder>
        getMetadataManagementActivityFieldBuilder() {
      if (metadataManagementActivityBuilder_ == null) {
        metadataManagementActivityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.metastore.v1beta.MetadataManagementActivity,
                com.google.cloud.metastore.v1beta.MetadataManagementActivity.Builder,
                com.google.cloud.metastore.v1beta.MetadataManagementActivityOrBuilder>(
                getMetadataManagementActivity(), getParentForChildren(), isClean());
        metadataManagementActivity_ = null;
      }
      return metadataManagementActivityBuilder_;
    }

    private int releaseChannel_ = 0;
    /**
     *
     *
     * <pre>
     * Immutable. The release channel of the service.
     * If unspecified, defaults to `STABLE`.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.Service.ReleaseChannel release_channel = 19 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for releaseChannel.
     */
    @java.lang.Override
    public int getReleaseChannelValue() {
      return releaseChannel_;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The release channel of the service.
     * If unspecified, defaults to `STABLE`.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.Service.ReleaseChannel release_channel = 19 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for releaseChannel to set.
     * @return This builder for chaining.
     */
    public Builder setReleaseChannelValue(int value) {

      releaseChannel_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The release channel of the service.
     * If unspecified, defaults to `STABLE`.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.Service.ReleaseChannel release_channel = 19 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The releaseChannel.
     */
    @java.lang.Override
    public com.google.cloud.metastore.v1beta.Service.ReleaseChannel getReleaseChannel() {
      @SuppressWarnings("deprecation")
      com.google.cloud.metastore.v1beta.Service.ReleaseChannel result =
          com.google.cloud.metastore.v1beta.Service.ReleaseChannel.valueOf(releaseChannel_);
      return result == null
          ? com.google.cloud.metastore.v1beta.Service.ReleaseChannel.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The release channel of the service.
     * If unspecified, defaults to `STABLE`.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.Service.ReleaseChannel release_channel = 19 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The releaseChannel to set.
     * @return This builder for chaining.
     */
    public Builder setReleaseChannel(
        com.google.cloud.metastore.v1beta.Service.ReleaseChannel value) {
      if (value == null) {
        throw new NullPointerException();
      }

      releaseChannel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The release channel of the service.
     * If unspecified, defaults to `STABLE`.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.Service.ReleaseChannel release_channel = 19 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReleaseChannel() {

      releaseChannel_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.metastore.v1beta.Service)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.metastore.v1beta.Service)
  private static final com.google.cloud.metastore.v1beta.Service DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.metastore.v1beta.Service();
  }

  public static com.google.cloud.metastore.v1beta.Service getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Service> PARSER =
      new com.google.protobuf.AbstractParser<Service>() {
        @java.lang.Override
        public Service parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Service> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Service> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.metastore.v1beta.Service getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
