/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/metastore/v1beta/metastore.proto

package com.google.cloud.metastore.v1beta;

/**
 *
 *
 * <pre>
 * A metastore resource that imports metadata.
 * </pre>
 *
 * Protobuf type {@code google.cloud.metastore.v1beta.MetadataImport}
 */
public final class MetadataImport extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.metastore.v1beta.MetadataImport)
    MetadataImportOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MetadataImport.newBuilder() to construct.
  private MetadataImport(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MetadataImport() {
    name_ = "";
    description_ = "";
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MetadataImport();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.metastore.v1beta.MetastoreProto
        .internal_static_google_cloud_metastore_v1beta_MetadataImport_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.metastore.v1beta.MetastoreProto
        .internal_static_google_cloud_metastore_v1beta_MetadataImport_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.metastore.v1beta.MetadataImport.class,
            com.google.cloud.metastore.v1beta.MetadataImport.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The current state of the metadata import.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.metastore.v1beta.MetadataImport.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The state of the metadata import is unknown.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The metadata import is running.
     * </pre>
     *
     * <code>RUNNING = 1;</code>
     */
    RUNNING(1),
    /**
     *
     *
     * <pre>
     * The metadata import completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 2;</code>
     */
    SUCCEEDED(2),
    /**
     *
     *
     * <pre>
     * The metadata import is being updated.
     * </pre>
     *
     * <code>UPDATING = 3;</code>
     */
    UPDATING(3),
    /**
     *
     *
     * <pre>
     * The metadata import failed, and attempted metadata changes were rolled
     * back.
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    FAILED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The state of the metadata import is unknown.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The metadata import is running.
     * </pre>
     *
     * <code>RUNNING = 1;</code>
     */
    public static final int RUNNING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The metadata import completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 2;</code>
     */
    public static final int SUCCEEDED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The metadata import is being updated.
     * </pre>
     *
     * <code>UPDATING = 3;</code>
     */
    public static final int UPDATING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The metadata import failed, and attempted metadata changes were rolled
     * back.
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    public static final int FAILED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return RUNNING;
        case 2:
          return SUCCEEDED;
        case 3:
          return UPDATING;
        case 4:
          return FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.metastore.v1beta.MetadataImport.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.metastore.v1beta.MetadataImport.State)
  }

  public interface DatabaseDumpOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.metastore.v1beta.MetadataImport.DatabaseDump)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The type of the database.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.DatabaseType database_type = 1 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.database_type is
     *     deprecated. See google/cloud/metastore/v1beta/metastore.proto;l=477
     * @return The enum numeric value on the wire for databaseType.
     */
    @java.lang.Deprecated
    int getDatabaseTypeValue();
    /**
     *
     *
     * <pre>
     * The type of the database.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.DatabaseType database_type = 1 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.database_type is
     *     deprecated. See google/cloud/metastore/v1beta/metastore.proto;l=477
     * @return The databaseType.
     */
    @java.lang.Deprecated
    com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.DatabaseType getDatabaseType();

    /**
     *
     *
     * <pre>
     * A Cloud Storage object or folder URI that specifies the source from which
     * to import metadata. It must begin with `gs://`.
     * </pre>
     *
     * <code>string gcs_uri = 2;</code>
     *
     * @return The gcsUri.
     */
    java.lang.String getGcsUri();
    /**
     *
     *
     * <pre>
     * A Cloud Storage object or folder URI that specifies the source from which
     * to import metadata. It must begin with `gs://`.
     * </pre>
     *
     * <code>string gcs_uri = 2;</code>
     *
     * @return The bytes for gcsUri.
     */
    com.google.protobuf.ByteString getGcsUriBytes();

    /**
     *
     *
     * <pre>
     * The name of the source database.
     * </pre>
     *
     * <code>string source_database = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.source_database is
     *     deprecated. See google/cloud/metastore/v1beta/metastore.proto;l=484
     * @return The sourceDatabase.
     */
    @java.lang.Deprecated
    java.lang.String getSourceDatabase();
    /**
     *
     *
     * <pre>
     * The name of the source database.
     * </pre>
     *
     * <code>string source_database = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.source_database is
     *     deprecated. See google/cloud/metastore/v1beta/metastore.proto;l=484
     * @return The bytes for sourceDatabase.
     */
    @java.lang.Deprecated
    com.google.protobuf.ByteString getSourceDatabaseBytes();

    /**
     *
     *
     * <pre>
     * Optional. The type of the database dump. If unspecified, defaults to
     * `MYSQL`.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.DatabaseDumpSpec.Type type = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    int getTypeValue();
    /**
     *
     *
     * <pre>
     * Optional. The type of the database dump. If unspecified, defaults to
     * `MYSQL`.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.DatabaseDumpSpec.Type type = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The type.
     */
    com.google.cloud.metastore.v1beta.DatabaseDumpSpec.Type getType();
  }
  /**
   *
   *
   * <pre>
   * A specification of the location of and metadata about a database dump from
   * a relational database management system.
   * </pre>
   *
   * Protobuf type {@code google.cloud.metastore.v1beta.MetadataImport.DatabaseDump}
   */
  public static final class DatabaseDump extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.metastore.v1beta.MetadataImport.DatabaseDump)
      DatabaseDumpOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DatabaseDump.newBuilder() to construct.
    private DatabaseDump(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DatabaseDump() {
      databaseType_ = 0;
      gcsUri_ = "";
      sourceDatabase_ = "";
      type_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DatabaseDump();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_MetadataImport_DatabaseDump_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_MetadataImport_DatabaseDump_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.class,
              com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The type of the database.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.DatabaseType}
     */
    public enum DatabaseType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * The type of the source database is unknown.
       * </pre>
       *
       * <code>DATABASE_TYPE_UNSPECIFIED = 0;</code>
       */
      DATABASE_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The type of the source database is MySQL.
       * </pre>
       *
       * <code>MYSQL = 1;</code>
       */
      MYSQL(1),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * The type of the source database is unknown.
       * </pre>
       *
       * <code>DATABASE_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int DATABASE_TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The type of the source database is MySQL.
       * </pre>
       *
       * <code>MYSQL = 1;</code>
       */
      public static final int MYSQL_VALUE = 1;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DatabaseType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static DatabaseType forNumber(int value) {
        switch (value) {
          case 0:
            return DATABASE_TYPE_UNSPECIFIED;
          case 1:
            return MYSQL;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<DatabaseType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<DatabaseType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<DatabaseType>() {
            public DatabaseType findValueByNumber(int number) {
              return DatabaseType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final DatabaseType[] VALUES = values();

      public static DatabaseType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private DatabaseType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.DatabaseType)
    }

    public static final int DATABASE_TYPE_FIELD_NUMBER = 1;
    private int databaseType_;
    /**
     *
     *
     * <pre>
     * The type of the database.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.DatabaseType database_type = 1 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.database_type is
     *     deprecated. See google/cloud/metastore/v1beta/metastore.proto;l=477
     * @return The enum numeric value on the wire for databaseType.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getDatabaseTypeValue() {
      return databaseType_;
    }
    /**
     *
     *
     * <pre>
     * The type of the database.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.DatabaseType database_type = 1 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.database_type is
     *     deprecated. See google/cloud/metastore/v1beta/metastore.proto;l=477
     * @return The databaseType.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.DatabaseType
        getDatabaseType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.DatabaseType result =
          com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.DatabaseType.valueOf(
              databaseType_);
      return result == null
          ? com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.DatabaseType.UNRECOGNIZED
          : result;
    }

    public static final int GCS_URI_FIELD_NUMBER = 2;
    private volatile java.lang.Object gcsUri_;
    /**
     *
     *
     * <pre>
     * A Cloud Storage object or folder URI that specifies the source from which
     * to import metadata. It must begin with `gs://`.
     * </pre>
     *
     * <code>string gcs_uri = 2;</code>
     *
     * @return The gcsUri.
     */
    @java.lang.Override
    public java.lang.String getGcsUri() {
      java.lang.Object ref = gcsUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gcsUri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A Cloud Storage object or folder URI that specifies the source from which
     * to import metadata. It must begin with `gs://`.
     * </pre>
     *
     * <code>string gcs_uri = 2;</code>
     *
     * @return The bytes for gcsUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGcsUriBytes() {
      java.lang.Object ref = gcsUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gcsUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SOURCE_DATABASE_FIELD_NUMBER = 3;
    private volatile java.lang.Object sourceDatabase_;
    /**
     *
     *
     * <pre>
     * The name of the source database.
     * </pre>
     *
     * <code>string source_database = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.source_database is
     *     deprecated. See google/cloud/metastore/v1beta/metastore.proto;l=484
     * @return The sourceDatabase.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.lang.String getSourceDatabase() {
      java.lang.Object ref = sourceDatabase_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceDatabase_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the source database.
     * </pre>
     *
     * <code>string source_database = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.source_database is
     *     deprecated. See google/cloud/metastore/v1beta/metastore.proto;l=484
     * @return The bytes for sourceDatabase.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getSourceDatabaseBytes() {
      java.lang.Object ref = sourceDatabase_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceDatabase_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TYPE_FIELD_NUMBER = 4;
    private int type_;
    /**
     *
     *
     * <pre>
     * Optional. The type of the database dump. If unspecified, defaults to
     * `MYSQL`.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.DatabaseDumpSpec.Type type = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of the database dump. If unspecified, defaults to
     * `MYSQL`.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.DatabaseDumpSpec.Type type = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.metastore.v1beta.DatabaseDumpSpec.Type getType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.metastore.v1beta.DatabaseDumpSpec.Type result =
          com.google.cloud.metastore.v1beta.DatabaseDumpSpec.Type.valueOf(type_);
      return result == null
          ? com.google.cloud.metastore.v1beta.DatabaseDumpSpec.Type.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (databaseType_
          != com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.DatabaseType
              .DATABASE_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, databaseType_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, gcsUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceDatabase_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, sourceDatabase_);
      }
      if (type_
          != com.google.cloud.metastore.v1beta.DatabaseDumpSpec.Type.TYPE_UNSPECIFIED.getNumber()) {
        output.writeEnum(4, type_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (databaseType_
          != com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.DatabaseType
              .DATABASE_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, databaseType_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, gcsUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceDatabase_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, sourceDatabase_);
      }
      if (type_
          != com.google.cloud.metastore.v1beta.DatabaseDumpSpec.Type.TYPE_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, type_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump)) {
        return super.equals(obj);
      }
      com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump other =
          (com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump) obj;

      if (databaseType_ != other.databaseType_) return false;
      if (!getGcsUri().equals(other.getGcsUri())) return false;
      if (!getSourceDatabase().equals(other.getSourceDatabase())) return false;
      if (type_ != other.type_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DATABASE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + databaseType_;
      hash = (37 * hash) + GCS_URI_FIELD_NUMBER;
      hash = (53 * hash) + getGcsUri().hashCode();
      hash = (37 * hash) + SOURCE_DATABASE_FIELD_NUMBER;
      hash = (53 * hash) + getSourceDatabase().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A specification of the location of and metadata about a database dump from
     * a relational database management system.
     * </pre>
     *
     * Protobuf type {@code google.cloud.metastore.v1beta.MetadataImport.DatabaseDump}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.metastore.v1beta.MetadataImport.DatabaseDump)
        com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDumpOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.metastore.v1beta.MetastoreProto
            .internal_static_google_cloud_metastore_v1beta_MetadataImport_DatabaseDump_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.metastore.v1beta.MetastoreProto
            .internal_static_google_cloud_metastore_v1beta_MetadataImport_DatabaseDump_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.class,
                com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.Builder.class);
      }

      // Construct using com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        databaseType_ = 0;

        gcsUri_ = "";

        sourceDatabase_ = "";

        type_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.metastore.v1beta.MetastoreProto
            .internal_static_google_cloud_metastore_v1beta_MetadataImport_DatabaseDump_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump
          getDefaultInstanceForType() {
        return com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump build() {
        com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump buildPartial() {
        com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump result =
            new com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump(this);
        result.databaseType_ = databaseType_;
        result.gcsUri_ = gcsUri_;
        result.sourceDatabase_ = sourceDatabase_;
        result.type_ = type_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump) {
          return mergeFrom((com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump other) {
        if (other
            == com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.getDefaultInstance())
          return this;
        if (other.databaseType_ != 0) {
          setDatabaseTypeValue(other.getDatabaseTypeValue());
        }
        if (!other.getGcsUri().isEmpty()) {
          gcsUri_ = other.gcsUri_;
          onChanged();
        }
        if (!other.getSourceDatabase().isEmpty()) {
          sourceDatabase_ = other.sourceDatabase_;
          onChanged();
        }
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  databaseType_ = input.readEnum();

                  break;
                } // case 8
              case 18:
                {
                  gcsUri_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              case 26:
                {
                  sourceDatabase_ = input.readStringRequireUtf8();

                  break;
                } // case 26
              case 32:
                {
                  type_ = input.readEnum();

                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int databaseType_ = 0;
      /**
       *
       *
       * <pre>
       * The type of the database.
       * </pre>
       *
       * <code>
       * .google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.DatabaseType database_type = 1 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.database_type is
       *     deprecated. See google/cloud/metastore/v1beta/metastore.proto;l=477
       * @return The enum numeric value on the wire for databaseType.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public int getDatabaseTypeValue() {
        return databaseType_;
      }
      /**
       *
       *
       * <pre>
       * The type of the database.
       * </pre>
       *
       * <code>
       * .google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.DatabaseType database_type = 1 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.database_type is
       *     deprecated. See google/cloud/metastore/v1beta/metastore.proto;l=477
       * @param value The enum numeric value on the wire for databaseType to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setDatabaseTypeValue(int value) {

        databaseType_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of the database.
       * </pre>
       *
       * <code>
       * .google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.DatabaseType database_type = 1 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.database_type is
       *     deprecated. See google/cloud/metastore/v1beta/metastore.proto;l=477
       * @return The databaseType.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.DatabaseType
          getDatabaseType() {
        @SuppressWarnings("deprecation")
        com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.DatabaseType result =
            com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.DatabaseType.valueOf(
                databaseType_);
        return result == null
            ? com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.DatabaseType
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The type of the database.
       * </pre>
       *
       * <code>
       * .google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.DatabaseType database_type = 1 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.database_type is
       *     deprecated. See google/cloud/metastore/v1beta/metastore.proto;l=477
       * @param value The databaseType to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setDatabaseType(
          com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.DatabaseType value) {
        if (value == null) {
          throw new NullPointerException();
        }

        databaseType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of the database.
       * </pre>
       *
       * <code>
       * .google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.DatabaseType database_type = 1 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.database_type is
       *     deprecated. See google/cloud/metastore/v1beta/metastore.proto;l=477
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearDatabaseType() {

        databaseType_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object gcsUri_ = "";
      /**
       *
       *
       * <pre>
       * A Cloud Storage object or folder URI that specifies the source from which
       * to import metadata. It must begin with `gs://`.
       * </pre>
       *
       * <code>string gcs_uri = 2;</code>
       *
       * @return The gcsUri.
       */
      public java.lang.String getGcsUri() {
        java.lang.Object ref = gcsUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gcsUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage object or folder URI that specifies the source from which
       * to import metadata. It must begin with `gs://`.
       * </pre>
       *
       * <code>string gcs_uri = 2;</code>
       *
       * @return The bytes for gcsUri.
       */
      public com.google.protobuf.ByteString getGcsUriBytes() {
        java.lang.Object ref = gcsUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gcsUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage object or folder URI that specifies the source from which
       * to import metadata. It must begin with `gs://`.
       * </pre>
       *
       * <code>string gcs_uri = 2;</code>
       *
       * @param value The gcsUri to set.
       * @return This builder for chaining.
       */
      public Builder setGcsUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        gcsUri_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage object or folder URI that specifies the source from which
       * to import metadata. It must begin with `gs://`.
       * </pre>
       *
       * <code>string gcs_uri = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGcsUri() {

        gcsUri_ = getDefaultInstance().getGcsUri();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage object or folder URI that specifies the source from which
       * to import metadata. It must begin with `gs://`.
       * </pre>
       *
       * <code>string gcs_uri = 2;</code>
       *
       * @param value The bytes for gcsUri to set.
       * @return This builder for chaining.
       */
      public Builder setGcsUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        gcsUri_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object sourceDatabase_ = "";
      /**
       *
       *
       * <pre>
       * The name of the source database.
       * </pre>
       *
       * <code>string source_database = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.source_database is
       *     deprecated. See google/cloud/metastore/v1beta/metastore.proto;l=484
       * @return The sourceDatabase.
       */
      @java.lang.Deprecated
      public java.lang.String getSourceDatabase() {
        java.lang.Object ref = sourceDatabase_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sourceDatabase_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the source database.
       * </pre>
       *
       * <code>string source_database = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.source_database is
       *     deprecated. See google/cloud/metastore/v1beta/metastore.proto;l=484
       * @return The bytes for sourceDatabase.
       */
      @java.lang.Deprecated
      public com.google.protobuf.ByteString getSourceDatabaseBytes() {
        java.lang.Object ref = sourceDatabase_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          sourceDatabase_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the source database.
       * </pre>
       *
       * <code>string source_database = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.source_database is
       *     deprecated. See google/cloud/metastore/v1beta/metastore.proto;l=484
       * @param value The sourceDatabase to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setSourceDatabase(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        sourceDatabase_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the source database.
       * </pre>
       *
       * <code>string source_database = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.source_database is
       *     deprecated. See google/cloud/metastore/v1beta/metastore.proto;l=484
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearSourceDatabase() {

        sourceDatabase_ = getDefaultInstance().getSourceDatabase();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the source database.
       * </pre>
       *
       * <code>string source_database = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.source_database is
       *     deprecated. See google/cloud/metastore/v1beta/metastore.proto;l=484
       * @param value The bytes for sourceDatabase to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setSourceDatabaseBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        sourceDatabase_ = value;
        onChanged();
        return this;
      }

      private int type_ = 0;
      /**
       *
       *
       * <pre>
       * Optional. The type of the database dump. If unspecified, defaults to
       * `MYSQL`.
       * </pre>
       *
       * <code>
       * .google.cloud.metastore.v1beta.DatabaseDumpSpec.Type type = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The type of the database dump. If unspecified, defaults to
       * `MYSQL`.
       * </pre>
       *
       * <code>
       * .google.cloud.metastore.v1beta.DatabaseDumpSpec.Type type = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The enum numeric value on the wire for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeValue(int value) {

        type_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The type of the database dump. If unspecified, defaults to
       * `MYSQL`.
       * </pre>
       *
       * <code>
       * .google.cloud.metastore.v1beta.DatabaseDumpSpec.Type type = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.cloud.metastore.v1beta.DatabaseDumpSpec.Type getType() {
        @SuppressWarnings("deprecation")
        com.google.cloud.metastore.v1beta.DatabaseDumpSpec.Type result =
            com.google.cloud.metastore.v1beta.DatabaseDumpSpec.Type.valueOf(type_);
        return result == null
            ? com.google.cloud.metastore.v1beta.DatabaseDumpSpec.Type.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Optional. The type of the database dump. If unspecified, defaults to
       * `MYSQL`.
       * </pre>
       *
       * <code>
       * .google.cloud.metastore.v1beta.DatabaseDumpSpec.Type type = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(com.google.cloud.metastore.v1beta.DatabaseDumpSpec.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }

        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The type of the database dump. If unspecified, defaults to
       * `MYSQL`.
       * </pre>
       *
       * <code>
       * .google.cloud.metastore.v1beta.DatabaseDumpSpec.Type type = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {

        type_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.metastore.v1beta.MetadataImport.DatabaseDump)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.metastore.v1beta.MetadataImport.DatabaseDump)
    private static final com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump();
    }

    public static com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DatabaseDump> PARSER =
        new com.google.protobuf.AbstractParser<DatabaseDump>() {
          @java.lang.Override
          public DatabaseDump parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DatabaseDump> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DatabaseDump> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int metadataCase_ = 0;
  private java.lang.Object metadata_;

  public enum MetadataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DATABASE_DUMP(6),
    METADATA_NOT_SET(0);
    private final int value;

    private MetadataCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MetadataCase valueOf(int value) {
      return forNumber(value);
    }

    public static MetadataCase forNumber(int value) {
      switch (value) {
        case 6:
          return DATABASE_DUMP;
        case 0:
          return METADATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public MetadataCase getMetadataCase() {
    return MetadataCase.forNumber(metadataCase_);
  }

  public static final int DATABASE_DUMP_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Immutable. A database dump from a pre-existing metastore's database.
   * </pre>
   *
   * <code>
   * .google.cloud.metastore.v1beta.MetadataImport.DatabaseDump database_dump = 6 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the databaseDump field is set.
   */
  @java.lang.Override
  public boolean hasDatabaseDump() {
    return metadataCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Immutable. A database dump from a pre-existing metastore's database.
   * </pre>
   *
   * <code>
   * .google.cloud.metastore.v1beta.MetadataImport.DatabaseDump database_dump = 6 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The databaseDump.
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump getDatabaseDump() {
    if (metadataCase_ == 6) {
      return (com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump) metadata_;
    }
    return com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Immutable. A database dump from a pre-existing metastore's database.
   * </pre>
   *
   * <code>
   * .google.cloud.metastore.v1beta.MetadataImport.DatabaseDump database_dump = 6 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDumpOrBuilder
      getDatabaseDumpOrBuilder() {
    if (metadataCase_ == 6) {
      return (com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump) metadata_;
    }
    return com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Immutable. The relative resource name of the metadata import, of the form:
   * `projects/{project_number}/locations/{location_id}/services/{service_id}/metadataImports/{metadata_import_id}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The relative resource name of the metadata import, of the form:
   * `projects/{project_number}/locations/{location_id}/services/{service_id}/metadataImports/{metadata_import_id}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * The description of the metadata import.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The description of the metadata import.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the metadata import was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the metadata import was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the metadata import was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the metadata import was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the metadata import was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the metadata import was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int STATE_FIELD_NUMBER = 5;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. The current state of the metadata import.
   * </pre>
   *
   * <code>
   * .google.cloud.metastore.v1beta.MetadataImport.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of the metadata import.
   * </pre>
   *
   * <code>
   * .google.cloud.metastore.v1beta.MetadataImport.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.MetadataImport.State getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.metastore.v1beta.MetadataImport.State result =
        com.google.cloud.metastore.v1beta.MetadataImport.State.valueOf(state_);
    return result == null
        ? com.google.cloud.metastore.v1beta.MetadataImport.State.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (createTime_ != null) {
      output.writeMessage(3, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(4, getUpdateTime());
    }
    if (state_
        != com.google.cloud.metastore.v1beta.MetadataImport.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(5, state_);
    }
    if (metadataCase_ == 6) {
      output.writeMessage(
          6, (com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump) metadata_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    if (state_
        != com.google.cloud.metastore.v1beta.MetadataImport.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, state_);
    }
    if (metadataCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump) metadata_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.metastore.v1beta.MetadataImport)) {
      return super.equals(obj);
    }
    com.google.cloud.metastore.v1beta.MetadataImport other =
        (com.google.cloud.metastore.v1beta.MetadataImport) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (state_ != other.state_) return false;
    if (!getMetadataCase().equals(other.getMetadataCase())) return false;
    switch (metadataCase_) {
      case 6:
        if (!getDatabaseDump().equals(other.getDatabaseDump())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    switch (metadataCase_) {
      case 6:
        hash = (37 * hash) + DATABASE_DUMP_FIELD_NUMBER;
        hash = (53 * hash) + getDatabaseDump().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.metastore.v1beta.MetadataImport parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.MetadataImport parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.MetadataImport parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.MetadataImport parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.MetadataImport parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.MetadataImport parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.MetadataImport parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.MetadataImport parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.MetadataImport parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.MetadataImport parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.MetadataImport parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.MetadataImport parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.metastore.v1beta.MetadataImport prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A metastore resource that imports metadata.
   * </pre>
   *
   * Protobuf type {@code google.cloud.metastore.v1beta.MetadataImport}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.metastore.v1beta.MetadataImport)
      com.google.cloud.metastore.v1beta.MetadataImportOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_MetadataImport_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_MetadataImport_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.metastore.v1beta.MetadataImport.class,
              com.google.cloud.metastore.v1beta.MetadataImport.Builder.class);
    }

    // Construct using com.google.cloud.metastore.v1beta.MetadataImport.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (databaseDumpBuilder_ != null) {
        databaseDumpBuilder_.clear();
      }
      name_ = "";

      description_ = "";

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      state_ = 0;

      metadataCase_ = 0;
      metadata_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_MetadataImport_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.MetadataImport getDefaultInstanceForType() {
      return com.google.cloud.metastore.v1beta.MetadataImport.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.MetadataImport build() {
      com.google.cloud.metastore.v1beta.MetadataImport result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.MetadataImport buildPartial() {
      com.google.cloud.metastore.v1beta.MetadataImport result =
          new com.google.cloud.metastore.v1beta.MetadataImport(this);
      if (metadataCase_ == 6) {
        if (databaseDumpBuilder_ == null) {
          result.metadata_ = metadata_;
        } else {
          result.metadata_ = databaseDumpBuilder_.build();
        }
      }
      result.name_ = name_;
      result.description_ = description_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      result.state_ = state_;
      result.metadataCase_ = metadataCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.metastore.v1beta.MetadataImport) {
        return mergeFrom((com.google.cloud.metastore.v1beta.MetadataImport) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.metastore.v1beta.MetadataImport other) {
      if (other == com.google.cloud.metastore.v1beta.MetadataImport.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      switch (other.getMetadataCase()) {
        case DATABASE_DUMP:
          {
            mergeDatabaseDump(other.getDatabaseDump());
            break;
          }
        case METADATA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 40:
              {
                state_ = input.readEnum();

                break;
              } // case 40
            case 50:
              {
                input.readMessage(getDatabaseDumpFieldBuilder().getBuilder(), extensionRegistry);
                metadataCase_ = 6;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int metadataCase_ = 0;
    private java.lang.Object metadata_;

    public MetadataCase getMetadataCase() {
      return MetadataCase.forNumber(metadataCase_);
    }

    public Builder clearMetadata() {
      metadataCase_ = 0;
      metadata_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump,
            com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.Builder,
            com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDumpOrBuilder>
        databaseDumpBuilder_;
    /**
     *
     *
     * <pre>
     * Immutable. A database dump from a pre-existing metastore's database.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport.DatabaseDump database_dump = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the databaseDump field is set.
     */
    @java.lang.Override
    public boolean hasDatabaseDump() {
      return metadataCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Immutable. A database dump from a pre-existing metastore's database.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport.DatabaseDump database_dump = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The databaseDump.
     */
    @java.lang.Override
    public com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump getDatabaseDump() {
      if (databaseDumpBuilder_ == null) {
        if (metadataCase_ == 6) {
          return (com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump) metadata_;
        }
        return com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.getDefaultInstance();
      } else {
        if (metadataCase_ == 6) {
          return databaseDumpBuilder_.getMessage();
        }
        return com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. A database dump from a pre-existing metastore's database.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport.DatabaseDump database_dump = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setDatabaseDump(
        com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump value) {
      if (databaseDumpBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
        onChanged();
      } else {
        databaseDumpBuilder_.setMessage(value);
      }
      metadataCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. A database dump from a pre-existing metastore's database.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport.DatabaseDump database_dump = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setDatabaseDump(
        com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.Builder builderForValue) {
      if (databaseDumpBuilder_ == null) {
        metadata_ = builderForValue.build();
        onChanged();
      } else {
        databaseDumpBuilder_.setMessage(builderForValue.build());
      }
      metadataCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. A database dump from a pre-existing metastore's database.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport.DatabaseDump database_dump = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeDatabaseDump(
        com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump value) {
      if (databaseDumpBuilder_ == null) {
        if (metadataCase_ == 6
            && metadata_
                != com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump
                    .getDefaultInstance()) {
          metadata_ =
              com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.newBuilder(
                      (com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump) metadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metadata_ = value;
        }
        onChanged();
      } else {
        if (metadataCase_ == 6) {
          databaseDumpBuilder_.mergeFrom(value);
        } else {
          databaseDumpBuilder_.setMessage(value);
        }
      }
      metadataCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. A database dump from a pre-existing metastore's database.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport.DatabaseDump database_dump = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearDatabaseDump() {
      if (databaseDumpBuilder_ == null) {
        if (metadataCase_ == 6) {
          metadataCase_ = 0;
          metadata_ = null;
          onChanged();
        }
      } else {
        if (metadataCase_ == 6) {
          metadataCase_ = 0;
          metadata_ = null;
        }
        databaseDumpBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. A database dump from a pre-existing metastore's database.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport.DatabaseDump database_dump = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.Builder
        getDatabaseDumpBuilder() {
      return getDatabaseDumpFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Immutable. A database dump from a pre-existing metastore's database.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport.DatabaseDump database_dump = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDumpOrBuilder
        getDatabaseDumpOrBuilder() {
      if ((metadataCase_ == 6) && (databaseDumpBuilder_ != null)) {
        return databaseDumpBuilder_.getMessageOrBuilder();
      } else {
        if (metadataCase_ == 6) {
          return (com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump) metadata_;
        }
        return com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. A database dump from a pre-existing metastore's database.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport.DatabaseDump database_dump = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump,
            com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.Builder,
            com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDumpOrBuilder>
        getDatabaseDumpFieldBuilder() {
      if (databaseDumpBuilder_ == null) {
        if (!(metadataCase_ == 6)) {
          metadata_ =
              com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.getDefaultInstance();
        }
        databaseDumpBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump,
                com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump.Builder,
                com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDumpOrBuilder>(
                (com.google.cloud.metastore.v1beta.MetadataImport.DatabaseDump) metadata_,
                getParentForChildren(),
                isClean());
        metadata_ = null;
      }
      metadataCase_ = 6;
      onChanged();
      ;
      return databaseDumpBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The relative resource name of the metadata import, of the form:
     * `projects/{project_number}/locations/{location_id}/services/{service_id}/metadataImports/{metadata_import_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The relative resource name of the metadata import, of the form:
     * `projects/{project_number}/locations/{location_id}/services/{service_id}/metadataImports/{metadata_import_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The relative resource name of the metadata import, of the form:
     * `projects/{project_number}/locations/{location_id}/services/{service_id}/metadataImports/{metadata_import_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The relative resource name of the metadata import, of the form:
     * `projects/{project_number}/locations/{location_id}/services/{service_id}/metadataImports/{metadata_import_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The relative resource name of the metadata import, of the form:
     * `projects/{project_number}/locations/{location_id}/services/{service_id}/metadataImports/{metadata_import_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * The description of the metadata import.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the metadata import.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the metadata import.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the metadata import.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the metadata import.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the metadata import was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metadata import was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metadata import was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metadata import was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metadata import was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metadata import was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metadata import was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metadata import was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metadata import was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the metadata import was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metadata import was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metadata import was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metadata import was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metadata import was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metadata import was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metadata import was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metadata import was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metadata import was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state of the metadata import.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the metadata import.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the metadata import.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.metastore.v1beta.MetadataImport.State getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.metastore.v1beta.MetadataImport.State result =
          com.google.cloud.metastore.v1beta.MetadataImport.State.valueOf(state_);
      return result == null
          ? com.google.cloud.metastore.v1beta.MetadataImport.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the metadata import.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.metastore.v1beta.MetadataImport.State value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the metadata import.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.metastore.v1beta.MetadataImport)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.metastore.v1beta.MetadataImport)
  private static final com.google.cloud.metastore.v1beta.MetadataImport DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.metastore.v1beta.MetadataImport();
  }

  public static com.google.cloud.metastore.v1beta.MetadataImport getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MetadataImport> PARSER =
      new com.google.protobuf.AbstractParser<MetadataImport>() {
        @java.lang.Override
        public MetadataImport parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MetadataImport> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MetadataImport> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.metastore.v1beta.MetadataImport getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
