/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/metastore/v1beta/metastore.proto

package com.google.cloud.metastore.v1beta;

/**
 *
 *
 * <pre>
 * Specifies configuration information specific to running Hive metastore
 * software as the metastore service.
 * </pre>
 *
 * Protobuf type {@code google.cloud.metastore.v1beta.HiveMetastoreConfig}
 */
public final class HiveMetastoreConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.metastore.v1beta.HiveMetastoreConfig)
    HiveMetastoreConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use HiveMetastoreConfig.newBuilder() to construct.
  private HiveMetastoreConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private HiveMetastoreConfig() {
    version_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new HiveMetastoreConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.metastore.v1beta.MetastoreProto
        .internal_static_google_cloud_metastore_v1beta_HiveMetastoreConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 2:
        return internalGetConfigOverrides();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.metastore.v1beta.MetastoreProto
        .internal_static_google_cloud_metastore_v1beta_HiveMetastoreConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.metastore.v1beta.HiveMetastoreConfig.class,
            com.google.cloud.metastore.v1beta.HiveMetastoreConfig.Builder.class);
  }

  public static final int VERSION_FIELD_NUMBER = 1;
  private volatile java.lang.Object version_;
  /**
   *
   *
   * <pre>
   * Immutable. The Hive metastore schema version.
   * </pre>
   *
   * <code>string version = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The version.
   */
  @java.lang.Override
  public java.lang.String getVersion() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      version_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The Hive metastore schema version.
   * </pre>
   *
   * <code>string version = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for version.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionBytes() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      version_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONFIG_OVERRIDES_FIELD_NUMBER = 2;

  private static final class ConfigOverridesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.metastore.v1beta.MetastoreProto
                .internal_static_google_cloud_metastore_v1beta_HiveMetastoreConfig_ConfigOverridesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> configOverrides_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetConfigOverrides() {
    if (configOverrides_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ConfigOverridesDefaultEntryHolder.defaultEntry);
    }
    return configOverrides_;
  }

  public int getConfigOverridesCount() {
    return internalGetConfigOverrides().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * A mapping of Hive metastore configuration key-value pairs to apply to the
   * Hive metastore (configured in `hive-site.xml`). The mappings
   * override system defaults (some keys cannot be overridden).
   * </pre>
   *
   * <code>map&lt;string, string&gt; config_overrides = 2;</code>
   */
  @java.lang.Override
  public boolean containsConfigOverrides(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetConfigOverrides().getMap().containsKey(key);
  }
  /** Use {@link #getConfigOverridesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getConfigOverrides() {
    return getConfigOverridesMap();
  }
  /**
   *
   *
   * <pre>
   * A mapping of Hive metastore configuration key-value pairs to apply to the
   * Hive metastore (configured in `hive-site.xml`). The mappings
   * override system defaults (some keys cannot be overridden).
   * </pre>
   *
   * <code>map&lt;string, string&gt; config_overrides = 2;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getConfigOverridesMap() {
    return internalGetConfigOverrides().getMap();
  }
  /**
   *
   *
   * <pre>
   * A mapping of Hive metastore configuration key-value pairs to apply to the
   * Hive metastore (configured in `hive-site.xml`). The mappings
   * override system defaults (some keys cannot be overridden).
   * </pre>
   *
   * <code>map&lt;string, string&gt; config_overrides = 2;</code>
   */
  @java.lang.Override
  public java.lang.String getConfigOverridesOrDefault(
      java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetConfigOverrides().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * A mapping of Hive metastore configuration key-value pairs to apply to the
   * Hive metastore (configured in `hive-site.xml`). The mappings
   * override system defaults (some keys cannot be overridden).
   * </pre>
   *
   * <code>map&lt;string, string&gt; config_overrides = 2;</code>
   */
  @java.lang.Override
  public java.lang.String getConfigOverridesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetConfigOverrides().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int KERBEROS_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.metastore.v1beta.KerberosConfig kerberosConfig_;
  /**
   *
   *
   * <pre>
   * Information used to configure the Hive metastore service as a service
   * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
   * method and specify this field's path
   * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
   * while omitting this field from the request's `service`.
   * </pre>
   *
   * <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
   *
   * @return Whether the kerberosConfig field is set.
   */
  @java.lang.Override
  public boolean hasKerberosConfig() {
    return kerberosConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Information used to configure the Hive metastore service as a service
   * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
   * method and specify this field's path
   * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
   * while omitting this field from the request's `service`.
   * </pre>
   *
   * <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
   *
   * @return The kerberosConfig.
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.KerberosConfig getKerberosConfig() {
    return kerberosConfig_ == null
        ? com.google.cloud.metastore.v1beta.KerberosConfig.getDefaultInstance()
        : kerberosConfig_;
  }
  /**
   *
   *
   * <pre>
   * Information used to configure the Hive metastore service as a service
   * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
   * method and specify this field's path
   * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
   * while omitting this field from the request's `service`.
   * </pre>
   *
   * <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.KerberosConfigOrBuilder getKerberosConfigOrBuilder() {
    return getKerberosConfig();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, version_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetConfigOverrides(), ConfigOverridesDefaultEntryHolder.defaultEntry, 2);
    if (kerberosConfig_ != null) {
      output.writeMessage(3, getKerberosConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, version_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetConfigOverrides().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> configOverrides__ =
          ConfigOverridesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, configOverrides__);
    }
    if (kerberosConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getKerberosConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.metastore.v1beta.HiveMetastoreConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.metastore.v1beta.HiveMetastoreConfig other =
        (com.google.cloud.metastore.v1beta.HiveMetastoreConfig) obj;

    if (!getVersion().equals(other.getVersion())) return false;
    if (!internalGetConfigOverrides().equals(other.internalGetConfigOverrides())) return false;
    if (hasKerberosConfig() != other.hasKerberosConfig()) return false;
    if (hasKerberosConfig()) {
      if (!getKerberosConfig().equals(other.getKerberosConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getVersion().hashCode();
    if (!internalGetConfigOverrides().getMap().isEmpty()) {
      hash = (37 * hash) + CONFIG_OVERRIDES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetConfigOverrides().hashCode();
    }
    if (hasKerberosConfig()) {
      hash = (37 * hash) + KERBEROS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getKerberosConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.metastore.v1beta.HiveMetastoreConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies configuration information specific to running Hive metastore
   * software as the metastore service.
   * </pre>
   *
   * Protobuf type {@code google.cloud.metastore.v1beta.HiveMetastoreConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.metastore.v1beta.HiveMetastoreConfig)
      com.google.cloud.metastore.v1beta.HiveMetastoreConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_HiveMetastoreConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 2:
          return internalGetConfigOverrides();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 2:
          return internalGetMutableConfigOverrides();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_HiveMetastoreConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.metastore.v1beta.HiveMetastoreConfig.class,
              com.google.cloud.metastore.v1beta.HiveMetastoreConfig.Builder.class);
    }

    // Construct using com.google.cloud.metastore.v1beta.HiveMetastoreConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      version_ = "";

      internalGetMutableConfigOverrides().clear();
      if (kerberosConfigBuilder_ == null) {
        kerberosConfig_ = null;
      } else {
        kerberosConfig_ = null;
        kerberosConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_HiveMetastoreConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.HiveMetastoreConfig getDefaultInstanceForType() {
      return com.google.cloud.metastore.v1beta.HiveMetastoreConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.HiveMetastoreConfig build() {
      com.google.cloud.metastore.v1beta.HiveMetastoreConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.HiveMetastoreConfig buildPartial() {
      com.google.cloud.metastore.v1beta.HiveMetastoreConfig result =
          new com.google.cloud.metastore.v1beta.HiveMetastoreConfig(this);
      int from_bitField0_ = bitField0_;
      result.version_ = version_;
      result.configOverrides_ = internalGetConfigOverrides();
      result.configOverrides_.makeImmutable();
      if (kerberosConfigBuilder_ == null) {
        result.kerberosConfig_ = kerberosConfig_;
      } else {
        result.kerberosConfig_ = kerberosConfigBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.metastore.v1beta.HiveMetastoreConfig) {
        return mergeFrom((com.google.cloud.metastore.v1beta.HiveMetastoreConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.metastore.v1beta.HiveMetastoreConfig other) {
      if (other == com.google.cloud.metastore.v1beta.HiveMetastoreConfig.getDefaultInstance())
        return this;
      if (!other.getVersion().isEmpty()) {
        version_ = other.version_;
        onChanged();
      }
      internalGetMutableConfigOverrides().mergeFrom(other.internalGetConfigOverrides());
      if (other.hasKerberosConfig()) {
        mergeKerberosConfig(other.getKerberosConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                version_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> configOverrides__ =
                    input.readMessage(
                        ConfigOverridesDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableConfigOverrides()
                    .getMutableMap()
                    .put(configOverrides__.getKey(), configOverrides__.getValue());
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getKerberosConfigFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The Hive metastore schema version.
     * </pre>
     *
     * <code>string version = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The version.
     */
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The Hive metastore schema version.
     * </pre>
     *
     * <code>string version = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for version.
     */
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The Hive metastore schema version.
     * </pre>
     *
     * <code>string version = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The version to set.
     * @return This builder for chaining.
     */
    public Builder setVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      version_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The Hive metastore schema version.
     * </pre>
     *
     * <code>string version = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersion() {

      version_ = getDefaultInstance().getVersion();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The Hive metastore schema version.
     * </pre>
     *
     * <code>string version = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for version to set.
     * @return This builder for chaining.
     */
    public Builder setVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      version_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> configOverrides_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetConfigOverrides() {
      if (configOverrides_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ConfigOverridesDefaultEntryHolder.defaultEntry);
      }
      return configOverrides_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableConfigOverrides() {
      onChanged();
      ;
      if (configOverrides_ == null) {
        configOverrides_ =
            com.google.protobuf.MapField.newMapField(
                ConfigOverridesDefaultEntryHolder.defaultEntry);
      }
      if (!configOverrides_.isMutable()) {
        configOverrides_ = configOverrides_.copy();
      }
      return configOverrides_;
    }

    public int getConfigOverridesCount() {
      return internalGetConfigOverrides().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * A mapping of Hive metastore configuration key-value pairs to apply to the
     * Hive metastore (configured in `hive-site.xml`). The mappings
     * override system defaults (some keys cannot be overridden).
     * </pre>
     *
     * <code>map&lt;string, string&gt; config_overrides = 2;</code>
     */
    @java.lang.Override
    public boolean containsConfigOverrides(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetConfigOverrides().getMap().containsKey(key);
    }
    /** Use {@link #getConfigOverridesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getConfigOverrides() {
      return getConfigOverridesMap();
    }
    /**
     *
     *
     * <pre>
     * A mapping of Hive metastore configuration key-value pairs to apply to the
     * Hive metastore (configured in `hive-site.xml`). The mappings
     * override system defaults (some keys cannot be overridden).
     * </pre>
     *
     * <code>map&lt;string, string&gt; config_overrides = 2;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getConfigOverridesMap() {
      return internalGetConfigOverrides().getMap();
    }
    /**
     *
     *
     * <pre>
     * A mapping of Hive metastore configuration key-value pairs to apply to the
     * Hive metastore (configured in `hive-site.xml`). The mappings
     * override system defaults (some keys cannot be overridden).
     * </pre>
     *
     * <code>map&lt;string, string&gt; config_overrides = 2;</code>
     */
    @java.lang.Override
    public java.lang.String getConfigOverridesOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetConfigOverrides().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * A mapping of Hive metastore configuration key-value pairs to apply to the
     * Hive metastore (configured in `hive-site.xml`). The mappings
     * override system defaults (some keys cannot be overridden).
     * </pre>
     *
     * <code>map&lt;string, string&gt; config_overrides = 2;</code>
     */
    @java.lang.Override
    public java.lang.String getConfigOverridesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetConfigOverrides().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearConfigOverrides() {
      internalGetMutableConfigOverrides().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A mapping of Hive metastore configuration key-value pairs to apply to the
     * Hive metastore (configured in `hive-site.xml`). The mappings
     * override system defaults (some keys cannot be overridden).
     * </pre>
     *
     * <code>map&lt;string, string&gt; config_overrides = 2;</code>
     */
    public Builder removeConfigOverrides(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableConfigOverrides().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableConfigOverrides() {
      return internalGetMutableConfigOverrides().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * A mapping of Hive metastore configuration key-value pairs to apply to the
     * Hive metastore (configured in `hive-site.xml`). The mappings
     * override system defaults (some keys cannot be overridden).
     * </pre>
     *
     * <code>map&lt;string, string&gt; config_overrides = 2;</code>
     */
    public Builder putConfigOverrides(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableConfigOverrides().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * A mapping of Hive metastore configuration key-value pairs to apply to the
     * Hive metastore (configured in `hive-site.xml`). The mappings
     * override system defaults (some keys cannot be overridden).
     * </pre>
     *
     * <code>map&lt;string, string&gt; config_overrides = 2;</code>
     */
    public Builder putAllConfigOverrides(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableConfigOverrides().getMutableMap().putAll(values);
      return this;
    }

    private com.google.cloud.metastore.v1beta.KerberosConfig kerberosConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.metastore.v1beta.KerberosConfig,
            com.google.cloud.metastore.v1beta.KerberosConfig.Builder,
            com.google.cloud.metastore.v1beta.KerberosConfigOrBuilder>
        kerberosConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Information used to configure the Hive metastore service as a service
     * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
     * method and specify this field's path
     * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
     * while omitting this field from the request's `service`.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
     *
     * @return Whether the kerberosConfig field is set.
     */
    public boolean hasKerberosConfig() {
      return kerberosConfigBuilder_ != null || kerberosConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Information used to configure the Hive metastore service as a service
     * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
     * method and specify this field's path
     * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
     * while omitting this field from the request's `service`.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
     *
     * @return The kerberosConfig.
     */
    public com.google.cloud.metastore.v1beta.KerberosConfig getKerberosConfig() {
      if (kerberosConfigBuilder_ == null) {
        return kerberosConfig_ == null
            ? com.google.cloud.metastore.v1beta.KerberosConfig.getDefaultInstance()
            : kerberosConfig_;
      } else {
        return kerberosConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Information used to configure the Hive metastore service as a service
     * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
     * method and specify this field's path
     * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
     * while omitting this field from the request's `service`.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
     */
    public Builder setKerberosConfig(com.google.cloud.metastore.v1beta.KerberosConfig value) {
      if (kerberosConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kerberosConfig_ = value;
        onChanged();
      } else {
        kerberosConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Information used to configure the Hive metastore service as a service
     * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
     * method and specify this field's path
     * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
     * while omitting this field from the request's `service`.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
     */
    public Builder setKerberosConfig(
        com.google.cloud.metastore.v1beta.KerberosConfig.Builder builderForValue) {
      if (kerberosConfigBuilder_ == null) {
        kerberosConfig_ = builderForValue.build();
        onChanged();
      } else {
        kerberosConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Information used to configure the Hive metastore service as a service
     * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
     * method and specify this field's path
     * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
     * while omitting this field from the request's `service`.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
     */
    public Builder mergeKerberosConfig(com.google.cloud.metastore.v1beta.KerberosConfig value) {
      if (kerberosConfigBuilder_ == null) {
        if (kerberosConfig_ != null) {
          kerberosConfig_ =
              com.google.cloud.metastore.v1beta.KerberosConfig.newBuilder(kerberosConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          kerberosConfig_ = value;
        }
        onChanged();
      } else {
        kerberosConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Information used to configure the Hive metastore service as a service
     * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
     * method and specify this field's path
     * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
     * while omitting this field from the request's `service`.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
     */
    public Builder clearKerberosConfig() {
      if (kerberosConfigBuilder_ == null) {
        kerberosConfig_ = null;
        onChanged();
      } else {
        kerberosConfig_ = null;
        kerberosConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Information used to configure the Hive metastore service as a service
     * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
     * method and specify this field's path
     * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
     * while omitting this field from the request's `service`.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
     */
    public com.google.cloud.metastore.v1beta.KerberosConfig.Builder getKerberosConfigBuilder() {

      onChanged();
      return getKerberosConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Information used to configure the Hive metastore service as a service
     * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
     * method and specify this field's path
     * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
     * while omitting this field from the request's `service`.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
     */
    public com.google.cloud.metastore.v1beta.KerberosConfigOrBuilder getKerberosConfigOrBuilder() {
      if (kerberosConfigBuilder_ != null) {
        return kerberosConfigBuilder_.getMessageOrBuilder();
      } else {
        return kerberosConfig_ == null
            ? com.google.cloud.metastore.v1beta.KerberosConfig.getDefaultInstance()
            : kerberosConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Information used to configure the Hive metastore service as a service
     * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
     * method and specify this field's path
     * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
     * while omitting this field from the request's `service`.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.metastore.v1beta.KerberosConfig,
            com.google.cloud.metastore.v1beta.KerberosConfig.Builder,
            com.google.cloud.metastore.v1beta.KerberosConfigOrBuilder>
        getKerberosConfigFieldBuilder() {
      if (kerberosConfigBuilder_ == null) {
        kerberosConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.metastore.v1beta.KerberosConfig,
                com.google.cloud.metastore.v1beta.KerberosConfig.Builder,
                com.google.cloud.metastore.v1beta.KerberosConfigOrBuilder>(
                getKerberosConfig(), getParentForChildren(), isClean());
        kerberosConfig_ = null;
      }
      return kerberosConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.metastore.v1beta.HiveMetastoreConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.metastore.v1beta.HiveMetastoreConfig)
  private static final com.google.cloud.metastore.v1beta.HiveMetastoreConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.metastore.v1beta.HiveMetastoreConfig();
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HiveMetastoreConfig> PARSER =
      new com.google.protobuf.AbstractParser<HiveMetastoreConfig>() {
        @java.lang.Override
        public HiveMetastoreConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<HiveMetastoreConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HiveMetastoreConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.metastore.v1beta.HiveMetastoreConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
