/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/certificatemanager/v1/certificate_manager.proto

package com.google.cloud.certificatemanager.v1;

/**
 *
 *
 * <pre>
 * A DnsAuthorization resource describes a way to perform domain authorization
 * for certificate issuance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.certificatemanager.v1.DnsAuthorization}
 */
public final class DnsAuthorization extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.certificatemanager.v1.DnsAuthorization)
    DnsAuthorizationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DnsAuthorization.newBuilder() to construct.
  private DnsAuthorization(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DnsAuthorization() {
    name_ = "";
    description_ = "";
    domain_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DnsAuthorization();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.certificatemanager.v1.CertificateManagerProto
        .internal_static_google_cloud_certificatemanager_v1_DnsAuthorization_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.certificatemanager.v1.CertificateManagerProto
        .internal_static_google_cloud_certificatemanager_v1_DnsAuthorization_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.certificatemanager.v1.DnsAuthorization.class,
            com.google.cloud.certificatemanager.v1.DnsAuthorization.Builder.class);
  }

  public interface DnsResourceRecordOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. Fully qualified name of the DNS Resource Record.
     * e.g. `_acme-challenge.example.com`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Output only. Fully qualified name of the DNS Resource Record.
     * e.g. `_acme-challenge.example.com`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Output only. Type of the DNS Resource Record.
     * Currently always set to "CNAME".
     * </pre>
     *
     * <code>string type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The type.
     */
    java.lang.String getType();
    /**
     *
     *
     * <pre>
     * Output only. Type of the DNS Resource Record.
     * Currently always set to "CNAME".
     * </pre>
     *
     * <code>string type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for type.
     */
    com.google.protobuf.ByteString getTypeBytes();

    /**
     *
     *
     * <pre>
     * Output only. Data of the DNS Resource Record.
     * </pre>
     *
     * <code>string data = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The data.
     */
    java.lang.String getData();
    /**
     *
     *
     * <pre>
     * Output only. Data of the DNS Resource Record.
     * </pre>
     *
     * <code>string data = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for data.
     */
    com.google.protobuf.ByteString getDataBytes();
  }
  /**
   *
   *
   * <pre>
   * The structure describing the DNS Resource Record that needs to be added
   * to DNS configuration for the authorization to be usable by
   * certificate.
   * </pre>
   *
   * Protobuf type {@code google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord}
   */
  public static final class DnsResourceRecord extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord)
      DnsResourceRecordOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DnsResourceRecord.newBuilder() to construct.
    private DnsResourceRecord(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DnsResourceRecord() {
      name_ = "";
      type_ = "";
      data_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DnsResourceRecord();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.certificatemanager.v1.CertificateManagerProto
          .internal_static_google_cloud_certificatemanager_v1_DnsAuthorization_DnsResourceRecord_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.certificatemanager.v1.CertificateManagerProto
          .internal_static_google_cloud_certificatemanager_v1_DnsAuthorization_DnsResourceRecord_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord.class,
              com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord.Builder
                  .class);
    }

    public static final int NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object name_;
    /**
     *
     *
     * <pre>
     * Output only. Fully qualified name of the DNS Resource Record.
     * e.g. `_acme-challenge.example.com`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Fully qualified name of the DNS Resource Record.
     * e.g. `_acme-challenge.example.com`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TYPE_FIELD_NUMBER = 2;
    private volatile java.lang.Object type_;
    /**
     *
     *
     * <pre>
     * Output only. Type of the DNS Resource Record.
     * Currently always set to "CNAME".
     * </pre>
     *
     * <code>string type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Type of the DNS Resource Record.
     * Currently always set to "CNAME".
     * </pre>
     *
     * <code>string type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for type.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DATA_FIELD_NUMBER = 3;
    private volatile java.lang.Object data_;
    /**
     *
     *
     * <pre>
     * Output only. Data of the DNS Resource Record.
     * </pre>
     *
     * <code>string data = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The data.
     */
    @java.lang.Override
    public java.lang.String getData() {
      java.lang.Object ref = data_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        data_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Data of the DNS Resource Record.
     * </pre>
     *
     * <code>string data = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for data.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDataBytes() {
      java.lang.Object ref = data_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        data_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, type_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(data_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, data_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, type_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(data_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, data_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord)) {
        return super.equals(obj);
      }
      com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord other =
          (com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getType().equals(other.getType())) return false;
      if (!getData().equals(other.getData())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getType().hashCode();
      hash = (37 * hash) + DATA_FIELD_NUMBER;
      hash = (53 * hash) + getData().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The structure describing the DNS Resource Record that needs to be added
     * to DNS configuration for the authorization to be usable by
     * certificate.
     * </pre>
     *
     * Protobuf type {@code google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord)
        com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecordOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.certificatemanager.v1.CertificateManagerProto
            .internal_static_google_cloud_certificatemanager_v1_DnsAuthorization_DnsResourceRecord_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.certificatemanager.v1.CertificateManagerProto
            .internal_static_google_cloud_certificatemanager_v1_DnsAuthorization_DnsResourceRecord_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord.class,
                com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        name_ = "";

        type_ = "";

        data_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.certificatemanager.v1.CertificateManagerProto
            .internal_static_google_cloud_certificatemanager_v1_DnsAuthorization_DnsResourceRecord_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
          getDefaultInstanceForType() {
        return com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord build() {
        com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
          buildPartial() {
        com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord result =
            new com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord(this);
        result.name_ = name_;
        result.type_ = type_;
        result.data_ = data_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord) {
          return mergeFrom(
              (com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord other) {
        if (other
            == com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        if (!other.getType().isEmpty()) {
          type_ = other.type_;
          onChanged();
        }
        if (!other.getData().isEmpty()) {
          data_ = other.data_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  type_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              case 26:
                {
                  data_ = input.readStringRequireUtf8();

                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Output only. Fully qualified name of the DNS Resource Record.
       * e.g. `_acme-challenge.example.com`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Fully qualified name of the DNS Resource Record.
       * e.g. `_acme-challenge.example.com`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Fully qualified name of the DNS Resource Record.
       * e.g. `_acme-challenge.example.com`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        name_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Fully qualified name of the DNS Resource Record.
       * e.g. `_acme-challenge.example.com`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {

        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Fully qualified name of the DNS Resource Record.
       * e.g. `_acme-challenge.example.com`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        name_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object type_ = "";
      /**
       *
       *
       * <pre>
       * Output only. Type of the DNS Resource Record.
       * Currently always set to "CNAME".
       * </pre>
       *
       * <code>string type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The type.
       */
      public java.lang.String getType() {
        java.lang.Object ref = type_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          type_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Type of the DNS Resource Record.
       * Currently always set to "CNAME".
       * </pre>
       *
       * <code>string type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for type.
       */
      public com.google.protobuf.ByteString getTypeBytes() {
        java.lang.Object ref = type_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          type_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Type of the DNS Resource Record.
       * Currently always set to "CNAME".
       * </pre>
       *
       * <code>string type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        type_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Type of the DNS Resource Record.
       * Currently always set to "CNAME".
       * </pre>
       *
       * <code>string type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {

        type_ = getDefaultInstance().getType();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Type of the DNS Resource Record.
       * Currently always set to "CNAME".
       * </pre>
       *
       * <code>string type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        type_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object data_ = "";
      /**
       *
       *
       * <pre>
       * Output only. Data of the DNS Resource Record.
       * </pre>
       *
       * <code>string data = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The data.
       */
      public java.lang.String getData() {
        java.lang.Object ref = data_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          data_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Data of the DNS Resource Record.
       * </pre>
       *
       * <code>string data = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for data.
       */
      public com.google.protobuf.ByteString getDataBytes() {
        java.lang.Object ref = data_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          data_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Data of the DNS Resource Record.
       * </pre>
       *
       * <code>string data = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The data to set.
       * @return This builder for chaining.
       */
      public Builder setData(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        data_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Data of the DNS Resource Record.
       * </pre>
       *
       * <code>string data = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearData() {

        data_ = getDefaultInstance().getData();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Data of the DNS Resource Record.
       * </pre>
       *
       * <code>string data = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for data to set.
       * @return This builder for chaining.
       */
      public Builder setDataBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        data_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord)
    private static final com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord();
    }

    public static com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DnsResourceRecord> PARSER =
        new com.google.protobuf.AbstractParser<DnsResourceRecord>() {
          @java.lang.Override
          public DnsResourceRecord parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DnsResourceRecord> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DnsResourceRecord> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * A user-defined name of the dns authorization. DnsAuthorization names must
   * be unique globally and match pattern
   * `projects/&#42;&#47;locations/&#42;&#47;dnsAuthorizations/&#42;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A user-defined name of the dns authorization. DnsAuthorization names must
   * be unique globally and match pattern
   * `projects/&#42;&#47;locations/&#42;&#47;dnsAuthorizations/&#42;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a DnsAuthorization.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a DnsAuthorization.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a DnsAuthorization.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a DnsAuthorization.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a DnsAuthorization.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a DnsAuthorization.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.certificatemanager.v1.CertificateManagerProto
                .internal_static_google_cloud_certificatemanager_v1_DnsAuthorization_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Set of labels associated with a DnsAuthorization.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Set of labels associated with a DnsAuthorization.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Set of labels associated with a DnsAuthorization.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Set of labels associated with a DnsAuthorization.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 5;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * One or more paragraphs of text description of a DnsAuthorization.
   * </pre>
   *
   * <code>string description = 5;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * One or more paragraphs of text description of a DnsAuthorization.
   * </pre>
   *
   * <code>string description = 5;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOMAIN_FIELD_NUMBER = 6;
  private volatile java.lang.Object domain_;
  /**
   *
   *
   * <pre>
   * Required. Immutable. A domain which is being authorized. A DnsAuthorization
   * resource covers a single domain and its wildcard, e.g. authorization for
   * `example.com` can be used to issue certificates for `example.com` and
   * `*.example.com`.
   * </pre>
   *
   * <code>
   * string domain = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The domain.
   */
  @java.lang.Override
  public java.lang.String getDomain() {
    java.lang.Object ref = domain_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      domain_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. A domain which is being authorized. A DnsAuthorization
   * resource covers a single domain and its wildcard, e.g. authorization for
   * `example.com` can be used to issue certificates for `example.com` and
   * `*.example.com`.
   * </pre>
   *
   * <code>
   * string domain = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for domain.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDomainBytes() {
    java.lang.Object ref = domain_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      domain_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DNS_RESOURCE_RECORD_FIELD_NUMBER = 10;
  private com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
      dnsResourceRecord_;
  /**
   *
   *
   * <pre>
   * Output only. DNS Resource Record that needs to be added to DNS
   * configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord dns_resource_record = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the dnsResourceRecord field is set.
   */
  @java.lang.Override
  public boolean hasDnsResourceRecord() {
    return dnsResourceRecord_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. DNS Resource Record that needs to be added to DNS
   * configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord dns_resource_record = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The dnsResourceRecord.
   */
  @java.lang.Override
  public com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
      getDnsResourceRecord() {
    return dnsResourceRecord_ == null
        ? com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
            .getDefaultInstance()
        : dnsResourceRecord_;
  }
  /**
   *
   *
   * <pre>
   * Output only. DNS Resource Record that needs to be added to DNS
   * configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord dns_resource_record = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecordOrBuilder
      getDnsResourceRecordOrBuilder() {
    return getDnsResourceRecord();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(3, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(domain_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, domain_);
    }
    if (dnsResourceRecord_ != null) {
      output.writeMessage(10, getDnsResourceRecord());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(domain_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, domain_);
    }
    if (dnsResourceRecord_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getDnsResourceRecord());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.certificatemanager.v1.DnsAuthorization)) {
      return super.equals(obj);
    }
    com.google.cloud.certificatemanager.v1.DnsAuthorization other =
        (com.google.cloud.certificatemanager.v1.DnsAuthorization) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getDomain().equals(other.getDomain())) return false;
    if (hasDnsResourceRecord() != other.hasDnsResourceRecord()) return false;
    if (hasDnsResourceRecord()) {
      if (!getDnsResourceRecord().equals(other.getDnsResourceRecord())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + DOMAIN_FIELD_NUMBER;
    hash = (53 * hash) + getDomain().hashCode();
    if (hasDnsResourceRecord()) {
      hash = (37 * hash) + DNS_RESOURCE_RECORD_FIELD_NUMBER;
      hash = (53 * hash) + getDnsResourceRecord().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.certificatemanager.v1.DnsAuthorization parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.certificatemanager.v1.DnsAuthorization parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.DnsAuthorization parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.certificatemanager.v1.DnsAuthorization parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.DnsAuthorization parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.certificatemanager.v1.DnsAuthorization parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.DnsAuthorization parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.certificatemanager.v1.DnsAuthorization parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.DnsAuthorization parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.certificatemanager.v1.DnsAuthorization parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.DnsAuthorization parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.certificatemanager.v1.DnsAuthorization parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.certificatemanager.v1.DnsAuthorization prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A DnsAuthorization resource describes a way to perform domain authorization
   * for certificate issuance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.certificatemanager.v1.DnsAuthorization}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.certificatemanager.v1.DnsAuthorization)
      com.google.cloud.certificatemanager.v1.DnsAuthorizationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.certificatemanager.v1.CertificateManagerProto
          .internal_static_google_cloud_certificatemanager_v1_DnsAuthorization_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.certificatemanager.v1.CertificateManagerProto
          .internal_static_google_cloud_certificatemanager_v1_DnsAuthorization_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.certificatemanager.v1.DnsAuthorization.class,
              com.google.cloud.certificatemanager.v1.DnsAuthorization.Builder.class);
    }

    // Construct using com.google.cloud.certificatemanager.v1.DnsAuthorization.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      description_ = "";

      domain_ = "";

      if (dnsResourceRecordBuilder_ == null) {
        dnsResourceRecord_ = null;
      } else {
        dnsResourceRecord_ = null;
        dnsResourceRecordBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.certificatemanager.v1.CertificateManagerProto
          .internal_static_google_cloud_certificatemanager_v1_DnsAuthorization_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.DnsAuthorization getDefaultInstanceForType() {
      return com.google.cloud.certificatemanager.v1.DnsAuthorization.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.DnsAuthorization build() {
      com.google.cloud.certificatemanager.v1.DnsAuthorization result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.DnsAuthorization buildPartial() {
      com.google.cloud.certificatemanager.v1.DnsAuthorization result =
          new com.google.cloud.certificatemanager.v1.DnsAuthorization(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      result.description_ = description_;
      result.domain_ = domain_;
      if (dnsResourceRecordBuilder_ == null) {
        result.dnsResourceRecord_ = dnsResourceRecord_;
      } else {
        result.dnsResourceRecord_ = dnsResourceRecordBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.certificatemanager.v1.DnsAuthorization) {
        return mergeFrom((com.google.cloud.certificatemanager.v1.DnsAuthorization) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.certificatemanager.v1.DnsAuthorization other) {
      if (other == com.google.cloud.certificatemanager.v1.DnsAuthorization.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (!other.getDomain().isEmpty()) {
        domain_ = other.domain_;
        onChanged();
      }
      if (other.hasDnsResourceRecord()) {
        mergeDnsResourceRecord(other.getDnsResourceRecord());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                break;
              } // case 34
            case 42:
              {
                description_ = input.readStringRequireUtf8();

                break;
              } // case 42
            case 50:
              {
                domain_ = input.readStringRequireUtf8();

                break;
              } // case 50
            case 82:
              {
                input.readMessage(
                    getDnsResourceRecordFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * A user-defined name of the dns authorization. DnsAuthorization names must
     * be unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;dnsAuthorizations/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the dns authorization. DnsAuthorization names must
     * be unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;dnsAuthorizations/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the dns authorization. DnsAuthorization names must
     * be unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;dnsAuthorizations/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the dns authorization. DnsAuthorization names must
     * be unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;dnsAuthorizations/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the dns authorization. DnsAuthorization names must
     * be unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;dnsAuthorizations/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a DnsAuthorization.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a DnsAuthorization.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a DnsAuthorization.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a DnsAuthorization.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a DnsAuthorization.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a DnsAuthorization.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a DnsAuthorization.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a DnsAuthorization.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a DnsAuthorization.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a DnsAuthorization.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a DnsAuthorization.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a DnsAuthorization.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a DnsAuthorization.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a DnsAuthorization.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a DnsAuthorization.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a DnsAuthorization.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a DnsAuthorization.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a DnsAuthorization.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a DnsAuthorization.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a DnsAuthorization.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a DnsAuthorization.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a DnsAuthorization.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a DnsAuthorization.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a DnsAuthorization.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a DnsAuthorization.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a DnsAuthorization.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a DnsAuthorization.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a DnsAuthorization.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a DnsAuthorization.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a DnsAuthorization.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object domain_ = "";
    /**
     *
     *
     * <pre>
     * Required. Immutable. A domain which is being authorized. A DnsAuthorization
     * resource covers a single domain and its wildcard, e.g. authorization for
     * `example.com` can be used to issue certificates for `example.com` and
     * `*.example.com`.
     * </pre>
     *
     * <code>
     * string domain = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The domain.
     */
    public java.lang.String getDomain() {
      java.lang.Object ref = domain_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        domain_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. A domain which is being authorized. A DnsAuthorization
     * resource covers a single domain and its wildcard, e.g. authorization for
     * `example.com` can be used to issue certificates for `example.com` and
     * `*.example.com`.
     * </pre>
     *
     * <code>
     * string domain = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The bytes for domain.
     */
    public com.google.protobuf.ByteString getDomainBytes() {
      java.lang.Object ref = domain_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        domain_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. A domain which is being authorized. A DnsAuthorization
     * resource covers a single domain and its wildcard, e.g. authorization for
     * `example.com` can be used to issue certificates for `example.com` and
     * `*.example.com`.
     * </pre>
     *
     * <code>
     * string domain = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The domain to set.
     * @return This builder for chaining.
     */
    public Builder setDomain(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      domain_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. A domain which is being authorized. A DnsAuthorization
     * resource covers a single domain and its wildcard, e.g. authorization for
     * `example.com` can be used to issue certificates for `example.com` and
     * `*.example.com`.
     * </pre>
     *
     * <code>
     * string domain = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDomain() {

      domain_ = getDefaultInstance().getDomain();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. A domain which is being authorized. A DnsAuthorization
     * resource covers a single domain and its wildcard, e.g. authorization for
     * `example.com` can be used to issue certificates for `example.com` and
     * `*.example.com`.
     * </pre>
     *
     * <code>
     * string domain = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes for domain to set.
     * @return This builder for chaining.
     */
    public Builder setDomainBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      domain_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
        dnsResourceRecord_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord,
            com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord.Builder,
            com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecordOrBuilder>
        dnsResourceRecordBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. DNS Resource Record that needs to be added to DNS
     * configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord dns_resource_record = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the dnsResourceRecord field is set.
     */
    public boolean hasDnsResourceRecord() {
      return dnsResourceRecordBuilder_ != null || dnsResourceRecord_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. DNS Resource Record that needs to be added to DNS
     * configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord dns_resource_record = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The dnsResourceRecord.
     */
    public com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
        getDnsResourceRecord() {
      if (dnsResourceRecordBuilder_ == null) {
        return dnsResourceRecord_ == null
            ? com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
                .getDefaultInstance()
            : dnsResourceRecord_;
      } else {
        return dnsResourceRecordBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. DNS Resource Record that needs to be added to DNS
     * configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord dns_resource_record = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDnsResourceRecord(
        com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord value) {
      if (dnsResourceRecordBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dnsResourceRecord_ = value;
        onChanged();
      } else {
        dnsResourceRecordBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. DNS Resource Record that needs to be added to DNS
     * configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord dns_resource_record = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDnsResourceRecord(
        com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord.Builder
            builderForValue) {
      if (dnsResourceRecordBuilder_ == null) {
        dnsResourceRecord_ = builderForValue.build();
        onChanged();
      } else {
        dnsResourceRecordBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. DNS Resource Record that needs to be added to DNS
     * configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord dns_resource_record = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDnsResourceRecord(
        com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord value) {
      if (dnsResourceRecordBuilder_ == null) {
        if (dnsResourceRecord_ != null) {
          dnsResourceRecord_ =
              com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord.newBuilder(
                      dnsResourceRecord_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dnsResourceRecord_ = value;
        }
        onChanged();
      } else {
        dnsResourceRecordBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. DNS Resource Record that needs to be added to DNS
     * configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord dns_resource_record = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDnsResourceRecord() {
      if (dnsResourceRecordBuilder_ == null) {
        dnsResourceRecord_ = null;
        onChanged();
      } else {
        dnsResourceRecord_ = null;
        dnsResourceRecordBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. DNS Resource Record that needs to be added to DNS
     * configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord dns_resource_record = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord.Builder
        getDnsResourceRecordBuilder() {

      onChanged();
      return getDnsResourceRecordFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. DNS Resource Record that needs to be added to DNS
     * configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord dns_resource_record = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecordOrBuilder
        getDnsResourceRecordOrBuilder() {
      if (dnsResourceRecordBuilder_ != null) {
        return dnsResourceRecordBuilder_.getMessageOrBuilder();
      } else {
        return dnsResourceRecord_ == null
            ? com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
                .getDefaultInstance()
            : dnsResourceRecord_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. DNS Resource Record that needs to be added to DNS
     * configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord dns_resource_record = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord,
            com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord.Builder,
            com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecordOrBuilder>
        getDnsResourceRecordFieldBuilder() {
      if (dnsResourceRecordBuilder_ == null) {
        dnsResourceRecordBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord,
                com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord.Builder,
                com.google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecordOrBuilder>(
                getDnsResourceRecord(), getParentForChildren(), isClean());
        dnsResourceRecord_ = null;
      }
      return dnsResourceRecordBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.certificatemanager.v1.DnsAuthorization)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.certificatemanager.v1.DnsAuthorization)
  private static final com.google.cloud.certificatemanager.v1.DnsAuthorization DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.certificatemanager.v1.DnsAuthorization();
  }

  public static com.google.cloud.certificatemanager.v1.DnsAuthorization getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DnsAuthorization> PARSER =
      new com.google.protobuf.AbstractParser<DnsAuthorization>() {
        @java.lang.Override
        public DnsAuthorization parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DnsAuthorization> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DnsAuthorization> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.certificatemanager.v1.DnsAuthorization getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
