/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/certificatemanager/v1/certificate_manager.proto

package com.google.cloud.certificatemanager.v1;

public interface CertificateOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.certificatemanager.v1.Certificate)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * A user-defined name of the certificate. Certificate names must be unique
   * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * A user-defined name of the certificate. Certificate names must be unique
   * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * One or more paragraphs of text description of a certificate.
   * </pre>
   *
   * <code>string description = 8;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();
  /**
   *
   *
   * <pre>
   * One or more paragraphs of text description of a certificate.
   * </pre>
   *
   * <code>string description = 8;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a Certificate.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a Certificate.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a Certificate.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a Certificate.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a Certificate.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a Certificate.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Set of labels associated with a Certificate.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  int getLabelsCount();
  /**
   *
   *
   * <pre>
   * Set of labels associated with a Certificate.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  boolean containsLabels(java.lang.String key);
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();
  /**
   *
   *
   * <pre>
   * Set of labels associated with a Certificate.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
  /**
   *
   *
   * <pre>
   * Set of labels associated with a Certificate.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */

  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * Set of labels associated with a Certificate.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * If set, defines data of a self-managed certificate.
   * </pre>
   *
   * <code>.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate self_managed = 5;
   * </code>
   *
   * @return Whether the selfManaged field is set.
   */
  boolean hasSelfManaged();
  /**
   *
   *
   * <pre>
   * If set, defines data of a self-managed certificate.
   * </pre>
   *
   * <code>.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate self_managed = 5;
   * </code>
   *
   * @return The selfManaged.
   */
  com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate getSelfManaged();
  /**
   *
   *
   * <pre>
   * If set, defines data of a self-managed certificate.
   * </pre>
   *
   * <code>.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate self_managed = 5;
   * </code>
   */
  com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificateOrBuilder
      getSelfManagedOrBuilder();

  /**
   *
   *
   * <pre>
   * If set, contains configuration and state of a managed certificate.
   * </pre>
   *
   * <code>.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate managed = 11;</code>
   *
   * @return Whether the managed field is set.
   */
  boolean hasManaged();
  /**
   *
   *
   * <pre>
   * If set, contains configuration and state of a managed certificate.
   * </pre>
   *
   * <code>.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate managed = 11;</code>
   *
   * @return The managed.
   */
  com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate getManaged();
  /**
   *
   *
   * <pre>
   * If set, contains configuration and state of a managed certificate.
   * </pre>
   *
   * <code>.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate managed = 11;</code>
   */
  com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificateOrBuilder
      getManagedOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The list of Subject Alternative Names of dnsName type defined
   * in the certificate (see RFC 5280 4.2.1.6). Managed certificates that
   * haven't been provisioned yet have this field populated with a value of the
   * managed.domains field.
   * </pre>
   *
   * <code>repeated string san_dnsnames = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return A list containing the sanDnsnames.
   */
  java.util.List<java.lang.String> getSanDnsnamesList();
  /**
   *
   *
   * <pre>
   * Output only. The list of Subject Alternative Names of dnsName type defined
   * in the certificate (see RFC 5280 4.2.1.6). Managed certificates that
   * haven't been provisioned yet have this field populated with a value of the
   * managed.domains field.
   * </pre>
   *
   * <code>repeated string san_dnsnames = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The count of sanDnsnames.
   */
  int getSanDnsnamesCount();
  /**
   *
   *
   * <pre>
   * Output only. The list of Subject Alternative Names of dnsName type defined
   * in the certificate (see RFC 5280 4.2.1.6). Managed certificates that
   * haven't been provisioned yet have this field populated with a value of the
   * managed.domains field.
   * </pre>
   *
   * <code>repeated string san_dnsnames = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the element to return.
   * @return The sanDnsnames at the given index.
   */
  java.lang.String getSanDnsnames(int index);
  /**
   *
   *
   * <pre>
   * Output only. The list of Subject Alternative Names of dnsName type defined
   * in the certificate (see RFC 5280 4.2.1.6). Managed certificates that
   * haven't been provisioned yet have this field populated with a value of the
   * managed.domains field.
   * </pre>
   *
   * <code>repeated string san_dnsnames = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the sanDnsnames at the given index.
   */
  com.google.protobuf.ByteString getSanDnsnamesBytes(int index);

  /**
   *
   *
   * <pre>
   * Output only. The PEM-encoded certificate chain.
   * </pre>
   *
   * <code>string pem_certificate = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The pemCertificate.
   */
  java.lang.String getPemCertificate();
  /**
   *
   *
   * <pre>
   * Output only. The PEM-encoded certificate chain.
   * </pre>
   *
   * <code>string pem_certificate = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for pemCertificate.
   */
  com.google.protobuf.ByteString getPemCertificateBytes();

  /**
   *
   *
   * <pre>
   * Output only. The expiry timestamp of a Certificate.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the expireTime field is set.
   */
  boolean hasExpireTime();
  /**
   *
   *
   * <pre>
   * Output only. The expiry timestamp of a Certificate.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The expireTime.
   */
  com.google.protobuf.Timestamp getExpireTime();
  /**
   *
   *
   * <pre>
   * Output only. The expiry timestamp of a Certificate.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Immutable. The scope of the certificate.
   * </pre>
   *
   * <code>
   * .google.cloud.certificatemanager.v1.Certificate.Scope scope = 12 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for scope.
   */
  int getScopeValue();
  /**
   *
   *
   * <pre>
   * Immutable. The scope of the certificate.
   * </pre>
   *
   * <code>
   * .google.cloud.certificatemanager.v1.Certificate.Scope scope = 12 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The scope.
   */
  com.google.cloud.certificatemanager.v1.Certificate.Scope getScope();

  public com.google.cloud.certificatemanager.v1.Certificate.TypeCase getTypeCase();
}
