/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/certificatemanager/v1/certificate_manager.proto

package com.google.cloud.certificatemanager.v1;

public interface CertificateMapEntryOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.certificatemanager.v1.CertificateMapEntry)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * A user-defined name of the Certificate Map Entry. Certificate Map Entry
   * names must be unique globally and match pattern
   * `projects/&#42;&#47;locations/&#42;&#47;certificateMaps/&#42;&#47;certificateMapEntries/&#42;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * A user-defined name of the Certificate Map Entry. Certificate Map Entry
   * names must be unique globally and match pattern
   * `projects/&#42;&#47;locations/&#42;&#47;certificateMaps/&#42;&#47;certificateMapEntries/&#42;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * One or more paragraphs of text description of a certificate map entry.
   * </pre>
   *
   * <code>string description = 9;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();
  /**
   *
   *
   * <pre>
   * One or more paragraphs of text description of a certificate map entry.
   * </pre>
   *
   * <code>string description = 9;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a Certificate Map Entry.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a Certificate Map Entry.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a Certificate Map Entry.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The update timestamp of a Certificate Map Entry.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The update timestamp of a Certificate Map Entry.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The update timestamp of a Certificate Map Entry.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Set of labels associated with a Certificate Map Entry.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  int getLabelsCount();
  /**
   *
   *
   * <pre>
   * Set of labels associated with a Certificate Map Entry.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  boolean containsLabels(java.lang.String key);
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();
  /**
   *
   *
   * <pre>
   * Set of labels associated with a Certificate Map Entry.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
  /**
   *
   *
   * <pre>
   * Set of labels associated with a Certificate Map Entry.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */

  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * Set of labels associated with a Certificate Map Entry.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * A Hostname (FQDN, e.g. `example.com`) or a wildcard hostname expression
   * (`*.example.com`) for a set of hostnames with common suffix. Used as
   * Server Name Indication (SNI) for selecting a proper certificate.
   * </pre>
   *
   * <code>string hostname = 5;</code>
   *
   * @return Whether the hostname field is set.
   */
  boolean hasHostname();
  /**
   *
   *
   * <pre>
   * A Hostname (FQDN, e.g. `example.com`) or a wildcard hostname expression
   * (`*.example.com`) for a set of hostnames with common suffix. Used as
   * Server Name Indication (SNI) for selecting a proper certificate.
   * </pre>
   *
   * <code>string hostname = 5;</code>
   *
   * @return The hostname.
   */
  java.lang.String getHostname();
  /**
   *
   *
   * <pre>
   * A Hostname (FQDN, e.g. `example.com`) or a wildcard hostname expression
   * (`*.example.com`) for a set of hostnames with common suffix. Used as
   * Server Name Indication (SNI) for selecting a proper certificate.
   * </pre>
   *
   * <code>string hostname = 5;</code>
   *
   * @return The bytes for hostname.
   */
  com.google.protobuf.ByteString getHostnameBytes();

  /**
   *
   *
   * <pre>
   * A predefined matcher for particular cases, other than SNI selection.
   * </pre>
   *
   * <code>.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher matcher = 10;</code>
   *
   * @return Whether the matcher field is set.
   */
  boolean hasMatcher();
  /**
   *
   *
   * <pre>
   * A predefined matcher for particular cases, other than SNI selection.
   * </pre>
   *
   * <code>.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher matcher = 10;</code>
   *
   * @return The enum numeric value on the wire for matcher.
   */
  int getMatcherValue();
  /**
   *
   *
   * <pre>
   * A predefined matcher for particular cases, other than SNI selection.
   * </pre>
   *
   * <code>.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher matcher = 10;</code>
   *
   * @return The matcher.
   */
  com.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher getMatcher();

  /**
   *
   *
   * <pre>
   * A set of Certificates defines for the given `hostname`. There can be
   * defined up to fifteen certificates in each Certificate Map Entry. Each
   * certificate must match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
   * </pre>
   *
   * <code>repeated string certificates = 7 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return A list containing the certificates.
   */
  java.util.List<java.lang.String> getCertificatesList();
  /**
   *
   *
   * <pre>
   * A set of Certificates defines for the given `hostname`. There can be
   * defined up to fifteen certificates in each Certificate Map Entry. Each
   * certificate must match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
   * </pre>
   *
   * <code>repeated string certificates = 7 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The count of certificates.
   */
  int getCertificatesCount();
  /**
   *
   *
   * <pre>
   * A set of Certificates defines for the given `hostname`. There can be
   * defined up to fifteen certificates in each Certificate Map Entry. Each
   * certificate must match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
   * </pre>
   *
   * <code>repeated string certificates = 7 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the element to return.
   * @return The certificates at the given index.
   */
  java.lang.String getCertificates(int index);
  /**
   *
   *
   * <pre>
   * A set of Certificates defines for the given `hostname`. There can be
   * defined up to fifteen certificates in each Certificate Map Entry. Each
   * certificate must match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
   * </pre>
   *
   * <code>repeated string certificates = 7 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the certificates at the given index.
   */
  com.google.protobuf.ByteString getCertificatesBytes(int index);

  /**
   *
   *
   * <pre>
   * Output only. A serving state of this Certificate Map Entry.
   * </pre>
   *
   * <code>
   * .google.cloud.certificatemanager.v1.ServingState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  int getStateValue();
  /**
   *
   *
   * <pre>
   * Output only. A serving state of this Certificate Map Entry.
   * </pre>
   *
   * <code>
   * .google.cloud.certificatemanager.v1.ServingState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  com.google.cloud.certificatemanager.v1.ServingState getState();

  public com.google.cloud.certificatemanager.v1.CertificateMapEntry.MatchCase getMatchCase();
}
