/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/certificatemanager/v1/certificate_manager.proto

package com.google.cloud.certificatemanager.v1;

/**
 *
 *
 * <pre>
 * Defines a certificate map entry.
 * </pre>
 *
 * Protobuf type {@code google.cloud.certificatemanager.v1.CertificateMapEntry}
 */
public final class CertificateMapEntry extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.certificatemanager.v1.CertificateMapEntry)
    CertificateMapEntryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CertificateMapEntry.newBuilder() to construct.
  private CertificateMapEntry(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CertificateMapEntry() {
    name_ = "";
    description_ = "";
    certificates_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CertificateMapEntry();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.certificatemanager.v1.CertificateManagerProto
        .internal_static_google_cloud_certificatemanager_v1_CertificateMapEntry_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.certificatemanager.v1.CertificateManagerProto
        .internal_static_google_cloud_certificatemanager_v1_CertificateMapEntry_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.certificatemanager.v1.CertificateMapEntry.class,
            com.google.cloud.certificatemanager.v1.CertificateMapEntry.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Defines predefined cases other than SNI-hostname match when this
   * configuration should be applied.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher}
   */
  public enum Matcher implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A matcher has't been recognized.
     * </pre>
     *
     * <code>MATCHER_UNSPECIFIED = 0;</code>
     */
    MATCHER_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * A primary certificate that is served when SNI wasn't specified in the
     * request or SNI couldn't be found in the map.
     * </pre>
     *
     * <code>PRIMARY = 1;</code>
     */
    PRIMARY(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A matcher has't been recognized.
     * </pre>
     *
     * <code>MATCHER_UNSPECIFIED = 0;</code>
     */
    public static final int MATCHER_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * A primary certificate that is served when SNI wasn't specified in the
     * request or SNI couldn't be found in the map.
     * </pre>
     *
     * <code>PRIMARY = 1;</code>
     */
    public static final int PRIMARY_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Matcher valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Matcher forNumber(int value) {
      switch (value) {
        case 0:
          return MATCHER_UNSPECIFIED;
        case 1:
          return PRIMARY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Matcher> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Matcher> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Matcher>() {
          public Matcher findValueByNumber(int number) {
            return Matcher.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.certificatemanager.v1.CertificateMapEntry.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Matcher[] VALUES = values();

    public static Matcher valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Matcher(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher)
  }

  private int matchCase_ = 0;
  private java.lang.Object match_;

  public enum MatchCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    HOSTNAME(5),
    MATCHER(10),
    MATCH_NOT_SET(0);
    private final int value;

    private MatchCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MatchCase valueOf(int value) {
      return forNumber(value);
    }

    public static MatchCase forNumber(int value) {
      switch (value) {
        case 5:
          return HOSTNAME;
        case 10:
          return MATCHER;
        case 0:
          return MATCH_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public MatchCase getMatchCase() {
    return MatchCase.forNumber(matchCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * A user-defined name of the Certificate Map Entry. Certificate Map Entry
   * names must be unique globally and match pattern
   * `projects/&#42;&#47;locations/&#42;&#47;certificateMaps/&#42;&#47;certificateMapEntries/&#42;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A user-defined name of the Certificate Map Entry. Certificate Map Entry
   * names must be unique globally and match pattern
   * `projects/&#42;&#47;locations/&#42;&#47;certificateMaps/&#42;&#47;certificateMapEntries/&#42;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 9;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * One or more paragraphs of text description of a certificate map entry.
   * </pre>
   *
   * <code>string description = 9;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * One or more paragraphs of text description of a certificate map entry.
   * </pre>
   *
   * <code>string description = 9;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a Certificate Map Entry.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a Certificate Map Entry.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a Certificate Map Entry.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The update timestamp of a Certificate Map Entry.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The update timestamp of a Certificate Map Entry.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The update timestamp of a Certificate Map Entry.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.certificatemanager.v1.CertificateManagerProto
                .internal_static_google_cloud_certificatemanager_v1_CertificateMapEntry_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Set of labels associated with a Certificate Map Entry.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Set of labels associated with a Certificate Map Entry.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Set of labels associated with a Certificate Map Entry.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Set of labels associated with a Certificate Map Entry.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int HOSTNAME_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * A Hostname (FQDN, e.g. `example.com`) or a wildcard hostname expression
   * (`*.example.com`) for a set of hostnames with common suffix. Used as
   * Server Name Indication (SNI) for selecting a proper certificate.
   * </pre>
   *
   * <code>string hostname = 5;</code>
   *
   * @return Whether the hostname field is set.
   */
  public boolean hasHostname() {
    return matchCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * A Hostname (FQDN, e.g. `example.com`) or a wildcard hostname expression
   * (`*.example.com`) for a set of hostnames with common suffix. Used as
   * Server Name Indication (SNI) for selecting a proper certificate.
   * </pre>
   *
   * <code>string hostname = 5;</code>
   *
   * @return The hostname.
   */
  public java.lang.String getHostname() {
    java.lang.Object ref = "";
    if (matchCase_ == 5) {
      ref = match_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (matchCase_ == 5) {
        match_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A Hostname (FQDN, e.g. `example.com`) or a wildcard hostname expression
   * (`*.example.com`) for a set of hostnames with common suffix. Used as
   * Server Name Indication (SNI) for selecting a proper certificate.
   * </pre>
   *
   * <code>string hostname = 5;</code>
   *
   * @return The bytes for hostname.
   */
  public com.google.protobuf.ByteString getHostnameBytes() {
    java.lang.Object ref = "";
    if (matchCase_ == 5) {
      ref = match_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (matchCase_ == 5) {
        match_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MATCHER_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * A predefined matcher for particular cases, other than SNI selection.
   * </pre>
   *
   * <code>.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher matcher = 10;</code>
   *
   * @return Whether the matcher field is set.
   */
  public boolean hasMatcher() {
    return matchCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * A predefined matcher for particular cases, other than SNI selection.
   * </pre>
   *
   * <code>.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher matcher = 10;</code>
   *
   * @return The enum numeric value on the wire for matcher.
   */
  public int getMatcherValue() {
    if (matchCase_ == 10) {
      return (java.lang.Integer) match_;
    }
    return 0;
  }
  /**
   *
   *
   * <pre>
   * A predefined matcher for particular cases, other than SNI selection.
   * </pre>
   *
   * <code>.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher matcher = 10;</code>
   *
   * @return The matcher.
   */
  public com.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher getMatcher() {
    if (matchCase_ == 10) {
      @SuppressWarnings("deprecation")
      com.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher result =
          com.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher.valueOf(
              (java.lang.Integer) match_);
      return result == null
          ? com.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher.UNRECOGNIZED
          : result;
    }
    return com.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher.MATCHER_UNSPECIFIED;
  }

  public static final int CERTIFICATES_FIELD_NUMBER = 7;
  private com.google.protobuf.LazyStringList certificates_;
  /**
   *
   *
   * <pre>
   * A set of Certificates defines for the given `hostname`. There can be
   * defined up to fifteen certificates in each Certificate Map Entry. Each
   * certificate must match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
   * </pre>
   *
   * <code>repeated string certificates = 7 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return A list containing the certificates.
   */
  public com.google.protobuf.ProtocolStringList getCertificatesList() {
    return certificates_;
  }
  /**
   *
   *
   * <pre>
   * A set of Certificates defines for the given `hostname`. There can be
   * defined up to fifteen certificates in each Certificate Map Entry. Each
   * certificate must match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
   * </pre>
   *
   * <code>repeated string certificates = 7 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The count of certificates.
   */
  public int getCertificatesCount() {
    return certificates_.size();
  }
  /**
   *
   *
   * <pre>
   * A set of Certificates defines for the given `hostname`. There can be
   * defined up to fifteen certificates in each Certificate Map Entry. Each
   * certificate must match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
   * </pre>
   *
   * <code>repeated string certificates = 7 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the element to return.
   * @return The certificates at the given index.
   */
  public java.lang.String getCertificates(int index) {
    return certificates_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A set of Certificates defines for the given `hostname`. There can be
   * defined up to fifteen certificates in each Certificate Map Entry. Each
   * certificate must match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
   * </pre>
   *
   * <code>repeated string certificates = 7 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the certificates at the given index.
   */
  public com.google.protobuf.ByteString getCertificatesBytes(int index) {
    return certificates_.getByteString(index);
  }

  public static final int STATE_FIELD_NUMBER = 8;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. A serving state of this Certificate Map Entry.
   * </pre>
   *
   * <code>
   * .google.cloud.certificatemanager.v1.ServingState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A serving state of this Certificate Map Entry.
   * </pre>
   *
   * <code>
   * .google.cloud.certificatemanager.v1.ServingState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.certificatemanager.v1.ServingState getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.certificatemanager.v1.ServingState result =
        com.google.cloud.certificatemanager.v1.ServingState.valueOf(state_);
    return result == null
        ? com.google.cloud.certificatemanager.v1.ServingState.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(3, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    if (matchCase_ == 5) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, match_);
    }
    for (int i = 0; i < certificates_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, certificates_.getRaw(i));
    }
    if (state_
        != com.google.cloud.certificatemanager.v1.ServingState.SERVING_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(8, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, description_);
    }
    if (matchCase_ == 10) {
      output.writeEnum(10, ((java.lang.Integer) match_));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    if (matchCase_ == 5) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, match_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < certificates_.size(); i++) {
        dataSize += computeStringSizeNoTag(certificates_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getCertificatesList().size();
    }
    if (state_
        != com.google.cloud.certificatemanager.v1.ServingState.SERVING_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, description_);
    }
    if (matchCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(10, ((java.lang.Integer) match_));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.certificatemanager.v1.CertificateMapEntry)) {
      return super.equals(obj);
    }
    com.google.cloud.certificatemanager.v1.CertificateMapEntry other =
        (com.google.cloud.certificatemanager.v1.CertificateMapEntry) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getCertificatesList().equals(other.getCertificatesList())) return false;
    if (state_ != other.state_) return false;
    if (!getMatchCase().equals(other.getMatchCase())) return false;
    switch (matchCase_) {
      case 5:
        if (!getHostname().equals(other.getHostname())) return false;
        break;
      case 10:
        if (getMatcherValue() != other.getMatcherValue()) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getCertificatesCount() > 0) {
      hash = (37 * hash) + CERTIFICATES_FIELD_NUMBER;
      hash = (53 * hash) + getCertificatesList().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    switch (matchCase_) {
      case 5:
        hash = (37 * hash) + HOSTNAME_FIELD_NUMBER;
        hash = (53 * hash) + getHostname().hashCode();
        break;
      case 10:
        hash = (37 * hash) + MATCHER_FIELD_NUMBER;
        hash = (53 * hash) + getMatcherValue();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMapEntry parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMapEntry parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMapEntry parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMapEntry parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMapEntry parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMapEntry parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMapEntry parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMapEntry parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMapEntry parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMapEntry parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMapEntry parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMapEntry parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.certificatemanager.v1.CertificateMapEntry prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Defines a certificate map entry.
   * </pre>
   *
   * Protobuf type {@code google.cloud.certificatemanager.v1.CertificateMapEntry}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.certificatemanager.v1.CertificateMapEntry)
      com.google.cloud.certificatemanager.v1.CertificateMapEntryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.certificatemanager.v1.CertificateManagerProto
          .internal_static_google_cloud_certificatemanager_v1_CertificateMapEntry_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.certificatemanager.v1.CertificateManagerProto
          .internal_static_google_cloud_certificatemanager_v1_CertificateMapEntry_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.certificatemanager.v1.CertificateMapEntry.class,
              com.google.cloud.certificatemanager.v1.CertificateMapEntry.Builder.class);
    }

    // Construct using com.google.cloud.certificatemanager.v1.CertificateMapEntry.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      description_ = "";

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      certificates_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      state_ = 0;

      matchCase_ = 0;
      match_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.certificatemanager.v1.CertificateManagerProto
          .internal_static_google_cloud_certificatemanager_v1_CertificateMapEntry_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.CertificateMapEntry getDefaultInstanceForType() {
      return com.google.cloud.certificatemanager.v1.CertificateMapEntry.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.CertificateMapEntry build() {
      com.google.cloud.certificatemanager.v1.CertificateMapEntry result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.CertificateMapEntry buildPartial() {
      com.google.cloud.certificatemanager.v1.CertificateMapEntry result =
          new com.google.cloud.certificatemanager.v1.CertificateMapEntry(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.description_ = description_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      if (matchCase_ == 5) {
        result.match_ = match_;
      }
      if (matchCase_ == 10) {
        result.match_ = match_;
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        certificates_ = certificates_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.certificates_ = certificates_;
      result.state_ = state_;
      result.matchCase_ = matchCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.certificatemanager.v1.CertificateMapEntry) {
        return mergeFrom((com.google.cloud.certificatemanager.v1.CertificateMapEntry) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.certificatemanager.v1.CertificateMapEntry other) {
      if (other == com.google.cloud.certificatemanager.v1.CertificateMapEntry.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (!other.certificates_.isEmpty()) {
        if (certificates_.isEmpty()) {
          certificates_ = other.certificates_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureCertificatesIsMutable();
          certificates_.addAll(other.certificates_);
        }
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      switch (other.getMatchCase()) {
        case HOSTNAME:
          {
            matchCase_ = 5;
            match_ = other.match_;
            onChanged();
            break;
          }
        case MATCHER:
          {
            setMatcherValue(other.getMatcherValue());
            break;
          }
        case MATCH_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                matchCase_ = 5;
                match_ = s;
                break;
              } // case 42
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureCertificatesIsMutable();
                certificates_.add(s);
                break;
              } // case 58
            case 64:
              {
                state_ = input.readEnum();

                break;
              } // case 64
            case 74:
              {
                description_ = input.readStringRequireUtf8();

                break;
              } // case 74
            case 80:
              {
                int rawValue = input.readEnum();
                matchCase_ = 10;
                match_ = rawValue;
                break;
              } // case 80
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int matchCase_ = 0;
    private java.lang.Object match_;

    public MatchCase getMatchCase() {
      return MatchCase.forNumber(matchCase_);
    }

    public Builder clearMatch() {
      matchCase_ = 0;
      match_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * A user-defined name of the Certificate Map Entry. Certificate Map Entry
     * names must be unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;certificateMaps/&#42;&#47;certificateMapEntries/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the Certificate Map Entry. Certificate Map Entry
     * names must be unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;certificateMaps/&#42;&#47;certificateMapEntries/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the Certificate Map Entry. Certificate Map Entry
     * names must be unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;certificateMaps/&#42;&#47;certificateMapEntries/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the Certificate Map Entry. Certificate Map Entry
     * names must be unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;certificateMaps/&#42;&#47;certificateMapEntries/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the Certificate Map Entry. Certificate Map Entry
     * names must be unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;certificateMaps/&#42;&#47;certificateMapEntries/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a certificate map entry.
     * </pre>
     *
     * <code>string description = 9;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a certificate map entry.
     * </pre>
     *
     * <code>string description = 9;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a certificate map entry.
     * </pre>
     *
     * <code>string description = 9;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a certificate map entry.
     * </pre>
     *
     * <code>string description = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a certificate map entry.
     * </pre>
     *
     * <code>string description = 9;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate Map Entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate Map Entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate Map Entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate Map Entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate Map Entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate Map Entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate Map Entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate Map Entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate Map Entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The update timestamp of a Certificate Map Entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The update timestamp of a Certificate Map Entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The update timestamp of a Certificate Map Entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The update timestamp of a Certificate Map Entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The update timestamp of a Certificate Map Entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The update timestamp of a Certificate Map Entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The update timestamp of a Certificate Map Entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The update timestamp of a Certificate Map Entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The update timestamp of a Certificate Map Entry.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a Certificate Map Entry.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a Certificate Map Entry.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a Certificate Map Entry.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a Certificate Map Entry.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a Certificate Map Entry.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a Certificate Map Entry.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a Certificate Map Entry.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    /**
     *
     *
     * <pre>
     * A Hostname (FQDN, e.g. `example.com`) or a wildcard hostname expression
     * (`*.example.com`) for a set of hostnames with common suffix. Used as
     * Server Name Indication (SNI) for selecting a proper certificate.
     * </pre>
     *
     * <code>string hostname = 5;</code>
     *
     * @return Whether the hostname field is set.
     */
    @java.lang.Override
    public boolean hasHostname() {
      return matchCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * A Hostname (FQDN, e.g. `example.com`) or a wildcard hostname expression
     * (`*.example.com`) for a set of hostnames with common suffix. Used as
     * Server Name Indication (SNI) for selecting a proper certificate.
     * </pre>
     *
     * <code>string hostname = 5;</code>
     *
     * @return The hostname.
     */
    @java.lang.Override
    public java.lang.String getHostname() {
      java.lang.Object ref = "";
      if (matchCase_ == 5) {
        ref = match_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (matchCase_ == 5) {
          match_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A Hostname (FQDN, e.g. `example.com`) or a wildcard hostname expression
     * (`*.example.com`) for a set of hostnames with common suffix. Used as
     * Server Name Indication (SNI) for selecting a proper certificate.
     * </pre>
     *
     * <code>string hostname = 5;</code>
     *
     * @return The bytes for hostname.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getHostnameBytes() {
      java.lang.Object ref = "";
      if (matchCase_ == 5) {
        ref = match_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (matchCase_ == 5) {
          match_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A Hostname (FQDN, e.g. `example.com`) or a wildcard hostname expression
     * (`*.example.com`) for a set of hostnames with common suffix. Used as
     * Server Name Indication (SNI) for selecting a proper certificate.
     * </pre>
     *
     * <code>string hostname = 5;</code>
     *
     * @param value The hostname to set.
     * @return This builder for chaining.
     */
    public Builder setHostname(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      matchCase_ = 5;
      match_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Hostname (FQDN, e.g. `example.com`) or a wildcard hostname expression
     * (`*.example.com`) for a set of hostnames with common suffix. Used as
     * Server Name Indication (SNI) for selecting a proper certificate.
     * </pre>
     *
     * <code>string hostname = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHostname() {
      if (matchCase_ == 5) {
        matchCase_ = 0;
        match_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Hostname (FQDN, e.g. `example.com`) or a wildcard hostname expression
     * (`*.example.com`) for a set of hostnames with common suffix. Used as
     * Server Name Indication (SNI) for selecting a proper certificate.
     * </pre>
     *
     * <code>string hostname = 5;</code>
     *
     * @param value The bytes for hostname to set.
     * @return This builder for chaining.
     */
    public Builder setHostnameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      matchCase_ = 5;
      match_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A predefined matcher for particular cases, other than SNI selection.
     * </pre>
     *
     * <code>.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher matcher = 10;</code>
     *
     * @return Whether the matcher field is set.
     */
    @java.lang.Override
    public boolean hasMatcher() {
      return matchCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * A predefined matcher for particular cases, other than SNI selection.
     * </pre>
     *
     * <code>.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher matcher = 10;</code>
     *
     * @return The enum numeric value on the wire for matcher.
     */
    @java.lang.Override
    public int getMatcherValue() {
      if (matchCase_ == 10) {
        return ((java.lang.Integer) match_).intValue();
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * A predefined matcher for particular cases, other than SNI selection.
     * </pre>
     *
     * <code>.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher matcher = 10;</code>
     *
     * @param value The enum numeric value on the wire for matcher to set.
     * @return This builder for chaining.
     */
    public Builder setMatcherValue(int value) {
      matchCase_ = 10;
      match_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A predefined matcher for particular cases, other than SNI selection.
     * </pre>
     *
     * <code>.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher matcher = 10;</code>
     *
     * @return The matcher.
     */
    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher getMatcher() {
      if (matchCase_ == 10) {
        @SuppressWarnings("deprecation")
        com.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher result =
            com.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher.valueOf(
                (java.lang.Integer) match_);
        return result == null
            ? com.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher.UNRECOGNIZED
            : result;
      }
      return com.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher.MATCHER_UNSPECIFIED;
    }
    /**
     *
     *
     * <pre>
     * A predefined matcher for particular cases, other than SNI selection.
     * </pre>
     *
     * <code>.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher matcher = 10;</code>
     *
     * @param value The matcher to set.
     * @return This builder for chaining.
     */
    public Builder setMatcher(
        com.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher value) {
      if (value == null) {
        throw new NullPointerException();
      }
      matchCase_ = 10;
      match_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A predefined matcher for particular cases, other than SNI selection.
     * </pre>
     *
     * <code>.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher matcher = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMatcher() {
      if (matchCase_ == 10) {
        matchCase_ = 0;
        match_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.LazyStringList certificates_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureCertificatesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        certificates_ = new com.google.protobuf.LazyStringArrayList(certificates_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * A set of Certificates defines for the given `hostname`. There can be
     * defined up to fifteen certificates in each Certificate Map Entry. Each
     * certificate must match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
     * </pre>
     *
     * <code>repeated string certificates = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return A list containing the certificates.
     */
    public com.google.protobuf.ProtocolStringList getCertificatesList() {
      return certificates_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * A set of Certificates defines for the given `hostname`. There can be
     * defined up to fifteen certificates in each Certificate Map Entry. Each
     * certificate must match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
     * </pre>
     *
     * <code>repeated string certificates = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The count of certificates.
     */
    public int getCertificatesCount() {
      return certificates_.size();
    }
    /**
     *
     *
     * <pre>
     * A set of Certificates defines for the given `hostname`. There can be
     * defined up to fifteen certificates in each Certificate Map Entry. Each
     * certificate must match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
     * </pre>
     *
     * <code>repeated string certificates = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the element to return.
     * @return The certificates at the given index.
     */
    public java.lang.String getCertificates(int index) {
      return certificates_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A set of Certificates defines for the given `hostname`. There can be
     * defined up to fifteen certificates in each Certificate Map Entry. Each
     * certificate must match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
     * </pre>
     *
     * <code>repeated string certificates = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the certificates at the given index.
     */
    public com.google.protobuf.ByteString getCertificatesBytes(int index) {
      return certificates_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A set of Certificates defines for the given `hostname`. There can be
     * defined up to fifteen certificates in each Certificate Map Entry. Each
     * certificate must match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
     * </pre>
     *
     * <code>repeated string certificates = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index to set the value at.
     * @param value The certificates to set.
     * @return This builder for chaining.
     */
    public Builder setCertificates(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCertificatesIsMutable();
      certificates_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of Certificates defines for the given `hostname`. There can be
     * defined up to fifteen certificates in each Certificate Map Entry. Each
     * certificate must match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
     * </pre>
     *
     * <code>repeated string certificates = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The certificates to add.
     * @return This builder for chaining.
     */
    public Builder addCertificates(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCertificatesIsMutable();
      certificates_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of Certificates defines for the given `hostname`. There can be
     * defined up to fifteen certificates in each Certificate Map Entry. Each
     * certificate must match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
     * </pre>
     *
     * <code>repeated string certificates = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param values The certificates to add.
     * @return This builder for chaining.
     */
    public Builder addAllCertificates(java.lang.Iterable<java.lang.String> values) {
      ensureCertificatesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, certificates_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of Certificates defines for the given `hostname`. There can be
     * defined up to fifteen certificates in each Certificate Map Entry. Each
     * certificate must match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
     * </pre>
     *
     * <code>repeated string certificates = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCertificates() {
      certificates_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of Certificates defines for the given `hostname`. There can be
     * defined up to fifteen certificates in each Certificate Map Entry. Each
     * certificate must match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
     * </pre>
     *
     * <code>repeated string certificates = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes of the certificates to add.
     * @return This builder for chaining.
     */
    public Builder addCertificatesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCertificatesIsMutable();
      certificates_.add(value);
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. A serving state of this Certificate Map Entry.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.ServingState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. A serving state of this Certificate Map Entry.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.ServingState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A serving state of this Certificate Map Entry.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.ServingState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.ServingState getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.certificatemanager.v1.ServingState result =
          com.google.cloud.certificatemanager.v1.ServingState.valueOf(state_);
      return result == null
          ? com.google.cloud.certificatemanager.v1.ServingState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. A serving state of this Certificate Map Entry.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.ServingState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.certificatemanager.v1.ServingState value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A serving state of this Certificate Map Entry.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.ServingState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.certificatemanager.v1.CertificateMapEntry)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.certificatemanager.v1.CertificateMapEntry)
  private static final com.google.cloud.certificatemanager.v1.CertificateMapEntry DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.certificatemanager.v1.CertificateMapEntry();
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMapEntry getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CertificateMapEntry> PARSER =
      new com.google.protobuf.AbstractParser<CertificateMapEntry>() {
        @java.lang.Override
        public CertificateMapEntry parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CertificateMapEntry> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CertificateMapEntry> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.certificatemanager.v1.CertificateMapEntry getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
