/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/certificatemanager/v1/certificate_manager.proto

package com.google.cloud.certificatemanager.v1;

/**
 *
 *
 * <pre>
 * Defines a collection of certificate configurations.
 * </pre>
 *
 * Protobuf type {@code google.cloud.certificatemanager.v1.CertificateMap}
 */
public final class CertificateMap extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.certificatemanager.v1.CertificateMap)
    CertificateMapOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CertificateMap.newBuilder() to construct.
  private CertificateMap(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CertificateMap() {
    name_ = "";
    description_ = "";
    gclbTargets_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CertificateMap();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.certificatemanager.v1.CertificateManagerProto
        .internal_static_google_cloud_certificatemanager_v1_CertificateMap_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 3:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.certificatemanager.v1.CertificateManagerProto
        .internal_static_google_cloud_certificatemanager_v1_CertificateMap_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.certificatemanager.v1.CertificateMap.class,
            com.google.cloud.certificatemanager.v1.CertificateMap.Builder.class);
  }

  public interface GclbTargetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.certificatemanager.v1.CertificateMap.GclbTarget)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. This field returns the resource name in the following
     * format:
     * `//compute.googleapis.com/projects/&#42;&#47;global/targetHttpsProxies/&#42;`.
     * </pre>
     *
     * <code>string target_https_proxy = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the targetHttpsProxy field is set.
     */
    boolean hasTargetHttpsProxy();
    /**
     *
     *
     * <pre>
     * Output only. This field returns the resource name in the following
     * format:
     * `//compute.googleapis.com/projects/&#42;&#47;global/targetHttpsProxies/&#42;`.
     * </pre>
     *
     * <code>string target_https_proxy = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The targetHttpsProxy.
     */
    java.lang.String getTargetHttpsProxy();
    /**
     *
     *
     * <pre>
     * Output only. This field returns the resource name in the following
     * format:
     * `//compute.googleapis.com/projects/&#42;&#47;global/targetHttpsProxies/&#42;`.
     * </pre>
     *
     * <code>string target_https_proxy = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for targetHttpsProxy.
     */
    com.google.protobuf.ByteString getTargetHttpsProxyBytes();

    /**
     *
     *
     * <pre>
     * Output only. This field returns the resource name in the following
     * format:
     * `//compute.googleapis.com/projects/&#42;&#47;global/targetSslProxies/&#42;`.
     * </pre>
     *
     * <code>string target_ssl_proxy = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the targetSslProxy field is set.
     */
    boolean hasTargetSslProxy();
    /**
     *
     *
     * <pre>
     * Output only. This field returns the resource name in the following
     * format:
     * `//compute.googleapis.com/projects/&#42;&#47;global/targetSslProxies/&#42;`.
     * </pre>
     *
     * <code>string target_ssl_proxy = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The targetSslProxy.
     */
    java.lang.String getTargetSslProxy();
    /**
     *
     *
     * <pre>
     * Output only. This field returns the resource name in the following
     * format:
     * `//compute.googleapis.com/projects/&#42;&#47;global/targetSslProxies/&#42;`.
     * </pre>
     *
     * <code>string target_ssl_proxy = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for targetSslProxy.
     */
    com.google.protobuf.ByteString getTargetSslProxyBytes();

    /**
     *
     *
     * <pre>
     * Output only. IP configurations for this Target Proxy where the
     * Certificate Map is serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig>
        getIpConfigsList();
    /**
     *
     *
     * <pre>
     * Output only. IP configurations for this Target Proxy where the
     * Certificate Map is serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig getIpConfigs(
        int index);
    /**
     *
     *
     * <pre>
     * Output only. IP configurations for this Target Proxy where the
     * Certificate Map is serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    int getIpConfigsCount();
    /**
     *
     *
     * <pre>
     * Output only. IP configurations for this Target Proxy where the
     * Certificate Map is serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfigOrBuilder>
        getIpConfigsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Output only. IP configurations for this Target Proxy where the
     * Certificate Map is serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfigOrBuilder
        getIpConfigsOrBuilder(int index);

    public com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.TargetProxyCase
        getTargetProxyCase();
  }
  /**
   *
   *
   * <pre>
   * Describes a Target Proxy which uses this Certificate Map.
   * </pre>
   *
   * Protobuf type {@code google.cloud.certificatemanager.v1.CertificateMap.GclbTarget}
   */
  public static final class GclbTarget extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.certificatemanager.v1.CertificateMap.GclbTarget)
      GclbTargetOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GclbTarget.newBuilder() to construct.
    private GclbTarget(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GclbTarget() {
      ipConfigs_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GclbTarget();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.certificatemanager.v1.CertificateManagerProto
          .internal_static_google_cloud_certificatemanager_v1_CertificateMap_GclbTarget_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.certificatemanager.v1.CertificateManagerProto
          .internal_static_google_cloud_certificatemanager_v1_CertificateMap_GclbTarget_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.class,
              com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.Builder.class);
    }

    public interface IpConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Output only. An external IP address.
       * </pre>
       *
       * <code>string ip_address = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The ipAddress.
       */
      java.lang.String getIpAddress();
      /**
       *
       *
       * <pre>
       * Output only. An external IP address.
       * </pre>
       *
       * <code>string ip_address = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for ipAddress.
       */
      com.google.protobuf.ByteString getIpAddressBytes();

      /**
       *
       *
       * <pre>
       * Output only. Ports.
       * </pre>
       *
       * <code>repeated uint32 ports = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return A list containing the ports.
       */
      java.util.List<java.lang.Integer> getPortsList();
      /**
       *
       *
       * <pre>
       * Output only. Ports.
       * </pre>
       *
       * <code>repeated uint32 ports = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The count of ports.
       */
      int getPortsCount();
      /**
       *
       *
       * <pre>
       * Output only. Ports.
       * </pre>
       *
       * <code>repeated uint32 ports = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param index The index of the element to return.
       * @return The ports at the given index.
       */
      int getPorts(int index);
    }
    /**
     *
     *
     * <pre>
     * Defines IP configuration where this Certificate Map is serving.
     * </pre>
     *
     * Protobuf type {@code google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig}
     */
    public static final class IpConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig)
        IpConfigOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use IpConfig.newBuilder() to construct.
      private IpConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private IpConfig() {
        ipAddress_ = "";
        ports_ = emptyIntList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new IpConfig();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.certificatemanager.v1.CertificateManagerProto
            .internal_static_google_cloud_certificatemanager_v1_CertificateMap_GclbTarget_IpConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.certificatemanager.v1.CertificateManagerProto
            .internal_static_google_cloud_certificatemanager_v1_CertificateMap_GclbTarget_IpConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig.class,
                com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig.Builder
                    .class);
      }

      public static final int IP_ADDRESS_FIELD_NUMBER = 1;
      private volatile java.lang.Object ipAddress_;
      /**
       *
       *
       * <pre>
       * Output only. An external IP address.
       * </pre>
       *
       * <code>string ip_address = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The ipAddress.
       */
      @java.lang.Override
      public java.lang.String getIpAddress() {
        java.lang.Object ref = ipAddress_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ipAddress_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. An external IP address.
       * </pre>
       *
       * <code>string ip_address = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for ipAddress.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getIpAddressBytes() {
        java.lang.Object ref = ipAddress_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          ipAddress_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int PORTS_FIELD_NUMBER = 3;
      private com.google.protobuf.Internal.IntList ports_;
      /**
       *
       *
       * <pre>
       * Output only. Ports.
       * </pre>
       *
       * <code>repeated uint32 ports = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return A list containing the ports.
       */
      @java.lang.Override
      public java.util.List<java.lang.Integer> getPortsList() {
        return ports_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Ports.
       * </pre>
       *
       * <code>repeated uint32 ports = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The count of ports.
       */
      public int getPortsCount() {
        return ports_.size();
      }
      /**
       *
       *
       * <pre>
       * Output only. Ports.
       * </pre>
       *
       * <code>repeated uint32 ports = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param index The index of the element to return.
       * @return The ports at the given index.
       */
      public int getPorts(int index) {
        return ports_.getInt(index);
      }

      private int portsMemoizedSerializedSize = -1;

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getSerializedSize();
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ipAddress_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, ipAddress_);
        }
        if (getPortsList().size() > 0) {
          output.writeUInt32NoTag(26);
          output.writeUInt32NoTag(portsMemoizedSerializedSize);
        }
        for (int i = 0; i < ports_.size(); i++) {
          output.writeUInt32NoTag(ports_.getInt(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ipAddress_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, ipAddress_);
        }
        {
          int dataSize = 0;
          for (int i = 0; i < ports_.size(); i++) {
            dataSize +=
                com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(ports_.getInt(i));
          }
          size += dataSize;
          if (!getPortsList().isEmpty()) {
            size += 1;
            size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
          }
          portsMemoizedSerializedSize = dataSize;
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig other =
            (com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig) obj;

        if (!getIpAddress().equals(other.getIpAddress())) return false;
        if (!getPortsList().equals(other.getPortsList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + IP_ADDRESS_FIELD_NUMBER;
        hash = (53 * hash) + getIpAddress().hashCode();
        if (getPortsCount() > 0) {
          hash = (37 * hash) + PORTS_FIELD_NUMBER;
          hash = (53 * hash) + getPortsList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Defines IP configuration where this Certificate Map is serving.
       * </pre>
       *
       * Protobuf type {@code google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig)
          com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.certificatemanager.v1.CertificateManagerProto
              .internal_static_google_cloud_certificatemanager_v1_CertificateMap_GclbTarget_IpConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.certificatemanager.v1.CertificateManagerProto
              .internal_static_google_cloud_certificatemanager_v1_CertificateMap_GclbTarget_IpConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig.class,
                  com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          ipAddress_ = "";

          ports_ = emptyIntList();
          bitField0_ = (bitField0_ & ~0x00000001);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.certificatemanager.v1.CertificateManagerProto
              .internal_static_google_cloud_certificatemanager_v1_CertificateMap_GclbTarget_IpConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig
            getDefaultInstanceForType() {
          return com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig build() {
          com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig
            buildPartial() {
          com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig result =
              new com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig(this);
          int from_bitField0_ = bitField0_;
          result.ipAddress_ = ipAddress_;
          if (((bitField0_ & 0x00000001) != 0)) {
            ports_.makeImmutable();
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.ports_ = ports_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig) {
            return mergeFrom(
                (com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig other) {
          if (other
              == com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig
                  .getDefaultInstance()) return this;
          if (!other.getIpAddress().isEmpty()) {
            ipAddress_ = other.ipAddress_;
            onChanged();
          }
          if (!other.ports_.isEmpty()) {
            if (ports_.isEmpty()) {
              ports_ = other.ports_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensurePortsIsMutable();
              ports_.addAll(other.ports_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    ipAddress_ = input.readStringRequireUtf8();

                    break;
                  } // case 10
                case 24:
                  {
                    int v = input.readUInt32();
                    ensurePortsIsMutable();
                    ports_.addInt(v);
                    break;
                  } // case 24
                case 26:
                  {
                    int length = input.readRawVarint32();
                    int limit = input.pushLimit(length);
                    ensurePortsIsMutable();
                    while (input.getBytesUntilLimit() > 0) {
                      ports_.addInt(input.readUInt32());
                    }
                    input.popLimit(limit);
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object ipAddress_ = "";
        /**
         *
         *
         * <pre>
         * Output only. An external IP address.
         * </pre>
         *
         * <code>string ip_address = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @return The ipAddress.
         */
        public java.lang.String getIpAddress() {
          java.lang.Object ref = ipAddress_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            ipAddress_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Output only. An external IP address.
         * </pre>
         *
         * <code>string ip_address = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @return The bytes for ipAddress.
         */
        public com.google.protobuf.ByteString getIpAddressBytes() {
          java.lang.Object ref = ipAddress_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            ipAddress_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Output only. An external IP address.
         * </pre>
         *
         * <code>string ip_address = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @param value The ipAddress to set.
         * @return This builder for chaining.
         */
        public Builder setIpAddress(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          ipAddress_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. An external IP address.
         * </pre>
         *
         * <code>string ip_address = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearIpAddress() {

          ipAddress_ = getDefaultInstance().getIpAddress();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. An external IP address.
         * </pre>
         *
         * <code>string ip_address = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @param value The bytes for ipAddress to set.
         * @return This builder for chaining.
         */
        public Builder setIpAddressBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          ipAddress_ = value;
          onChanged();
          return this;
        }

        private com.google.protobuf.Internal.IntList ports_ = emptyIntList();

        private void ensurePortsIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            ports_ = mutableCopy(ports_);
            bitField0_ |= 0x00000001;
          }
        }
        /**
         *
         *
         * <pre>
         * Output only. Ports.
         * </pre>
         *
         * <code>repeated uint32 ports = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @return A list containing the ports.
         */
        public java.util.List<java.lang.Integer> getPortsList() {
          return ((bitField0_ & 0x00000001) != 0)
              ? java.util.Collections.unmodifiableList(ports_)
              : ports_;
        }
        /**
         *
         *
         * <pre>
         * Output only. Ports.
         * </pre>
         *
         * <code>repeated uint32 ports = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @return The count of ports.
         */
        public int getPortsCount() {
          return ports_.size();
        }
        /**
         *
         *
         * <pre>
         * Output only. Ports.
         * </pre>
         *
         * <code>repeated uint32 ports = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @param index The index of the element to return.
         * @return The ports at the given index.
         */
        public int getPorts(int index) {
          return ports_.getInt(index);
        }
        /**
         *
         *
         * <pre>
         * Output only. Ports.
         * </pre>
         *
         * <code>repeated uint32 ports = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @param index The index to set the value at.
         * @param value The ports to set.
         * @return This builder for chaining.
         */
        public Builder setPorts(int index, int value) {
          ensurePortsIsMutable();
          ports_.setInt(index, value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Ports.
         * </pre>
         *
         * <code>repeated uint32 ports = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @param value The ports to add.
         * @return This builder for chaining.
         */
        public Builder addPorts(int value) {
          ensurePortsIsMutable();
          ports_.addInt(value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Ports.
         * </pre>
         *
         * <code>repeated uint32 ports = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @param values The ports to add.
         * @return This builder for chaining.
         */
        public Builder addAllPorts(java.lang.Iterable<? extends java.lang.Integer> values) {
          ensurePortsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ports_);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Ports.
         * </pre>
         *
         * <code>repeated uint32 ports = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPorts() {
          ports_ = emptyIntList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig)
      private static final com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig();
      }

      public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<IpConfig> PARSER =
          new com.google.protobuf.AbstractParser<IpConfig>() {
            @java.lang.Override
            public IpConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<IpConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<IpConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int targetProxyCase_ = 0;
    private java.lang.Object targetProxy_;

    public enum TargetProxyCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      TARGET_HTTPS_PROXY(1),
      TARGET_SSL_PROXY(3),
      TARGETPROXY_NOT_SET(0);
      private final int value;

      private TargetProxyCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static TargetProxyCase valueOf(int value) {
        return forNumber(value);
      }

      public static TargetProxyCase forNumber(int value) {
        switch (value) {
          case 1:
            return TARGET_HTTPS_PROXY;
          case 3:
            return TARGET_SSL_PROXY;
          case 0:
            return TARGETPROXY_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public TargetProxyCase getTargetProxyCase() {
      return TargetProxyCase.forNumber(targetProxyCase_);
    }

    public static final int TARGET_HTTPS_PROXY_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Output only. This field returns the resource name in the following
     * format:
     * `//compute.googleapis.com/projects/&#42;&#47;global/targetHttpsProxies/&#42;`.
     * </pre>
     *
     * <code>string target_https_proxy = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the targetHttpsProxy field is set.
     */
    public boolean hasTargetHttpsProxy() {
      return targetProxyCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Output only. This field returns the resource name in the following
     * format:
     * `//compute.googleapis.com/projects/&#42;&#47;global/targetHttpsProxies/&#42;`.
     * </pre>
     *
     * <code>string target_https_proxy = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The targetHttpsProxy.
     */
    public java.lang.String getTargetHttpsProxy() {
      java.lang.Object ref = "";
      if (targetProxyCase_ == 1) {
        ref = targetProxy_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (targetProxyCase_ == 1) {
          targetProxy_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This field returns the resource name in the following
     * format:
     * `//compute.googleapis.com/projects/&#42;&#47;global/targetHttpsProxies/&#42;`.
     * </pre>
     *
     * <code>string target_https_proxy = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for targetHttpsProxy.
     */
    public com.google.protobuf.ByteString getTargetHttpsProxyBytes() {
      java.lang.Object ref = "";
      if (targetProxyCase_ == 1) {
        ref = targetProxy_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (targetProxyCase_ == 1) {
          targetProxy_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TARGET_SSL_PROXY_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * Output only. This field returns the resource name in the following
     * format:
     * `//compute.googleapis.com/projects/&#42;&#47;global/targetSslProxies/&#42;`.
     * </pre>
     *
     * <code>string target_ssl_proxy = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the targetSslProxy field is set.
     */
    public boolean hasTargetSslProxy() {
      return targetProxyCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Output only. This field returns the resource name in the following
     * format:
     * `//compute.googleapis.com/projects/&#42;&#47;global/targetSslProxies/&#42;`.
     * </pre>
     *
     * <code>string target_ssl_proxy = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The targetSslProxy.
     */
    public java.lang.String getTargetSslProxy() {
      java.lang.Object ref = "";
      if (targetProxyCase_ == 3) {
        ref = targetProxy_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (targetProxyCase_ == 3) {
          targetProxy_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This field returns the resource name in the following
     * format:
     * `//compute.googleapis.com/projects/&#42;&#47;global/targetSslProxies/&#42;`.
     * </pre>
     *
     * <code>string target_ssl_proxy = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for targetSslProxy.
     */
    public com.google.protobuf.ByteString getTargetSslProxyBytes() {
      java.lang.Object ref = "";
      if (targetProxyCase_ == 3) {
        ref = targetProxy_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (targetProxyCase_ == 3) {
          targetProxy_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int IP_CONFIGS_FIELD_NUMBER = 2;
    private java.util.List<
            com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig>
        ipConfigs_;
    /**
     *
     *
     * <pre>
     * Output only. IP configurations for this Target Proxy where the
     * Certificate Map is serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig>
        getIpConfigsList() {
      return ipConfigs_;
    }
    /**
     *
     *
     * <pre>
     * Output only. IP configurations for this Target Proxy where the
     * Certificate Map is serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfigOrBuilder>
        getIpConfigsOrBuilderList() {
      return ipConfigs_;
    }
    /**
     *
     *
     * <pre>
     * Output only. IP configurations for this Target Proxy where the
     * Certificate Map is serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public int getIpConfigsCount() {
      return ipConfigs_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. IP configurations for this Target Proxy where the
     * Certificate Map is serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig getIpConfigs(
        int index) {
      return ipConfigs_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. IP configurations for this Target Proxy where the
     * Certificate Map is serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfigOrBuilder
        getIpConfigsOrBuilder(int index) {
      return ipConfigs_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (targetProxyCase_ == 1) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, targetProxy_);
      }
      for (int i = 0; i < ipConfigs_.size(); i++) {
        output.writeMessage(2, ipConfigs_.get(i));
      }
      if (targetProxyCase_ == 3) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, targetProxy_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (targetProxyCase_ == 1) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, targetProxy_);
      }
      for (int i = 0; i < ipConfigs_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, ipConfigs_.get(i));
      }
      if (targetProxyCase_ == 3) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, targetProxy_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget)) {
        return super.equals(obj);
      }
      com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget other =
          (com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget) obj;

      if (!getIpConfigsList().equals(other.getIpConfigsList())) return false;
      if (!getTargetProxyCase().equals(other.getTargetProxyCase())) return false;
      switch (targetProxyCase_) {
        case 1:
          if (!getTargetHttpsProxy().equals(other.getTargetHttpsProxy())) return false;
          break;
        case 3:
          if (!getTargetSslProxy().equals(other.getTargetSslProxy())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getIpConfigsCount() > 0) {
        hash = (37 * hash) + IP_CONFIGS_FIELD_NUMBER;
        hash = (53 * hash) + getIpConfigsList().hashCode();
      }
      switch (targetProxyCase_) {
        case 1:
          hash = (37 * hash) + TARGET_HTTPS_PROXY_FIELD_NUMBER;
          hash = (53 * hash) + getTargetHttpsProxy().hashCode();
          break;
        case 3:
          hash = (37 * hash) + TARGET_SSL_PROXY_FIELD_NUMBER;
          hash = (53 * hash) + getTargetSslProxy().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Describes a Target Proxy which uses this Certificate Map.
     * </pre>
     *
     * Protobuf type {@code google.cloud.certificatemanager.v1.CertificateMap.GclbTarget}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.certificatemanager.v1.CertificateMap.GclbTarget)
        com.google.cloud.certificatemanager.v1.CertificateMap.GclbTargetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.certificatemanager.v1.CertificateManagerProto
            .internal_static_google_cloud_certificatemanager_v1_CertificateMap_GclbTarget_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.certificatemanager.v1.CertificateManagerProto
            .internal_static_google_cloud_certificatemanager_v1_CertificateMap_GclbTarget_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.class,
                com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.Builder.class);
      }

      // Construct using
      // com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (ipConfigsBuilder_ == null) {
          ipConfigs_ = java.util.Collections.emptyList();
        } else {
          ipConfigs_ = null;
          ipConfigsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        targetProxyCase_ = 0;
        targetProxy_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.certificatemanager.v1.CertificateManagerProto
            .internal_static_google_cloud_certificatemanager_v1_CertificateMap_GclbTarget_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget
          getDefaultInstanceForType() {
        return com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget build() {
        com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget buildPartial() {
        com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget result =
            new com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget(this);
        int from_bitField0_ = bitField0_;
        if (targetProxyCase_ == 1) {
          result.targetProxy_ = targetProxy_;
        }
        if (targetProxyCase_ == 3) {
          result.targetProxy_ = targetProxy_;
        }
        if (ipConfigsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            ipConfigs_ = java.util.Collections.unmodifiableList(ipConfigs_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.ipConfigs_ = ipConfigs_;
        } else {
          result.ipConfigs_ = ipConfigsBuilder_.build();
        }
        result.targetProxyCase_ = targetProxyCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget) {
          return mergeFrom(
              (com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget other) {
        if (other
            == com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget
                .getDefaultInstance()) return this;
        if (ipConfigsBuilder_ == null) {
          if (!other.ipConfigs_.isEmpty()) {
            if (ipConfigs_.isEmpty()) {
              ipConfigs_ = other.ipConfigs_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureIpConfigsIsMutable();
              ipConfigs_.addAll(other.ipConfigs_);
            }
            onChanged();
          }
        } else {
          if (!other.ipConfigs_.isEmpty()) {
            if (ipConfigsBuilder_.isEmpty()) {
              ipConfigsBuilder_.dispose();
              ipConfigsBuilder_ = null;
              ipConfigs_ = other.ipConfigs_;
              bitField0_ = (bitField0_ & ~0x00000001);
              ipConfigsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getIpConfigsFieldBuilder()
                      : null;
            } else {
              ipConfigsBuilder_.addAllMessages(other.ipConfigs_);
            }
          }
        }
        switch (other.getTargetProxyCase()) {
          case TARGET_HTTPS_PROXY:
            {
              targetProxyCase_ = 1;
              targetProxy_ = other.targetProxy_;
              onChanged();
              break;
            }
          case TARGET_SSL_PROXY:
            {
              targetProxyCase_ = 3;
              targetProxy_ = other.targetProxy_;
              onChanged();
              break;
            }
          case TARGETPROXY_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  targetProxyCase_ = 1;
                  targetProxy_ = s;
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig m =
                      input.readMessage(
                          com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig
                              .parser(),
                          extensionRegistry);
                  if (ipConfigsBuilder_ == null) {
                    ensureIpConfigsIsMutable();
                    ipConfigs_.add(m);
                  } else {
                    ipConfigsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  targetProxyCase_ = 3;
                  targetProxy_ = s;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int targetProxyCase_ = 0;
      private java.lang.Object targetProxy_;

      public TargetProxyCase getTargetProxyCase() {
        return TargetProxyCase.forNumber(targetProxyCase_);
      }

      public Builder clearTargetProxy() {
        targetProxyCase_ = 0;
        targetProxy_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * Output only. This field returns the resource name in the following
       * format:
       * `//compute.googleapis.com/projects/&#42;&#47;global/targetHttpsProxies/&#42;`.
       * </pre>
       *
       * <code>string target_https_proxy = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return Whether the targetHttpsProxy field is set.
       */
      @java.lang.Override
      public boolean hasTargetHttpsProxy() {
        return targetProxyCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Output only. This field returns the resource name in the following
       * format:
       * `//compute.googleapis.com/projects/&#42;&#47;global/targetHttpsProxies/&#42;`.
       * </pre>
       *
       * <code>string target_https_proxy = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The targetHttpsProxy.
       */
      @java.lang.Override
      public java.lang.String getTargetHttpsProxy() {
        java.lang.Object ref = "";
        if (targetProxyCase_ == 1) {
          ref = targetProxy_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (targetProxyCase_ == 1) {
            targetProxy_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. This field returns the resource name in the following
       * format:
       * `//compute.googleapis.com/projects/&#42;&#47;global/targetHttpsProxies/&#42;`.
       * </pre>
       *
       * <code>string target_https_proxy = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for targetHttpsProxy.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTargetHttpsProxyBytes() {
        java.lang.Object ref = "";
        if (targetProxyCase_ == 1) {
          ref = targetProxy_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (targetProxyCase_ == 1) {
            targetProxy_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. This field returns the resource name in the following
       * format:
       * `//compute.googleapis.com/projects/&#42;&#47;global/targetHttpsProxies/&#42;`.
       * </pre>
       *
       * <code>string target_https_proxy = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The targetHttpsProxy to set.
       * @return This builder for chaining.
       */
      public Builder setTargetHttpsProxy(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        targetProxyCase_ = 1;
        targetProxy_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. This field returns the resource name in the following
       * format:
       * `//compute.googleapis.com/projects/&#42;&#47;global/targetHttpsProxies/&#42;`.
       * </pre>
       *
       * <code>string target_https_proxy = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTargetHttpsProxy() {
        if (targetProxyCase_ == 1) {
          targetProxyCase_ = 0;
          targetProxy_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. This field returns the resource name in the following
       * format:
       * `//compute.googleapis.com/projects/&#42;&#47;global/targetHttpsProxies/&#42;`.
       * </pre>
       *
       * <code>string target_https_proxy = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for targetHttpsProxy to set.
       * @return This builder for chaining.
       */
      public Builder setTargetHttpsProxyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        targetProxyCase_ = 1;
        targetProxy_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. This field returns the resource name in the following
       * format:
       * `//compute.googleapis.com/projects/&#42;&#47;global/targetSslProxies/&#42;`.
       * </pre>
       *
       * <code>string target_ssl_proxy = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return Whether the targetSslProxy field is set.
       */
      @java.lang.Override
      public boolean hasTargetSslProxy() {
        return targetProxyCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * Output only. This field returns the resource name in the following
       * format:
       * `//compute.googleapis.com/projects/&#42;&#47;global/targetSslProxies/&#42;`.
       * </pre>
       *
       * <code>string target_ssl_proxy = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The targetSslProxy.
       */
      @java.lang.Override
      public java.lang.String getTargetSslProxy() {
        java.lang.Object ref = "";
        if (targetProxyCase_ == 3) {
          ref = targetProxy_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (targetProxyCase_ == 3) {
            targetProxy_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. This field returns the resource name in the following
       * format:
       * `//compute.googleapis.com/projects/&#42;&#47;global/targetSslProxies/&#42;`.
       * </pre>
       *
       * <code>string target_ssl_proxy = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for targetSslProxy.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTargetSslProxyBytes() {
        java.lang.Object ref = "";
        if (targetProxyCase_ == 3) {
          ref = targetProxy_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (targetProxyCase_ == 3) {
            targetProxy_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. This field returns the resource name in the following
       * format:
       * `//compute.googleapis.com/projects/&#42;&#47;global/targetSslProxies/&#42;`.
       * </pre>
       *
       * <code>string target_ssl_proxy = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The targetSslProxy to set.
       * @return This builder for chaining.
       */
      public Builder setTargetSslProxy(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        targetProxyCase_ = 3;
        targetProxy_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. This field returns the resource name in the following
       * format:
       * `//compute.googleapis.com/projects/&#42;&#47;global/targetSslProxies/&#42;`.
       * </pre>
       *
       * <code>string target_ssl_proxy = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTargetSslProxy() {
        if (targetProxyCase_ == 3) {
          targetProxyCase_ = 0;
          targetProxy_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. This field returns the resource name in the following
       * format:
       * `//compute.googleapis.com/projects/&#42;&#47;global/targetSslProxies/&#42;`.
       * </pre>
       *
       * <code>string target_ssl_proxy = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for targetSslProxy to set.
       * @return This builder for chaining.
       */
      public Builder setTargetSslProxyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        targetProxyCase_ = 3;
        targetProxy_ = value;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig>
          ipConfigs_ = java.util.Collections.emptyList();

      private void ensureIpConfigsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          ipConfigs_ =
              new java.util.ArrayList<
                  com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig>(
                  ipConfigs_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig,
              com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig.Builder,
              com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfigOrBuilder>
          ipConfigsBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. IP configurations for this Target Proxy where the
       * Certificate Map is serving.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<
              com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig>
          getIpConfigsList() {
        if (ipConfigsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(ipConfigs_);
        } else {
          return ipConfigsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. IP configurations for this Target Proxy where the
       * Certificate Map is serving.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public int getIpConfigsCount() {
        if (ipConfigsBuilder_ == null) {
          return ipConfigs_.size();
        } else {
          return ipConfigsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. IP configurations for this Target Proxy where the
       * Certificate Map is serving.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig getIpConfigs(
          int index) {
        if (ipConfigsBuilder_ == null) {
          return ipConfigs_.get(index);
        } else {
          return ipConfigsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. IP configurations for this Target Proxy where the
       * Certificate Map is serving.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setIpConfigs(
          int index,
          com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig value) {
        if (ipConfigsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIpConfigsIsMutable();
          ipConfigs_.set(index, value);
          onChanged();
        } else {
          ipConfigsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. IP configurations for this Target Proxy where the
       * Certificate Map is serving.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setIpConfigs(
          int index,
          com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig.Builder
              builderForValue) {
        if (ipConfigsBuilder_ == null) {
          ensureIpConfigsIsMutable();
          ipConfigs_.set(index, builderForValue.build());
          onChanged();
        } else {
          ipConfigsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. IP configurations for this Target Proxy where the
       * Certificate Map is serving.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addIpConfigs(
          com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig value) {
        if (ipConfigsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIpConfigsIsMutable();
          ipConfigs_.add(value);
          onChanged();
        } else {
          ipConfigsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. IP configurations for this Target Proxy where the
       * Certificate Map is serving.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addIpConfigs(
          int index,
          com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig value) {
        if (ipConfigsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIpConfigsIsMutable();
          ipConfigs_.add(index, value);
          onChanged();
        } else {
          ipConfigsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. IP configurations for this Target Proxy where the
       * Certificate Map is serving.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addIpConfigs(
          com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig.Builder
              builderForValue) {
        if (ipConfigsBuilder_ == null) {
          ensureIpConfigsIsMutable();
          ipConfigs_.add(builderForValue.build());
          onChanged();
        } else {
          ipConfigsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. IP configurations for this Target Proxy where the
       * Certificate Map is serving.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addIpConfigs(
          int index,
          com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig.Builder
              builderForValue) {
        if (ipConfigsBuilder_ == null) {
          ensureIpConfigsIsMutable();
          ipConfigs_.add(index, builderForValue.build());
          onChanged();
        } else {
          ipConfigsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. IP configurations for this Target Proxy where the
       * Certificate Map is serving.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addAllIpConfigs(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig>
              values) {
        if (ipConfigsBuilder_ == null) {
          ensureIpConfigsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ipConfigs_);
          onChanged();
        } else {
          ipConfigsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. IP configurations for this Target Proxy where the
       * Certificate Map is serving.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearIpConfigs() {
        if (ipConfigsBuilder_ == null) {
          ipConfigs_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          ipConfigsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. IP configurations for this Target Proxy where the
       * Certificate Map is serving.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder removeIpConfigs(int index) {
        if (ipConfigsBuilder_ == null) {
          ensureIpConfigsIsMutable();
          ipConfigs_.remove(index);
          onChanged();
        } else {
          ipConfigsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. IP configurations for this Target Proxy where the
       * Certificate Map is serving.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig.Builder
          getIpConfigsBuilder(int index) {
        return getIpConfigsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. IP configurations for this Target Proxy where the
       * Certificate Map is serving.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfigOrBuilder
          getIpConfigsOrBuilder(int index) {
        if (ipConfigsBuilder_ == null) {
          return ipConfigs_.get(index);
        } else {
          return ipConfigsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. IP configurations for this Target Proxy where the
       * Certificate Map is serving.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget
                      .IpConfigOrBuilder>
          getIpConfigsOrBuilderList() {
        if (ipConfigsBuilder_ != null) {
          return ipConfigsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(ipConfigs_);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. IP configurations for this Target Proxy where the
       * Certificate Map is serving.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig.Builder
          addIpConfigsBuilder() {
        return getIpConfigsFieldBuilder()
            .addBuilder(
                com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. IP configurations for this Target Proxy where the
       * Certificate Map is serving.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig.Builder
          addIpConfigsBuilder(int index) {
        return getIpConfigsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. IP configurations for this Target Proxy where the
       * Certificate Map is serving.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig ip_configs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<
              com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig.Builder>
          getIpConfigsBuilderList() {
        return getIpConfigsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig,
              com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig.Builder,
              com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfigOrBuilder>
          getIpConfigsFieldBuilder() {
        if (ipConfigsBuilder_ == null) {
          ipConfigsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig,
                  com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig.Builder,
                  com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget
                      .IpConfigOrBuilder>(
                  ipConfigs_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          ipConfigs_ = null;
        }
        return ipConfigsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.certificatemanager.v1.CertificateMap.GclbTarget)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.certificatemanager.v1.CertificateMap.GclbTarget)
    private static final com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget();
    }

    public static com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GclbTarget> PARSER =
        new com.google.protobuf.AbstractParser<GclbTarget>() {
          @java.lang.Override
          public GclbTarget parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GclbTarget> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GclbTarget> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * A user-defined name of the Certificate Map. Certificate Map names must be
   * unique globally and match pattern
   * `projects/&#42;&#47;locations/&#42;&#47;certificateMaps/&#42;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A user-defined name of the Certificate Map. Certificate Map names must be
   * unique globally and match pattern
   * `projects/&#42;&#47;locations/&#42;&#47;certificateMaps/&#42;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 5;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * One or more paragraphs of text description of a certificate map.
   * </pre>
   *
   * <code>string description = 5;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * One or more paragraphs of text description of a certificate map.
   * </pre>
   *
   * <code>string description = 5;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a Certificate Map.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a Certificate Map.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a Certificate Map.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The update timestamp of a Certificate Map.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The update timestamp of a Certificate Map.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The update timestamp of a Certificate Map.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int LABELS_FIELD_NUMBER = 3;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.certificatemanager.v1.CertificateManagerProto
                .internal_static_google_cloud_certificatemanager_v1_CertificateMap_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Set of labels associated with a Certificate Map.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Set of labels associated with a Certificate Map.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Set of labels associated with a Certificate Map.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Set of labels associated with a Certificate Map.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int GCLB_TARGETS_FIELD_NUMBER = 4;
  private java.util.List<com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget>
      gclbTargets_;
  /**
   *
   *
   * <pre>
   * Output only. A list of GCLB targets which use this Certificate Map.
   * A Target Proxy is only present on this list if it's attached to a
   * Forwarding Rule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget gclb_targets = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget>
      getGclbTargetsList() {
    return gclbTargets_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of GCLB targets which use this Certificate Map.
   * A Target Proxy is only present on this list if it's attached to a
   * Forwarding Rule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget gclb_targets = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.certificatemanager.v1.CertificateMap.GclbTargetOrBuilder>
      getGclbTargetsOrBuilderList() {
    return gclbTargets_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of GCLB targets which use this Certificate Map.
   * A Target Proxy is only present on this list if it's attached to a
   * Forwarding Rule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget gclb_targets = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getGclbTargetsCount() {
    return gclbTargets_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of GCLB targets which use this Certificate Map.
   * A Target Proxy is only present on this list if it's attached to a
   * Forwarding Rule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget gclb_targets = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget getGclbTargets(
      int index) {
    return gclbTargets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of GCLB targets which use this Certificate Map.
   * A Target Proxy is only present on this list if it's attached to a
   * Forwarding Rule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget gclb_targets = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.certificatemanager.v1.CertificateMap.GclbTargetOrBuilder
      getGclbTargetsOrBuilder(int index) {
    return gclbTargets_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 3);
    for (int i = 0; i < gclbTargets_.size(); i++) {
      output.writeMessage(4, gclbTargets_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, description_);
    }
    if (updateTime_ != null) {
      output.writeMessage(6, getUpdateTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, labels__);
    }
    for (int i = 0; i < gclbTargets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, gclbTargets_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, description_);
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getUpdateTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.certificatemanager.v1.CertificateMap)) {
      return super.equals(obj);
    }
    com.google.cloud.certificatemanager.v1.CertificateMap other =
        (com.google.cloud.certificatemanager.v1.CertificateMap) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getGclbTargetsList().equals(other.getGclbTargetsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getGclbTargetsCount() > 0) {
      hash = (37 * hash) + GCLB_TARGETS_FIELD_NUMBER;
      hash = (53 * hash) + getGclbTargetsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMap parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMap parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMap parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMap parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMap parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMap parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMap parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMap parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMap parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMap parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMap parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMap parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.certificatemanager.v1.CertificateMap prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Defines a collection of certificate configurations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.certificatemanager.v1.CertificateMap}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.certificatemanager.v1.CertificateMap)
      com.google.cloud.certificatemanager.v1.CertificateMapOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.certificatemanager.v1.CertificateManagerProto
          .internal_static_google_cloud_certificatemanager_v1_CertificateMap_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 3:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 3:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.certificatemanager.v1.CertificateManagerProto
          .internal_static_google_cloud_certificatemanager_v1_CertificateMap_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.certificatemanager.v1.CertificateMap.class,
              com.google.cloud.certificatemanager.v1.CertificateMap.Builder.class);
    }

    // Construct using com.google.cloud.certificatemanager.v1.CertificateMap.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      description_ = "";

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      if (gclbTargetsBuilder_ == null) {
        gclbTargets_ = java.util.Collections.emptyList();
      } else {
        gclbTargets_ = null;
        gclbTargetsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.certificatemanager.v1.CertificateManagerProto
          .internal_static_google_cloud_certificatemanager_v1_CertificateMap_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.CertificateMap getDefaultInstanceForType() {
      return com.google.cloud.certificatemanager.v1.CertificateMap.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.CertificateMap build() {
      com.google.cloud.certificatemanager.v1.CertificateMap result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.CertificateMap buildPartial() {
      com.google.cloud.certificatemanager.v1.CertificateMap result =
          new com.google.cloud.certificatemanager.v1.CertificateMap(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.description_ = description_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      if (gclbTargetsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          gclbTargets_ = java.util.Collections.unmodifiableList(gclbTargets_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.gclbTargets_ = gclbTargets_;
      } else {
        result.gclbTargets_ = gclbTargetsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.certificatemanager.v1.CertificateMap) {
        return mergeFrom((com.google.cloud.certificatemanager.v1.CertificateMap) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.certificatemanager.v1.CertificateMap other) {
      if (other == com.google.cloud.certificatemanager.v1.CertificateMap.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (gclbTargetsBuilder_ == null) {
        if (!other.gclbTargets_.isEmpty()) {
          if (gclbTargets_.isEmpty()) {
            gclbTargets_ = other.gclbTargets_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureGclbTargetsIsMutable();
            gclbTargets_.addAll(other.gclbTargets_);
          }
          onChanged();
        }
      } else {
        if (!other.gclbTargets_.isEmpty()) {
          if (gclbTargetsBuilder_.isEmpty()) {
            gclbTargetsBuilder_.dispose();
            gclbTargetsBuilder_ = null;
            gclbTargets_ = other.gclbTargets_;
            bitField0_ = (bitField0_ & ~0x00000002);
            gclbTargetsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getGclbTargetsFieldBuilder()
                    : null;
          } else {
            gclbTargetsBuilder_.addAllMessages(other.gclbTargets_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget m =
                    input.readMessage(
                        com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.parser(),
                        extensionRegistry);
                if (gclbTargetsBuilder_ == null) {
                  ensureGclbTargetsIsMutable();
                  gclbTargets_.add(m);
                } else {
                  gclbTargetsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                description_ = input.readStringRequireUtf8();

                break;
              } // case 42
            case 50:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * A user-defined name of the Certificate Map. Certificate Map names must be
     * unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;certificateMaps/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the Certificate Map. Certificate Map names must be
     * unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;certificateMaps/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the Certificate Map. Certificate Map names must be
     * unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;certificateMaps/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the Certificate Map. Certificate Map names must be
     * unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;certificateMaps/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the Certificate Map. Certificate Map names must be
     * unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;certificateMaps/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a certificate map.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a certificate map.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a certificate map.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a certificate map.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a certificate map.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate Map.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate Map.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate Map.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate Map.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate Map.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate Map.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate Map.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate Map.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate Map.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The update timestamp of a Certificate Map.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The update timestamp of a Certificate Map.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The update timestamp of a Certificate Map.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The update timestamp of a Certificate Map.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The update timestamp of a Certificate Map.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The update timestamp of a Certificate Map.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The update timestamp of a Certificate Map.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The update timestamp of a Certificate Map.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The update timestamp of a Certificate Map.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a Certificate Map.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a Certificate Map.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a Certificate Map.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a Certificate Map.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a Certificate Map.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a Certificate Map.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a Certificate Map.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private java.util.List<com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget>
        gclbTargets_ = java.util.Collections.emptyList();

    private void ensureGclbTargetsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        gclbTargets_ =
            new java.util.ArrayList<
                com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget>(gclbTargets_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget,
            com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.Builder,
            com.google.cloud.certificatemanager.v1.CertificateMap.GclbTargetOrBuilder>
        gclbTargetsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. A list of GCLB targets which use this Certificate Map.
     * A Target Proxy is only present on this list if it's attached to a
     * Forwarding Rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget gclb_targets = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget>
        getGclbTargetsList() {
      if (gclbTargetsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(gclbTargets_);
      } else {
        return gclbTargetsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of GCLB targets which use this Certificate Map.
     * A Target Proxy is only present on this list if it's attached to a
     * Forwarding Rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget gclb_targets = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getGclbTargetsCount() {
      if (gclbTargetsBuilder_ == null) {
        return gclbTargets_.size();
      } else {
        return gclbTargetsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of GCLB targets which use this Certificate Map.
     * A Target Proxy is only present on this list if it's attached to a
     * Forwarding Rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget gclb_targets = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget getGclbTargets(
        int index) {
      if (gclbTargetsBuilder_ == null) {
        return gclbTargets_.get(index);
      } else {
        return gclbTargetsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of GCLB targets which use this Certificate Map.
     * A Target Proxy is only present on this list if it's attached to a
     * Forwarding Rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget gclb_targets = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setGclbTargets(
        int index, com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget value) {
      if (gclbTargetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGclbTargetsIsMutable();
        gclbTargets_.set(index, value);
        onChanged();
      } else {
        gclbTargetsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of GCLB targets which use this Certificate Map.
     * A Target Proxy is only present on this list if it's attached to a
     * Forwarding Rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget gclb_targets = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setGclbTargets(
        int index,
        com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.Builder builderForValue) {
      if (gclbTargetsBuilder_ == null) {
        ensureGclbTargetsIsMutable();
        gclbTargets_.set(index, builderForValue.build());
        onChanged();
      } else {
        gclbTargetsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of GCLB targets which use this Certificate Map.
     * A Target Proxy is only present on this list if it's attached to a
     * Forwarding Rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget gclb_targets = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addGclbTargets(
        com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget value) {
      if (gclbTargetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGclbTargetsIsMutable();
        gclbTargets_.add(value);
        onChanged();
      } else {
        gclbTargetsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of GCLB targets which use this Certificate Map.
     * A Target Proxy is only present on this list if it's attached to a
     * Forwarding Rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget gclb_targets = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addGclbTargets(
        int index, com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget value) {
      if (gclbTargetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGclbTargetsIsMutable();
        gclbTargets_.add(index, value);
        onChanged();
      } else {
        gclbTargetsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of GCLB targets which use this Certificate Map.
     * A Target Proxy is only present on this list if it's attached to a
     * Forwarding Rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget gclb_targets = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addGclbTargets(
        com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.Builder builderForValue) {
      if (gclbTargetsBuilder_ == null) {
        ensureGclbTargetsIsMutable();
        gclbTargets_.add(builderForValue.build());
        onChanged();
      } else {
        gclbTargetsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of GCLB targets which use this Certificate Map.
     * A Target Proxy is only present on this list if it's attached to a
     * Forwarding Rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget gclb_targets = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addGclbTargets(
        int index,
        com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.Builder builderForValue) {
      if (gclbTargetsBuilder_ == null) {
        ensureGclbTargetsIsMutable();
        gclbTargets_.add(index, builderForValue.build());
        onChanged();
      } else {
        gclbTargetsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of GCLB targets which use this Certificate Map.
     * A Target Proxy is only present on this list if it's attached to a
     * Forwarding Rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget gclb_targets = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllGclbTargets(
        java.lang.Iterable<
                ? extends com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget>
            values) {
      if (gclbTargetsBuilder_ == null) {
        ensureGclbTargetsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, gclbTargets_);
        onChanged();
      } else {
        gclbTargetsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of GCLB targets which use this Certificate Map.
     * A Target Proxy is only present on this list if it's attached to a
     * Forwarding Rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget gclb_targets = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearGclbTargets() {
      if (gclbTargetsBuilder_ == null) {
        gclbTargets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        gclbTargetsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of GCLB targets which use this Certificate Map.
     * A Target Proxy is only present on this list if it's attached to a
     * Forwarding Rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget gclb_targets = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeGclbTargets(int index) {
      if (gclbTargetsBuilder_ == null) {
        ensureGclbTargetsIsMutable();
        gclbTargets_.remove(index);
        onChanged();
      } else {
        gclbTargetsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of GCLB targets which use this Certificate Map.
     * A Target Proxy is only present on this list if it's attached to a
     * Forwarding Rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget gclb_targets = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.Builder
        getGclbTargetsBuilder(int index) {
      return getGclbTargetsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of GCLB targets which use this Certificate Map.
     * A Target Proxy is only present on this list if it's attached to a
     * Forwarding Rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget gclb_targets = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.certificatemanager.v1.CertificateMap.GclbTargetOrBuilder
        getGclbTargetsOrBuilder(int index) {
      if (gclbTargetsBuilder_ == null) {
        return gclbTargets_.get(index);
      } else {
        return gclbTargetsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of GCLB targets which use this Certificate Map.
     * A Target Proxy is only present on this list if it's attached to a
     * Forwarding Rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget gclb_targets = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.certificatemanager.v1.CertificateMap.GclbTargetOrBuilder>
        getGclbTargetsOrBuilderList() {
      if (gclbTargetsBuilder_ != null) {
        return gclbTargetsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(gclbTargets_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of GCLB targets which use this Certificate Map.
     * A Target Proxy is only present on this list if it's attached to a
     * Forwarding Rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget gclb_targets = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.Builder
        addGclbTargetsBuilder() {
      return getGclbTargetsFieldBuilder()
          .addBuilder(
              com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of GCLB targets which use this Certificate Map.
     * A Target Proxy is only present on this list if it's attached to a
     * Forwarding Rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget gclb_targets = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.Builder
        addGclbTargetsBuilder(int index) {
      return getGclbTargetsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of GCLB targets which use this Certificate Map.
     * A Target Proxy is only present on this list if it's attached to a
     * Forwarding Rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.CertificateMap.GclbTarget gclb_targets = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.Builder>
        getGclbTargetsBuilderList() {
      return getGclbTargetsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget,
            com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.Builder,
            com.google.cloud.certificatemanager.v1.CertificateMap.GclbTargetOrBuilder>
        getGclbTargetsFieldBuilder() {
      if (gclbTargetsBuilder_ == null) {
        gclbTargetsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget,
                com.google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.Builder,
                com.google.cloud.certificatemanager.v1.CertificateMap.GclbTargetOrBuilder>(
                gclbTargets_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        gclbTargets_ = null;
      }
      return gclbTargetsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.certificatemanager.v1.CertificateMap)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.certificatemanager.v1.CertificateMap)
  private static final com.google.cloud.certificatemanager.v1.CertificateMap DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.certificatemanager.v1.CertificateMap();
  }

  public static com.google.cloud.certificatemanager.v1.CertificateMap getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CertificateMap> PARSER =
      new com.google.protobuf.AbstractParser<CertificateMap>() {
        @java.lang.Override
        public CertificateMap parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CertificateMap> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CertificateMap> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.certificatemanager.v1.CertificateMap getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
