/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/certificatemanager/v1/certificate_issuance_config.proto

package com.google.cloud.certificatemanager.v1;

/**
 *
 *
 * <pre>
 * CertificateIssuanceConfig specifies how to issue and manage a certificate.
 * </pre>
 *
 * Protobuf type {@code google.cloud.certificatemanager.v1.CertificateIssuanceConfig}
 */
public final class CertificateIssuanceConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.certificatemanager.v1.CertificateIssuanceConfig)
    CertificateIssuanceConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CertificateIssuanceConfig.newBuilder() to construct.
  private CertificateIssuanceConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CertificateIssuanceConfig() {
    name_ = "";
    description_ = "";
    keyAlgorithm_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CertificateIssuanceConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.certificatemanager.v1.CertificateIssuanceConfigProto
        .internal_static_google_cloud_certificatemanager_v1_CertificateIssuanceConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.certificatemanager.v1.CertificateIssuanceConfigProto
        .internal_static_google_cloud_certificatemanager_v1_CertificateIssuanceConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.class,
            com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of keypair to generate.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.certificatemanager.v1.CertificateIssuanceConfig.KeyAlgorithm}
   */
  public enum KeyAlgorithm implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified key algorithm.
     * </pre>
     *
     * <code>KEY_ALGORITHM_UNSPECIFIED = 0;</code>
     */
    KEY_ALGORITHM_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Specifies RSA with a 2048-bit modulus.
     * </pre>
     *
     * <code>RSA_2048 = 1;</code>
     */
    RSA_2048(1),
    /**
     *
     *
     * <pre>
     * Specifies ECDSA with curve P256.
     * </pre>
     *
     * <code>ECDSA_P256 = 4;</code>
     */
    ECDSA_P256(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified key algorithm.
     * </pre>
     *
     * <code>KEY_ALGORITHM_UNSPECIFIED = 0;</code>
     */
    public static final int KEY_ALGORITHM_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Specifies RSA with a 2048-bit modulus.
     * </pre>
     *
     * <code>RSA_2048 = 1;</code>
     */
    public static final int RSA_2048_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Specifies ECDSA with curve P256.
     * </pre>
     *
     * <code>ECDSA_P256 = 4;</code>
     */
    public static final int ECDSA_P256_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static KeyAlgorithm valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static KeyAlgorithm forNumber(int value) {
      switch (value) {
        case 0:
          return KEY_ALGORITHM_UNSPECIFIED;
        case 1:
          return RSA_2048;
        case 4:
          return ECDSA_P256;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<KeyAlgorithm> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<KeyAlgorithm> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<KeyAlgorithm>() {
          public KeyAlgorithm findValueByNumber(int number) {
            return KeyAlgorithm.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final KeyAlgorithm[] VALUES = values();

    public static KeyAlgorithm valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private KeyAlgorithm(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.certificatemanager.v1.CertificateIssuanceConfig.KeyAlgorithm)
  }

  public interface CertificateAuthorityConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Defines a CertificateAuthorityServiceConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig certificate_authority_service_config = 1;
     * </code>
     *
     * @return Whether the certificateAuthorityServiceConfig field is set.
     */
    boolean hasCertificateAuthorityServiceConfig();
    /**
     *
     *
     * <pre>
     * Defines a CertificateAuthorityServiceConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig certificate_authority_service_config = 1;
     * </code>
     *
     * @return The certificateAuthorityServiceConfig.
     */
    com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig
            .CertificateAuthorityServiceConfig
        getCertificateAuthorityServiceConfig();
    /**
     *
     *
     * <pre>
     * Defines a CertificateAuthorityServiceConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig certificate_authority_service_config = 1;
     * </code>
     */
    com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig
            .CertificateAuthorityServiceConfigOrBuilder
        getCertificateAuthorityServiceConfigOrBuilder();

    public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfig.KindCase
        getKindCase();
  }
  /**
   *
   *
   * <pre>
   * The CA that issues the workload certificate. It includes CA address, type,
   * authentication to CA service, etc.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig}
   */
  public static final class CertificateAuthorityConfig
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig)
      CertificateAuthorityConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CertificateAuthorityConfig.newBuilder() to construct.
    private CertificateAuthorityConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CertificateAuthorityConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CertificateAuthorityConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.certificatemanager.v1.CertificateIssuanceConfigProto
          .internal_static_google_cloud_certificatemanager_v1_CertificateIssuanceConfig_CertificateAuthorityConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.certificatemanager.v1.CertificateIssuanceConfigProto
          .internal_static_google_cloud_certificatemanager_v1_CertificateIssuanceConfig_CertificateAuthorityConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                  .CertificateAuthorityConfig.class,
              com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                  .CertificateAuthorityConfig.Builder.class);
    }

    public interface CertificateAuthorityServiceConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. A CA pool resource used to issue a certificate.
       * The CA pool string has a relative resource path following the form
       * "projects/{project}/locations/{location}/caPools/{ca_pool}".
       * </pre>
       *
       * <code>
       * string ca_pool = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The caPool.
       */
      java.lang.String getCaPool();
      /**
       *
       *
       * <pre>
       * Required. A CA pool resource used to issue a certificate.
       * The CA pool string has a relative resource path following the form
       * "projects/{project}/locations/{location}/caPools/{ca_pool}".
       * </pre>
       *
       * <code>
       * string ca_pool = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for caPool.
       */
      com.google.protobuf.ByteString getCaPoolBytes();
    }
    /**
     *
     *
     * <pre>
     * Contains information required to contact CA service.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig}
     */
    public static final class CertificateAuthorityServiceConfig
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig)
        CertificateAuthorityServiceConfigOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use CertificateAuthorityServiceConfig.newBuilder() to construct.
      private CertificateAuthorityServiceConfig(
          com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private CertificateAuthorityServiceConfig() {
        caPool_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new CertificateAuthorityServiceConfig();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.certificatemanager.v1.CertificateIssuanceConfigProto
            .internal_static_google_cloud_certificatemanager_v1_CertificateIssuanceConfig_CertificateAuthorityConfig_CertificateAuthorityServiceConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.certificatemanager.v1.CertificateIssuanceConfigProto
            .internal_static_google_cloud_certificatemanager_v1_CertificateIssuanceConfig_CertificateAuthorityConfig_CertificateAuthorityServiceConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                    .CertificateAuthorityConfig.CertificateAuthorityServiceConfig.class,
                com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                    .CertificateAuthorityConfig.CertificateAuthorityServiceConfig.Builder.class);
      }

      public static final int CA_POOL_FIELD_NUMBER = 1;
      private volatile java.lang.Object caPool_;
      /**
       *
       *
       * <pre>
       * Required. A CA pool resource used to issue a certificate.
       * The CA pool string has a relative resource path following the form
       * "projects/{project}/locations/{location}/caPools/{ca_pool}".
       * </pre>
       *
       * <code>
       * string ca_pool = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The caPool.
       */
      @java.lang.Override
      public java.lang.String getCaPool() {
        java.lang.Object ref = caPool_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          caPool_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A CA pool resource used to issue a certificate.
       * The CA pool string has a relative resource path following the form
       * "projects/{project}/locations/{location}/caPools/{ca_pool}".
       * </pre>
       *
       * <code>
       * string ca_pool = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for caPool.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getCaPoolBytes() {
        java.lang.Object ref = caPool_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          caPool_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(caPool_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, caPool_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(caPool_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, caPool_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                .CertificateAuthorityConfig.CertificateAuthorityServiceConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig
                .CertificateAuthorityServiceConfig
            other =
                (com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                        .CertificateAuthorityConfig.CertificateAuthorityServiceConfig)
                    obj;

        if (!getCaPool().equals(other.getCaPool())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + CA_POOL_FIELD_NUMBER;
        hash = (53 * hash) + getCaPool().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                  .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Contains information required to contact CA service.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig)
          com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig.CertificateAuthorityServiceConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.certificatemanager.v1.CertificateIssuanceConfigProto
              .internal_static_google_cloud_certificatemanager_v1_CertificateIssuanceConfig_CertificateAuthorityConfig_CertificateAuthorityServiceConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.certificatemanager.v1.CertificateIssuanceConfigProto
              .internal_static_google_cloud_certificatemanager_v1_CertificateIssuanceConfig_CertificateAuthorityConfig_CertificateAuthorityServiceConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                      .CertificateAuthorityConfig.CertificateAuthorityServiceConfig.class,
                  com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                      .CertificateAuthorityConfig.CertificateAuthorityServiceConfig.Builder.class);
        }

        // Construct using
        // com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          caPool_ = "";

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.certificatemanager.v1.CertificateIssuanceConfigProto
              .internal_static_google_cloud_certificatemanager_v1_CertificateIssuanceConfig_CertificateAuthorityConfig_CertificateAuthorityServiceConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
            getDefaultInstanceForType() {
          return com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig.CertificateAuthorityServiceConfig.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
            build() {
          com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                  .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
            buildPartial() {
          com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                  .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
              result =
                  new com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                      .CertificateAuthorityConfig.CertificateAuthorityServiceConfig(this);
          result.caPool_ = caPool_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                  .CertificateAuthorityConfig.CertificateAuthorityServiceConfig) {
            return mergeFrom(
                (com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                        .CertificateAuthorityConfig.CertificateAuthorityServiceConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                    .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
                other) {
          if (other
              == com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                  .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
                  .getDefaultInstance()) return this;
          if (!other.getCaPool().isEmpty()) {
            caPool_ = other.caPool_;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    caPool_ = input.readStringRequireUtf8();

                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private java.lang.Object caPool_ = "";
        /**
         *
         *
         * <pre>
         * Required. A CA pool resource used to issue a certificate.
         * The CA pool string has a relative resource path following the form
         * "projects/{project}/locations/{location}/caPools/{ca_pool}".
         * </pre>
         *
         * <code>
         * string ca_pool = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The caPool.
         */
        public java.lang.String getCaPool() {
          java.lang.Object ref = caPool_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            caPool_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. A CA pool resource used to issue a certificate.
         * The CA pool string has a relative resource path following the form
         * "projects/{project}/locations/{location}/caPools/{ca_pool}".
         * </pre>
         *
         * <code>
         * string ca_pool = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The bytes for caPool.
         */
        public com.google.protobuf.ByteString getCaPoolBytes() {
          java.lang.Object ref = caPool_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            caPool_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. A CA pool resource used to issue a certificate.
         * The CA pool string has a relative resource path following the form
         * "projects/{project}/locations/{location}/caPools/{ca_pool}".
         * </pre>
         *
         * <code>
         * string ca_pool = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The caPool to set.
         * @return This builder for chaining.
         */
        public Builder setCaPool(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          caPool_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. A CA pool resource used to issue a certificate.
         * The CA pool string has a relative resource path following the form
         * "projects/{project}/locations/{location}/caPools/{ca_pool}".
         * </pre>
         *
         * <code>
         * string ca_pool = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCaPool() {

          caPool_ = getDefaultInstance().getCaPool();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. A CA pool resource used to issue a certificate.
         * The CA pool string has a relative resource path following the form
         * "projects/{project}/locations/{location}/caPools/{ca_pool}".
         * </pre>
         *
         * <code>
         * string ca_pool = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The bytes for caPool to set.
         * @return This builder for chaining.
         */
        public Builder setCaPoolBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          caPool_ = value;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig)
      private static final com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                .CertificateAuthorityConfig.CertificateAuthorityServiceConfig();
      }

      public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<CertificateAuthorityServiceConfig> PARSER =
          new com.google.protobuf.AbstractParser<CertificateAuthorityServiceConfig>() {
            @java.lang.Override
            public CertificateAuthorityServiceConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<CertificateAuthorityServiceConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<CertificateAuthorityServiceConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int kindCase_ = 0;
    private java.lang.Object kind_;

    public enum KindCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      CERTIFICATE_AUTHORITY_SERVICE_CONFIG(1),
      KIND_NOT_SET(0);
      private final int value;

      private KindCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static KindCase valueOf(int value) {
        return forNumber(value);
      }

      public static KindCase forNumber(int value) {
        switch (value) {
          case 1:
            return CERTIFICATE_AUTHORITY_SERVICE_CONFIG;
          case 0:
            return KIND_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public KindCase getKindCase() {
      return KindCase.forNumber(kindCase_);
    }

    public static final int CERTIFICATE_AUTHORITY_SERVICE_CONFIG_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Defines a CertificateAuthorityServiceConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig certificate_authority_service_config = 1;
     * </code>
     *
     * @return Whether the certificateAuthorityServiceConfig field is set.
     */
    @java.lang.Override
    public boolean hasCertificateAuthorityServiceConfig() {
      return kindCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Defines a CertificateAuthorityServiceConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig certificate_authority_service_config = 1;
     * </code>
     *
     * @return The certificateAuthorityServiceConfig.
     */
    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
        getCertificateAuthorityServiceConfig() {
      if (kindCase_ == 1) {
        return (com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                .CertificateAuthorityConfig.CertificateAuthorityServiceConfig)
            kind_;
      }
      return com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
          .CertificateAuthorityConfig.CertificateAuthorityServiceConfig.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Defines a CertificateAuthorityServiceConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig certificate_authority_service_config = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfig.CertificateAuthorityServiceConfigOrBuilder
        getCertificateAuthorityServiceConfigOrBuilder() {
      if (kindCase_ == 1) {
        return (com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                .CertificateAuthorityConfig.CertificateAuthorityServiceConfig)
            kind_;
      }
      return com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
          .CertificateAuthorityConfig.CertificateAuthorityServiceConfig.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (kindCase_ == 1) {
        output.writeMessage(
            1,
            (com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                    .CertificateAuthorityConfig.CertificateAuthorityServiceConfig)
                kind_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (kindCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1,
                (com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                        .CertificateAuthorityConfig.CertificateAuthorityServiceConfig)
                    kind_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig
          other =
              (com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                      .CertificateAuthorityConfig)
                  obj;

      if (!getKindCase().equals(other.getKindCase())) return false;
      switch (kindCase_) {
        case 1:
          if (!getCertificateAuthorityServiceConfig()
              .equals(other.getCertificateAuthorityServiceConfig())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (kindCase_) {
        case 1:
          hash = (37 * hash) + CERTIFICATE_AUTHORITY_SERVICE_CONFIG_FIELD_NUMBER;
          hash = (53 * hash) + getCertificateAuthorityServiceConfig().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The CA that issues the workload certificate. It includes CA address, type,
     * authentication to CA service, etc.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig)
        com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.certificatemanager.v1.CertificateIssuanceConfigProto
            .internal_static_google_cloud_certificatemanager_v1_CertificateIssuanceConfig_CertificateAuthorityConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.certificatemanager.v1.CertificateIssuanceConfigProto
            .internal_static_google_cloud_certificatemanager_v1_CertificateIssuanceConfig_CertificateAuthorityConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                    .CertificateAuthorityConfig.class,
                com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                    .CertificateAuthorityConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (certificateAuthorityServiceConfigBuilder_ != null) {
          certificateAuthorityServiceConfigBuilder_.clear();
        }
        kindCase_ = 0;
        kind_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.certificatemanager.v1.CertificateIssuanceConfigProto
            .internal_static_google_cloud_certificatemanager_v1_CertificateIssuanceConfig_CertificateAuthorityConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig
          getDefaultInstanceForType() {
        return com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig
          build() {
        com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig
          buildPartial() {
        com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig
            result =
                new com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                    .CertificateAuthorityConfig(this);
        if (kindCase_ == 1) {
          if (certificateAuthorityServiceConfigBuilder_ == null) {
            result.kind_ = kind_;
          } else {
            result.kind_ = certificateAuthorityServiceConfigBuilder_.build();
          }
        }
        result.kindCase_ = kindCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                .CertificateAuthorityConfig) {
          return mergeFrom(
              (com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                      .CertificateAuthorityConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                  .CertificateAuthorityConfig
              other) {
        if (other
            == com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                .CertificateAuthorityConfig.getDefaultInstance()) return this;
        switch (other.getKindCase()) {
          case CERTIFICATE_AUTHORITY_SERVICE_CONFIG:
            {
              mergeCertificateAuthorityServiceConfig(other.getCertificateAuthorityServiceConfig());
              break;
            }
          case KIND_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getCertificateAuthorityServiceConfigFieldBuilder().getBuilder(),
                      extensionRegistry);
                  kindCase_ = 1;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int kindCase_ = 0;
      private java.lang.Object kind_;

      public KindCase getKindCase() {
        return KindCase.forNumber(kindCase_);
      }

      public Builder clearKind() {
        kindCase_ = 0;
        kind_ = null;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                  .CertificateAuthorityConfig.CertificateAuthorityServiceConfig,
              com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                  .CertificateAuthorityConfig.CertificateAuthorityServiceConfig.Builder,
              com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                  .CertificateAuthorityConfig.CertificateAuthorityServiceConfigOrBuilder>
          certificateAuthorityServiceConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Defines a CertificateAuthorityServiceConfig.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig certificate_authority_service_config = 1;
       * </code>
       *
       * @return Whether the certificateAuthorityServiceConfig field is set.
       */
      @java.lang.Override
      public boolean hasCertificateAuthorityServiceConfig() {
        return kindCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Defines a CertificateAuthorityServiceConfig.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig certificate_authority_service_config = 1;
       * </code>
       *
       * @return The certificateAuthorityServiceConfig.
       */
      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
          getCertificateAuthorityServiceConfig() {
        if (certificateAuthorityServiceConfigBuilder_ == null) {
          if (kindCase_ == 1) {
            return (com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                    .CertificateAuthorityConfig.CertificateAuthorityServiceConfig)
                kind_;
          }
          return com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig.CertificateAuthorityServiceConfig.getDefaultInstance();
        } else {
          if (kindCase_ == 1) {
            return certificateAuthorityServiceConfigBuilder_.getMessage();
          }
          return com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig.CertificateAuthorityServiceConfig.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Defines a CertificateAuthorityServiceConfig.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig certificate_authority_service_config = 1;
       * </code>
       */
      public Builder setCertificateAuthorityServiceConfig(
          com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                  .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
              value) {
        if (certificateAuthorityServiceConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          kind_ = value;
          onChanged();
        } else {
          certificateAuthorityServiceConfigBuilder_.setMessage(value);
        }
        kindCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Defines a CertificateAuthorityServiceConfig.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig certificate_authority_service_config = 1;
       * </code>
       */
      public Builder setCertificateAuthorityServiceConfig(
          com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                  .CertificateAuthorityConfig.CertificateAuthorityServiceConfig.Builder
              builderForValue) {
        if (certificateAuthorityServiceConfigBuilder_ == null) {
          kind_ = builderForValue.build();
          onChanged();
        } else {
          certificateAuthorityServiceConfigBuilder_.setMessage(builderForValue.build());
        }
        kindCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Defines a CertificateAuthorityServiceConfig.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig certificate_authority_service_config = 1;
       * </code>
       */
      public Builder mergeCertificateAuthorityServiceConfig(
          com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                  .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
              value) {
        if (certificateAuthorityServiceConfigBuilder_ == null) {
          if (kindCase_ == 1
              && kind_
                  != com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                      .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
                      .getDefaultInstance()) {
            kind_ =
                com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                    .CertificateAuthorityConfig.CertificateAuthorityServiceConfig.newBuilder(
                        (com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                                .CertificateAuthorityConfig.CertificateAuthorityServiceConfig)
                            kind_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            kind_ = value;
          }
          onChanged();
        } else {
          if (kindCase_ == 1) {
            certificateAuthorityServiceConfigBuilder_.mergeFrom(value);
          } else {
            certificateAuthorityServiceConfigBuilder_.setMessage(value);
          }
        }
        kindCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Defines a CertificateAuthorityServiceConfig.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig certificate_authority_service_config = 1;
       * </code>
       */
      public Builder clearCertificateAuthorityServiceConfig() {
        if (certificateAuthorityServiceConfigBuilder_ == null) {
          if (kindCase_ == 1) {
            kindCase_ = 0;
            kind_ = null;
            onChanged();
          }
        } else {
          if (kindCase_ == 1) {
            kindCase_ = 0;
            kind_ = null;
          }
          certificateAuthorityServiceConfigBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Defines a CertificateAuthorityServiceConfig.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig certificate_authority_service_config = 1;
       * </code>
       */
      public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig.CertificateAuthorityServiceConfig.Builder
          getCertificateAuthorityServiceConfigBuilder() {
        return getCertificateAuthorityServiceConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Defines a CertificateAuthorityServiceConfig.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig certificate_authority_service_config = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig.CertificateAuthorityServiceConfigOrBuilder
          getCertificateAuthorityServiceConfigOrBuilder() {
        if ((kindCase_ == 1) && (certificateAuthorityServiceConfigBuilder_ != null)) {
          return certificateAuthorityServiceConfigBuilder_.getMessageOrBuilder();
        } else {
          if (kindCase_ == 1) {
            return (com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                    .CertificateAuthorityConfig.CertificateAuthorityServiceConfig)
                kind_;
          }
          return com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig.CertificateAuthorityServiceConfig.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Defines a CertificateAuthorityServiceConfig.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig certificate_authority_service_config = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                  .CertificateAuthorityConfig.CertificateAuthorityServiceConfig,
              com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                  .CertificateAuthorityConfig.CertificateAuthorityServiceConfig.Builder,
              com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                  .CertificateAuthorityConfig.CertificateAuthorityServiceConfigOrBuilder>
          getCertificateAuthorityServiceConfigFieldBuilder() {
        if (certificateAuthorityServiceConfigBuilder_ == null) {
          if (!(kindCase_ == 1)) {
            kind_ =
                com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                    .CertificateAuthorityConfig.CertificateAuthorityServiceConfig
                    .getDefaultInstance();
          }
          certificateAuthorityServiceConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                      .CertificateAuthorityConfig.CertificateAuthorityServiceConfig,
                  com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                      .CertificateAuthorityConfig.CertificateAuthorityServiceConfig.Builder,
                  com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                      .CertificateAuthorityConfig.CertificateAuthorityServiceConfigOrBuilder>(
                  (com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                          .CertificateAuthorityConfig.CertificateAuthorityServiceConfig)
                      kind_,
                  getParentForChildren(),
                  isClean());
          kind_ = null;
        }
        kindCase_ = 1;
        onChanged();
        ;
        return certificateAuthorityServiceConfigBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig)
    private static final com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
              .CertificateAuthorityConfig();
    }

    public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CertificateAuthorityConfig> PARSER =
        new com.google.protobuf.AbstractParser<CertificateAuthorityConfig>() {
          @java.lang.Override
          public CertificateAuthorityConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CertificateAuthorityConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CertificateAuthorityConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * A user-defined name of the certificate issuance config.
   * CertificateIssuanceConfig names must be unique globally and match pattern
   * `projects/&#42;&#47;locations/&#42;&#47;certificateIssuanceConfigs/&#42;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A user-defined name of the certificate issuance config.
   * CertificateIssuanceConfig names must be unique globally and match pattern
   * `projects/&#42;&#47;locations/&#42;&#47;certificateIssuanceConfigs/&#42;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a CertificateIssuanceConfig.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a CertificateIssuanceConfig.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a CertificateIssuanceConfig.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a CertificateIssuanceConfig.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a CertificateIssuanceConfig.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a CertificateIssuanceConfig.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.certificatemanager.v1.CertificateIssuanceConfigProto
                .internal_static_google_cloud_certificatemanager_v1_CertificateIssuanceConfig_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Set of labels associated with a CertificateIssuanceConfig.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Set of labels associated with a CertificateIssuanceConfig.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Set of labels associated with a CertificateIssuanceConfig.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Set of labels associated with a CertificateIssuanceConfig.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 5;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * One or more paragraphs of text description of a CertificateIssuanceConfig.
   * </pre>
   *
   * <code>string description = 5;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * One or more paragraphs of text description of a CertificateIssuanceConfig.
   * </pre>
   *
   * <code>string description = 5;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CERTIFICATE_AUTHORITY_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
          .CertificateAuthorityConfig
      certificateAuthorityConfig_;
  /**
   *
   *
   * <pre>
   * Required. The CA that issues the workload certificate. It includes the CA
   * address, type, authentication to CA service, etc.
   * </pre>
   *
   * <code>
   * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig certificate_authority_config = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the certificateAuthorityConfig field is set.
   */
  @java.lang.Override
  public boolean hasCertificateAuthorityConfig() {
    return certificateAuthorityConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The CA that issues the workload certificate. It includes the CA
   * address, type, authentication to CA service, etc.
   * </pre>
   *
   * <code>
   * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig certificate_authority_config = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The certificateAuthorityConfig.
   */
  @java.lang.Override
  public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig
      getCertificateAuthorityConfig() {
    return certificateAuthorityConfig_ == null
        ? com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfig.getDefaultInstance()
        : certificateAuthorityConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. The CA that issues the workload certificate. It includes the CA
   * address, type, authentication to CA service, etc.
   * </pre>
   *
   * <code>
   * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig certificate_authority_config = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
          .CertificateAuthorityConfigOrBuilder
      getCertificateAuthorityConfigOrBuilder() {
    return getCertificateAuthorityConfig();
  }

  public static final int LIFETIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Duration lifetime_;
  /**
   *
   *
   * <pre>
   * Required. Workload certificate lifetime requested.
   * </pre>
   *
   * <code>.google.protobuf.Duration lifetime = 7 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the lifetime field is set.
   */
  @java.lang.Override
  public boolean hasLifetime() {
    return lifetime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Workload certificate lifetime requested.
   * </pre>
   *
   * <code>.google.protobuf.Duration lifetime = 7 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The lifetime.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getLifetime() {
    return lifetime_ == null ? com.google.protobuf.Duration.getDefaultInstance() : lifetime_;
  }
  /**
   *
   *
   * <pre>
   * Required. Workload certificate lifetime requested.
   * </pre>
   *
   * <code>.google.protobuf.Duration lifetime = 7 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getLifetimeOrBuilder() {
    return getLifetime();
  }

  public static final int ROTATION_WINDOW_PERCENTAGE_FIELD_NUMBER = 8;
  private int rotationWindowPercentage_;
  /**
   *
   *
   * <pre>
   * Required. Specifies the percentage of elapsed time of the certificate
   * lifetime to wait before renewing the certificate. Must be a number between
   * 1-99, inclusive.
   * </pre>
   *
   * <code>int32 rotation_window_percentage = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The rotationWindowPercentage.
   */
  @java.lang.Override
  public int getRotationWindowPercentage() {
    return rotationWindowPercentage_;
  }

  public static final int KEY_ALGORITHM_FIELD_NUMBER = 9;
  private int keyAlgorithm_;
  /**
   *
   *
   * <pre>
   * Required. The key algorithm to use when generating the private key.
   * </pre>
   *
   * <code>
   * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.KeyAlgorithm key_algorithm = 9 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for keyAlgorithm.
   */
  @java.lang.Override
  public int getKeyAlgorithmValue() {
    return keyAlgorithm_;
  }
  /**
   *
   *
   * <pre>
   * Required. The key algorithm to use when generating the private key.
   * </pre>
   *
   * <code>
   * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.KeyAlgorithm key_algorithm = 9 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The keyAlgorithm.
   */
  @java.lang.Override
  public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.KeyAlgorithm
      getKeyAlgorithm() {
    @SuppressWarnings("deprecation")
    com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.KeyAlgorithm result =
        com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.KeyAlgorithm.valueOf(
            keyAlgorithm_);
    return result == null
        ? com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.KeyAlgorithm.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(3, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, description_);
    }
    if (certificateAuthorityConfig_ != null) {
      output.writeMessage(6, getCertificateAuthorityConfig());
    }
    if (lifetime_ != null) {
      output.writeMessage(7, getLifetime());
    }
    if (rotationWindowPercentage_ != 0) {
      output.writeInt32(8, rotationWindowPercentage_);
    }
    if (keyAlgorithm_
        != com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.KeyAlgorithm
            .KEY_ALGORITHM_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(9, keyAlgorithm_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, description_);
    }
    if (certificateAuthorityConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, getCertificateAuthorityConfig());
    }
    if (lifetime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getLifetime());
    }
    if (rotationWindowPercentage_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(8, rotationWindowPercentage_);
    }
    if (keyAlgorithm_
        != com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.KeyAlgorithm
            .KEY_ALGORITHM_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, keyAlgorithm_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig other =
        (com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasCertificateAuthorityConfig() != other.hasCertificateAuthorityConfig()) return false;
    if (hasCertificateAuthorityConfig()) {
      if (!getCertificateAuthorityConfig().equals(other.getCertificateAuthorityConfig()))
        return false;
    }
    if (hasLifetime() != other.hasLifetime()) return false;
    if (hasLifetime()) {
      if (!getLifetime().equals(other.getLifetime())) return false;
    }
    if (getRotationWindowPercentage() != other.getRotationWindowPercentage()) return false;
    if (keyAlgorithm_ != other.keyAlgorithm_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasCertificateAuthorityConfig()) {
      hash = (37 * hash) + CERTIFICATE_AUTHORITY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getCertificateAuthorityConfig().hashCode();
    }
    if (hasLifetime()) {
      hash = (37 * hash) + LIFETIME_FIELD_NUMBER;
      hash = (53 * hash) + getLifetime().hashCode();
    }
    hash = (37 * hash) + ROTATION_WINDOW_PERCENTAGE_FIELD_NUMBER;
    hash = (53 * hash) + getRotationWindowPercentage();
    hash = (37 * hash) + KEY_ALGORITHM_FIELD_NUMBER;
    hash = (53 * hash) + keyAlgorithm_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * CertificateIssuanceConfig specifies how to issue and manage a certificate.
   * </pre>
   *
   * Protobuf type {@code google.cloud.certificatemanager.v1.CertificateIssuanceConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.certificatemanager.v1.CertificateIssuanceConfig)
      com.google.cloud.certificatemanager.v1.CertificateIssuanceConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.certificatemanager.v1.CertificateIssuanceConfigProto
          .internal_static_google_cloud_certificatemanager_v1_CertificateIssuanceConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.certificatemanager.v1.CertificateIssuanceConfigProto
          .internal_static_google_cloud_certificatemanager_v1_CertificateIssuanceConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.class,
              com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.Builder.class);
    }

    // Construct using com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      description_ = "";

      if (certificateAuthorityConfigBuilder_ == null) {
        certificateAuthorityConfig_ = null;
      } else {
        certificateAuthorityConfig_ = null;
        certificateAuthorityConfigBuilder_ = null;
      }
      if (lifetimeBuilder_ == null) {
        lifetime_ = null;
      } else {
        lifetime_ = null;
        lifetimeBuilder_ = null;
      }
      rotationWindowPercentage_ = 0;

      keyAlgorithm_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.certificatemanager.v1.CertificateIssuanceConfigProto
          .internal_static_google_cloud_certificatemanager_v1_CertificateIssuanceConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
        getDefaultInstanceForType() {
      return com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig build() {
      com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig buildPartial() {
      com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig result =
          new com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      result.description_ = description_;
      if (certificateAuthorityConfigBuilder_ == null) {
        result.certificateAuthorityConfig_ = certificateAuthorityConfig_;
      } else {
        result.certificateAuthorityConfig_ = certificateAuthorityConfigBuilder_.build();
      }
      if (lifetimeBuilder_ == null) {
        result.lifetime_ = lifetime_;
      } else {
        result.lifetime_ = lifetimeBuilder_.build();
      }
      result.rotationWindowPercentage_ = rotationWindowPercentage_;
      result.keyAlgorithm_ = keyAlgorithm_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig) {
        return mergeFrom((com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig other) {
      if (other
          == com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (other.hasCertificateAuthorityConfig()) {
        mergeCertificateAuthorityConfig(other.getCertificateAuthorityConfig());
      }
      if (other.hasLifetime()) {
        mergeLifetime(other.getLifetime());
      }
      if (other.getRotationWindowPercentage() != 0) {
        setRotationWindowPercentage(other.getRotationWindowPercentage());
      }
      if (other.keyAlgorithm_ != 0) {
        setKeyAlgorithmValue(other.getKeyAlgorithmValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                break;
              } // case 34
            case 42:
              {
                description_ = input.readStringRequireUtf8();

                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getCertificateAuthorityConfigFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            case 58:
              {
                input.readMessage(getLifetimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 58
            case 64:
              {
                rotationWindowPercentage_ = input.readInt32();

                break;
              } // case 64
            case 72:
              {
                keyAlgorithm_ = input.readEnum();

                break;
              } // case 72
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * A user-defined name of the certificate issuance config.
     * CertificateIssuanceConfig names must be unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;certificateIssuanceConfigs/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the certificate issuance config.
     * CertificateIssuanceConfig names must be unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;certificateIssuanceConfigs/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the certificate issuance config.
     * CertificateIssuanceConfig names must be unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;certificateIssuanceConfigs/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the certificate issuance config.
     * CertificateIssuanceConfig names must be unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;certificateIssuanceConfigs/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the certificate issuance config.
     * CertificateIssuanceConfig names must be unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;certificateIssuanceConfigs/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a CertificateIssuanceConfig.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfig
        certificateAuthorityConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                .CertificateAuthorityConfig,
            com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                .CertificateAuthorityConfig.Builder,
            com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                .CertificateAuthorityConfigOrBuilder>
        certificateAuthorityConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The CA that issues the workload certificate. It includes the CA
     * address, type, authentication to CA service, etc.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig certificate_authority_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the certificateAuthorityConfig field is set.
     */
    public boolean hasCertificateAuthorityConfig() {
      return certificateAuthorityConfigBuilder_ != null || certificateAuthorityConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The CA that issues the workload certificate. It includes the CA
     * address, type, authentication to CA service, etc.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig certificate_authority_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The certificateAuthorityConfig.
     */
    public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfig
        getCertificateAuthorityConfig() {
      if (certificateAuthorityConfigBuilder_ == null) {
        return certificateAuthorityConfig_ == null
            ? com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                .CertificateAuthorityConfig.getDefaultInstance()
            : certificateAuthorityConfig_;
      } else {
        return certificateAuthorityConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The CA that issues the workload certificate. It includes the CA
     * address, type, authentication to CA service, etc.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig certificate_authority_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setCertificateAuthorityConfig(
        com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig
            value) {
      if (certificateAuthorityConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        certificateAuthorityConfig_ = value;
        onChanged();
      } else {
        certificateAuthorityConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The CA that issues the workload certificate. It includes the CA
     * address, type, authentication to CA service, etc.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig certificate_authority_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setCertificateAuthorityConfig(
        com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig
                .Builder
            builderForValue) {
      if (certificateAuthorityConfigBuilder_ == null) {
        certificateAuthorityConfig_ = builderForValue.build();
        onChanged();
      } else {
        certificateAuthorityConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The CA that issues the workload certificate. It includes the CA
     * address, type, authentication to CA service, etc.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig certificate_authority_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeCertificateAuthorityConfig(
        com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig
            value) {
      if (certificateAuthorityConfigBuilder_ == null) {
        if (certificateAuthorityConfig_ != null) {
          certificateAuthorityConfig_ =
              com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                  .CertificateAuthorityConfig.newBuilder(certificateAuthorityConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          certificateAuthorityConfig_ = value;
        }
        onChanged();
      } else {
        certificateAuthorityConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The CA that issues the workload certificate. It includes the CA
     * address, type, authentication to CA service, etc.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig certificate_authority_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearCertificateAuthorityConfig() {
      if (certificateAuthorityConfigBuilder_ == null) {
        certificateAuthorityConfig_ = null;
        onChanged();
      } else {
        certificateAuthorityConfig_ = null;
        certificateAuthorityConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The CA that issues the workload certificate. It includes the CA
     * address, type, authentication to CA service, etc.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig certificate_authority_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfig.Builder
        getCertificateAuthorityConfigBuilder() {

      onChanged();
      return getCertificateAuthorityConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The CA that issues the workload certificate. It includes the CA
     * address, type, authentication to CA service, etc.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig certificate_authority_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
            .CertificateAuthorityConfigOrBuilder
        getCertificateAuthorityConfigOrBuilder() {
      if (certificateAuthorityConfigBuilder_ != null) {
        return certificateAuthorityConfigBuilder_.getMessageOrBuilder();
      } else {
        return certificateAuthorityConfig_ == null
            ? com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                .CertificateAuthorityConfig.getDefaultInstance()
            : certificateAuthorityConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The CA that issues the workload certificate. It includes the CA
     * address, type, authentication to CA service, etc.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig certificate_authority_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                .CertificateAuthorityConfig,
            com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                .CertificateAuthorityConfig.Builder,
            com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                .CertificateAuthorityConfigOrBuilder>
        getCertificateAuthorityConfigFieldBuilder() {
      if (certificateAuthorityConfigBuilder_ == null) {
        certificateAuthorityConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                    .CertificateAuthorityConfig,
                com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                    .CertificateAuthorityConfig.Builder,
                com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
                    .CertificateAuthorityConfigOrBuilder>(
                getCertificateAuthorityConfig(), getParentForChildren(), isClean());
        certificateAuthorityConfig_ = null;
      }
      return certificateAuthorityConfigBuilder_;
    }

    private com.google.protobuf.Duration lifetime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        lifetimeBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Workload certificate lifetime requested.
     * </pre>
     *
     * <code>.google.protobuf.Duration lifetime = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the lifetime field is set.
     */
    public boolean hasLifetime() {
      return lifetimeBuilder_ != null || lifetime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Workload certificate lifetime requested.
     * </pre>
     *
     * <code>.google.protobuf.Duration lifetime = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The lifetime.
     */
    public com.google.protobuf.Duration getLifetime() {
      if (lifetimeBuilder_ == null) {
        return lifetime_ == null ? com.google.protobuf.Duration.getDefaultInstance() : lifetime_;
      } else {
        return lifetimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Workload certificate lifetime requested.
     * </pre>
     *
     * <code>.google.protobuf.Duration lifetime = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setLifetime(com.google.protobuf.Duration value) {
      if (lifetimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lifetime_ = value;
        onChanged();
      } else {
        lifetimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Workload certificate lifetime requested.
     * </pre>
     *
     * <code>.google.protobuf.Duration lifetime = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setLifetime(com.google.protobuf.Duration.Builder builderForValue) {
      if (lifetimeBuilder_ == null) {
        lifetime_ = builderForValue.build();
        onChanged();
      } else {
        lifetimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Workload certificate lifetime requested.
     * </pre>
     *
     * <code>.google.protobuf.Duration lifetime = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeLifetime(com.google.protobuf.Duration value) {
      if (lifetimeBuilder_ == null) {
        if (lifetime_ != null) {
          lifetime_ =
              com.google.protobuf.Duration.newBuilder(lifetime_).mergeFrom(value).buildPartial();
        } else {
          lifetime_ = value;
        }
        onChanged();
      } else {
        lifetimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Workload certificate lifetime requested.
     * </pre>
     *
     * <code>.google.protobuf.Duration lifetime = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearLifetime() {
      if (lifetimeBuilder_ == null) {
        lifetime_ = null;
        onChanged();
      } else {
        lifetime_ = null;
        lifetimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Workload certificate lifetime requested.
     * </pre>
     *
     * <code>.google.protobuf.Duration lifetime = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getLifetimeBuilder() {

      onChanged();
      return getLifetimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Workload certificate lifetime requested.
     * </pre>
     *
     * <code>.google.protobuf.Duration lifetime = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getLifetimeOrBuilder() {
      if (lifetimeBuilder_ != null) {
        return lifetimeBuilder_.getMessageOrBuilder();
      } else {
        return lifetime_ == null ? com.google.protobuf.Duration.getDefaultInstance() : lifetime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Workload certificate lifetime requested.
     * </pre>
     *
     * <code>.google.protobuf.Duration lifetime = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getLifetimeFieldBuilder() {
      if (lifetimeBuilder_ == null) {
        lifetimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getLifetime(), getParentForChildren(), isClean());
        lifetime_ = null;
      }
      return lifetimeBuilder_;
    }

    private int rotationWindowPercentage_;
    /**
     *
     *
     * <pre>
     * Required. Specifies the percentage of elapsed time of the certificate
     * lifetime to wait before renewing the certificate. Must be a number between
     * 1-99, inclusive.
     * </pre>
     *
     * <code>int32 rotation_window_percentage = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The rotationWindowPercentage.
     */
    @java.lang.Override
    public int getRotationWindowPercentage() {
      return rotationWindowPercentage_;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies the percentage of elapsed time of the certificate
     * lifetime to wait before renewing the certificate. Must be a number between
     * 1-99, inclusive.
     * </pre>
     *
     * <code>int32 rotation_window_percentage = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The rotationWindowPercentage to set.
     * @return This builder for chaining.
     */
    public Builder setRotationWindowPercentage(int value) {

      rotationWindowPercentage_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies the percentage of elapsed time of the certificate
     * lifetime to wait before renewing the certificate. Must be a number between
     * 1-99, inclusive.
     * </pre>
     *
     * <code>int32 rotation_window_percentage = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRotationWindowPercentage() {

      rotationWindowPercentage_ = 0;
      onChanged();
      return this;
    }

    private int keyAlgorithm_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The key algorithm to use when generating the private key.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.KeyAlgorithm key_algorithm = 9 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for keyAlgorithm.
     */
    @java.lang.Override
    public int getKeyAlgorithmValue() {
      return keyAlgorithm_;
    }
    /**
     *
     *
     * <pre>
     * Required. The key algorithm to use when generating the private key.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.KeyAlgorithm key_algorithm = 9 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for keyAlgorithm to set.
     * @return This builder for chaining.
     */
    public Builder setKeyAlgorithmValue(int value) {

      keyAlgorithm_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The key algorithm to use when generating the private key.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.KeyAlgorithm key_algorithm = 9 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The keyAlgorithm.
     */
    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.KeyAlgorithm
        getKeyAlgorithm() {
      @SuppressWarnings("deprecation")
      com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.KeyAlgorithm result =
          com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.KeyAlgorithm.valueOf(
              keyAlgorithm_);
      return result == null
          ? com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.KeyAlgorithm
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The key algorithm to use when generating the private key.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.KeyAlgorithm key_algorithm = 9 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The keyAlgorithm to set.
     * @return This builder for chaining.
     */
    public Builder setKeyAlgorithm(
        com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig.KeyAlgorithm value) {
      if (value == null) {
        throw new NullPointerException();
      }

      keyAlgorithm_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The key algorithm to use when generating the private key.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.CertificateIssuanceConfig.KeyAlgorithm key_algorithm = 9 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKeyAlgorithm() {

      keyAlgorithm_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.certificatemanager.v1.CertificateIssuanceConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.certificatemanager.v1.CertificateIssuanceConfig)
  private static final com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig();
  }

  public static com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CertificateIssuanceConfig> PARSER =
      new com.google.protobuf.AbstractParser<CertificateIssuanceConfig>() {
        @java.lang.Override
        public CertificateIssuanceConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CertificateIssuanceConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CertificateIssuanceConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
