/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/certificatemanager/v1/certificate_manager.proto

package com.google.cloud.certificatemanager.v1;

/**
 *
 *
 * <pre>
 * Defines TLS certificate.
 * </pre>
 *
 * Protobuf type {@code google.cloud.certificatemanager.v1.Certificate}
 */
public final class Certificate extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.certificatemanager.v1.Certificate)
    CertificateOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Certificate.newBuilder() to construct.
  private Certificate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Certificate() {
    name_ = "";
    description_ = "";
    sanDnsnames_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    pemCertificate_ = "";
    scope_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Certificate();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.certificatemanager.v1.CertificateManagerProto
        .internal_static_google_cloud_certificatemanager_v1_Certificate_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.certificatemanager.v1.CertificateManagerProto
        .internal_static_google_cloud_certificatemanager_v1_Certificate_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.certificatemanager.v1.Certificate.class,
            com.google.cloud.certificatemanager.v1.Certificate.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Certificate scope.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.certificatemanager.v1.Certificate.Scope}
   */
  public enum Scope implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Certificates with default scope are served from core Google data centers.
     * If unsure, choose this option.
     * </pre>
     *
     * <code>DEFAULT = 0;</code>
     */
    DEFAULT(0),
    /**
     *
     *
     * <pre>
     * Certificates with scope EDGE_CACHE are special-purposed certificates,
     * served from non-core Google data centers.
     * </pre>
     *
     * <code>EDGE_CACHE = 1;</code>
     */
    EDGE_CACHE(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Certificates with default scope are served from core Google data centers.
     * If unsure, choose this option.
     * </pre>
     *
     * <code>DEFAULT = 0;</code>
     */
    public static final int DEFAULT_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Certificates with scope EDGE_CACHE are special-purposed certificates,
     * served from non-core Google data centers.
     * </pre>
     *
     * <code>EDGE_CACHE = 1;</code>
     */
    public static final int EDGE_CACHE_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Scope valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Scope forNumber(int value) {
      switch (value) {
        case 0:
          return DEFAULT;
        case 1:
          return EDGE_CACHE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Scope> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Scope> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Scope>() {
          public Scope findValueByNumber(int number) {
            return Scope.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.certificatemanager.v1.Certificate.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Scope[] VALUES = values();

    public static Scope valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Scope(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.certificatemanager.v1.Certificate.Scope)
  }

  public interface SelfManagedCertificateOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Input only. The PEM-encoded certificate chain.
     * Leaf certificate comes first, followed by intermediate ones if any.
     * </pre>
     *
     * <code>string pem_certificate = 1 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The pemCertificate.
     */
    java.lang.String getPemCertificate();
    /**
     *
     *
     * <pre>
     * Input only. The PEM-encoded certificate chain.
     * Leaf certificate comes first, followed by intermediate ones if any.
     * </pre>
     *
     * <code>string pem_certificate = 1 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The bytes for pemCertificate.
     */
    com.google.protobuf.ByteString getPemCertificateBytes();

    /**
     *
     *
     * <pre>
     * Input only. The PEM-encoded private key of the leaf certificate.
     * </pre>
     *
     * <code>string pem_private_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The pemPrivateKey.
     */
    java.lang.String getPemPrivateKey();
    /**
     *
     *
     * <pre>
     * Input only. The PEM-encoded private key of the leaf certificate.
     * </pre>
     *
     * <code>string pem_private_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The bytes for pemPrivateKey.
     */
    com.google.protobuf.ByteString getPemPrivateKeyBytes();
  }
  /**
   *
   *
   * <pre>
   * Certificate data for a SelfManaged Certificate.
   * SelfManaged Certificates are uploaded by the user. Updating such
   * certificates before they expire remains the user's responsibility.
   * </pre>
   *
   * Protobuf type {@code google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate}
   */
  public static final class SelfManagedCertificate extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate)
      SelfManagedCertificateOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SelfManagedCertificate.newBuilder() to construct.
    private SelfManagedCertificate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SelfManagedCertificate() {
      pemCertificate_ = "";
      pemPrivateKey_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SelfManagedCertificate();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.certificatemanager.v1.CertificateManagerProto
          .internal_static_google_cloud_certificatemanager_v1_Certificate_SelfManagedCertificate_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.certificatemanager.v1.CertificateManagerProto
          .internal_static_google_cloud_certificatemanager_v1_Certificate_SelfManagedCertificate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate.class,
              com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate.Builder
                  .class);
    }

    public static final int PEM_CERTIFICATE_FIELD_NUMBER = 1;
    private volatile java.lang.Object pemCertificate_;
    /**
     *
     *
     * <pre>
     * Input only. The PEM-encoded certificate chain.
     * Leaf certificate comes first, followed by intermediate ones if any.
     * </pre>
     *
     * <code>string pem_certificate = 1 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The pemCertificate.
     */
    @java.lang.Override
    public java.lang.String getPemCertificate() {
      java.lang.Object ref = pemCertificate_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pemCertificate_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. The PEM-encoded certificate chain.
     * Leaf certificate comes first, followed by intermediate ones if any.
     * </pre>
     *
     * <code>string pem_certificate = 1 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The bytes for pemCertificate.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPemCertificateBytes() {
      java.lang.Object ref = pemCertificate_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pemCertificate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PEM_PRIVATE_KEY_FIELD_NUMBER = 2;
    private volatile java.lang.Object pemPrivateKey_;
    /**
     *
     *
     * <pre>
     * Input only. The PEM-encoded private key of the leaf certificate.
     * </pre>
     *
     * <code>string pem_private_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The pemPrivateKey.
     */
    @java.lang.Override
    public java.lang.String getPemPrivateKey() {
      java.lang.Object ref = pemPrivateKey_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pemPrivateKey_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. The PEM-encoded private key of the leaf certificate.
     * </pre>
     *
     * <code>string pem_private_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The bytes for pemPrivateKey.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPemPrivateKeyBytes() {
      java.lang.Object ref = pemPrivateKey_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pemPrivateKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pemCertificate_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, pemCertificate_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pemPrivateKey_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, pemPrivateKey_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pemCertificate_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, pemCertificate_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pemPrivateKey_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, pemPrivateKey_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate)) {
        return super.equals(obj);
      }
      com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate other =
          (com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate) obj;

      if (!getPemCertificate().equals(other.getPemCertificate())) return false;
      if (!getPemPrivateKey().equals(other.getPemPrivateKey())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PEM_CERTIFICATE_FIELD_NUMBER;
      hash = (53 * hash) + getPemCertificate().hashCode();
      hash = (37 * hash) + PEM_PRIVATE_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getPemPrivateKey().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Certificate data for a SelfManaged Certificate.
     * SelfManaged Certificates are uploaded by the user. Updating such
     * certificates before they expire remains the user's responsibility.
     * </pre>
     *
     * Protobuf type {@code google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate)
        com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificateOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.certificatemanager.v1.CertificateManagerProto
            .internal_static_google_cloud_certificatemanager_v1_Certificate_SelfManagedCertificate_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.certificatemanager.v1.CertificateManagerProto
            .internal_static_google_cloud_certificatemanager_v1_Certificate_SelfManagedCertificate_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate.class,
                com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        pemCertificate_ = "";

        pemPrivateKey_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.certificatemanager.v1.CertificateManagerProto
            .internal_static_google_cloud_certificatemanager_v1_Certificate_SelfManagedCertificate_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
          getDefaultInstanceForType() {
        return com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate build() {
        com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
          buildPartial() {
        com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate result =
            new com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate(this);
        result.pemCertificate_ = pemCertificate_;
        result.pemPrivateKey_ = pemPrivateKey_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate) {
          return mergeFrom(
              (com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate other) {
        if (other
            == com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
                .getDefaultInstance()) return this;
        if (!other.getPemCertificate().isEmpty()) {
          pemCertificate_ = other.pemCertificate_;
          onChanged();
        }
        if (!other.getPemPrivateKey().isEmpty()) {
          pemPrivateKey_ = other.pemPrivateKey_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  pemCertificate_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  pemPrivateKey_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object pemCertificate_ = "";
      /**
       *
       *
       * <pre>
       * Input only. The PEM-encoded certificate chain.
       * Leaf certificate comes first, followed by intermediate ones if any.
       * </pre>
       *
       * <code>string pem_certificate = 1 [(.google.api.field_behavior) = INPUT_ONLY];</code>
       *
       * @return The pemCertificate.
       */
      public java.lang.String getPemCertificate() {
        java.lang.Object ref = pemCertificate_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          pemCertificate_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Input only. The PEM-encoded certificate chain.
       * Leaf certificate comes first, followed by intermediate ones if any.
       * </pre>
       *
       * <code>string pem_certificate = 1 [(.google.api.field_behavior) = INPUT_ONLY];</code>
       *
       * @return The bytes for pemCertificate.
       */
      public com.google.protobuf.ByteString getPemCertificateBytes() {
        java.lang.Object ref = pemCertificate_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          pemCertificate_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Input only. The PEM-encoded certificate chain.
       * Leaf certificate comes first, followed by intermediate ones if any.
       * </pre>
       *
       * <code>string pem_certificate = 1 [(.google.api.field_behavior) = INPUT_ONLY];</code>
       *
       * @param value The pemCertificate to set.
       * @return This builder for chaining.
       */
      public Builder setPemCertificate(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        pemCertificate_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Input only. The PEM-encoded certificate chain.
       * Leaf certificate comes first, followed by intermediate ones if any.
       * </pre>
       *
       * <code>string pem_certificate = 1 [(.google.api.field_behavior) = INPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPemCertificate() {

        pemCertificate_ = getDefaultInstance().getPemCertificate();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Input only. The PEM-encoded certificate chain.
       * Leaf certificate comes first, followed by intermediate ones if any.
       * </pre>
       *
       * <code>string pem_certificate = 1 [(.google.api.field_behavior) = INPUT_ONLY];</code>
       *
       * @param value The bytes for pemCertificate to set.
       * @return This builder for chaining.
       */
      public Builder setPemCertificateBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        pemCertificate_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object pemPrivateKey_ = "";
      /**
       *
       *
       * <pre>
       * Input only. The PEM-encoded private key of the leaf certificate.
       * </pre>
       *
       * <code>string pem_private_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
       *
       * @return The pemPrivateKey.
       */
      public java.lang.String getPemPrivateKey() {
        java.lang.Object ref = pemPrivateKey_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          pemPrivateKey_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Input only. The PEM-encoded private key of the leaf certificate.
       * </pre>
       *
       * <code>string pem_private_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
       *
       * @return The bytes for pemPrivateKey.
       */
      public com.google.protobuf.ByteString getPemPrivateKeyBytes() {
        java.lang.Object ref = pemPrivateKey_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          pemPrivateKey_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Input only. The PEM-encoded private key of the leaf certificate.
       * </pre>
       *
       * <code>string pem_private_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
       *
       * @param value The pemPrivateKey to set.
       * @return This builder for chaining.
       */
      public Builder setPemPrivateKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        pemPrivateKey_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Input only. The PEM-encoded private key of the leaf certificate.
       * </pre>
       *
       * <code>string pem_private_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPemPrivateKey() {

        pemPrivateKey_ = getDefaultInstance().getPemPrivateKey();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Input only. The PEM-encoded private key of the leaf certificate.
       * </pre>
       *
       * <code>string pem_private_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
       *
       * @param value The bytes for pemPrivateKey to set.
       * @return This builder for chaining.
       */
      public Builder setPemPrivateKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        pemPrivateKey_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate)
    private static final com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate();
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SelfManagedCertificate> PARSER =
        new com.google.protobuf.AbstractParser<SelfManagedCertificate>() {
          @java.lang.Override
          public SelfManagedCertificate parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SelfManagedCertificate> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SelfManagedCertificate> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ManagedCertificateOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.certificatemanager.v1.Certificate.ManagedCertificate)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Immutable. The domains for which a managed SSL certificate will be
     * generated. Wildcard domains are only supported with DNS challenge
     * resolution.
     * </pre>
     *
     * <code>repeated string domains = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return A list containing the domains.
     */
    java.util.List<java.lang.String> getDomainsList();
    /**
     *
     *
     * <pre>
     * Immutable. The domains for which a managed SSL certificate will be
     * generated. Wildcard domains are only supported with DNS challenge
     * resolution.
     * </pre>
     *
     * <code>repeated string domains = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The count of domains.
     */
    int getDomainsCount();
    /**
     *
     *
     * <pre>
     * Immutable. The domains for which a managed SSL certificate will be
     * generated. Wildcard domains are only supported with DNS challenge
     * resolution.
     * </pre>
     *
     * <code>repeated string domains = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param index The index of the element to return.
     * @return The domains at the given index.
     */
    java.lang.String getDomains(int index);
    /**
     *
     *
     * <pre>
     * Immutable. The domains for which a managed SSL certificate will be
     * generated. Wildcard domains are only supported with DNS challenge
     * resolution.
     * </pre>
     *
     * <code>repeated string domains = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the domains at the given index.
     */
    com.google.protobuf.ByteString getDomainsBytes(int index);

    /**
     *
     *
     * <pre>
     * Immutable. Authorizations that will be used for performing domain
     * authorization.
     * </pre>
     *
     * <code>
     * repeated string dns_authorizations = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return A list containing the dnsAuthorizations.
     */
    java.util.List<java.lang.String> getDnsAuthorizationsList();
    /**
     *
     *
     * <pre>
     * Immutable. Authorizations that will be used for performing domain
     * authorization.
     * </pre>
     *
     * <code>
     * repeated string dns_authorizations = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The count of dnsAuthorizations.
     */
    int getDnsAuthorizationsCount();
    /**
     *
     *
     * <pre>
     * Immutable. Authorizations that will be used for performing domain
     * authorization.
     * </pre>
     *
     * <code>
     * repeated string dns_authorizations = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the element to return.
     * @return The dnsAuthorizations at the given index.
     */
    java.lang.String getDnsAuthorizations(int index);
    /**
     *
     *
     * <pre>
     * Immutable. Authorizations that will be used for performing domain
     * authorization.
     * </pre>
     *
     * <code>
     * repeated string dns_authorizations = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the dnsAuthorizations at the given index.
     */
    com.google.protobuf.ByteString getDnsAuthorizationsBytes(int index);

    /**
     *
     *
     * <pre>
     * The resource name for a
     * [CertificateIssuanceConfig][google.cloud.certificatemanager.v1.CertificateIssuanceConfig]
     * used to configure private PKI certificates in the format
     * `projects/&#42;&#47;locations/&#42;&#47;certificateIssuanceConfigs/&#42;`.
     * If this field is not set, the certificates will instead be publicly
     * signed as documented at
     * https://cloud.google.com/load-balancing/docs/ssl-certificates/google-managed-certs#caa.
     * </pre>
     *
     * <code>
     * string issuance_config = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The issuanceConfig.
     */
    java.lang.String getIssuanceConfig();
    /**
     *
     *
     * <pre>
     * The resource name for a
     * [CertificateIssuanceConfig][google.cloud.certificatemanager.v1.CertificateIssuanceConfig]
     * used to configure private PKI certificates in the format
     * `projects/&#42;&#47;locations/&#42;&#47;certificateIssuanceConfigs/&#42;`.
     * If this field is not set, the certificates will instead be publicly
     * signed as documented at
     * https://cloud.google.com/load-balancing/docs/ssl-certificates/google-managed-certs#caa.
     * </pre>
     *
     * <code>
     * string issuance_config = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for issuanceConfig.
     */
    com.google.protobuf.ByteString getIssuanceConfigBytes();

    /**
     *
     *
     * <pre>
     * Output only. State of the managed certificate resource.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();
    /**
     *
     *
     * <pre>
     * Output only. State of the managed certificate resource.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State getState();

    /**
     *
     *
     * <pre>
     * Output only. Information about issues with provisioning a Managed
     * Certificate.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue provisioning_issue = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the provisioningIssue field is set.
     */
    boolean hasProvisioningIssue();
    /**
     *
     *
     * <pre>
     * Output only. Information about issues with provisioning a Managed
     * Certificate.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue provisioning_issue = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The provisioningIssue.
     */
    com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue
        getProvisioningIssue();
    /**
     *
     *
     * <pre>
     * Output only. Information about issues with provisioning a Managed
     * Certificate.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue provisioning_issue = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssueOrBuilder
        getProvisioningIssueOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. Detailed state of the latest authorization attempt for each
     * domain specified for managed certificate resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<
            com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .AuthorizationAttemptInfo>
        getAuthorizationAttemptInfoList();
    /**
     *
     *
     * <pre>
     * Output only. Detailed state of the latest authorization attempt for each
     * domain specified for managed certificate resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo
        getAuthorizationAttemptInfo(int index);
    /**
     *
     *
     * <pre>
     * Output only. Detailed state of the latest authorization attempt for each
     * domain specified for managed certificate resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    int getAuthorizationAttemptInfoCount();
    /**
     *
     *
     * <pre>
     * Output only. Detailed state of the latest authorization attempt for each
     * domain specified for managed certificate resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                    .AuthorizationAttemptInfoOrBuilder>
        getAuthorizationAttemptInfoOrBuilderList();
    /**
     *
     *
     * <pre>
     * Output only. Detailed state of the latest authorization attempt for each
     * domain specified for managed certificate resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
            .AuthorizationAttemptInfoOrBuilder
        getAuthorizationAttemptInfoOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Configuration and state of a Managed Certificate.
   * Certificate Manager provisions and renews Managed Certificates
   * automatically, for as long as it's authorized to do so.
   * </pre>
   *
   * Protobuf type {@code google.cloud.certificatemanager.v1.Certificate.ManagedCertificate}
   */
  public static final class ManagedCertificate extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.certificatemanager.v1.Certificate.ManagedCertificate)
      ManagedCertificateOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ManagedCertificate.newBuilder() to construct.
    private ManagedCertificate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ManagedCertificate() {
      domains_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      dnsAuthorizations_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      issuanceConfig_ = "";
      state_ = 0;
      authorizationAttemptInfo_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ManagedCertificate();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.certificatemanager.v1.CertificateManagerProto
          .internal_static_google_cloud_certificatemanager_v1_Certificate_ManagedCertificate_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.certificatemanager.v1.CertificateManagerProto
          .internal_static_google_cloud_certificatemanager_v1_Certificate_ManagedCertificate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.class,
              com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.Builder.class);
    }

    /**
     * Protobuf enum {@code google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State}
     */
    public enum State implements com.google.protobuf.ProtocolMessageEnum {
      /** <code>STATE_UNSPECIFIED = 0;</code> */
      STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Certificate Manager attempts to provision or renew the certificate.
       * If the process takes longer than expected, consult the
       * `provisioning_issue` field.
       * </pre>
       *
       * <code>PROVISIONING = 1;</code>
       */
      PROVISIONING(1),
      /**
       *
       *
       * <pre>
       * Multiple certificate provisioning attempts failed and Certificate
       * Manager gave up. To try again, delete and create a new managed
       * Certificate resource.
       * For details see the `provisioning_issue` field.
       * </pre>
       *
       * <code>FAILED = 2;</code>
       */
      FAILED(2),
      /**
       *
       *
       * <pre>
       * The certificate management is working, and a certificate has been
       * provisioned.
       * </pre>
       *
       * <code>ACTIVE = 3;</code>
       */
      ACTIVE(3),
      UNRECOGNIZED(-1),
      ;

      /** <code>STATE_UNSPECIFIED = 0;</code> */
      public static final int STATE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Certificate Manager attempts to provision or renew the certificate.
       * If the process takes longer than expected, consult the
       * `provisioning_issue` field.
       * </pre>
       *
       * <code>PROVISIONING = 1;</code>
       */
      public static final int PROVISIONING_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Multiple certificate provisioning attempts failed and Certificate
       * Manager gave up. To try again, delete and create a new managed
       * Certificate resource.
       * For details see the `provisioning_issue` field.
       * </pre>
       *
       * <code>FAILED = 2;</code>
       */
      public static final int FAILED_VALUE = 2;
      /**
       *
       *
       * <pre>
       * The certificate management is working, and a certificate has been
       * provisioned.
       * </pre>
       *
       * <code>ACTIVE = 3;</code>
       */
      public static final int ACTIVE_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static State valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static State forNumber(int value) {
        switch (value) {
          case 0:
            return STATE_UNSPECIFIED;
          case 1:
            return PROVISIONING;
          case 2:
            return FAILED;
          case 3:
            return ACTIVE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<State>() {
            public State findValueByNumber(int number) {
              return State.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final State[] VALUES = values();

      public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private State(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State)
    }

    public interface ProvisioningIssueOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Output only. Reason for provisioning failures.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue.Reason reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for reason.
       */
      int getReasonValue();
      /**
       *
       *
       * <pre>
       * Output only. Reason for provisioning failures.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue.Reason reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The reason.
       */
      com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue.Reason
          getReason();

      /**
       *
       *
       * <pre>
       * Output only. Human readable explanation about the issue. Provided to
       * help address the configuration issues. Not guaranteed to be stable. For
       * programmatic access use Reason enum.
       * </pre>
       *
       * <code>string details = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The details.
       */
      java.lang.String getDetails();
      /**
       *
       *
       * <pre>
       * Output only. Human readable explanation about the issue. Provided to
       * help address the configuration issues. Not guaranteed to be stable. For
       * programmatic access use Reason enum.
       * </pre>
       *
       * <code>string details = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for details.
       */
      com.google.protobuf.ByteString getDetailsBytes();
    }
    /**
     *
     *
     * <pre>
     * Information about issues with provisioning a Managed Certificate.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue}
     */
    public static final class ProvisioningIssue extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue)
        ProvisioningIssueOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ProvisioningIssue.newBuilder() to construct.
      private ProvisioningIssue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ProvisioningIssue() {
        reason_ = 0;
        details_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ProvisioningIssue();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.certificatemanager.v1.CertificateManagerProto
            .internal_static_google_cloud_certificatemanager_v1_Certificate_ManagedCertificate_ProvisioningIssue_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.certificatemanager.v1.CertificateManagerProto
            .internal_static_google_cloud_certificatemanager_v1_Certificate_ManagedCertificate_ProvisioningIssue_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                    .ProvisioningIssue.class,
                com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                    .ProvisioningIssue.Builder.class);
      }

      /**
       * Protobuf enum {@code
       * google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue.Reason}
       */
      public enum Reason implements com.google.protobuf.ProtocolMessageEnum {
        /** <code>REASON_UNSPECIFIED = 0;</code> */
        REASON_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Certificate provisioning failed due to an issue with one or more of
         * the domains on the certificate.
         * For details of which domains failed, consult the
         * `authorization_attempt_info` field.
         * </pre>
         *
         * <code>AUTHORIZATION_ISSUE = 1;</code>
         */
        AUTHORIZATION_ISSUE(1),
        /**
         *
         *
         * <pre>
         * Exceeded Certificate Authority quotas or internal rate limits of the
         * system. Provisioning may take longer to complete.
         * </pre>
         *
         * <code>RATE_LIMITED = 2;</code>
         */
        RATE_LIMITED(2),
        UNRECOGNIZED(-1),
        ;

        /** <code>REASON_UNSPECIFIED = 0;</code> */
        public static final int REASON_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * Certificate provisioning failed due to an issue with one or more of
         * the domains on the certificate.
         * For details of which domains failed, consult the
         * `authorization_attempt_info` field.
         * </pre>
         *
         * <code>AUTHORIZATION_ISSUE = 1;</code>
         */
        public static final int AUTHORIZATION_ISSUE_VALUE = 1;
        /**
         *
         *
         * <pre>
         * Exceeded Certificate Authority quotas or internal rate limits of the
         * system. Provisioning may take longer to complete.
         * </pre>
         *
         * <code>RATE_LIMITED = 2;</code>
         */
        public static final int RATE_LIMITED_VALUE = 2;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static Reason valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static Reason forNumber(int value) {
          switch (value) {
            case 0:
              return REASON_UNSPECIFIED;
            case 1:
              return AUTHORIZATION_ISSUE;
            case 2:
              return RATE_LIMITED;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<Reason> internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<Reason> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Reason>() {
              public Reason findValueByNumber(int number) {
                return Reason.forNumber(number);
              }
            };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .ProvisioningIssue.getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final Reason[] VALUES = values();

        public static Reason valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private Reason(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue.Reason)
      }

      public static final int REASON_FIELD_NUMBER = 1;
      private int reason_;
      /**
       *
       *
       * <pre>
       * Output only. Reason for provisioning failures.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue.Reason reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for reason.
       */
      @java.lang.Override
      public int getReasonValue() {
        return reason_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Reason for provisioning failures.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue.Reason reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The reason.
       */
      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue
              .Reason
          getReason() {
        @SuppressWarnings("deprecation")
        com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue
                .Reason
            result =
                com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                    .ProvisioningIssue.Reason.valueOf(reason_);
        return result == null
            ? com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .ProvisioningIssue.Reason.UNRECOGNIZED
            : result;
      }

      public static final int DETAILS_FIELD_NUMBER = 2;
      private volatile java.lang.Object details_;
      /**
       *
       *
       * <pre>
       * Output only. Human readable explanation about the issue. Provided to
       * help address the configuration issues. Not guaranteed to be stable. For
       * programmatic access use Reason enum.
       * </pre>
       *
       * <code>string details = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The details.
       */
      @java.lang.Override
      public java.lang.String getDetails() {
        java.lang.Object ref = details_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          details_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Human readable explanation about the issue. Provided to
       * help address the configuration issues. Not guaranteed to be stable. For
       * programmatic access use Reason enum.
       * </pre>
       *
       * <code>string details = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for details.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDetailsBytes() {
        java.lang.Object ref = details_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          details_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (reason_
            != com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .ProvisioningIssue.Reason.REASON_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(1, reason_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(details_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, details_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (reason_
            != com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .ProvisioningIssue.Reason.REASON_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, reason_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(details_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, details_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .ProvisioningIssue)) {
          return super.equals(obj);
        }
        com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue
            other =
                (com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                        .ProvisioningIssue)
                    obj;

        if (reason_ != other.reason_) return false;
        if (!getDetails().equals(other.getDetails())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + REASON_FIELD_NUMBER;
        hash = (53 * hash) + reason_;
        hash = (37 * hash) + DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getDetails().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .ProvisioningIssue
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .ProvisioningIssue
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .ProvisioningIssue
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .ProvisioningIssue
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .ProvisioningIssue
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .ProvisioningIssue
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .ProvisioningIssue
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .ProvisioningIssue
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .ProvisioningIssue
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .ProvisioningIssue
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .ProvisioningIssue
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .ProvisioningIssue
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Information about issues with provisioning a Managed Certificate.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue)
          com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .ProvisioningIssueOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.certificatemanager.v1.CertificateManagerProto
              .internal_static_google_cloud_certificatemanager_v1_Certificate_ManagedCertificate_ProvisioningIssue_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.certificatemanager.v1.CertificateManagerProto
              .internal_static_google_cloud_certificatemanager_v1_Certificate_ManagedCertificate_ProvisioningIssue_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                      .ProvisioningIssue.class,
                  com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                      .ProvisioningIssue.Builder.class);
        }

        // Construct using
        // com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          reason_ = 0;

          details_ = "";

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.certificatemanager.v1.CertificateManagerProto
              .internal_static_google_cloud_certificatemanager_v1_Certificate_ManagedCertificate_ProvisioningIssue_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .ProvisioningIssue
            getDefaultInstanceForType() {
          return com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .ProvisioningIssue.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .ProvisioningIssue
            build() {
          com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .ProvisioningIssue
            buildPartial() {
          com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue
              result =
                  new com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                      .ProvisioningIssue(this);
          result.reason_ = reason_;
          result.details_ = details_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .ProvisioningIssue) {
            return mergeFrom(
                (com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                        .ProvisioningIssue)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue
                other) {
          if (other
              == com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .ProvisioningIssue.getDefaultInstance()) return this;
          if (other.reason_ != 0) {
            setReasonValue(other.getReasonValue());
          }
          if (!other.getDetails().isEmpty()) {
            details_ = other.details_;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    reason_ = input.readEnum();

                    break;
                  } // case 8
                case 18:
                  {
                    details_ = input.readStringRequireUtf8();

                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int reason_ = 0;
        /**
         *
         *
         * <pre>
         * Output only. Reason for provisioning failures.
         * </pre>
         *
         * <code>
         * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue.Reason reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @return The enum numeric value on the wire for reason.
         */
        @java.lang.Override
        public int getReasonValue() {
          return reason_;
        }
        /**
         *
         *
         * <pre>
         * Output only. Reason for provisioning failures.
         * </pre>
         *
         * <code>
         * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue.Reason reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @param value The enum numeric value on the wire for reason to set.
         * @return This builder for chaining.
         */
        public Builder setReasonValue(int value) {

          reason_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Reason for provisioning failures.
         * </pre>
         *
         * <code>
         * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue.Reason reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @return The reason.
         */
        @java.lang.Override
        public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .ProvisioningIssue.Reason
            getReason() {
          @SuppressWarnings("deprecation")
          com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue
                  .Reason
              result =
                  com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                      .ProvisioningIssue.Reason.valueOf(reason_);
          return result == null
              ? com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .ProvisioningIssue.Reason.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * Output only. Reason for provisioning failures.
         * </pre>
         *
         * <code>
         * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue.Reason reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @param value The reason to set.
         * @return This builder for chaining.
         */
        public Builder setReason(
            com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue
                    .Reason
                value) {
          if (value == null) {
            throw new NullPointerException();
          }

          reason_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Reason for provisioning failures.
         * </pre>
         *
         * <code>
         * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue.Reason reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearReason() {

          reason_ = 0;
          onChanged();
          return this;
        }

        private java.lang.Object details_ = "";
        /**
         *
         *
         * <pre>
         * Output only. Human readable explanation about the issue. Provided to
         * help address the configuration issues. Not guaranteed to be stable. For
         * programmatic access use Reason enum.
         * </pre>
         *
         * <code>string details = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @return The details.
         */
        public java.lang.String getDetails() {
          java.lang.Object ref = details_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            details_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Output only. Human readable explanation about the issue. Provided to
         * help address the configuration issues. Not guaranteed to be stable. For
         * programmatic access use Reason enum.
         * </pre>
         *
         * <code>string details = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @return The bytes for details.
         */
        public com.google.protobuf.ByteString getDetailsBytes() {
          java.lang.Object ref = details_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            details_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Output only. Human readable explanation about the issue. Provided to
         * help address the configuration issues. Not guaranteed to be stable. For
         * programmatic access use Reason enum.
         * </pre>
         *
         * <code>string details = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @param value The details to set.
         * @return This builder for chaining.
         */
        public Builder setDetails(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          details_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Human readable explanation about the issue. Provided to
         * help address the configuration issues. Not guaranteed to be stable. For
         * programmatic access use Reason enum.
         * </pre>
         *
         * <code>string details = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDetails() {

          details_ = getDefaultInstance().getDetails();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Human readable explanation about the issue. Provided to
         * help address the configuration issues. Not guaranteed to be stable. For
         * programmatic access use Reason enum.
         * </pre>
         *
         * <code>string details = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @param value The bytes for details to set.
         * @return This builder for chaining.
         */
        public Builder setDetailsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          details_ = value;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue)
      private static final com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .ProvisioningIssue
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .ProvisioningIssue();
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .ProvisioningIssue
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ProvisioningIssue> PARSER =
          new com.google.protobuf.AbstractParser<ProvisioningIssue>() {
            @java.lang.Override
            public ProvisioningIssue parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ProvisioningIssue> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ProvisioningIssue> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface AuthorizationAttemptInfoOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Domain name of the authorization attempt.
       * </pre>
       *
       * <code>string domain = 1;</code>
       *
       * @return The domain.
       */
      java.lang.String getDomain();
      /**
       *
       *
       * <pre>
       * Domain name of the authorization attempt.
       * </pre>
       *
       * <code>string domain = 1;</code>
       *
       * @return The bytes for domain.
       */
      com.google.protobuf.ByteString getDomainBytes();

      /**
       *
       *
       * <pre>
       * Output only. State of the domain for managed certificate issuance.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      int getStateValue();
      /**
       *
       *
       * <pre>
       * Output only. State of the domain for managed certificate issuance.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The state.
       */
      com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo
              .State
          getState();

      /**
       *
       *
       * <pre>
       * Output only. Reason for failure of the authorization attempt for the
       * domain.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.FailureReason failure_reason = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for failureReason.
       */
      int getFailureReasonValue();
      /**
       *
       *
       * <pre>
       * Output only. Reason for failure of the authorization attempt for the
       * domain.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.FailureReason failure_reason = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The failureReason.
       */
      com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo
              .FailureReason
          getFailureReason();

      /**
       *
       *
       * <pre>
       * Output only. Human readable explanation for reaching the state.
       * Provided to help address the configuration issues. Not guaranteed to be
       * stable. For programmatic access use FailureReason enum.
       * </pre>
       *
       * <code>string details = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The details.
       */
      java.lang.String getDetails();
      /**
       *
       *
       * <pre>
       * Output only. Human readable explanation for reaching the state.
       * Provided to help address the configuration issues. Not guaranteed to be
       * stable. For programmatic access use FailureReason enum.
       * </pre>
       *
       * <code>string details = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for details.
       */
      com.google.protobuf.ByteString getDetailsBytes();
    }
    /**
     *
     *
     * <pre>
     * State of the latest attempt to authorize a domain for certificate
     * issuance.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo}
     */
    public static final class AuthorizationAttemptInfo
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo)
        AuthorizationAttemptInfoOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use AuthorizationAttemptInfo.newBuilder() to construct.
      private AuthorizationAttemptInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private AuthorizationAttemptInfo() {
        domain_ = "";
        state_ = 0;
        failureReason_ = 0;
        details_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new AuthorizationAttemptInfo();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.certificatemanager.v1.CertificateManagerProto
            .internal_static_google_cloud_certificatemanager_v1_Certificate_ManagedCertificate_AuthorizationAttemptInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.certificatemanager.v1.CertificateManagerProto
            .internal_static_google_cloud_certificatemanager_v1_Certificate_ManagedCertificate_AuthorizationAttemptInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                    .AuthorizationAttemptInfo.class,
                com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                    .AuthorizationAttemptInfo.Builder.class);
      }

      /**
       * Protobuf enum {@code
       * google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.State}
       */
      public enum State implements com.google.protobuf.ProtocolMessageEnum {
        /** <code>STATE_UNSPECIFIED = 0;</code> */
        STATE_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Certificate provisioning for this domain is under way. GCP will
         * attempt to authorize the domain.
         * </pre>
         *
         * <code>AUTHORIZING = 1;</code>
         */
        AUTHORIZING(1),
        /**
         *
         *
         * <pre>
         * A managed certificate can be provisioned, no issues for this domain.
         * </pre>
         *
         * <code>AUTHORIZED = 6;</code>
         */
        AUTHORIZED(6),
        /**
         *
         *
         * <pre>
         * Attempt to authorize the domain failed. This prevents the Managed
         * Certificate from being issued.
         * See `failure_reason` and `details` fields for more information.
         * </pre>
         *
         * <code>FAILED = 7;</code>
         */
        FAILED(7),
        UNRECOGNIZED(-1),
        ;

        /** <code>STATE_UNSPECIFIED = 0;</code> */
        public static final int STATE_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * Certificate provisioning for this domain is under way. GCP will
         * attempt to authorize the domain.
         * </pre>
         *
         * <code>AUTHORIZING = 1;</code>
         */
        public static final int AUTHORIZING_VALUE = 1;
        /**
         *
         *
         * <pre>
         * A managed certificate can be provisioned, no issues for this domain.
         * </pre>
         *
         * <code>AUTHORIZED = 6;</code>
         */
        public static final int AUTHORIZED_VALUE = 6;
        /**
         *
         *
         * <pre>
         * Attempt to authorize the domain failed. This prevents the Managed
         * Certificate from being issued.
         * See `failure_reason` and `details` fields for more information.
         * </pre>
         *
         * <code>FAILED = 7;</code>
         */
        public static final int FAILED_VALUE = 7;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static State valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static State forNumber(int value) {
          switch (value) {
            case 0:
              return STATE_UNSPECIFIED;
            case 1:
              return AUTHORIZING;
            case 6:
              return AUTHORIZED;
            case 7:
              return FAILED;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<State>() {
              public State findValueByNumber(int number) {
                return State.forNumber(number);
              }
            };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfo.getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final State[] VALUES = values();

        public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private State(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.State)
      }

      /**
       * Protobuf enum {@code
       * google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.FailureReason}
       */
      public enum FailureReason implements com.google.protobuf.ProtocolMessageEnum {
        /** <code>FAILURE_REASON_UNSPECIFIED = 0;</code> */
        FAILURE_REASON_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * There was a problem with the user's DNS or load balancer
         * configuration for this domain.
         * </pre>
         *
         * <code>CONFIG = 1;</code>
         */
        CONFIG(1),
        /**
         *
         *
         * <pre>
         * Certificate issuance forbidden by an explicit CAA record for the
         * domain or a failure to check CAA records for the domain.
         * </pre>
         *
         * <code>CAA = 2;</code>
         */
        CAA(2),
        /**
         *
         *
         * <pre>
         * Reached a CA or internal rate-limit for the domain,
         * e.g. for certificates per top-level private domain.
         * </pre>
         *
         * <code>RATE_LIMITED = 3;</code>
         */
        RATE_LIMITED(3),
        UNRECOGNIZED(-1),
        ;

        /** <code>FAILURE_REASON_UNSPECIFIED = 0;</code> */
        public static final int FAILURE_REASON_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * There was a problem with the user's DNS or load balancer
         * configuration for this domain.
         * </pre>
         *
         * <code>CONFIG = 1;</code>
         */
        public static final int CONFIG_VALUE = 1;
        /**
         *
         *
         * <pre>
         * Certificate issuance forbidden by an explicit CAA record for the
         * domain or a failure to check CAA records for the domain.
         * </pre>
         *
         * <code>CAA = 2;</code>
         */
        public static final int CAA_VALUE = 2;
        /**
         *
         *
         * <pre>
         * Reached a CA or internal rate-limit for the domain,
         * e.g. for certificates per top-level private domain.
         * </pre>
         *
         * <code>RATE_LIMITED = 3;</code>
         */
        public static final int RATE_LIMITED_VALUE = 3;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static FailureReason valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static FailureReason forNumber(int value) {
          switch (value) {
            case 0:
              return FAILURE_REASON_UNSPECIFIED;
            case 1:
              return CONFIG;
            case 2:
              return CAA;
            case 3:
              return RATE_LIMITED;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<FailureReason>
            internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<FailureReason>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<FailureReason>() {
                  public FailureReason findValueByNumber(int number) {
                    return FailureReason.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfo.getDescriptor()
              .getEnumTypes()
              .get(1);
        }

        private static final FailureReason[] VALUES = values();

        public static FailureReason valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private FailureReason(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.FailureReason)
      }

      public static final int DOMAIN_FIELD_NUMBER = 1;
      private volatile java.lang.Object domain_;
      /**
       *
       *
       * <pre>
       * Domain name of the authorization attempt.
       * </pre>
       *
       * <code>string domain = 1;</code>
       *
       * @return The domain.
       */
      @java.lang.Override
      public java.lang.String getDomain() {
        java.lang.Object ref = domain_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          domain_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Domain name of the authorization attempt.
       * </pre>
       *
       * <code>string domain = 1;</code>
       *
       * @return The bytes for domain.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDomainBytes() {
        java.lang.Object ref = domain_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          domain_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int STATE_FIELD_NUMBER = 2;
      private int state_;
      /**
       *
       *
       * <pre>
       * Output only. State of the domain for managed certificate issuance.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }
      /**
       *
       *
       * <pre>
       * Output only. State of the domain for managed certificate issuance.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfo.State
          getState() {
        @SuppressWarnings("deprecation")
        com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .AuthorizationAttemptInfo.State
            result =
                com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                    .AuthorizationAttemptInfo.State.valueOf(state_);
        return result == null
            ? com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .AuthorizationAttemptInfo.State.UNRECOGNIZED
            : result;
      }

      public static final int FAILURE_REASON_FIELD_NUMBER = 3;
      private int failureReason_;
      /**
       *
       *
       * <pre>
       * Output only. Reason for failure of the authorization attempt for the
       * domain.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.FailureReason failure_reason = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for failureReason.
       */
      @java.lang.Override
      public int getFailureReasonValue() {
        return failureReason_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Reason for failure of the authorization attempt for the
       * domain.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.FailureReason failure_reason = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The failureReason.
       */
      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfo.FailureReason
          getFailureReason() {
        @SuppressWarnings("deprecation")
        com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .AuthorizationAttemptInfo.FailureReason
            result =
                com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                    .AuthorizationAttemptInfo.FailureReason.valueOf(failureReason_);
        return result == null
            ? com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .AuthorizationAttemptInfo.FailureReason.UNRECOGNIZED
            : result;
      }

      public static final int DETAILS_FIELD_NUMBER = 4;
      private volatile java.lang.Object details_;
      /**
       *
       *
       * <pre>
       * Output only. Human readable explanation for reaching the state.
       * Provided to help address the configuration issues. Not guaranteed to be
       * stable. For programmatic access use FailureReason enum.
       * </pre>
       *
       * <code>string details = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The details.
       */
      @java.lang.Override
      public java.lang.String getDetails() {
        java.lang.Object ref = details_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          details_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Human readable explanation for reaching the state.
       * Provided to help address the configuration issues. Not guaranteed to be
       * stable. For programmatic access use FailureReason enum.
       * </pre>
       *
       * <code>string details = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for details.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDetailsBytes() {
        java.lang.Object ref = details_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          details_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(domain_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, domain_);
        }
        if (state_
            != com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .AuthorizationAttemptInfo.State.STATE_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(2, state_);
        }
        if (failureReason_
            != com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .AuthorizationAttemptInfo.FailureReason.FAILURE_REASON_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(3, failureReason_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(details_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, details_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(domain_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, domain_);
        }
        if (state_
            != com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .AuthorizationAttemptInfo.State.STATE_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, state_);
        }
        if (failureReason_
            != com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .AuthorizationAttemptInfo.FailureReason.FAILURE_REASON_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, failureReason_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(details_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, details_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .AuthorizationAttemptInfo)) {
          return super.equals(obj);
        }
        com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .AuthorizationAttemptInfo
            other =
                (com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                        .AuthorizationAttemptInfo)
                    obj;

        if (!getDomain().equals(other.getDomain())) return false;
        if (state_ != other.state_) return false;
        if (failureReason_ != other.failureReason_) return false;
        if (!getDetails().equals(other.getDetails())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + DOMAIN_FIELD_NUMBER;
        hash = (53 * hash) + getDomain().hashCode();
        hash = (37 * hash) + STATE_FIELD_NUMBER;
        hash = (53 * hash) + state_;
        hash = (37 * hash) + FAILURE_REASON_FIELD_NUMBER;
        hash = (53 * hash) + failureReason_;
        hash = (37 * hash) + DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getDetails().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfo
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfo
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfo
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfo
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfo
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfo
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfo
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfo
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfo
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfo
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfo
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfo
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .AuthorizationAttemptInfo
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * State of the latest attempt to authorize a domain for certificate
       * issuance.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo)
          com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfoOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.certificatemanager.v1.CertificateManagerProto
              .internal_static_google_cloud_certificatemanager_v1_Certificate_ManagedCertificate_AuthorizationAttemptInfo_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.certificatemanager.v1.CertificateManagerProto
              .internal_static_google_cloud_certificatemanager_v1_Certificate_ManagedCertificate_AuthorizationAttemptInfo_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                      .AuthorizationAttemptInfo.class,
                  com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                      .AuthorizationAttemptInfo.Builder.class);
        }

        // Construct using
        // com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          domain_ = "";

          state_ = 0;

          failureReason_ = 0;

          details_ = "";

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.certificatemanager.v1.CertificateManagerProto
              .internal_static_google_cloud_certificatemanager_v1_Certificate_ManagedCertificate_AuthorizationAttemptInfo_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .AuthorizationAttemptInfo
            getDefaultInstanceForType() {
          return com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfo.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .AuthorizationAttemptInfo
            build() {
          com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .AuthorizationAttemptInfo
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .AuthorizationAttemptInfo
            buildPartial() {
          com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .AuthorizationAttemptInfo
              result =
                  new com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                      .AuthorizationAttemptInfo(this);
          result.domain_ = domain_;
          result.state_ = state_;
          result.failureReason_ = failureReason_;
          result.details_ = details_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .AuthorizationAttemptInfo) {
            return mergeFrom(
                (com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                        .AuthorizationAttemptInfo)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                    .AuthorizationAttemptInfo
                other) {
          if (other
              == com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .AuthorizationAttemptInfo.getDefaultInstance()) return this;
          if (!other.getDomain().isEmpty()) {
            domain_ = other.domain_;
            onChanged();
          }
          if (other.state_ != 0) {
            setStateValue(other.getStateValue());
          }
          if (other.failureReason_ != 0) {
            setFailureReasonValue(other.getFailureReasonValue());
          }
          if (!other.getDetails().isEmpty()) {
            details_ = other.details_;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    domain_ = input.readStringRequireUtf8();

                    break;
                  } // case 10
                case 16:
                  {
                    state_ = input.readEnum();

                    break;
                  } // case 16
                case 24:
                  {
                    failureReason_ = input.readEnum();

                    break;
                  } // case 24
                case 34:
                  {
                    details_ = input.readStringRequireUtf8();

                    break;
                  } // case 34
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private java.lang.Object domain_ = "";
        /**
         *
         *
         * <pre>
         * Domain name of the authorization attempt.
         * </pre>
         *
         * <code>string domain = 1;</code>
         *
         * @return The domain.
         */
        public java.lang.String getDomain() {
          java.lang.Object ref = domain_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            domain_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Domain name of the authorization attempt.
         * </pre>
         *
         * <code>string domain = 1;</code>
         *
         * @return The bytes for domain.
         */
        public com.google.protobuf.ByteString getDomainBytes() {
          java.lang.Object ref = domain_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            domain_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Domain name of the authorization attempt.
         * </pre>
         *
         * <code>string domain = 1;</code>
         *
         * @param value The domain to set.
         * @return This builder for chaining.
         */
        public Builder setDomain(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          domain_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Domain name of the authorization attempt.
         * </pre>
         *
         * <code>string domain = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDomain() {

          domain_ = getDefaultInstance().getDomain();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Domain name of the authorization attempt.
         * </pre>
         *
         * <code>string domain = 1;</code>
         *
         * @param value The bytes for domain to set.
         * @return This builder for chaining.
         */
        public Builder setDomainBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          domain_ = value;
          onChanged();
          return this;
        }

        private int state_ = 0;
        /**
         *
         *
         * <pre>
         * Output only. State of the domain for managed certificate issuance.
         * </pre>
         *
         * <code>
         * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @return The enum numeric value on the wire for state.
         */
        @java.lang.Override
        public int getStateValue() {
          return state_;
        }
        /**
         *
         *
         * <pre>
         * Output only. State of the domain for managed certificate issuance.
         * </pre>
         *
         * <code>
         * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @param value The enum numeric value on the wire for state to set.
         * @return This builder for chaining.
         */
        public Builder setStateValue(int value) {

          state_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. State of the domain for managed certificate issuance.
         * </pre>
         *
         * <code>
         * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @return The state.
         */
        @java.lang.Override
        public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .AuthorizationAttemptInfo.State
            getState() {
          @SuppressWarnings("deprecation")
          com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .AuthorizationAttemptInfo.State
              result =
                  com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                      .AuthorizationAttemptInfo.State.valueOf(state_);
          return result == null
              ? com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .AuthorizationAttemptInfo.State.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * Output only. State of the domain for managed certificate issuance.
         * </pre>
         *
         * <code>
         * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @param value The state to set.
         * @return This builder for chaining.
         */
        public Builder setState(
            com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                    .AuthorizationAttemptInfo.State
                value) {
          if (value == null) {
            throw new NullPointerException();
          }

          state_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. State of the domain for managed certificate issuance.
         * </pre>
         *
         * <code>
         * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearState() {

          state_ = 0;
          onChanged();
          return this;
        }

        private int failureReason_ = 0;
        /**
         *
         *
         * <pre>
         * Output only. Reason for failure of the authorization attempt for the
         * domain.
         * </pre>
         *
         * <code>
         * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.FailureReason failure_reason = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @return The enum numeric value on the wire for failureReason.
         */
        @java.lang.Override
        public int getFailureReasonValue() {
          return failureReason_;
        }
        /**
         *
         *
         * <pre>
         * Output only. Reason for failure of the authorization attempt for the
         * domain.
         * </pre>
         *
         * <code>
         * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.FailureReason failure_reason = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @param value The enum numeric value on the wire for failureReason to set.
         * @return This builder for chaining.
         */
        public Builder setFailureReasonValue(int value) {

          failureReason_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Reason for failure of the authorization attempt for the
         * domain.
         * </pre>
         *
         * <code>
         * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.FailureReason failure_reason = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @return The failureReason.
         */
        @java.lang.Override
        public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .AuthorizationAttemptInfo.FailureReason
            getFailureReason() {
          @SuppressWarnings("deprecation")
          com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .AuthorizationAttemptInfo.FailureReason
              result =
                  com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                      .AuthorizationAttemptInfo.FailureReason.valueOf(failureReason_);
          return result == null
              ? com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .AuthorizationAttemptInfo.FailureReason.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * Output only. Reason for failure of the authorization attempt for the
         * domain.
         * </pre>
         *
         * <code>
         * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.FailureReason failure_reason = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @param value The failureReason to set.
         * @return This builder for chaining.
         */
        public Builder setFailureReason(
            com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                    .AuthorizationAttemptInfo.FailureReason
                value) {
          if (value == null) {
            throw new NullPointerException();
          }

          failureReason_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Reason for failure of the authorization attempt for the
         * domain.
         * </pre>
         *
         * <code>
         * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.FailureReason failure_reason = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFailureReason() {

          failureReason_ = 0;
          onChanged();
          return this;
        }

        private java.lang.Object details_ = "";
        /**
         *
         *
         * <pre>
         * Output only. Human readable explanation for reaching the state.
         * Provided to help address the configuration issues. Not guaranteed to be
         * stable. For programmatic access use FailureReason enum.
         * </pre>
         *
         * <code>string details = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @return The details.
         */
        public java.lang.String getDetails() {
          java.lang.Object ref = details_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            details_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Output only. Human readable explanation for reaching the state.
         * Provided to help address the configuration issues. Not guaranteed to be
         * stable. For programmatic access use FailureReason enum.
         * </pre>
         *
         * <code>string details = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @return The bytes for details.
         */
        public com.google.protobuf.ByteString getDetailsBytes() {
          java.lang.Object ref = details_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            details_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Output only. Human readable explanation for reaching the state.
         * Provided to help address the configuration issues. Not guaranteed to be
         * stable. For programmatic access use FailureReason enum.
         * </pre>
         *
         * <code>string details = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @param value The details to set.
         * @return This builder for chaining.
         */
        public Builder setDetails(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          details_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Human readable explanation for reaching the state.
         * Provided to help address the configuration issues. Not guaranteed to be
         * stable. For programmatic access use FailureReason enum.
         * </pre>
         *
         * <code>string details = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDetails() {

          details_ = getDefaultInstance().getDetails();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Human readable explanation for reaching the state.
         * Provided to help address the configuration issues. Not guaranteed to be
         * stable. For programmatic access use FailureReason enum.
         * </pre>
         *
         * <code>string details = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @param value The bytes for details to set.
         * @return This builder for chaining.
         */
        public Builder setDetailsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          details_ = value;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo)
      private static final com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfo
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .AuthorizationAttemptInfo();
      }

      public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfo
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<AuthorizationAttemptInfo> PARSER =
          new com.google.protobuf.AbstractParser<AuthorizationAttemptInfo>() {
            @java.lang.Override
            public AuthorizationAttemptInfo parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<AuthorizationAttemptInfo> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<AuthorizationAttemptInfo> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfo
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int DOMAINS_FIELD_NUMBER = 1;
    private com.google.protobuf.LazyStringList domains_;
    /**
     *
     *
     * <pre>
     * Immutable. The domains for which a managed SSL certificate will be
     * generated. Wildcard domains are only supported with DNS challenge
     * resolution.
     * </pre>
     *
     * <code>repeated string domains = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return A list containing the domains.
     */
    public com.google.protobuf.ProtocolStringList getDomainsList() {
      return domains_;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The domains for which a managed SSL certificate will be
     * generated. Wildcard domains are only supported with DNS challenge
     * resolution.
     * </pre>
     *
     * <code>repeated string domains = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The count of domains.
     */
    public int getDomainsCount() {
      return domains_.size();
    }
    /**
     *
     *
     * <pre>
     * Immutable. The domains for which a managed SSL certificate will be
     * generated. Wildcard domains are only supported with DNS challenge
     * resolution.
     * </pre>
     *
     * <code>repeated string domains = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param index The index of the element to return.
     * @return The domains at the given index.
     */
    public java.lang.String getDomains(int index) {
      return domains_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Immutable. The domains for which a managed SSL certificate will be
     * generated. Wildcard domains are only supported with DNS challenge
     * resolution.
     * </pre>
     *
     * <code>repeated string domains = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the domains at the given index.
     */
    public com.google.protobuf.ByteString getDomainsBytes(int index) {
      return domains_.getByteString(index);
    }

    public static final int DNS_AUTHORIZATIONS_FIELD_NUMBER = 2;
    private com.google.protobuf.LazyStringList dnsAuthorizations_;
    /**
     *
     *
     * <pre>
     * Immutable. Authorizations that will be used for performing domain
     * authorization.
     * </pre>
     *
     * <code>
     * repeated string dns_authorizations = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return A list containing the dnsAuthorizations.
     */
    public com.google.protobuf.ProtocolStringList getDnsAuthorizationsList() {
      return dnsAuthorizations_;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Authorizations that will be used for performing domain
     * authorization.
     * </pre>
     *
     * <code>
     * repeated string dns_authorizations = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The count of dnsAuthorizations.
     */
    public int getDnsAuthorizationsCount() {
      return dnsAuthorizations_.size();
    }
    /**
     *
     *
     * <pre>
     * Immutable. Authorizations that will be used for performing domain
     * authorization.
     * </pre>
     *
     * <code>
     * repeated string dns_authorizations = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the element to return.
     * @return The dnsAuthorizations at the given index.
     */
    public java.lang.String getDnsAuthorizations(int index) {
      return dnsAuthorizations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Immutable. Authorizations that will be used for performing domain
     * authorization.
     * </pre>
     *
     * <code>
     * repeated string dns_authorizations = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the dnsAuthorizations at the given index.
     */
    public com.google.protobuf.ByteString getDnsAuthorizationsBytes(int index) {
      return dnsAuthorizations_.getByteString(index);
    }

    public static final int ISSUANCE_CONFIG_FIELD_NUMBER = 6;
    private volatile java.lang.Object issuanceConfig_;
    /**
     *
     *
     * <pre>
     * The resource name for a
     * [CertificateIssuanceConfig][google.cloud.certificatemanager.v1.CertificateIssuanceConfig]
     * used to configure private PKI certificates in the format
     * `projects/&#42;&#47;locations/&#42;&#47;certificateIssuanceConfigs/&#42;`.
     * If this field is not set, the certificates will instead be publicly
     * signed as documented at
     * https://cloud.google.com/load-balancing/docs/ssl-certificates/google-managed-certs#caa.
     * </pre>
     *
     * <code>
     * string issuance_config = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The issuanceConfig.
     */
    @java.lang.Override
    public java.lang.String getIssuanceConfig() {
      java.lang.Object ref = issuanceConfig_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        issuanceConfig_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name for a
     * [CertificateIssuanceConfig][google.cloud.certificatemanager.v1.CertificateIssuanceConfig]
     * used to configure private PKI certificates in the format
     * `projects/&#42;&#47;locations/&#42;&#47;certificateIssuanceConfigs/&#42;`.
     * If this field is not set, the certificates will instead be publicly
     * signed as documented at
     * https://cloud.google.com/load-balancing/docs/ssl-certificates/google-managed-certs#caa.
     * </pre>
     *
     * <code>
     * string issuance_config = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for issuanceConfig.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIssuanceConfigBytes() {
      java.lang.Object ref = issuanceConfig_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        issuanceConfig_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STATE_FIELD_NUMBER = 4;
    private int state_;
    /**
     *
     *
     * <pre>
     * Output only. State of the managed certificate resource.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the managed certificate resource.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State result =
          com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State.valueOf(
              state_);
      return result == null
          ? com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State.UNRECOGNIZED
          : result;
    }

    public static final int PROVISIONING_ISSUE_FIELD_NUMBER = 3;
    private com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue
        provisioningIssue_;
    /**
     *
     *
     * <pre>
     * Output only. Information about issues with provisioning a Managed
     * Certificate.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue provisioning_issue = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the provisioningIssue field is set.
     */
    @java.lang.Override
    public boolean hasProvisioningIssue() {
      return provisioningIssue_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about issues with provisioning a Managed
     * Certificate.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue provisioning_issue = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The provisioningIssue.
     */
    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue
        getProvisioningIssue() {
      return provisioningIssue_ == null
          ? com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue
              .getDefaultInstance()
          : provisioningIssue_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about issues with provisioning a Managed
     * Certificate.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue provisioning_issue = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
            .ProvisioningIssueOrBuilder
        getProvisioningIssueOrBuilder() {
      return getProvisioningIssue();
    }

    public static final int AUTHORIZATION_ATTEMPT_INFO_FIELD_NUMBER = 5;
    private java.util.List<
            com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .AuthorizationAttemptInfo>
        authorizationAttemptInfo_;
    /**
     *
     *
     * <pre>
     * Output only. Detailed state of the latest authorization attempt for each
     * domain specified for managed certificate resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .AuthorizationAttemptInfo>
        getAuthorizationAttemptInfoList() {
      return authorizationAttemptInfo_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed state of the latest authorization attempt for each
     * domain specified for managed certificate resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                    .AuthorizationAttemptInfoOrBuilder>
        getAuthorizationAttemptInfoOrBuilderList() {
      return authorizationAttemptInfo_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed state of the latest authorization attempt for each
     * domain specified for managed certificate resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public int getAuthorizationAttemptInfoCount() {
      return authorizationAttemptInfo_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed state of the latest authorization attempt for each
     * domain specified for managed certificate resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
            .AuthorizationAttemptInfo
        getAuthorizationAttemptInfo(int index) {
      return authorizationAttemptInfo_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed state of the latest authorization attempt for each
     * domain specified for managed certificate resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
            .AuthorizationAttemptInfoOrBuilder
        getAuthorizationAttemptInfoOrBuilder(int index) {
      return authorizationAttemptInfo_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < domains_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, domains_.getRaw(i));
      }
      for (int i = 0; i < dnsAuthorizations_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, dnsAuthorizations_.getRaw(i));
      }
      if (provisioningIssue_ != null) {
        output.writeMessage(3, getProvisioningIssue());
      }
      if (state_
          != com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State
              .STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(4, state_);
      }
      for (int i = 0; i < authorizationAttemptInfo_.size(); i++) {
        output.writeMessage(5, authorizationAttemptInfo_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(issuanceConfig_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, issuanceConfig_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < domains_.size(); i++) {
          dataSize += computeStringSizeNoTag(domains_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getDomainsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < dnsAuthorizations_.size(); i++) {
          dataSize += computeStringSizeNoTag(dnsAuthorizations_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getDnsAuthorizationsList().size();
      }
      if (provisioningIssue_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getProvisioningIssue());
      }
      if (state_
          != com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State
              .STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
      }
      for (int i = 0; i < authorizationAttemptInfo_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5, authorizationAttemptInfo_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(issuanceConfig_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, issuanceConfig_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate)) {
        return super.equals(obj);
      }
      com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate other =
          (com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate) obj;

      if (!getDomainsList().equals(other.getDomainsList())) return false;
      if (!getDnsAuthorizationsList().equals(other.getDnsAuthorizationsList())) return false;
      if (!getIssuanceConfig().equals(other.getIssuanceConfig())) return false;
      if (state_ != other.state_) return false;
      if (hasProvisioningIssue() != other.hasProvisioningIssue()) return false;
      if (hasProvisioningIssue()) {
        if (!getProvisioningIssue().equals(other.getProvisioningIssue())) return false;
      }
      if (!getAuthorizationAttemptInfoList().equals(other.getAuthorizationAttemptInfoList()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getDomainsCount() > 0) {
        hash = (37 * hash) + DOMAINS_FIELD_NUMBER;
        hash = (53 * hash) + getDomainsList().hashCode();
      }
      if (getDnsAuthorizationsCount() > 0) {
        hash = (37 * hash) + DNS_AUTHORIZATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getDnsAuthorizationsList().hashCode();
      }
      hash = (37 * hash) + ISSUANCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getIssuanceConfig().hashCode();
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      if (hasProvisioningIssue()) {
        hash = (37 * hash) + PROVISIONING_ISSUE_FIELD_NUMBER;
        hash = (53 * hash) + getProvisioningIssue().hashCode();
      }
      if (getAuthorizationAttemptInfoCount() > 0) {
        hash = (37 * hash) + AUTHORIZATION_ATTEMPT_INFO_FIELD_NUMBER;
        hash = (53 * hash) + getAuthorizationAttemptInfoList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration and state of a Managed Certificate.
     * Certificate Manager provisions and renews Managed Certificates
     * automatically, for as long as it's authorized to do so.
     * </pre>
     *
     * Protobuf type {@code google.cloud.certificatemanager.v1.Certificate.ManagedCertificate}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.certificatemanager.v1.Certificate.ManagedCertificate)
        com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificateOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.certificatemanager.v1.CertificateManagerProto
            .internal_static_google_cloud_certificatemanager_v1_Certificate_ManagedCertificate_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.certificatemanager.v1.CertificateManagerProto
            .internal_static_google_cloud_certificatemanager_v1_Certificate_ManagedCertificate_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.class,
                com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        domains_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        dnsAuthorizations_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        issuanceConfig_ = "";

        state_ = 0;

        if (provisioningIssueBuilder_ == null) {
          provisioningIssue_ = null;
        } else {
          provisioningIssue_ = null;
          provisioningIssueBuilder_ = null;
        }
        if (authorizationAttemptInfoBuilder_ == null) {
          authorizationAttemptInfo_ = java.util.Collections.emptyList();
        } else {
          authorizationAttemptInfo_ = null;
          authorizationAttemptInfoBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.certificatemanager.v1.CertificateManagerProto
            .internal_static_google_cloud_certificatemanager_v1_Certificate_ManagedCertificate_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
          getDefaultInstanceForType() {
        return com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate build() {
        com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate buildPartial() {
        com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate result =
            new com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate(this);
        int from_bitField0_ = bitField0_;
        if (((bitField0_ & 0x00000001) != 0)) {
          domains_ = domains_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.domains_ = domains_;
        if (((bitField0_ & 0x00000002) != 0)) {
          dnsAuthorizations_ = dnsAuthorizations_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.dnsAuthorizations_ = dnsAuthorizations_;
        result.issuanceConfig_ = issuanceConfig_;
        result.state_ = state_;
        if (provisioningIssueBuilder_ == null) {
          result.provisioningIssue_ = provisioningIssue_;
        } else {
          result.provisioningIssue_ = provisioningIssueBuilder_.build();
        }
        if (authorizationAttemptInfoBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            authorizationAttemptInfo_ =
                java.util.Collections.unmodifiableList(authorizationAttemptInfo_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.authorizationAttemptInfo_ = authorizationAttemptInfo_;
        } else {
          result.authorizationAttemptInfo_ = authorizationAttemptInfoBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate) {
          return mergeFrom(
              (com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate other) {
        if (other
            == com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                .getDefaultInstance()) return this;
        if (!other.domains_.isEmpty()) {
          if (domains_.isEmpty()) {
            domains_ = other.domains_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureDomainsIsMutable();
            domains_.addAll(other.domains_);
          }
          onChanged();
        }
        if (!other.dnsAuthorizations_.isEmpty()) {
          if (dnsAuthorizations_.isEmpty()) {
            dnsAuthorizations_ = other.dnsAuthorizations_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureDnsAuthorizationsIsMutable();
            dnsAuthorizations_.addAll(other.dnsAuthorizations_);
          }
          onChanged();
        }
        if (!other.getIssuanceConfig().isEmpty()) {
          issuanceConfig_ = other.issuanceConfig_;
          onChanged();
        }
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        if (other.hasProvisioningIssue()) {
          mergeProvisioningIssue(other.getProvisioningIssue());
        }
        if (authorizationAttemptInfoBuilder_ == null) {
          if (!other.authorizationAttemptInfo_.isEmpty()) {
            if (authorizationAttemptInfo_.isEmpty()) {
              authorizationAttemptInfo_ = other.authorizationAttemptInfo_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureAuthorizationAttemptInfoIsMutable();
              authorizationAttemptInfo_.addAll(other.authorizationAttemptInfo_);
            }
            onChanged();
          }
        } else {
          if (!other.authorizationAttemptInfo_.isEmpty()) {
            if (authorizationAttemptInfoBuilder_.isEmpty()) {
              authorizationAttemptInfoBuilder_.dispose();
              authorizationAttemptInfoBuilder_ = null;
              authorizationAttemptInfo_ = other.authorizationAttemptInfo_;
              bitField0_ = (bitField0_ & ~0x00000004);
              authorizationAttemptInfoBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getAuthorizationAttemptInfoFieldBuilder()
                      : null;
            } else {
              authorizationAttemptInfoBuilder_.addAllMessages(other.authorizationAttemptInfo_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureDomainsIsMutable();
                  domains_.add(s);
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureDnsAuthorizationsIsMutable();
                  dnsAuthorizations_.add(s);
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getProvisioningIssueFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 26
              case 32:
                {
                  state_ = input.readEnum();

                  break;
                } // case 32
              case 42:
                {
                  com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                          .AuthorizationAttemptInfo
                      m =
                          input.readMessage(
                              com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                                  .AuthorizationAttemptInfo.parser(),
                              extensionRegistry);
                  if (authorizationAttemptInfoBuilder_ == null) {
                    ensureAuthorizationAttemptInfoIsMutable();
                    authorizationAttemptInfo_.add(m);
                  } else {
                    authorizationAttemptInfoBuilder_.addMessage(m);
                  }
                  break;
                } // case 42
              case 50:
                {
                  issuanceConfig_ = input.readStringRequireUtf8();

                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringList domains_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureDomainsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          domains_ = new com.google.protobuf.LazyStringArrayList(domains_);
          bitField0_ |= 0x00000001;
        }
      }
      /**
       *
       *
       * <pre>
       * Immutable. The domains for which a managed SSL certificate will be
       * generated. Wildcard domains are only supported with DNS challenge
       * resolution.
       * </pre>
       *
       * <code>repeated string domains = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @return A list containing the domains.
       */
      public com.google.protobuf.ProtocolStringList getDomainsList() {
        return domains_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * Immutable. The domains for which a managed SSL certificate will be
       * generated. Wildcard domains are only supported with DNS challenge
       * resolution.
       * </pre>
       *
       * <code>repeated string domains = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @return The count of domains.
       */
      public int getDomainsCount() {
        return domains_.size();
      }
      /**
       *
       *
       * <pre>
       * Immutable. The domains for which a managed SSL certificate will be
       * generated. Wildcard domains are only supported with DNS challenge
       * resolution.
       * </pre>
       *
       * <code>repeated string domains = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @param index The index of the element to return.
       * @return The domains at the given index.
       */
      public java.lang.String getDomains(int index) {
        return domains_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Immutable. The domains for which a managed SSL certificate will be
       * generated. Wildcard domains are only supported with DNS challenge
       * resolution.
       * </pre>
       *
       * <code>repeated string domains = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the domains at the given index.
       */
      public com.google.protobuf.ByteString getDomainsBytes(int index) {
        return domains_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Immutable. The domains for which a managed SSL certificate will be
       * generated. Wildcard domains are only supported with DNS challenge
       * resolution.
       * </pre>
       *
       * <code>repeated string domains = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @param index The index to set the value at.
       * @param value The domains to set.
       * @return This builder for chaining.
       */
      public Builder setDomains(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDomainsIsMutable();
        domains_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Immutable. The domains for which a managed SSL certificate will be
       * generated. Wildcard domains are only supported with DNS challenge
       * resolution.
       * </pre>
       *
       * <code>repeated string domains = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @param value The domains to add.
       * @return This builder for chaining.
       */
      public Builder addDomains(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDomainsIsMutable();
        domains_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Immutable. The domains for which a managed SSL certificate will be
       * generated. Wildcard domains are only supported with DNS challenge
       * resolution.
       * </pre>
       *
       * <code>repeated string domains = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @param values The domains to add.
       * @return This builder for chaining.
       */
      public Builder addAllDomains(java.lang.Iterable<java.lang.String> values) {
        ensureDomainsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, domains_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Immutable. The domains for which a managed SSL certificate will be
       * generated. Wildcard domains are only supported with DNS challenge
       * resolution.
       * </pre>
       *
       * <code>repeated string domains = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDomains() {
        domains_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Immutable. The domains for which a managed SSL certificate will be
       * generated. Wildcard domains are only supported with DNS challenge
       * resolution.
       * </pre>
       *
       * <code>repeated string domains = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @param value The bytes of the domains to add.
       * @return This builder for chaining.
       */
      public Builder addDomainsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureDomainsIsMutable();
        domains_.add(value);
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList dnsAuthorizations_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureDnsAuthorizationsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          dnsAuthorizations_ = new com.google.protobuf.LazyStringArrayList(dnsAuthorizations_);
          bitField0_ |= 0x00000002;
        }
      }
      /**
       *
       *
       * <pre>
       * Immutable. Authorizations that will be used for performing domain
       * authorization.
       * </pre>
       *
       * <code>
       * repeated string dns_authorizations = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return A list containing the dnsAuthorizations.
       */
      public com.google.protobuf.ProtocolStringList getDnsAuthorizationsList() {
        return dnsAuthorizations_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * Immutable. Authorizations that will be used for performing domain
       * authorization.
       * </pre>
       *
       * <code>
       * repeated string dns_authorizations = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The count of dnsAuthorizations.
       */
      public int getDnsAuthorizationsCount() {
        return dnsAuthorizations_.size();
      }
      /**
       *
       *
       * <pre>
       * Immutable. Authorizations that will be used for performing domain
       * authorization.
       * </pre>
       *
       * <code>
       * repeated string dns_authorizations = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param index The index of the element to return.
       * @return The dnsAuthorizations at the given index.
       */
      public java.lang.String getDnsAuthorizations(int index) {
        return dnsAuthorizations_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Immutable. Authorizations that will be used for performing domain
       * authorization.
       * </pre>
       *
       * <code>
       * repeated string dns_authorizations = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the dnsAuthorizations at the given index.
       */
      public com.google.protobuf.ByteString getDnsAuthorizationsBytes(int index) {
        return dnsAuthorizations_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Immutable. Authorizations that will be used for performing domain
       * authorization.
       * </pre>
       *
       * <code>
       * repeated string dns_authorizations = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The dnsAuthorizations to set.
       * @return This builder for chaining.
       */
      public Builder setDnsAuthorizations(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDnsAuthorizationsIsMutable();
        dnsAuthorizations_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Immutable. Authorizations that will be used for performing domain
       * authorization.
       * </pre>
       *
       * <code>
       * repeated string dns_authorizations = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The dnsAuthorizations to add.
       * @return This builder for chaining.
       */
      public Builder addDnsAuthorizations(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDnsAuthorizationsIsMutable();
        dnsAuthorizations_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Immutable. Authorizations that will be used for performing domain
       * authorization.
       * </pre>
       *
       * <code>
       * repeated string dns_authorizations = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param values The dnsAuthorizations to add.
       * @return This builder for chaining.
       */
      public Builder addAllDnsAuthorizations(java.lang.Iterable<java.lang.String> values) {
        ensureDnsAuthorizationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dnsAuthorizations_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Immutable. Authorizations that will be used for performing domain
       * authorization.
       * </pre>
       *
       * <code>
       * repeated string dns_authorizations = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDnsAuthorizations() {
        dnsAuthorizations_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Immutable. Authorizations that will be used for performing domain
       * authorization.
       * </pre>
       *
       * <code>
       * repeated string dns_authorizations = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes of the dnsAuthorizations to add.
       * @return This builder for chaining.
       */
      public Builder addDnsAuthorizationsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureDnsAuthorizationsIsMutable();
        dnsAuthorizations_.add(value);
        onChanged();
        return this;
      }

      private java.lang.Object issuanceConfig_ = "";
      /**
       *
       *
       * <pre>
       * The resource name for a
       * [CertificateIssuanceConfig][google.cloud.certificatemanager.v1.CertificateIssuanceConfig]
       * used to configure private PKI certificates in the format
       * `projects/&#42;&#47;locations/&#42;&#47;certificateIssuanceConfigs/&#42;`.
       * If this field is not set, the certificates will instead be publicly
       * signed as documented at
       * https://cloud.google.com/load-balancing/docs/ssl-certificates/google-managed-certs#caa.
       * </pre>
       *
       * <code>
       * string issuance_config = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The issuanceConfig.
       */
      public java.lang.String getIssuanceConfig() {
        java.lang.Object ref = issuanceConfig_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          issuanceConfig_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The resource name for a
       * [CertificateIssuanceConfig][google.cloud.certificatemanager.v1.CertificateIssuanceConfig]
       * used to configure private PKI certificates in the format
       * `projects/&#42;&#47;locations/&#42;&#47;certificateIssuanceConfigs/&#42;`.
       * If this field is not set, the certificates will instead be publicly
       * signed as documented at
       * https://cloud.google.com/load-balancing/docs/ssl-certificates/google-managed-certs#caa.
       * </pre>
       *
       * <code>
       * string issuance_config = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for issuanceConfig.
       */
      public com.google.protobuf.ByteString getIssuanceConfigBytes() {
        java.lang.Object ref = issuanceConfig_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          issuanceConfig_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The resource name for a
       * [CertificateIssuanceConfig][google.cloud.certificatemanager.v1.CertificateIssuanceConfig]
       * used to configure private PKI certificates in the format
       * `projects/&#42;&#47;locations/&#42;&#47;certificateIssuanceConfigs/&#42;`.
       * If this field is not set, the certificates will instead be publicly
       * signed as documented at
       * https://cloud.google.com/load-balancing/docs/ssl-certificates/google-managed-certs#caa.
       * </pre>
       *
       * <code>
       * string issuance_config = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The issuanceConfig to set.
       * @return This builder for chaining.
       */
      public Builder setIssuanceConfig(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        issuanceConfig_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource name for a
       * [CertificateIssuanceConfig][google.cloud.certificatemanager.v1.CertificateIssuanceConfig]
       * used to configure private PKI certificates in the format
       * `projects/&#42;&#47;locations/&#42;&#47;certificateIssuanceConfigs/&#42;`.
       * If this field is not set, the certificates will instead be publicly
       * signed as documented at
       * https://cloud.google.com/load-balancing/docs/ssl-certificates/google-managed-certs#caa.
       * </pre>
       *
       * <code>
       * string issuance_config = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIssuanceConfig() {

        issuanceConfig_ = getDefaultInstance().getIssuanceConfig();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource name for a
       * [CertificateIssuanceConfig][google.cloud.certificatemanager.v1.CertificateIssuanceConfig]
       * used to configure private PKI certificates in the format
       * `projects/&#42;&#47;locations/&#42;&#47;certificateIssuanceConfigs/&#42;`.
       * If this field is not set, the certificates will instead be publicly
       * signed as documented at
       * https://cloud.google.com/load-balancing/docs/ssl-certificates/google-managed-certs#caa.
       * </pre>
       *
       * <code>
       * string issuance_config = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for issuanceConfig to set.
       * @return This builder for chaining.
       */
      public Builder setIssuanceConfigBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        issuanceConfig_ = value;
        onChanged();
        return this;
      }

      private int state_ = 0;
      /**
       *
       *
       * <pre>
       * Output only. State of the managed certificate resource.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }
      /**
       *
       *
       * <pre>
       * Output only. State of the managed certificate resource.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {

        state_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. State of the managed certificate resource.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State
          getState() {
        @SuppressWarnings("deprecation")
        com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State result =
            com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State.valueOf(
                state_);
        return result == null
            ? com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Output only. State of the managed certificate resource.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(
          com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State value) {
        if (value == null) {
          throw new NullPointerException();
        }

        state_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. State of the managed certificate resource.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {

        state_ = 0;
        onChanged();
        return this;
      }

      private com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .ProvisioningIssue
          provisioningIssue_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .ProvisioningIssue,
              com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .ProvisioningIssue.Builder,
              com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .ProvisioningIssueOrBuilder>
          provisioningIssueBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. Information about issues with provisioning a Managed
       * Certificate.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue provisioning_issue = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the provisioningIssue field is set.
       */
      public boolean hasProvisioningIssue() {
        return provisioningIssueBuilder_ != null || provisioningIssue_ != null;
      }
      /**
       *
       *
       * <pre>
       * Output only. Information about issues with provisioning a Managed
       * Certificate.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue provisioning_issue = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The provisioningIssue.
       */
      public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue
          getProvisioningIssue() {
        if (provisioningIssueBuilder_ == null) {
          return provisioningIssue_ == null
              ? com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .ProvisioningIssue.getDefaultInstance()
              : provisioningIssue_;
        } else {
          return provisioningIssueBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Information about issues with provisioning a Managed
       * Certificate.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue provisioning_issue = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setProvisioningIssue(
          com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue
              value) {
        if (provisioningIssueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          provisioningIssue_ = value;
          onChanged();
        } else {
          provisioningIssueBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Information about issues with provisioning a Managed
       * Certificate.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue provisioning_issue = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setProvisioningIssue(
          com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue
                  .Builder
              builderForValue) {
        if (provisioningIssueBuilder_ == null) {
          provisioningIssue_ = builderForValue.build();
          onChanged();
        } else {
          provisioningIssueBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Information about issues with provisioning a Managed
       * Certificate.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue provisioning_issue = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeProvisioningIssue(
          com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue
              value) {
        if (provisioningIssueBuilder_ == null) {
          if (provisioningIssue_ != null) {
            provisioningIssue_ =
                com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                    .ProvisioningIssue.newBuilder(provisioningIssue_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            provisioningIssue_ = value;
          }
          onChanged();
        } else {
          provisioningIssueBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Information about issues with provisioning a Managed
       * Certificate.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue provisioning_issue = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearProvisioningIssue() {
        if (provisioningIssueBuilder_ == null) {
          provisioningIssue_ = null;
          onChanged();
        } else {
          provisioningIssue_ = null;
          provisioningIssueBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Information about issues with provisioning a Managed
       * Certificate.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue provisioning_issue = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue
              .Builder
          getProvisioningIssueBuilder() {

        onChanged();
        return getProvisioningIssueFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. Information about issues with provisioning a Managed
       * Certificate.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue provisioning_issue = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .ProvisioningIssueOrBuilder
          getProvisioningIssueOrBuilder() {
        if (provisioningIssueBuilder_ != null) {
          return provisioningIssueBuilder_.getMessageOrBuilder();
        } else {
          return provisioningIssue_ == null
              ? com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .ProvisioningIssue.getDefaultInstance()
              : provisioningIssue_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Information about issues with provisioning a Managed
       * Certificate.
       * </pre>
       *
       * <code>
       * .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue provisioning_issue = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .ProvisioningIssue,
              com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .ProvisioningIssue.Builder,
              com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .ProvisioningIssueOrBuilder>
          getProvisioningIssueFieldBuilder() {
        if (provisioningIssueBuilder_ == null) {
          provisioningIssueBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                      .ProvisioningIssue,
                  com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                      .ProvisioningIssue.Builder,
                  com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                      .ProvisioningIssueOrBuilder>(
                  getProvisioningIssue(), getParentForChildren(), isClean());
          provisioningIssue_ = null;
        }
        return provisioningIssueBuilder_;
      }

      private java.util.List<
              com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .AuthorizationAttemptInfo>
          authorizationAttemptInfo_ = java.util.Collections.emptyList();

      private void ensureAuthorizationAttemptInfoIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          authorizationAttemptInfo_ =
              new java.util.ArrayList<
                  com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                      .AuthorizationAttemptInfo>(authorizationAttemptInfo_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .AuthorizationAttemptInfo,
              com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .AuthorizationAttemptInfo.Builder,
              com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .AuthorizationAttemptInfoOrBuilder>
          authorizationAttemptInfoBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. Detailed state of the latest authorization attempt for each
       * domain specified for managed certificate resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<
              com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .AuthorizationAttemptInfo>
          getAuthorizationAttemptInfoList() {
        if (authorizationAttemptInfoBuilder_ == null) {
          return java.util.Collections.unmodifiableList(authorizationAttemptInfo_);
        } else {
          return authorizationAttemptInfoBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Detailed state of the latest authorization attempt for each
       * domain specified for managed certificate resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public int getAuthorizationAttemptInfoCount() {
        if (authorizationAttemptInfoBuilder_ == null) {
          return authorizationAttemptInfo_.size();
        } else {
          return authorizationAttemptInfoBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Detailed state of the latest authorization attempt for each
       * domain specified for managed certificate resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfo
          getAuthorizationAttemptInfo(int index) {
        if (authorizationAttemptInfoBuilder_ == null) {
          return authorizationAttemptInfo_.get(index);
        } else {
          return authorizationAttemptInfoBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Detailed state of the latest authorization attempt for each
       * domain specified for managed certificate resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setAuthorizationAttemptInfo(
          int index,
          com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .AuthorizationAttemptInfo
              value) {
        if (authorizationAttemptInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAuthorizationAttemptInfoIsMutable();
          authorizationAttemptInfo_.set(index, value);
          onChanged();
        } else {
          authorizationAttemptInfoBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Detailed state of the latest authorization attempt for each
       * domain specified for managed certificate resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setAuthorizationAttemptInfo(
          int index,
          com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .AuthorizationAttemptInfo.Builder
              builderForValue) {
        if (authorizationAttemptInfoBuilder_ == null) {
          ensureAuthorizationAttemptInfoIsMutable();
          authorizationAttemptInfo_.set(index, builderForValue.build());
          onChanged();
        } else {
          authorizationAttemptInfoBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Detailed state of the latest authorization attempt for each
       * domain specified for managed certificate resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addAuthorizationAttemptInfo(
          com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .AuthorizationAttemptInfo
              value) {
        if (authorizationAttemptInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAuthorizationAttemptInfoIsMutable();
          authorizationAttemptInfo_.add(value);
          onChanged();
        } else {
          authorizationAttemptInfoBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Detailed state of the latest authorization attempt for each
       * domain specified for managed certificate resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addAuthorizationAttemptInfo(
          int index,
          com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .AuthorizationAttemptInfo
              value) {
        if (authorizationAttemptInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAuthorizationAttemptInfoIsMutable();
          authorizationAttemptInfo_.add(index, value);
          onChanged();
        } else {
          authorizationAttemptInfoBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Detailed state of the latest authorization attempt for each
       * domain specified for managed certificate resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addAuthorizationAttemptInfo(
          com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .AuthorizationAttemptInfo.Builder
              builderForValue) {
        if (authorizationAttemptInfoBuilder_ == null) {
          ensureAuthorizationAttemptInfoIsMutable();
          authorizationAttemptInfo_.add(builderForValue.build());
          onChanged();
        } else {
          authorizationAttemptInfoBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Detailed state of the latest authorization attempt for each
       * domain specified for managed certificate resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addAuthorizationAttemptInfo(
          int index,
          com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .AuthorizationAttemptInfo.Builder
              builderForValue) {
        if (authorizationAttemptInfoBuilder_ == null) {
          ensureAuthorizationAttemptInfoIsMutable();
          authorizationAttemptInfo_.add(index, builderForValue.build());
          onChanged();
        } else {
          authorizationAttemptInfoBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Detailed state of the latest authorization attempt for each
       * domain specified for managed certificate resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addAllAuthorizationAttemptInfo(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                          .AuthorizationAttemptInfo>
              values) {
        if (authorizationAttemptInfoBuilder_ == null) {
          ensureAuthorizationAttemptInfoIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, authorizationAttemptInfo_);
          onChanged();
        } else {
          authorizationAttemptInfoBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Detailed state of the latest authorization attempt for each
       * domain specified for managed certificate resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearAuthorizationAttemptInfo() {
        if (authorizationAttemptInfoBuilder_ == null) {
          authorizationAttemptInfo_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          authorizationAttemptInfoBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Detailed state of the latest authorization attempt for each
       * domain specified for managed certificate resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder removeAuthorizationAttemptInfo(int index) {
        if (authorizationAttemptInfoBuilder_ == null) {
          ensureAuthorizationAttemptInfoIsMutable();
          authorizationAttemptInfo_.remove(index);
          onChanged();
        } else {
          authorizationAttemptInfoBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Detailed state of the latest authorization attempt for each
       * domain specified for managed certificate resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfo.Builder
          getAuthorizationAttemptInfoBuilder(int index) {
        return getAuthorizationAttemptInfoFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. Detailed state of the latest authorization attempt for each
       * domain specified for managed certificate resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfoOrBuilder
          getAuthorizationAttemptInfoOrBuilder(int index) {
        if (authorizationAttemptInfoBuilder_ == null) {
          return authorizationAttemptInfo_.get(index);
        } else {
          return authorizationAttemptInfoBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Detailed state of the latest authorization attempt for each
       * domain specified for managed certificate resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                      .AuthorizationAttemptInfoOrBuilder>
          getAuthorizationAttemptInfoOrBuilderList() {
        if (authorizationAttemptInfoBuilder_ != null) {
          return authorizationAttemptInfoBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(authorizationAttemptInfo_);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Detailed state of the latest authorization attempt for each
       * domain specified for managed certificate resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfo.Builder
          addAuthorizationAttemptInfoBuilder() {
        return getAuthorizationAttemptInfoFieldBuilder()
            .addBuilder(
                com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                    .AuthorizationAttemptInfo.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. Detailed state of the latest authorization attempt for each
       * domain specified for managed certificate resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
              .AuthorizationAttemptInfo.Builder
          addAuthorizationAttemptInfoBuilder(int index) {
        return getAuthorizationAttemptInfoFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                    .AuthorizationAttemptInfo.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. Detailed state of the latest authorization attempt for each
       * domain specified for managed certificate resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo authorization_attempt_info = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<
              com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .AuthorizationAttemptInfo.Builder>
          getAuthorizationAttemptInfoBuilderList() {
        return getAuthorizationAttemptInfoFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .AuthorizationAttemptInfo,
              com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .AuthorizationAttemptInfo.Builder,
              com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .AuthorizationAttemptInfoOrBuilder>
          getAuthorizationAttemptInfoFieldBuilder() {
        if (authorizationAttemptInfoBuilder_ == null) {
          authorizationAttemptInfoBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                      .AuthorizationAttemptInfo,
                  com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                      .AuthorizationAttemptInfo.Builder,
                  com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                      .AuthorizationAttemptInfoOrBuilder>(
                  authorizationAttemptInfo_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          authorizationAttemptInfo_ = null;
        }
        return authorizationAttemptInfoBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.certificatemanager.v1.Certificate.ManagedCertificate)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.certificatemanager.v1.Certificate.ManagedCertificate)
    private static final com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate();
    }

    public static com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ManagedCertificate> PARSER =
        new com.google.protobuf.AbstractParser<ManagedCertificate>() {
          @java.lang.Override
          public ManagedCertificate parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ManagedCertificate> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ManagedCertificate> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int typeCase_ = 0;
  private java.lang.Object type_;

  public enum TypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SELF_MANAGED(5),
    MANAGED(11),
    TYPE_NOT_SET(0);
    private final int value;

    private TypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static TypeCase forNumber(int value) {
      switch (value) {
        case 5:
          return SELF_MANAGED;
        case 11:
          return MANAGED;
        case 0:
          return TYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TypeCase getTypeCase() {
    return TypeCase.forNumber(typeCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * A user-defined name of the certificate. Certificate names must be unique
   * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A user-defined name of the certificate. Certificate names must be unique
   * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 8;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * One or more paragraphs of text description of a certificate.
   * </pre>
   *
   * <code>string description = 8;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * One or more paragraphs of text description of a certificate.
   * </pre>
   *
   * <code>string description = 8;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a Certificate.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a Certificate.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of a Certificate.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a Certificate.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a Certificate.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a Certificate.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.certificatemanager.v1.CertificateManagerProto
                .internal_static_google_cloud_certificatemanager_v1_Certificate_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Set of labels associated with a Certificate.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Set of labels associated with a Certificate.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Set of labels associated with a Certificate.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Set of labels associated with a Certificate.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int SELF_MANAGED_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * If set, defines data of a self-managed certificate.
   * </pre>
   *
   * <code>.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate self_managed = 5;
   * </code>
   *
   * @return Whether the selfManaged field is set.
   */
  @java.lang.Override
  public boolean hasSelfManaged() {
    return typeCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * If set, defines data of a self-managed certificate.
   * </pre>
   *
   * <code>.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate self_managed = 5;
   * </code>
   *
   * @return The selfManaged.
   */
  @java.lang.Override
  public com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
      getSelfManaged() {
    if (typeCase_ == 5) {
      return (com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate) type_;
    }
    return com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * If set, defines data of a self-managed certificate.
   * </pre>
   *
   * <code>.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate self_managed = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificateOrBuilder
      getSelfManagedOrBuilder() {
    if (typeCase_ == 5) {
      return (com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate) type_;
    }
    return com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
        .getDefaultInstance();
  }

  public static final int MANAGED_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * If set, contains configuration and state of a managed certificate.
   * </pre>
   *
   * <code>.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate managed = 11;</code>
   *
   * @return Whether the managed field is set.
   */
  @java.lang.Override
  public boolean hasManaged() {
    return typeCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * If set, contains configuration and state of a managed certificate.
   * </pre>
   *
   * <code>.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate managed = 11;</code>
   *
   * @return The managed.
   */
  @java.lang.Override
  public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate getManaged() {
    if (typeCase_ == 11) {
      return (com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate) type_;
    }
    return com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * If set, contains configuration and state of a managed certificate.
   * </pre>
   *
   * <code>.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate managed = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificateOrBuilder
      getManagedOrBuilder() {
    if (typeCase_ == 11) {
      return (com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate) type_;
    }
    return com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
        .getDefaultInstance();
  }

  public static final int SAN_DNSNAMES_FIELD_NUMBER = 6;
  private com.google.protobuf.LazyStringList sanDnsnames_;
  /**
   *
   *
   * <pre>
   * Output only. The list of Subject Alternative Names of dnsName type defined
   * in the certificate (see RFC 5280 4.2.1.6). Managed certificates that
   * haven't been provisioned yet have this field populated with a value of the
   * managed.domains field.
   * </pre>
   *
   * <code>repeated string san_dnsnames = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return A list containing the sanDnsnames.
   */
  public com.google.protobuf.ProtocolStringList getSanDnsnamesList() {
    return sanDnsnames_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The list of Subject Alternative Names of dnsName type defined
   * in the certificate (see RFC 5280 4.2.1.6). Managed certificates that
   * haven't been provisioned yet have this field populated with a value of the
   * managed.domains field.
   * </pre>
   *
   * <code>repeated string san_dnsnames = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The count of sanDnsnames.
   */
  public int getSanDnsnamesCount() {
    return sanDnsnames_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The list of Subject Alternative Names of dnsName type defined
   * in the certificate (see RFC 5280 4.2.1.6). Managed certificates that
   * haven't been provisioned yet have this field populated with a value of the
   * managed.domains field.
   * </pre>
   *
   * <code>repeated string san_dnsnames = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the element to return.
   * @return The sanDnsnames at the given index.
   */
  public java.lang.String getSanDnsnames(int index) {
    return sanDnsnames_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The list of Subject Alternative Names of dnsName type defined
   * in the certificate (see RFC 5280 4.2.1.6). Managed certificates that
   * haven't been provisioned yet have this field populated with a value of the
   * managed.domains field.
   * </pre>
   *
   * <code>repeated string san_dnsnames = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the sanDnsnames at the given index.
   */
  public com.google.protobuf.ByteString getSanDnsnamesBytes(int index) {
    return sanDnsnames_.getByteString(index);
  }

  public static final int PEM_CERTIFICATE_FIELD_NUMBER = 9;
  private volatile java.lang.Object pemCertificate_;
  /**
   *
   *
   * <pre>
   * Output only. The PEM-encoded certificate chain.
   * </pre>
   *
   * <code>string pem_certificate = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The pemCertificate.
   */
  @java.lang.Override
  public java.lang.String getPemCertificate() {
    java.lang.Object ref = pemCertificate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pemCertificate_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The PEM-encoded certificate chain.
   * </pre>
   *
   * <code>string pem_certificate = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for pemCertificate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPemCertificateBytes() {
    java.lang.Object ref = pemCertificate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pemCertificate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXPIRE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp expireTime_;
  /**
   *
   *
   * <pre>
   * Output only. The expiry timestamp of a Certificate.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the expireTime field is set.
   */
  @java.lang.Override
  public boolean hasExpireTime() {
    return expireTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The expiry timestamp of a Certificate.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The expireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpireTime() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The expiry timestamp of a Certificate.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
    return getExpireTime();
  }

  public static final int SCOPE_FIELD_NUMBER = 12;
  private int scope_;
  /**
   *
   *
   * <pre>
   * Immutable. The scope of the certificate.
   * </pre>
   *
   * <code>
   * .google.cloud.certificatemanager.v1.Certificate.Scope scope = 12 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for scope.
   */
  @java.lang.Override
  public int getScopeValue() {
    return scope_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. The scope of the certificate.
   * </pre>
   *
   * <code>
   * .google.cloud.certificatemanager.v1.Certificate.Scope scope = 12 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The scope.
   */
  @java.lang.Override
  public com.google.cloud.certificatemanager.v1.Certificate.Scope getScope() {
    @SuppressWarnings("deprecation")
    com.google.cloud.certificatemanager.v1.Certificate.Scope result =
        com.google.cloud.certificatemanager.v1.Certificate.Scope.valueOf(scope_);
    return result == null
        ? com.google.cloud.certificatemanager.v1.Certificate.Scope.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(3, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    if (typeCase_ == 5) {
      output.writeMessage(
          5, (com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate) type_);
    }
    for (int i = 0; i < sanDnsnames_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, sanDnsnames_.getRaw(i));
    }
    if (expireTime_ != null) {
      output.writeMessage(7, getExpireTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pemCertificate_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, pemCertificate_);
    }
    if (typeCase_ == 11) {
      output.writeMessage(
          11, (com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate) type_);
    }
    if (scope_ != com.google.cloud.certificatemanager.v1.Certificate.Scope.DEFAULT.getNumber()) {
      output.writeEnum(12, scope_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    if (typeCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate) type_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < sanDnsnames_.size(); i++) {
        dataSize += computeStringSizeNoTag(sanDnsnames_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSanDnsnamesList().size();
    }
    if (expireTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getExpireTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pemCertificate_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, pemCertificate_);
    }
    if (typeCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate) type_);
    }
    if (scope_ != com.google.cloud.certificatemanager.v1.Certificate.Scope.DEFAULT.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(12, scope_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.certificatemanager.v1.Certificate)) {
      return super.equals(obj);
    }
    com.google.cloud.certificatemanager.v1.Certificate other =
        (com.google.cloud.certificatemanager.v1.Certificate) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getSanDnsnamesList().equals(other.getSanDnsnamesList())) return false;
    if (!getPemCertificate().equals(other.getPemCertificate())) return false;
    if (hasExpireTime() != other.hasExpireTime()) return false;
    if (hasExpireTime()) {
      if (!getExpireTime().equals(other.getExpireTime())) return false;
    }
    if (scope_ != other.scope_) return false;
    if (!getTypeCase().equals(other.getTypeCase())) return false;
    switch (typeCase_) {
      case 5:
        if (!getSelfManaged().equals(other.getSelfManaged())) return false;
        break;
      case 11:
        if (!getManaged().equals(other.getManaged())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getSanDnsnamesCount() > 0) {
      hash = (37 * hash) + SAN_DNSNAMES_FIELD_NUMBER;
      hash = (53 * hash) + getSanDnsnamesList().hashCode();
    }
    hash = (37 * hash) + PEM_CERTIFICATE_FIELD_NUMBER;
    hash = (53 * hash) + getPemCertificate().hashCode();
    if (hasExpireTime()) {
      hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExpireTime().hashCode();
    }
    hash = (37 * hash) + SCOPE_FIELD_NUMBER;
    hash = (53 * hash) + scope_;
    switch (typeCase_) {
      case 5:
        hash = (37 * hash) + SELF_MANAGED_FIELD_NUMBER;
        hash = (53 * hash) + getSelfManaged().hashCode();
        break;
      case 11:
        hash = (37 * hash) + MANAGED_FIELD_NUMBER;
        hash = (53 * hash) + getManaged().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.certificatemanager.v1.Certificate parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.certificatemanager.v1.Certificate parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.Certificate parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.certificatemanager.v1.Certificate parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.Certificate parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.certificatemanager.v1.Certificate parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.Certificate parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.certificatemanager.v1.Certificate parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.Certificate parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.certificatemanager.v1.Certificate parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.certificatemanager.v1.Certificate parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.certificatemanager.v1.Certificate parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.certificatemanager.v1.Certificate prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Defines TLS certificate.
   * </pre>
   *
   * Protobuf type {@code google.cloud.certificatemanager.v1.Certificate}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.certificatemanager.v1.Certificate)
      com.google.cloud.certificatemanager.v1.CertificateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.certificatemanager.v1.CertificateManagerProto
          .internal_static_google_cloud_certificatemanager_v1_Certificate_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.certificatemanager.v1.CertificateManagerProto
          .internal_static_google_cloud_certificatemanager_v1_Certificate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.certificatemanager.v1.Certificate.class,
              com.google.cloud.certificatemanager.v1.Certificate.Builder.class);
    }

    // Construct using com.google.cloud.certificatemanager.v1.Certificate.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      description_ = "";

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      if (selfManagedBuilder_ != null) {
        selfManagedBuilder_.clear();
      }
      if (managedBuilder_ != null) {
        managedBuilder_.clear();
      }
      sanDnsnames_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      pemCertificate_ = "";

      if (expireTimeBuilder_ == null) {
        expireTime_ = null;
      } else {
        expireTime_ = null;
        expireTimeBuilder_ = null;
      }
      scope_ = 0;

      typeCase_ = 0;
      type_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.certificatemanager.v1.CertificateManagerProto
          .internal_static_google_cloud_certificatemanager_v1_Certificate_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.Certificate getDefaultInstanceForType() {
      return com.google.cloud.certificatemanager.v1.Certificate.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.Certificate build() {
      com.google.cloud.certificatemanager.v1.Certificate result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.Certificate buildPartial() {
      com.google.cloud.certificatemanager.v1.Certificate result =
          new com.google.cloud.certificatemanager.v1.Certificate(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.description_ = description_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      if (typeCase_ == 5) {
        if (selfManagedBuilder_ == null) {
          result.type_ = type_;
        } else {
          result.type_ = selfManagedBuilder_.build();
        }
      }
      if (typeCase_ == 11) {
        if (managedBuilder_ == null) {
          result.type_ = type_;
        } else {
          result.type_ = managedBuilder_.build();
        }
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        sanDnsnames_ = sanDnsnames_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.sanDnsnames_ = sanDnsnames_;
      result.pemCertificate_ = pemCertificate_;
      if (expireTimeBuilder_ == null) {
        result.expireTime_ = expireTime_;
      } else {
        result.expireTime_ = expireTimeBuilder_.build();
      }
      result.scope_ = scope_;
      result.typeCase_ = typeCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.certificatemanager.v1.Certificate) {
        return mergeFrom((com.google.cloud.certificatemanager.v1.Certificate) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.certificatemanager.v1.Certificate other) {
      if (other == com.google.cloud.certificatemanager.v1.Certificate.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (!other.sanDnsnames_.isEmpty()) {
        if (sanDnsnames_.isEmpty()) {
          sanDnsnames_ = other.sanDnsnames_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureSanDnsnamesIsMutable();
          sanDnsnames_.addAll(other.sanDnsnames_);
        }
        onChanged();
      }
      if (!other.getPemCertificate().isEmpty()) {
        pemCertificate_ = other.pemCertificate_;
        onChanged();
      }
      if (other.hasExpireTime()) {
        mergeExpireTime(other.getExpireTime());
      }
      if (other.scope_ != 0) {
        setScopeValue(other.getScopeValue());
      }
      switch (other.getTypeCase()) {
        case SELF_MANAGED:
          {
            mergeSelfManaged(other.getSelfManaged());
            break;
          }
        case MANAGED:
          {
            mergeManaged(other.getManaged());
            break;
          }
        case TYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getSelfManagedFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSanDnsnamesIsMutable();
                sanDnsnames_.add(s);
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getExpireTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 58
            case 66:
              {
                description_ = input.readStringRequireUtf8();

                break;
              } // case 66
            case 74:
              {
                pemCertificate_ = input.readStringRequireUtf8();

                break;
              } // case 74
            case 90:
              {
                input.readMessage(getManagedFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 11;
                break;
              } // case 90
            case 96:
              {
                scope_ = input.readEnum();

                break;
              } // case 96
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int typeCase_ = 0;
    private java.lang.Object type_;

    public TypeCase getTypeCase() {
      return TypeCase.forNumber(typeCase_);
    }

    public Builder clearType() {
      typeCase_ = 0;
      type_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * A user-defined name of the certificate. Certificate names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the certificate. Certificate names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the certificate. Certificate names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the certificate. Certificate names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the certificate. Certificate names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a certificate.
     * </pre>
     *
     * <code>string description = 8;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a certificate.
     * </pre>
     *
     * <code>string description = 8;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a certificate.
     * </pre>
     *
     * <code>string description = 8;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a certificate.
     * </pre>
     *
     * <code>string description = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of a certificate.
     * </pre>
     *
     * <code>string description = 8;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a Certificate.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a Certificate.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a Certificate.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a Certificate.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a Certificate.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a Certificate.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with a Certificate.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate,
            com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate.Builder,
            com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificateOrBuilder>
        selfManagedBuilder_;
    /**
     *
     *
     * <pre>
     * If set, defines data of a self-managed certificate.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate self_managed = 5;
     * </code>
     *
     * @return Whether the selfManaged field is set.
     */
    @java.lang.Override
    public boolean hasSelfManaged() {
      return typeCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * If set, defines data of a self-managed certificate.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate self_managed = 5;
     * </code>
     *
     * @return The selfManaged.
     */
    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
        getSelfManaged() {
      if (selfManagedBuilder_ == null) {
        if (typeCase_ == 5) {
          return (com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate) type_;
        }
        return com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
            .getDefaultInstance();
      } else {
        if (typeCase_ == 5) {
          return selfManagedBuilder_.getMessage();
        }
        return com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If set, defines data of a self-managed certificate.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate self_managed = 5;
     * </code>
     */
    public Builder setSelfManaged(
        com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate value) {
      if (selfManagedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        selfManagedBuilder_.setMessage(value);
      }
      typeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, defines data of a self-managed certificate.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate self_managed = 5;
     * </code>
     */
    public Builder setSelfManaged(
        com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate.Builder
            builderForValue) {
      if (selfManagedBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        selfManagedBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, defines data of a self-managed certificate.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate self_managed = 5;
     * </code>
     */
    public Builder mergeSelfManaged(
        com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate value) {
      if (selfManagedBuilder_ == null) {
        if (typeCase_ == 5
            && type_
                != com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
                    .getDefaultInstance()) {
          type_ =
              com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate.newBuilder(
                      (com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate)
                          type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 5) {
          selfManagedBuilder_.mergeFrom(value);
        } else {
          selfManagedBuilder_.setMessage(value);
        }
      }
      typeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, defines data of a self-managed certificate.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate self_managed = 5;
     * </code>
     */
    public Builder clearSelfManaged() {
      if (selfManagedBuilder_ == null) {
        if (typeCase_ == 5) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 5) {
          typeCase_ = 0;
          type_ = null;
        }
        selfManagedBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, defines data of a self-managed certificate.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate self_managed = 5;
     * </code>
     */
    public com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate.Builder
        getSelfManagedBuilder() {
      return getSelfManagedFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If set, defines data of a self-managed certificate.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate self_managed = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificateOrBuilder
        getSelfManagedOrBuilder() {
      if ((typeCase_ == 5) && (selfManagedBuilder_ != null)) {
        return selfManagedBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 5) {
          return (com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate) type_;
        }
        return com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If set, defines data of a self-managed certificate.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate self_managed = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate,
            com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate.Builder,
            com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificateOrBuilder>
        getSelfManagedFieldBuilder() {
      if (selfManagedBuilder_ == null) {
        if (!(typeCase_ == 5)) {
          type_ =
              com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
                  .getDefaultInstance();
        }
        selfManagedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate,
                com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate.Builder,
                com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificateOrBuilder>(
                (com.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 5;
      onChanged();
      ;
      return selfManagedBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate,
            com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.Builder,
            com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificateOrBuilder>
        managedBuilder_;
    /**
     *
     *
     * <pre>
     * If set, contains configuration and state of a managed certificate.
     * </pre>
     *
     * <code>.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate managed = 11;</code>
     *
     * @return Whether the managed field is set.
     */
    @java.lang.Override
    public boolean hasManaged() {
      return typeCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * If set, contains configuration and state of a managed certificate.
     * </pre>
     *
     * <code>.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate managed = 11;</code>
     *
     * @return The managed.
     */
    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate getManaged() {
      if (managedBuilder_ == null) {
        if (typeCase_ == 11) {
          return (com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate) type_;
        }
        return com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
            .getDefaultInstance();
      } else {
        if (typeCase_ == 11) {
          return managedBuilder_.getMessage();
        }
        return com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If set, contains configuration and state of a managed certificate.
     * </pre>
     *
     * <code>.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate managed = 11;</code>
     */
    public Builder setManaged(
        com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate value) {
      if (managedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        managedBuilder_.setMessage(value);
      }
      typeCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, contains configuration and state of a managed certificate.
     * </pre>
     *
     * <code>.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate managed = 11;</code>
     */
    public Builder setManaged(
        com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.Builder
            builderForValue) {
      if (managedBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        managedBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, contains configuration and state of a managed certificate.
     * </pre>
     *
     * <code>.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate managed = 11;</code>
     */
    public Builder mergeManaged(
        com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate value) {
      if (managedBuilder_ == null) {
        if (typeCase_ == 11
            && type_
                != com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                    .getDefaultInstance()) {
          type_ =
              com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.newBuilder(
                      (com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 11) {
          managedBuilder_.mergeFrom(value);
        } else {
          managedBuilder_.setMessage(value);
        }
      }
      typeCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, contains configuration and state of a managed certificate.
     * </pre>
     *
     * <code>.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate managed = 11;</code>
     */
    public Builder clearManaged() {
      if (managedBuilder_ == null) {
        if (typeCase_ == 11) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 11) {
          typeCase_ = 0;
          type_ = null;
        }
        managedBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, contains configuration and state of a managed certificate.
     * </pre>
     *
     * <code>.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate managed = 11;</code>
     */
    public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.Builder
        getManagedBuilder() {
      return getManagedFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If set, contains configuration and state of a managed certificate.
     * </pre>
     *
     * <code>.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate managed = 11;</code>
     */
    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificateOrBuilder
        getManagedOrBuilder() {
      if ((typeCase_ == 11) && (managedBuilder_ != null)) {
        return managedBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 11) {
          return (com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate) type_;
        }
        return com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If set, contains configuration and state of a managed certificate.
     * </pre>
     *
     * <code>.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate managed = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate,
            com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.Builder,
            com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificateOrBuilder>
        getManagedFieldBuilder() {
      if (managedBuilder_ == null) {
        if (!(typeCase_ == 11)) {
          type_ =
              com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
                  .getDefaultInstance();
        }
        managedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate,
                com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.Builder,
                com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificateOrBuilder>(
                (com.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 11;
      onChanged();
      ;
      return managedBuilder_;
    }

    private com.google.protobuf.LazyStringList sanDnsnames_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureSanDnsnamesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        sanDnsnames_ = new com.google.protobuf.LazyStringArrayList(sanDnsnames_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of Subject Alternative Names of dnsName type defined
     * in the certificate (see RFC 5280 4.2.1.6). Managed certificates that
     * haven't been provisioned yet have this field populated with a value of the
     * managed.domains field.
     * </pre>
     *
     * <code>repeated string san_dnsnames = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return A list containing the sanDnsnames.
     */
    public com.google.protobuf.ProtocolStringList getSanDnsnamesList() {
      return sanDnsnames_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of Subject Alternative Names of dnsName type defined
     * in the certificate (see RFC 5280 4.2.1.6). Managed certificates that
     * haven't been provisioned yet have this field populated with a value of the
     * managed.domains field.
     * </pre>
     *
     * <code>repeated string san_dnsnames = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The count of sanDnsnames.
     */
    public int getSanDnsnamesCount() {
      return sanDnsnames_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of Subject Alternative Names of dnsName type defined
     * in the certificate (see RFC 5280 4.2.1.6). Managed certificates that
     * haven't been provisioned yet have this field populated with a value of the
     * managed.domains field.
     * </pre>
     *
     * <code>repeated string san_dnsnames = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the element to return.
     * @return The sanDnsnames at the given index.
     */
    public java.lang.String getSanDnsnames(int index) {
      return sanDnsnames_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of Subject Alternative Names of dnsName type defined
     * in the certificate (see RFC 5280 4.2.1.6). Managed certificates that
     * haven't been provisioned yet have this field populated with a value of the
     * managed.domains field.
     * </pre>
     *
     * <code>repeated string san_dnsnames = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the sanDnsnames at the given index.
     */
    public com.google.protobuf.ByteString getSanDnsnamesBytes(int index) {
      return sanDnsnames_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of Subject Alternative Names of dnsName type defined
     * in the certificate (see RFC 5280 4.2.1.6). Managed certificates that
     * haven't been provisioned yet have this field populated with a value of the
     * managed.domains field.
     * </pre>
     *
     * <code>repeated string san_dnsnames = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index to set the value at.
     * @param value The sanDnsnames to set.
     * @return This builder for chaining.
     */
    public Builder setSanDnsnames(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSanDnsnamesIsMutable();
      sanDnsnames_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of Subject Alternative Names of dnsName type defined
     * in the certificate (see RFC 5280 4.2.1.6). Managed certificates that
     * haven't been provisioned yet have this field populated with a value of the
     * managed.domains field.
     * </pre>
     *
     * <code>repeated string san_dnsnames = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The sanDnsnames to add.
     * @return This builder for chaining.
     */
    public Builder addSanDnsnames(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSanDnsnamesIsMutable();
      sanDnsnames_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of Subject Alternative Names of dnsName type defined
     * in the certificate (see RFC 5280 4.2.1.6). Managed certificates that
     * haven't been provisioned yet have this field populated with a value of the
     * managed.domains field.
     * </pre>
     *
     * <code>repeated string san_dnsnames = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param values The sanDnsnames to add.
     * @return This builder for chaining.
     */
    public Builder addAllSanDnsnames(java.lang.Iterable<java.lang.String> values) {
      ensureSanDnsnamesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sanDnsnames_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of Subject Alternative Names of dnsName type defined
     * in the certificate (see RFC 5280 4.2.1.6). Managed certificates that
     * haven't been provisioned yet have this field populated with a value of the
     * managed.domains field.
     * </pre>
     *
     * <code>repeated string san_dnsnames = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSanDnsnames() {
      sanDnsnames_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of Subject Alternative Names of dnsName type defined
     * in the certificate (see RFC 5280 4.2.1.6). Managed certificates that
     * haven't been provisioned yet have this field populated with a value of the
     * managed.domains field.
     * </pre>
     *
     * <code>repeated string san_dnsnames = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes of the sanDnsnames to add.
     * @return This builder for chaining.
     */
    public Builder addSanDnsnamesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSanDnsnamesIsMutable();
      sanDnsnames_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object pemCertificate_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The PEM-encoded certificate chain.
     * </pre>
     *
     * <code>string pem_certificate = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The pemCertificate.
     */
    public java.lang.String getPemCertificate() {
      java.lang.Object ref = pemCertificate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pemCertificate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The PEM-encoded certificate chain.
     * </pre>
     *
     * <code>string pem_certificate = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for pemCertificate.
     */
    public com.google.protobuf.ByteString getPemCertificateBytes() {
      java.lang.Object ref = pemCertificate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pemCertificate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The PEM-encoded certificate chain.
     * </pre>
     *
     * <code>string pem_certificate = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The pemCertificate to set.
     * @return This builder for chaining.
     */
    public Builder setPemCertificate(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      pemCertificate_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The PEM-encoded certificate chain.
     * </pre>
     *
     * <code>string pem_certificate = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPemCertificate() {

      pemCertificate_ = getDefaultInstance().getPemCertificate();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The PEM-encoded certificate chain.
     * </pre>
     *
     * <code>string pem_certificate = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for pemCertificate to set.
     * @return This builder for chaining.
     */
    public Builder setPemCertificateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      pemCertificate_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp expireTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expireTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The expiry timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the expireTime field is set.
     */
    public boolean hasExpireTime() {
      return expireTimeBuilder_ != null || expireTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The expiry timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The expireTime.
     */
    public com.google.protobuf.Timestamp getExpireTime() {
      if (expireTimeBuilder_ == null) {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      } else {
        return expireTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The expiry timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expireTime_ = value;
        onChanged();
      } else {
        expireTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The expiry timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expireTimeBuilder_ == null) {
        expireTime_ = builderForValue.build();
        onChanged();
      } else {
        expireTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The expiry timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (expireTime_ != null) {
          expireTime_ =
              com.google.protobuf.Timestamp.newBuilder(expireTime_).mergeFrom(value).buildPartial();
        } else {
          expireTime_ = value;
        }
        onChanged();
      } else {
        expireTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The expiry timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearExpireTime() {
      if (expireTimeBuilder_ == null) {
        expireTime_ = null;
        onChanged();
      } else {
        expireTime_ = null;
        expireTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The expiry timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {

      onChanged();
      return getExpireTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The expiry timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      if (expireTimeBuilder_ != null) {
        return expireTimeBuilder_.getMessageOrBuilder();
      } else {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The expiry timestamp of a Certificate.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpireTimeFieldBuilder() {
      if (expireTimeBuilder_ == null) {
        expireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getExpireTime(), getParentForChildren(), isClean());
        expireTime_ = null;
      }
      return expireTimeBuilder_;
    }

    private int scope_ = 0;
    /**
     *
     *
     * <pre>
     * Immutable. The scope of the certificate.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.Certificate.Scope scope = 12 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for scope.
     */
    @java.lang.Override
    public int getScopeValue() {
      return scope_;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The scope of the certificate.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.Certificate.Scope scope = 12 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for scope to set.
     * @return This builder for chaining.
     */
    public Builder setScopeValue(int value) {

      scope_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The scope of the certificate.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.Certificate.Scope scope = 12 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The scope.
     */
    @java.lang.Override
    public com.google.cloud.certificatemanager.v1.Certificate.Scope getScope() {
      @SuppressWarnings("deprecation")
      com.google.cloud.certificatemanager.v1.Certificate.Scope result =
          com.google.cloud.certificatemanager.v1.Certificate.Scope.valueOf(scope_);
      return result == null
          ? com.google.cloud.certificatemanager.v1.Certificate.Scope.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The scope of the certificate.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.Certificate.Scope scope = 12 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The scope to set.
     * @return This builder for chaining.
     */
    public Builder setScope(com.google.cloud.certificatemanager.v1.Certificate.Scope value) {
      if (value == null) {
        throw new NullPointerException();
      }

      scope_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The scope of the certificate.
     * </pre>
     *
     * <code>
     * .google.cloud.certificatemanager.v1.Certificate.Scope scope = 12 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScope() {

      scope_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.certificatemanager.v1.Certificate)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.certificatemanager.v1.Certificate)
  private static final com.google.cloud.certificatemanager.v1.Certificate DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.certificatemanager.v1.Certificate();
  }

  public static com.google.cloud.certificatemanager.v1.Certificate getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Certificate> PARSER =
      new com.google.protobuf.AbstractParser<Certificate>() {
        @java.lang.Override
        public Certificate parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Certificate> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Certificate> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.certificatemanager.v1.Certificate getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
