/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReadSessionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SESSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/sessions/{session}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String session;

    @Deprecated
    protected ReadSessionName() {
        this.project = null;
        this.location = null;
        this.session = null;
    }

    private ReadSessionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSession() {
        return this.session;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ReadSessionName of(String project, String location, String session) {
        return ReadSessionName.newBuilder().setProject(project).setLocation(location).setSession(session).build();
    }

    public static String format(String project, String location, String session) {
        return ReadSessionName.newBuilder().setProject(project).setLocation(location).setSession(session).build().toString();
    }

    public static ReadSessionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SESSION.validatedMatch(formattedString, "ReadSessionName.parse: formattedString not in valid format");
        return ReadSessionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("session"));
    }

    public static List<ReadSessionName> parseList(List<String> formattedStrings) {
        ArrayList<ReadSessionName> list = new ArrayList<ReadSessionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReadSessionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReadSessionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReadSessionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SESSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReadSessionName readSessionName = this;
            synchronized (readSessionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.session != null) {
                        fieldMapBuilder.put((Object)"session", (Object)this.session);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SESSION.instantiate(new String[]{"project", this.project, "location", this.location, "session", this.session});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ReadSessionName that = (ReadSessionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.session, that.session);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.session);
    }

    public static class Builder {
        private String project;
        private String location;
        private String session;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSession() {
            return this.session;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSession(String session) {
            this.session = session;
            return this;
        }

        private Builder(ReadSessionName readSessionName) {
            this.project = readSessionName.project;
            this.location = readSessionName.location;
            this.session = readSessionName.session;
        }

        public ReadSessionName build() {
            return new ReadSessionName(this);
        }
    }
}

