/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/apigateway/v1/apigateway.proto

package com.google.cloud.apigateway.v1;

/**
 *
 *
 * <pre>
 * Represents the metadata of the long-running operation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.apigateway.v1.OperationMetadata}
 */
public final class OperationMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.apigateway.v1.OperationMetadata)
    OperationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OperationMetadata.newBuilder() to construct.
  private OperationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OperationMetadata() {
    target_ = "";
    verb_ = "";
    statusMessage_ = "";
    apiVersion_ = "";
    diagnostics_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OperationMetadata();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.apigateway.v1.Apigateway
        .internal_static_google_cloud_apigateway_v1_OperationMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.apigateway.v1.Apigateway
        .internal_static_google_cloud_apigateway_v1_OperationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.apigateway.v1.OperationMetadata.class,
            com.google.cloud.apigateway.v1.OperationMetadata.Builder.class);
  }

  public interface DiagnosticOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.apigateway.v1.OperationMetadata.Diagnostic)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Location of the diagnostic.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The location.
     */
    java.lang.String getLocation();
    /**
     *
     *
     * <pre>
     * Location of the diagnostic.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The bytes for location.
     */
    com.google.protobuf.ByteString getLocationBytes();

    /**
     *
     *
     * <pre>
     * The diagnostic message.
     * </pre>
     *
     * <code>string message = 2;</code>
     *
     * @return The message.
     */
    java.lang.String getMessage();
    /**
     *
     *
     * <pre>
     * The diagnostic message.
     * </pre>
     *
     * <code>string message = 2;</code>
     *
     * @return The bytes for message.
     */
    com.google.protobuf.ByteString getMessageBytes();
  }
  /**
   *
   *
   * <pre>
   * Diagnostic information from configuration processing.
   * </pre>
   *
   * Protobuf type {@code google.cloud.apigateway.v1.OperationMetadata.Diagnostic}
   */
  public static final class Diagnostic extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.apigateway.v1.OperationMetadata.Diagnostic)
      DiagnosticOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Diagnostic.newBuilder() to construct.
    private Diagnostic(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Diagnostic() {
      location_ = "";
      message_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Diagnostic();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.apigateway.v1.Apigateway
          .internal_static_google_cloud_apigateway_v1_OperationMetadata_Diagnostic_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.apigateway.v1.Apigateway
          .internal_static_google_cloud_apigateway_v1_OperationMetadata_Diagnostic_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic.class,
              com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic.Builder.class);
    }

    public static final int LOCATION_FIELD_NUMBER = 1;
    private volatile java.lang.Object location_;
    /**
     *
     *
     * <pre>
     * Location of the diagnostic.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The location.
     */
    @java.lang.Override
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Location of the diagnostic.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The bytes for location.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MESSAGE_FIELD_NUMBER = 2;
    private volatile java.lang.Object message_;
    /**
     *
     *
     * <pre>
     * The diagnostic message.
     * </pre>
     *
     * <code>string message = 2;</code>
     *
     * @return The message.
     */
    @java.lang.Override
    public java.lang.String getMessage() {
      java.lang.Object ref = message_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        message_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The diagnostic message.
     * </pre>
     *
     * <code>string message = 2;</code>
     *
     * @return The bytes for message.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMessageBytes() {
      java.lang.Object ref = message_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        message_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, location_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, message_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, location_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, message_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic)) {
        return super.equals(obj);
      }
      com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic other =
          (com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic) obj;

      if (!getLocation().equals(other.getLocation())) return false;
      if (!getMessage().equals(other.getMessage())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getLocation().hashCode();
      hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getMessage().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Diagnostic information from configuration processing.
     * </pre>
     *
     * Protobuf type {@code google.cloud.apigateway.v1.OperationMetadata.Diagnostic}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.apigateway.v1.OperationMetadata.Diagnostic)
        com.google.cloud.apigateway.v1.OperationMetadata.DiagnosticOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.apigateway.v1.Apigateway
            .internal_static_google_cloud_apigateway_v1_OperationMetadata_Diagnostic_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.apigateway.v1.Apigateway
            .internal_static_google_cloud_apigateway_v1_OperationMetadata_Diagnostic_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic.class,
                com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic.Builder.class);
      }

      // Construct using com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        location_ = "";

        message_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.apigateway.v1.Apigateway
            .internal_static_google_cloud_apigateway_v1_OperationMetadata_Diagnostic_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic
          getDefaultInstanceForType() {
        return com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic build() {
        com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic buildPartial() {
        com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic result =
            new com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic(this);
        result.location_ = location_;
        result.message_ = message_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic) {
          return mergeFrom((com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic other) {
        if (other
            == com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic.getDefaultInstance())
          return this;
        if (!other.getLocation().isEmpty()) {
          location_ = other.location_;
          onChanged();
        }
        if (!other.getMessage().isEmpty()) {
          message_ = other.message_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  location_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  message_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object location_ = "";
      /**
       *
       *
       * <pre>
       * Location of the diagnostic.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return The location.
       */
      public java.lang.String getLocation() {
        java.lang.Object ref = location_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          location_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Location of the diagnostic.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return The bytes for location.
       */
      public com.google.protobuf.ByteString getLocationBytes() {
        java.lang.Object ref = location_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          location_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Location of the diagnostic.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @param value The location to set.
       * @return This builder for chaining.
       */
      public Builder setLocation(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        location_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Location of the diagnostic.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLocation() {

        location_ = getDefaultInstance().getLocation();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Location of the diagnostic.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @param value The bytes for location to set.
       * @return This builder for chaining.
       */
      public Builder setLocationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        location_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object message_ = "";
      /**
       *
       *
       * <pre>
       * The diagnostic message.
       * </pre>
       *
       * <code>string message = 2;</code>
       *
       * @return The message.
       */
      public java.lang.String getMessage() {
        java.lang.Object ref = message_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          message_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The diagnostic message.
       * </pre>
       *
       * <code>string message = 2;</code>
       *
       * @return The bytes for message.
       */
      public com.google.protobuf.ByteString getMessageBytes() {
        java.lang.Object ref = message_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          message_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The diagnostic message.
       * </pre>
       *
       * <code>string message = 2;</code>
       *
       * @param value The message to set.
       * @return This builder for chaining.
       */
      public Builder setMessage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        message_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The diagnostic message.
       * </pre>
       *
       * <code>string message = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMessage() {

        message_ = getDefaultInstance().getMessage();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The diagnostic message.
       * </pre>
       *
       * <code>string message = 2;</code>
       *
       * @param value The bytes for message to set.
       * @return This builder for chaining.
       */
      public Builder setMessageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        message_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.apigateway.v1.OperationMetadata.Diagnostic)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.apigateway.v1.OperationMetadata.Diagnostic)
    private static final com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic();
    }

    public static com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Diagnostic> PARSER =
        new com.google.protobuf.AbstractParser<Diagnostic>() {
          @java.lang.Override
          public Diagnostic parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Diagnostic> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Diagnostic> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int END_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the operation finished running.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the operation finished running.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the operation finished running.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return getEndTime();
  }

  public static final int TARGET_FIELD_NUMBER = 3;
  private volatile java.lang.Object target_;
  /**
   *
   *
   * <pre>
   * Output only. Server-defined resource path for the target of the operation.
   * </pre>
   *
   * <code>string target = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The target.
   */
  @java.lang.Override
  public java.lang.String getTarget() {
    java.lang.Object ref = target_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      target_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Server-defined resource path for the target of the operation.
   * </pre>
   *
   * <code>string target = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for target.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetBytes() {
    java.lang.Object ref = target_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      target_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERB_FIELD_NUMBER = 4;
  private volatile java.lang.Object verb_;
  /**
   *
   *
   * <pre>
   * Output only. Name of the verb executed by the operation.
   * </pre>
   *
   * <code>string verb = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The verb.
   */
  @java.lang.Override
  public java.lang.String getVerb() {
    java.lang.Object ref = verb_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      verb_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of the verb executed by the operation.
   * </pre>
   *
   * <code>string verb = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for verb.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVerbBytes() {
    java.lang.Object ref = verb_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      verb_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_MESSAGE_FIELD_NUMBER = 5;
  private volatile java.lang.Object statusMessage_;
  /**
   *
   *
   * <pre>
   * Output only. Human-readable status of the operation, if any.
   * </pre>
   *
   * <code>string status_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The statusMessage.
   */
  @java.lang.Override
  public java.lang.String getStatusMessage() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      statusMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Human-readable status of the operation, if any.
   * </pre>
   *
   * <code>string status_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for statusMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusMessageBytes() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      statusMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUESTED_CANCELLATION_FIELD_NUMBER = 6;
  private boolean requestedCancellation_;
  /**
   *
   *
   * <pre>
   * Output only. Identifies whether the user has requested cancellation
   * of the operation. Operations that have successfully been cancelled
   * have [Operation.error][] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
   * corresponding to `Code.CANCELLED`.
   * </pre>
   *
   * <code>bool requested_cancellation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The requestedCancellation.
   */
  @java.lang.Override
  public boolean getRequestedCancellation() {
    return requestedCancellation_;
  }

  public static final int API_VERSION_FIELD_NUMBER = 7;
  private volatile java.lang.Object apiVersion_;
  /**
   *
   *
   * <pre>
   * Output only. API version used to start the operation.
   * </pre>
   *
   * <code>string api_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The apiVersion.
   */
  @java.lang.Override
  public java.lang.String getApiVersion() {
    java.lang.Object ref = apiVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      apiVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. API version used to start the operation.
   * </pre>
   *
   * <code>string api_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for apiVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getApiVersionBytes() {
    java.lang.Object ref = apiVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      apiVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DIAGNOSTICS_FIELD_NUMBER = 8;
  private java.util.List<com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic> diagnostics_;
  /**
   *
   *
   * <pre>
   * Output only. Diagnostics generated during processing of configuration source files.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.apigateway.v1.OperationMetadata.Diagnostic diagnostics = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic>
      getDiagnosticsList() {
    return diagnostics_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Diagnostics generated during processing of configuration source files.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.apigateway.v1.OperationMetadata.Diagnostic diagnostics = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.apigateway.v1.OperationMetadata.DiagnosticOrBuilder>
      getDiagnosticsOrBuilderList() {
    return diagnostics_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Diagnostics generated during processing of configuration source files.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.apigateway.v1.OperationMetadata.Diagnostic diagnostics = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getDiagnosticsCount() {
    return diagnostics_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Diagnostics generated during processing of configuration source files.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.apigateway.v1.OperationMetadata.Diagnostic diagnostics = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic getDiagnostics(int index) {
    return diagnostics_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Diagnostics generated during processing of configuration source files.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.apigateway.v1.OperationMetadata.Diagnostic diagnostics = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.apigateway.v1.OperationMetadata.DiagnosticOrBuilder
      getDiagnosticsOrBuilder(int index) {
    return diagnostics_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (createTime_ != null) {
      output.writeMessage(1, getCreateTime());
    }
    if (endTime_ != null) {
      output.writeMessage(2, getEndTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(target_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, target_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(verb_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, verb_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statusMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, statusMessage_);
    }
    if (requestedCancellation_ != false) {
      output.writeBool(6, requestedCancellation_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(apiVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, apiVersion_);
    }
    for (int i = 0; i < diagnostics_.size(); i++) {
      output.writeMessage(8, diagnostics_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCreateTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEndTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(target_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, target_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(verb_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, verb_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statusMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, statusMessage_);
    }
    if (requestedCancellation_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, requestedCancellation_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(apiVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, apiVersion_);
    }
    for (int i = 0; i < diagnostics_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, diagnostics_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.apigateway.v1.OperationMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.apigateway.v1.OperationMetadata other =
        (com.google.cloud.apigateway.v1.OperationMetadata) obj;

    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (!getTarget().equals(other.getTarget())) return false;
    if (!getVerb().equals(other.getVerb())) return false;
    if (!getStatusMessage().equals(other.getStatusMessage())) return false;
    if (getRequestedCancellation() != other.getRequestedCancellation()) return false;
    if (!getApiVersion().equals(other.getApiVersion())) return false;
    if (!getDiagnosticsList().equals(other.getDiagnosticsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (37 * hash) + TARGET_FIELD_NUMBER;
    hash = (53 * hash) + getTarget().hashCode();
    hash = (37 * hash) + VERB_FIELD_NUMBER;
    hash = (53 * hash) + getVerb().hashCode();
    hash = (37 * hash) + STATUS_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getStatusMessage().hashCode();
    hash = (37 * hash) + REQUESTED_CANCELLATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRequestedCancellation());
    hash = (37 * hash) + API_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getApiVersion().hashCode();
    if (getDiagnosticsCount() > 0) {
      hash = (37 * hash) + DIAGNOSTICS_FIELD_NUMBER;
      hash = (53 * hash) + getDiagnosticsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.apigateway.v1.OperationMetadata parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.apigateway.v1.OperationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.apigateway.v1.OperationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.apigateway.v1.OperationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.apigateway.v1.OperationMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.apigateway.v1.OperationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.apigateway.v1.OperationMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.apigateway.v1.OperationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.apigateway.v1.OperationMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.apigateway.v1.OperationMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.apigateway.v1.OperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.apigateway.v1.OperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.apigateway.v1.OperationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the metadata of the long-running operation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.apigateway.v1.OperationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.apigateway.v1.OperationMetadata)
      com.google.cloud.apigateway.v1.OperationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.apigateway.v1.Apigateway
          .internal_static_google_cloud_apigateway_v1_OperationMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.apigateway.v1.Apigateway
          .internal_static_google_cloud_apigateway_v1_OperationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.apigateway.v1.OperationMetadata.class,
              com.google.cloud.apigateway.v1.OperationMetadata.Builder.class);
    }

    // Construct using com.google.cloud.apigateway.v1.OperationMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (endTimeBuilder_ == null) {
        endTime_ = null;
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }
      target_ = "";

      verb_ = "";

      statusMessage_ = "";

      requestedCancellation_ = false;

      apiVersion_ = "";

      if (diagnosticsBuilder_ == null) {
        diagnostics_ = java.util.Collections.emptyList();
      } else {
        diagnostics_ = null;
        diagnosticsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.apigateway.v1.Apigateway
          .internal_static_google_cloud_apigateway_v1_OperationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.apigateway.v1.OperationMetadata getDefaultInstanceForType() {
      return com.google.cloud.apigateway.v1.OperationMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.apigateway.v1.OperationMetadata build() {
      com.google.cloud.apigateway.v1.OperationMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.apigateway.v1.OperationMetadata buildPartial() {
      com.google.cloud.apigateway.v1.OperationMetadata result =
          new com.google.cloud.apigateway.v1.OperationMetadata(this);
      int from_bitField0_ = bitField0_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (endTimeBuilder_ == null) {
        result.endTime_ = endTime_;
      } else {
        result.endTime_ = endTimeBuilder_.build();
      }
      result.target_ = target_;
      result.verb_ = verb_;
      result.statusMessage_ = statusMessage_;
      result.requestedCancellation_ = requestedCancellation_;
      result.apiVersion_ = apiVersion_;
      if (diagnosticsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          diagnostics_ = java.util.Collections.unmodifiableList(diagnostics_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.diagnostics_ = diagnostics_;
      } else {
        result.diagnostics_ = diagnosticsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.apigateway.v1.OperationMetadata) {
        return mergeFrom((com.google.cloud.apigateway.v1.OperationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.apigateway.v1.OperationMetadata other) {
      if (other == com.google.cloud.apigateway.v1.OperationMetadata.getDefaultInstance())
        return this;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (!other.getTarget().isEmpty()) {
        target_ = other.target_;
        onChanged();
      }
      if (!other.getVerb().isEmpty()) {
        verb_ = other.verb_;
        onChanged();
      }
      if (!other.getStatusMessage().isEmpty()) {
        statusMessage_ = other.statusMessage_;
        onChanged();
      }
      if (other.getRequestedCancellation() != false) {
        setRequestedCancellation(other.getRequestedCancellation());
      }
      if (!other.getApiVersion().isEmpty()) {
        apiVersion_ = other.apiVersion_;
        onChanged();
      }
      if (diagnosticsBuilder_ == null) {
        if (!other.diagnostics_.isEmpty()) {
          if (diagnostics_.isEmpty()) {
            diagnostics_ = other.diagnostics_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureDiagnosticsIsMutable();
            diagnostics_.addAll(other.diagnostics_);
          }
          onChanged();
        }
      } else {
        if (!other.diagnostics_.isEmpty()) {
          if (diagnosticsBuilder_.isEmpty()) {
            diagnosticsBuilder_.dispose();
            diagnosticsBuilder_ = null;
            diagnostics_ = other.diagnostics_;
            bitField0_ = (bitField0_ & ~0x00000001);
            diagnosticsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDiagnosticsFieldBuilder()
                    : null;
          } else {
            diagnosticsBuilder_.addAllMessages(other.diagnostics_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                target_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 34:
              {
                verb_ = input.readStringRequireUtf8();

                break;
              } // case 34
            case 42:
              {
                statusMessage_ = input.readStringRequireUtf8();

                break;
              } // case 42
            case 48:
              {
                requestedCancellation_ = input.readBool();

                break;
              } // case 48
            case 58:
              {
                apiVersion_ = input.readStringRequireUtf8();

                break;
              } // case 58
            case 66:
              {
                com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic m =
                    input.readMessage(
                        com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic.parser(),
                        extensionRegistry);
                if (diagnosticsBuilder_ == null) {
                  ensureDiagnosticsIsMutable();
                  diagnostics_.add(m);
                } else {
                  diagnosticsBuilder_.addMessage(m);
                }
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return endTimeBuilder_ != null || endTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
        onChanged();
      } else {
        endTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
        onChanged();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (endTime_ != null) {
          endTime_ =
              com.google.protobuf.Timestamp.newBuilder(endTime_).mergeFrom(value).buildPartial();
        } else {
          endTime_ = value;
        }
        onChanged();
      } else {
        endTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      if (endTimeBuilder_ == null) {
        endTime_ = null;
        onChanged();
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {

      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private java.lang.Object target_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Server-defined resource path for the target of the operation.
     * </pre>
     *
     * <code>string target = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The target.
     */
    public java.lang.String getTarget() {
      java.lang.Object ref = target_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        target_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server-defined resource path for the target of the operation.
     * </pre>
     *
     * <code>string target = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for target.
     */
    public com.google.protobuf.ByteString getTargetBytes() {
      java.lang.Object ref = target_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        target_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server-defined resource path for the target of the operation.
     * </pre>
     *
     * <code>string target = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The target to set.
     * @return This builder for chaining.
     */
    public Builder setTarget(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      target_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server-defined resource path for the target of the operation.
     * </pre>
     *
     * <code>string target = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTarget() {

      target_ = getDefaultInstance().getTarget();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server-defined resource path for the target of the operation.
     * </pre>
     *
     * <code>string target = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for target to set.
     * @return This builder for chaining.
     */
    public Builder setTargetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      target_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object verb_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of the verb executed by the operation.
     * </pre>
     *
     * <code>string verb = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The verb.
     */
    public java.lang.String getVerb() {
      java.lang.Object ref = verb_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        verb_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the verb executed by the operation.
     * </pre>
     *
     * <code>string verb = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for verb.
     */
    public com.google.protobuf.ByteString getVerbBytes() {
      java.lang.Object ref = verb_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        verb_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the verb executed by the operation.
     * </pre>
     *
     * <code>string verb = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The verb to set.
     * @return This builder for chaining.
     */
    public Builder setVerb(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      verb_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the verb executed by the operation.
     * </pre>
     *
     * <code>string verb = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVerb() {

      verb_ = getDefaultInstance().getVerb();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the verb executed by the operation.
     * </pre>
     *
     * <code>string verb = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for verb to set.
     * @return This builder for chaining.
     */
    public Builder setVerbBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      verb_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object statusMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Human-readable status of the operation, if any.
     * </pre>
     *
     * <code>string status_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The statusMessage.
     */
    public java.lang.String getStatusMessage() {
      java.lang.Object ref = statusMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        statusMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Human-readable status of the operation, if any.
     * </pre>
     *
     * <code>string status_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for statusMessage.
     */
    public com.google.protobuf.ByteString getStatusMessageBytes() {
      java.lang.Object ref = statusMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        statusMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Human-readable status of the operation, if any.
     * </pre>
     *
     * <code>string status_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The statusMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStatusMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      statusMessage_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Human-readable status of the operation, if any.
     * </pre>
     *
     * <code>string status_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatusMessage() {

      statusMessage_ = getDefaultInstance().getStatusMessage();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Human-readable status of the operation, if any.
     * </pre>
     *
     * <code>string status_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for statusMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStatusMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      statusMessage_ = value;
      onChanged();
      return this;
    }

    private boolean requestedCancellation_;
    /**
     *
     *
     * <pre>
     * Output only. Identifies whether the user has requested cancellation
     * of the operation. Operations that have successfully been cancelled
     * have [Operation.error][] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
     * corresponding to `Code.CANCELLED`.
     * </pre>
     *
     * <code>bool requested_cancellation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The requestedCancellation.
     */
    @java.lang.Override
    public boolean getRequestedCancellation() {
      return requestedCancellation_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifies whether the user has requested cancellation
     * of the operation. Operations that have successfully been cancelled
     * have [Operation.error][] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
     * corresponding to `Code.CANCELLED`.
     * </pre>
     *
     * <code>bool requested_cancellation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The requestedCancellation to set.
     * @return This builder for chaining.
     */
    public Builder setRequestedCancellation(boolean value) {

      requestedCancellation_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifies whether the user has requested cancellation
     * of the operation. Operations that have successfully been cancelled
     * have [Operation.error][] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
     * corresponding to `Code.CANCELLED`.
     * </pre>
     *
     * <code>bool requested_cancellation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestedCancellation() {

      requestedCancellation_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object apiVersion_ = "";
    /**
     *
     *
     * <pre>
     * Output only. API version used to start the operation.
     * </pre>
     *
     * <code>string api_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The apiVersion.
     */
    public java.lang.String getApiVersion() {
      java.lang.Object ref = apiVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        apiVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. API version used to start the operation.
     * </pre>
     *
     * <code>string api_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for apiVersion.
     */
    public com.google.protobuf.ByteString getApiVersionBytes() {
      java.lang.Object ref = apiVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        apiVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. API version used to start the operation.
     * </pre>
     *
     * <code>string api_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The apiVersion to set.
     * @return This builder for chaining.
     */
    public Builder setApiVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      apiVersion_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. API version used to start the operation.
     * </pre>
     *
     * <code>string api_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearApiVersion() {

      apiVersion_ = getDefaultInstance().getApiVersion();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. API version used to start the operation.
     * </pre>
     *
     * <code>string api_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for apiVersion to set.
     * @return This builder for chaining.
     */
    public Builder setApiVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      apiVersion_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic>
        diagnostics_ = java.util.Collections.emptyList();

    private void ensureDiagnosticsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        diagnostics_ =
            new java.util.ArrayList<com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic>(
                diagnostics_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic,
            com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic.Builder,
            com.google.cloud.apigateway.v1.OperationMetadata.DiagnosticOrBuilder>
        diagnosticsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Diagnostics generated during processing of configuration source files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.OperationMetadata.Diagnostic diagnostics = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic>
        getDiagnosticsList() {
      if (diagnosticsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(diagnostics_);
      } else {
        return diagnosticsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Diagnostics generated during processing of configuration source files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.OperationMetadata.Diagnostic diagnostics = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getDiagnosticsCount() {
      if (diagnosticsBuilder_ == null) {
        return diagnostics_.size();
      } else {
        return diagnosticsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Diagnostics generated during processing of configuration source files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.OperationMetadata.Diagnostic diagnostics = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic getDiagnostics(int index) {
      if (diagnosticsBuilder_ == null) {
        return diagnostics_.get(index);
      } else {
        return diagnosticsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Diagnostics generated during processing of configuration source files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.OperationMetadata.Diagnostic diagnostics = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDiagnostics(
        int index, com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic value) {
      if (diagnosticsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDiagnosticsIsMutable();
        diagnostics_.set(index, value);
        onChanged();
      } else {
        diagnosticsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Diagnostics generated during processing of configuration source files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.OperationMetadata.Diagnostic diagnostics = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDiagnostics(
        int index,
        com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic.Builder builderForValue) {
      if (diagnosticsBuilder_ == null) {
        ensureDiagnosticsIsMutable();
        diagnostics_.set(index, builderForValue.build());
        onChanged();
      } else {
        diagnosticsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Diagnostics generated during processing of configuration source files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.OperationMetadata.Diagnostic diagnostics = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addDiagnostics(
        com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic value) {
      if (diagnosticsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDiagnosticsIsMutable();
        diagnostics_.add(value);
        onChanged();
      } else {
        diagnosticsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Diagnostics generated during processing of configuration source files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.OperationMetadata.Diagnostic diagnostics = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addDiagnostics(
        int index, com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic value) {
      if (diagnosticsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDiagnosticsIsMutable();
        diagnostics_.add(index, value);
        onChanged();
      } else {
        diagnosticsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Diagnostics generated during processing of configuration source files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.OperationMetadata.Diagnostic diagnostics = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addDiagnostics(
        com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic.Builder builderForValue) {
      if (diagnosticsBuilder_ == null) {
        ensureDiagnosticsIsMutable();
        diagnostics_.add(builderForValue.build());
        onChanged();
      } else {
        diagnosticsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Diagnostics generated during processing of configuration source files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.OperationMetadata.Diagnostic diagnostics = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addDiagnostics(
        int index,
        com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic.Builder builderForValue) {
      if (diagnosticsBuilder_ == null) {
        ensureDiagnosticsIsMutable();
        diagnostics_.add(index, builderForValue.build());
        onChanged();
      } else {
        diagnosticsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Diagnostics generated during processing of configuration source files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.OperationMetadata.Diagnostic diagnostics = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllDiagnostics(
        java.lang.Iterable<? extends com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic>
            values) {
      if (diagnosticsBuilder_ == null) {
        ensureDiagnosticsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, diagnostics_);
        onChanged();
      } else {
        diagnosticsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Diagnostics generated during processing of configuration source files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.OperationMetadata.Diagnostic diagnostics = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDiagnostics() {
      if (diagnosticsBuilder_ == null) {
        diagnostics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        diagnosticsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Diagnostics generated during processing of configuration source files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.OperationMetadata.Diagnostic diagnostics = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeDiagnostics(int index) {
      if (diagnosticsBuilder_ == null) {
        ensureDiagnosticsIsMutable();
        diagnostics_.remove(index);
        onChanged();
      } else {
        diagnosticsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Diagnostics generated during processing of configuration source files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.OperationMetadata.Diagnostic diagnostics = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic.Builder
        getDiagnosticsBuilder(int index) {
      return getDiagnosticsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Diagnostics generated during processing of configuration source files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.OperationMetadata.Diagnostic diagnostics = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.apigateway.v1.OperationMetadata.DiagnosticOrBuilder
        getDiagnosticsOrBuilder(int index) {
      if (diagnosticsBuilder_ == null) {
        return diagnostics_.get(index);
      } else {
        return diagnosticsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Diagnostics generated during processing of configuration source files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.OperationMetadata.Diagnostic diagnostics = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.apigateway.v1.OperationMetadata.DiagnosticOrBuilder>
        getDiagnosticsOrBuilderList() {
      if (diagnosticsBuilder_ != null) {
        return diagnosticsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(diagnostics_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Diagnostics generated during processing of configuration source files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.OperationMetadata.Diagnostic diagnostics = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic.Builder
        addDiagnosticsBuilder() {
      return getDiagnosticsFieldBuilder()
          .addBuilder(
              com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Diagnostics generated during processing of configuration source files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.OperationMetadata.Diagnostic diagnostics = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic.Builder
        addDiagnosticsBuilder(int index) {
      return getDiagnosticsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Diagnostics generated during processing of configuration source files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.OperationMetadata.Diagnostic diagnostics = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic.Builder>
        getDiagnosticsBuilderList() {
      return getDiagnosticsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic,
            com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic.Builder,
            com.google.cloud.apigateway.v1.OperationMetadata.DiagnosticOrBuilder>
        getDiagnosticsFieldBuilder() {
      if (diagnosticsBuilder_ == null) {
        diagnosticsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic,
                com.google.cloud.apigateway.v1.OperationMetadata.Diagnostic.Builder,
                com.google.cloud.apigateway.v1.OperationMetadata.DiagnosticOrBuilder>(
                diagnostics_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        diagnostics_ = null;
      }
      return diagnosticsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.apigateway.v1.OperationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.apigateway.v1.OperationMetadata)
  private static final com.google.cloud.apigateway.v1.OperationMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.apigateway.v1.OperationMetadata();
  }

  public static com.google.cloud.apigateway.v1.OperationMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OperationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<OperationMetadata>() {
        @java.lang.Override
        public OperationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OperationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OperationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.apigateway.v1.OperationMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
