/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/apigateway/v1/apigateway.proto

package com.google.cloud.apigateway.v1;

/**
 *
 *
 * <pre>
 * Response message for ApiGatewayService.ListApis
 * </pre>
 *
 * Protobuf type {@code google.cloud.apigateway.v1.ListApisResponse}
 */
public final class ListApisResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.apigateway.v1.ListApisResponse)
    ListApisResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListApisResponse.newBuilder() to construct.
  private ListApisResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListApisResponse() {
    apis_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
    unreachableLocations_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListApisResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.apigateway.v1.Apigateway
        .internal_static_google_cloud_apigateway_v1_ListApisResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.apigateway.v1.Apigateway
        .internal_static_google_cloud_apigateway_v1_ListApisResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.apigateway.v1.ListApisResponse.class,
            com.google.cloud.apigateway.v1.ListApisResponse.Builder.class);
  }

  public static final int APIS_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.apigateway.v1.Api> apis_;
  /**
   *
   *
   * <pre>
   * APIs.
   * </pre>
   *
   * <code>repeated .google.cloud.apigateway.v1.Api apis = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.apigateway.v1.Api> getApisList() {
    return apis_;
  }
  /**
   *
   *
   * <pre>
   * APIs.
   * </pre>
   *
   * <code>repeated .google.cloud.apigateway.v1.Api apis = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.apigateway.v1.ApiOrBuilder>
      getApisOrBuilderList() {
    return apis_;
  }
  /**
   *
   *
   * <pre>
   * APIs.
   * </pre>
   *
   * <code>repeated .google.cloud.apigateway.v1.Api apis = 1;</code>
   */
  @java.lang.Override
  public int getApisCount() {
    return apis_.size();
  }
  /**
   *
   *
   * <pre>
   * APIs.
   * </pre>
   *
   * <code>repeated .google.cloud.apigateway.v1.Api apis = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.apigateway.v1.Api getApis(int index) {
    return apis_.get(index);
  }
  /**
   *
   *
   * <pre>
   * APIs.
   * </pre>
   *
   * <code>repeated .google.cloud.apigateway.v1.Api apis = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.apigateway.v1.ApiOrBuilder getApisOrBuilder(int index) {
    return apis_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;
  private volatile java.lang.Object nextPageToken_;
  /**
   *
   *
   * <pre>
   * Next page token.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Next page token.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UNREACHABLE_LOCATIONS_FIELD_NUMBER = 3;
  private com.google.protobuf.LazyStringList unreachableLocations_;
  /**
   *
   *
   * <pre>
   * Locations that could not be reached.
   * </pre>
   *
   * <code>repeated string unreachable_locations = 3;</code>
   *
   * @return A list containing the unreachableLocations.
   */
  public com.google.protobuf.ProtocolStringList getUnreachableLocationsList() {
    return unreachableLocations_;
  }
  /**
   *
   *
   * <pre>
   * Locations that could not be reached.
   * </pre>
   *
   * <code>repeated string unreachable_locations = 3;</code>
   *
   * @return The count of unreachableLocations.
   */
  public int getUnreachableLocationsCount() {
    return unreachableLocations_.size();
  }
  /**
   *
   *
   * <pre>
   * Locations that could not be reached.
   * </pre>
   *
   * <code>repeated string unreachable_locations = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The unreachableLocations at the given index.
   */
  public java.lang.String getUnreachableLocations(int index) {
    return unreachableLocations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Locations that could not be reached.
   * </pre>
   *
   * <code>repeated string unreachable_locations = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the unreachableLocations at the given index.
   */
  public com.google.protobuf.ByteString getUnreachableLocationsBytes(int index) {
    return unreachableLocations_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < apis_.size(); i++) {
      output.writeMessage(1, apis_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
    }
    for (int i = 0; i < unreachableLocations_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 3, unreachableLocations_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < apis_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, apis_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < unreachableLocations_.size(); i++) {
        dataSize += computeStringSizeNoTag(unreachableLocations_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getUnreachableLocationsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.apigateway.v1.ListApisResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.apigateway.v1.ListApisResponse other =
        (com.google.cloud.apigateway.v1.ListApisResponse) obj;

    if (!getApisList().equals(other.getApisList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!getUnreachableLocationsList().equals(other.getUnreachableLocationsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getApisCount() > 0) {
      hash = (37 * hash) + APIS_FIELD_NUMBER;
      hash = (53 * hash) + getApisList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    if (getUnreachableLocationsCount() > 0) {
      hash = (37 * hash) + UNREACHABLE_LOCATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getUnreachableLocationsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.apigateway.v1.ListApisResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.apigateway.v1.ListApisResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.apigateway.v1.ListApisResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.apigateway.v1.ListApisResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.apigateway.v1.ListApisResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.apigateway.v1.ListApisResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.apigateway.v1.ListApisResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.apigateway.v1.ListApisResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.apigateway.v1.ListApisResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.apigateway.v1.ListApisResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.apigateway.v1.ListApisResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.apigateway.v1.ListApisResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.apigateway.v1.ListApisResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for ApiGatewayService.ListApis
   * </pre>
   *
   * Protobuf type {@code google.cloud.apigateway.v1.ListApisResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.apigateway.v1.ListApisResponse)
      com.google.cloud.apigateway.v1.ListApisResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.apigateway.v1.Apigateway
          .internal_static_google_cloud_apigateway_v1_ListApisResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.apigateway.v1.Apigateway
          .internal_static_google_cloud_apigateway_v1_ListApisResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.apigateway.v1.ListApisResponse.class,
              com.google.cloud.apigateway.v1.ListApisResponse.Builder.class);
    }

    // Construct using com.google.cloud.apigateway.v1.ListApisResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (apisBuilder_ == null) {
        apis_ = java.util.Collections.emptyList();
      } else {
        apis_ = null;
        apisBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      nextPageToken_ = "";

      unreachableLocations_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.apigateway.v1.Apigateway
          .internal_static_google_cloud_apigateway_v1_ListApisResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.apigateway.v1.ListApisResponse getDefaultInstanceForType() {
      return com.google.cloud.apigateway.v1.ListApisResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.apigateway.v1.ListApisResponse build() {
      com.google.cloud.apigateway.v1.ListApisResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.apigateway.v1.ListApisResponse buildPartial() {
      com.google.cloud.apigateway.v1.ListApisResponse result =
          new com.google.cloud.apigateway.v1.ListApisResponse(this);
      int from_bitField0_ = bitField0_;
      if (apisBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          apis_ = java.util.Collections.unmodifiableList(apis_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.apis_ = apis_;
      } else {
        result.apis_ = apisBuilder_.build();
      }
      result.nextPageToken_ = nextPageToken_;
      if (((bitField0_ & 0x00000002) != 0)) {
        unreachableLocations_ = unreachableLocations_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.unreachableLocations_ = unreachableLocations_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.apigateway.v1.ListApisResponse) {
        return mergeFrom((com.google.cloud.apigateway.v1.ListApisResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.apigateway.v1.ListApisResponse other) {
      if (other == com.google.cloud.apigateway.v1.ListApisResponse.getDefaultInstance())
        return this;
      if (apisBuilder_ == null) {
        if (!other.apis_.isEmpty()) {
          if (apis_.isEmpty()) {
            apis_ = other.apis_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureApisIsMutable();
            apis_.addAll(other.apis_);
          }
          onChanged();
        }
      } else {
        if (!other.apis_.isEmpty()) {
          if (apisBuilder_.isEmpty()) {
            apisBuilder_.dispose();
            apisBuilder_ = null;
            apis_ = other.apis_;
            bitField0_ = (bitField0_ & ~0x00000001);
            apisBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getApisFieldBuilder()
                    : null;
          } else {
            apisBuilder_.addAllMessages(other.apis_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        onChanged();
      }
      if (!other.unreachableLocations_.isEmpty()) {
        if (unreachableLocations_.isEmpty()) {
          unreachableLocations_ = other.unreachableLocations_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureUnreachableLocationsIsMutable();
          unreachableLocations_.addAll(other.unreachableLocations_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.apigateway.v1.Api m =
                    input.readMessage(
                        com.google.cloud.apigateway.v1.Api.parser(), extensionRegistry);
                if (apisBuilder_ == null) {
                  ensureApisIsMutable();
                  apis_.add(m);
                } else {
                  apisBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                nextPageToken_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureUnreachableLocationsIsMutable();
                unreachableLocations_.add(s);
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.apigateway.v1.Api> apis_ =
        java.util.Collections.emptyList();

    private void ensureApisIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        apis_ = new java.util.ArrayList<com.google.cloud.apigateway.v1.Api>(apis_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.apigateway.v1.Api,
            com.google.cloud.apigateway.v1.Api.Builder,
            com.google.cloud.apigateway.v1.ApiOrBuilder>
        apisBuilder_;

    /**
     *
     *
     * <pre>
     * APIs.
     * </pre>
     *
     * <code>repeated .google.cloud.apigateway.v1.Api apis = 1;</code>
     */
    public java.util.List<com.google.cloud.apigateway.v1.Api> getApisList() {
      if (apisBuilder_ == null) {
        return java.util.Collections.unmodifiableList(apis_);
      } else {
        return apisBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * APIs.
     * </pre>
     *
     * <code>repeated .google.cloud.apigateway.v1.Api apis = 1;</code>
     */
    public int getApisCount() {
      if (apisBuilder_ == null) {
        return apis_.size();
      } else {
        return apisBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * APIs.
     * </pre>
     *
     * <code>repeated .google.cloud.apigateway.v1.Api apis = 1;</code>
     */
    public com.google.cloud.apigateway.v1.Api getApis(int index) {
      if (apisBuilder_ == null) {
        return apis_.get(index);
      } else {
        return apisBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * APIs.
     * </pre>
     *
     * <code>repeated .google.cloud.apigateway.v1.Api apis = 1;</code>
     */
    public Builder setApis(int index, com.google.cloud.apigateway.v1.Api value) {
      if (apisBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureApisIsMutable();
        apis_.set(index, value);
        onChanged();
      } else {
        apisBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * APIs.
     * </pre>
     *
     * <code>repeated .google.cloud.apigateway.v1.Api apis = 1;</code>
     */
    public Builder setApis(int index, com.google.cloud.apigateway.v1.Api.Builder builderForValue) {
      if (apisBuilder_ == null) {
        ensureApisIsMutable();
        apis_.set(index, builderForValue.build());
        onChanged();
      } else {
        apisBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * APIs.
     * </pre>
     *
     * <code>repeated .google.cloud.apigateway.v1.Api apis = 1;</code>
     */
    public Builder addApis(com.google.cloud.apigateway.v1.Api value) {
      if (apisBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureApisIsMutable();
        apis_.add(value);
        onChanged();
      } else {
        apisBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * APIs.
     * </pre>
     *
     * <code>repeated .google.cloud.apigateway.v1.Api apis = 1;</code>
     */
    public Builder addApis(int index, com.google.cloud.apigateway.v1.Api value) {
      if (apisBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureApisIsMutable();
        apis_.add(index, value);
        onChanged();
      } else {
        apisBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * APIs.
     * </pre>
     *
     * <code>repeated .google.cloud.apigateway.v1.Api apis = 1;</code>
     */
    public Builder addApis(com.google.cloud.apigateway.v1.Api.Builder builderForValue) {
      if (apisBuilder_ == null) {
        ensureApisIsMutable();
        apis_.add(builderForValue.build());
        onChanged();
      } else {
        apisBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * APIs.
     * </pre>
     *
     * <code>repeated .google.cloud.apigateway.v1.Api apis = 1;</code>
     */
    public Builder addApis(int index, com.google.cloud.apigateway.v1.Api.Builder builderForValue) {
      if (apisBuilder_ == null) {
        ensureApisIsMutable();
        apis_.add(index, builderForValue.build());
        onChanged();
      } else {
        apisBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * APIs.
     * </pre>
     *
     * <code>repeated .google.cloud.apigateway.v1.Api apis = 1;</code>
     */
    public Builder addAllApis(
        java.lang.Iterable<? extends com.google.cloud.apigateway.v1.Api> values) {
      if (apisBuilder_ == null) {
        ensureApisIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, apis_);
        onChanged();
      } else {
        apisBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * APIs.
     * </pre>
     *
     * <code>repeated .google.cloud.apigateway.v1.Api apis = 1;</code>
     */
    public Builder clearApis() {
      if (apisBuilder_ == null) {
        apis_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        apisBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * APIs.
     * </pre>
     *
     * <code>repeated .google.cloud.apigateway.v1.Api apis = 1;</code>
     */
    public Builder removeApis(int index) {
      if (apisBuilder_ == null) {
        ensureApisIsMutable();
        apis_.remove(index);
        onChanged();
      } else {
        apisBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * APIs.
     * </pre>
     *
     * <code>repeated .google.cloud.apigateway.v1.Api apis = 1;</code>
     */
    public com.google.cloud.apigateway.v1.Api.Builder getApisBuilder(int index) {
      return getApisFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * APIs.
     * </pre>
     *
     * <code>repeated .google.cloud.apigateway.v1.Api apis = 1;</code>
     */
    public com.google.cloud.apigateway.v1.ApiOrBuilder getApisOrBuilder(int index) {
      if (apisBuilder_ == null) {
        return apis_.get(index);
      } else {
        return apisBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * APIs.
     * </pre>
     *
     * <code>repeated .google.cloud.apigateway.v1.Api apis = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.apigateway.v1.ApiOrBuilder>
        getApisOrBuilderList() {
      if (apisBuilder_ != null) {
        return apisBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(apis_);
      }
    }
    /**
     *
     *
     * <pre>
     * APIs.
     * </pre>
     *
     * <code>repeated .google.cloud.apigateway.v1.Api apis = 1;</code>
     */
    public com.google.cloud.apigateway.v1.Api.Builder addApisBuilder() {
      return getApisFieldBuilder()
          .addBuilder(com.google.cloud.apigateway.v1.Api.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * APIs.
     * </pre>
     *
     * <code>repeated .google.cloud.apigateway.v1.Api apis = 1;</code>
     */
    public com.google.cloud.apigateway.v1.Api.Builder addApisBuilder(int index) {
      return getApisFieldBuilder()
          .addBuilder(index, com.google.cloud.apigateway.v1.Api.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * APIs.
     * </pre>
     *
     * <code>repeated .google.cloud.apigateway.v1.Api apis = 1;</code>
     */
    public java.util.List<com.google.cloud.apigateway.v1.Api.Builder> getApisBuilderList() {
      return getApisFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.apigateway.v1.Api,
            com.google.cloud.apigateway.v1.Api.Builder,
            com.google.cloud.apigateway.v1.ApiOrBuilder>
        getApisFieldBuilder() {
      if (apisBuilder_ == null) {
        apisBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.apigateway.v1.Api,
                com.google.cloud.apigateway.v1.Api.Builder,
                com.google.cloud.apigateway.v1.ApiOrBuilder>(
                apis_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        apis_ = null;
      }
      return apisBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * Next page token.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Next page token.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Next page token.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      nextPageToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Next page token.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {

      nextPageToken_ = getDefaultInstance().getNextPageToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Next page token.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      nextPageToken_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList unreachableLocations_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureUnreachableLocationsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        unreachableLocations_ = new com.google.protobuf.LazyStringArrayList(unreachableLocations_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable_locations = 3;</code>
     *
     * @return A list containing the unreachableLocations.
     */
    public com.google.protobuf.ProtocolStringList getUnreachableLocationsList() {
      return unreachableLocations_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable_locations = 3;</code>
     *
     * @return The count of unreachableLocations.
     */
    public int getUnreachableLocationsCount() {
      return unreachableLocations_.size();
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable_locations = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The unreachableLocations at the given index.
     */
    public java.lang.String getUnreachableLocations(int index) {
      return unreachableLocations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable_locations = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the unreachableLocations at the given index.
     */
    public com.google.protobuf.ByteString getUnreachableLocationsBytes(int index) {
      return unreachableLocations_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable_locations = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The unreachableLocations to set.
     * @return This builder for chaining.
     */
    public Builder setUnreachableLocations(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUnreachableLocationsIsMutable();
      unreachableLocations_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable_locations = 3;</code>
     *
     * @param value The unreachableLocations to add.
     * @return This builder for chaining.
     */
    public Builder addUnreachableLocations(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUnreachableLocationsIsMutable();
      unreachableLocations_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable_locations = 3;</code>
     *
     * @param values The unreachableLocations to add.
     * @return This builder for chaining.
     */
    public Builder addAllUnreachableLocations(java.lang.Iterable<java.lang.String> values) {
      ensureUnreachableLocationsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, unreachableLocations_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable_locations = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnreachableLocations() {
      unreachableLocations_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable_locations = 3;</code>
     *
     * @param value The bytes of the unreachableLocations to add.
     * @return This builder for chaining.
     */
    public Builder addUnreachableLocationsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureUnreachableLocationsIsMutable();
      unreachableLocations_.add(value);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.apigateway.v1.ListApisResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.apigateway.v1.ListApisResponse)
  private static final com.google.cloud.apigateway.v1.ListApisResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.apigateway.v1.ListApisResponse();
  }

  public static com.google.cloud.apigateway.v1.ListApisResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListApisResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListApisResponse>() {
        @java.lang.Override
        public ListApisResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListApisResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListApisResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.apigateway.v1.ListApisResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
