/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/apigateway/v1/apigateway.proto

package com.google.cloud.apigateway.v1;

/**
 *
 *
 * <pre>
 * An API Configuration is a combination of settings for both the Managed
 * Service and Gateways serving this API Config.
 * </pre>
 *
 * Protobuf type {@code google.cloud.apigateway.v1.ApiConfig}
 */
public final class ApiConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.apigateway.v1.ApiConfig)
    ApiConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ApiConfig.newBuilder() to construct.
  private ApiConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ApiConfig() {
    name_ = "";
    displayName_ = "";
    gatewayServiceAccount_ = "";
    serviceConfigId_ = "";
    state_ = 0;
    openapiDocuments_ = java.util.Collections.emptyList();
    grpcServices_ = java.util.Collections.emptyList();
    managedServiceConfigs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ApiConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.apigateway.v1.Apigateway
        .internal_static_google_cloud_apigateway_v1_ApiConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.apigateway.v1.Apigateway
        .internal_static_google_cloud_apigateway_v1_ApiConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.apigateway.v1.ApiConfig.class,
            com.google.cloud.apigateway.v1.ApiConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * All the possible API Config states.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.apigateway.v1.ApiConfig.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * API Config does not have a state yet.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * API Config is being created and deployed to the API Controller.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * API Config is ready for use by Gateways.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    ACTIVE(2),
    /**
     *
     *
     * <pre>
     * API Config creation failed.
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    FAILED(3),
    /**
     *
     *
     * <pre>
     * API Config is being deleted.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    DELETING(4),
    /**
     *
     *
     * <pre>
     * API Config is being updated.
     * </pre>
     *
     * <code>UPDATING = 5;</code>
     */
    UPDATING(5),
    /**
     *
     *
     * <pre>
     * API Config settings are being activated in downstream systems.
     * API Configs in this state cannot be used by Gateways.
     * </pre>
     *
     * <code>ACTIVATING = 6;</code>
     */
    ACTIVATING(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * API Config does not have a state yet.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * API Config is being created and deployed to the API Controller.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * API Config is ready for use by Gateways.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    public static final int ACTIVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * API Config creation failed.
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    public static final int FAILED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * API Config is being deleted.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    public static final int DELETING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * API Config is being updated.
     * </pre>
     *
     * <code>UPDATING = 5;</code>
     */
    public static final int UPDATING_VALUE = 5;
    /**
     *
     *
     * <pre>
     * API Config settings are being activated in downstream systems.
     * API Configs in this state cannot be used by Gateways.
     * </pre>
     *
     * <code>ACTIVATING = 6;</code>
     */
    public static final int ACTIVATING_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return ACTIVE;
        case 3:
          return FAILED;
        case 4:
          return DELETING;
        case 5:
          return UPDATING;
        case 6:
          return ACTIVATING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.apigateway.v1.ApiConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.apigateway.v1.ApiConfig.State)
  }

  public interface FileOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.apigateway.v1.ApiConfig.File)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The file path (full or relative path). This is typically the path of the
     * file when it is uploaded.
     * </pre>
     *
     * <code>string path = 1;</code>
     *
     * @return The path.
     */
    java.lang.String getPath();
    /**
     *
     *
     * <pre>
     * The file path (full or relative path). This is typically the path of the
     * file when it is uploaded.
     * </pre>
     *
     * <code>string path = 1;</code>
     *
     * @return The bytes for path.
     */
    com.google.protobuf.ByteString getPathBytes();

    /**
     *
     *
     * <pre>
     * The bytes that constitute the file.
     * </pre>
     *
     * <code>bytes contents = 2;</code>
     *
     * @return The contents.
     */
    com.google.protobuf.ByteString getContents();
  }
  /**
   *
   *
   * <pre>
   * A lightweight description of a file.
   * </pre>
   *
   * Protobuf type {@code google.cloud.apigateway.v1.ApiConfig.File}
   */
  public static final class File extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.apigateway.v1.ApiConfig.File)
      FileOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use File.newBuilder() to construct.
    private File(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private File() {
      path_ = "";
      contents_ = com.google.protobuf.ByteString.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new File();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.apigateway.v1.Apigateway
          .internal_static_google_cloud_apigateway_v1_ApiConfig_File_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.apigateway.v1.Apigateway
          .internal_static_google_cloud_apigateway_v1_ApiConfig_File_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.apigateway.v1.ApiConfig.File.class,
              com.google.cloud.apigateway.v1.ApiConfig.File.Builder.class);
    }

    public static final int PATH_FIELD_NUMBER = 1;
    private volatile java.lang.Object path_;
    /**
     *
     *
     * <pre>
     * The file path (full or relative path). This is typically the path of the
     * file when it is uploaded.
     * </pre>
     *
     * <code>string path = 1;</code>
     *
     * @return The path.
     */
    @java.lang.Override
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        path_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The file path (full or relative path). This is typically the path of the
     * file when it is uploaded.
     * </pre>
     *
     * <code>string path = 1;</code>
     *
     * @return The bytes for path.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONTENTS_FIELD_NUMBER = 2;
    private com.google.protobuf.ByteString contents_;
    /**
     *
     *
     * <pre>
     * The bytes that constitute the file.
     * </pre>
     *
     * <code>bytes contents = 2;</code>
     *
     * @return The contents.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getContents() {
      return contents_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, path_);
      }
      if (!contents_.isEmpty()) {
        output.writeBytes(2, contents_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, path_);
      }
      if (!contents_.isEmpty()) {
        size += com.google.protobuf.CodedOutputStream.computeBytesSize(2, contents_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.apigateway.v1.ApiConfig.File)) {
        return super.equals(obj);
      }
      com.google.cloud.apigateway.v1.ApiConfig.File other =
          (com.google.cloud.apigateway.v1.ApiConfig.File) obj;

      if (!getPath().equals(other.getPath())) return false;
      if (!getContents().equals(other.getContents())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PATH_FIELD_NUMBER;
      hash = (53 * hash) + getPath().hashCode();
      hash = (37 * hash) + CONTENTS_FIELD_NUMBER;
      hash = (53 * hash) + getContents().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.File parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.File parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.File parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.File parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.File parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.File parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.File parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.File parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.File parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.File parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.File parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.File parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.apigateway.v1.ApiConfig.File prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A lightweight description of a file.
     * </pre>
     *
     * Protobuf type {@code google.cloud.apigateway.v1.ApiConfig.File}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.apigateway.v1.ApiConfig.File)
        com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.apigateway.v1.Apigateway
            .internal_static_google_cloud_apigateway_v1_ApiConfig_File_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.apigateway.v1.Apigateway
            .internal_static_google_cloud_apigateway_v1_ApiConfig_File_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.apigateway.v1.ApiConfig.File.class,
                com.google.cloud.apigateway.v1.ApiConfig.File.Builder.class);
      }

      // Construct using com.google.cloud.apigateway.v1.ApiConfig.File.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        path_ = "";

        contents_ = com.google.protobuf.ByteString.EMPTY;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.apigateway.v1.Apigateway
            .internal_static_google_cloud_apigateway_v1_ApiConfig_File_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.apigateway.v1.ApiConfig.File getDefaultInstanceForType() {
        return com.google.cloud.apigateway.v1.ApiConfig.File.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.apigateway.v1.ApiConfig.File build() {
        com.google.cloud.apigateway.v1.ApiConfig.File result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.apigateway.v1.ApiConfig.File buildPartial() {
        com.google.cloud.apigateway.v1.ApiConfig.File result =
            new com.google.cloud.apigateway.v1.ApiConfig.File(this);
        result.path_ = path_;
        result.contents_ = contents_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.apigateway.v1.ApiConfig.File) {
          return mergeFrom((com.google.cloud.apigateway.v1.ApiConfig.File) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.apigateway.v1.ApiConfig.File other) {
        if (other == com.google.cloud.apigateway.v1.ApiConfig.File.getDefaultInstance())
          return this;
        if (!other.getPath().isEmpty()) {
          path_ = other.path_;
          onChanged();
        }
        if (other.getContents() != com.google.protobuf.ByteString.EMPTY) {
          setContents(other.getContents());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  path_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  contents_ = input.readBytes();

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object path_ = "";
      /**
       *
       *
       * <pre>
       * The file path (full or relative path). This is typically the path of the
       * file when it is uploaded.
       * </pre>
       *
       * <code>string path = 1;</code>
       *
       * @return The path.
       */
      public java.lang.String getPath() {
        java.lang.Object ref = path_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          path_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The file path (full or relative path). This is typically the path of the
       * file when it is uploaded.
       * </pre>
       *
       * <code>string path = 1;</code>
       *
       * @return The bytes for path.
       */
      public com.google.protobuf.ByteString getPathBytes() {
        java.lang.Object ref = path_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          path_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The file path (full or relative path). This is typically the path of the
       * file when it is uploaded.
       * </pre>
       *
       * <code>string path = 1;</code>
       *
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        path_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The file path (full or relative path). This is typically the path of the
       * file when it is uploaded.
       * </pre>
       *
       * <code>string path = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPath() {

        path_ = getDefaultInstance().getPath();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The file path (full or relative path). This is typically the path of the
       * file when it is uploaded.
       * </pre>
       *
       * <code>string path = 1;</code>
       *
       * @param value The bytes for path to set.
       * @return This builder for chaining.
       */
      public Builder setPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        path_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString contents_ = com.google.protobuf.ByteString.EMPTY;
      /**
       *
       *
       * <pre>
       * The bytes that constitute the file.
       * </pre>
       *
       * <code>bytes contents = 2;</code>
       *
       * @return The contents.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getContents() {
        return contents_;
      }
      /**
       *
       *
       * <pre>
       * The bytes that constitute the file.
       * </pre>
       *
       * <code>bytes contents = 2;</code>
       *
       * @param value The contents to set.
       * @return This builder for chaining.
       */
      public Builder setContents(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }

        contents_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The bytes that constitute the file.
       * </pre>
       *
       * <code>bytes contents = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContents() {

        contents_ = getDefaultInstance().getContents();
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.apigateway.v1.ApiConfig.File)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.apigateway.v1.ApiConfig.File)
    private static final com.google.cloud.apigateway.v1.ApiConfig.File DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.apigateway.v1.ApiConfig.File();
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.File getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<File> PARSER =
        new com.google.protobuf.AbstractParser<File>() {
          @java.lang.Override
          public File parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<File> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<File> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.apigateway.v1.ApiConfig.File getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface OpenApiDocumentOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.apigateway.v1.ApiConfig.OpenApiDocument)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The OpenAPI Specification document file.
     * </pre>
     *
     * <code>.google.cloud.apigateway.v1.ApiConfig.File document = 1;</code>
     *
     * @return Whether the document field is set.
     */
    boolean hasDocument();
    /**
     *
     *
     * <pre>
     * The OpenAPI Specification document file.
     * </pre>
     *
     * <code>.google.cloud.apigateway.v1.ApiConfig.File document = 1;</code>
     *
     * @return The document.
     */
    com.google.cloud.apigateway.v1.ApiConfig.File getDocument();
    /**
     *
     *
     * <pre>
     * The OpenAPI Specification document file.
     * </pre>
     *
     * <code>.google.cloud.apigateway.v1.ApiConfig.File document = 1;</code>
     */
    com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder getDocumentOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * An OpenAPI Specification Document describing an API.
   * </pre>
   *
   * Protobuf type {@code google.cloud.apigateway.v1.ApiConfig.OpenApiDocument}
   */
  public static final class OpenApiDocument extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.apigateway.v1.ApiConfig.OpenApiDocument)
      OpenApiDocumentOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OpenApiDocument.newBuilder() to construct.
    private OpenApiDocument(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OpenApiDocument() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OpenApiDocument();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.apigateway.v1.Apigateway
          .internal_static_google_cloud_apigateway_v1_ApiConfig_OpenApiDocument_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.apigateway.v1.Apigateway
          .internal_static_google_cloud_apigateway_v1_ApiConfig_OpenApiDocument_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument.class,
              com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument.Builder.class);
    }

    public static final int DOCUMENT_FIELD_NUMBER = 1;
    private com.google.cloud.apigateway.v1.ApiConfig.File document_;
    /**
     *
     *
     * <pre>
     * The OpenAPI Specification document file.
     * </pre>
     *
     * <code>.google.cloud.apigateway.v1.ApiConfig.File document = 1;</code>
     *
     * @return Whether the document field is set.
     */
    @java.lang.Override
    public boolean hasDocument() {
      return document_ != null;
    }
    /**
     *
     *
     * <pre>
     * The OpenAPI Specification document file.
     * </pre>
     *
     * <code>.google.cloud.apigateway.v1.ApiConfig.File document = 1;</code>
     *
     * @return The document.
     */
    @java.lang.Override
    public com.google.cloud.apigateway.v1.ApiConfig.File getDocument() {
      return document_ == null
          ? com.google.cloud.apigateway.v1.ApiConfig.File.getDefaultInstance()
          : document_;
    }
    /**
     *
     *
     * <pre>
     * The OpenAPI Specification document file.
     * </pre>
     *
     * <code>.google.cloud.apigateway.v1.ApiConfig.File document = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder getDocumentOrBuilder() {
      return getDocument();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (document_ != null) {
        output.writeMessage(1, getDocument());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (document_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDocument());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument)) {
        return super.equals(obj);
      }
      com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument other =
          (com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument) obj;

      if (hasDocument() != other.hasDocument()) return false;
      if (hasDocument()) {
        if (!getDocument().equals(other.getDocument())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasDocument()) {
        hash = (37 * hash) + DOCUMENT_FIELD_NUMBER;
        hash = (53 * hash) + getDocument().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An OpenAPI Specification Document describing an API.
     * </pre>
     *
     * Protobuf type {@code google.cloud.apigateway.v1.ApiConfig.OpenApiDocument}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.apigateway.v1.ApiConfig.OpenApiDocument)
        com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocumentOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.apigateway.v1.Apigateway
            .internal_static_google_cloud_apigateway_v1_ApiConfig_OpenApiDocument_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.apigateway.v1.Apigateway
            .internal_static_google_cloud_apigateway_v1_ApiConfig_OpenApiDocument_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument.class,
                com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument.Builder.class);
      }

      // Construct using com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (documentBuilder_ == null) {
          document_ = null;
        } else {
          document_ = null;
          documentBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.apigateway.v1.Apigateway
            .internal_static_google_cloud_apigateway_v1_ApiConfig_OpenApiDocument_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument getDefaultInstanceForType() {
        return com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument build() {
        com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument buildPartial() {
        com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument result =
            new com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument(this);
        if (documentBuilder_ == null) {
          result.document_ = document_;
        } else {
          result.document_ = documentBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument) {
          return mergeFrom((com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument other) {
        if (other == com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument.getDefaultInstance())
          return this;
        if (other.hasDocument()) {
          mergeDocument(other.getDocument());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getDocumentFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private com.google.cloud.apigateway.v1.ApiConfig.File document_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.apigateway.v1.ApiConfig.File,
              com.google.cloud.apigateway.v1.ApiConfig.File.Builder,
              com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder>
          documentBuilder_;
      /**
       *
       *
       * <pre>
       * The OpenAPI Specification document file.
       * </pre>
       *
       * <code>.google.cloud.apigateway.v1.ApiConfig.File document = 1;</code>
       *
       * @return Whether the document field is set.
       */
      public boolean hasDocument() {
        return documentBuilder_ != null || document_ != null;
      }
      /**
       *
       *
       * <pre>
       * The OpenAPI Specification document file.
       * </pre>
       *
       * <code>.google.cloud.apigateway.v1.ApiConfig.File document = 1;</code>
       *
       * @return The document.
       */
      public com.google.cloud.apigateway.v1.ApiConfig.File getDocument() {
        if (documentBuilder_ == null) {
          return document_ == null
              ? com.google.cloud.apigateway.v1.ApiConfig.File.getDefaultInstance()
              : document_;
        } else {
          return documentBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The OpenAPI Specification document file.
       * </pre>
       *
       * <code>.google.cloud.apigateway.v1.ApiConfig.File document = 1;</code>
       */
      public Builder setDocument(com.google.cloud.apigateway.v1.ApiConfig.File value) {
        if (documentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          document_ = value;
          onChanged();
        } else {
          documentBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The OpenAPI Specification document file.
       * </pre>
       *
       * <code>.google.cloud.apigateway.v1.ApiConfig.File document = 1;</code>
       */
      public Builder setDocument(
          com.google.cloud.apigateway.v1.ApiConfig.File.Builder builderForValue) {
        if (documentBuilder_ == null) {
          document_ = builderForValue.build();
          onChanged();
        } else {
          documentBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The OpenAPI Specification document file.
       * </pre>
       *
       * <code>.google.cloud.apigateway.v1.ApiConfig.File document = 1;</code>
       */
      public Builder mergeDocument(com.google.cloud.apigateway.v1.ApiConfig.File value) {
        if (documentBuilder_ == null) {
          if (document_ != null) {
            document_ =
                com.google.cloud.apigateway.v1.ApiConfig.File.newBuilder(document_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            document_ = value;
          }
          onChanged();
        } else {
          documentBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The OpenAPI Specification document file.
       * </pre>
       *
       * <code>.google.cloud.apigateway.v1.ApiConfig.File document = 1;</code>
       */
      public Builder clearDocument() {
        if (documentBuilder_ == null) {
          document_ = null;
          onChanged();
        } else {
          document_ = null;
          documentBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The OpenAPI Specification document file.
       * </pre>
       *
       * <code>.google.cloud.apigateway.v1.ApiConfig.File document = 1;</code>
       */
      public com.google.cloud.apigateway.v1.ApiConfig.File.Builder getDocumentBuilder() {

        onChanged();
        return getDocumentFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The OpenAPI Specification document file.
       * </pre>
       *
       * <code>.google.cloud.apigateway.v1.ApiConfig.File document = 1;</code>
       */
      public com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder getDocumentOrBuilder() {
        if (documentBuilder_ != null) {
          return documentBuilder_.getMessageOrBuilder();
        } else {
          return document_ == null
              ? com.google.cloud.apigateway.v1.ApiConfig.File.getDefaultInstance()
              : document_;
        }
      }
      /**
       *
       *
       * <pre>
       * The OpenAPI Specification document file.
       * </pre>
       *
       * <code>.google.cloud.apigateway.v1.ApiConfig.File document = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.apigateway.v1.ApiConfig.File,
              com.google.cloud.apigateway.v1.ApiConfig.File.Builder,
              com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder>
          getDocumentFieldBuilder() {
        if (documentBuilder_ == null) {
          documentBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.apigateway.v1.ApiConfig.File,
                  com.google.cloud.apigateway.v1.ApiConfig.File.Builder,
                  com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder>(
                  getDocument(), getParentForChildren(), isClean());
          document_ = null;
        }
        return documentBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.apigateway.v1.ApiConfig.OpenApiDocument)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.apigateway.v1.ApiConfig.OpenApiDocument)
    private static final com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument();
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OpenApiDocument> PARSER =
        new com.google.protobuf.AbstractParser<OpenApiDocument>() {
          @java.lang.Override
          public OpenApiDocument parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OpenApiDocument> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OpenApiDocument> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GrpcServiceDefinitionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Input only. File descriptor set, generated by protoc.
     * To generate, use protoc with imports and source info included.
     * For an example test.proto file, the following command would put the value
     * in a new file named out.pb.
     * $ protoc --include_imports --include_source_info test.proto -o out.pb
     * </pre>
     *
     * <code>
     * .google.cloud.apigateway.v1.ApiConfig.File file_descriptor_set = 1 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return Whether the fileDescriptorSet field is set.
     */
    boolean hasFileDescriptorSet();
    /**
     *
     *
     * <pre>
     * Input only. File descriptor set, generated by protoc.
     * To generate, use protoc with imports and source info included.
     * For an example test.proto file, the following command would put the value
     * in a new file named out.pb.
     * $ protoc --include_imports --include_source_info test.proto -o out.pb
     * </pre>
     *
     * <code>
     * .google.cloud.apigateway.v1.ApiConfig.File file_descriptor_set = 1 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The fileDescriptorSet.
     */
    com.google.cloud.apigateway.v1.ApiConfig.File getFileDescriptorSet();
    /**
     *
     *
     * <pre>
     * Input only. File descriptor set, generated by protoc.
     * To generate, use protoc with imports and source info included.
     * For an example test.proto file, the following command would put the value
     * in a new file named out.pb.
     * $ protoc --include_imports --include_source_info test.proto -o out.pb
     * </pre>
     *
     * <code>
     * .google.cloud.apigateway.v1.ApiConfig.File file_descriptor_set = 1 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder getFileDescriptorSetOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Uncompiled proto files associated with the descriptor set, used for
     * display purposes (server-side compilation is not supported). These
     * should match the inputs to 'protoc' command used to generate
     * file_descriptor_set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<com.google.cloud.apigateway.v1.ApiConfig.File> getSourceList();
    /**
     *
     *
     * <pre>
     * Optional. Uncompiled proto files associated with the descriptor set, used for
     * display purposes (server-side compilation is not supported). These
     * should match the inputs to 'protoc' command used to generate
     * file_descriptor_set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.apigateway.v1.ApiConfig.File getSource(int index);
    /**
     *
     *
     * <pre>
     * Optional. Uncompiled proto files associated with the descriptor set, used for
     * display purposes (server-side compilation is not supported). These
     * should match the inputs to 'protoc' command used to generate
     * file_descriptor_set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getSourceCount();
    /**
     *
     *
     * <pre>
     * Optional. Uncompiled proto files associated with the descriptor set, used for
     * display purposes (server-side compilation is not supported). These
     * should match the inputs to 'protoc' command used to generate
     * file_descriptor_set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<? extends com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder>
        getSourceOrBuilderList();
    /**
     *
     *
     * <pre>
     * Optional. Uncompiled proto files associated with the descriptor set, used for
     * display purposes (server-side compilation is not supported). These
     * should match the inputs to 'protoc' command used to generate
     * file_descriptor_set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder getSourceOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * A gRPC service definition.
   * </pre>
   *
   * Protobuf type {@code google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition}
   */
  public static final class GrpcServiceDefinition extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition)
      GrpcServiceDefinitionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GrpcServiceDefinition.newBuilder() to construct.
    private GrpcServiceDefinition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GrpcServiceDefinition() {
      source_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GrpcServiceDefinition();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.apigateway.v1.Apigateway
          .internal_static_google_cloud_apigateway_v1_ApiConfig_GrpcServiceDefinition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.apigateway.v1.Apigateway
          .internal_static_google_cloud_apigateway_v1_ApiConfig_GrpcServiceDefinition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition.class,
              com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition.Builder.class);
    }

    public static final int FILE_DESCRIPTOR_SET_FIELD_NUMBER = 1;
    private com.google.cloud.apigateway.v1.ApiConfig.File fileDescriptorSet_;
    /**
     *
     *
     * <pre>
     * Input only. File descriptor set, generated by protoc.
     * To generate, use protoc with imports and source info included.
     * For an example test.proto file, the following command would put the value
     * in a new file named out.pb.
     * $ protoc --include_imports --include_source_info test.proto -o out.pb
     * </pre>
     *
     * <code>
     * .google.cloud.apigateway.v1.ApiConfig.File file_descriptor_set = 1 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return Whether the fileDescriptorSet field is set.
     */
    @java.lang.Override
    public boolean hasFileDescriptorSet() {
      return fileDescriptorSet_ != null;
    }
    /**
     *
     *
     * <pre>
     * Input only. File descriptor set, generated by protoc.
     * To generate, use protoc with imports and source info included.
     * For an example test.proto file, the following command would put the value
     * in a new file named out.pb.
     * $ protoc --include_imports --include_source_info test.proto -o out.pb
     * </pre>
     *
     * <code>
     * .google.cloud.apigateway.v1.ApiConfig.File file_descriptor_set = 1 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The fileDescriptorSet.
     */
    @java.lang.Override
    public com.google.cloud.apigateway.v1.ApiConfig.File getFileDescriptorSet() {
      return fileDescriptorSet_ == null
          ? com.google.cloud.apigateway.v1.ApiConfig.File.getDefaultInstance()
          : fileDescriptorSet_;
    }
    /**
     *
     *
     * <pre>
     * Input only. File descriptor set, generated by protoc.
     * To generate, use protoc with imports and source info included.
     * For an example test.proto file, the following command would put the value
     * in a new file named out.pb.
     * $ protoc --include_imports --include_source_info test.proto -o out.pb
     * </pre>
     *
     * <code>
     * .google.cloud.apigateway.v1.ApiConfig.File file_descriptor_set = 1 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder getFileDescriptorSetOrBuilder() {
      return getFileDescriptorSet();
    }

    public static final int SOURCE_FIELD_NUMBER = 2;
    private java.util.List<com.google.cloud.apigateway.v1.ApiConfig.File> source_;
    /**
     *
     *
     * <pre>
     * Optional. Uncompiled proto files associated with the descriptor set, used for
     * display purposes (server-side compilation is not supported). These
     * should match the inputs to 'protoc' command used to generate
     * file_descriptor_set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.apigateway.v1.ApiConfig.File> getSourceList() {
      return source_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Uncompiled proto files associated with the descriptor set, used for
     * display purposes (server-side compilation is not supported). These
     * should match the inputs to 'protoc' command used to generate
     * file_descriptor_set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder>
        getSourceOrBuilderList() {
      return source_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Uncompiled proto files associated with the descriptor set, used for
     * display purposes (server-side compilation is not supported). These
     * should match the inputs to 'protoc' command used to generate
     * file_descriptor_set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getSourceCount() {
      return source_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Uncompiled proto files associated with the descriptor set, used for
     * display purposes (server-side compilation is not supported). These
     * should match the inputs to 'protoc' command used to generate
     * file_descriptor_set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.apigateway.v1.ApiConfig.File getSource(int index) {
      return source_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Uncompiled proto files associated with the descriptor set, used for
     * display purposes (server-side compilation is not supported). These
     * should match the inputs to 'protoc' command used to generate
     * file_descriptor_set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder getSourceOrBuilder(int index) {
      return source_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (fileDescriptorSet_ != null) {
        output.writeMessage(1, getFileDescriptorSet());
      }
      for (int i = 0; i < source_.size(); i++) {
        output.writeMessage(2, source_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (fileDescriptorSet_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getFileDescriptorSet());
      }
      for (int i = 0; i < source_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, source_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition)) {
        return super.equals(obj);
      }
      com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition other =
          (com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition) obj;

      if (hasFileDescriptorSet() != other.hasFileDescriptorSet()) return false;
      if (hasFileDescriptorSet()) {
        if (!getFileDescriptorSet().equals(other.getFileDescriptorSet())) return false;
      }
      if (!getSourceList().equals(other.getSourceList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasFileDescriptorSet()) {
        hash = (37 * hash) + FILE_DESCRIPTOR_SET_FIELD_NUMBER;
        hash = (53 * hash) + getFileDescriptorSet().hashCode();
      }
      if (getSourceCount() > 0) {
        hash = (37 * hash) + SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getSourceList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A gRPC service definition.
     * </pre>
     *
     * Protobuf type {@code google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition)
        com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinitionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.apigateway.v1.Apigateway
            .internal_static_google_cloud_apigateway_v1_ApiConfig_GrpcServiceDefinition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.apigateway.v1.Apigateway
            .internal_static_google_cloud_apigateway_v1_ApiConfig_GrpcServiceDefinition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition.class,
                com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition.Builder.class);
      }

      // Construct using com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (fileDescriptorSetBuilder_ == null) {
          fileDescriptorSet_ = null;
        } else {
          fileDescriptorSet_ = null;
          fileDescriptorSetBuilder_ = null;
        }
        if (sourceBuilder_ == null) {
          source_ = java.util.Collections.emptyList();
        } else {
          source_ = null;
          sourceBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.apigateway.v1.Apigateway
            .internal_static_google_cloud_apigateway_v1_ApiConfig_GrpcServiceDefinition_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition
          getDefaultInstanceForType() {
        return com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition build() {
        com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition buildPartial() {
        com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition result =
            new com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition(this);
        int from_bitField0_ = bitField0_;
        if (fileDescriptorSetBuilder_ == null) {
          result.fileDescriptorSet_ = fileDescriptorSet_;
        } else {
          result.fileDescriptorSet_ = fileDescriptorSetBuilder_.build();
        }
        if (sourceBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            source_ = java.util.Collections.unmodifiableList(source_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.source_ = source_;
        } else {
          result.source_ = sourceBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition) {
          return mergeFrom((com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition other) {
        if (other
            == com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition.getDefaultInstance())
          return this;
        if (other.hasFileDescriptorSet()) {
          mergeFileDescriptorSet(other.getFileDescriptorSet());
        }
        if (sourceBuilder_ == null) {
          if (!other.source_.isEmpty()) {
            if (source_.isEmpty()) {
              source_ = other.source_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureSourceIsMutable();
              source_.addAll(other.source_);
            }
            onChanged();
          }
        } else {
          if (!other.source_.isEmpty()) {
            if (sourceBuilder_.isEmpty()) {
              sourceBuilder_.dispose();
              sourceBuilder_ = null;
              source_ = other.source_;
              bitField0_ = (bitField0_ & ~0x00000001);
              sourceBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getSourceFieldBuilder()
                      : null;
            } else {
              sourceBuilder_.addAllMessages(other.source_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getFileDescriptorSetFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.apigateway.v1.ApiConfig.File m =
                      input.readMessage(
                          com.google.cloud.apigateway.v1.ApiConfig.File.parser(),
                          extensionRegistry);
                  if (sourceBuilder_ == null) {
                    ensureSourceIsMutable();
                    source_.add(m);
                  } else {
                    sourceBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.apigateway.v1.ApiConfig.File fileDescriptorSet_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.apigateway.v1.ApiConfig.File,
              com.google.cloud.apigateway.v1.ApiConfig.File.Builder,
              com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder>
          fileDescriptorSetBuilder_;
      /**
       *
       *
       * <pre>
       * Input only. File descriptor set, generated by protoc.
       * To generate, use protoc with imports and source info included.
       * For an example test.proto file, the following command would put the value
       * in a new file named out.pb.
       * $ protoc --include_imports --include_source_info test.proto -o out.pb
       * </pre>
       *
       * <code>
       * .google.cloud.apigateway.v1.ApiConfig.File file_descriptor_set = 1 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       *
       * @return Whether the fileDescriptorSet field is set.
       */
      public boolean hasFileDescriptorSet() {
        return fileDescriptorSetBuilder_ != null || fileDescriptorSet_ != null;
      }
      /**
       *
       *
       * <pre>
       * Input only. File descriptor set, generated by protoc.
       * To generate, use protoc with imports and source info included.
       * For an example test.proto file, the following command would put the value
       * in a new file named out.pb.
       * $ protoc --include_imports --include_source_info test.proto -o out.pb
       * </pre>
       *
       * <code>
       * .google.cloud.apigateway.v1.ApiConfig.File file_descriptor_set = 1 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       *
       * @return The fileDescriptorSet.
       */
      public com.google.cloud.apigateway.v1.ApiConfig.File getFileDescriptorSet() {
        if (fileDescriptorSetBuilder_ == null) {
          return fileDescriptorSet_ == null
              ? com.google.cloud.apigateway.v1.ApiConfig.File.getDefaultInstance()
              : fileDescriptorSet_;
        } else {
          return fileDescriptorSetBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Input only. File descriptor set, generated by protoc.
       * To generate, use protoc with imports and source info included.
       * For an example test.proto file, the following command would put the value
       * in a new file named out.pb.
       * $ protoc --include_imports --include_source_info test.proto -o out.pb
       * </pre>
       *
       * <code>
       * .google.cloud.apigateway.v1.ApiConfig.File file_descriptor_set = 1 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public Builder setFileDescriptorSet(com.google.cloud.apigateway.v1.ApiConfig.File value) {
        if (fileDescriptorSetBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          fileDescriptorSet_ = value;
          onChanged();
        } else {
          fileDescriptorSetBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Input only. File descriptor set, generated by protoc.
       * To generate, use protoc with imports and source info included.
       * For an example test.proto file, the following command would put the value
       * in a new file named out.pb.
       * $ protoc --include_imports --include_source_info test.proto -o out.pb
       * </pre>
       *
       * <code>
       * .google.cloud.apigateway.v1.ApiConfig.File file_descriptor_set = 1 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public Builder setFileDescriptorSet(
          com.google.cloud.apigateway.v1.ApiConfig.File.Builder builderForValue) {
        if (fileDescriptorSetBuilder_ == null) {
          fileDescriptorSet_ = builderForValue.build();
          onChanged();
        } else {
          fileDescriptorSetBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Input only. File descriptor set, generated by protoc.
       * To generate, use protoc with imports and source info included.
       * For an example test.proto file, the following command would put the value
       * in a new file named out.pb.
       * $ protoc --include_imports --include_source_info test.proto -o out.pb
       * </pre>
       *
       * <code>
       * .google.cloud.apigateway.v1.ApiConfig.File file_descriptor_set = 1 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public Builder mergeFileDescriptorSet(com.google.cloud.apigateway.v1.ApiConfig.File value) {
        if (fileDescriptorSetBuilder_ == null) {
          if (fileDescriptorSet_ != null) {
            fileDescriptorSet_ =
                com.google.cloud.apigateway.v1.ApiConfig.File.newBuilder(fileDescriptorSet_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            fileDescriptorSet_ = value;
          }
          onChanged();
        } else {
          fileDescriptorSetBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Input only. File descriptor set, generated by protoc.
       * To generate, use protoc with imports and source info included.
       * For an example test.proto file, the following command would put the value
       * in a new file named out.pb.
       * $ protoc --include_imports --include_source_info test.proto -o out.pb
       * </pre>
       *
       * <code>
       * .google.cloud.apigateway.v1.ApiConfig.File file_descriptor_set = 1 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public Builder clearFileDescriptorSet() {
        if (fileDescriptorSetBuilder_ == null) {
          fileDescriptorSet_ = null;
          onChanged();
        } else {
          fileDescriptorSet_ = null;
          fileDescriptorSetBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Input only. File descriptor set, generated by protoc.
       * To generate, use protoc with imports and source info included.
       * For an example test.proto file, the following command would put the value
       * in a new file named out.pb.
       * $ protoc --include_imports --include_source_info test.proto -o out.pb
       * </pre>
       *
       * <code>
       * .google.cloud.apigateway.v1.ApiConfig.File file_descriptor_set = 1 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public com.google.cloud.apigateway.v1.ApiConfig.File.Builder getFileDescriptorSetBuilder() {

        onChanged();
        return getFileDescriptorSetFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Input only. File descriptor set, generated by protoc.
       * To generate, use protoc with imports and source info included.
       * For an example test.proto file, the following command would put the value
       * in a new file named out.pb.
       * $ protoc --include_imports --include_source_info test.proto -o out.pb
       * </pre>
       *
       * <code>
       * .google.cloud.apigateway.v1.ApiConfig.File file_descriptor_set = 1 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder
          getFileDescriptorSetOrBuilder() {
        if (fileDescriptorSetBuilder_ != null) {
          return fileDescriptorSetBuilder_.getMessageOrBuilder();
        } else {
          return fileDescriptorSet_ == null
              ? com.google.cloud.apigateway.v1.ApiConfig.File.getDefaultInstance()
              : fileDescriptorSet_;
        }
      }
      /**
       *
       *
       * <pre>
       * Input only. File descriptor set, generated by protoc.
       * To generate, use protoc with imports and source info included.
       * For an example test.proto file, the following command would put the value
       * in a new file named out.pb.
       * $ protoc --include_imports --include_source_info test.proto -o out.pb
       * </pre>
       *
       * <code>
       * .google.cloud.apigateway.v1.ApiConfig.File file_descriptor_set = 1 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.apigateway.v1.ApiConfig.File,
              com.google.cloud.apigateway.v1.ApiConfig.File.Builder,
              com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder>
          getFileDescriptorSetFieldBuilder() {
        if (fileDescriptorSetBuilder_ == null) {
          fileDescriptorSetBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.apigateway.v1.ApiConfig.File,
                  com.google.cloud.apigateway.v1.ApiConfig.File.Builder,
                  com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder>(
                  getFileDescriptorSet(), getParentForChildren(), isClean());
          fileDescriptorSet_ = null;
        }
        return fileDescriptorSetBuilder_;
      }

      private java.util.List<com.google.cloud.apigateway.v1.ApiConfig.File> source_ =
          java.util.Collections.emptyList();

      private void ensureSourceIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          source_ = new java.util.ArrayList<com.google.cloud.apigateway.v1.ApiConfig.File>(source_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.apigateway.v1.ApiConfig.File,
              com.google.cloud.apigateway.v1.ApiConfig.File.Builder,
              com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder>
          sourceBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Uncompiled proto files associated with the descriptor set, used for
       * display purposes (server-side compilation is not supported). These
       * should match the inputs to 'protoc' command used to generate
       * file_descriptor_set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.cloud.apigateway.v1.ApiConfig.File> getSourceList() {
        if (sourceBuilder_ == null) {
          return java.util.Collections.unmodifiableList(source_);
        } else {
          return sourceBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Uncompiled proto files associated with the descriptor set, used for
       * display purposes (server-side compilation is not supported). These
       * should match the inputs to 'protoc' command used to generate
       * file_descriptor_set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public int getSourceCount() {
        if (sourceBuilder_ == null) {
          return source_.size();
        } else {
          return sourceBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Uncompiled proto files associated with the descriptor set, used for
       * display purposes (server-side compilation is not supported). These
       * should match the inputs to 'protoc' command used to generate
       * file_descriptor_set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.apigateway.v1.ApiConfig.File getSource(int index) {
        if (sourceBuilder_ == null) {
          return source_.get(index);
        } else {
          return sourceBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Uncompiled proto files associated with the descriptor set, used for
       * display purposes (server-side compilation is not supported). These
       * should match the inputs to 'protoc' command used to generate
       * file_descriptor_set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setSource(int index, com.google.cloud.apigateway.v1.ApiConfig.File value) {
        if (sourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSourceIsMutable();
          source_.set(index, value);
          onChanged();
        } else {
          sourceBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Uncompiled proto files associated with the descriptor set, used for
       * display purposes (server-side compilation is not supported). These
       * should match the inputs to 'protoc' command used to generate
       * file_descriptor_set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setSource(
          int index, com.google.cloud.apigateway.v1.ApiConfig.File.Builder builderForValue) {
        if (sourceBuilder_ == null) {
          ensureSourceIsMutable();
          source_.set(index, builderForValue.build());
          onChanged();
        } else {
          sourceBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Uncompiled proto files associated with the descriptor set, used for
       * display purposes (server-side compilation is not supported). These
       * should match the inputs to 'protoc' command used to generate
       * file_descriptor_set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addSource(com.google.cloud.apigateway.v1.ApiConfig.File value) {
        if (sourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSourceIsMutable();
          source_.add(value);
          onChanged();
        } else {
          sourceBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Uncompiled proto files associated with the descriptor set, used for
       * display purposes (server-side compilation is not supported). These
       * should match the inputs to 'protoc' command used to generate
       * file_descriptor_set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addSource(int index, com.google.cloud.apigateway.v1.ApiConfig.File value) {
        if (sourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSourceIsMutable();
          source_.add(index, value);
          onChanged();
        } else {
          sourceBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Uncompiled proto files associated with the descriptor set, used for
       * display purposes (server-side compilation is not supported). These
       * should match the inputs to 'protoc' command used to generate
       * file_descriptor_set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addSource(
          com.google.cloud.apigateway.v1.ApiConfig.File.Builder builderForValue) {
        if (sourceBuilder_ == null) {
          ensureSourceIsMutable();
          source_.add(builderForValue.build());
          onChanged();
        } else {
          sourceBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Uncompiled proto files associated with the descriptor set, used for
       * display purposes (server-side compilation is not supported). These
       * should match the inputs to 'protoc' command used to generate
       * file_descriptor_set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addSource(
          int index, com.google.cloud.apigateway.v1.ApiConfig.File.Builder builderForValue) {
        if (sourceBuilder_ == null) {
          ensureSourceIsMutable();
          source_.add(index, builderForValue.build());
          onChanged();
        } else {
          sourceBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Uncompiled proto files associated with the descriptor set, used for
       * display purposes (server-side compilation is not supported). These
       * should match the inputs to 'protoc' command used to generate
       * file_descriptor_set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAllSource(
          java.lang.Iterable<? extends com.google.cloud.apigateway.v1.ApiConfig.File> values) {
        if (sourceBuilder_ == null) {
          ensureSourceIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, source_);
          onChanged();
        } else {
          sourceBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Uncompiled proto files associated with the descriptor set, used for
       * display purposes (server-side compilation is not supported). These
       * should match the inputs to 'protoc' command used to generate
       * file_descriptor_set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearSource() {
        if (sourceBuilder_ == null) {
          source_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          sourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Uncompiled proto files associated with the descriptor set, used for
       * display purposes (server-side compilation is not supported). These
       * should match the inputs to 'protoc' command used to generate
       * file_descriptor_set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeSource(int index) {
        if (sourceBuilder_ == null) {
          ensureSourceIsMutable();
          source_.remove(index);
          onChanged();
        } else {
          sourceBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Uncompiled proto files associated with the descriptor set, used for
       * display purposes (server-side compilation is not supported). These
       * should match the inputs to 'protoc' command used to generate
       * file_descriptor_set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.apigateway.v1.ApiConfig.File.Builder getSourceBuilder(int index) {
        return getSourceFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Uncompiled proto files associated with the descriptor set, used for
       * display purposes (server-side compilation is not supported). These
       * should match the inputs to 'protoc' command used to generate
       * file_descriptor_set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder getSourceOrBuilder(int index) {
        if (sourceBuilder_ == null) {
          return source_.get(index);
        } else {
          return sourceBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Uncompiled proto files associated with the descriptor set, used for
       * display purposes (server-side compilation is not supported). These
       * should match the inputs to 'protoc' command used to generate
       * file_descriptor_set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<? extends com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder>
          getSourceOrBuilderList() {
        if (sourceBuilder_ != null) {
          return sourceBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(source_);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Uncompiled proto files associated with the descriptor set, used for
       * display purposes (server-side compilation is not supported). These
       * should match the inputs to 'protoc' command used to generate
       * file_descriptor_set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.apigateway.v1.ApiConfig.File.Builder addSourceBuilder() {
        return getSourceFieldBuilder()
            .addBuilder(com.google.cloud.apigateway.v1.ApiConfig.File.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. Uncompiled proto files associated with the descriptor set, used for
       * display purposes (server-side compilation is not supported). These
       * should match the inputs to 'protoc' command used to generate
       * file_descriptor_set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.apigateway.v1.ApiConfig.File.Builder addSourceBuilder(int index) {
        return getSourceFieldBuilder()
            .addBuilder(index, com.google.cloud.apigateway.v1.ApiConfig.File.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. Uncompiled proto files associated with the descriptor set, used for
       * display purposes (server-side compilation is not supported). These
       * should match the inputs to 'protoc' command used to generate
       * file_descriptor_set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.apigateway.v1.ApiConfig.File source = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.cloud.apigateway.v1.ApiConfig.File.Builder>
          getSourceBuilderList() {
        return getSourceFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.apigateway.v1.ApiConfig.File,
              com.google.cloud.apigateway.v1.ApiConfig.File.Builder,
              com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder>
          getSourceFieldBuilder() {
        if (sourceBuilder_ == null) {
          sourceBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.apigateway.v1.ApiConfig.File,
                  com.google.cloud.apigateway.v1.ApiConfig.File.Builder,
                  com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder>(
                  source_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          source_ = null;
        }
        return sourceBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition)
    private static final com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition();
    }

    public static com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GrpcServiceDefinition> PARSER =
        new com.google.protobuf.AbstractParser<GrpcServiceDefinition>() {
          @java.lang.Override
          public GrpcServiceDefinition parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GrpcServiceDefinition> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GrpcServiceDefinition> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the API Config.
   * Format: projects/{project}/locations/global/apis/{api}/configs/{api_config}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the API Config.
   * Format: projects/{project}/locations/global/apis/{api}/configs/{api_config}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Created time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Created time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Created time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Updated time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Updated time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Updated time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.apigateway.v1.Apigateway
                .internal_static_google_cloud_apigateway_v1_ApiConfig_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Resource labels to represent user-provided metadata.
   * Refer to cloud documentation on labels for more details.
   * https://cloud.google.com/compute/docs/labeling-resources
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Resource labels to represent user-provided metadata.
   * Refer to cloud documentation on labels for more details.
   * https://cloud.google.com/compute/docs/labeling-resources
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Resource labels to represent user-provided metadata.
   * Refer to cloud documentation on labels for more details.
   * https://cloud.google.com/compute/docs/labeling-resources
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Resource labels to represent user-provided metadata.
   * Refer to cloud documentation on labels for more details.
   * https://cloud.google.com/compute/docs/labeling-resources
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 5;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Optional. Display name.
   * </pre>
   *
   * <code>string display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Display name.
   * </pre>
   *
   * <code>string display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GATEWAY_SERVICE_ACCOUNT_FIELD_NUMBER = 14;
  private volatile java.lang.Object gatewayServiceAccount_;
  /**
   *
   *
   * <pre>
   * Immutable. The Google Cloud IAM Service Account that Gateways serving this config
   * should use to authenticate to other services. This may either be the
   * Service Account's email
   * (`{ACCOUNT_ID}&#64;{PROJECT}.iam.gserviceaccount.com`) or its full resource
   * name (`projects/{PROJECT}/accounts/{UNIQUE_ID}`). This is most often used
   * when the service is a GCP resource such as a Cloud Run Service or an
   * IAP-secured service.
   * </pre>
   *
   * <code>
   * string gateway_service_account = 14 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The gatewayServiceAccount.
   */
  @java.lang.Override
  public java.lang.String getGatewayServiceAccount() {
    java.lang.Object ref = gatewayServiceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      gatewayServiceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The Google Cloud IAM Service Account that Gateways serving this config
   * should use to authenticate to other services. This may either be the
   * Service Account's email
   * (`{ACCOUNT_ID}&#64;{PROJECT}.iam.gserviceaccount.com`) or its full resource
   * name (`projects/{PROJECT}/accounts/{UNIQUE_ID}`). This is most often used
   * when the service is a GCP resource such as a Cloud Run Service or an
   * IAP-secured service.
   * </pre>
   *
   * <code>
   * string gateway_service_account = 14 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for gatewayServiceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGatewayServiceAccountBytes() {
    java.lang.Object ref = gatewayServiceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      gatewayServiceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_CONFIG_ID_FIELD_NUMBER = 12;
  private volatile java.lang.Object serviceConfigId_;
  /**
   *
   *
   * <pre>
   * Output only. The ID of the associated Service Config (
   * https://cloud.google.com/service-infrastructure/docs/glossary#config).
   * </pre>
   *
   * <code>
   * string service_config_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The serviceConfigId.
   */
  @java.lang.Override
  public java.lang.String getServiceConfigId() {
    java.lang.Object ref = serviceConfigId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceConfigId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The ID of the associated Service Config (
   * https://cloud.google.com/service-infrastructure/docs/glossary#config).
   * </pre>
   *
   * <code>
   * string service_config_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for serviceConfigId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceConfigIdBytes() {
    java.lang.Object ref = serviceConfigId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceConfigId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 8;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. State of the API Config.
   * </pre>
   *
   * <code>
   * .google.cloud.apigateway.v1.ApiConfig.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. State of the API Config.
   * </pre>
   *
   * <code>
   * .google.cloud.apigateway.v1.ApiConfig.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.apigateway.v1.ApiConfig.State getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.apigateway.v1.ApiConfig.State result =
        com.google.cloud.apigateway.v1.ApiConfig.State.valueOf(state_);
    return result == null ? com.google.cloud.apigateway.v1.ApiConfig.State.UNRECOGNIZED : result;
  }

  public static final int OPENAPI_DOCUMENTS_FIELD_NUMBER = 9;
  private java.util.List<com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument>
      openapiDocuments_;
  /**
   *
   *
   * <pre>
   * Optional. OpenAPI specification documents. If specified, grpc_services and
   * managed_service_configs must not be included.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.apigateway.v1.ApiConfig.OpenApiDocument openapi_documents = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument>
      getOpenapiDocumentsList() {
    return openapiDocuments_;
  }
  /**
   *
   *
   * <pre>
   * Optional. OpenAPI specification documents. If specified, grpc_services and
   * managed_service_configs must not be included.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.apigateway.v1.ApiConfig.OpenApiDocument openapi_documents = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocumentOrBuilder>
      getOpenapiDocumentsOrBuilderList() {
    return openapiDocuments_;
  }
  /**
   *
   *
   * <pre>
   * Optional. OpenAPI specification documents. If specified, grpc_services and
   * managed_service_configs must not be included.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.apigateway.v1.ApiConfig.OpenApiDocument openapi_documents = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getOpenapiDocumentsCount() {
    return openapiDocuments_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. OpenAPI specification documents. If specified, grpc_services and
   * managed_service_configs must not be included.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.apigateway.v1.ApiConfig.OpenApiDocument openapi_documents = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument getOpenapiDocuments(int index) {
    return openapiDocuments_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. OpenAPI specification documents. If specified, grpc_services and
   * managed_service_configs must not be included.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.apigateway.v1.ApiConfig.OpenApiDocument openapi_documents = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocumentOrBuilder
      getOpenapiDocumentsOrBuilder(int index) {
    return openapiDocuments_.get(index);
  }

  public static final int GRPC_SERVICES_FIELD_NUMBER = 10;
  private java.util.List<com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition>
      grpcServices_;
  /**
   *
   *
   * <pre>
   * Optional. gRPC service definition files. If specified, openapi_documents must
   * not be included.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition grpc_services = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition>
      getGrpcServicesList() {
    return grpcServices_;
  }
  /**
   *
   *
   * <pre>
   * Optional. gRPC service definition files. If specified, openapi_documents must
   * not be included.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition grpc_services = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinitionOrBuilder>
      getGrpcServicesOrBuilderList() {
    return grpcServices_;
  }
  /**
   *
   *
   * <pre>
   * Optional. gRPC service definition files. If specified, openapi_documents must
   * not be included.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition grpc_services = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getGrpcServicesCount() {
    return grpcServices_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. gRPC service definition files. If specified, openapi_documents must
   * not be included.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition grpc_services = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition getGrpcServices(int index) {
    return grpcServices_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. gRPC service definition files. If specified, openapi_documents must
   * not be included.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition grpc_services = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinitionOrBuilder
      getGrpcServicesOrBuilder(int index) {
    return grpcServices_.get(index);
  }

  public static final int MANAGED_SERVICE_CONFIGS_FIELD_NUMBER = 11;
  private java.util.List<com.google.cloud.apigateway.v1.ApiConfig.File> managedServiceConfigs_;
  /**
   *
   *
   * <pre>
   * Optional. Service Configuration files. At least one must be included when using gRPC
   * service definitions. See
   * https://cloud.google.com/endpoints/docs/grpc/grpc-service-config#service_configuration_overview
   * for the expected file contents.
   * If multiple files are specified, the files are merged with the following
   * rules:
   * * All singular scalar fields are merged using "last one wins" semantics in
   * the order of the files uploaded.
   * * Repeated fields are concatenated.
   * * Singular embedded messages are merged using these rules for nested
   * fields.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.apigateway.v1.ApiConfig.File managed_service_configs = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.apigateway.v1.ApiConfig.File>
      getManagedServiceConfigsList() {
    return managedServiceConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Service Configuration files. At least one must be included when using gRPC
   * service definitions. See
   * https://cloud.google.com/endpoints/docs/grpc/grpc-service-config#service_configuration_overview
   * for the expected file contents.
   * If multiple files are specified, the files are merged with the following
   * rules:
   * * All singular scalar fields are merged using "last one wins" semantics in
   * the order of the files uploaded.
   * * Repeated fields are concatenated.
   * * Singular embedded messages are merged using these rules for nested
   * fields.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.apigateway.v1.ApiConfig.File managed_service_configs = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder>
      getManagedServiceConfigsOrBuilderList() {
    return managedServiceConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Service Configuration files. At least one must be included when using gRPC
   * service definitions. See
   * https://cloud.google.com/endpoints/docs/grpc/grpc-service-config#service_configuration_overview
   * for the expected file contents.
   * If multiple files are specified, the files are merged with the following
   * rules:
   * * All singular scalar fields are merged using "last one wins" semantics in
   * the order of the files uploaded.
   * * Repeated fields are concatenated.
   * * Singular embedded messages are merged using these rules for nested
   * fields.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.apigateway.v1.ApiConfig.File managed_service_configs = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getManagedServiceConfigsCount() {
    return managedServiceConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Service Configuration files. At least one must be included when using gRPC
   * service definitions. See
   * https://cloud.google.com/endpoints/docs/grpc/grpc-service-config#service_configuration_overview
   * for the expected file contents.
   * If multiple files are specified, the files are merged with the following
   * rules:
   * * All singular scalar fields are merged using "last one wins" semantics in
   * the order of the files uploaded.
   * * Repeated fields are concatenated.
   * * Singular embedded messages are merged using these rules for nested
   * fields.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.apigateway.v1.ApiConfig.File managed_service_configs = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.apigateway.v1.ApiConfig.File getManagedServiceConfigs(int index) {
    return managedServiceConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Service Configuration files. At least one must be included when using gRPC
   * service definitions. See
   * https://cloud.google.com/endpoints/docs/grpc/grpc-service-config#service_configuration_overview
   * for the expected file contents.
   * If multiple files are specified, the files are merged with the following
   * rules:
   * * All singular scalar fields are merged using "last one wins" semantics in
   * the order of the files uploaded.
   * * Repeated fields are concatenated.
   * * Singular embedded messages are merged using these rules for nested
   * fields.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.apigateway.v1.ApiConfig.File managed_service_configs = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder getManagedServiceConfigsOrBuilder(
      int index) {
    return managedServiceConfigs_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(3, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, displayName_);
    }
    if (state_ != com.google.cloud.apigateway.v1.ApiConfig.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(8, state_);
    }
    for (int i = 0; i < openapiDocuments_.size(); i++) {
      output.writeMessage(9, openapiDocuments_.get(i));
    }
    for (int i = 0; i < grpcServices_.size(); i++) {
      output.writeMessage(10, grpcServices_.get(i));
    }
    for (int i = 0; i < managedServiceConfigs_.size(); i++) {
      output.writeMessage(11, managedServiceConfigs_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceConfigId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, serviceConfigId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gatewayServiceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, gatewayServiceAccount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, displayName_);
    }
    if (state_ != com.google.cloud.apigateway.v1.ApiConfig.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, state_);
    }
    for (int i = 0; i < openapiDocuments_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, openapiDocuments_.get(i));
    }
    for (int i = 0; i < grpcServices_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, grpcServices_.get(i));
    }
    for (int i = 0; i < managedServiceConfigs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, managedServiceConfigs_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceConfigId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, serviceConfigId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gatewayServiceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, gatewayServiceAccount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.apigateway.v1.ApiConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.apigateway.v1.ApiConfig other = (com.google.cloud.apigateway.v1.ApiConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getGatewayServiceAccount().equals(other.getGatewayServiceAccount())) return false;
    if (!getServiceConfigId().equals(other.getServiceConfigId())) return false;
    if (state_ != other.state_) return false;
    if (!getOpenapiDocumentsList().equals(other.getOpenapiDocumentsList())) return false;
    if (!getGrpcServicesList().equals(other.getGrpcServicesList())) return false;
    if (!getManagedServiceConfigsList().equals(other.getManagedServiceConfigsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + GATEWAY_SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getGatewayServiceAccount().hashCode();
    hash = (37 * hash) + SERVICE_CONFIG_ID_FIELD_NUMBER;
    hash = (53 * hash) + getServiceConfigId().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (getOpenapiDocumentsCount() > 0) {
      hash = (37 * hash) + OPENAPI_DOCUMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getOpenapiDocumentsList().hashCode();
    }
    if (getGrpcServicesCount() > 0) {
      hash = (37 * hash) + GRPC_SERVICES_FIELD_NUMBER;
      hash = (53 * hash) + getGrpcServicesList().hashCode();
    }
    if (getManagedServiceConfigsCount() > 0) {
      hash = (37 * hash) + MANAGED_SERVICE_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getManagedServiceConfigsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.apigateway.v1.ApiConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.apigateway.v1.ApiConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.apigateway.v1.ApiConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.apigateway.v1.ApiConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.apigateway.v1.ApiConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.apigateway.v1.ApiConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.apigateway.v1.ApiConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.apigateway.v1.ApiConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.apigateway.v1.ApiConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.apigateway.v1.ApiConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.apigateway.v1.ApiConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.apigateway.v1.ApiConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.apigateway.v1.ApiConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An API Configuration is a combination of settings for both the Managed
   * Service and Gateways serving this API Config.
   * </pre>
   *
   * Protobuf type {@code google.cloud.apigateway.v1.ApiConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.apigateway.v1.ApiConfig)
      com.google.cloud.apigateway.v1.ApiConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.apigateway.v1.Apigateway
          .internal_static_google_cloud_apigateway_v1_ApiConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.apigateway.v1.Apigateway
          .internal_static_google_cloud_apigateway_v1_ApiConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.apigateway.v1.ApiConfig.class,
              com.google.cloud.apigateway.v1.ApiConfig.Builder.class);
    }

    // Construct using com.google.cloud.apigateway.v1.ApiConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      displayName_ = "";

      gatewayServiceAccount_ = "";

      serviceConfigId_ = "";

      state_ = 0;

      if (openapiDocumentsBuilder_ == null) {
        openapiDocuments_ = java.util.Collections.emptyList();
      } else {
        openapiDocuments_ = null;
        openapiDocumentsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (grpcServicesBuilder_ == null) {
        grpcServices_ = java.util.Collections.emptyList();
      } else {
        grpcServices_ = null;
        grpcServicesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (managedServiceConfigsBuilder_ == null) {
        managedServiceConfigs_ = java.util.Collections.emptyList();
      } else {
        managedServiceConfigs_ = null;
        managedServiceConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.apigateway.v1.Apigateway
          .internal_static_google_cloud_apigateway_v1_ApiConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.apigateway.v1.ApiConfig getDefaultInstanceForType() {
      return com.google.cloud.apigateway.v1.ApiConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.apigateway.v1.ApiConfig build() {
      com.google.cloud.apigateway.v1.ApiConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.apigateway.v1.ApiConfig buildPartial() {
      com.google.cloud.apigateway.v1.ApiConfig result =
          new com.google.cloud.apigateway.v1.ApiConfig(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      result.displayName_ = displayName_;
      result.gatewayServiceAccount_ = gatewayServiceAccount_;
      result.serviceConfigId_ = serviceConfigId_;
      result.state_ = state_;
      if (openapiDocumentsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          openapiDocuments_ = java.util.Collections.unmodifiableList(openapiDocuments_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.openapiDocuments_ = openapiDocuments_;
      } else {
        result.openapiDocuments_ = openapiDocumentsBuilder_.build();
      }
      if (grpcServicesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          grpcServices_ = java.util.Collections.unmodifiableList(grpcServices_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.grpcServices_ = grpcServices_;
      } else {
        result.grpcServices_ = grpcServicesBuilder_.build();
      }
      if (managedServiceConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          managedServiceConfigs_ = java.util.Collections.unmodifiableList(managedServiceConfigs_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.managedServiceConfigs_ = managedServiceConfigs_;
      } else {
        result.managedServiceConfigs_ = managedServiceConfigsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.apigateway.v1.ApiConfig) {
        return mergeFrom((com.google.cloud.apigateway.v1.ApiConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.apigateway.v1.ApiConfig other) {
      if (other == com.google.cloud.apigateway.v1.ApiConfig.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (!other.getGatewayServiceAccount().isEmpty()) {
        gatewayServiceAccount_ = other.gatewayServiceAccount_;
        onChanged();
      }
      if (!other.getServiceConfigId().isEmpty()) {
        serviceConfigId_ = other.serviceConfigId_;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (openapiDocumentsBuilder_ == null) {
        if (!other.openapiDocuments_.isEmpty()) {
          if (openapiDocuments_.isEmpty()) {
            openapiDocuments_ = other.openapiDocuments_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureOpenapiDocumentsIsMutable();
            openapiDocuments_.addAll(other.openapiDocuments_);
          }
          onChanged();
        }
      } else {
        if (!other.openapiDocuments_.isEmpty()) {
          if (openapiDocumentsBuilder_.isEmpty()) {
            openapiDocumentsBuilder_.dispose();
            openapiDocumentsBuilder_ = null;
            openapiDocuments_ = other.openapiDocuments_;
            bitField0_ = (bitField0_ & ~0x00000002);
            openapiDocumentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getOpenapiDocumentsFieldBuilder()
                    : null;
          } else {
            openapiDocumentsBuilder_.addAllMessages(other.openapiDocuments_);
          }
        }
      }
      if (grpcServicesBuilder_ == null) {
        if (!other.grpcServices_.isEmpty()) {
          if (grpcServices_.isEmpty()) {
            grpcServices_ = other.grpcServices_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureGrpcServicesIsMutable();
            grpcServices_.addAll(other.grpcServices_);
          }
          onChanged();
        }
      } else {
        if (!other.grpcServices_.isEmpty()) {
          if (grpcServicesBuilder_.isEmpty()) {
            grpcServicesBuilder_.dispose();
            grpcServicesBuilder_ = null;
            grpcServices_ = other.grpcServices_;
            bitField0_ = (bitField0_ & ~0x00000004);
            grpcServicesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getGrpcServicesFieldBuilder()
                    : null;
          } else {
            grpcServicesBuilder_.addAllMessages(other.grpcServices_);
          }
        }
      }
      if (managedServiceConfigsBuilder_ == null) {
        if (!other.managedServiceConfigs_.isEmpty()) {
          if (managedServiceConfigs_.isEmpty()) {
            managedServiceConfigs_ = other.managedServiceConfigs_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureManagedServiceConfigsIsMutable();
            managedServiceConfigs_.addAll(other.managedServiceConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.managedServiceConfigs_.isEmpty()) {
          if (managedServiceConfigsBuilder_.isEmpty()) {
            managedServiceConfigsBuilder_.dispose();
            managedServiceConfigsBuilder_ = null;
            managedServiceConfigs_ = other.managedServiceConfigs_;
            bitField0_ = (bitField0_ & ~0x00000008);
            managedServiceConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getManagedServiceConfigsFieldBuilder()
                    : null;
          } else {
            managedServiceConfigsBuilder_.addAllMessages(other.managedServiceConfigs_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                break;
              } // case 34
            case 42:
              {
                displayName_ = input.readStringRequireUtf8();

                break;
              } // case 42
            case 64:
              {
                state_ = input.readEnum();

                break;
              } // case 64
            case 74:
              {
                com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument m =
                    input.readMessage(
                        com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument.parser(),
                        extensionRegistry);
                if (openapiDocumentsBuilder_ == null) {
                  ensureOpenapiDocumentsIsMutable();
                  openapiDocuments_.add(m);
                } else {
                  openapiDocumentsBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 82:
              {
                com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition m =
                    input.readMessage(
                        com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition.parser(),
                        extensionRegistry);
                if (grpcServicesBuilder_ == null) {
                  ensureGrpcServicesIsMutable();
                  grpcServices_.add(m);
                } else {
                  grpcServicesBuilder_.addMessage(m);
                }
                break;
              } // case 82
            case 90:
              {
                com.google.cloud.apigateway.v1.ApiConfig.File m =
                    input.readMessage(
                        com.google.cloud.apigateway.v1.ApiConfig.File.parser(), extensionRegistry);
                if (managedServiceConfigsBuilder_ == null) {
                  ensureManagedServiceConfigsIsMutable();
                  managedServiceConfigs_.add(m);
                } else {
                  managedServiceConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 90
            case 98:
              {
                serviceConfigId_ = input.readStringRequireUtf8();

                break;
              } // case 98
            case 114:
              {
                gatewayServiceAccount_ = input.readStringRequireUtf8();

                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the API Config.
     * Format: projects/{project}/locations/global/apis/{api}/configs/{api_config}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the API Config.
     * Format: projects/{project}/locations/global/apis/{api}/configs/{api_config}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the API Config.
     * Format: projects/{project}/locations/global/apis/{api}/configs/{api_config}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the API Config.
     * Format: projects/{project}/locations/global/apis/{api}/configs/{api_config}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the API Config.
     * Format: projects/{project}/locations/global/apis/{api}/configs/{api_config}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Created time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Created time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Created time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Created time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Created time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Created time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Created time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Created time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Created time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Updated time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Updated time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Updated time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Updated time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Updated time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Updated time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Updated time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Updated time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Updated time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Resource labels to represent user-provided metadata.
     * Refer to cloud documentation on labels for more details.
     * https://cloud.google.com/compute/docs/labeling-resources
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Resource labels to represent user-provided metadata.
     * Refer to cloud documentation on labels for more details.
     * https://cloud.google.com/compute/docs/labeling-resources
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Resource labels to represent user-provided metadata.
     * Refer to cloud documentation on labels for more details.
     * https://cloud.google.com/compute/docs/labeling-resources
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resource labels to represent user-provided metadata.
     * Refer to cloud documentation on labels for more details.
     * https://cloud.google.com/compute/docs/labeling-resources
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resource labels to represent user-provided metadata.
     * Refer to cloud documentation on labels for more details.
     * https://cloud.google.com/compute/docs/labeling-resources
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Resource labels to represent user-provided metadata.
     * Refer to cloud documentation on labels for more details.
     * https://cloud.google.com/compute/docs/labeling-resources
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resource labels to represent user-provided metadata.
     * Refer to cloud documentation on labels for more details.
     * https://cloud.google.com/compute/docs/labeling-resources
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Display name.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Display name.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Display name.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Display name.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Display name.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object gatewayServiceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The Google Cloud IAM Service Account that Gateways serving this config
     * should use to authenticate to other services. This may either be the
     * Service Account's email
     * (`{ACCOUNT_ID}&#64;{PROJECT}.iam.gserviceaccount.com`) or its full resource
     * name (`projects/{PROJECT}/accounts/{UNIQUE_ID}`). This is most often used
     * when the service is a GCP resource such as a Cloud Run Service or an
     * IAP-secured service.
     * </pre>
     *
     * <code>
     * string gateway_service_account = 14 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The gatewayServiceAccount.
     */
    public java.lang.String getGatewayServiceAccount() {
      java.lang.Object ref = gatewayServiceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gatewayServiceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The Google Cloud IAM Service Account that Gateways serving this config
     * should use to authenticate to other services. This may either be the
     * Service Account's email
     * (`{ACCOUNT_ID}&#64;{PROJECT}.iam.gserviceaccount.com`) or its full resource
     * name (`projects/{PROJECT}/accounts/{UNIQUE_ID}`). This is most often used
     * when the service is a GCP resource such as a Cloud Run Service or an
     * IAP-secured service.
     * </pre>
     *
     * <code>
     * string gateway_service_account = 14 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for gatewayServiceAccount.
     */
    public com.google.protobuf.ByteString getGatewayServiceAccountBytes() {
      java.lang.Object ref = gatewayServiceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gatewayServiceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The Google Cloud IAM Service Account that Gateways serving this config
     * should use to authenticate to other services. This may either be the
     * Service Account's email
     * (`{ACCOUNT_ID}&#64;{PROJECT}.iam.gserviceaccount.com`) or its full resource
     * name (`projects/{PROJECT}/accounts/{UNIQUE_ID}`). This is most often used
     * when the service is a GCP resource such as a Cloud Run Service or an
     * IAP-secured service.
     * </pre>
     *
     * <code>
     * string gateway_service_account = 14 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The gatewayServiceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setGatewayServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      gatewayServiceAccount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The Google Cloud IAM Service Account that Gateways serving this config
     * should use to authenticate to other services. This may either be the
     * Service Account's email
     * (`{ACCOUNT_ID}&#64;{PROJECT}.iam.gserviceaccount.com`) or its full resource
     * name (`projects/{PROJECT}/accounts/{UNIQUE_ID}`). This is most often used
     * when the service is a GCP resource such as a Cloud Run Service or an
     * IAP-secured service.
     * </pre>
     *
     * <code>
     * string gateway_service_account = 14 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGatewayServiceAccount() {

      gatewayServiceAccount_ = getDefaultInstance().getGatewayServiceAccount();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The Google Cloud IAM Service Account that Gateways serving this config
     * should use to authenticate to other services. This may either be the
     * Service Account's email
     * (`{ACCOUNT_ID}&#64;{PROJECT}.iam.gserviceaccount.com`) or its full resource
     * name (`projects/{PROJECT}/accounts/{UNIQUE_ID}`). This is most often used
     * when the service is a GCP resource such as a Cloud Run Service or an
     * IAP-secured service.
     * </pre>
     *
     * <code>
     * string gateway_service_account = 14 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for gatewayServiceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setGatewayServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      gatewayServiceAccount_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object serviceConfigId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The ID of the associated Service Config (
     * https://cloud.google.com/service-infrastructure/docs/glossary#config).
     * </pre>
     *
     * <code>
     * string service_config_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The serviceConfigId.
     */
    public java.lang.String getServiceConfigId() {
      java.lang.Object ref = serviceConfigId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceConfigId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the associated Service Config (
     * https://cloud.google.com/service-infrastructure/docs/glossary#config).
     * </pre>
     *
     * <code>
     * string service_config_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for serviceConfigId.
     */
    public com.google.protobuf.ByteString getServiceConfigIdBytes() {
      java.lang.Object ref = serviceConfigId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceConfigId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the associated Service Config (
     * https://cloud.google.com/service-infrastructure/docs/glossary#config).
     * </pre>
     *
     * <code>
     * string service_config_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The serviceConfigId to set.
     * @return This builder for chaining.
     */
    public Builder setServiceConfigId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      serviceConfigId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the associated Service Config (
     * https://cloud.google.com/service-infrastructure/docs/glossary#config).
     * </pre>
     *
     * <code>
     * string service_config_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceConfigId() {

      serviceConfigId_ = getDefaultInstance().getServiceConfigId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the associated Service Config (
     * https://cloud.google.com/service-infrastructure/docs/glossary#config).
     * </pre>
     *
     * <code>
     * string service_config_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for serviceConfigId to set.
     * @return This builder for chaining.
     */
    public Builder setServiceConfigIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      serviceConfigId_ = value;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. State of the API Config.
     * </pre>
     *
     * <code>
     * .google.cloud.apigateway.v1.ApiConfig.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the API Config.
     * </pre>
     *
     * <code>
     * .google.cloud.apigateway.v1.ApiConfig.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the API Config.
     * </pre>
     *
     * <code>
     * .google.cloud.apigateway.v1.ApiConfig.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.apigateway.v1.ApiConfig.State getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.apigateway.v1.ApiConfig.State result =
          com.google.cloud.apigateway.v1.ApiConfig.State.valueOf(state_);
      return result == null ? com.google.cloud.apigateway.v1.ApiConfig.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the API Config.
     * </pre>
     *
     * <code>
     * .google.cloud.apigateway.v1.ApiConfig.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.apigateway.v1.ApiConfig.State value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the API Config.
     * </pre>
     *
     * <code>
     * .google.cloud.apigateway.v1.ApiConfig.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument>
        openapiDocuments_ = java.util.Collections.emptyList();

    private void ensureOpenapiDocumentsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        openapiDocuments_ =
            new java.util.ArrayList<com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument>(
                openapiDocuments_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument,
            com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument.Builder,
            com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocumentOrBuilder>
        openapiDocumentsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. OpenAPI specification documents. If specified, grpc_services and
     * managed_service_configs must not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.OpenApiDocument openapi_documents = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument>
        getOpenapiDocumentsList() {
      if (openapiDocumentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(openapiDocuments_);
      } else {
        return openapiDocumentsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. OpenAPI specification documents. If specified, grpc_services and
     * managed_service_configs must not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.OpenApiDocument openapi_documents = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getOpenapiDocumentsCount() {
      if (openapiDocumentsBuilder_ == null) {
        return openapiDocuments_.size();
      } else {
        return openapiDocumentsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. OpenAPI specification documents. If specified, grpc_services and
     * managed_service_configs must not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.OpenApiDocument openapi_documents = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument getOpenapiDocuments(int index) {
      if (openapiDocumentsBuilder_ == null) {
        return openapiDocuments_.get(index);
      } else {
        return openapiDocumentsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. OpenAPI specification documents. If specified, grpc_services and
     * managed_service_configs must not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.OpenApiDocument openapi_documents = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOpenapiDocuments(
        int index, com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument value) {
      if (openapiDocumentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOpenapiDocumentsIsMutable();
        openapiDocuments_.set(index, value);
        onChanged();
      } else {
        openapiDocumentsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. OpenAPI specification documents. If specified, grpc_services and
     * managed_service_configs must not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.OpenApiDocument openapi_documents = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOpenapiDocuments(
        int index,
        com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument.Builder builderForValue) {
      if (openapiDocumentsBuilder_ == null) {
        ensureOpenapiDocumentsIsMutable();
        openapiDocuments_.set(index, builderForValue.build());
        onChanged();
      } else {
        openapiDocumentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. OpenAPI specification documents. If specified, grpc_services and
     * managed_service_configs must not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.OpenApiDocument openapi_documents = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addOpenapiDocuments(
        com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument value) {
      if (openapiDocumentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOpenapiDocumentsIsMutable();
        openapiDocuments_.add(value);
        onChanged();
      } else {
        openapiDocumentsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. OpenAPI specification documents. If specified, grpc_services and
     * managed_service_configs must not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.OpenApiDocument openapi_documents = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addOpenapiDocuments(
        int index, com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument value) {
      if (openapiDocumentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOpenapiDocumentsIsMutable();
        openapiDocuments_.add(index, value);
        onChanged();
      } else {
        openapiDocumentsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. OpenAPI specification documents. If specified, grpc_services and
     * managed_service_configs must not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.OpenApiDocument openapi_documents = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addOpenapiDocuments(
        com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument.Builder builderForValue) {
      if (openapiDocumentsBuilder_ == null) {
        ensureOpenapiDocumentsIsMutable();
        openapiDocuments_.add(builderForValue.build());
        onChanged();
      } else {
        openapiDocumentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. OpenAPI specification documents. If specified, grpc_services and
     * managed_service_configs must not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.OpenApiDocument openapi_documents = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addOpenapiDocuments(
        int index,
        com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument.Builder builderForValue) {
      if (openapiDocumentsBuilder_ == null) {
        ensureOpenapiDocumentsIsMutable();
        openapiDocuments_.add(index, builderForValue.build());
        onChanged();
      } else {
        openapiDocumentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. OpenAPI specification documents. If specified, grpc_services and
     * managed_service_configs must not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.OpenApiDocument openapi_documents = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllOpenapiDocuments(
        java.lang.Iterable<? extends com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument>
            values) {
      if (openapiDocumentsBuilder_ == null) {
        ensureOpenapiDocumentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, openapiDocuments_);
        onChanged();
      } else {
        openapiDocumentsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. OpenAPI specification documents. If specified, grpc_services and
     * managed_service_configs must not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.OpenApiDocument openapi_documents = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearOpenapiDocuments() {
      if (openapiDocumentsBuilder_ == null) {
        openapiDocuments_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        openapiDocumentsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. OpenAPI specification documents. If specified, grpc_services and
     * managed_service_configs must not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.OpenApiDocument openapi_documents = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeOpenapiDocuments(int index) {
      if (openapiDocumentsBuilder_ == null) {
        ensureOpenapiDocumentsIsMutable();
        openapiDocuments_.remove(index);
        onChanged();
      } else {
        openapiDocumentsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. OpenAPI specification documents. If specified, grpc_services and
     * managed_service_configs must not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.OpenApiDocument openapi_documents = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument.Builder
        getOpenapiDocumentsBuilder(int index) {
      return getOpenapiDocumentsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. OpenAPI specification documents. If specified, grpc_services and
     * managed_service_configs must not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.OpenApiDocument openapi_documents = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocumentOrBuilder
        getOpenapiDocumentsOrBuilder(int index) {
      if (openapiDocumentsBuilder_ == null) {
        return openapiDocuments_.get(index);
      } else {
        return openapiDocumentsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. OpenAPI specification documents. If specified, grpc_services and
     * managed_service_configs must not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.OpenApiDocument openapi_documents = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocumentOrBuilder>
        getOpenapiDocumentsOrBuilderList() {
      if (openapiDocumentsBuilder_ != null) {
        return openapiDocumentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(openapiDocuments_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. OpenAPI specification documents. If specified, grpc_services and
     * managed_service_configs must not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.OpenApiDocument openapi_documents = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument.Builder
        addOpenapiDocumentsBuilder() {
      return getOpenapiDocumentsFieldBuilder()
          .addBuilder(
              com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. OpenAPI specification documents. If specified, grpc_services and
     * managed_service_configs must not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.OpenApiDocument openapi_documents = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument.Builder
        addOpenapiDocumentsBuilder(int index) {
      return getOpenapiDocumentsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. OpenAPI specification documents. If specified, grpc_services and
     * managed_service_configs must not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.OpenApiDocument openapi_documents = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument.Builder>
        getOpenapiDocumentsBuilderList() {
      return getOpenapiDocumentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument,
            com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument.Builder,
            com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocumentOrBuilder>
        getOpenapiDocumentsFieldBuilder() {
      if (openapiDocumentsBuilder_ == null) {
        openapiDocumentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument,
                com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocument.Builder,
                com.google.cloud.apigateway.v1.ApiConfig.OpenApiDocumentOrBuilder>(
                openapiDocuments_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        openapiDocuments_ = null;
      }
      return openapiDocumentsBuilder_;
    }

    private java.util.List<com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition>
        grpcServices_ = java.util.Collections.emptyList();

    private void ensureGrpcServicesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        grpcServices_ =
            new java.util.ArrayList<com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition>(
                grpcServices_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition,
            com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition.Builder,
            com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinitionOrBuilder>
        grpcServicesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. gRPC service definition files. If specified, openapi_documents must
     * not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition grpc_services = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition>
        getGrpcServicesList() {
      if (grpcServicesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(grpcServices_);
      } else {
        return grpcServicesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. gRPC service definition files. If specified, openapi_documents must
     * not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition grpc_services = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getGrpcServicesCount() {
      if (grpcServicesBuilder_ == null) {
        return grpcServices_.size();
      } else {
        return grpcServicesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. gRPC service definition files. If specified, openapi_documents must
     * not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition grpc_services = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition getGrpcServices(
        int index) {
      if (grpcServicesBuilder_ == null) {
        return grpcServices_.get(index);
      } else {
        return grpcServicesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. gRPC service definition files. If specified, openapi_documents must
     * not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition grpc_services = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGrpcServices(
        int index, com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition value) {
      if (grpcServicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGrpcServicesIsMutable();
        grpcServices_.set(index, value);
        onChanged();
      } else {
        grpcServicesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. gRPC service definition files. If specified, openapi_documents must
     * not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition grpc_services = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGrpcServices(
        int index,
        com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition.Builder builderForValue) {
      if (grpcServicesBuilder_ == null) {
        ensureGrpcServicesIsMutable();
        grpcServices_.set(index, builderForValue.build());
        onChanged();
      } else {
        grpcServicesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. gRPC service definition files. If specified, openapi_documents must
     * not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition grpc_services = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addGrpcServices(
        com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition value) {
      if (grpcServicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGrpcServicesIsMutable();
        grpcServices_.add(value);
        onChanged();
      } else {
        grpcServicesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. gRPC service definition files. If specified, openapi_documents must
     * not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition grpc_services = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addGrpcServices(
        int index, com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition value) {
      if (grpcServicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGrpcServicesIsMutable();
        grpcServices_.add(index, value);
        onChanged();
      } else {
        grpcServicesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. gRPC service definition files. If specified, openapi_documents must
     * not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition grpc_services = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addGrpcServices(
        com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition.Builder builderForValue) {
      if (grpcServicesBuilder_ == null) {
        ensureGrpcServicesIsMutable();
        grpcServices_.add(builderForValue.build());
        onChanged();
      } else {
        grpcServicesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. gRPC service definition files. If specified, openapi_documents must
     * not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition grpc_services = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addGrpcServices(
        int index,
        com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition.Builder builderForValue) {
      if (grpcServicesBuilder_ == null) {
        ensureGrpcServicesIsMutable();
        grpcServices_.add(index, builderForValue.build());
        onChanged();
      } else {
        grpcServicesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. gRPC service definition files. If specified, openapi_documents must
     * not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition grpc_services = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllGrpcServices(
        java.lang.Iterable<? extends com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition>
            values) {
      if (grpcServicesBuilder_ == null) {
        ensureGrpcServicesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, grpcServices_);
        onChanged();
      } else {
        grpcServicesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. gRPC service definition files. If specified, openapi_documents must
     * not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition grpc_services = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGrpcServices() {
      if (grpcServicesBuilder_ == null) {
        grpcServices_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        grpcServicesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. gRPC service definition files. If specified, openapi_documents must
     * not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition grpc_services = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeGrpcServices(int index) {
      if (grpcServicesBuilder_ == null) {
        ensureGrpcServicesIsMutable();
        grpcServices_.remove(index);
        onChanged();
      } else {
        grpcServicesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. gRPC service definition files. If specified, openapi_documents must
     * not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition grpc_services = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition.Builder
        getGrpcServicesBuilder(int index) {
      return getGrpcServicesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. gRPC service definition files. If specified, openapi_documents must
     * not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition grpc_services = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinitionOrBuilder
        getGrpcServicesOrBuilder(int index) {
      if (grpcServicesBuilder_ == null) {
        return grpcServices_.get(index);
      } else {
        return grpcServicesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. gRPC service definition files. If specified, openapi_documents must
     * not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition grpc_services = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinitionOrBuilder>
        getGrpcServicesOrBuilderList() {
      if (grpcServicesBuilder_ != null) {
        return grpcServicesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(grpcServices_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. gRPC service definition files. If specified, openapi_documents must
     * not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition grpc_services = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition.Builder
        addGrpcServicesBuilder() {
      return getGrpcServicesFieldBuilder()
          .addBuilder(
              com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. gRPC service definition files. If specified, openapi_documents must
     * not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition grpc_services = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition.Builder
        addGrpcServicesBuilder(int index) {
      return getGrpcServicesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. gRPC service definition files. If specified, openapi_documents must
     * not be included.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition grpc_services = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition.Builder>
        getGrpcServicesBuilderList() {
      return getGrpcServicesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition,
            com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition.Builder,
            com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinitionOrBuilder>
        getGrpcServicesFieldBuilder() {
      if (grpcServicesBuilder_ == null) {
        grpcServicesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition,
                com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinition.Builder,
                com.google.cloud.apigateway.v1.ApiConfig.GrpcServiceDefinitionOrBuilder>(
                grpcServices_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        grpcServices_ = null;
      }
      return grpcServicesBuilder_;
    }

    private java.util.List<com.google.cloud.apigateway.v1.ApiConfig.File> managedServiceConfigs_ =
        java.util.Collections.emptyList();

    private void ensureManagedServiceConfigsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        managedServiceConfigs_ =
            new java.util.ArrayList<com.google.cloud.apigateway.v1.ApiConfig.File>(
                managedServiceConfigs_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.apigateway.v1.ApiConfig.File,
            com.google.cloud.apigateway.v1.ApiConfig.File.Builder,
            com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder>
        managedServiceConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Service Configuration files. At least one must be included when using gRPC
     * service definitions. See
     * https://cloud.google.com/endpoints/docs/grpc/grpc-service-config#service_configuration_overview
     * for the expected file contents.
     * If multiple files are specified, the files are merged with the following
     * rules:
     * * All singular scalar fields are merged using "last one wins" semantics in
     * the order of the files uploaded.
     * * Repeated fields are concatenated.
     * * Singular embedded messages are merged using these rules for nested
     * fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File managed_service_configs = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.apigateway.v1.ApiConfig.File>
        getManagedServiceConfigsList() {
      if (managedServiceConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(managedServiceConfigs_);
      } else {
        return managedServiceConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Service Configuration files. At least one must be included when using gRPC
     * service definitions. See
     * https://cloud.google.com/endpoints/docs/grpc/grpc-service-config#service_configuration_overview
     * for the expected file contents.
     * If multiple files are specified, the files are merged with the following
     * rules:
     * * All singular scalar fields are merged using "last one wins" semantics in
     * the order of the files uploaded.
     * * Repeated fields are concatenated.
     * * Singular embedded messages are merged using these rules for nested
     * fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File managed_service_configs = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getManagedServiceConfigsCount() {
      if (managedServiceConfigsBuilder_ == null) {
        return managedServiceConfigs_.size();
      } else {
        return managedServiceConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Service Configuration files. At least one must be included when using gRPC
     * service definitions. See
     * https://cloud.google.com/endpoints/docs/grpc/grpc-service-config#service_configuration_overview
     * for the expected file contents.
     * If multiple files are specified, the files are merged with the following
     * rules:
     * * All singular scalar fields are merged using "last one wins" semantics in
     * the order of the files uploaded.
     * * Repeated fields are concatenated.
     * * Singular embedded messages are merged using these rules for nested
     * fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File managed_service_configs = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.apigateway.v1.ApiConfig.File getManagedServiceConfigs(int index) {
      if (managedServiceConfigsBuilder_ == null) {
        return managedServiceConfigs_.get(index);
      } else {
        return managedServiceConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Service Configuration files. At least one must be included when using gRPC
     * service definitions. See
     * https://cloud.google.com/endpoints/docs/grpc/grpc-service-config#service_configuration_overview
     * for the expected file contents.
     * If multiple files are specified, the files are merged with the following
     * rules:
     * * All singular scalar fields are merged using "last one wins" semantics in
     * the order of the files uploaded.
     * * Repeated fields are concatenated.
     * * Singular embedded messages are merged using these rules for nested
     * fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File managed_service_configs = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setManagedServiceConfigs(
        int index, com.google.cloud.apigateway.v1.ApiConfig.File value) {
      if (managedServiceConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureManagedServiceConfigsIsMutable();
        managedServiceConfigs_.set(index, value);
        onChanged();
      } else {
        managedServiceConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Service Configuration files. At least one must be included when using gRPC
     * service definitions. See
     * https://cloud.google.com/endpoints/docs/grpc/grpc-service-config#service_configuration_overview
     * for the expected file contents.
     * If multiple files are specified, the files are merged with the following
     * rules:
     * * All singular scalar fields are merged using "last one wins" semantics in
     * the order of the files uploaded.
     * * Repeated fields are concatenated.
     * * Singular embedded messages are merged using these rules for nested
     * fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File managed_service_configs = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setManagedServiceConfigs(
        int index, com.google.cloud.apigateway.v1.ApiConfig.File.Builder builderForValue) {
      if (managedServiceConfigsBuilder_ == null) {
        ensureManagedServiceConfigsIsMutable();
        managedServiceConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        managedServiceConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Service Configuration files. At least one must be included when using gRPC
     * service definitions. See
     * https://cloud.google.com/endpoints/docs/grpc/grpc-service-config#service_configuration_overview
     * for the expected file contents.
     * If multiple files are specified, the files are merged with the following
     * rules:
     * * All singular scalar fields are merged using "last one wins" semantics in
     * the order of the files uploaded.
     * * Repeated fields are concatenated.
     * * Singular embedded messages are merged using these rules for nested
     * fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File managed_service_configs = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addManagedServiceConfigs(com.google.cloud.apigateway.v1.ApiConfig.File value) {
      if (managedServiceConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureManagedServiceConfigsIsMutable();
        managedServiceConfigs_.add(value);
        onChanged();
      } else {
        managedServiceConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Service Configuration files. At least one must be included when using gRPC
     * service definitions. See
     * https://cloud.google.com/endpoints/docs/grpc/grpc-service-config#service_configuration_overview
     * for the expected file contents.
     * If multiple files are specified, the files are merged with the following
     * rules:
     * * All singular scalar fields are merged using "last one wins" semantics in
     * the order of the files uploaded.
     * * Repeated fields are concatenated.
     * * Singular embedded messages are merged using these rules for nested
     * fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File managed_service_configs = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addManagedServiceConfigs(
        int index, com.google.cloud.apigateway.v1.ApiConfig.File value) {
      if (managedServiceConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureManagedServiceConfigsIsMutable();
        managedServiceConfigs_.add(index, value);
        onChanged();
      } else {
        managedServiceConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Service Configuration files. At least one must be included when using gRPC
     * service definitions. See
     * https://cloud.google.com/endpoints/docs/grpc/grpc-service-config#service_configuration_overview
     * for the expected file contents.
     * If multiple files are specified, the files are merged with the following
     * rules:
     * * All singular scalar fields are merged using "last one wins" semantics in
     * the order of the files uploaded.
     * * Repeated fields are concatenated.
     * * Singular embedded messages are merged using these rules for nested
     * fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File managed_service_configs = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addManagedServiceConfigs(
        com.google.cloud.apigateway.v1.ApiConfig.File.Builder builderForValue) {
      if (managedServiceConfigsBuilder_ == null) {
        ensureManagedServiceConfigsIsMutable();
        managedServiceConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        managedServiceConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Service Configuration files. At least one must be included when using gRPC
     * service definitions. See
     * https://cloud.google.com/endpoints/docs/grpc/grpc-service-config#service_configuration_overview
     * for the expected file contents.
     * If multiple files are specified, the files are merged with the following
     * rules:
     * * All singular scalar fields are merged using "last one wins" semantics in
     * the order of the files uploaded.
     * * Repeated fields are concatenated.
     * * Singular embedded messages are merged using these rules for nested
     * fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File managed_service_configs = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addManagedServiceConfigs(
        int index, com.google.cloud.apigateway.v1.ApiConfig.File.Builder builderForValue) {
      if (managedServiceConfigsBuilder_ == null) {
        ensureManagedServiceConfigsIsMutable();
        managedServiceConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        managedServiceConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Service Configuration files. At least one must be included when using gRPC
     * service definitions. See
     * https://cloud.google.com/endpoints/docs/grpc/grpc-service-config#service_configuration_overview
     * for the expected file contents.
     * If multiple files are specified, the files are merged with the following
     * rules:
     * * All singular scalar fields are merged using "last one wins" semantics in
     * the order of the files uploaded.
     * * Repeated fields are concatenated.
     * * Singular embedded messages are merged using these rules for nested
     * fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File managed_service_configs = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllManagedServiceConfigs(
        java.lang.Iterable<? extends com.google.cloud.apigateway.v1.ApiConfig.File> values) {
      if (managedServiceConfigsBuilder_ == null) {
        ensureManagedServiceConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, managedServiceConfigs_);
        onChanged();
      } else {
        managedServiceConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Service Configuration files. At least one must be included when using gRPC
     * service definitions. See
     * https://cloud.google.com/endpoints/docs/grpc/grpc-service-config#service_configuration_overview
     * for the expected file contents.
     * If multiple files are specified, the files are merged with the following
     * rules:
     * * All singular scalar fields are merged using "last one wins" semantics in
     * the order of the files uploaded.
     * * Repeated fields are concatenated.
     * * Singular embedded messages are merged using these rules for nested
     * fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File managed_service_configs = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearManagedServiceConfigs() {
      if (managedServiceConfigsBuilder_ == null) {
        managedServiceConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        managedServiceConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Service Configuration files. At least one must be included when using gRPC
     * service definitions. See
     * https://cloud.google.com/endpoints/docs/grpc/grpc-service-config#service_configuration_overview
     * for the expected file contents.
     * If multiple files are specified, the files are merged with the following
     * rules:
     * * All singular scalar fields are merged using "last one wins" semantics in
     * the order of the files uploaded.
     * * Repeated fields are concatenated.
     * * Singular embedded messages are merged using these rules for nested
     * fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File managed_service_configs = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeManagedServiceConfigs(int index) {
      if (managedServiceConfigsBuilder_ == null) {
        ensureManagedServiceConfigsIsMutable();
        managedServiceConfigs_.remove(index);
        onChanged();
      } else {
        managedServiceConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Service Configuration files. At least one must be included when using gRPC
     * service definitions. See
     * https://cloud.google.com/endpoints/docs/grpc/grpc-service-config#service_configuration_overview
     * for the expected file contents.
     * If multiple files are specified, the files are merged with the following
     * rules:
     * * All singular scalar fields are merged using "last one wins" semantics in
     * the order of the files uploaded.
     * * Repeated fields are concatenated.
     * * Singular embedded messages are merged using these rules for nested
     * fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File managed_service_configs = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.apigateway.v1.ApiConfig.File.Builder getManagedServiceConfigsBuilder(
        int index) {
      return getManagedServiceConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Service Configuration files. At least one must be included when using gRPC
     * service definitions. See
     * https://cloud.google.com/endpoints/docs/grpc/grpc-service-config#service_configuration_overview
     * for the expected file contents.
     * If multiple files are specified, the files are merged with the following
     * rules:
     * * All singular scalar fields are merged using "last one wins" semantics in
     * the order of the files uploaded.
     * * Repeated fields are concatenated.
     * * Singular embedded messages are merged using these rules for nested
     * fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File managed_service_configs = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder getManagedServiceConfigsOrBuilder(
        int index) {
      if (managedServiceConfigsBuilder_ == null) {
        return managedServiceConfigs_.get(index);
      } else {
        return managedServiceConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Service Configuration files. At least one must be included when using gRPC
     * service definitions. See
     * https://cloud.google.com/endpoints/docs/grpc/grpc-service-config#service_configuration_overview
     * for the expected file contents.
     * If multiple files are specified, the files are merged with the following
     * rules:
     * * All singular scalar fields are merged using "last one wins" semantics in
     * the order of the files uploaded.
     * * Repeated fields are concatenated.
     * * Singular embedded messages are merged using these rules for nested
     * fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File managed_service_configs = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder>
        getManagedServiceConfigsOrBuilderList() {
      if (managedServiceConfigsBuilder_ != null) {
        return managedServiceConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(managedServiceConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Service Configuration files. At least one must be included when using gRPC
     * service definitions. See
     * https://cloud.google.com/endpoints/docs/grpc/grpc-service-config#service_configuration_overview
     * for the expected file contents.
     * If multiple files are specified, the files are merged with the following
     * rules:
     * * All singular scalar fields are merged using "last one wins" semantics in
     * the order of the files uploaded.
     * * Repeated fields are concatenated.
     * * Singular embedded messages are merged using these rules for nested
     * fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File managed_service_configs = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.apigateway.v1.ApiConfig.File.Builder addManagedServiceConfigsBuilder() {
      return getManagedServiceConfigsFieldBuilder()
          .addBuilder(com.google.cloud.apigateway.v1.ApiConfig.File.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Service Configuration files. At least one must be included when using gRPC
     * service definitions. See
     * https://cloud.google.com/endpoints/docs/grpc/grpc-service-config#service_configuration_overview
     * for the expected file contents.
     * If multiple files are specified, the files are merged with the following
     * rules:
     * * All singular scalar fields are merged using "last one wins" semantics in
     * the order of the files uploaded.
     * * Repeated fields are concatenated.
     * * Singular embedded messages are merged using these rules for nested
     * fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File managed_service_configs = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.apigateway.v1.ApiConfig.File.Builder addManagedServiceConfigsBuilder(
        int index) {
      return getManagedServiceConfigsFieldBuilder()
          .addBuilder(index, com.google.cloud.apigateway.v1.ApiConfig.File.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Service Configuration files. At least one must be included when using gRPC
     * service definitions. See
     * https://cloud.google.com/endpoints/docs/grpc/grpc-service-config#service_configuration_overview
     * for the expected file contents.
     * If multiple files are specified, the files are merged with the following
     * rules:
     * * All singular scalar fields are merged using "last one wins" semantics in
     * the order of the files uploaded.
     * * Repeated fields are concatenated.
     * * Singular embedded messages are merged using these rules for nested
     * fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.apigateway.v1.ApiConfig.File managed_service_configs = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.apigateway.v1.ApiConfig.File.Builder>
        getManagedServiceConfigsBuilderList() {
      return getManagedServiceConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.apigateway.v1.ApiConfig.File,
            com.google.cloud.apigateway.v1.ApiConfig.File.Builder,
            com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder>
        getManagedServiceConfigsFieldBuilder() {
      if (managedServiceConfigsBuilder_ == null) {
        managedServiceConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.apigateway.v1.ApiConfig.File,
                com.google.cloud.apigateway.v1.ApiConfig.File.Builder,
                com.google.cloud.apigateway.v1.ApiConfig.FileOrBuilder>(
                managedServiceConfigs_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        managedServiceConfigs_ = null;
      }
      return managedServiceConfigsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.apigateway.v1.ApiConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.apigateway.v1.ApiConfig)
  private static final com.google.cloud.apigateway.v1.ApiConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.apigateway.v1.ApiConfig();
  }

  public static com.google.cloud.apigateway.v1.ApiConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ApiConfig> PARSER =
      new com.google.protobuf.AbstractParser<ApiConfig>() {
        @java.lang.Override
        public ApiConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ApiConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ApiConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.apigateway.v1.ApiConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
