/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FeatureMonitorName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_FEATURE_GROUP_FEATURE_MONITOR = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/featureGroups/{feature_group}/featureMonitors/{feature_monitor}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String featureGroup;
    private final String featureMonitor;

    @Deprecated
    protected FeatureMonitorName() {
        this.project = null;
        this.location = null;
        this.featureGroup = null;
        this.featureMonitor = null;
    }

    private FeatureMonitorName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.featureGroup = (String)Preconditions.checkNotNull((Object)builder.getFeatureGroup());
        this.featureMonitor = (String)Preconditions.checkNotNull((Object)builder.getFeatureMonitor());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFeatureGroup() {
        return this.featureGroup;
    }

    public String getFeatureMonitor() {
        return this.featureMonitor;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FeatureMonitorName of(String project, String location, String featureGroup, String featureMonitor) {
        return FeatureMonitorName.newBuilder().setProject(project).setLocation(location).setFeatureGroup(featureGroup).setFeatureMonitor(featureMonitor).build();
    }

    public static String format(String project, String location, String featureGroup, String featureMonitor) {
        return FeatureMonitorName.newBuilder().setProject(project).setLocation(location).setFeatureGroup(featureGroup).setFeatureMonitor(featureMonitor).build().toString();
    }

    public static FeatureMonitorName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_FEATURE_GROUP_FEATURE_MONITOR.validatedMatch(formattedString, "FeatureMonitorName.parse: formattedString not in valid format");
        return FeatureMonitorName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("feature_group"), (String)matchMap.get("feature_monitor"));
    }

    public static List<FeatureMonitorName> parseList(List<String> formattedStrings) {
        ArrayList<FeatureMonitorName> list = new ArrayList<FeatureMonitorName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FeatureMonitorName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FeatureMonitorName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FeatureMonitorName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_FEATURE_GROUP_FEATURE_MONITOR.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FeatureMonitorName featureMonitorName = this;
            synchronized (featureMonitorName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.featureGroup != null) {
                        fieldMapBuilder.put((Object)"feature_group", (Object)this.featureGroup);
                    }
                    if (this.featureMonitor != null) {
                        fieldMapBuilder.put((Object)"feature_monitor", (Object)this.featureMonitor);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_FEATURE_GROUP_FEATURE_MONITOR.instantiate(new String[]{"project", this.project, "location", this.location, "feature_group", this.featureGroup, "feature_monitor", this.featureMonitor});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FeatureMonitorName that = (FeatureMonitorName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.featureGroup, that.featureGroup) && Objects.equals(this.featureMonitor, that.featureMonitor);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.featureGroup);
        h *= 1000003;
        return h ^= Objects.hashCode(this.featureMonitor);
    }

    public static class Builder {
        private String project;
        private String location;
        private String featureGroup;
        private String featureMonitor;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFeatureGroup() {
            return this.featureGroup;
        }

        public String getFeatureMonitor() {
            return this.featureMonitor;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFeatureGroup(String featureGroup) {
            this.featureGroup = featureGroup;
            return this;
        }

        public Builder setFeatureMonitor(String featureMonitor) {
            this.featureMonitor = featureMonitor;
            return this;
        }

        private Builder(FeatureMonitorName featureMonitorName) {
            this.project = featureMonitorName.project;
            this.location = featureMonitorName.location;
            this.featureGroup = featureMonitorName.featureGroup;
            this.featureMonitor = featureMonitorName.featureMonitor;
        }

        public FeatureMonitorName build() {
            return new FeatureMonitorName(this);
        }
    }
}

