/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/tuning_job.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Represents a TuningJob that runs with Google owned models.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.TuningJob}
 */
public final class TuningJob extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.TuningJob)
    TuningJobOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TuningJob.newBuilder() to construct.
  private TuningJob(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TuningJob() {
    name_ = "";
    tunedModelDisplayName_ = "";
    description_ = "";
    state_ = 0;
    experiment_ = "";
    pipelineJob_ = "";
    serviceAccount_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TuningJob();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.TuningJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_TuningJob_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 12:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.TuningJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_TuningJob_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.TuningJob.class,
            com.google.cloud.aiplatform.v1beta1.TuningJob.Builder.class);
  }

  private int bitField0_;
  private int sourceModelCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object sourceModel_;

  public enum SourceModelCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BASE_MODEL(4),
    SOURCEMODEL_NOT_SET(0);
    private final int value;

    private SourceModelCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceModelCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceModelCase forNumber(int value) {
      switch (value) {
        case 4:
          return BASE_MODEL;
        case 0:
          return SOURCEMODEL_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceModelCase getSourceModelCase() {
    return SourceModelCase.forNumber(sourceModelCase_);
  }

  private int tuningSpecCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object tuningSpec_;

  public enum TuningSpecCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SUPERVISED_TUNING_SPEC(5),
    DISTILLATION_SPEC(17),
    PARTNER_MODEL_TUNING_SPEC(21),
    TUNINGSPEC_NOT_SET(0);
    private final int value;

    private TuningSpecCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TuningSpecCase valueOf(int value) {
      return forNumber(value);
    }

    public static TuningSpecCase forNumber(int value) {
      switch (value) {
        case 5:
          return SUPERVISED_TUNING_SPEC;
        case 17:
          return DISTILLATION_SPEC;
        case 21:
          return PARTNER_MODEL_TUNING_SPEC;
        case 0:
          return TUNINGSPEC_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TuningSpecCase getTuningSpecCase() {
    return TuningSpecCase.forNumber(tuningSpecCase_);
  }

  public static final int BASE_MODEL_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * The base model that is being tuned, e.g., "gemini-1.0-pro-002".
   * </pre>
   *
   * <code>string base_model = 4;</code>
   *
   * @return Whether the baseModel field is set.
   */
  public boolean hasBaseModel() {
    return sourceModelCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * The base model that is being tuned, e.g., "gemini-1.0-pro-002".
   * </pre>
   *
   * <code>string base_model = 4;</code>
   *
   * @return The baseModel.
   */
  public java.lang.String getBaseModel() {
    java.lang.Object ref = "";
    if (sourceModelCase_ == 4) {
      ref = sourceModel_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (sourceModelCase_ == 4) {
        sourceModel_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The base model that is being tuned, e.g., "gemini-1.0-pro-002".
   * </pre>
   *
   * <code>string base_model = 4;</code>
   *
   * @return The bytes for baseModel.
   */
  public com.google.protobuf.ByteString getBaseModelBytes() {
    java.lang.Object ref = "";
    if (sourceModelCase_ == 4) {
      ref = sourceModel_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (sourceModelCase_ == 4) {
        sourceModel_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUPERVISED_TUNING_SPEC_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Tuning Spec for Supervised Fine Tuning.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec supervised_tuning_spec = 5;</code>
   *
   * @return Whether the supervisedTuningSpec field is set.
   */
  @java.lang.Override
  public boolean hasSupervisedTuningSpec() {
    return tuningSpecCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Tuning Spec for Supervised Fine Tuning.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec supervised_tuning_spec = 5;</code>
   *
   * @return The supervisedTuningSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec getSupervisedTuningSpec() {
    if (tuningSpecCase_ == 5) {
      return (com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec) tuningSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Tuning Spec for Supervised Fine Tuning.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec supervised_tuning_spec = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpecOrBuilder
      getSupervisedTuningSpecOrBuilder() {
    if (tuningSpecCase_ == 5) {
      return (com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec) tuningSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.getDefaultInstance();
  }

  public static final int DISTILLATION_SPEC_FIELD_NUMBER = 17;
  /**
   *
   *
   * <pre>
   * Tuning Spec for Distillation.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.DistillationSpec distillation_spec = 17;</code>
   *
   * @return Whether the distillationSpec field is set.
   */
  @java.lang.Override
  public boolean hasDistillationSpec() {
    return tuningSpecCase_ == 17;
  }
  /**
   *
   *
   * <pre>
   * Tuning Spec for Distillation.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.DistillationSpec distillation_spec = 17;</code>
   *
   * @return The distillationSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DistillationSpec getDistillationSpec() {
    if (tuningSpecCase_ == 17) {
      return (com.google.cloud.aiplatform.v1beta1.DistillationSpec) tuningSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.DistillationSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Tuning Spec for Distillation.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.DistillationSpec distillation_spec = 17;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DistillationSpecOrBuilder
      getDistillationSpecOrBuilder() {
    if (tuningSpecCase_ == 17) {
      return (com.google.cloud.aiplatform.v1beta1.DistillationSpec) tuningSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.DistillationSpec.getDefaultInstance();
  }

  public static final int PARTNER_MODEL_TUNING_SPEC_FIELD_NUMBER = 21;
  /**
   *
   *
   * <pre>
   * Tuning Spec for open sourced and third party partner models.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec partner_model_tuning_spec = 21;
   * </code>
   *
   * @return Whether the partnerModelTuningSpec field is set.
   */
  @java.lang.Override
  public boolean hasPartnerModelTuningSpec() {
    return tuningSpecCase_ == 21;
  }
  /**
   *
   *
   * <pre>
   * Tuning Spec for open sourced and third party partner models.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec partner_model_tuning_spec = 21;
   * </code>
   *
   * @return The partnerModelTuningSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec getPartnerModelTuningSpec() {
    if (tuningSpecCase_ == 21) {
      return (com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec) tuningSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Tuning Spec for open sourced and third party partner models.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec partner_model_tuning_spec = 21;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpecOrBuilder
      getPartnerModelTuningSpecOrBuilder() {
    if (tuningSpecCase_ == 21) {
      return (com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec) tuningSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Identifier. Resource name of a TuningJob. Format:
   * `projects/{project}/locations/{location}/tuningJobs/{tuning_job}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Identifier. Resource name of a TuningJob. Format:
   * `projects/{project}/locations/{location}/tuningJobs/{tuning_job}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TUNED_MODEL_DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tunedModelDisplayName_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The display name of the
   * [TunedModel][google.cloud.aiplatform.v1.Model]. The name can be up to 128
   * characters long and can consist of any UTF-8 characters.
   * </pre>
   *
   * <code>string tuned_model_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The tunedModelDisplayName.
   */
  @java.lang.Override
  public java.lang.String getTunedModelDisplayName() {
    java.lang.Object ref = tunedModelDisplayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tunedModelDisplayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The display name of the
   * [TunedModel][google.cloud.aiplatform.v1.Model]. The name can be up to 128
   * characters long and can consist of any UTF-8 characters.
   * </pre>
   *
   * <code>string tuned_model_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for tunedModelDisplayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTunedModelDisplayNameBytes() {
    java.lang.Object ref = tunedModelDisplayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tunedModelDisplayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The description of the
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The description of the
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 6;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The detailed state of the job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.JobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The detailed state of the job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.JobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.JobState getState() {
    com.google.cloud.aiplatform.v1beta1.JobState result =
        com.google.cloud.aiplatform.v1beta1.JobState.forNumber(state_);
    return result == null ? com.google.cloud.aiplatform.v1beta1.JobState.UNRECOGNIZED : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int START_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob] for the first time
   * entered the `JOB_STATE_RUNNING` state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob] for the first time
   * entered the `JOB_STATE_RUNNING` state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob] for the first time
   * entered the `JOB_STATE_RUNNING` state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the TuningJob entered any of the following
   * [JobStates][google.cloud.aiplatform.v1.JobState]: `JOB_STATE_SUCCEEDED`,
   * `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`, `JOB_STATE_EXPIRED`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the TuningJob entered any of the following
   * [JobStates][google.cloud.aiplatform.v1.JobState]: `JOB_STATE_SUCCEEDED`,
   * `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`, `JOB_STATE_EXPIRED`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the TuningJob entered any of the following
   * [JobStates][google.cloud.aiplatform.v1.JobState]: `JOB_STATE_SUCCEEDED`,
   * `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`, `JOB_STATE_EXPIRED`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob] was most recently
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob] was most recently
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob] was most recently
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int ERROR_FIELD_NUMBER = 11;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * Output only. Only populated when job's state is `JOB_STATE_FAILED` or
   * `JOB_STATE_CANCELLED`.
   * </pre>
   *
   * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Only populated when job's state is `JOB_STATE_FAILED` or
   * `JOB_STATE_CANCELLED`.
   * </pre>
   *
   * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Only populated when job's state is `JOB_STATE_FAILED` or
   * `JOB_STATE_CANCELLED`.
   * </pre>
   *
   * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }

  public static final int LABELS_FIELD_NUMBER = 12;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1beta1.TuningJobProto
                .internal_static_google_cloud_aiplatform_v1beta1_TuningJob_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob] and generated resources
   * such as [Model][google.cloud.aiplatform.v1.Model] and
   * [Endpoint][google.cloud.aiplatform.v1.Endpoint].
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob] and generated resources
   * such as [Model][google.cloud.aiplatform.v1.Model] and
   * [Endpoint][google.cloud.aiplatform.v1.Endpoint].
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob] and generated resources
   * such as [Model][google.cloud.aiplatform.v1.Model] and
   * [Endpoint][google.cloud.aiplatform.v1.Endpoint].
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob] and generated resources
   * such as [Model][google.cloud.aiplatform.v1.Model] and
   * [Endpoint][google.cloud.aiplatform.v1.Endpoint].
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int EXPERIMENT_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object experiment_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The Experiment associated with this
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
   * </pre>
   *
   * <code>
   * string experiment = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The experiment.
   */
  @java.lang.Override
  public java.lang.String getExperiment() {
    java.lang.Object ref = experiment_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      experiment_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The Experiment associated with this
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
   * </pre>
   *
   * <code>
   * string experiment = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for experiment.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExperimentBytes() {
    java.lang.Object ref = experiment_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      experiment_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TUNED_MODEL_FIELD_NUMBER = 14;
  private com.google.cloud.aiplatform.v1beta1.TunedModel tunedModel_;
  /**
   *
   *
   * <pre>
   * Output only. The tuned model resources assiociated with this
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.TunedModel tuned_model = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the tunedModel field is set.
   */
  @java.lang.Override
  public boolean hasTunedModel() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The tuned model resources assiociated with this
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.TunedModel tuned_model = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The tunedModel.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.TunedModel getTunedModel() {
    return tunedModel_ == null
        ? com.google.cloud.aiplatform.v1beta1.TunedModel.getDefaultInstance()
        : tunedModel_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The tuned model resources assiociated with this
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.TunedModel tuned_model = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.TunedModelOrBuilder getTunedModelOrBuilder() {
    return tunedModel_ == null
        ? com.google.cloud.aiplatform.v1beta1.TunedModel.getDefaultInstance()
        : tunedModel_;
  }

  public static final int TUNING_DATA_STATS_FIELD_NUMBER = 15;
  private com.google.cloud.aiplatform.v1beta1.TuningDataStats tuningDataStats_;
  /**
   *
   *
   * <pre>
   * Output only. The tuning data statistics associated with this
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.TuningDataStats tuning_data_stats = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the tuningDataStats field is set.
   */
  @java.lang.Override
  public boolean hasTuningDataStats() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The tuning data statistics associated with this
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.TuningDataStats tuning_data_stats = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The tuningDataStats.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.TuningDataStats getTuningDataStats() {
    return tuningDataStats_ == null
        ? com.google.cloud.aiplatform.v1beta1.TuningDataStats.getDefaultInstance()
        : tuningDataStats_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The tuning data statistics associated with this
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.TuningDataStats tuning_data_stats = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.TuningDataStatsOrBuilder
      getTuningDataStatsOrBuilder() {
    return tuningDataStats_ == null
        ? com.google.cloud.aiplatform.v1beta1.TuningDataStats.getDefaultInstance()
        : tuningDataStats_;
  }

  public static final int PIPELINE_JOB_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pipelineJob_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the PipelineJob associated with the
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob]. Format:
   * `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`.
   * </pre>
   *
   * <code>
   * string pipeline_job = 18 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The pipelineJob.
   */
  @java.lang.Override
  public java.lang.String getPipelineJob() {
    java.lang.Object ref = pipelineJob_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pipelineJob_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the PipelineJob associated with the
   * [TuningJob][google.cloud.aiplatform.v1.TuningJob]. Format:
   * `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`.
   * </pre>
   *
   * <code>
   * string pipeline_job = 18 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for pipelineJob.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPipelineJobBytes() {
    java.lang.Object ref = pipelineJob_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pipelineJob_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENCRYPTION_SPEC_FIELD_NUMBER = 16;
  private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key options for a TuningJob. If this is set,
   * then all resources created by the TuningJob will be encrypted with the
   * provided encryption key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 16;</code>
   *
   * @return Whether the encryptionSpec field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionSpec() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key options for a TuningJob. If this is set,
   * then all resources created by the TuningJob will be encrypted with the
   * provided encryption key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 16;</code>
   *
   * @return The encryptionSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key options for a TuningJob. If this is set,
   * then all resources created by the TuningJob will be encrypted with the
   * provided encryption key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 16;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 22;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * The service account that the tuningJob workload runs as.
   * If not specified, the Vertex AI Secure Fine-Tuned Service Agent in the
   * project will be used. See
   * https://cloud.google.com/iam/docs/service-agents#vertex-ai-secure-fine-tuning-service-agent
   *
   * Users starting the pipeline must have the `iam.serviceAccounts.actAs`
   * permission on this service account.
   * </pre>
   *
   * <code>string service_account = 22;</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The service account that the tuningJob workload runs as.
   * If not specified, the Vertex AI Secure Fine-Tuned Service Agent in the
   * project will be used. See
   * https://cloud.google.com/iam/docs/service-agents#vertex-ai-secure-fine-tuning-service-agent
   *
   * Users starting the pipeline must have the `iam.serviceAccounts.actAs`
   * permission on this service account.
   * </pre>
   *
   * <code>string service_account = 22;</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tunedModelDisplayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, tunedModelDisplayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (sourceModelCase_ == 4) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, sourceModel_);
    }
    if (tuningSpecCase_ == 5) {
      output.writeMessage(
          5, (com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec) tuningSpec_);
    }
    if (state_ != com.google.cloud.aiplatform.v1beta1.JobState.JOB_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(6, state_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getStartTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(9, getEndTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(10, getUpdateTime());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(11, getError());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 12);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(experiment_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, experiment_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(14, getTunedModel());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(15, getTuningDataStats());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(16, getEncryptionSpec());
    }
    if (tuningSpecCase_ == 17) {
      output.writeMessage(17, (com.google.cloud.aiplatform.v1beta1.DistillationSpec) tuningSpec_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pipelineJob_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, pipelineJob_);
    }
    if (tuningSpecCase_ == 21) {
      output.writeMessage(
          21, (com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec) tuningSpec_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 22, serviceAccount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tunedModelDisplayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, tunedModelDisplayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (sourceModelCase_ == 4) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, sourceModel_);
    }
    if (tuningSpecCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec) tuningSpec_);
    }
    if (state_ != com.google.cloud.aiplatform.v1beta1.JobState.JOB_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, state_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getStartTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getEndTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getUpdateTime());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getError());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(experiment_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, experiment_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getTunedModel());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getTuningDataStats());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getEncryptionSpec());
    }
    if (tuningSpecCase_ == 17) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17, (com.google.cloud.aiplatform.v1beta1.DistillationSpec) tuningSpec_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pipelineJob_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, pipelineJob_);
    }
    if (tuningSpecCase_ == 21) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              21, (com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec) tuningSpec_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(22, serviceAccount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.TuningJob)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.TuningJob other =
        (com.google.cloud.aiplatform.v1beta1.TuningJob) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getTunedModelDisplayName().equals(other.getTunedModelDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (state_ != other.state_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getExperiment().equals(other.getExperiment())) return false;
    if (hasTunedModel() != other.hasTunedModel()) return false;
    if (hasTunedModel()) {
      if (!getTunedModel().equals(other.getTunedModel())) return false;
    }
    if (hasTuningDataStats() != other.hasTuningDataStats()) return false;
    if (hasTuningDataStats()) {
      if (!getTuningDataStats().equals(other.getTuningDataStats())) return false;
    }
    if (!getPipelineJob().equals(other.getPipelineJob())) return false;
    if (hasEncryptionSpec() != other.hasEncryptionSpec()) return false;
    if (hasEncryptionSpec()) {
      if (!getEncryptionSpec().equals(other.getEncryptionSpec())) return false;
    }
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (!getSourceModelCase().equals(other.getSourceModelCase())) return false;
    switch (sourceModelCase_) {
      case 4:
        if (!getBaseModel().equals(other.getBaseModel())) return false;
        break;
      case 0:
      default:
    }
    if (!getTuningSpecCase().equals(other.getTuningSpecCase())) return false;
    switch (tuningSpecCase_) {
      case 5:
        if (!getSupervisedTuningSpec().equals(other.getSupervisedTuningSpec())) return false;
        break;
      case 17:
        if (!getDistillationSpec().equals(other.getDistillationSpec())) return false;
        break;
      case 21:
        if (!getPartnerModelTuningSpec().equals(other.getPartnerModelTuningSpec())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TUNED_MODEL_DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getTunedModelDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + EXPERIMENT_FIELD_NUMBER;
    hash = (53 * hash) + getExperiment().hashCode();
    if (hasTunedModel()) {
      hash = (37 * hash) + TUNED_MODEL_FIELD_NUMBER;
      hash = (53 * hash) + getTunedModel().hashCode();
    }
    if (hasTuningDataStats()) {
      hash = (37 * hash) + TUNING_DATA_STATS_FIELD_NUMBER;
      hash = (53 * hash) + getTuningDataStats().hashCode();
    }
    hash = (37 * hash) + PIPELINE_JOB_FIELD_NUMBER;
    hash = (53 * hash) + getPipelineJob().hashCode();
    if (hasEncryptionSpec()) {
      hash = (37 * hash) + ENCRYPTION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionSpec().hashCode();
    }
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    switch (sourceModelCase_) {
      case 4:
        hash = (37 * hash) + BASE_MODEL_FIELD_NUMBER;
        hash = (53 * hash) + getBaseModel().hashCode();
        break;
      case 0:
      default:
    }
    switch (tuningSpecCase_) {
      case 5:
        hash = (37 * hash) + SUPERVISED_TUNING_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getSupervisedTuningSpec().hashCode();
        break;
      case 17:
        hash = (37 * hash) + DISTILLATION_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getDistillationSpec().hashCode();
        break;
      case 21:
        hash = (37 * hash) + PARTNER_MODEL_TUNING_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getPartnerModelTuningSpec().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.TuningJob parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.TuningJob parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.TuningJob parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.TuningJob parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.TuningJob parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.TuningJob parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.TuningJob parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.TuningJob parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.TuningJob parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.TuningJob parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.TuningJob parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.TuningJob parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.TuningJob prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a TuningJob that runs with Google owned models.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.TuningJob}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.TuningJob)
      com.google.cloud.aiplatform.v1beta1.TuningJobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.TuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_TuningJob_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 12:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 12:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.TuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_TuningJob_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.TuningJob.class,
              com.google.cloud.aiplatform.v1beta1.TuningJob.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.TuningJob.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getStartTimeFieldBuilder();
        getEndTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getErrorFieldBuilder();
        getTunedModelFieldBuilder();
        getTuningDataStatsFieldBuilder();
        getEncryptionSpecFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (supervisedTuningSpecBuilder_ != null) {
        supervisedTuningSpecBuilder_.clear();
      }
      if (distillationSpecBuilder_ != null) {
        distillationSpecBuilder_.clear();
      }
      if (partnerModelTuningSpecBuilder_ != null) {
        partnerModelTuningSpecBuilder_.clear();
      }
      name_ = "";
      tunedModelDisplayName_ = "";
      description_ = "";
      state_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      experiment_ = "";
      tunedModel_ = null;
      if (tunedModelBuilder_ != null) {
        tunedModelBuilder_.dispose();
        tunedModelBuilder_ = null;
      }
      tuningDataStats_ = null;
      if (tuningDataStatsBuilder_ != null) {
        tuningDataStatsBuilder_.dispose();
        tuningDataStatsBuilder_ = null;
      }
      pipelineJob_ = "";
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      serviceAccount_ = "";
      sourceModelCase_ = 0;
      sourceModel_ = null;
      tuningSpecCase_ = 0;
      tuningSpec_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.TuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_TuningJob_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.TuningJob getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.TuningJob.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.TuningJob build() {
      com.google.cloud.aiplatform.v1beta1.TuningJob result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.TuningJob buildPartial() {
      com.google.cloud.aiplatform.v1beta1.TuningJob result =
          new com.google.cloud.aiplatform.v1beta1.TuningJob(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.TuningJob result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.tunedModelDisplayName_ = tunedModelDisplayName_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.state_ = state_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.error_ = errorBuilder_ == null ? error_ : errorBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.experiment_ = experiment_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.tunedModel_ = tunedModelBuilder_ == null ? tunedModel_ : tunedModelBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.tuningDataStats_ =
            tuningDataStatsBuilder_ == null ? tuningDataStats_ : tuningDataStatsBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.pipelineJob_ = pipelineJob_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.encryptionSpec_ =
            encryptionSpecBuilder_ == null ? encryptionSpec_ : encryptionSpecBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1beta1.TuningJob result) {
      result.sourceModelCase_ = sourceModelCase_;
      result.sourceModel_ = this.sourceModel_;
      result.tuningSpecCase_ = tuningSpecCase_;
      result.tuningSpec_ = this.tuningSpec_;
      if (tuningSpecCase_ == 5 && supervisedTuningSpecBuilder_ != null) {
        result.tuningSpec_ = supervisedTuningSpecBuilder_.build();
      }
      if (tuningSpecCase_ == 17 && distillationSpecBuilder_ != null) {
        result.tuningSpec_ = distillationSpecBuilder_.build();
      }
      if (tuningSpecCase_ == 21 && partnerModelTuningSpecBuilder_ != null) {
        result.tuningSpec_ = partnerModelTuningSpecBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.TuningJob) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.TuningJob) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.TuningJob other) {
      if (other == com.google.cloud.aiplatform.v1beta1.TuningJob.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getTunedModelDisplayName().isEmpty()) {
        tunedModelDisplayName_ = other.tunedModelDisplayName_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00002000;
      if (!other.getExperiment().isEmpty()) {
        experiment_ = other.experiment_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.hasTunedModel()) {
        mergeTunedModel(other.getTunedModel());
      }
      if (other.hasTuningDataStats()) {
        mergeTuningDataStats(other.getTuningDataStats());
      }
      if (!other.getPipelineJob().isEmpty()) {
        pipelineJob_ = other.pipelineJob_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (other.hasEncryptionSpec()) {
        mergeEncryptionSpec(other.getEncryptionSpec());
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00080000;
        onChanged();
      }
      switch (other.getSourceModelCase()) {
        case BASE_MODEL:
          {
            sourceModelCase_ = 4;
            sourceModel_ = other.sourceModel_;
            onChanged();
            break;
          }
        case SOURCEMODEL_NOT_SET:
          {
            break;
          }
      }
      switch (other.getTuningSpecCase()) {
        case SUPERVISED_TUNING_SPEC:
          {
            mergeSupervisedTuningSpec(other.getSupervisedTuningSpec());
            break;
          }
        case DISTILLATION_SPEC:
          {
            mergeDistillationSpec(other.getDistillationSpec());
            break;
          }
        case PARTNER_MODEL_TUNING_SPEC:
          {
            mergePartnerModelTuningSpec(other.getPartnerModelTuningSpec());
            break;
          }
        case TUNINGSPEC_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 10
            case 18:
              {
                tunedModelDisplayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                sourceModelCase_ = 4;
                sourceModel_ = s;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getSupervisedTuningSpecFieldBuilder().getBuilder(), extensionRegistry);
                tuningSpecCase_ = 5;
                break;
              } // case 42
            case 48:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 48
            case 58:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 90
            case 98:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00002000;
                break;
              } // case 98
            case 106:
              {
                experiment_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getTunedModelFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(getTuningDataStatsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 122
            case 130:
              {
                input.readMessage(getEncryptionSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(
                    getDistillationSpecFieldBuilder().getBuilder(), extensionRegistry);
                tuningSpecCase_ = 17;
                break;
              } // case 138
            case 146:
              {
                pipelineJob_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case 146
            case 170:
              {
                input.readMessage(
                    getPartnerModelTuningSpecFieldBuilder().getBuilder(), extensionRegistry);
                tuningSpecCase_ = 21;
                break;
              } // case 170
            case 178:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00080000;
                break;
              } // case 178
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceModelCase_ = 0;
    private java.lang.Object sourceModel_;

    public SourceModelCase getSourceModelCase() {
      return SourceModelCase.forNumber(sourceModelCase_);
    }

    public Builder clearSourceModel() {
      sourceModelCase_ = 0;
      sourceModel_ = null;
      onChanged();
      return this;
    }

    private int tuningSpecCase_ = 0;
    private java.lang.Object tuningSpec_;

    public TuningSpecCase getTuningSpecCase() {
      return TuningSpecCase.forNumber(tuningSpecCase_);
    }

    public Builder clearTuningSpec() {
      tuningSpecCase_ = 0;
      tuningSpec_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * The base model that is being tuned, e.g., "gemini-1.0-pro-002".
     * </pre>
     *
     * <code>string base_model = 4;</code>
     *
     * @return Whether the baseModel field is set.
     */
    @java.lang.Override
    public boolean hasBaseModel() {
      return sourceModelCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * The base model that is being tuned, e.g., "gemini-1.0-pro-002".
     * </pre>
     *
     * <code>string base_model = 4;</code>
     *
     * @return The baseModel.
     */
    @java.lang.Override
    public java.lang.String getBaseModel() {
      java.lang.Object ref = "";
      if (sourceModelCase_ == 4) {
        ref = sourceModel_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (sourceModelCase_ == 4) {
          sourceModel_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The base model that is being tuned, e.g., "gemini-1.0-pro-002".
     * </pre>
     *
     * <code>string base_model = 4;</code>
     *
     * @return The bytes for baseModel.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBaseModelBytes() {
      java.lang.Object ref = "";
      if (sourceModelCase_ == 4) {
        ref = sourceModel_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (sourceModelCase_ == 4) {
          sourceModel_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The base model that is being tuned, e.g., "gemini-1.0-pro-002".
     * </pre>
     *
     * <code>string base_model = 4;</code>
     *
     * @param value The baseModel to set.
     * @return This builder for chaining.
     */
    public Builder setBaseModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceModelCase_ = 4;
      sourceModel_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The base model that is being tuned, e.g., "gemini-1.0-pro-002".
     * </pre>
     *
     * <code>string base_model = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBaseModel() {
      if (sourceModelCase_ == 4) {
        sourceModelCase_ = 0;
        sourceModel_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The base model that is being tuned, e.g., "gemini-1.0-pro-002".
     * </pre>
     *
     * <code>string base_model = 4;</code>
     *
     * @param value The bytes for baseModel to set.
     * @return This builder for chaining.
     */
    public Builder setBaseModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceModelCase_ = 4;
      sourceModel_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec,
            com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpecOrBuilder>
        supervisedTuningSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Tuning Spec for Supervised Fine Tuning.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec supervised_tuning_spec = 5;
     * </code>
     *
     * @return Whether the supervisedTuningSpec field is set.
     */
    @java.lang.Override
    public boolean hasSupervisedTuningSpec() {
      return tuningSpecCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Tuning Spec for Supervised Fine Tuning.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec supervised_tuning_spec = 5;
     * </code>
     *
     * @return The supervisedTuningSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec getSupervisedTuningSpec() {
      if (supervisedTuningSpecBuilder_ == null) {
        if (tuningSpecCase_ == 5) {
          return (com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec) tuningSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.getDefaultInstance();
      } else {
        if (tuningSpecCase_ == 5) {
          return supervisedTuningSpecBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Tuning Spec for Supervised Fine Tuning.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec supervised_tuning_spec = 5;
     * </code>
     */
    public Builder setSupervisedTuningSpec(
        com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec value) {
      if (supervisedTuningSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tuningSpec_ = value;
        onChanged();
      } else {
        supervisedTuningSpecBuilder_.setMessage(value);
      }
      tuningSpecCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tuning Spec for Supervised Fine Tuning.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec supervised_tuning_spec = 5;
     * </code>
     */
    public Builder setSupervisedTuningSpec(
        com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.Builder builderForValue) {
      if (supervisedTuningSpecBuilder_ == null) {
        tuningSpec_ = builderForValue.build();
        onChanged();
      } else {
        supervisedTuningSpecBuilder_.setMessage(builderForValue.build());
      }
      tuningSpecCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tuning Spec for Supervised Fine Tuning.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec supervised_tuning_spec = 5;
     * </code>
     */
    public Builder mergeSupervisedTuningSpec(
        com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec value) {
      if (supervisedTuningSpecBuilder_ == null) {
        if (tuningSpecCase_ == 5
            && tuningSpec_
                != com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.getDefaultInstance()) {
          tuningSpec_ =
              com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec) tuningSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          tuningSpec_ = value;
        }
        onChanged();
      } else {
        if (tuningSpecCase_ == 5) {
          supervisedTuningSpecBuilder_.mergeFrom(value);
        } else {
          supervisedTuningSpecBuilder_.setMessage(value);
        }
      }
      tuningSpecCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tuning Spec for Supervised Fine Tuning.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec supervised_tuning_spec = 5;
     * </code>
     */
    public Builder clearSupervisedTuningSpec() {
      if (supervisedTuningSpecBuilder_ == null) {
        if (tuningSpecCase_ == 5) {
          tuningSpecCase_ = 0;
          tuningSpec_ = null;
          onChanged();
        }
      } else {
        if (tuningSpecCase_ == 5) {
          tuningSpecCase_ = 0;
          tuningSpec_ = null;
        }
        supervisedTuningSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tuning Spec for Supervised Fine Tuning.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec supervised_tuning_spec = 5;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.Builder
        getSupervisedTuningSpecBuilder() {
      return getSupervisedTuningSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Tuning Spec for Supervised Fine Tuning.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec supervised_tuning_spec = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpecOrBuilder
        getSupervisedTuningSpecOrBuilder() {
      if ((tuningSpecCase_ == 5) && (supervisedTuningSpecBuilder_ != null)) {
        return supervisedTuningSpecBuilder_.getMessageOrBuilder();
      } else {
        if (tuningSpecCase_ == 5) {
          return (com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec) tuningSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Tuning Spec for Supervised Fine Tuning.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec supervised_tuning_spec = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec,
            com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpecOrBuilder>
        getSupervisedTuningSpecFieldBuilder() {
      if (supervisedTuningSpecBuilder_ == null) {
        if (!(tuningSpecCase_ == 5)) {
          tuningSpec_ =
              com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.getDefaultInstance();
        }
        supervisedTuningSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec,
                com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpecOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec) tuningSpec_,
                getParentForChildren(),
                isClean());
        tuningSpec_ = null;
      }
      tuningSpecCase_ = 5;
      onChanged();
      return supervisedTuningSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DistillationSpec,
            com.google.cloud.aiplatform.v1beta1.DistillationSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.DistillationSpecOrBuilder>
        distillationSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Tuning Spec for Distillation.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.DistillationSpec distillation_spec = 17;</code>
     *
     * @return Whether the distillationSpec field is set.
     */
    @java.lang.Override
    public boolean hasDistillationSpec() {
      return tuningSpecCase_ == 17;
    }
    /**
     *
     *
     * <pre>
     * Tuning Spec for Distillation.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.DistillationSpec distillation_spec = 17;</code>
     *
     * @return The distillationSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DistillationSpec getDistillationSpec() {
      if (distillationSpecBuilder_ == null) {
        if (tuningSpecCase_ == 17) {
          return (com.google.cloud.aiplatform.v1beta1.DistillationSpec) tuningSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.DistillationSpec.getDefaultInstance();
      } else {
        if (tuningSpecCase_ == 17) {
          return distillationSpecBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.DistillationSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Tuning Spec for Distillation.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.DistillationSpec distillation_spec = 17;</code>
     */
    public Builder setDistillationSpec(com.google.cloud.aiplatform.v1beta1.DistillationSpec value) {
      if (distillationSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tuningSpec_ = value;
        onChanged();
      } else {
        distillationSpecBuilder_.setMessage(value);
      }
      tuningSpecCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tuning Spec for Distillation.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.DistillationSpec distillation_spec = 17;</code>
     */
    public Builder setDistillationSpec(
        com.google.cloud.aiplatform.v1beta1.DistillationSpec.Builder builderForValue) {
      if (distillationSpecBuilder_ == null) {
        tuningSpec_ = builderForValue.build();
        onChanged();
      } else {
        distillationSpecBuilder_.setMessage(builderForValue.build());
      }
      tuningSpecCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tuning Spec for Distillation.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.DistillationSpec distillation_spec = 17;</code>
     */
    public Builder mergeDistillationSpec(
        com.google.cloud.aiplatform.v1beta1.DistillationSpec value) {
      if (distillationSpecBuilder_ == null) {
        if (tuningSpecCase_ == 17
            && tuningSpec_
                != com.google.cloud.aiplatform.v1beta1.DistillationSpec.getDefaultInstance()) {
          tuningSpec_ =
              com.google.cloud.aiplatform.v1beta1.DistillationSpec.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.DistillationSpec) tuningSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          tuningSpec_ = value;
        }
        onChanged();
      } else {
        if (tuningSpecCase_ == 17) {
          distillationSpecBuilder_.mergeFrom(value);
        } else {
          distillationSpecBuilder_.setMessage(value);
        }
      }
      tuningSpecCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tuning Spec for Distillation.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.DistillationSpec distillation_spec = 17;</code>
     */
    public Builder clearDistillationSpec() {
      if (distillationSpecBuilder_ == null) {
        if (tuningSpecCase_ == 17) {
          tuningSpecCase_ = 0;
          tuningSpec_ = null;
          onChanged();
        }
      } else {
        if (tuningSpecCase_ == 17) {
          tuningSpecCase_ = 0;
          tuningSpec_ = null;
        }
        distillationSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tuning Spec for Distillation.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.DistillationSpec distillation_spec = 17;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.DistillationSpec.Builder
        getDistillationSpecBuilder() {
      return getDistillationSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Tuning Spec for Distillation.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.DistillationSpec distillation_spec = 17;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DistillationSpecOrBuilder
        getDistillationSpecOrBuilder() {
      if ((tuningSpecCase_ == 17) && (distillationSpecBuilder_ != null)) {
        return distillationSpecBuilder_.getMessageOrBuilder();
      } else {
        if (tuningSpecCase_ == 17) {
          return (com.google.cloud.aiplatform.v1beta1.DistillationSpec) tuningSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.DistillationSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Tuning Spec for Distillation.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.DistillationSpec distillation_spec = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DistillationSpec,
            com.google.cloud.aiplatform.v1beta1.DistillationSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.DistillationSpecOrBuilder>
        getDistillationSpecFieldBuilder() {
      if (distillationSpecBuilder_ == null) {
        if (!(tuningSpecCase_ == 17)) {
          tuningSpec_ = com.google.cloud.aiplatform.v1beta1.DistillationSpec.getDefaultInstance();
        }
        distillationSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.DistillationSpec,
                com.google.cloud.aiplatform.v1beta1.DistillationSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.DistillationSpecOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.DistillationSpec) tuningSpec_,
                getParentForChildren(),
                isClean());
        tuningSpec_ = null;
      }
      tuningSpecCase_ = 17;
      onChanged();
      return distillationSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec,
            com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpecOrBuilder>
        partnerModelTuningSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Tuning Spec for open sourced and third party partner models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec partner_model_tuning_spec = 21;
     * </code>
     *
     * @return Whether the partnerModelTuningSpec field is set.
     */
    @java.lang.Override
    public boolean hasPartnerModelTuningSpec() {
      return tuningSpecCase_ == 21;
    }
    /**
     *
     *
     * <pre>
     * Tuning Spec for open sourced and third party partner models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec partner_model_tuning_spec = 21;
     * </code>
     *
     * @return The partnerModelTuningSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec getPartnerModelTuningSpec() {
      if (partnerModelTuningSpecBuilder_ == null) {
        if (tuningSpecCase_ == 21) {
          return (com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec) tuningSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec.getDefaultInstance();
      } else {
        if (tuningSpecCase_ == 21) {
          return partnerModelTuningSpecBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Tuning Spec for open sourced and third party partner models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec partner_model_tuning_spec = 21;
     * </code>
     */
    public Builder setPartnerModelTuningSpec(
        com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec value) {
      if (partnerModelTuningSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tuningSpec_ = value;
        onChanged();
      } else {
        partnerModelTuningSpecBuilder_.setMessage(value);
      }
      tuningSpecCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tuning Spec for open sourced and third party partner models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec partner_model_tuning_spec = 21;
     * </code>
     */
    public Builder setPartnerModelTuningSpec(
        com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec.Builder builderForValue) {
      if (partnerModelTuningSpecBuilder_ == null) {
        tuningSpec_ = builderForValue.build();
        onChanged();
      } else {
        partnerModelTuningSpecBuilder_.setMessage(builderForValue.build());
      }
      tuningSpecCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tuning Spec for open sourced and third party partner models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec partner_model_tuning_spec = 21;
     * </code>
     */
    public Builder mergePartnerModelTuningSpec(
        com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec value) {
      if (partnerModelTuningSpecBuilder_ == null) {
        if (tuningSpecCase_ == 21
            && tuningSpec_
                != com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec
                    .getDefaultInstance()) {
          tuningSpec_ =
              com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec) tuningSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          tuningSpec_ = value;
        }
        onChanged();
      } else {
        if (tuningSpecCase_ == 21) {
          partnerModelTuningSpecBuilder_.mergeFrom(value);
        } else {
          partnerModelTuningSpecBuilder_.setMessage(value);
        }
      }
      tuningSpecCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tuning Spec for open sourced and third party partner models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec partner_model_tuning_spec = 21;
     * </code>
     */
    public Builder clearPartnerModelTuningSpec() {
      if (partnerModelTuningSpecBuilder_ == null) {
        if (tuningSpecCase_ == 21) {
          tuningSpecCase_ = 0;
          tuningSpec_ = null;
          onChanged();
        }
      } else {
        if (tuningSpecCase_ == 21) {
          tuningSpecCase_ = 0;
          tuningSpec_ = null;
        }
        partnerModelTuningSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tuning Spec for open sourced and third party partner models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec partner_model_tuning_spec = 21;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec.Builder
        getPartnerModelTuningSpecBuilder() {
      return getPartnerModelTuningSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Tuning Spec for open sourced and third party partner models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec partner_model_tuning_spec = 21;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpecOrBuilder
        getPartnerModelTuningSpecOrBuilder() {
      if ((tuningSpecCase_ == 21) && (partnerModelTuningSpecBuilder_ != null)) {
        return partnerModelTuningSpecBuilder_.getMessageOrBuilder();
      } else {
        if (tuningSpecCase_ == 21) {
          return (com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec) tuningSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Tuning Spec for open sourced and third party partner models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec partner_model_tuning_spec = 21;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec,
            com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpecOrBuilder>
        getPartnerModelTuningSpecFieldBuilder() {
      if (partnerModelTuningSpecBuilder_ == null) {
        if (!(tuningSpecCase_ == 21)) {
          tuningSpec_ =
              com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec.getDefaultInstance();
        }
        partnerModelTuningSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec,
                com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpecOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec) tuningSpec_,
                getParentForChildren(),
                isClean());
        tuningSpec_ = null;
      }
      tuningSpecCase_ = 21;
      onChanged();
      return partnerModelTuningSpecBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Identifier. Resource name of a TuningJob. Format:
     * `projects/{project}/locations/{location}/tuningJobs/{tuning_job}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier. Resource name of a TuningJob. Format:
     * `projects/{project}/locations/{location}/tuningJobs/{tuning_job}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier. Resource name of a TuningJob. Format:
     * `projects/{project}/locations/{location}/tuningJobs/{tuning_job}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier. Resource name of a TuningJob. Format:
     * `projects/{project}/locations/{location}/tuningJobs/{tuning_job}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier. Resource name of a TuningJob. Format:
     * `projects/{project}/locations/{location}/tuningJobs/{tuning_job}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object tunedModelDisplayName_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The display name of the
     * [TunedModel][google.cloud.aiplatform.v1.Model]. The name can be up to 128
     * characters long and can consist of any UTF-8 characters.
     * </pre>
     *
     * <code>string tuned_model_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The tunedModelDisplayName.
     */
    public java.lang.String getTunedModelDisplayName() {
      java.lang.Object ref = tunedModelDisplayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tunedModelDisplayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The display name of the
     * [TunedModel][google.cloud.aiplatform.v1.Model]. The name can be up to 128
     * characters long and can consist of any UTF-8 characters.
     * </pre>
     *
     * <code>string tuned_model_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for tunedModelDisplayName.
     */
    public com.google.protobuf.ByteString getTunedModelDisplayNameBytes() {
      java.lang.Object ref = tunedModelDisplayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tunedModelDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The display name of the
     * [TunedModel][google.cloud.aiplatform.v1.Model]. The name can be up to 128
     * characters long and can consist of any UTF-8 characters.
     * </pre>
     *
     * <code>string tuned_model_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The tunedModelDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setTunedModelDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tunedModelDisplayName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The display name of the
     * [TunedModel][google.cloud.aiplatform.v1.Model]. The name can be up to 128
     * characters long and can consist of any UTF-8 characters.
     * </pre>
     *
     * <code>string tuned_model_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTunedModelDisplayName() {
      tunedModelDisplayName_ = getDefaultInstance().getTunedModelDisplayName();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The display name of the
     * [TunedModel][google.cloud.aiplatform.v1.Model]. The name can be up to 128
     * characters long and can consist of any UTF-8 characters.
     * </pre>
     *
     * <code>string tuned_model_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for tunedModelDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setTunedModelDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tunedModelDisplayName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The description of the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.JobState getState() {
      com.google.cloud.aiplatform.v1beta1.JobState result =
          com.google.cloud.aiplatform.v1beta1.JobState.forNumber(state_);
      return result == null ? com.google.cloud.aiplatform.v1beta1.JobState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.aiplatform.v1beta1.JobState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000080);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] for the first time
     * entered the `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] for the first time
     * entered the `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] for the first time
     * entered the `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] for the first time
     * entered the `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] for the first time
     * entered the `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] for the first time
     * entered the `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] for the first time
     * entered the `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] for the first time
     * entered the `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] for the first time
     * entered the `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the TuningJob entered any of the following
     * [JobStates][google.cloud.aiplatform.v1.JobState]: `JOB_STATE_SUCCEEDED`,
     * `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`, `JOB_STATE_EXPIRED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TuningJob entered any of the following
     * [JobStates][google.cloud.aiplatform.v1.JobState]: `JOB_STATE_SUCCEEDED`,
     * `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`, `JOB_STATE_EXPIRED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TuningJob entered any of the following
     * [JobStates][google.cloud.aiplatform.v1.JobState]: `JOB_STATE_SUCCEEDED`,
     * `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`, `JOB_STATE_EXPIRED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TuningJob entered any of the following
     * [JobStates][google.cloud.aiplatform.v1.JobState]: `JOB_STATE_SUCCEEDED`,
     * `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`, `JOB_STATE_EXPIRED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TuningJob entered any of the following
     * [JobStates][google.cloud.aiplatform.v1.JobState]: `JOB_STATE_SUCCEEDED`,
     * `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`, `JOB_STATE_EXPIRED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TuningJob entered any of the following
     * [JobStates][google.cloud.aiplatform.v1.JobState]: `JOB_STATE_SUCCEEDED`,
     * `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`, `JOB_STATE_EXPIRED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000400);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TuningJob entered any of the following
     * [JobStates][google.cloud.aiplatform.v1.JobState]: `JOB_STATE_SUCCEEDED`,
     * `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`, `JOB_STATE_EXPIRED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TuningJob entered any of the following
     * [JobStates][google.cloud.aiplatform.v1.JobState]: `JOB_STATE_SUCCEEDED`,
     * `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`, `JOB_STATE_EXPIRED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TuningJob entered any of the following
     * [JobStates][google.cloud.aiplatform.v1.JobState]: `JOB_STATE_SUCCEEDED`,
     * `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`, `JOB_STATE_EXPIRED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000800);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Only populated when job's state is `JOB_STATE_FAILED` or
     * `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when job's state is `JOB_STATE_FAILED` or
     * `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when job's state is `JOB_STATE_FAILED` or
     * `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
      } else {
        errorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when job's state is `JOB_STATE_FAILED` or
     * `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when job's state is `JOB_STATE_FAILED` or
     * `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && error_ != null
            && error_ != com.google.rpc.Status.getDefaultInstance()) {
          getErrorBuilder().mergeFrom(value);
        } else {
          error_ = value;
        }
      } else {
        errorBuilder_.mergeFrom(value);
      }
      if (error_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when job's state is `JOB_STATE_FAILED` or
     * `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearError() {
      bitField0_ = (bitField0_ & ~0x00001000);
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when job's state is `JOB_STATE_FAILED` or
     * `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when job's state is `JOB_STATE_FAILED` or
     * `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when job's state is `JOB_STATE_FAILED` or
     * `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] and generated resources
     * such as [Model][google.cloud.aiplatform.v1.Model] and
     * [Endpoint][google.cloud.aiplatform.v1.Endpoint].
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] and generated resources
     * such as [Model][google.cloud.aiplatform.v1.Model] and
     * [Endpoint][google.cloud.aiplatform.v1.Endpoint].
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] and generated resources
     * such as [Model][google.cloud.aiplatform.v1.Model] and
     * [Endpoint][google.cloud.aiplatform.v1.Endpoint].
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] and generated resources
     * such as [Model][google.cloud.aiplatform.v1.Model] and
     * [Endpoint][google.cloud.aiplatform.v1.Endpoint].
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00002000);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] and generated resources
     * such as [Model][google.cloud.aiplatform.v1.Model] and
     * [Endpoint][google.cloud.aiplatform.v1.Endpoint].
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00002000;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] and generated resources
     * such as [Model][google.cloud.aiplatform.v1.Model] and
     * [Endpoint][google.cloud.aiplatform.v1.Endpoint].
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00002000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob] and generated resources
     * such as [Model][google.cloud.aiplatform.v1.Model] and
     * [Endpoint][google.cloud.aiplatform.v1.Endpoint].
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00002000;
      return this;
    }

    private java.lang.Object experiment_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The Experiment associated with this
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>
     * string experiment = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The experiment.
     */
    public java.lang.String getExperiment() {
      java.lang.Object ref = experiment_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        experiment_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Experiment associated with this
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>
     * string experiment = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for experiment.
     */
    public com.google.protobuf.ByteString getExperimentBytes() {
      java.lang.Object ref = experiment_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        experiment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Experiment associated with this
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>
     * string experiment = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The experiment to set.
     * @return This builder for chaining.
     */
    public Builder setExperiment(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      experiment_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Experiment associated with this
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>
     * string experiment = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExperiment() {
      experiment_ = getDefaultInstance().getExperiment();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Experiment associated with this
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>
     * string experiment = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for experiment to set.
     * @return This builder for chaining.
     */
    public Builder setExperimentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      experiment_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.TunedModel tunedModel_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.TunedModel,
            com.google.cloud.aiplatform.v1beta1.TunedModel.Builder,
            com.google.cloud.aiplatform.v1beta1.TunedModelOrBuilder>
        tunedModelBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The tuned model resources assiociated with this
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.TunedModel tuned_model = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the tunedModel field is set.
     */
    public boolean hasTunedModel() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The tuned model resources assiociated with this
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.TunedModel tuned_model = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The tunedModel.
     */
    public com.google.cloud.aiplatform.v1beta1.TunedModel getTunedModel() {
      if (tunedModelBuilder_ == null) {
        return tunedModel_ == null
            ? com.google.cloud.aiplatform.v1beta1.TunedModel.getDefaultInstance()
            : tunedModel_;
      } else {
        return tunedModelBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The tuned model resources assiociated with this
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.TunedModel tuned_model = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTunedModel(com.google.cloud.aiplatform.v1beta1.TunedModel value) {
      if (tunedModelBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tunedModel_ = value;
      } else {
        tunedModelBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The tuned model resources assiociated with this
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.TunedModel tuned_model = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTunedModel(
        com.google.cloud.aiplatform.v1beta1.TunedModel.Builder builderForValue) {
      if (tunedModelBuilder_ == null) {
        tunedModel_ = builderForValue.build();
      } else {
        tunedModelBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The tuned model resources assiociated with this
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.TunedModel tuned_model = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeTunedModel(com.google.cloud.aiplatform.v1beta1.TunedModel value) {
      if (tunedModelBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && tunedModel_ != null
            && tunedModel_ != com.google.cloud.aiplatform.v1beta1.TunedModel.getDefaultInstance()) {
          getTunedModelBuilder().mergeFrom(value);
        } else {
          tunedModel_ = value;
        }
      } else {
        tunedModelBuilder_.mergeFrom(value);
      }
      if (tunedModel_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The tuned model resources assiociated with this
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.TunedModel tuned_model = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTunedModel() {
      bitField0_ = (bitField0_ & ~0x00008000);
      tunedModel_ = null;
      if (tunedModelBuilder_ != null) {
        tunedModelBuilder_.dispose();
        tunedModelBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The tuned model resources assiociated with this
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.TunedModel tuned_model = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.TunedModel.Builder getTunedModelBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getTunedModelFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The tuned model resources assiociated with this
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.TunedModel tuned_model = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.TunedModelOrBuilder getTunedModelOrBuilder() {
      if (tunedModelBuilder_ != null) {
        return tunedModelBuilder_.getMessageOrBuilder();
      } else {
        return tunedModel_ == null
            ? com.google.cloud.aiplatform.v1beta1.TunedModel.getDefaultInstance()
            : tunedModel_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The tuned model resources assiociated with this
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.TunedModel tuned_model = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.TunedModel,
            com.google.cloud.aiplatform.v1beta1.TunedModel.Builder,
            com.google.cloud.aiplatform.v1beta1.TunedModelOrBuilder>
        getTunedModelFieldBuilder() {
      if (tunedModelBuilder_ == null) {
        tunedModelBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.TunedModel,
                com.google.cloud.aiplatform.v1beta1.TunedModel.Builder,
                com.google.cloud.aiplatform.v1beta1.TunedModelOrBuilder>(
                getTunedModel(), getParentForChildren(), isClean());
        tunedModel_ = null;
      }
      return tunedModelBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.TuningDataStats tuningDataStats_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.TuningDataStats,
            com.google.cloud.aiplatform.v1beta1.TuningDataStats.Builder,
            com.google.cloud.aiplatform.v1beta1.TuningDataStatsOrBuilder>
        tuningDataStatsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The tuning data statistics associated with this
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.TuningDataStats tuning_data_stats = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the tuningDataStats field is set.
     */
    public boolean hasTuningDataStats() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The tuning data statistics associated with this
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.TuningDataStats tuning_data_stats = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The tuningDataStats.
     */
    public com.google.cloud.aiplatform.v1beta1.TuningDataStats getTuningDataStats() {
      if (tuningDataStatsBuilder_ == null) {
        return tuningDataStats_ == null
            ? com.google.cloud.aiplatform.v1beta1.TuningDataStats.getDefaultInstance()
            : tuningDataStats_;
      } else {
        return tuningDataStatsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The tuning data statistics associated with this
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.TuningDataStats tuning_data_stats = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTuningDataStats(com.google.cloud.aiplatform.v1beta1.TuningDataStats value) {
      if (tuningDataStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tuningDataStats_ = value;
      } else {
        tuningDataStatsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The tuning data statistics associated with this
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.TuningDataStats tuning_data_stats = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTuningDataStats(
        com.google.cloud.aiplatform.v1beta1.TuningDataStats.Builder builderForValue) {
      if (tuningDataStatsBuilder_ == null) {
        tuningDataStats_ = builderForValue.build();
      } else {
        tuningDataStatsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The tuning data statistics associated with this
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.TuningDataStats tuning_data_stats = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeTuningDataStats(com.google.cloud.aiplatform.v1beta1.TuningDataStats value) {
      if (tuningDataStatsBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && tuningDataStats_ != null
            && tuningDataStats_
                != com.google.cloud.aiplatform.v1beta1.TuningDataStats.getDefaultInstance()) {
          getTuningDataStatsBuilder().mergeFrom(value);
        } else {
          tuningDataStats_ = value;
        }
      } else {
        tuningDataStatsBuilder_.mergeFrom(value);
      }
      if (tuningDataStats_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The tuning data statistics associated with this
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.TuningDataStats tuning_data_stats = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTuningDataStats() {
      bitField0_ = (bitField0_ & ~0x00010000);
      tuningDataStats_ = null;
      if (tuningDataStatsBuilder_ != null) {
        tuningDataStatsBuilder_.dispose();
        tuningDataStatsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The tuning data statistics associated with this
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.TuningDataStats tuning_data_stats = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.TuningDataStats.Builder getTuningDataStatsBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getTuningDataStatsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The tuning data statistics associated with this
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.TuningDataStats tuning_data_stats = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.TuningDataStatsOrBuilder
        getTuningDataStatsOrBuilder() {
      if (tuningDataStatsBuilder_ != null) {
        return tuningDataStatsBuilder_.getMessageOrBuilder();
      } else {
        return tuningDataStats_ == null
            ? com.google.cloud.aiplatform.v1beta1.TuningDataStats.getDefaultInstance()
            : tuningDataStats_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The tuning data statistics associated with this
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.TuningDataStats tuning_data_stats = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.TuningDataStats,
            com.google.cloud.aiplatform.v1beta1.TuningDataStats.Builder,
            com.google.cloud.aiplatform.v1beta1.TuningDataStatsOrBuilder>
        getTuningDataStatsFieldBuilder() {
      if (tuningDataStatsBuilder_ == null) {
        tuningDataStatsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.TuningDataStats,
                com.google.cloud.aiplatform.v1beta1.TuningDataStats.Builder,
                com.google.cloud.aiplatform.v1beta1.TuningDataStatsOrBuilder>(
                getTuningDataStats(), getParentForChildren(), isClean());
        tuningDataStats_ = null;
      }
      return tuningDataStatsBuilder_;
    }

    private java.lang.Object pipelineJob_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PipelineJob associated with the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob]. Format:
     * `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`.
     * </pre>
     *
     * <code>
     * string pipeline_job = 18 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The pipelineJob.
     */
    public java.lang.String getPipelineJob() {
      java.lang.Object ref = pipelineJob_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pipelineJob_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PipelineJob associated with the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob]. Format:
     * `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`.
     * </pre>
     *
     * <code>
     * string pipeline_job = 18 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for pipelineJob.
     */
    public com.google.protobuf.ByteString getPipelineJobBytes() {
      java.lang.Object ref = pipelineJob_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pipelineJob_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PipelineJob associated with the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob]. Format:
     * `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`.
     * </pre>
     *
     * <code>
     * string pipeline_job = 18 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The pipelineJob to set.
     * @return This builder for chaining.
     */
    public Builder setPipelineJob(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pipelineJob_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PipelineJob associated with the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob]. Format:
     * `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`.
     * </pre>
     *
     * <code>
     * string pipeline_job = 18 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPipelineJob() {
      pipelineJob_ = getDefaultInstance().getPipelineJob();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PipelineJob associated with the
     * [TuningJob][google.cloud.aiplatform.v1.TuningJob]. Format:
     * `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`.
     * </pre>
     *
     * <code>
     * string pipeline_job = 18 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for pipelineJob to set.
     * @return This builder for chaining.
     */
    public Builder setPipelineJobBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pipelineJob_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        encryptionSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a TuningJob. If this is set,
     * then all resources created by the TuningJob will be encrypted with the
     * provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 16;</code>
     *
     * @return Whether the encryptionSpec field is set.
     */
    public boolean hasEncryptionSpec() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a TuningJob. If this is set,
     * then all resources created by the TuningJob will be encrypted with the
     * provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 16;</code>
     *
     * @return The encryptionSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      } else {
        return encryptionSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a TuningJob. If this is set,
     * then all resources created by the TuningJob will be encrypted with the
     * provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 16;</code>
     */
    public Builder setEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionSpec_ = value;
      } else {
        encryptionSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a TuningJob. If this is set,
     * then all resources created by the TuningJob will be encrypted with the
     * provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 16;</code>
     */
    public Builder setEncryptionSpec(
        com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder builderForValue) {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = builderForValue.build();
      } else {
        encryptionSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a TuningJob. If this is set,
     * then all resources created by the TuningJob will be encrypted with the
     * provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 16;</code>
     */
    public Builder mergeEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && encryptionSpec_ != null
            && encryptionSpec_
                != com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()) {
          getEncryptionSpecBuilder().mergeFrom(value);
        } else {
          encryptionSpec_ = value;
        }
      } else {
        encryptionSpecBuilder_.mergeFrom(value);
      }
      if (encryptionSpec_ != null) {
        bitField0_ |= 0x00040000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a TuningJob. If this is set,
     * then all resources created by the TuningJob will be encrypted with the
     * provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 16;</code>
     */
    public Builder clearEncryptionSpec() {
      bitField0_ = (bitField0_ & ~0x00040000);
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a TuningJob. If this is set,
     * then all resources created by the TuningJob will be encrypted with the
     * provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 16;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder getEncryptionSpecBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getEncryptionSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a TuningJob. If this is set,
     * then all resources created by the TuningJob will be encrypted with the
     * provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 16;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder
        getEncryptionSpecOrBuilder() {
      if (encryptionSpecBuilder_ != null) {
        return encryptionSpecBuilder_.getMessageOrBuilder();
      } else {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a TuningJob. If this is set,
     * then all resources created by the TuningJob will be encrypted with the
     * provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 16;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        getEncryptionSpecFieldBuilder() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>(
                getEncryptionSpec(), getParentForChildren(), isClean());
        encryptionSpec_ = null;
      }
      return encryptionSpecBuilder_;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * The service account that the tuningJob workload runs as.
     * If not specified, the Vertex AI Secure Fine-Tuned Service Agent in the
     * project will be used. See
     * https://cloud.google.com/iam/docs/service-agents#vertex-ai-secure-fine-tuning-service-agent
     *
     * Users starting the pipeline must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 22;</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The service account that the tuningJob workload runs as.
     * If not specified, the Vertex AI Secure Fine-Tuned Service Agent in the
     * project will be used. See
     * https://cloud.google.com/iam/docs/service-agents#vertex-ai-secure-fine-tuning-service-agent
     *
     * Users starting the pipeline must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 22;</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The service account that the tuningJob workload runs as.
     * If not specified, the Vertex AI Secure Fine-Tuned Service Agent in the
     * project will be used. See
     * https://cloud.google.com/iam/docs/service-agents#vertex-ai-secure-fine-tuning-service-agent
     *
     * Users starting the pipeline must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 22;</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service account that the tuningJob workload runs as.
     * If not specified, the Vertex AI Secure Fine-Tuned Service Agent in the
     * project will be used. See
     * https://cloud.google.com/iam/docs/service-agents#vertex-ai-secure-fine-tuning-service-agent
     *
     * Users starting the pipeline must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 22;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00080000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service account that the tuningJob workload runs as.
     * If not specified, the Vertex AI Secure Fine-Tuned Service Agent in the
     * project will be used. See
     * https://cloud.google.com/iam/docs/service-agents#vertex-ai-secure-fine-tuning-service-agent
     *
     * Users starting the pipeline must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 22;</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.TuningJob)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.TuningJob)
  private static final com.google.cloud.aiplatform.v1beta1.TuningJob DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.TuningJob();
  }

  public static com.google.cloud.aiplatform.v1beta1.TuningJob getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TuningJob> PARSER =
      new com.google.protobuf.AbstractParser<TuningJob>() {
        @java.lang.Override
        public TuningJob parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TuningJob> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TuningJob> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.TuningJob getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
