/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/io.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * The Google Drive location for the input content.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.GoogleDriveSource}
 */
public final class GoogleDriveSource extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.GoogleDriveSource)
    GoogleDriveSourceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GoogleDriveSource.newBuilder() to construct.
  private GoogleDriveSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GoogleDriveSource() {
    resourceIds_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GoogleDriveSource();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.IoProto
        .internal_static_google_cloud_aiplatform_v1beta1_GoogleDriveSource_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.IoProto
        .internal_static_google_cloud_aiplatform_v1beta1_GoogleDriveSource_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.class,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder.class);
  }

  public interface ResourceIdOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The type of the Google Drive resource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType resource_type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for resourceType.
     */
    int getResourceTypeValue();
    /**
     *
     *
     * <pre>
     * Required. The type of the Google Drive resource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType resource_type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The resourceType.
     */
    com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType getResourceType();

    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Drive resource.
     * </pre>
     *
     * <code>string resource_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The resourceId.
     */
    java.lang.String getResourceId();
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Drive resource.
     * </pre>
     *
     * <code>string resource_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for resourceId.
     */
    com.google.protobuf.ByteString getResourceIdBytes();
  }
  /**
   *
   *
   * <pre>
   * The type and ID of the Google Drive resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId}
   */
  public static final class ResourceId extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId)
      ResourceIdOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ResourceId.newBuilder() to construct.
    private ResourceId(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ResourceId() {
      resourceType_ = 0;
      resourceId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ResourceId();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.IoProto
          .internal_static_google_cloud_aiplatform_v1beta1_GoogleDriveSource_ResourceId_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.IoProto
          .internal_static_google_cloud_aiplatform_v1beta1_GoogleDriveSource_ResourceId_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.class,
              com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The type of the Google Drive resource.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType}
     */
    public enum ResourceType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified resource type.
       * </pre>
       *
       * <code>RESOURCE_TYPE_UNSPECIFIED = 0;</code>
       */
      RESOURCE_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * File resource type.
       * </pre>
       *
       * <code>RESOURCE_TYPE_FILE = 1;</code>
       */
      RESOURCE_TYPE_FILE(1),
      /**
       *
       *
       * <pre>
       * Folder resource type.
       * </pre>
       *
       * <code>RESOURCE_TYPE_FOLDER = 2;</code>
       */
      RESOURCE_TYPE_FOLDER(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified resource type.
       * </pre>
       *
       * <code>RESOURCE_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int RESOURCE_TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * File resource type.
       * </pre>
       *
       * <code>RESOURCE_TYPE_FILE = 1;</code>
       */
      public static final int RESOURCE_TYPE_FILE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Folder resource type.
       * </pre>
       *
       * <code>RESOURCE_TYPE_FOLDER = 2;</code>
       */
      public static final int RESOURCE_TYPE_FOLDER_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ResourceType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static ResourceType forNumber(int value) {
        switch (value) {
          case 0:
            return RESOURCE_TYPE_UNSPECIFIED;
          case 1:
            return RESOURCE_TYPE_FILE;
          case 2:
            return RESOURCE_TYPE_FOLDER;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ResourceType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<ResourceType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ResourceType>() {
            public ResourceType findValueByNumber(int number) {
              return ResourceType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final ResourceType[] VALUES = values();

      public static ResourceType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private ResourceType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType)
    }

    public static final int RESOURCE_TYPE_FIELD_NUMBER = 1;
    private int resourceType_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The type of the Google Drive resource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType resource_type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for resourceType.
     */
    @java.lang.Override
    public int getResourceTypeValue() {
      return resourceType_;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of the Google Drive resource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType resource_type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The resourceType.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType
        getResourceType() {
      com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType result =
          com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType.forNumber(
              resourceType_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType
              .UNRECOGNIZED
          : result;
    }

    public static final int RESOURCE_ID_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object resourceId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Drive resource.
     * </pre>
     *
     * <code>string resource_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The resourceId.
     */
    @java.lang.Override
    public java.lang.String getResourceId() {
      java.lang.Object ref = resourceId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Drive resource.
     * </pre>
     *
     * <code>string resource_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for resourceId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getResourceIdBytes() {
      java.lang.Object ref = resourceId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (resourceType_
          != com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType
              .RESOURCE_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, resourceType_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, resourceId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (resourceType_
          != com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType
              .RESOURCE_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, resourceType_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, resourceId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId other =
          (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId) obj;

      if (resourceType_ != other.resourceType_) return false;
      if (!getResourceId().equals(other.getResourceId())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + RESOURCE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + resourceType_;
      hash = (37 * hash) + RESOURCE_ID_FIELD_NUMBER;
      hash = (53 * hash) + getResourceId().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The type and ID of the Google Drive resource.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId)
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceIdOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.IoProto
            .internal_static_google_cloud_aiplatform_v1beta1_GoogleDriveSource_ResourceId_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.IoProto
            .internal_static_google_cloud_aiplatform_v1beta1_GoogleDriveSource_ResourceId_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.class,
                com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        resourceType_ = 0;
        resourceId_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.IoProto
            .internal_static_google_cloud_aiplatform_v1beta1_GoogleDriveSource_ResourceId_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId build() {
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId buildPartial() {
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId result =
            new com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.resourceType_ = resourceType_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.resourceId_ = resourceId_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId
                .getDefaultInstance()) return this;
        if (other.resourceType_ != 0) {
          setResourceTypeValue(other.getResourceTypeValue());
        }
        if (!other.getResourceId().isEmpty()) {
          resourceId_ = other.resourceId_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  resourceType_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  resourceId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int resourceType_ = 0;
      /**
       *
       *
       * <pre>
       * Required. The type of the Google Drive resource.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType resource_type = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for resourceType.
       */
      @java.lang.Override
      public int getResourceTypeValue() {
        return resourceType_;
      }
      /**
       *
       *
       * <pre>
       * Required. The type of the Google Drive resource.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType resource_type = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for resourceType to set.
       * @return This builder for chaining.
       */
      public Builder setResourceTypeValue(int value) {
        resourceType_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The type of the Google Drive resource.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType resource_type = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The resourceType.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType
          getResourceType() {
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType result =
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType.forNumber(
                resourceType_);
        return result == null
            ? com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Required. The type of the Google Drive resource.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType resource_type = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The resourceType to set.
       * @return This builder for chaining.
       */
      public Builder setResourceType(
          com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        resourceType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The type of the Google Drive resource.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType resource_type = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearResourceType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        resourceType_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object resourceId_ = "";
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Drive resource.
       * </pre>
       *
       * <code>string resource_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The resourceId.
       */
      public java.lang.String getResourceId() {
        java.lang.Object ref = resourceId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          resourceId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Drive resource.
       * </pre>
       *
       * <code>string resource_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for resourceId.
       */
      public com.google.protobuf.ByteString getResourceIdBytes() {
        java.lang.Object ref = resourceId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          resourceId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Drive resource.
       * </pre>
       *
       * <code>string resource_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The resourceId to set.
       * @return This builder for chaining.
       */
      public Builder setResourceId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Drive resource.
       * </pre>
       *
       * <code>string resource_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearResourceId() {
        resourceId_ = getDefaultInstance().getResourceId();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Drive resource.
       * </pre>
       *
       * <code>string resource_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for resourceId to set.
       * @return This builder for chaining.
       */
      public Builder setResourceIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        resourceId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId)
    private static final com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId();
    }

    public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ResourceId> PARSER =
        new com.google.protobuf.AbstractParser<ResourceId>() {
          @java.lang.Override
          public ResourceId parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ResourceId> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ResourceId> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int RESOURCE_IDS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId>
      resourceIds_;
  /**
   *
   *
   * <pre>
   * Required. Google Drive resource IDs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId resource_ids = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId>
      getResourceIdsList() {
    return resourceIds_;
  }
  /**
   *
   *
   * <pre>
   * Required. Google Drive resource IDs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId resource_ids = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceIdOrBuilder>
      getResourceIdsOrBuilderList() {
    return resourceIds_;
  }
  /**
   *
   *
   * <pre>
   * Required. Google Drive resource IDs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId resource_ids = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getResourceIdsCount() {
    return resourceIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Google Drive resource IDs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId resource_ids = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId getResourceIds(
      int index) {
    return resourceIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Google Drive resource IDs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId resource_ids = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceIdOrBuilder
      getResourceIdsOrBuilder(int index) {
    return resourceIds_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < resourceIds_.size(); i++) {
      output.writeMessage(1, resourceIds_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < resourceIds_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, resourceIds_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.GoogleDriveSource)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.GoogleDriveSource other =
        (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) obj;

    if (!getResourceIdsList().equals(other.getResourceIdsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getResourceIdsCount() > 0) {
      hash = (37 * hash) + RESOURCE_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getResourceIdsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.GoogleDriveSource prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The Google Drive location for the input content.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.GoogleDriveSource}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.GoogleDriveSource)
      com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.IoProto
          .internal_static_google_cloud_aiplatform_v1beta1_GoogleDriveSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.IoProto
          .internal_static_google_cloud_aiplatform_v1beta1_GoogleDriveSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.class,
              com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (resourceIdsBuilder_ == null) {
        resourceIds_ = java.util.Collections.emptyList();
      } else {
        resourceIds_ = null;
        resourceIdsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.IoProto
          .internal_static_google_cloud_aiplatform_v1beta1_GoogleDriveSource_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource build() {
      com.google.cloud.aiplatform.v1beta1.GoogleDriveSource result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource buildPartial() {
      com.google.cloud.aiplatform.v1beta1.GoogleDriveSource result =
          new com.google.cloud.aiplatform.v1beta1.GoogleDriveSource(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource result) {
      if (resourceIdsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          resourceIds_ = java.util.Collections.unmodifiableList(resourceIds_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.resourceIds_ = resourceIds_;
      } else {
        result.resourceIds_ = resourceIdsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.GoogleDriveSource result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.GoogleDriveSource other) {
      if (other == com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance())
        return this;
      if (resourceIdsBuilder_ == null) {
        if (!other.resourceIds_.isEmpty()) {
          if (resourceIds_.isEmpty()) {
            resourceIds_ = other.resourceIds_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureResourceIdsIsMutable();
            resourceIds_.addAll(other.resourceIds_);
          }
          onChanged();
        }
      } else {
        if (!other.resourceIds_.isEmpty()) {
          if (resourceIdsBuilder_.isEmpty()) {
            resourceIdsBuilder_.dispose();
            resourceIdsBuilder_ = null;
            resourceIds_ = other.resourceIds_;
            bitField0_ = (bitField0_ & ~0x00000001);
            resourceIdsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getResourceIdsFieldBuilder()
                    : null;
          } else {
            resourceIdsBuilder_.addAllMessages(other.resourceIds_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.parser(),
                        extensionRegistry);
                if (resourceIdsBuilder_ == null) {
                  ensureResourceIdsIsMutable();
                  resourceIds_.add(m);
                } else {
                  resourceIdsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId>
        resourceIds_ = java.util.Collections.emptyList();

    private void ensureResourceIdsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        resourceIds_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId>(resourceIds_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.Builder,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceIdOrBuilder>
        resourceIdsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Google Drive resource IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId resource_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId>
        getResourceIdsList() {
      if (resourceIdsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(resourceIds_);
      } else {
        return resourceIdsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Google Drive resource IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId resource_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getResourceIdsCount() {
      if (resourceIdsBuilder_ == null) {
        return resourceIds_.size();
      } else {
        return resourceIdsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Google Drive resource IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId resource_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId getResourceIds(
        int index) {
      if (resourceIdsBuilder_ == null) {
        return resourceIds_.get(index);
      } else {
        return resourceIdsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Google Drive resource IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId resource_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setResourceIds(
        int index, com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId value) {
      if (resourceIdsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourceIdsIsMutable();
        resourceIds_.set(index, value);
        onChanged();
      } else {
        resourceIdsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Google Drive resource IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId resource_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setResourceIds(
        int index,
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.Builder builderForValue) {
      if (resourceIdsBuilder_ == null) {
        ensureResourceIdsIsMutable();
        resourceIds_.set(index, builderForValue.build());
        onChanged();
      } else {
        resourceIdsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Google Drive resource IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId resource_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addResourceIds(
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId value) {
      if (resourceIdsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourceIdsIsMutable();
        resourceIds_.add(value);
        onChanged();
      } else {
        resourceIdsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Google Drive resource IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId resource_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addResourceIds(
        int index, com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId value) {
      if (resourceIdsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourceIdsIsMutable();
        resourceIds_.add(index, value);
        onChanged();
      } else {
        resourceIdsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Google Drive resource IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId resource_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addResourceIds(
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.Builder builderForValue) {
      if (resourceIdsBuilder_ == null) {
        ensureResourceIdsIsMutable();
        resourceIds_.add(builderForValue.build());
        onChanged();
      } else {
        resourceIdsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Google Drive resource IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId resource_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addResourceIds(
        int index,
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.Builder builderForValue) {
      if (resourceIdsBuilder_ == null) {
        ensureResourceIdsIsMutable();
        resourceIds_.add(index, builderForValue.build());
        onChanged();
      } else {
        resourceIdsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Google Drive resource IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId resource_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllResourceIds(
        java.lang.Iterable<
                ? extends com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId>
            values) {
      if (resourceIdsBuilder_ == null) {
        ensureResourceIdsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, resourceIds_);
        onChanged();
      } else {
        resourceIdsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Google Drive resource IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId resource_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearResourceIds() {
      if (resourceIdsBuilder_ == null) {
        resourceIds_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        resourceIdsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Google Drive resource IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId resource_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeResourceIds(int index) {
      if (resourceIdsBuilder_ == null) {
        ensureResourceIdsIsMutable();
        resourceIds_.remove(index);
        onChanged();
      } else {
        resourceIdsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Google Drive resource IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId resource_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.Builder
        getResourceIdsBuilder(int index) {
      return getResourceIdsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Google Drive resource IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId resource_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceIdOrBuilder
        getResourceIdsOrBuilder(int index) {
      if (resourceIdsBuilder_ == null) {
        return resourceIds_.get(index);
      } else {
        return resourceIdsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Google Drive resource IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId resource_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceIdOrBuilder>
        getResourceIdsOrBuilderList() {
      if (resourceIdsBuilder_ != null) {
        return resourceIdsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(resourceIds_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Google Drive resource IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId resource_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.Builder
        addResourceIdsBuilder() {
      return getResourceIdsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Google Drive resource IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId resource_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.Builder
        addResourceIdsBuilder(int index) {
      return getResourceIdsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Google Drive resource IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId resource_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.Builder>
        getResourceIdsBuilderList() {
      return getResourceIdsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.Builder,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceIdOrBuilder>
        getResourceIdsFieldBuilder() {
      if (resourceIdsBuilder_ == null) {
        resourceIdsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId,
                com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.Builder,
                com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceIdOrBuilder>(
                resourceIds_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        resourceIds_ = null;
      }
      return resourceIdsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.GoogleDriveSource)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.GoogleDriveSource)
  private static final com.google.cloud.aiplatform.v1beta1.GoogleDriveSource DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.GoogleDriveSource();
  }

  public static com.google.cloud.aiplatform.v1beta1.GoogleDriveSource getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GoogleDriveSource> PARSER =
      new com.google.protobuf.AbstractParser<GoogleDriveSource>() {
        @java.lang.Override
        public GoogleDriveSource parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GoogleDriveSource> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GoogleDriveSource> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
