/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FeaturestoreName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_FEATURESTORE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/featurestores/{featurestore}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String featurestore;

    @Deprecated
    protected FeaturestoreName() {
        this.project = null;
        this.location = null;
        this.featurestore = null;
    }

    private FeaturestoreName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.featurestore = (String)Preconditions.checkNotNull((Object)builder.getFeaturestore());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFeaturestore() {
        return this.featurestore;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FeaturestoreName of(String project, String location, String featurestore) {
        return FeaturestoreName.newBuilder().setProject(project).setLocation(location).setFeaturestore(featurestore).build();
    }

    public static String format(String project, String location, String featurestore) {
        return FeaturestoreName.newBuilder().setProject(project).setLocation(location).setFeaturestore(featurestore).build().toString();
    }

    public static FeaturestoreName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_FEATURESTORE.validatedMatch(formattedString, "FeaturestoreName.parse: formattedString not in valid format");
        return FeaturestoreName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("featurestore"));
    }

    public static List<FeaturestoreName> parseList(List<String> formattedStrings) {
        ArrayList<FeaturestoreName> list = new ArrayList<FeaturestoreName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FeaturestoreName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FeaturestoreName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FeaturestoreName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_FEATURESTORE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FeaturestoreName featurestoreName = this;
            synchronized (featurestoreName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.featurestore != null) {
                        fieldMapBuilder.put((Object)"featurestore", (Object)this.featurestore);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_FEATURESTORE.instantiate(new String[]{"project", this.project, "location", this.location, "featurestore", this.featurestore});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            FeaturestoreName that = (FeaturestoreName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.featurestore, that.featurestore);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.featurestore);
    }

    public static class Builder {
        private String project;
        private String location;
        private String featurestore;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFeaturestore() {
            return this.featurestore;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFeaturestore(String featurestore) {
            this.featurestore = featurestore;
            return this;
        }

        private Builder(FeaturestoreName featurestoreName) {
            this.project = featurestoreName.project;
            this.location = featurestoreName.location;
            this.featurestore = featurestoreName.featurestore;
        }

        public FeaturestoreName build() {
            return new FeaturestoreName(this);
        }
    }
}

