/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/custom_job.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * All parameters related to queuing and scheduling of custom jobs.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.Scheduling}
 */
public final class Scheduling extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.Scheduling)
    SchedulingOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Scheduling.newBuilder() to construct.
  private Scheduling(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Scheduling() {
    strategy_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Scheduling();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.CustomJobProto
        .internal_static_google_cloud_aiplatform_v1_Scheduling_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.CustomJobProto
        .internal_static_google_cloud_aiplatform_v1_Scheduling_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.Scheduling.class,
            com.google.cloud.aiplatform.v1.Scheduling.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Optional. This determines which type of scheduling strategy to use. Right
   * now users have two options such as STANDARD which will use regular on
   * demand resources to schedule the job, the other is SPOT which would
   * leverage spot resources alongwith regular resources to schedule
   * the job.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1.Scheduling.Strategy}
   */
  public enum Strategy implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Strategy will default to STANDARD.
     * </pre>
     *
     * <code>STRATEGY_UNSPECIFIED = 0;</code>
     */
    STRATEGY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Deprecated. Regular on-demand provisioning strategy.
     * </pre>
     *
     * <code>ON_DEMAND = 1 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    ON_DEMAND(1),
    /**
     *
     *
     * <pre>
     * Deprecated. Low cost by making potential use of spot resources.
     * </pre>
     *
     * <code>LOW_COST = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    LOW_COST(2),
    /**
     *
     *
     * <pre>
     * Standard provisioning strategy uses regular on-demand resources.
     * </pre>
     *
     * <code>STANDARD = 3;</code>
     */
    STANDARD(3),
    /**
     *
     *
     * <pre>
     * Spot provisioning strategy uses spot resources.
     * </pre>
     *
     * <code>SPOT = 4;</code>
     */
    SPOT(4),
    /**
     *
     *
     * <pre>
     * Flex Start strategy uses DWS to queue for resources.
     * </pre>
     *
     * <code>FLEX_START = 6;</code>
     */
    FLEX_START(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Strategy will default to STANDARD.
     * </pre>
     *
     * <code>STRATEGY_UNSPECIFIED = 0;</code>
     */
    public static final int STRATEGY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Deprecated. Regular on-demand provisioning strategy.
     * </pre>
     *
     * <code>ON_DEMAND = 1 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int ON_DEMAND_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Deprecated. Low cost by making potential use of spot resources.
     * </pre>
     *
     * <code>LOW_COST = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int LOW_COST_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Standard provisioning strategy uses regular on-demand resources.
     * </pre>
     *
     * <code>STANDARD = 3;</code>
     */
    public static final int STANDARD_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Spot provisioning strategy uses spot resources.
     * </pre>
     *
     * <code>SPOT = 4;</code>
     */
    public static final int SPOT_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Flex Start strategy uses DWS to queue for resources.
     * </pre>
     *
     * <code>FLEX_START = 6;</code>
     */
    public static final int FLEX_START_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Strategy valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Strategy forNumber(int value) {
      switch (value) {
        case 0:
          return STRATEGY_UNSPECIFIED;
        case 1:
          return ON_DEMAND;
        case 2:
          return LOW_COST;
        case 3:
          return STANDARD;
        case 4:
          return SPOT;
        case 6:
          return FLEX_START;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Strategy> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Strategy> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Strategy>() {
          public Strategy findValueByNumber(int number) {
            return Strategy.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.Scheduling.getDescriptor().getEnumTypes().get(0);
    }

    private static final Strategy[] VALUES = values();

    public static Strategy valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Strategy(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.Scheduling.Strategy)
  }

  private int bitField0_;
  public static final int TIMEOUT_FIELD_NUMBER = 1;
  private com.google.protobuf.Duration timeout_;
  /**
   *
   *
   * <pre>
   * Optional. The maximum job running time. The default is 7 days.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 1;</code>
   *
   * @return Whether the timeout field is set.
   */
  @java.lang.Override
  public boolean hasTimeout() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The maximum job running time. The default is 7 days.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 1;</code>
   *
   * @return The timeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeout() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The maximum job running time. The default is 7 days.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }

  public static final int RESTART_JOB_ON_WORKER_RESTART_FIELD_NUMBER = 3;
  private boolean restartJobOnWorkerRestart_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Restarts the entire CustomJob if a worker gets restarted.
   * This feature can be used by distributed training jobs that are not
   * resilient to workers leaving and joining a job.
   * </pre>
   *
   * <code>bool restart_job_on_worker_restart = 3;</code>
   *
   * @return The restartJobOnWorkerRestart.
   */
  @java.lang.Override
  public boolean getRestartJobOnWorkerRestart() {
    return restartJobOnWorkerRestart_;
  }

  public static final int STRATEGY_FIELD_NUMBER = 4;
  private int strategy_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. This determines which type of scheduling strategy to use.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Scheduling.Strategy strategy = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for strategy.
   */
  @java.lang.Override
  public int getStrategyValue() {
    return strategy_;
  }
  /**
   *
   *
   * <pre>
   * Optional. This determines which type of scheduling strategy to use.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Scheduling.Strategy strategy = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The strategy.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Scheduling.Strategy getStrategy() {
    com.google.cloud.aiplatform.v1.Scheduling.Strategy result =
        com.google.cloud.aiplatform.v1.Scheduling.Strategy.forNumber(strategy_);
    return result == null
        ? com.google.cloud.aiplatform.v1.Scheduling.Strategy.UNRECOGNIZED
        : result;
  }

  public static final int DISABLE_RETRIES_FIELD_NUMBER = 5;
  private boolean disableRetries_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Indicates if the job should retry for internal errors after the
   * job starts running. If true, overrides
   * `Scheduling.restart_job_on_worker_restart` to false.
   * </pre>
   *
   * <code>bool disable_retries = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The disableRetries.
   */
  @java.lang.Override
  public boolean getDisableRetries() {
    return disableRetries_;
  }

  public static final int MAX_WAIT_DURATION_FIELD_NUMBER = 6;
  private com.google.protobuf.Duration maxWaitDuration_;
  /**
   *
   *
   * <pre>
   * Optional. This is the maximum duration that a job will wait for the
   * requested resources to be provisioned if the scheduling strategy is set to
   * [Strategy.DWS_FLEX_START].
   * If set to 0, the job will wait indefinitely. The default is 24 hours.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration max_wait_duration = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the maxWaitDuration field is set.
   */
  @java.lang.Override
  public boolean hasMaxWaitDuration() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. This is the maximum duration that a job will wait for the
   * requested resources to be provisioned if the scheduling strategy is set to
   * [Strategy.DWS_FLEX_START].
   * If set to 0, the job will wait indefinitely. The default is 24 hours.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration max_wait_duration = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The maxWaitDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getMaxWaitDuration() {
    return maxWaitDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : maxWaitDuration_;
  }
  /**
   *
   *
   * <pre>
   * Optional. This is the maximum duration that a job will wait for the
   * requested resources to be provisioned if the scheduling strategy is set to
   * [Strategy.DWS_FLEX_START].
   * If set to 0, the job will wait indefinitely. The default is 24 hours.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration max_wait_duration = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getMaxWaitDurationOrBuilder() {
    return maxWaitDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : maxWaitDuration_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getTimeout());
    }
    if (restartJobOnWorkerRestart_ != false) {
      output.writeBool(3, restartJobOnWorkerRestart_);
    }
    if (strategy_
        != com.google.cloud.aiplatform.v1.Scheduling.Strategy.STRATEGY_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, strategy_);
    }
    if (disableRetries_ != false) {
      output.writeBool(5, disableRetries_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getMaxWaitDuration());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTimeout());
    }
    if (restartJobOnWorkerRestart_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, restartJobOnWorkerRestart_);
    }
    if (strategy_
        != com.google.cloud.aiplatform.v1.Scheduling.Strategy.STRATEGY_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, strategy_);
    }
    if (disableRetries_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, disableRetries_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getMaxWaitDuration());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.Scheduling)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.Scheduling other =
        (com.google.cloud.aiplatform.v1.Scheduling) obj;

    if (hasTimeout() != other.hasTimeout()) return false;
    if (hasTimeout()) {
      if (!getTimeout().equals(other.getTimeout())) return false;
    }
    if (getRestartJobOnWorkerRestart() != other.getRestartJobOnWorkerRestart()) return false;
    if (strategy_ != other.strategy_) return false;
    if (getDisableRetries() != other.getDisableRetries()) return false;
    if (hasMaxWaitDuration() != other.hasMaxWaitDuration()) return false;
    if (hasMaxWaitDuration()) {
      if (!getMaxWaitDuration().equals(other.getMaxWaitDuration())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasTimeout()) {
      hash = (37 * hash) + TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getTimeout().hashCode();
    }
    hash = (37 * hash) + RESTART_JOB_ON_WORKER_RESTART_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRestartJobOnWorkerRestart());
    hash = (37 * hash) + STRATEGY_FIELD_NUMBER;
    hash = (53 * hash) + strategy_;
    hash = (37 * hash) + DISABLE_RETRIES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisableRetries());
    if (hasMaxWaitDuration()) {
      hash = (37 * hash) + MAX_WAIT_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getMaxWaitDuration().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.Scheduling parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Scheduling parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Scheduling parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Scheduling parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Scheduling parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Scheduling parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Scheduling parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Scheduling parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Scheduling parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Scheduling parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Scheduling parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Scheduling parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.Scheduling prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * All parameters related to queuing and scheduling of custom jobs.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.Scheduling}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.Scheduling)
      com.google.cloud.aiplatform.v1.SchedulingOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.CustomJobProto
          .internal_static_google_cloud_aiplatform_v1_Scheduling_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.CustomJobProto
          .internal_static_google_cloud_aiplatform_v1_Scheduling_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.Scheduling.class,
              com.google.cloud.aiplatform.v1.Scheduling.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.Scheduling.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTimeoutFieldBuilder();
        getMaxWaitDurationFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      timeout_ = null;
      if (timeoutBuilder_ != null) {
        timeoutBuilder_.dispose();
        timeoutBuilder_ = null;
      }
      restartJobOnWorkerRestart_ = false;
      strategy_ = 0;
      disableRetries_ = false;
      maxWaitDuration_ = null;
      if (maxWaitDurationBuilder_ != null) {
        maxWaitDurationBuilder_.dispose();
        maxWaitDurationBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.CustomJobProto
          .internal_static_google_cloud_aiplatform_v1_Scheduling_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Scheduling getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.Scheduling.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Scheduling build() {
      com.google.cloud.aiplatform.v1.Scheduling result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Scheduling buildPartial() {
      com.google.cloud.aiplatform.v1.Scheduling result =
          new com.google.cloud.aiplatform.v1.Scheduling(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.Scheduling result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.timeout_ = timeoutBuilder_ == null ? timeout_ : timeoutBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.restartJobOnWorkerRestart_ = restartJobOnWorkerRestart_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.strategy_ = strategy_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.disableRetries_ = disableRetries_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.maxWaitDuration_ =
            maxWaitDurationBuilder_ == null ? maxWaitDuration_ : maxWaitDurationBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.Scheduling) {
        return mergeFrom((com.google.cloud.aiplatform.v1.Scheduling) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.Scheduling other) {
      if (other == com.google.cloud.aiplatform.v1.Scheduling.getDefaultInstance()) return this;
      if (other.hasTimeout()) {
        mergeTimeout(other.getTimeout());
      }
      if (other.getRestartJobOnWorkerRestart() != false) {
        setRestartJobOnWorkerRestart(other.getRestartJobOnWorkerRestart());
      }
      if (other.strategy_ != 0) {
        setStrategyValue(other.getStrategyValue());
      }
      if (other.getDisableRetries() != false) {
        setDisableRetries(other.getDisableRetries());
      }
      if (other.hasMaxWaitDuration()) {
        mergeMaxWaitDuration(other.getMaxWaitDuration());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 24:
              {
                restartJobOnWorkerRestart_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 24
            case 32:
              {
                strategy_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 32
            case 40:
              {
                disableRetries_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getMaxWaitDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Duration timeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeoutBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The maximum job running time. The default is 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 1;</code>
     *
     * @return Whether the timeout field is set.
     */
    public boolean hasTimeout() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum job running time. The default is 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 1;</code>
     *
     * @return The timeout.
     */
    public com.google.protobuf.Duration getTimeout() {
      if (timeoutBuilder_ == null) {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      } else {
        return timeoutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum job running time. The default is 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 1;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeout_ = value;
      } else {
        timeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum job running time. The default is 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 1;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeoutBuilder_ == null) {
        timeout_ = builderForValue.build();
      } else {
        timeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum job running time. The default is 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 1;</code>
     */
    public Builder mergeTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && timeout_ != null
            && timeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTimeoutBuilder().mergeFrom(value);
        } else {
          timeout_ = value;
        }
      } else {
        timeoutBuilder_.mergeFrom(value);
      }
      if (timeout_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum job running time. The default is 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 1;</code>
     */
    public Builder clearTimeout() {
      bitField0_ = (bitField0_ & ~0x00000001);
      timeout_ = null;
      if (timeoutBuilder_ != null) {
        timeoutBuilder_.dispose();
        timeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum job running time. The default is 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 1;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeoutBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getTimeoutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum job running time. The default is 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 1;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
      if (timeoutBuilder_ != null) {
        return timeoutBuilder_.getMessageOrBuilder();
      } else {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum job running time. The default is 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeoutFieldBuilder() {
      if (timeoutBuilder_ == null) {
        timeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeout(), getParentForChildren(), isClean());
        timeout_ = null;
      }
      return timeoutBuilder_;
    }

    private boolean restartJobOnWorkerRestart_;
    /**
     *
     *
     * <pre>
     * Optional. Restarts the entire CustomJob if a worker gets restarted.
     * This feature can be used by distributed training jobs that are not
     * resilient to workers leaving and joining a job.
     * </pre>
     *
     * <code>bool restart_job_on_worker_restart = 3;</code>
     *
     * @return The restartJobOnWorkerRestart.
     */
    @java.lang.Override
    public boolean getRestartJobOnWorkerRestart() {
      return restartJobOnWorkerRestart_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Restarts the entire CustomJob if a worker gets restarted.
     * This feature can be used by distributed training jobs that are not
     * resilient to workers leaving and joining a job.
     * </pre>
     *
     * <code>bool restart_job_on_worker_restart = 3;</code>
     *
     * @param value The restartJobOnWorkerRestart to set.
     * @return This builder for chaining.
     */
    public Builder setRestartJobOnWorkerRestart(boolean value) {

      restartJobOnWorkerRestart_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Restarts the entire CustomJob if a worker gets restarted.
     * This feature can be used by distributed training jobs that are not
     * resilient to workers leaving and joining a job.
     * </pre>
     *
     * <code>bool restart_job_on_worker_restart = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRestartJobOnWorkerRestart() {
      bitField0_ = (bitField0_ & ~0x00000002);
      restartJobOnWorkerRestart_ = false;
      onChanged();
      return this;
    }

    private int strategy_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. This determines which type of scheduling strategy to use.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Scheduling.Strategy strategy = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for strategy.
     */
    @java.lang.Override
    public int getStrategyValue() {
      return strategy_;
    }
    /**
     *
     *
     * <pre>
     * Optional. This determines which type of scheduling strategy to use.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Scheduling.Strategy strategy = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for strategy to set.
     * @return This builder for chaining.
     */
    public Builder setStrategyValue(int value) {
      strategy_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This determines which type of scheduling strategy to use.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Scheduling.Strategy strategy = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The strategy.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Scheduling.Strategy getStrategy() {
      com.google.cloud.aiplatform.v1.Scheduling.Strategy result =
          com.google.cloud.aiplatform.v1.Scheduling.Strategy.forNumber(strategy_);
      return result == null
          ? com.google.cloud.aiplatform.v1.Scheduling.Strategy.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. This determines which type of scheduling strategy to use.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Scheduling.Strategy strategy = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The strategy to set.
     * @return This builder for chaining.
     */
    public Builder setStrategy(com.google.cloud.aiplatform.v1.Scheduling.Strategy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      strategy_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This determines which type of scheduling strategy to use.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Scheduling.Strategy strategy = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStrategy() {
      bitField0_ = (bitField0_ & ~0x00000004);
      strategy_ = 0;
      onChanged();
      return this;
    }

    private boolean disableRetries_;
    /**
     *
     *
     * <pre>
     * Optional. Indicates if the job should retry for internal errors after the
     * job starts running. If true, overrides
     * `Scheduling.restart_job_on_worker_restart` to false.
     * </pre>
     *
     * <code>bool disable_retries = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The disableRetries.
     */
    @java.lang.Override
    public boolean getDisableRetries() {
      return disableRetries_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates if the job should retry for internal errors after the
     * job starts running. If true, overrides
     * `Scheduling.restart_job_on_worker_restart` to false.
     * </pre>
     *
     * <code>bool disable_retries = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The disableRetries to set.
     * @return This builder for chaining.
     */
    public Builder setDisableRetries(boolean value) {

      disableRetries_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates if the job should retry for internal errors after the
     * job starts running. If true, overrides
     * `Scheduling.restart_job_on_worker_restart` to false.
     * </pre>
     *
     * <code>bool disable_retries = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisableRetries() {
      bitField0_ = (bitField0_ & ~0x00000008);
      disableRetries_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration maxWaitDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        maxWaitDurationBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. This is the maximum duration that a job will wait for the
     * requested resources to be provisioned if the scheduling strategy is set to
     * [Strategy.DWS_FLEX_START].
     * If set to 0, the job will wait indefinitely. The default is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration max_wait_duration = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the maxWaitDuration field is set.
     */
    public boolean hasMaxWaitDuration() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. This is the maximum duration that a job will wait for the
     * requested resources to be provisioned if the scheduling strategy is set to
     * [Strategy.DWS_FLEX_START].
     * If set to 0, the job will wait indefinitely. The default is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration max_wait_duration = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The maxWaitDuration.
     */
    public com.google.protobuf.Duration getMaxWaitDuration() {
      if (maxWaitDurationBuilder_ == null) {
        return maxWaitDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : maxWaitDuration_;
      } else {
        return maxWaitDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This is the maximum duration that a job will wait for the
     * requested resources to be provisioned if the scheduling strategy is set to
     * [Strategy.DWS_FLEX_START].
     * If set to 0, the job will wait indefinitely. The default is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration max_wait_duration = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMaxWaitDuration(com.google.protobuf.Duration value) {
      if (maxWaitDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maxWaitDuration_ = value;
      } else {
        maxWaitDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This is the maximum duration that a job will wait for the
     * requested resources to be provisioned if the scheduling strategy is set to
     * [Strategy.DWS_FLEX_START].
     * If set to 0, the job will wait indefinitely. The default is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration max_wait_duration = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMaxWaitDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (maxWaitDurationBuilder_ == null) {
        maxWaitDuration_ = builderForValue.build();
      } else {
        maxWaitDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This is the maximum duration that a job will wait for the
     * requested resources to be provisioned if the scheduling strategy is set to
     * [Strategy.DWS_FLEX_START].
     * If set to 0, the job will wait indefinitely. The default is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration max_wait_duration = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeMaxWaitDuration(com.google.protobuf.Duration value) {
      if (maxWaitDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && maxWaitDuration_ != null
            && maxWaitDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getMaxWaitDurationBuilder().mergeFrom(value);
        } else {
          maxWaitDuration_ = value;
        }
      } else {
        maxWaitDurationBuilder_.mergeFrom(value);
      }
      if (maxWaitDuration_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This is the maximum duration that a job will wait for the
     * requested resources to be provisioned if the scheduling strategy is set to
     * [Strategy.DWS_FLEX_START].
     * If set to 0, the job will wait indefinitely. The default is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration max_wait_duration = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMaxWaitDuration() {
      bitField0_ = (bitField0_ & ~0x00000010);
      maxWaitDuration_ = null;
      if (maxWaitDurationBuilder_ != null) {
        maxWaitDurationBuilder_.dispose();
        maxWaitDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This is the maximum duration that a job will wait for the
     * requested resources to be provisioned if the scheduling strategy is set to
     * [Strategy.DWS_FLEX_START].
     * If set to 0, the job will wait indefinitely. The default is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration max_wait_duration = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getMaxWaitDurationBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getMaxWaitDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. This is the maximum duration that a job will wait for the
     * requested resources to be provisioned if the scheduling strategy is set to
     * [Strategy.DWS_FLEX_START].
     * If set to 0, the job will wait indefinitely. The default is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration max_wait_duration = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getMaxWaitDurationOrBuilder() {
      if (maxWaitDurationBuilder_ != null) {
        return maxWaitDurationBuilder_.getMessageOrBuilder();
      } else {
        return maxWaitDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : maxWaitDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This is the maximum duration that a job will wait for the
     * requested resources to be provisioned if the scheduling strategy is set to
     * [Strategy.DWS_FLEX_START].
     * If set to 0, the job will wait indefinitely. The default is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration max_wait_duration = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getMaxWaitDurationFieldBuilder() {
      if (maxWaitDurationBuilder_ == null) {
        maxWaitDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getMaxWaitDuration(), getParentForChildren(), isClean());
        maxWaitDuration_ = null;
      }
      return maxWaitDurationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.Scheduling)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.Scheduling)
  private static final com.google.cloud.aiplatform.v1.Scheduling DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.Scheduling();
  }

  public static com.google.cloud.aiplatform.v1.Scheduling getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Scheduling> PARSER =
      new com.google.protobuf.AbstractParser<Scheduling>() {
        @java.lang.Override
        public Scheduling parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Scheduling> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Scheduling> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Scheduling getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
