/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/vertex_rag_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [VertexRagService.RetrieveContexts][google.cloud.aiplatform.v1.VertexRagService.RetrieveContexts].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.RetrieveContextsRequest}
 */
public final class RetrieveContextsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.RetrieveContextsRequest)
    RetrieveContextsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RetrieveContextsRequest.newBuilder() to construct.
  private RetrieveContextsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RetrieveContextsRequest() {
    parent_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RetrieveContextsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.VertexRagServiceProto
        .internal_static_google_cloud_aiplatform_v1_RetrieveContextsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.VertexRagServiceProto
        .internal_static_google_cloud_aiplatform_v1_RetrieveContextsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.RetrieveContextsRequest.class,
            com.google.cloud.aiplatform.v1.RetrieveContextsRequest.Builder.class);
  }

  public interface VertexRagStoreOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<
            com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource>
        getRagResourcesList();
    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
        getRagResources(int index);
    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getRagResourcesCount();
    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
                    .RagResourceOrBuilder>
        getRagResourcesOrBuilderList();
    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResourceOrBuilder
        getRagResourcesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Optional. Only return contexts with vector distance smaller than the
     * threshold.
     * </pre>
     *
     * <code>
     * optional double vector_distance_threshold = 2 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated
     *     google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.vector_distance_threshold
     *     is deprecated. See google/cloud/aiplatform/v1/vertex_rag_service.proto;l=117
     * @return Whether the vectorDistanceThreshold field is set.
     */
    @java.lang.Deprecated
    boolean hasVectorDistanceThreshold();
    /**
     *
     *
     * <pre>
     * Optional. Only return contexts with vector distance smaller than the
     * threshold.
     * </pre>
     *
     * <code>
     * optional double vector_distance_threshold = 2 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated
     *     google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.vector_distance_threshold
     *     is deprecated. See google/cloud/aiplatform/v1/vertex_rag_service.proto;l=117
     * @return The vectorDistanceThreshold.
     */
    @java.lang.Deprecated
    double getVectorDistanceThreshold();
  }
  /**
   *
   *
   * <pre>
   * The data source for Vertex RagStore.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore}
   */
  public static final class VertexRagStore extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore)
      VertexRagStoreOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use VertexRagStore.newBuilder() to construct.
    private VertexRagStore(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private VertexRagStore() {
      ragResources_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new VertexRagStore();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.VertexRagServiceProto
          .internal_static_google_cloud_aiplatform_v1_RetrieveContextsRequest_VertexRagStore_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.VertexRagServiceProto
          .internal_static_google_cloud_aiplatform_v1_RetrieveContextsRequest_VertexRagStore_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.class,
              com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.Builder.class);
    }

    public interface RagResourceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. RagCorpora resource name.
       * Format:
       * `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
       * </pre>
       *
       * <code>
       * string rag_corpus = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The ragCorpus.
       */
      java.lang.String getRagCorpus();
      /**
       *
       *
       * <pre>
       * Optional. RagCorpora resource name.
       * Format:
       * `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
       * </pre>
       *
       * <code>
       * string rag_corpus = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for ragCorpus.
       */
      com.google.protobuf.ByteString getRagCorpusBytes();

      /**
       *
       *
       * <pre>
       * Optional. rag_file_id. The files should be in the same rag_corpus set
       * in rag_corpus field.
       * </pre>
       *
       * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the ragFileIds.
       */
      java.util.List<java.lang.String> getRagFileIdsList();
      /**
       *
       *
       * <pre>
       * Optional. rag_file_id. The files should be in the same rag_corpus set
       * in rag_corpus field.
       * </pre>
       *
       * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of ragFileIds.
       */
      int getRagFileIdsCount();
      /**
       *
       *
       * <pre>
       * Optional. rag_file_id. The files should be in the same rag_corpus set
       * in rag_corpus field.
       * </pre>
       *
       * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The ragFileIds at the given index.
       */
      java.lang.String getRagFileIds(int index);
      /**
       *
       *
       * <pre>
       * Optional. rag_file_id. The files should be in the same rag_corpus set
       * in rag_corpus field.
       * </pre>
       *
       * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the ragFileIds at the given index.
       */
      com.google.protobuf.ByteString getRagFileIdsBytes(int index);
    }
    /**
     *
     *
     * <pre>
     * The definition of the Rag resource.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource}
     */
    public static final class RagResource extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource)
        RagResourceOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use RagResource.newBuilder() to construct.
      private RagResource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private RagResource() {
        ragCorpus_ = "";
        ragFileIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new RagResource();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.VertexRagServiceProto
            .internal_static_google_cloud_aiplatform_v1_RetrieveContextsRequest_VertexRagStore_RagResource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.VertexRagServiceProto
            .internal_static_google_cloud_aiplatform_v1_RetrieveContextsRequest_VertexRagStore_RagResource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
                    .class,
                com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
                    .Builder.class);
      }

      public static final int RAG_CORPUS_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object ragCorpus_ = "";
      /**
       *
       *
       * <pre>
       * Optional. RagCorpora resource name.
       * Format:
       * `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
       * </pre>
       *
       * <code>
       * string rag_corpus = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The ragCorpus.
       */
      @java.lang.Override
      public java.lang.String getRagCorpus() {
        java.lang.Object ref = ragCorpus_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ragCorpus_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. RagCorpora resource name.
       * Format:
       * `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
       * </pre>
       *
       * <code>
       * string rag_corpus = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for ragCorpus.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getRagCorpusBytes() {
        java.lang.Object ref = ragCorpus_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          ragCorpus_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int RAG_FILE_IDS_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList ragFileIds_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * Optional. rag_file_id. The files should be in the same rag_corpus set
       * in rag_corpus field.
       * </pre>
       *
       * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the ragFileIds.
       */
      public com.google.protobuf.ProtocolStringList getRagFileIdsList() {
        return ragFileIds_;
      }
      /**
       *
       *
       * <pre>
       * Optional. rag_file_id. The files should be in the same rag_corpus set
       * in rag_corpus field.
       * </pre>
       *
       * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of ragFileIds.
       */
      public int getRagFileIdsCount() {
        return ragFileIds_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. rag_file_id. The files should be in the same rag_corpus set
       * in rag_corpus field.
       * </pre>
       *
       * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The ragFileIds at the given index.
       */
      public java.lang.String getRagFileIds(int index) {
        return ragFileIds_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. rag_file_id. The files should be in the same rag_corpus set
       * in rag_corpus field.
       * </pre>
       *
       * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the ragFileIds at the given index.
       */
      public com.google.protobuf.ByteString getRagFileIdsBytes(int index) {
        return ragFileIds_.getByteString(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ragCorpus_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, ragCorpus_);
        }
        for (int i = 0; i < ragFileIds_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, ragFileIds_.getRaw(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ragCorpus_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, ragCorpus_);
        }
        {
          int dataSize = 0;
          for (int i = 0; i < ragFileIds_.size(); i++) {
            dataSize += computeStringSizeNoTag(ragFileIds_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getRagFileIdsList().size();
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource other =
            (com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource) obj;

        if (!getRagCorpus().equals(other.getRagCorpus())) return false;
        if (!getRagFileIdsList().equals(other.getRagFileIdsList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + RAG_CORPUS_FIELD_NUMBER;
        hash = (53 * hash) + getRagCorpus().hashCode();
        if (getRagFileIdsCount() > 0) {
          hash = (37 * hash) + RAG_FILE_IDS_FIELD_NUMBER;
          hash = (53 * hash) + getRagFileIdsList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
              .RagResource
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
              .RagResource
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
              .RagResource
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
              .RagResource
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
              .RagResource
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
              .RagResource
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
              .RagResource
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
              .RagResource
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
              .RagResource
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
              .RagResource
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
              .RagResource
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
              .RagResource
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The definition of the Rag resource.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource)
          com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
              .RagResourceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.VertexRagServiceProto
              .internal_static_google_cloud_aiplatform_v1_RetrieveContextsRequest_VertexRagStore_RagResource_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.VertexRagServiceProto
              .internal_static_google_cloud_aiplatform_v1_RetrieveContextsRequest_VertexRagStore_RagResource_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
                      .class,
                  com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          ragCorpus_ = "";
          ragFileIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1.VertexRagServiceProto
              .internal_static_google_cloud_aiplatform_v1_RetrieveContextsRequest_VertexRagStore_RagResource_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
            build() {
          com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
            buildPartial() {
          com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource result =
              new com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.ragCorpus_ = ragCorpus_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            ragFileIds_.makeImmutable();
            result.ragFileIds_ = ragFileIds_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
                other) {
          if (other
              == com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
                  .getDefaultInstance()) return this;
          if (!other.getRagCorpus().isEmpty()) {
            ragCorpus_ = other.ragCorpus_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.ragFileIds_.isEmpty()) {
            if (ragFileIds_.isEmpty()) {
              ragFileIds_ = other.ragFileIds_;
              bitField0_ |= 0x00000002;
            } else {
              ensureRagFileIdsIsMutable();
              ragFileIds_.addAll(other.ragFileIds_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    ragCorpus_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureRagFileIdsIsMutable();
                    ragFileIds_.add(s);
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object ragCorpus_ = "";
        /**
         *
         *
         * <pre>
         * Optional. RagCorpora resource name.
         * Format:
         * `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
         * </pre>
         *
         * <code>
         * string rag_corpus = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The ragCorpus.
         */
        public java.lang.String getRagCorpus() {
          java.lang.Object ref = ragCorpus_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            ragCorpus_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. RagCorpora resource name.
         * Format:
         * `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
         * </pre>
         *
         * <code>
         * string rag_corpus = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The bytes for ragCorpus.
         */
        public com.google.protobuf.ByteString getRagCorpusBytes() {
          java.lang.Object ref = ragCorpus_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            ragCorpus_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. RagCorpora resource name.
         * Format:
         * `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
         * </pre>
         *
         * <code>
         * string rag_corpus = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The ragCorpus to set.
         * @return This builder for chaining.
         */
        public Builder setRagCorpus(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ragCorpus_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. RagCorpora resource name.
         * Format:
         * `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
         * </pre>
         *
         * <code>
         * string rag_corpus = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRagCorpus() {
          ragCorpus_ = getDefaultInstance().getRagCorpus();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. RagCorpora resource name.
         * Format:
         * `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
         * </pre>
         *
         * <code>
         * string rag_corpus = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The bytes for ragCorpus to set.
         * @return This builder for chaining.
         */
        public Builder setRagCorpusBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ragCorpus_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringArrayList ragFileIds_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureRagFileIdsIsMutable() {
          if (!ragFileIds_.isModifiable()) {
            ragFileIds_ = new com.google.protobuf.LazyStringArrayList(ragFileIds_);
          }
          bitField0_ |= 0x00000002;
        }
        /**
         *
         *
         * <pre>
         * Optional. rag_file_id. The files should be in the same rag_corpus set
         * in rag_corpus field.
         * </pre>
         *
         * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return A list containing the ragFileIds.
         */
        public com.google.protobuf.ProtocolStringList getRagFileIdsList() {
          ragFileIds_.makeImmutable();
          return ragFileIds_;
        }
        /**
         *
         *
         * <pre>
         * Optional. rag_file_id. The files should be in the same rag_corpus set
         * in rag_corpus field.
         * </pre>
         *
         * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The count of ragFileIds.
         */
        public int getRagFileIdsCount() {
          return ragFileIds_.size();
        }
        /**
         *
         *
         * <pre>
         * Optional. rag_file_id. The files should be in the same rag_corpus set
         * in rag_corpus field.
         * </pre>
         *
         * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the element to return.
         * @return The ragFileIds at the given index.
         */
        public java.lang.String getRagFileIds(int index) {
          return ragFileIds_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. rag_file_id. The files should be in the same rag_corpus set
         * in rag_corpus field.
         * </pre>
         *
         * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the ragFileIds at the given index.
         */
        public com.google.protobuf.ByteString getRagFileIdsBytes(int index) {
          return ragFileIds_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. rag_file_id. The files should be in the same rag_corpus set
         * in rag_corpus field.
         * </pre>
         *
         * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index to set the value at.
         * @param value The ragFileIds to set.
         * @return This builder for chaining.
         */
        public Builder setRagFileIds(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRagFileIdsIsMutable();
          ragFileIds_.set(index, value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. rag_file_id. The files should be in the same rag_corpus set
         * in rag_corpus field.
         * </pre>
         *
         * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The ragFileIds to add.
         * @return This builder for chaining.
         */
        public Builder addRagFileIds(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRagFileIdsIsMutable();
          ragFileIds_.add(value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. rag_file_id. The files should be in the same rag_corpus set
         * in rag_corpus field.
         * </pre>
         *
         * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param values The ragFileIds to add.
         * @return This builder for chaining.
         */
        public Builder addAllRagFileIds(java.lang.Iterable<java.lang.String> values) {
          ensureRagFileIdsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ragFileIds_);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. rag_file_id. The files should be in the same rag_corpus set
         * in rag_corpus field.
         * </pre>
         *
         * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRagFileIds() {
          ragFileIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. rag_file_id. The files should be in the same rag_corpus set
         * in rag_corpus field.
         * </pre>
         *
         * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes of the ragFileIds to add.
         * @return This builder for chaining.
         */
        public Builder addRagFileIdsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureRagFileIdsIsMutable();
          ragFileIds_.add(value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource)
      private static final com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
              .RagResource
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource();
      }

      public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
              .RagResource
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<RagResource> PARSER =
          new com.google.protobuf.AbstractParser<RagResource>() {
            @java.lang.Override
            public RagResource parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<RagResource> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<RagResource> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int RAG_RESOURCES_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource>
        ragResources_;
    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource>
        getRagResourcesList() {
      return ragResources_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
                    .RagResourceOrBuilder>
        getRagResourcesOrBuilderList() {
      return ragResources_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getRagResourcesCount() {
      return ragResources_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
        getRagResources(int index) {
      return ragResources_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
            .RagResourceOrBuilder
        getRagResourcesOrBuilder(int index) {
      return ragResources_.get(index);
    }

    public static final int VECTOR_DISTANCE_THRESHOLD_FIELD_NUMBER = 2;
    private double vectorDistanceThreshold_ = 0D;
    /**
     *
     *
     * <pre>
     * Optional. Only return contexts with vector distance smaller than the
     * threshold.
     * </pre>
     *
     * <code>
     * optional double vector_distance_threshold = 2 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated
     *     google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.vector_distance_threshold
     *     is deprecated. See google/cloud/aiplatform/v1/vertex_rag_service.proto;l=117
     * @return Whether the vectorDistanceThreshold field is set.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean hasVectorDistanceThreshold() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Only return contexts with vector distance smaller than the
     * threshold.
     * </pre>
     *
     * <code>
     * optional double vector_distance_threshold = 2 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated
     *     google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.vector_distance_threshold
     *     is deprecated. See google/cloud/aiplatform/v1/vertex_rag_service.proto;l=117
     * @return The vectorDistanceThreshold.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public double getVectorDistanceThreshold() {
      return vectorDistanceThreshold_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeDouble(2, vectorDistanceThreshold_);
      }
      for (int i = 0; i < ragResources_.size(); i++) {
        output.writeMessage(3, ragResources_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeDoubleSize(2, vectorDistanceThreshold_);
      }
      for (int i = 0; i < ragResources_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, ragResources_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore other =
          (com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore) obj;

      if (!getRagResourcesList().equals(other.getRagResourcesList())) return false;
      if (hasVectorDistanceThreshold() != other.hasVectorDistanceThreshold()) return false;
      if (hasVectorDistanceThreshold()) {
        if (java.lang.Double.doubleToLongBits(getVectorDistanceThreshold())
            != java.lang.Double.doubleToLongBits(other.getVectorDistanceThreshold())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getRagResourcesCount() > 0) {
        hash = (37 * hash) + RAG_RESOURCES_FIELD_NUMBER;
        hash = (53 * hash) + getRagResourcesList().hashCode();
      }
      if (hasVectorDistanceThreshold()) {
        hash = (37 * hash) + VECTOR_DISTANCE_THRESHOLD_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getVectorDistanceThreshold()));
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The data source for Vertex RagStore.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore)
        com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStoreOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.VertexRagServiceProto
            .internal_static_google_cloud_aiplatform_v1_RetrieveContextsRequest_VertexRagStore_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.VertexRagServiceProto
            .internal_static_google_cloud_aiplatform_v1_RetrieveContextsRequest_VertexRagStore_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.class,
                com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (ragResourcesBuilder_ == null) {
          ragResources_ = java.util.Collections.emptyList();
        } else {
          ragResources_ = null;
          ragResourcesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        vectorDistanceThreshold_ = 0D;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.VertexRagServiceProto
            .internal_static_google_cloud_aiplatform_v1_RetrieveContextsRequest_VertexRagStore_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore build() {
        com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore buildPartial() {
        com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore result =
            new com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore result) {
        if (ragResourcesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            ragResources_ = java.util.Collections.unmodifiableList(ragResources_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.ragResources_ = ragResources_;
        } else {
          result.ragResources_ = ragResourcesBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.vectorDistanceThreshold_ = vectorDistanceThreshold_;
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore other) {
        if (other
            == com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
                .getDefaultInstance()) return this;
        if (ragResourcesBuilder_ == null) {
          if (!other.ragResources_.isEmpty()) {
            if (ragResources_.isEmpty()) {
              ragResources_ = other.ragResources_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureRagResourcesIsMutable();
              ragResources_.addAll(other.ragResources_);
            }
            onChanged();
          }
        } else {
          if (!other.ragResources_.isEmpty()) {
            if (ragResourcesBuilder_.isEmpty()) {
              ragResourcesBuilder_.dispose();
              ragResourcesBuilder_ = null;
              ragResources_ = other.ragResources_;
              bitField0_ = (bitField0_ & ~0x00000001);
              ragResourcesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getRagResourcesFieldBuilder()
                      : null;
            } else {
              ragResourcesBuilder_.addAllMessages(other.ragResources_);
            }
          }
        }
        if (other.hasVectorDistanceThreshold()) {
          setVectorDistanceThreshold(other.getVectorDistanceThreshold());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 17:
                {
                  vectorDistanceThreshold_ = input.readDouble();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 17
              case 26:
                {
                  com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
                      m =
                          input.readMessage(
                              com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
                                  .RagResource.parser(),
                              extensionRegistry);
                  if (ragResourcesBuilder_ == null) {
                    ensureRagResourcesIsMutable();
                    ragResources_.add(m);
                  } else {
                    ragResourcesBuilder_.addMessage(m);
                  }
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<
              com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource>
          ragResources_ = java.util.Collections.emptyList();

      private void ensureRagResourcesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          ragResources_ =
              new java.util.ArrayList<
                  com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
                      .RagResource>(ragResources_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource,
              com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
                  .Builder,
              com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
                  .RagResourceOrBuilder>
          ragResourcesBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. The representation of the rag source. It can be used to specify
       * corpus only or ragfiles. Currently only support one corpus or multiple
       * files from one corpus. In the future we may open up multiple corpora
       * support.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource>
          getRagResourcesList() {
        if (ragResourcesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(ragResources_);
        } else {
          return ragResourcesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The representation of the rag source. It can be used to specify
       * corpus only or ragfiles. Currently only support one corpus or multiple
       * files from one corpus. In the future we may open up multiple corpora
       * support.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public int getRagResourcesCount() {
        if (ragResourcesBuilder_ == null) {
          return ragResources_.size();
        } else {
          return ragResourcesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The representation of the rag source. It can be used to specify
       * corpus only or ragfiles. Currently only support one corpus or multiple
       * files from one corpus. In the future we may open up multiple corpora
       * support.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
          getRagResources(int index) {
        if (ragResourcesBuilder_ == null) {
          return ragResources_.get(index);
        } else {
          return ragResourcesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The representation of the rag source. It can be used to specify
       * corpus only or ragfiles. Currently only support one corpus or multiple
       * files from one corpus. In the future we may open up multiple corpora
       * support.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setRagResources(
          int index,
          com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource value) {
        if (ragResourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRagResourcesIsMutable();
          ragResources_.set(index, value);
          onChanged();
        } else {
          ragResourcesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The representation of the rag source. It can be used to specify
       * corpus only or ragfiles. Currently only support one corpus or multiple
       * files from one corpus. In the future we may open up multiple corpora
       * support.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setRagResources(
          int index,
          com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource.Builder
              builderForValue) {
        if (ragResourcesBuilder_ == null) {
          ensureRagResourcesIsMutable();
          ragResources_.set(index, builderForValue.build());
          onChanged();
        } else {
          ragResourcesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The representation of the rag source. It can be used to specify
       * corpus only or ragfiles. Currently only support one corpus or multiple
       * files from one corpus. In the future we may open up multiple corpora
       * support.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addRagResources(
          com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource value) {
        if (ragResourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRagResourcesIsMutable();
          ragResources_.add(value);
          onChanged();
        } else {
          ragResourcesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The representation of the rag source. It can be used to specify
       * corpus only or ragfiles. Currently only support one corpus or multiple
       * files from one corpus. In the future we may open up multiple corpora
       * support.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addRagResources(
          int index,
          com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource value) {
        if (ragResourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRagResourcesIsMutable();
          ragResources_.add(index, value);
          onChanged();
        } else {
          ragResourcesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The representation of the rag source. It can be used to specify
       * corpus only or ragfiles. Currently only support one corpus or multiple
       * files from one corpus. In the future we may open up multiple corpora
       * support.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addRagResources(
          com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource.Builder
              builderForValue) {
        if (ragResourcesBuilder_ == null) {
          ensureRagResourcesIsMutable();
          ragResources_.add(builderForValue.build());
          onChanged();
        } else {
          ragResourcesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The representation of the rag source. It can be used to specify
       * corpus only or ragfiles. Currently only support one corpus or multiple
       * files from one corpus. In the future we may open up multiple corpora
       * support.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addRagResources(
          int index,
          com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource.Builder
              builderForValue) {
        if (ragResourcesBuilder_ == null) {
          ensureRagResourcesIsMutable();
          ragResources_.add(index, builderForValue.build());
          onChanged();
        } else {
          ragResourcesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The representation of the rag source. It can be used to specify
       * corpus only or ragfiles. Currently only support one corpus or multiple
       * files from one corpus. In the future we may open up multiple corpora
       * support.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAllRagResources(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
                          .RagResource>
              values) {
        if (ragResourcesBuilder_ == null) {
          ensureRagResourcesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ragResources_);
          onChanged();
        } else {
          ragResourcesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The representation of the rag source. It can be used to specify
       * corpus only or ragfiles. Currently only support one corpus or multiple
       * files from one corpus. In the future we may open up multiple corpora
       * support.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearRagResources() {
        if (ragResourcesBuilder_ == null) {
          ragResources_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          ragResourcesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The representation of the rag source. It can be used to specify
       * corpus only or ragfiles. Currently only support one corpus or multiple
       * files from one corpus. In the future we may open up multiple corpora
       * support.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeRagResources(int index) {
        if (ragResourcesBuilder_ == null) {
          ensureRagResourcesIsMutable();
          ragResources_.remove(index);
          onChanged();
        } else {
          ragResourcesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The representation of the rag source. It can be used to specify
       * corpus only or ragfiles. Currently only support one corpus or multiple
       * files from one corpus. In the future we may open up multiple corpora
       * support.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
              .Builder
          getRagResourcesBuilder(int index) {
        return getRagResourcesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. The representation of the rag source. It can be used to specify
       * corpus only or ragfiles. Currently only support one corpus or multiple
       * files from one corpus. In the future we may open up multiple corpora
       * support.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
              .RagResourceOrBuilder
          getRagResourcesOrBuilder(int index) {
        if (ragResourcesBuilder_ == null) {
          return ragResources_.get(index);
        } else {
          return ragResourcesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The representation of the rag source. It can be used to specify
       * corpus only or ragfiles. Currently only support one corpus or multiple
       * files from one corpus. In the future we may open up multiple corpora
       * support.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
                      .RagResourceOrBuilder>
          getRagResourcesOrBuilderList() {
        if (ragResourcesBuilder_ != null) {
          return ragResourcesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(ragResources_);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The representation of the rag source. It can be used to specify
       * corpus only or ragfiles. Currently only support one corpus or multiple
       * files from one corpus. In the future we may open up multiple corpora
       * support.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
              .Builder
          addRagResourcesBuilder() {
        return getRagResourcesFieldBuilder()
            .addBuilder(
                com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. The representation of the rag source. It can be used to specify
       * corpus only or ragfiles. Currently only support one corpus or multiple
       * files from one corpus. In the future we may open up multiple corpora
       * support.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
              .Builder
          addRagResourcesBuilder(int index) {
        return getRagResourcesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. The representation of the rag source. It can be used to specify
       * corpus only or ragfiles. Currently only support one corpus or multiple
       * files from one corpus. In the future we may open up multiple corpora
       * support.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource rag_resources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
                  .Builder>
          getRagResourcesBuilderList() {
        return getRagResourcesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource,
              com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
                  .Builder,
              com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
                  .RagResourceOrBuilder>
          getRagResourcesFieldBuilder() {
        if (ragResourcesBuilder_ == null) {
          ragResourcesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource,
                  com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
                      .Builder,
                  com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
                      .RagResourceOrBuilder>(
                  ragResources_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          ragResources_ = null;
        }
        return ragResourcesBuilder_;
      }

      private double vectorDistanceThreshold_;
      /**
       *
       *
       * <pre>
       * Optional. Only return contexts with vector distance smaller than the
       * threshold.
       * </pre>
       *
       * <code>
       * optional double vector_distance_threshold = 2 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @deprecated
       *     google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.vector_distance_threshold
       *     is deprecated. See google/cloud/aiplatform/v1/vertex_rag_service.proto;l=117
       * @return Whether the vectorDistanceThreshold field is set.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public boolean hasVectorDistanceThreshold() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Only return contexts with vector distance smaller than the
       * threshold.
       * </pre>
       *
       * <code>
       * optional double vector_distance_threshold = 2 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @deprecated
       *     google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.vector_distance_threshold
       *     is deprecated. See google/cloud/aiplatform/v1/vertex_rag_service.proto;l=117
       * @return The vectorDistanceThreshold.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public double getVectorDistanceThreshold() {
        return vectorDistanceThreshold_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Only return contexts with vector distance smaller than the
       * threshold.
       * </pre>
       *
       * <code>
       * optional double vector_distance_threshold = 2 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @deprecated
       *     google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.vector_distance_threshold
       *     is deprecated. See google/cloud/aiplatform/v1/vertex_rag_service.proto;l=117
       * @param value The vectorDistanceThreshold to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setVectorDistanceThreshold(double value) {

        vectorDistanceThreshold_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Only return contexts with vector distance smaller than the
       * threshold.
       * </pre>
       *
       * <code>
       * optional double vector_distance_threshold = 2 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @deprecated
       *     google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.vector_distance_threshold
       *     is deprecated. See google/cloud/aiplatform/v1/vertex_rag_service.proto;l=117
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearVectorDistanceThreshold() {
        bitField0_ = (bitField0_ & ~0x00000002);
        vectorDistanceThreshold_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore)
    private static final com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore();
    }

    public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<VertexRagStore> PARSER =
        new com.google.protobuf.AbstractParser<VertexRagStore>() {
          @java.lang.Override
          public VertexRagStore parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<VertexRagStore> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<VertexRagStore> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int dataSourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object dataSource_;

  public enum DataSourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    VERTEX_RAG_STORE(2),
    DATASOURCE_NOT_SET(0);
    private final int value;

    private DataSourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataSourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static DataSourceCase forNumber(int value) {
      switch (value) {
        case 2:
          return VERTEX_RAG_STORE;
        case 0:
          return DATASOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DataSourceCase getDataSourceCase() {
    return DataSourceCase.forNumber(dataSourceCase_);
  }

  public static final int VERTEX_RAG_STORE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The data source for Vertex RagStore.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore vertex_rag_store = 2;
   * </code>
   *
   * @return Whether the vertexRagStore field is set.
   */
  @java.lang.Override
  public boolean hasVertexRagStore() {
    return dataSourceCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The data source for Vertex RagStore.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore vertex_rag_store = 2;
   * </code>
   *
   * @return The vertexRagStore.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore getVertexRagStore() {
    if (dataSourceCase_ == 2) {
      return (com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore) dataSource_;
    }
    return com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The data source for Vertex RagStore.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore vertex_rag_store = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStoreOrBuilder
      getVertexRagStoreOrBuilder() {
    if (dataSourceCase_ == 2) {
      return (com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore) dataSource_;
    }
    return com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
        .getDefaultInstance();
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location from which to retrieve
   * RagContexts. The users must have permission to make a call in the project.
   * Format:
   * `projects/{project}/locations/{location}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location from which to retrieve
   * RagContexts. The users must have permission to make a call in the project.
   * Format:
   * `projects/{project}/locations/{location}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_FIELD_NUMBER = 3;
  private com.google.cloud.aiplatform.v1.RagQuery query_;
  /**
   *
   *
   * <pre>
   * Required. Single RAG retrieve query.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.RagQuery query = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the query field is set.
   */
  @java.lang.Override
  public boolean hasQuery() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Single RAG retrieve query.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.RagQuery query = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The query.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagQuery getQuery() {
    return query_ == null ? com.google.cloud.aiplatform.v1.RagQuery.getDefaultInstance() : query_;
  }
  /**
   *
   *
   * <pre>
   * Required. Single RAG retrieve query.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.RagQuery query = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagQueryOrBuilder getQueryOrBuilder() {
    return query_ == null ? com.google.cloud.aiplatform.v1.RagQuery.getDefaultInstance() : query_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (dataSourceCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore) dataSource_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getQuery());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (dataSourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore) dataSource_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getQuery());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.RetrieveContextsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.RetrieveContextsRequest other =
        (com.google.cloud.aiplatform.v1.RetrieveContextsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasQuery() != other.hasQuery()) return false;
    if (hasQuery()) {
      if (!getQuery().equals(other.getQuery())) return false;
    }
    if (!getDataSourceCase().equals(other.getDataSourceCase())) return false;
    switch (dataSourceCase_) {
      case 2:
        if (!getVertexRagStore().equals(other.getVertexRagStore())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasQuery()) {
      hash = (37 * hash) + QUERY_FIELD_NUMBER;
      hash = (53 * hash) + getQuery().hashCode();
    }
    switch (dataSourceCase_) {
      case 2:
        hash = (37 * hash) + VERTEX_RAG_STORE_FIELD_NUMBER;
        hash = (53 * hash) + getVertexRagStore().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1.RetrieveContextsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [VertexRagService.RetrieveContexts][google.cloud.aiplatform.v1.VertexRagService.RetrieveContexts].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.RetrieveContextsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.RetrieveContextsRequest)
      com.google.cloud.aiplatform.v1.RetrieveContextsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.VertexRagServiceProto
          .internal_static_google_cloud_aiplatform_v1_RetrieveContextsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.VertexRagServiceProto
          .internal_static_google_cloud_aiplatform_v1_RetrieveContextsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.RetrieveContextsRequest.class,
              com.google.cloud.aiplatform.v1.RetrieveContextsRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.RetrieveContextsRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getQueryFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (vertexRagStoreBuilder_ != null) {
        vertexRagStoreBuilder_.clear();
      }
      parent_ = "";
      query_ = null;
      if (queryBuilder_ != null) {
        queryBuilder_.dispose();
        queryBuilder_ = null;
      }
      dataSourceCase_ = 0;
      dataSource_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.VertexRagServiceProto
          .internal_static_google_cloud_aiplatform_v1_RetrieveContextsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RetrieveContextsRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.RetrieveContextsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RetrieveContextsRequest build() {
      com.google.cloud.aiplatform.v1.RetrieveContextsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RetrieveContextsRequest buildPartial() {
      com.google.cloud.aiplatform.v1.RetrieveContextsRequest result =
          new com.google.cloud.aiplatform.v1.RetrieveContextsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.RetrieveContextsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.parent_ = parent_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.query_ = queryBuilder_ == null ? query_ : queryBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1.RetrieveContextsRequest result) {
      result.dataSourceCase_ = dataSourceCase_;
      result.dataSource_ = this.dataSource_;
      if (dataSourceCase_ == 2 && vertexRagStoreBuilder_ != null) {
        result.dataSource_ = vertexRagStoreBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.RetrieveContextsRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1.RetrieveContextsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.RetrieveContextsRequest other) {
      if (other == com.google.cloud.aiplatform.v1.RetrieveContextsRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasQuery()) {
        mergeQuery(other.getQuery());
      }
      switch (other.getDataSourceCase()) {
        case VERTEX_RAG_STORE:
          {
            mergeVertexRagStore(other.getVertexRagStore());
            break;
          }
        case DATASOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getVertexRagStoreFieldBuilder().getBuilder(), extensionRegistry);
                dataSourceCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getQueryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int dataSourceCase_ = 0;
    private java.lang.Object dataSource_;

    public DataSourceCase getDataSourceCase() {
      return DataSourceCase.forNumber(dataSourceCase_);
    }

    public Builder clearDataSource() {
      dataSourceCase_ = 0;
      dataSource_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore,
            com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.Builder,
            com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStoreOrBuilder>
        vertexRagStoreBuilder_;
    /**
     *
     *
     * <pre>
     * The data source for Vertex RagStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore vertex_rag_store = 2;
     * </code>
     *
     * @return Whether the vertexRagStore field is set.
     */
    @java.lang.Override
    public boolean hasVertexRagStore() {
      return dataSourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The data source for Vertex RagStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore vertex_rag_store = 2;
     * </code>
     *
     * @return The vertexRagStore.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
        getVertexRagStore() {
      if (vertexRagStoreBuilder_ == null) {
        if (dataSourceCase_ == 2) {
          return (com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore)
              dataSource_;
        }
        return com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
            .getDefaultInstance();
      } else {
        if (dataSourceCase_ == 2) {
          return vertexRagStoreBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The data source for Vertex RagStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore vertex_rag_store = 2;
     * </code>
     */
    public Builder setVertexRagStore(
        com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore value) {
      if (vertexRagStoreBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataSource_ = value;
        onChanged();
      } else {
        vertexRagStoreBuilder_.setMessage(value);
      }
      dataSourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data source for Vertex RagStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore vertex_rag_store = 2;
     * </code>
     */
    public Builder setVertexRagStore(
        com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.Builder
            builderForValue) {
      if (vertexRagStoreBuilder_ == null) {
        dataSource_ = builderForValue.build();
        onChanged();
      } else {
        vertexRagStoreBuilder_.setMessage(builderForValue.build());
      }
      dataSourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data source for Vertex RagStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore vertex_rag_store = 2;
     * </code>
     */
    public Builder mergeVertexRagStore(
        com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore value) {
      if (vertexRagStoreBuilder_ == null) {
        if (dataSourceCase_ == 2
            && dataSource_
                != com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
                    .getDefaultInstance()) {
          dataSource_ =
              com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.newBuilder(
                      (com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore)
                          dataSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dataSource_ = value;
        }
        onChanged();
      } else {
        if (dataSourceCase_ == 2) {
          vertexRagStoreBuilder_.mergeFrom(value);
        } else {
          vertexRagStoreBuilder_.setMessage(value);
        }
      }
      dataSourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data source for Vertex RagStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore vertex_rag_store = 2;
     * </code>
     */
    public Builder clearVertexRagStore() {
      if (vertexRagStoreBuilder_ == null) {
        if (dataSourceCase_ == 2) {
          dataSourceCase_ = 0;
          dataSource_ = null;
          onChanged();
        }
      } else {
        if (dataSourceCase_ == 2) {
          dataSourceCase_ = 0;
          dataSource_ = null;
        }
        vertexRagStoreBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data source for Vertex RagStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore vertex_rag_store = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.Builder
        getVertexRagStoreBuilder() {
      return getVertexRagStoreFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The data source for Vertex RagStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore vertex_rag_store = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStoreOrBuilder
        getVertexRagStoreOrBuilder() {
      if ((dataSourceCase_ == 2) && (vertexRagStoreBuilder_ != null)) {
        return vertexRagStoreBuilder_.getMessageOrBuilder();
      } else {
        if (dataSourceCase_ == 2) {
          return (com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore)
              dataSource_;
        }
        return com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The data source for Vertex RagStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore vertex_rag_store = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore,
            com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.Builder,
            com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStoreOrBuilder>
        getVertexRagStoreFieldBuilder() {
      if (vertexRagStoreBuilder_ == null) {
        if (!(dataSourceCase_ == 2)) {
          dataSource_ =
              com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
                  .getDefaultInstance();
        }
        vertexRagStoreBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore,
                com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.Builder,
                com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStoreOrBuilder>(
                (com.google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore) dataSource_,
                getParentForChildren(),
                isClean());
        dataSource_ = null;
      }
      dataSourceCase_ = 2;
      onChanged();
      return vertexRagStoreBuilder_;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location from which to retrieve
     * RagContexts. The users must have permission to make a call in the project.
     * Format:
     * `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location from which to retrieve
     * RagContexts. The users must have permission to make a call in the project.
     * Format:
     * `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location from which to retrieve
     * RagContexts. The users must have permission to make a call in the project.
     * Format:
     * `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location from which to retrieve
     * RagContexts. The users must have permission to make a call in the project.
     * Format:
     * `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location from which to retrieve
     * RagContexts. The users must have permission to make a call in the project.
     * Format:
     * `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.RagQuery query_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RagQuery,
            com.google.cloud.aiplatform.v1.RagQuery.Builder,
            com.google.cloud.aiplatform.v1.RagQueryOrBuilder>
        queryBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Single RAG retrieve query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagQuery query = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the query field is set.
     */
    public boolean hasQuery() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Single RAG retrieve query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagQuery query = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The query.
     */
    public com.google.cloud.aiplatform.v1.RagQuery getQuery() {
      if (queryBuilder_ == null) {
        return query_ == null
            ? com.google.cloud.aiplatform.v1.RagQuery.getDefaultInstance()
            : query_;
      } else {
        return queryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Single RAG retrieve query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagQuery query = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setQuery(com.google.cloud.aiplatform.v1.RagQuery value) {
      if (queryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        query_ = value;
      } else {
        queryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Single RAG retrieve query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagQuery query = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setQuery(com.google.cloud.aiplatform.v1.RagQuery.Builder builderForValue) {
      if (queryBuilder_ == null) {
        query_ = builderForValue.build();
      } else {
        queryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Single RAG retrieve query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagQuery query = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeQuery(com.google.cloud.aiplatform.v1.RagQuery value) {
      if (queryBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && query_ != null
            && query_ != com.google.cloud.aiplatform.v1.RagQuery.getDefaultInstance()) {
          getQueryBuilder().mergeFrom(value);
        } else {
          query_ = value;
        }
      } else {
        queryBuilder_.mergeFrom(value);
      }
      if (query_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Single RAG retrieve query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagQuery query = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearQuery() {
      bitField0_ = (bitField0_ & ~0x00000004);
      query_ = null;
      if (queryBuilder_ != null) {
        queryBuilder_.dispose();
        queryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Single RAG retrieve query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagQuery query = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.RagQuery.Builder getQueryBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getQueryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Single RAG retrieve query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagQuery query = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.RagQueryOrBuilder getQueryOrBuilder() {
      if (queryBuilder_ != null) {
        return queryBuilder_.getMessageOrBuilder();
      } else {
        return query_ == null
            ? com.google.cloud.aiplatform.v1.RagQuery.getDefaultInstance()
            : query_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Single RAG retrieve query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagQuery query = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RagQuery,
            com.google.cloud.aiplatform.v1.RagQuery.Builder,
            com.google.cloud.aiplatform.v1.RagQueryOrBuilder>
        getQueryFieldBuilder() {
      if (queryBuilder_ == null) {
        queryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.RagQuery,
                com.google.cloud.aiplatform.v1.RagQuery.Builder,
                com.google.cloud.aiplatform.v1.RagQueryOrBuilder>(
                getQuery(), getParentForChildren(), isClean());
        query_ = null;
      }
      return queryBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.RetrieveContextsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.RetrieveContextsRequest)
  private static final com.google.cloud.aiplatform.v1.RetrieveContextsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.RetrieveContextsRequest();
  }

  public static com.google.cloud.aiplatform.v1.RetrieveContextsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RetrieveContextsRequest> PARSER =
      new com.google.protobuf.AbstractParser<RetrieveContextsRequest>() {
        @java.lang.Override
        public RetrieveContextsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RetrieveContextsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RetrieveContextsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RetrieveContextsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
