/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/index.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * A datapoint of Index.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.IndexDatapoint}
 */
public final class IndexDatapoint extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.IndexDatapoint)
    IndexDatapointOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use IndexDatapoint.newBuilder() to construct.
  private IndexDatapoint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private IndexDatapoint() {
    datapointId_ = "";
    featureVector_ = emptyFloatList();
    restricts_ = java.util.Collections.emptyList();
    numericRestricts_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new IndexDatapoint();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.IndexProto
        .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.IndexProto
        .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.IndexDatapoint.class,
            com.google.cloud.aiplatform.v1.IndexDatapoint.Builder.class);
  }

  public interface SparseEmbeddingOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The list of embedding values of the sparse vector.
     * </pre>
     *
     * <code>repeated float values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the values.
     */
    java.util.List<java.lang.Float> getValuesList();
    /**
     *
     *
     * <pre>
     * Required. The list of embedding values of the sparse vector.
     * </pre>
     *
     * <code>repeated float values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of values.
     */
    int getValuesCount();
    /**
     *
     *
     * <pre>
     * Required. The list of embedding values of the sparse vector.
     * </pre>
     *
     * <code>repeated float values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The values at the given index.
     */
    float getValues(int index);

    /**
     *
     *
     * <pre>
     * Required. The list of indexes for the embedding values of the sparse
     * vector.
     * </pre>
     *
     * <code>repeated int64 dimensions = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the dimensions.
     */
    java.util.List<java.lang.Long> getDimensionsList();
    /**
     *
     *
     * <pre>
     * Required. The list of indexes for the embedding values of the sparse
     * vector.
     * </pre>
     *
     * <code>repeated int64 dimensions = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of dimensions.
     */
    int getDimensionsCount();
    /**
     *
     *
     * <pre>
     * Required. The list of indexes for the embedding values of the sparse
     * vector.
     * </pre>
     *
     * <code>repeated int64 dimensions = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The dimensions at the given index.
     */
    long getDimensions(int index);
  }
  /**
   *
   *
   * <pre>
   * Feature embedding vector for sparse index. An array of numbers whose values
   * are located in the specified dimensions.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding}
   */
  public static final class SparseEmbedding extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding)
      SparseEmbeddingOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SparseEmbedding.newBuilder() to construct.
    private SparseEmbedding(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SparseEmbedding() {
      values_ = emptyFloatList();
      dimensions_ = emptyLongList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SparseEmbedding();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.IndexProto
          .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_SparseEmbedding_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.IndexProto
          .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_SparseEmbedding_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding.class,
              com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding.Builder.class);
    }

    public static final int VALUES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.Internal.FloatList values_ = emptyFloatList();
    /**
     *
     *
     * <pre>
     * Required. The list of embedding values of the sparse vector.
     * </pre>
     *
     * <code>repeated float values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the values.
     */
    @java.lang.Override
    public java.util.List<java.lang.Float> getValuesList() {
      return values_;
    }
    /**
     *
     *
     * <pre>
     * Required. The list of embedding values of the sparse vector.
     * </pre>
     *
     * <code>repeated float values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of values.
     */
    public int getValuesCount() {
      return values_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. The list of embedding values of the sparse vector.
     * </pre>
     *
     * <code>repeated float values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The values at the given index.
     */
    public float getValues(int index) {
      return values_.getFloat(index);
    }

    private int valuesMemoizedSerializedSize = -1;

    public static final int DIMENSIONS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.Internal.LongList dimensions_ = emptyLongList();
    /**
     *
     *
     * <pre>
     * Required. The list of indexes for the embedding values of the sparse
     * vector.
     * </pre>
     *
     * <code>repeated int64 dimensions = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the dimensions.
     */
    @java.lang.Override
    public java.util.List<java.lang.Long> getDimensionsList() {
      return dimensions_;
    }
    /**
     *
     *
     * <pre>
     * Required. The list of indexes for the embedding values of the sparse
     * vector.
     * </pre>
     *
     * <code>repeated int64 dimensions = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of dimensions.
     */
    public int getDimensionsCount() {
      return dimensions_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. The list of indexes for the embedding values of the sparse
     * vector.
     * </pre>
     *
     * <code>repeated int64 dimensions = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The dimensions at the given index.
     */
    public long getDimensions(int index) {
      return dimensions_.getLong(index);
    }

    private int dimensionsMemoizedSerializedSize = -1;

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      if (getValuesList().size() > 0) {
        output.writeUInt32NoTag(10);
        output.writeUInt32NoTag(valuesMemoizedSerializedSize);
      }
      for (int i = 0; i < values_.size(); i++) {
        output.writeFloatNoTag(values_.getFloat(i));
      }
      if (getDimensionsList().size() > 0) {
        output.writeUInt32NoTag(18);
        output.writeUInt32NoTag(dimensionsMemoizedSerializedSize);
      }
      for (int i = 0; i < dimensions_.size(); i++) {
        output.writeInt64NoTag(dimensions_.getLong(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        dataSize = 4 * getValuesList().size();
        size += dataSize;
        if (!getValuesList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
        }
        valuesMemoizedSerializedSize = dataSize;
      }
      {
        int dataSize = 0;
        for (int i = 0; i < dimensions_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeInt64SizeNoTag(dimensions_.getLong(i));
        }
        size += dataSize;
        if (!getDimensionsList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
        }
        dimensionsMemoizedSerializedSize = dataSize;
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding other =
          (com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding) obj;

      if (!getValuesList().equals(other.getValuesList())) return false;
      if (!getDimensionsList().equals(other.getDimensionsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getValuesCount() > 0) {
        hash = (37 * hash) + VALUES_FIELD_NUMBER;
        hash = (53 * hash) + getValuesList().hashCode();
      }
      if (getDimensionsCount() > 0) {
        hash = (37 * hash) + DIMENSIONS_FIELD_NUMBER;
        hash = (53 * hash) + getDimensionsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Feature embedding vector for sparse index. An array of numbers whose values
     * are located in the specified dimensions.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding)
        com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbeddingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.IndexProto
            .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_SparseEmbedding_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.IndexProto
            .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_SparseEmbedding_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding.class,
                com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        values_ = emptyFloatList();
        dimensions_ = emptyLongList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.IndexProto
            .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_SparseEmbedding_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding build() {
        com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding buildPartial() {
        com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding result =
            new com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          values_.makeImmutable();
          result.values_ = values_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          dimensions_.makeImmutable();
          result.dimensions_ = dimensions_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding) {
          return mergeFrom((com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding other) {
        if (other
            == com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding.getDefaultInstance())
          return this;
        if (!other.values_.isEmpty()) {
          if (values_.isEmpty()) {
            values_ = other.values_;
            values_.makeImmutable();
            bitField0_ |= 0x00000001;
          } else {
            ensureValuesIsMutable();
            values_.addAll(other.values_);
          }
          onChanged();
        }
        if (!other.dimensions_.isEmpty()) {
          if (dimensions_.isEmpty()) {
            dimensions_ = other.dimensions_;
            dimensions_.makeImmutable();
            bitField0_ |= 0x00000002;
          } else {
            ensureDimensionsIsMutable();
            dimensions_.addAll(other.dimensions_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 13:
                {
                  float v = input.readFloat();
                  ensureValuesIsMutable();
                  values_.addFloat(v);
                  break;
                } // case 13
              case 10:
                {
                  int length = input.readRawVarint32();
                  int limit = input.pushLimit(length);
                  int alloc = length > 4096 ? 4096 : length;
                  ensureValuesIsMutable(alloc / 4);
                  while (input.getBytesUntilLimit() > 0) {
                    values_.addFloat(input.readFloat());
                  }
                  input.popLimit(limit);
                  break;
                } // case 10
              case 16:
                {
                  long v = input.readInt64();
                  ensureDimensionsIsMutable();
                  dimensions_.addLong(v);
                  break;
                } // case 16
              case 18:
                {
                  int length = input.readRawVarint32();
                  int limit = input.pushLimit(length);
                  ensureDimensionsIsMutable();
                  while (input.getBytesUntilLimit() > 0) {
                    dimensions_.addLong(input.readInt64());
                  }
                  input.popLimit(limit);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Internal.FloatList values_ = emptyFloatList();

      private void ensureValuesIsMutable() {
        if (!values_.isModifiable()) {
          values_ = makeMutableCopy(values_);
        }
        bitField0_ |= 0x00000001;
      }

      private void ensureValuesIsMutable(int capacity) {
        if (!values_.isModifiable()) {
          values_ = makeMutableCopy(values_, capacity);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of embedding values of the sparse vector.
       * </pre>
       *
       * <code>repeated float values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return A list containing the values.
       */
      public java.util.List<java.lang.Float> getValuesList() {
        values_.makeImmutable();
        return values_;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of embedding values of the sparse vector.
       * </pre>
       *
       * <code>repeated float values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The count of values.
       */
      public int getValuesCount() {
        return values_.size();
      }
      /**
       *
       *
       * <pre>
       * Required. The list of embedding values of the sparse vector.
       * </pre>
       *
       * <code>repeated float values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the element to return.
       * @return The values at the given index.
       */
      public float getValues(int index) {
        return values_.getFloat(index);
      }
      /**
       *
       *
       * <pre>
       * Required. The list of embedding values of the sparse vector.
       * </pre>
       *
       * <code>repeated float values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index to set the value at.
       * @param value The values to set.
       * @return This builder for chaining.
       */
      public Builder setValues(int index, float value) {

        ensureValuesIsMutable();
        values_.setFloat(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of embedding values of the sparse vector.
       * </pre>
       *
       * <code>repeated float values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The values to add.
       * @return This builder for chaining.
       */
      public Builder addValues(float value) {

        ensureValuesIsMutable();
        values_.addFloat(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of embedding values of the sparse vector.
       * </pre>
       *
       * <code>repeated float values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param values The values to add.
       * @return This builder for chaining.
       */
      public Builder addAllValues(java.lang.Iterable<? extends java.lang.Float> values) {
        ensureValuesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of embedding values of the sparse vector.
       * </pre>
       *
       * <code>repeated float values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValues() {
        values_ = emptyFloatList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      private com.google.protobuf.Internal.LongList dimensions_ = emptyLongList();

      private void ensureDimensionsIsMutable() {
        if (!dimensions_.isModifiable()) {
          dimensions_ = makeMutableCopy(dimensions_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of indexes for the embedding values of the sparse
       * vector.
       * </pre>
       *
       * <code>repeated int64 dimensions = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return A list containing the dimensions.
       */
      public java.util.List<java.lang.Long> getDimensionsList() {
        dimensions_.makeImmutable();
        return dimensions_;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of indexes for the embedding values of the sparse
       * vector.
       * </pre>
       *
       * <code>repeated int64 dimensions = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The count of dimensions.
       */
      public int getDimensionsCount() {
        return dimensions_.size();
      }
      /**
       *
       *
       * <pre>
       * Required. The list of indexes for the embedding values of the sparse
       * vector.
       * </pre>
       *
       * <code>repeated int64 dimensions = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the element to return.
       * @return The dimensions at the given index.
       */
      public long getDimensions(int index) {
        return dimensions_.getLong(index);
      }
      /**
       *
       *
       * <pre>
       * Required. The list of indexes for the embedding values of the sparse
       * vector.
       * </pre>
       *
       * <code>repeated int64 dimensions = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index to set the value at.
       * @param value The dimensions to set.
       * @return This builder for chaining.
       */
      public Builder setDimensions(int index, long value) {

        ensureDimensionsIsMutable();
        dimensions_.setLong(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of indexes for the embedding values of the sparse
       * vector.
       * </pre>
       *
       * <code>repeated int64 dimensions = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The dimensions to add.
       * @return This builder for chaining.
       */
      public Builder addDimensions(long value) {

        ensureDimensionsIsMutable();
        dimensions_.addLong(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of indexes for the embedding values of the sparse
       * vector.
       * </pre>
       *
       * <code>repeated int64 dimensions = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param values The dimensions to add.
       * @return This builder for chaining.
       */
      public Builder addAllDimensions(java.lang.Iterable<? extends java.lang.Long> values) {
        ensureDimensionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dimensions_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of indexes for the embedding values of the sparse
       * vector.
       * </pre>
       *
       * <code>repeated int64 dimensions = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDimensions() {
        dimensions_ = emptyLongList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding)
    private static final com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding();
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SparseEmbedding> PARSER =
        new com.google.protobuf.AbstractParser<SparseEmbedding>() {
          @java.lang.Override
          public SparseEmbedding parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SparseEmbedding> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SparseEmbedding> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RestrictionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.IndexDatapoint.Restriction)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The namespace of this restriction. e.g.: color.
     * </pre>
     *
     * <code>string namespace = 1;</code>
     *
     * @return The namespace.
     */
    java.lang.String getNamespace();
    /**
     *
     *
     * <pre>
     * The namespace of this restriction. e.g.: color.
     * </pre>
     *
     * <code>string namespace = 1;</code>
     *
     * @return The bytes for namespace.
     */
    com.google.protobuf.ByteString getNamespaceBytes();

    /**
     *
     *
     * <pre>
     * The attributes to allow in this namespace. e.g.: 'red'
     * </pre>
     *
     * <code>repeated string allow_list = 2;</code>
     *
     * @return A list containing the allowList.
     */
    java.util.List<java.lang.String> getAllowListList();
    /**
     *
     *
     * <pre>
     * The attributes to allow in this namespace. e.g.: 'red'
     * </pre>
     *
     * <code>repeated string allow_list = 2;</code>
     *
     * @return The count of allowList.
     */
    int getAllowListCount();
    /**
     *
     *
     * <pre>
     * The attributes to allow in this namespace. e.g.: 'red'
     * </pre>
     *
     * <code>repeated string allow_list = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The allowList at the given index.
     */
    java.lang.String getAllowList(int index);
    /**
     *
     *
     * <pre>
     * The attributes to allow in this namespace. e.g.: 'red'
     * </pre>
     *
     * <code>repeated string allow_list = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allowList at the given index.
     */
    com.google.protobuf.ByteString getAllowListBytes(int index);

    /**
     *
     *
     * <pre>
     * The attributes to deny in this namespace. e.g.: 'blue'
     * </pre>
     *
     * <code>repeated string deny_list = 3;</code>
     *
     * @return A list containing the denyList.
     */
    java.util.List<java.lang.String> getDenyListList();
    /**
     *
     *
     * <pre>
     * The attributes to deny in this namespace. e.g.: 'blue'
     * </pre>
     *
     * <code>repeated string deny_list = 3;</code>
     *
     * @return The count of denyList.
     */
    int getDenyListCount();
    /**
     *
     *
     * <pre>
     * The attributes to deny in this namespace. e.g.: 'blue'
     * </pre>
     *
     * <code>repeated string deny_list = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The denyList at the given index.
     */
    java.lang.String getDenyList(int index);
    /**
     *
     *
     * <pre>
     * The attributes to deny in this namespace. e.g.: 'blue'
     * </pre>
     *
     * <code>repeated string deny_list = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the denyList at the given index.
     */
    com.google.protobuf.ByteString getDenyListBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Restriction of a datapoint which describe its attributes(tokens) from each
   * of several attribute categories(namespaces).
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.IndexDatapoint.Restriction}
   */
  public static final class Restriction extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.IndexDatapoint.Restriction)
      RestrictionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Restriction.newBuilder() to construct.
    private Restriction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Restriction() {
      namespace_ = "";
      allowList_ = com.google.protobuf.LazyStringArrayList.emptyList();
      denyList_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Restriction();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.IndexProto
          .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_Restriction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.IndexProto
          .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_Restriction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction.class,
              com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction.Builder.class);
    }

    public static final int NAMESPACE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object namespace_ = "";
    /**
     *
     *
     * <pre>
     * The namespace of this restriction. e.g.: color.
     * </pre>
     *
     * <code>string namespace = 1;</code>
     *
     * @return The namespace.
     */
    @java.lang.Override
    public java.lang.String getNamespace() {
      java.lang.Object ref = namespace_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        namespace_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The namespace of this restriction. e.g.: color.
     * </pre>
     *
     * <code>string namespace = 1;</code>
     *
     * @return The bytes for namespace.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNamespaceBytes() {
      java.lang.Object ref = namespace_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        namespace_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ALLOW_LIST_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList allowList_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * The attributes to allow in this namespace. e.g.: 'red'
     * </pre>
     *
     * <code>repeated string allow_list = 2;</code>
     *
     * @return A list containing the allowList.
     */
    public com.google.protobuf.ProtocolStringList getAllowListList() {
      return allowList_;
    }
    /**
     *
     *
     * <pre>
     * The attributes to allow in this namespace. e.g.: 'red'
     * </pre>
     *
     * <code>repeated string allow_list = 2;</code>
     *
     * @return The count of allowList.
     */
    public int getAllowListCount() {
      return allowList_.size();
    }
    /**
     *
     *
     * <pre>
     * The attributes to allow in this namespace. e.g.: 'red'
     * </pre>
     *
     * <code>repeated string allow_list = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The allowList at the given index.
     */
    public java.lang.String getAllowList(int index) {
      return allowList_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The attributes to allow in this namespace. e.g.: 'red'
     * </pre>
     *
     * <code>repeated string allow_list = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allowList at the given index.
     */
    public com.google.protobuf.ByteString getAllowListBytes(int index) {
      return allowList_.getByteString(index);
    }

    public static final int DENY_LIST_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList denyList_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * The attributes to deny in this namespace. e.g.: 'blue'
     * </pre>
     *
     * <code>repeated string deny_list = 3;</code>
     *
     * @return A list containing the denyList.
     */
    public com.google.protobuf.ProtocolStringList getDenyListList() {
      return denyList_;
    }
    /**
     *
     *
     * <pre>
     * The attributes to deny in this namespace. e.g.: 'blue'
     * </pre>
     *
     * <code>repeated string deny_list = 3;</code>
     *
     * @return The count of denyList.
     */
    public int getDenyListCount() {
      return denyList_.size();
    }
    /**
     *
     *
     * <pre>
     * The attributes to deny in this namespace. e.g.: 'blue'
     * </pre>
     *
     * <code>repeated string deny_list = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The denyList at the given index.
     */
    public java.lang.String getDenyList(int index) {
      return denyList_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The attributes to deny in this namespace. e.g.: 'blue'
     * </pre>
     *
     * <code>repeated string deny_list = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the denyList at the given index.
     */
    public com.google.protobuf.ByteString getDenyListBytes(int index) {
      return denyList_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(namespace_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, namespace_);
      }
      for (int i = 0; i < allowList_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, allowList_.getRaw(i));
      }
      for (int i = 0; i < denyList_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, denyList_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(namespace_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, namespace_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < allowList_.size(); i++) {
          dataSize += computeStringSizeNoTag(allowList_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAllowListList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < denyList_.size(); i++) {
          dataSize += computeStringSizeNoTag(denyList_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getDenyListList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction other =
          (com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction) obj;

      if (!getNamespace().equals(other.getNamespace())) return false;
      if (!getAllowListList().equals(other.getAllowListList())) return false;
      if (!getDenyListList().equals(other.getDenyListList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAMESPACE_FIELD_NUMBER;
      hash = (53 * hash) + getNamespace().hashCode();
      if (getAllowListCount() > 0) {
        hash = (37 * hash) + ALLOW_LIST_FIELD_NUMBER;
        hash = (53 * hash) + getAllowListList().hashCode();
      }
      if (getDenyListCount() > 0) {
        hash = (37 * hash) + DENY_LIST_FIELD_NUMBER;
        hash = (53 * hash) + getDenyListList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Restriction of a datapoint which describe its attributes(tokens) from each
     * of several attribute categories(namespaces).
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.IndexDatapoint.Restriction}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.IndexDatapoint.Restriction)
        com.google.cloud.aiplatform.v1.IndexDatapoint.RestrictionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.IndexProto
            .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_Restriction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.IndexProto
            .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_Restriction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction.class,
                com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        namespace_ = "";
        allowList_ = com.google.protobuf.LazyStringArrayList.emptyList();
        denyList_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.IndexProto
            .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_Restriction_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction build() {
        com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction buildPartial() {
        com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction result =
            new com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.namespace_ = namespace_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          allowList_.makeImmutable();
          result.allowList_ = allowList_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          denyList_.makeImmutable();
          result.denyList_ = denyList_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction) {
          return mergeFrom((com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction other) {
        if (other == com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction.getDefaultInstance())
          return this;
        if (!other.getNamespace().isEmpty()) {
          namespace_ = other.namespace_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.allowList_.isEmpty()) {
          if (allowList_.isEmpty()) {
            allowList_ = other.allowList_;
            bitField0_ |= 0x00000002;
          } else {
            ensureAllowListIsMutable();
            allowList_.addAll(other.allowList_);
          }
          onChanged();
        }
        if (!other.denyList_.isEmpty()) {
          if (denyList_.isEmpty()) {
            denyList_ = other.denyList_;
            bitField0_ |= 0x00000004;
          } else {
            ensureDenyListIsMutable();
            denyList_.addAll(other.denyList_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  namespace_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureAllowListIsMutable();
                  allowList_.add(s);
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureDenyListIsMutable();
                  denyList_.add(s);
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object namespace_ = "";
      /**
       *
       *
       * <pre>
       * The namespace of this restriction. e.g.: color.
       * </pre>
       *
       * <code>string namespace = 1;</code>
       *
       * @return The namespace.
       */
      public java.lang.String getNamespace() {
        java.lang.Object ref = namespace_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          namespace_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The namespace of this restriction. e.g.: color.
       * </pre>
       *
       * <code>string namespace = 1;</code>
       *
       * @return The bytes for namespace.
       */
      public com.google.protobuf.ByteString getNamespaceBytes() {
        java.lang.Object ref = namespace_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          namespace_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The namespace of this restriction. e.g.: color.
       * </pre>
       *
       * <code>string namespace = 1;</code>
       *
       * @param value The namespace to set.
       * @return This builder for chaining.
       */
      public Builder setNamespace(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        namespace_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The namespace of this restriction. e.g.: color.
       * </pre>
       *
       * <code>string namespace = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNamespace() {
        namespace_ = getDefaultInstance().getNamespace();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The namespace of this restriction. e.g.: color.
       * </pre>
       *
       * <code>string namespace = 1;</code>
       *
       * @param value The bytes for namespace to set.
       * @return This builder for chaining.
       */
      public Builder setNamespaceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        namespace_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList allowList_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureAllowListIsMutable() {
        if (!allowList_.isModifiable()) {
          allowList_ = new com.google.protobuf.LazyStringArrayList(allowList_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * The attributes to allow in this namespace. e.g.: 'red'
       * </pre>
       *
       * <code>repeated string allow_list = 2;</code>
       *
       * @return A list containing the allowList.
       */
      public com.google.protobuf.ProtocolStringList getAllowListList() {
        allowList_.makeImmutable();
        return allowList_;
      }
      /**
       *
       *
       * <pre>
       * The attributes to allow in this namespace. e.g.: 'red'
       * </pre>
       *
       * <code>repeated string allow_list = 2;</code>
       *
       * @return The count of allowList.
       */
      public int getAllowListCount() {
        return allowList_.size();
      }
      /**
       *
       *
       * <pre>
       * The attributes to allow in this namespace. e.g.: 'red'
       * </pre>
       *
       * <code>repeated string allow_list = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The allowList at the given index.
       */
      public java.lang.String getAllowList(int index) {
        return allowList_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The attributes to allow in this namespace. e.g.: 'red'
       * </pre>
       *
       * <code>repeated string allow_list = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the allowList at the given index.
       */
      public com.google.protobuf.ByteString getAllowListBytes(int index) {
        return allowList_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * The attributes to allow in this namespace. e.g.: 'red'
       * </pre>
       *
       * <code>repeated string allow_list = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The allowList to set.
       * @return This builder for chaining.
       */
      public Builder setAllowList(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowListIsMutable();
        allowList_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The attributes to allow in this namespace. e.g.: 'red'
       * </pre>
       *
       * <code>repeated string allow_list = 2;</code>
       *
       * @param value The allowList to add.
       * @return This builder for chaining.
       */
      public Builder addAllowList(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowListIsMutable();
        allowList_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The attributes to allow in this namespace. e.g.: 'red'
       * </pre>
       *
       * <code>repeated string allow_list = 2;</code>
       *
       * @param values The allowList to add.
       * @return This builder for chaining.
       */
      public Builder addAllAllowList(java.lang.Iterable<java.lang.String> values) {
        ensureAllowListIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowList_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The attributes to allow in this namespace. e.g.: 'red'
       * </pre>
       *
       * <code>repeated string allow_list = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllowList() {
        allowList_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The attributes to allow in this namespace. e.g.: 'red'
       * </pre>
       *
       * <code>repeated string allow_list = 2;</code>
       *
       * @param value The bytes of the allowList to add.
       * @return This builder for chaining.
       */
      public Builder addAllowListBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureAllowListIsMutable();
        allowList_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList denyList_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureDenyListIsMutable() {
        if (!denyList_.isModifiable()) {
          denyList_ = new com.google.protobuf.LazyStringArrayList(denyList_);
        }
        bitField0_ |= 0x00000004;
      }
      /**
       *
       *
       * <pre>
       * The attributes to deny in this namespace. e.g.: 'blue'
       * </pre>
       *
       * <code>repeated string deny_list = 3;</code>
       *
       * @return A list containing the denyList.
       */
      public com.google.protobuf.ProtocolStringList getDenyListList() {
        denyList_.makeImmutable();
        return denyList_;
      }
      /**
       *
       *
       * <pre>
       * The attributes to deny in this namespace. e.g.: 'blue'
       * </pre>
       *
       * <code>repeated string deny_list = 3;</code>
       *
       * @return The count of denyList.
       */
      public int getDenyListCount() {
        return denyList_.size();
      }
      /**
       *
       *
       * <pre>
       * The attributes to deny in this namespace. e.g.: 'blue'
       * </pre>
       *
       * <code>repeated string deny_list = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The denyList at the given index.
       */
      public java.lang.String getDenyList(int index) {
        return denyList_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The attributes to deny in this namespace. e.g.: 'blue'
       * </pre>
       *
       * <code>repeated string deny_list = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the denyList at the given index.
       */
      public com.google.protobuf.ByteString getDenyListBytes(int index) {
        return denyList_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * The attributes to deny in this namespace. e.g.: 'blue'
       * </pre>
       *
       * <code>repeated string deny_list = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The denyList to set.
       * @return This builder for chaining.
       */
      public Builder setDenyList(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDenyListIsMutable();
        denyList_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The attributes to deny in this namespace. e.g.: 'blue'
       * </pre>
       *
       * <code>repeated string deny_list = 3;</code>
       *
       * @param value The denyList to add.
       * @return This builder for chaining.
       */
      public Builder addDenyList(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDenyListIsMutable();
        denyList_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The attributes to deny in this namespace. e.g.: 'blue'
       * </pre>
       *
       * <code>repeated string deny_list = 3;</code>
       *
       * @param values The denyList to add.
       * @return This builder for chaining.
       */
      public Builder addAllDenyList(java.lang.Iterable<java.lang.String> values) {
        ensureDenyListIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, denyList_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The attributes to deny in this namespace. e.g.: 'blue'
       * </pre>
       *
       * <code>repeated string deny_list = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDenyList() {
        denyList_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The attributes to deny in this namespace. e.g.: 'blue'
       * </pre>
       *
       * <code>repeated string deny_list = 3;</code>
       *
       * @param value The bytes of the denyList to add.
       * @return This builder for chaining.
       */
      public Builder addDenyListBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureDenyListIsMutable();
        denyList_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.IndexDatapoint.Restriction)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.IndexDatapoint.Restriction)
    private static final com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction();
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Restriction> PARSER =
        new com.google.protobuf.AbstractParser<Restriction>() {
          @java.lang.Override
          public Restriction parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Restriction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Restriction> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface NumericRestrictionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Represents 64 bit integer.
     * </pre>
     *
     * <code>int64 value_int = 2;</code>
     *
     * @return Whether the valueInt field is set.
     */
    boolean hasValueInt();
    /**
     *
     *
     * <pre>
     * Represents 64 bit integer.
     * </pre>
     *
     * <code>int64 value_int = 2;</code>
     *
     * @return The valueInt.
     */
    long getValueInt();

    /**
     *
     *
     * <pre>
     * Represents 32 bit float.
     * </pre>
     *
     * <code>float value_float = 3;</code>
     *
     * @return Whether the valueFloat field is set.
     */
    boolean hasValueFloat();
    /**
     *
     *
     * <pre>
     * Represents 32 bit float.
     * </pre>
     *
     * <code>float value_float = 3;</code>
     *
     * @return The valueFloat.
     */
    float getValueFloat();

    /**
     *
     *
     * <pre>
     * Represents 64 bit float.
     * </pre>
     *
     * <code>double value_double = 4;</code>
     *
     * @return Whether the valueDouble field is set.
     */
    boolean hasValueDouble();
    /**
     *
     *
     * <pre>
     * Represents 64 bit float.
     * </pre>
     *
     * <code>double value_double = 4;</code>
     *
     * @return The valueDouble.
     */
    double getValueDouble();

    /**
     *
     *
     * <pre>
     * The namespace of this restriction. e.g.: cost.
     * </pre>
     *
     * <code>string namespace = 1;</code>
     *
     * @return The namespace.
     */
    java.lang.String getNamespace();
    /**
     *
     *
     * <pre>
     * The namespace of this restriction. e.g.: cost.
     * </pre>
     *
     * <code>string namespace = 1;</code>
     *
     * @return The bytes for namespace.
     */
    com.google.protobuf.ByteString getNamespaceBytes();

    /**
     *
     *
     * <pre>
     * This MUST be specified for queries and must NOT be specified for
     * datapoints.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Operator op = 5;</code>
     *
     * @return The enum numeric value on the wire for op.
     */
    int getOpValue();
    /**
     *
     *
     * <pre>
     * This MUST be specified for queries and must NOT be specified for
     * datapoints.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Operator op = 5;</code>
     *
     * @return The op.
     */
    com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Operator getOp();

    com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.ValueCase getValueCase();
  }
  /**
   *
   *
   * <pre>
   * This field allows restricts to be based on numeric comparisons rather
   * than categorical tokens.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction}
   */
  public static final class NumericRestriction extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction)
      NumericRestrictionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use NumericRestriction.newBuilder() to construct.
    private NumericRestriction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private NumericRestriction() {
      namespace_ = "";
      op_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new NumericRestriction();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.IndexProto
          .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_NumericRestriction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.IndexProto
          .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_NumericRestriction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.class,
              com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Which comparison operator to use.  Should be specified for queries only;
     * specifying this for a datapoint is an error.
     *
     * Datapoints for which Operator is true relative to the query's Value
     * field will be allowlisted.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Operator}
     */
    public enum Operator implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value of the enum.
       * </pre>
       *
       * <code>OPERATOR_UNSPECIFIED = 0;</code>
       */
      OPERATOR_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Datapoints are eligible iff their value is &lt; the query's.
       * </pre>
       *
       * <code>LESS = 1;</code>
       */
      LESS(1),
      /**
       *
       *
       * <pre>
       * Datapoints are eligible iff their value is &lt;= the query's.
       * </pre>
       *
       * <code>LESS_EQUAL = 2;</code>
       */
      LESS_EQUAL(2),
      /**
       *
       *
       * <pre>
       * Datapoints are eligible iff their value is == the query's.
       * </pre>
       *
       * <code>EQUAL = 3;</code>
       */
      EQUAL(3),
      /**
       *
       *
       * <pre>
       * Datapoints are eligible iff their value is &gt;= the query's.
       * </pre>
       *
       * <code>GREATER_EQUAL = 4;</code>
       */
      GREATER_EQUAL(4),
      /**
       *
       *
       * <pre>
       * Datapoints are eligible iff their value is &gt; the query's.
       * </pre>
       *
       * <code>GREATER = 5;</code>
       */
      GREATER(5),
      /**
       *
       *
       * <pre>
       * Datapoints are eligible iff their value is != the query's.
       * </pre>
       *
       * <code>NOT_EQUAL = 6;</code>
       */
      NOT_EQUAL(6),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value of the enum.
       * </pre>
       *
       * <code>OPERATOR_UNSPECIFIED = 0;</code>
       */
      public static final int OPERATOR_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Datapoints are eligible iff their value is &lt; the query's.
       * </pre>
       *
       * <code>LESS = 1;</code>
       */
      public static final int LESS_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Datapoints are eligible iff their value is &lt;= the query's.
       * </pre>
       *
       * <code>LESS_EQUAL = 2;</code>
       */
      public static final int LESS_EQUAL_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Datapoints are eligible iff their value is == the query's.
       * </pre>
       *
       * <code>EQUAL = 3;</code>
       */
      public static final int EQUAL_VALUE = 3;
      /**
       *
       *
       * <pre>
       * Datapoints are eligible iff their value is &gt;= the query's.
       * </pre>
       *
       * <code>GREATER_EQUAL = 4;</code>
       */
      public static final int GREATER_EQUAL_VALUE = 4;
      /**
       *
       *
       * <pre>
       * Datapoints are eligible iff their value is &gt; the query's.
       * </pre>
       *
       * <code>GREATER = 5;</code>
       */
      public static final int GREATER_VALUE = 5;
      /**
       *
       *
       * <pre>
       * Datapoints are eligible iff their value is != the query's.
       * </pre>
       *
       * <code>NOT_EQUAL = 6;</code>
       */
      public static final int NOT_EQUAL_VALUE = 6;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Operator valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Operator forNumber(int value) {
        switch (value) {
          case 0:
            return OPERATOR_UNSPECIFIED;
          case 1:
            return LESS;
          case 2:
            return LESS_EQUAL;
          case 3:
            return EQUAL;
          case 4:
            return GREATER_EQUAL;
          case 5:
            return GREATER;
          case 6:
            return NOT_EQUAL;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Operator> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Operator> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Operator>() {
            public Operator findValueByNumber(int number) {
              return Operator.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Operator[] VALUES = values();

      public static Operator valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Operator(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Operator)
    }

    private int valueCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object value_;

    public enum ValueCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      VALUE_INT(2),
      VALUE_FLOAT(3),
      VALUE_DOUBLE(4),
      VALUE_NOT_SET(0);
      private final int value;

      private ValueCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ValueCase valueOf(int value) {
        return forNumber(value);
      }

      public static ValueCase forNumber(int value) {
        switch (value) {
          case 2:
            return VALUE_INT;
          case 3:
            return VALUE_FLOAT;
          case 4:
            return VALUE_DOUBLE;
          case 0:
            return VALUE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ValueCase getValueCase() {
      return ValueCase.forNumber(valueCase_);
    }

    public static final int VALUE_INT_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Represents 64 bit integer.
     * </pre>
     *
     * <code>int64 value_int = 2;</code>
     *
     * @return Whether the valueInt field is set.
     */
    @java.lang.Override
    public boolean hasValueInt() {
      return valueCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Represents 64 bit integer.
     * </pre>
     *
     * <code>int64 value_int = 2;</code>
     *
     * @return The valueInt.
     */
    @java.lang.Override
    public long getValueInt() {
      if (valueCase_ == 2) {
        return (java.lang.Long) value_;
      }
      return 0L;
    }

    public static final int VALUE_FLOAT_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * Represents 32 bit float.
     * </pre>
     *
     * <code>float value_float = 3;</code>
     *
     * @return Whether the valueFloat field is set.
     */
    @java.lang.Override
    public boolean hasValueFloat() {
      return valueCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Represents 32 bit float.
     * </pre>
     *
     * <code>float value_float = 3;</code>
     *
     * @return The valueFloat.
     */
    @java.lang.Override
    public float getValueFloat() {
      if (valueCase_ == 3) {
        return (java.lang.Float) value_;
      }
      return 0F;
    }

    public static final int VALUE_DOUBLE_FIELD_NUMBER = 4;
    /**
     *
     *
     * <pre>
     * Represents 64 bit float.
     * </pre>
     *
     * <code>double value_double = 4;</code>
     *
     * @return Whether the valueDouble field is set.
     */
    @java.lang.Override
    public boolean hasValueDouble() {
      return valueCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Represents 64 bit float.
     * </pre>
     *
     * <code>double value_double = 4;</code>
     *
     * @return The valueDouble.
     */
    @java.lang.Override
    public double getValueDouble() {
      if (valueCase_ == 4) {
        return (java.lang.Double) value_;
      }
      return 0D;
    }

    public static final int NAMESPACE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object namespace_ = "";
    /**
     *
     *
     * <pre>
     * The namespace of this restriction. e.g.: cost.
     * </pre>
     *
     * <code>string namespace = 1;</code>
     *
     * @return The namespace.
     */
    @java.lang.Override
    public java.lang.String getNamespace() {
      java.lang.Object ref = namespace_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        namespace_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The namespace of this restriction. e.g.: cost.
     * </pre>
     *
     * <code>string namespace = 1;</code>
     *
     * @return The bytes for namespace.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNamespaceBytes() {
      java.lang.Object ref = namespace_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        namespace_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int OP_FIELD_NUMBER = 5;
    private int op_ = 0;
    /**
     *
     *
     * <pre>
     * This MUST be specified for queries and must NOT be specified for
     * datapoints.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Operator op = 5;</code>
     *
     * @return The enum numeric value on the wire for op.
     */
    @java.lang.Override
    public int getOpValue() {
      return op_;
    }
    /**
     *
     *
     * <pre>
     * This MUST be specified for queries and must NOT be specified for
     * datapoints.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Operator op = 5;</code>
     *
     * @return The op.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Operator getOp() {
      com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Operator result =
          com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Operator.forNumber(op_);
      return result == null
          ? com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Operator.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(namespace_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, namespace_);
      }
      if (valueCase_ == 2) {
        output.writeInt64(2, (long) ((java.lang.Long) value_));
      }
      if (valueCase_ == 3) {
        output.writeFloat(3, (float) ((java.lang.Float) value_));
      }
      if (valueCase_ == 4) {
        output.writeDouble(4, (double) ((java.lang.Double) value_));
      }
      if (op_
          != com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Operator
              .OPERATOR_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(5, op_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(namespace_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, namespace_);
      }
      if (valueCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt64Size(
                2, (long) ((java.lang.Long) value_));
      }
      if (valueCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeFloatSize(
                3, (float) ((java.lang.Float) value_));
      }
      if (valueCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeDoubleSize(
                4, (double) ((java.lang.Double) value_));
      }
      if (op_
          != com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Operator
              .OPERATOR_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, op_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction other =
          (com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction) obj;

      if (!getNamespace().equals(other.getNamespace())) return false;
      if (op_ != other.op_) return false;
      if (!getValueCase().equals(other.getValueCase())) return false;
      switch (valueCase_) {
        case 2:
          if (getValueInt() != other.getValueInt()) return false;
          break;
        case 3:
          if (java.lang.Float.floatToIntBits(getValueFloat())
              != java.lang.Float.floatToIntBits(other.getValueFloat())) return false;
          break;
        case 4:
          if (java.lang.Double.doubleToLongBits(getValueDouble())
              != java.lang.Double.doubleToLongBits(other.getValueDouble())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAMESPACE_FIELD_NUMBER;
      hash = (53 * hash) + getNamespace().hashCode();
      hash = (37 * hash) + OP_FIELD_NUMBER;
      hash = (53 * hash) + op_;
      switch (valueCase_) {
        case 2:
          hash = (37 * hash) + VALUE_INT_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getValueInt());
          break;
        case 3:
          hash = (37 * hash) + VALUE_FLOAT_FIELD_NUMBER;
          hash = (53 * hash) + java.lang.Float.floatToIntBits(getValueFloat());
          break;
        case 4:
          hash = (37 * hash) + VALUE_DOUBLE_FIELD_NUMBER;
          hash =
              (53 * hash)
                  + com.google.protobuf.Internal.hashLong(
                      java.lang.Double.doubleToLongBits(getValueDouble()));
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * This field allows restricts to be based on numeric comparisons rather
     * than categorical tokens.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction)
        com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestrictionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.IndexProto
            .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_NumericRestriction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.IndexProto
            .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_NumericRestriction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.class,
                com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        namespace_ = "";
        op_ = 0;
        valueCase_ = 0;
        value_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.IndexProto
            .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_NumericRestriction_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction build() {
        com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction buildPartial() {
        com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction result =
            new com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.namespace_ = namespace_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.op_ = op_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction result) {
        result.valueCase_ = valueCase_;
        result.value_ = this.value_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction other) {
        if (other
            == com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction
                .getDefaultInstance()) return this;
        if (!other.getNamespace().isEmpty()) {
          namespace_ = other.namespace_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (other.op_ != 0) {
          setOpValue(other.getOpValue());
        }
        switch (other.getValueCase()) {
          case VALUE_INT:
            {
              setValueInt(other.getValueInt());
              break;
            }
          case VALUE_FLOAT:
            {
              setValueFloat(other.getValueFloat());
              break;
            }
          case VALUE_DOUBLE:
            {
              setValueDouble(other.getValueDouble());
              break;
            }
          case VALUE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  namespace_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 10
              case 16:
                {
                  value_ = input.readInt64();
                  valueCase_ = 2;
                  break;
                } // case 16
              case 29:
                {
                  value_ = input.readFloat();
                  valueCase_ = 3;
                  break;
                } // case 29
              case 33:
                {
                  value_ = input.readDouble();
                  valueCase_ = 4;
                  break;
                } // case 33
              case 40:
                {
                  op_ = input.readEnum();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 40
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int valueCase_ = 0;
      private java.lang.Object value_;

      public ValueCase getValueCase() {
        return ValueCase.forNumber(valueCase_);
      }

      public Builder clearValue() {
        valueCase_ = 0;
        value_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * Represents 64 bit integer.
       * </pre>
       *
       * <code>int64 value_int = 2;</code>
       *
       * @return Whether the valueInt field is set.
       */
      public boolean hasValueInt() {
        return valueCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Represents 64 bit integer.
       * </pre>
       *
       * <code>int64 value_int = 2;</code>
       *
       * @return The valueInt.
       */
      public long getValueInt() {
        if (valueCase_ == 2) {
          return (java.lang.Long) value_;
        }
        return 0L;
      }
      /**
       *
       *
       * <pre>
       * Represents 64 bit integer.
       * </pre>
       *
       * <code>int64 value_int = 2;</code>
       *
       * @param value The valueInt to set.
       * @return This builder for chaining.
       */
      public Builder setValueInt(long value) {

        valueCase_ = 2;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents 64 bit integer.
       * </pre>
       *
       * <code>int64 value_int = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValueInt() {
        if (valueCase_ == 2) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Represents 32 bit float.
       * </pre>
       *
       * <code>float value_float = 3;</code>
       *
       * @return Whether the valueFloat field is set.
       */
      public boolean hasValueFloat() {
        return valueCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * Represents 32 bit float.
       * </pre>
       *
       * <code>float value_float = 3;</code>
       *
       * @return The valueFloat.
       */
      public float getValueFloat() {
        if (valueCase_ == 3) {
          return (java.lang.Float) value_;
        }
        return 0F;
      }
      /**
       *
       *
       * <pre>
       * Represents 32 bit float.
       * </pre>
       *
       * <code>float value_float = 3;</code>
       *
       * @param value The valueFloat to set.
       * @return This builder for chaining.
       */
      public Builder setValueFloat(float value) {

        valueCase_ = 3;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents 32 bit float.
       * </pre>
       *
       * <code>float value_float = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValueFloat() {
        if (valueCase_ == 3) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Represents 64 bit float.
       * </pre>
       *
       * <code>double value_double = 4;</code>
       *
       * @return Whether the valueDouble field is set.
       */
      public boolean hasValueDouble() {
        return valueCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * Represents 64 bit float.
       * </pre>
       *
       * <code>double value_double = 4;</code>
       *
       * @return The valueDouble.
       */
      public double getValueDouble() {
        if (valueCase_ == 4) {
          return (java.lang.Double) value_;
        }
        return 0D;
      }
      /**
       *
       *
       * <pre>
       * Represents 64 bit float.
       * </pre>
       *
       * <code>double value_double = 4;</code>
       *
       * @param value The valueDouble to set.
       * @return This builder for chaining.
       */
      public Builder setValueDouble(double value) {

        valueCase_ = 4;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents 64 bit float.
       * </pre>
       *
       * <code>double value_double = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValueDouble() {
        if (valueCase_ == 4) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }

      private java.lang.Object namespace_ = "";
      /**
       *
       *
       * <pre>
       * The namespace of this restriction. e.g.: cost.
       * </pre>
       *
       * <code>string namespace = 1;</code>
       *
       * @return The namespace.
       */
      public java.lang.String getNamespace() {
        java.lang.Object ref = namespace_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          namespace_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The namespace of this restriction. e.g.: cost.
       * </pre>
       *
       * <code>string namespace = 1;</code>
       *
       * @return The bytes for namespace.
       */
      public com.google.protobuf.ByteString getNamespaceBytes() {
        java.lang.Object ref = namespace_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          namespace_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The namespace of this restriction. e.g.: cost.
       * </pre>
       *
       * <code>string namespace = 1;</code>
       *
       * @param value The namespace to set.
       * @return This builder for chaining.
       */
      public Builder setNamespace(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        namespace_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The namespace of this restriction. e.g.: cost.
       * </pre>
       *
       * <code>string namespace = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNamespace() {
        namespace_ = getDefaultInstance().getNamespace();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The namespace of this restriction. e.g.: cost.
       * </pre>
       *
       * <code>string namespace = 1;</code>
       *
       * @param value The bytes for namespace to set.
       * @return This builder for chaining.
       */
      public Builder setNamespaceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        namespace_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private int op_ = 0;
      /**
       *
       *
       * <pre>
       * This MUST be specified for queries and must NOT be specified for
       * datapoints.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Operator op = 5;</code>
       *
       * @return The enum numeric value on the wire for op.
       */
      @java.lang.Override
      public int getOpValue() {
        return op_;
      }
      /**
       *
       *
       * <pre>
       * This MUST be specified for queries and must NOT be specified for
       * datapoints.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Operator op = 5;</code>
       *
       * @param value The enum numeric value on the wire for op to set.
       * @return This builder for chaining.
       */
      public Builder setOpValue(int value) {
        op_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This MUST be specified for queries and must NOT be specified for
       * datapoints.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Operator op = 5;</code>
       *
       * @return The op.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Operator getOp() {
        com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Operator result =
            com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Operator.forNumber(
                op_);
        return result == null
            ? com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Operator.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * This MUST be specified for queries and must NOT be specified for
       * datapoints.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Operator op = 5;</code>
       *
       * @param value The op to set.
       * @return This builder for chaining.
       */
      public Builder setOp(
          com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Operator value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        op_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This MUST be specified for queries and must NOT be specified for
       * datapoints.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Operator op = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOp() {
        bitField0_ = (bitField0_ & ~0x00000010);
        op_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction)
    private static final com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction();
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<NumericRestriction> PARSER =
        new com.google.protobuf.AbstractParser<NumericRestriction>() {
          @java.lang.Override
          public NumericRestriction parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<NumericRestriction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<NumericRestriction> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CrowdingTagOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The attribute value used for crowding.  The maximum number of neighbors
     * to return per crowding attribute value
     * (per_crowding_attribute_num_neighbors) is configured per-query. This
     * field is ignored if per_crowding_attribute_num_neighbors is larger than
     * the total number of neighbors to return for a given query.
     * </pre>
     *
     * <code>string crowding_attribute = 1;</code>
     *
     * @return The crowdingAttribute.
     */
    java.lang.String getCrowdingAttribute();
    /**
     *
     *
     * <pre>
     * The attribute value used for crowding.  The maximum number of neighbors
     * to return per crowding attribute value
     * (per_crowding_attribute_num_neighbors) is configured per-query. This
     * field is ignored if per_crowding_attribute_num_neighbors is larger than
     * the total number of neighbors to return for a given query.
     * </pre>
     *
     * <code>string crowding_attribute = 1;</code>
     *
     * @return The bytes for crowdingAttribute.
     */
    com.google.protobuf.ByteString getCrowdingAttributeBytes();
  }
  /**
   *
   *
   * <pre>
   * Crowding tag is a constraint on a neighbor list produced by nearest
   * neighbor search requiring that no more than some value k' of the k
   * neighbors returned have the same value of crowding_attribute.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag}
   */
  public static final class CrowdingTag extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag)
      CrowdingTagOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CrowdingTag.newBuilder() to construct.
    private CrowdingTag(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CrowdingTag() {
      crowdingAttribute_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CrowdingTag();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.IndexProto
          .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_CrowdingTag_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.IndexProto
          .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_CrowdingTag_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag.class,
              com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag.Builder.class);
    }

    public static final int CROWDING_ATTRIBUTE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object crowdingAttribute_ = "";
    /**
     *
     *
     * <pre>
     * The attribute value used for crowding.  The maximum number of neighbors
     * to return per crowding attribute value
     * (per_crowding_attribute_num_neighbors) is configured per-query. This
     * field is ignored if per_crowding_attribute_num_neighbors is larger than
     * the total number of neighbors to return for a given query.
     * </pre>
     *
     * <code>string crowding_attribute = 1;</code>
     *
     * @return The crowdingAttribute.
     */
    @java.lang.Override
    public java.lang.String getCrowdingAttribute() {
      java.lang.Object ref = crowdingAttribute_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        crowdingAttribute_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The attribute value used for crowding.  The maximum number of neighbors
     * to return per crowding attribute value
     * (per_crowding_attribute_num_neighbors) is configured per-query. This
     * field is ignored if per_crowding_attribute_num_neighbors is larger than
     * the total number of neighbors to return for a given query.
     * </pre>
     *
     * <code>string crowding_attribute = 1;</code>
     *
     * @return The bytes for crowdingAttribute.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCrowdingAttributeBytes() {
      java.lang.Object ref = crowdingAttribute_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        crowdingAttribute_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(crowdingAttribute_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, crowdingAttribute_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(crowdingAttribute_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, crowdingAttribute_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag other =
          (com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag) obj;

      if (!getCrowdingAttribute().equals(other.getCrowdingAttribute())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CROWDING_ATTRIBUTE_FIELD_NUMBER;
      hash = (53 * hash) + getCrowdingAttribute().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Crowding tag is a constraint on a neighbor list produced by nearest
     * neighbor search requiring that no more than some value k' of the k
     * neighbors returned have the same value of crowding_attribute.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag)
        com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTagOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.IndexProto
            .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_CrowdingTag_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.IndexProto
            .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_CrowdingTag_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag.class,
                com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        crowdingAttribute_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.IndexProto
            .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_CrowdingTag_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag build() {
        com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag buildPartial() {
        com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag result =
            new com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.crowdingAttribute_ = crowdingAttribute_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag) {
          return mergeFrom((com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag other) {
        if (other == com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag.getDefaultInstance())
          return this;
        if (!other.getCrowdingAttribute().isEmpty()) {
          crowdingAttribute_ = other.crowdingAttribute_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  crowdingAttribute_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object crowdingAttribute_ = "";
      /**
       *
       *
       * <pre>
       * The attribute value used for crowding.  The maximum number of neighbors
       * to return per crowding attribute value
       * (per_crowding_attribute_num_neighbors) is configured per-query. This
       * field is ignored if per_crowding_attribute_num_neighbors is larger than
       * the total number of neighbors to return for a given query.
       * </pre>
       *
       * <code>string crowding_attribute = 1;</code>
       *
       * @return The crowdingAttribute.
       */
      public java.lang.String getCrowdingAttribute() {
        java.lang.Object ref = crowdingAttribute_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          crowdingAttribute_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The attribute value used for crowding.  The maximum number of neighbors
       * to return per crowding attribute value
       * (per_crowding_attribute_num_neighbors) is configured per-query. This
       * field is ignored if per_crowding_attribute_num_neighbors is larger than
       * the total number of neighbors to return for a given query.
       * </pre>
       *
       * <code>string crowding_attribute = 1;</code>
       *
       * @return The bytes for crowdingAttribute.
       */
      public com.google.protobuf.ByteString getCrowdingAttributeBytes() {
        java.lang.Object ref = crowdingAttribute_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          crowdingAttribute_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The attribute value used for crowding.  The maximum number of neighbors
       * to return per crowding attribute value
       * (per_crowding_attribute_num_neighbors) is configured per-query. This
       * field is ignored if per_crowding_attribute_num_neighbors is larger than
       * the total number of neighbors to return for a given query.
       * </pre>
       *
       * <code>string crowding_attribute = 1;</code>
       *
       * @param value The crowdingAttribute to set.
       * @return This builder for chaining.
       */
      public Builder setCrowdingAttribute(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        crowdingAttribute_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The attribute value used for crowding.  The maximum number of neighbors
       * to return per crowding attribute value
       * (per_crowding_attribute_num_neighbors) is configured per-query. This
       * field is ignored if per_crowding_attribute_num_neighbors is larger than
       * the total number of neighbors to return for a given query.
       * </pre>
       *
       * <code>string crowding_attribute = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCrowdingAttribute() {
        crowdingAttribute_ = getDefaultInstance().getCrowdingAttribute();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The attribute value used for crowding.  The maximum number of neighbors
       * to return per crowding attribute value
       * (per_crowding_attribute_num_neighbors) is configured per-query. This
       * field is ignored if per_crowding_attribute_num_neighbors is larger than
       * the total number of neighbors to return for a given query.
       * </pre>
       *
       * <code>string crowding_attribute = 1;</code>
       *
       * @param value The bytes for crowdingAttribute to set.
       * @return This builder for chaining.
       */
      public Builder setCrowdingAttributeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        crowdingAttribute_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag)
    private static final com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag();
    }

    public static com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CrowdingTag> PARSER =
        new com.google.protobuf.AbstractParser<CrowdingTag>() {
          @java.lang.Override
          public CrowdingTag parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CrowdingTag> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CrowdingTag> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int DATAPOINT_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object datapointId_ = "";
  /**
   *
   *
   * <pre>
   * Required. Unique identifier of the datapoint.
   * </pre>
   *
   * <code>string datapoint_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The datapointId.
   */
  @java.lang.Override
  public java.lang.String getDatapointId() {
    java.lang.Object ref = datapointId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      datapointId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Unique identifier of the datapoint.
   * </pre>
   *
   * <code>string datapoint_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for datapointId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatapointIdBytes() {
    java.lang.Object ref = datapointId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      datapointId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FEATURE_VECTOR_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.FloatList featureVector_ = emptyFloatList();
  /**
   *
   *
   * <pre>
   * Required. Feature embedding vector for dense index. An array of numbers
   * with the length of [NearestNeighborSearchConfig.dimensions].
   * </pre>
   *
   * <code>repeated float feature_vector = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return A list containing the featureVector.
   */
  @java.lang.Override
  public java.util.List<java.lang.Float> getFeatureVectorList() {
    return featureVector_;
  }
  /**
   *
   *
   * <pre>
   * Required. Feature embedding vector for dense index. An array of numbers
   * with the length of [NearestNeighborSearchConfig.dimensions].
   * </pre>
   *
   * <code>repeated float feature_vector = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The count of featureVector.
   */
  public int getFeatureVectorCount() {
    return featureVector_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Feature embedding vector for dense index. An array of numbers
   * with the length of [NearestNeighborSearchConfig.dimensions].
   * </pre>
   *
   * <code>repeated float feature_vector = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the element to return.
   * @return The featureVector at the given index.
   */
  public float getFeatureVector(int index) {
    return featureVector_.getFloat(index);
  }

  private int featureVectorMemoizedSerializedSize = -1;

  public static final int SPARSE_EMBEDDING_FIELD_NUMBER = 7;
  private com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding sparseEmbedding_;
  /**
   *
   *
   * <pre>
   * Optional. Feature embedding vector for sparse index.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding sparse_embedding = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the sparseEmbedding field is set.
   */
  @java.lang.Override
  public boolean hasSparseEmbedding() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Feature embedding vector for sparse index.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding sparse_embedding = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The sparseEmbedding.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding getSparseEmbedding() {
    return sparseEmbedding_ == null
        ? com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding.getDefaultInstance()
        : sparseEmbedding_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Feature embedding vector for sparse index.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding sparse_embedding = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbeddingOrBuilder
      getSparseEmbeddingOrBuilder() {
    return sparseEmbedding_ == null
        ? com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding.getDefaultInstance()
        : sparseEmbedding_;
  }

  public static final int RESTRICTS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction> restricts_;
  /**
   *
   *
   * <pre>
   * Optional. List of Restrict of the datapoint, used to perform "restricted
   * searches" where boolean rule are used to filter the subset of the database
   * eligible for matching. This uses categorical tokens. See:
   * https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.IndexDatapoint.Restriction restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction>
      getRestrictsList() {
    return restricts_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of Restrict of the datapoint, used to perform "restricted
   * searches" where boolean rule are used to filter the subset of the database
   * eligible for matching. This uses categorical tokens. See:
   * https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.IndexDatapoint.Restriction restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.aiplatform.v1.IndexDatapoint.RestrictionOrBuilder>
      getRestrictsOrBuilderList() {
    return restricts_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of Restrict of the datapoint, used to perform "restricted
   * searches" where boolean rule are used to filter the subset of the database
   * eligible for matching. This uses categorical tokens. See:
   * https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.IndexDatapoint.Restriction restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getRestrictsCount() {
    return restricts_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. List of Restrict of the datapoint, used to perform "restricted
   * searches" where boolean rule are used to filter the subset of the database
   * eligible for matching. This uses categorical tokens. See:
   * https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.IndexDatapoint.Restriction restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction getRestricts(int index) {
    return restricts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. List of Restrict of the datapoint, used to perform "restricted
   * searches" where boolean rule are used to filter the subset of the database
   * eligible for matching. This uses categorical tokens. See:
   * https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.IndexDatapoint.Restriction restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.IndexDatapoint.RestrictionOrBuilder getRestrictsOrBuilder(
      int index) {
    return restricts_.get(index);
  }

  public static final int NUMERIC_RESTRICTS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction>
      numericRestricts_;
  /**
   *
   *
   * <pre>
   * Optional. List of Restrict of the datapoint, used to perform "restricted
   * searches" where boolean rule are used to filter the subset of the database
   * eligible for matching. This uses numeric comparisons.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction numeric_restricts = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction>
      getNumericRestrictsList() {
    return numericRestricts_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of Restrict of the datapoint, used to perform "restricted
   * searches" where boolean rule are used to filter the subset of the database
   * eligible for matching. This uses numeric comparisons.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction numeric_restricts = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestrictionOrBuilder>
      getNumericRestrictsOrBuilderList() {
    return numericRestricts_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of Restrict of the datapoint, used to perform "restricted
   * searches" where boolean rule are used to filter the subset of the database
   * eligible for matching. This uses numeric comparisons.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction numeric_restricts = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getNumericRestrictsCount() {
    return numericRestricts_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. List of Restrict of the datapoint, used to perform "restricted
   * searches" where boolean rule are used to filter the subset of the database
   * eligible for matching. This uses numeric comparisons.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction numeric_restricts = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction getNumericRestricts(
      int index) {
    return numericRestricts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. List of Restrict of the datapoint, used to perform "restricted
   * searches" where boolean rule are used to filter the subset of the database
   * eligible for matching. This uses numeric comparisons.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction numeric_restricts = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestrictionOrBuilder
      getNumericRestrictsOrBuilder(int index) {
    return numericRestricts_.get(index);
  }

  public static final int CROWDING_TAG_FIELD_NUMBER = 5;
  private com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag crowdingTag_;
  /**
   *
   *
   * <pre>
   * Optional. CrowdingTag of the datapoint, the number of neighbors to return
   * in each crowding can be configured during query.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag crowding_tag = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the crowdingTag field is set.
   */
  @java.lang.Override
  public boolean hasCrowdingTag() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. CrowdingTag of the datapoint, the number of neighbors to return
   * in each crowding can be configured during query.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag crowding_tag = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The crowdingTag.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag getCrowdingTag() {
    return crowdingTag_ == null
        ? com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag.getDefaultInstance()
        : crowdingTag_;
  }
  /**
   *
   *
   * <pre>
   * Optional. CrowdingTag of the datapoint, the number of neighbors to return
   * in each crowding can be configured during query.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag crowding_tag = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTagOrBuilder
      getCrowdingTagOrBuilder() {
    return crowdingTag_ == null
        ? com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag.getDefaultInstance()
        : crowdingTag_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datapointId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, datapointId_);
    }
    if (getFeatureVectorList().size() > 0) {
      output.writeUInt32NoTag(18);
      output.writeUInt32NoTag(featureVectorMemoizedSerializedSize);
    }
    for (int i = 0; i < featureVector_.size(); i++) {
      output.writeFloatNoTag(featureVector_.getFloat(i));
    }
    for (int i = 0; i < restricts_.size(); i++) {
      output.writeMessage(4, restricts_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getCrowdingTag());
    }
    for (int i = 0; i < numericRestricts_.size(); i++) {
      output.writeMessage(6, numericRestricts_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getSparseEmbedding());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datapointId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, datapointId_);
    }
    {
      int dataSize = 0;
      dataSize = 4 * getFeatureVectorList().size();
      size += dataSize;
      if (!getFeatureVectorList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      featureVectorMemoizedSerializedSize = dataSize;
    }
    for (int i = 0; i < restricts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, restricts_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCrowdingTag());
    }
    for (int i = 0; i < numericRestricts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, numericRestricts_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getSparseEmbedding());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.IndexDatapoint)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.IndexDatapoint other =
        (com.google.cloud.aiplatform.v1.IndexDatapoint) obj;

    if (!getDatapointId().equals(other.getDatapointId())) return false;
    if (!getFeatureVectorList().equals(other.getFeatureVectorList())) return false;
    if (hasSparseEmbedding() != other.hasSparseEmbedding()) return false;
    if (hasSparseEmbedding()) {
      if (!getSparseEmbedding().equals(other.getSparseEmbedding())) return false;
    }
    if (!getRestrictsList().equals(other.getRestrictsList())) return false;
    if (!getNumericRestrictsList().equals(other.getNumericRestrictsList())) return false;
    if (hasCrowdingTag() != other.hasCrowdingTag()) return false;
    if (hasCrowdingTag()) {
      if (!getCrowdingTag().equals(other.getCrowdingTag())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATAPOINT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDatapointId().hashCode();
    if (getFeatureVectorCount() > 0) {
      hash = (37 * hash) + FEATURE_VECTOR_FIELD_NUMBER;
      hash = (53 * hash) + getFeatureVectorList().hashCode();
    }
    if (hasSparseEmbedding()) {
      hash = (37 * hash) + SPARSE_EMBEDDING_FIELD_NUMBER;
      hash = (53 * hash) + getSparseEmbedding().hashCode();
    }
    if (getRestrictsCount() > 0) {
      hash = (37 * hash) + RESTRICTS_FIELD_NUMBER;
      hash = (53 * hash) + getRestrictsList().hashCode();
    }
    if (getNumericRestrictsCount() > 0) {
      hash = (37 * hash) + NUMERIC_RESTRICTS_FIELD_NUMBER;
      hash = (53 * hash) + getNumericRestrictsList().hashCode();
    }
    if (hasCrowdingTag()) {
      hash = (37 * hash) + CROWDING_TAG_FIELD_NUMBER;
      hash = (53 * hash) + getCrowdingTag().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.IndexDatapoint parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.IndexDatapoint parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.IndexDatapoint parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.IndexDatapoint parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.IndexDatapoint parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.IndexDatapoint parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.IndexDatapoint parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.IndexDatapoint parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.IndexDatapoint parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.IndexDatapoint parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.IndexDatapoint parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.IndexDatapoint parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.IndexDatapoint prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A datapoint of Index.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.IndexDatapoint}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.IndexDatapoint)
      com.google.cloud.aiplatform.v1.IndexDatapointOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.IndexProto
          .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.IndexProto
          .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.IndexDatapoint.class,
              com.google.cloud.aiplatform.v1.IndexDatapoint.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.IndexDatapoint.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSparseEmbeddingFieldBuilder();
        getRestrictsFieldBuilder();
        getNumericRestrictsFieldBuilder();
        getCrowdingTagFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      datapointId_ = "";
      featureVector_ = emptyFloatList();
      sparseEmbedding_ = null;
      if (sparseEmbeddingBuilder_ != null) {
        sparseEmbeddingBuilder_.dispose();
        sparseEmbeddingBuilder_ = null;
      }
      if (restrictsBuilder_ == null) {
        restricts_ = java.util.Collections.emptyList();
      } else {
        restricts_ = null;
        restrictsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      if (numericRestrictsBuilder_ == null) {
        numericRestricts_ = java.util.Collections.emptyList();
      } else {
        numericRestricts_ = null;
        numericRestrictsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      crowdingTag_ = null;
      if (crowdingTagBuilder_ != null) {
        crowdingTagBuilder_.dispose();
        crowdingTagBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.IndexProto
          .internal_static_google_cloud_aiplatform_v1_IndexDatapoint_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.IndexDatapoint getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.IndexDatapoint.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.IndexDatapoint build() {
      com.google.cloud.aiplatform.v1.IndexDatapoint result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.IndexDatapoint buildPartial() {
      com.google.cloud.aiplatform.v1.IndexDatapoint result =
          new com.google.cloud.aiplatform.v1.IndexDatapoint(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.aiplatform.v1.IndexDatapoint result) {
      if (restrictsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          restricts_ = java.util.Collections.unmodifiableList(restricts_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.restricts_ = restricts_;
      } else {
        result.restricts_ = restrictsBuilder_.build();
      }
      if (numericRestrictsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          numericRestricts_ = java.util.Collections.unmodifiableList(numericRestricts_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.numericRestricts_ = numericRestricts_;
      } else {
        result.numericRestricts_ = numericRestrictsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.IndexDatapoint result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.datapointId_ = datapointId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        featureVector_.makeImmutable();
        result.featureVector_ = featureVector_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.sparseEmbedding_ =
            sparseEmbeddingBuilder_ == null ? sparseEmbedding_ : sparseEmbeddingBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.crowdingTag_ =
            crowdingTagBuilder_ == null ? crowdingTag_ : crowdingTagBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.IndexDatapoint) {
        return mergeFrom((com.google.cloud.aiplatform.v1.IndexDatapoint) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.IndexDatapoint other) {
      if (other == com.google.cloud.aiplatform.v1.IndexDatapoint.getDefaultInstance()) return this;
      if (!other.getDatapointId().isEmpty()) {
        datapointId_ = other.datapointId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.featureVector_.isEmpty()) {
        if (featureVector_.isEmpty()) {
          featureVector_ = other.featureVector_;
          featureVector_.makeImmutable();
          bitField0_ |= 0x00000002;
        } else {
          ensureFeatureVectorIsMutable();
          featureVector_.addAll(other.featureVector_);
        }
        onChanged();
      }
      if (other.hasSparseEmbedding()) {
        mergeSparseEmbedding(other.getSparseEmbedding());
      }
      if (restrictsBuilder_ == null) {
        if (!other.restricts_.isEmpty()) {
          if (restricts_.isEmpty()) {
            restricts_ = other.restricts_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureRestrictsIsMutable();
            restricts_.addAll(other.restricts_);
          }
          onChanged();
        }
      } else {
        if (!other.restricts_.isEmpty()) {
          if (restrictsBuilder_.isEmpty()) {
            restrictsBuilder_.dispose();
            restrictsBuilder_ = null;
            restricts_ = other.restricts_;
            bitField0_ = (bitField0_ & ~0x00000008);
            restrictsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRestrictsFieldBuilder()
                    : null;
          } else {
            restrictsBuilder_.addAllMessages(other.restricts_);
          }
        }
      }
      if (numericRestrictsBuilder_ == null) {
        if (!other.numericRestricts_.isEmpty()) {
          if (numericRestricts_.isEmpty()) {
            numericRestricts_ = other.numericRestricts_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureNumericRestrictsIsMutable();
            numericRestricts_.addAll(other.numericRestricts_);
          }
          onChanged();
        }
      } else {
        if (!other.numericRestricts_.isEmpty()) {
          if (numericRestrictsBuilder_.isEmpty()) {
            numericRestrictsBuilder_.dispose();
            numericRestrictsBuilder_ = null;
            numericRestricts_ = other.numericRestricts_;
            bitField0_ = (bitField0_ & ~0x00000010);
            numericRestrictsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNumericRestrictsFieldBuilder()
                    : null;
          } else {
            numericRestrictsBuilder_.addAllMessages(other.numericRestricts_);
          }
        }
      }
      if (other.hasCrowdingTag()) {
        mergeCrowdingTag(other.getCrowdingTag());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                datapointId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 21:
              {
                float v = input.readFloat();
                ensureFeatureVectorIsMutable();
                featureVector_.addFloat(v);
                break;
              } // case 21
            case 18:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                int alloc = length > 4096 ? 4096 : length;
                ensureFeatureVectorIsMutable(alloc / 4);
                while (input.getBytesUntilLimit() > 0) {
                  featureVector_.addFloat(input.readFloat());
                }
                input.popLimit(limit);
                break;
              } // case 18
            case 34:
              {
                com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction.parser(),
                        extensionRegistry);
                if (restrictsBuilder_ == null) {
                  ensureRestrictsIsMutable();
                  restricts_.add(m);
                } else {
                  restrictsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getCrowdingTagFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.parser(),
                        extensionRegistry);
                if (numericRestrictsBuilder_ == null) {
                  ensureNumericRestrictsIsMutable();
                  numericRestricts_.add(m);
                } else {
                  numericRestrictsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getSparseEmbeddingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object datapointId_ = "";
    /**
     *
     *
     * <pre>
     * Required. Unique identifier of the datapoint.
     * </pre>
     *
     * <code>string datapoint_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The datapointId.
     */
    public java.lang.String getDatapointId() {
      java.lang.Object ref = datapointId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        datapointId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Unique identifier of the datapoint.
     * </pre>
     *
     * <code>string datapoint_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for datapointId.
     */
    public com.google.protobuf.ByteString getDatapointIdBytes() {
      java.lang.Object ref = datapointId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        datapointId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Unique identifier of the datapoint.
     * </pre>
     *
     * <code>string datapoint_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The datapointId to set.
     * @return This builder for chaining.
     */
    public Builder setDatapointId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      datapointId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Unique identifier of the datapoint.
     * </pre>
     *
     * <code>string datapoint_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatapointId() {
      datapointId_ = getDefaultInstance().getDatapointId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Unique identifier of the datapoint.
     * </pre>
     *
     * <code>string datapoint_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for datapointId to set.
     * @return This builder for chaining.
     */
    public Builder setDatapointIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      datapointId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.FloatList featureVector_ = emptyFloatList();

    private void ensureFeatureVectorIsMutable() {
      if (!featureVector_.isModifiable()) {
        featureVector_ = makeMutableCopy(featureVector_);
      }
      bitField0_ |= 0x00000002;
    }

    private void ensureFeatureVectorIsMutable(int capacity) {
      if (!featureVector_.isModifiable()) {
        featureVector_ = makeMutableCopy(featureVector_, capacity);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Required. Feature embedding vector for dense index. An array of numbers
     * with the length of [NearestNeighborSearchConfig.dimensions].
     * </pre>
     *
     * <code>repeated float feature_vector = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the featureVector.
     */
    public java.util.List<java.lang.Float> getFeatureVectorList() {
      featureVector_.makeImmutable();
      return featureVector_;
    }
    /**
     *
     *
     * <pre>
     * Required. Feature embedding vector for dense index. An array of numbers
     * with the length of [NearestNeighborSearchConfig.dimensions].
     * </pre>
     *
     * <code>repeated float feature_vector = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of featureVector.
     */
    public int getFeatureVectorCount() {
      return featureVector_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. Feature embedding vector for dense index. An array of numbers
     * with the length of [NearestNeighborSearchConfig.dimensions].
     * </pre>
     *
     * <code>repeated float feature_vector = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The featureVector at the given index.
     */
    public float getFeatureVector(int index) {
      return featureVector_.getFloat(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Feature embedding vector for dense index. An array of numbers
     * with the length of [NearestNeighborSearchConfig.dimensions].
     * </pre>
     *
     * <code>repeated float feature_vector = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index to set the value at.
     * @param value The featureVector to set.
     * @return This builder for chaining.
     */
    public Builder setFeatureVector(int index, float value) {

      ensureFeatureVectorIsMutable();
      featureVector_.setFloat(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Feature embedding vector for dense index. An array of numbers
     * with the length of [NearestNeighborSearchConfig.dimensions].
     * </pre>
     *
     * <code>repeated float feature_vector = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The featureVector to add.
     * @return This builder for chaining.
     */
    public Builder addFeatureVector(float value) {

      ensureFeatureVectorIsMutable();
      featureVector_.addFloat(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Feature embedding vector for dense index. An array of numbers
     * with the length of [NearestNeighborSearchConfig.dimensions].
     * </pre>
     *
     * <code>repeated float feature_vector = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param values The featureVector to add.
     * @return This builder for chaining.
     */
    public Builder addAllFeatureVector(java.lang.Iterable<? extends java.lang.Float> values) {
      ensureFeatureVectorIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, featureVector_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Feature embedding vector for dense index. An array of numbers
     * with the length of [NearestNeighborSearchConfig.dimensions].
     * </pre>
     *
     * <code>repeated float feature_vector = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFeatureVector() {
      featureVector_ = emptyFloatList();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding sparseEmbedding_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding,
            com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding.Builder,
            com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbeddingOrBuilder>
        sparseEmbeddingBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Feature embedding vector for sparse index.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding sparse_embedding = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sparseEmbedding field is set.
     */
    public boolean hasSparseEmbedding() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Feature embedding vector for sparse index.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding sparse_embedding = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sparseEmbedding.
     */
    public com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding getSparseEmbedding() {
      if (sparseEmbeddingBuilder_ == null) {
        return sparseEmbedding_ == null
            ? com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding.getDefaultInstance()
            : sparseEmbedding_;
      } else {
        return sparseEmbeddingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Feature embedding vector for sparse index.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding sparse_embedding = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSparseEmbedding(
        com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding value) {
      if (sparseEmbeddingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sparseEmbedding_ = value;
      } else {
        sparseEmbeddingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Feature embedding vector for sparse index.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding sparse_embedding = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSparseEmbedding(
        com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding.Builder builderForValue) {
      if (sparseEmbeddingBuilder_ == null) {
        sparseEmbedding_ = builderForValue.build();
      } else {
        sparseEmbeddingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Feature embedding vector for sparse index.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding sparse_embedding = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSparseEmbedding(
        com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding value) {
      if (sparseEmbeddingBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && sparseEmbedding_ != null
            && sparseEmbedding_
                != com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding
                    .getDefaultInstance()) {
          getSparseEmbeddingBuilder().mergeFrom(value);
        } else {
          sparseEmbedding_ = value;
        }
      } else {
        sparseEmbeddingBuilder_.mergeFrom(value);
      }
      if (sparseEmbedding_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Feature embedding vector for sparse index.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding sparse_embedding = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSparseEmbedding() {
      bitField0_ = (bitField0_ & ~0x00000004);
      sparseEmbedding_ = null;
      if (sparseEmbeddingBuilder_ != null) {
        sparseEmbeddingBuilder_.dispose();
        sparseEmbeddingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Feature embedding vector for sparse index.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding sparse_embedding = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding.Builder
        getSparseEmbeddingBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getSparseEmbeddingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Feature embedding vector for sparse index.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding sparse_embedding = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbeddingOrBuilder
        getSparseEmbeddingOrBuilder() {
      if (sparseEmbeddingBuilder_ != null) {
        return sparseEmbeddingBuilder_.getMessageOrBuilder();
      } else {
        return sparseEmbedding_ == null
            ? com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding.getDefaultInstance()
            : sparseEmbedding_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Feature embedding vector for sparse index.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding sparse_embedding = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding,
            com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding.Builder,
            com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbeddingOrBuilder>
        getSparseEmbeddingFieldBuilder() {
      if (sparseEmbeddingBuilder_ == null) {
        sparseEmbeddingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding,
                com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbedding.Builder,
                com.google.cloud.aiplatform.v1.IndexDatapoint.SparseEmbeddingOrBuilder>(
                getSparseEmbedding(), getParentForChildren(), isClean());
        sparseEmbedding_ = null;
      }
      return sparseEmbeddingBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction> restricts_ =
        java.util.Collections.emptyList();

    private void ensureRestrictsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        restricts_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction>(
                restricts_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction,
            com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction.Builder,
            com.google.cloud.aiplatform.v1.IndexDatapoint.RestrictionOrBuilder>
        restrictsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses categorical tokens. See:
     * https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.Restriction restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction>
        getRestrictsList() {
      if (restrictsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(restricts_);
      } else {
        return restrictsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses categorical tokens. See:
     * https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.Restriction restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getRestrictsCount() {
      if (restrictsBuilder_ == null) {
        return restricts_.size();
      } else {
        return restrictsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses categorical tokens. See:
     * https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.Restriction restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction getRestricts(int index) {
      if (restrictsBuilder_ == null) {
        return restricts_.get(index);
      } else {
        return restrictsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses categorical tokens. See:
     * https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.Restriction restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRestricts(
        int index, com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction value) {
      if (restrictsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRestrictsIsMutable();
        restricts_.set(index, value);
        onChanged();
      } else {
        restrictsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses categorical tokens. See:
     * https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.Restriction restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRestricts(
        int index,
        com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction.Builder builderForValue) {
      if (restrictsBuilder_ == null) {
        ensureRestrictsIsMutable();
        restricts_.set(index, builderForValue.build());
        onChanged();
      } else {
        restrictsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses categorical tokens. See:
     * https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.Restriction restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addRestricts(com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction value) {
      if (restrictsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRestrictsIsMutable();
        restricts_.add(value);
        onChanged();
      } else {
        restrictsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses categorical tokens. See:
     * https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.Restriction restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addRestricts(
        int index, com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction value) {
      if (restrictsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRestrictsIsMutable();
        restricts_.add(index, value);
        onChanged();
      } else {
        restrictsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses categorical tokens. See:
     * https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.Restriction restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addRestricts(
        com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction.Builder builderForValue) {
      if (restrictsBuilder_ == null) {
        ensureRestrictsIsMutable();
        restricts_.add(builderForValue.build());
        onChanged();
      } else {
        restrictsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses categorical tokens. See:
     * https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.Restriction restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addRestricts(
        int index,
        com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction.Builder builderForValue) {
      if (restrictsBuilder_ == null) {
        ensureRestrictsIsMutable();
        restricts_.add(index, builderForValue.build());
        onChanged();
      } else {
        restrictsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses categorical tokens. See:
     * https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.Restriction restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllRestricts(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction>
            values) {
      if (restrictsBuilder_ == null) {
        ensureRestrictsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, restricts_);
        onChanged();
      } else {
        restrictsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses categorical tokens. See:
     * https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.Restriction restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRestricts() {
      if (restrictsBuilder_ == null) {
        restricts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        restrictsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses categorical tokens. See:
     * https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.Restriction restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeRestricts(int index) {
      if (restrictsBuilder_ == null) {
        ensureRestrictsIsMutable();
        restricts_.remove(index);
        onChanged();
      } else {
        restrictsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses categorical tokens. See:
     * https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.Restriction restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction.Builder getRestrictsBuilder(
        int index) {
      return getRestrictsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses categorical tokens. See:
     * https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.Restriction restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.IndexDatapoint.RestrictionOrBuilder getRestrictsOrBuilder(
        int index) {
      if (restrictsBuilder_ == null) {
        return restricts_.get(index);
      } else {
        return restrictsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses categorical tokens. See:
     * https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.Restriction restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1.IndexDatapoint.RestrictionOrBuilder>
        getRestrictsOrBuilderList() {
      if (restrictsBuilder_ != null) {
        return restrictsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(restricts_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses categorical tokens. See:
     * https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.Restriction restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction.Builder addRestrictsBuilder() {
      return getRestrictsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses categorical tokens. See:
     * https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.Restriction restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction.Builder addRestrictsBuilder(
        int index) {
      return getRestrictsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses categorical tokens. See:
     * https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.Restriction restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction.Builder>
        getRestrictsBuilderList() {
      return getRestrictsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction,
            com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction.Builder,
            com.google.cloud.aiplatform.v1.IndexDatapoint.RestrictionOrBuilder>
        getRestrictsFieldBuilder() {
      if (restrictsBuilder_ == null) {
        restrictsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction,
                com.google.cloud.aiplatform.v1.IndexDatapoint.Restriction.Builder,
                com.google.cloud.aiplatform.v1.IndexDatapoint.RestrictionOrBuilder>(
                restricts_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        restricts_ = null;
      }
      return restrictsBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction>
        numericRestricts_ = java.util.Collections.emptyList();

    private void ensureNumericRestrictsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        numericRestricts_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction>(
                numericRestricts_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction,
            com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Builder,
            com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestrictionOrBuilder>
        numericRestrictsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses numeric comparisons.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction numeric_restricts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction>
        getNumericRestrictsList() {
      if (numericRestrictsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(numericRestricts_);
      } else {
        return numericRestrictsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses numeric comparisons.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction numeric_restricts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getNumericRestrictsCount() {
      if (numericRestrictsBuilder_ == null) {
        return numericRestricts_.size();
      } else {
        return numericRestrictsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses numeric comparisons.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction numeric_restricts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction getNumericRestricts(
        int index) {
      if (numericRestrictsBuilder_ == null) {
        return numericRestricts_.get(index);
      } else {
        return numericRestrictsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses numeric comparisons.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction numeric_restricts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNumericRestricts(
        int index, com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction value) {
      if (numericRestrictsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNumericRestrictsIsMutable();
        numericRestricts_.set(index, value);
        onChanged();
      } else {
        numericRestrictsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses numeric comparisons.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction numeric_restricts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNumericRestricts(
        int index,
        com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Builder builderForValue) {
      if (numericRestrictsBuilder_ == null) {
        ensureNumericRestrictsIsMutable();
        numericRestricts_.set(index, builderForValue.build());
        onChanged();
      } else {
        numericRestrictsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses numeric comparisons.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction numeric_restricts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addNumericRestricts(
        com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction value) {
      if (numericRestrictsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNumericRestrictsIsMutable();
        numericRestricts_.add(value);
        onChanged();
      } else {
        numericRestrictsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses numeric comparisons.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction numeric_restricts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addNumericRestricts(
        int index, com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction value) {
      if (numericRestrictsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNumericRestrictsIsMutable();
        numericRestricts_.add(index, value);
        onChanged();
      } else {
        numericRestrictsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses numeric comparisons.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction numeric_restricts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addNumericRestricts(
        com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Builder builderForValue) {
      if (numericRestrictsBuilder_ == null) {
        ensureNumericRestrictsIsMutable();
        numericRestricts_.add(builderForValue.build());
        onChanged();
      } else {
        numericRestrictsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses numeric comparisons.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction numeric_restricts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addNumericRestricts(
        int index,
        com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Builder builderForValue) {
      if (numericRestrictsBuilder_ == null) {
        ensureNumericRestrictsIsMutable();
        numericRestricts_.add(index, builderForValue.build());
        onChanged();
      } else {
        numericRestrictsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses numeric comparisons.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction numeric_restricts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllNumericRestricts(
        java.lang.Iterable<
                ? extends com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction>
            values) {
      if (numericRestrictsBuilder_ == null) {
        ensureNumericRestrictsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, numericRestricts_);
        onChanged();
      } else {
        numericRestrictsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses numeric comparisons.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction numeric_restricts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearNumericRestricts() {
      if (numericRestrictsBuilder_ == null) {
        numericRestricts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        numericRestrictsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses numeric comparisons.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction numeric_restricts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeNumericRestricts(int index) {
      if (numericRestrictsBuilder_ == null) {
        ensureNumericRestrictsIsMutable();
        numericRestricts_.remove(index);
        onChanged();
      } else {
        numericRestrictsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses numeric comparisons.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction numeric_restricts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Builder
        getNumericRestrictsBuilder(int index) {
      return getNumericRestrictsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses numeric comparisons.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction numeric_restricts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestrictionOrBuilder
        getNumericRestrictsOrBuilder(int index) {
      if (numericRestrictsBuilder_ == null) {
        return numericRestricts_.get(index);
      } else {
        return numericRestrictsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses numeric comparisons.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction numeric_restricts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestrictionOrBuilder>
        getNumericRestrictsOrBuilderList() {
      if (numericRestrictsBuilder_ != null) {
        return numericRestrictsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(numericRestricts_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses numeric comparisons.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction numeric_restricts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Builder
        addNumericRestrictsBuilder() {
      return getNumericRestrictsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses numeric comparisons.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction numeric_restricts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Builder
        addNumericRestrictsBuilder(int index) {
      return getNumericRestrictsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Restrict of the datapoint, used to perform "restricted
     * searches" where boolean rule are used to filter the subset of the database
     * eligible for matching. This uses numeric comparisons.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction numeric_restricts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Builder>
        getNumericRestrictsBuilderList() {
      return getNumericRestrictsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction,
            com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Builder,
            com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestrictionOrBuilder>
        getNumericRestrictsFieldBuilder() {
      if (numericRestrictsBuilder_ == null) {
        numericRestrictsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction,
                com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestriction.Builder,
                com.google.cloud.aiplatform.v1.IndexDatapoint.NumericRestrictionOrBuilder>(
                numericRestricts_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        numericRestricts_ = null;
      }
      return numericRestrictsBuilder_;
    }

    private com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag crowdingTag_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag,
            com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag.Builder,
            com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTagOrBuilder>
        crowdingTagBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. CrowdingTag of the datapoint, the number of neighbors to return
     * in each crowding can be configured during query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag crowding_tag = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the crowdingTag field is set.
     */
    public boolean hasCrowdingTag() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. CrowdingTag of the datapoint, the number of neighbors to return
     * in each crowding can be configured during query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag crowding_tag = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The crowdingTag.
     */
    public com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag getCrowdingTag() {
      if (crowdingTagBuilder_ == null) {
        return crowdingTag_ == null
            ? com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag.getDefaultInstance()
            : crowdingTag_;
      } else {
        return crowdingTagBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. CrowdingTag of the datapoint, the number of neighbors to return
     * in each crowding can be configured during query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag crowding_tag = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCrowdingTag(com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag value) {
      if (crowdingTagBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        crowdingTag_ = value;
      } else {
        crowdingTagBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. CrowdingTag of the datapoint, the number of neighbors to return
     * in each crowding can be configured during query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag crowding_tag = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCrowdingTag(
        com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag.Builder builderForValue) {
      if (crowdingTagBuilder_ == null) {
        crowdingTag_ = builderForValue.build();
      } else {
        crowdingTagBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. CrowdingTag of the datapoint, the number of neighbors to return
     * in each crowding can be configured during query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag crowding_tag = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCrowdingTag(
        com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag value) {
      if (crowdingTagBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && crowdingTag_ != null
            && crowdingTag_
                != com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag.getDefaultInstance()) {
          getCrowdingTagBuilder().mergeFrom(value);
        } else {
          crowdingTag_ = value;
        }
      } else {
        crowdingTagBuilder_.mergeFrom(value);
      }
      if (crowdingTag_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. CrowdingTag of the datapoint, the number of neighbors to return
     * in each crowding can be configured during query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag crowding_tag = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCrowdingTag() {
      bitField0_ = (bitField0_ & ~0x00000020);
      crowdingTag_ = null;
      if (crowdingTagBuilder_ != null) {
        crowdingTagBuilder_.dispose();
        crowdingTagBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. CrowdingTag of the datapoint, the number of neighbors to return
     * in each crowding can be configured during query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag crowding_tag = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag.Builder
        getCrowdingTagBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCrowdingTagFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. CrowdingTag of the datapoint, the number of neighbors to return
     * in each crowding can be configured during query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag crowding_tag = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTagOrBuilder
        getCrowdingTagOrBuilder() {
      if (crowdingTagBuilder_ != null) {
        return crowdingTagBuilder_.getMessageOrBuilder();
      } else {
        return crowdingTag_ == null
            ? com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag.getDefaultInstance()
            : crowdingTag_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. CrowdingTag of the datapoint, the number of neighbors to return
     * in each crowding can be configured during query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag crowding_tag = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag,
            com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag.Builder,
            com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTagOrBuilder>
        getCrowdingTagFieldBuilder() {
      if (crowdingTagBuilder_ == null) {
        crowdingTagBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag,
                com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTag.Builder,
                com.google.cloud.aiplatform.v1.IndexDatapoint.CrowdingTagOrBuilder>(
                getCrowdingTag(), getParentForChildren(), isClean());
        crowdingTag_ = null;
      }
      return crowdingTagBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.IndexDatapoint)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.IndexDatapoint)
  private static final com.google.cloud.aiplatform.v1.IndexDatapoint DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.IndexDatapoint();
  }

  public static com.google.cloud.aiplatform.v1.IndexDatapoint getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<IndexDatapoint> PARSER =
      new com.google.protobuf.AbstractParser<IndexDatapoint>() {
        @java.lang.Override
        public IndexDatapoint parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<IndexDatapoint> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<IndexDatapoint> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.IndexDatapoint getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
