/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/tool.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Function calling config.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.FunctionCallingConfig}
 */
public final class FunctionCallingConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.FunctionCallingConfig)
    FunctionCallingConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FunctionCallingConfig.newBuilder() to construct.
  private FunctionCallingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FunctionCallingConfig() {
    mode_ = 0;
    allowedFunctionNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FunctionCallingConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.ToolProto
        .internal_static_google_cloud_aiplatform_v1_FunctionCallingConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.ToolProto
        .internal_static_google_cloud_aiplatform_v1_FunctionCallingConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.FunctionCallingConfig.class,
            com.google.cloud.aiplatform.v1.FunctionCallingConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Function calling mode.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1.FunctionCallingConfig.Mode}
   */
  public enum Mode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified function calling mode. This value should not be used.
     * </pre>
     *
     * <code>MODE_UNSPECIFIED = 0;</code>
     */
    MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Default model behavior, model decides to predict either a function call
     * or a natural language response.
     * </pre>
     *
     * <code>AUTO = 1;</code>
     */
    AUTO(1),
    /**
     *
     *
     * <pre>
     * Model is constrained to always predicting a function call only.
     * If "allowed_function_names" are set, the predicted function call will be
     * limited to any one of "allowed_function_names", else the predicted
     * function call will be any one of the provided "function_declarations".
     * </pre>
     *
     * <code>ANY = 2;</code>
     */
    ANY(2),
    /**
     *
     *
     * <pre>
     * Model will not predict any function call. Model behavior is same as when
     * not passing any function declarations.
     * </pre>
     *
     * <code>NONE = 3;</code>
     */
    NONE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified function calling mode. This value should not be used.
     * </pre>
     *
     * <code>MODE_UNSPECIFIED = 0;</code>
     */
    public static final int MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Default model behavior, model decides to predict either a function call
     * or a natural language response.
     * </pre>
     *
     * <code>AUTO = 1;</code>
     */
    public static final int AUTO_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Model is constrained to always predicting a function call only.
     * If "allowed_function_names" are set, the predicted function call will be
     * limited to any one of "allowed_function_names", else the predicted
     * function call will be any one of the provided "function_declarations".
     * </pre>
     *
     * <code>ANY = 2;</code>
     */
    public static final int ANY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Model will not predict any function call. Model behavior is same as when
     * not passing any function declarations.
     * </pre>
     *
     * <code>NONE = 3;</code>
     */
    public static final int NONE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Mode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Mode forNumber(int value) {
      switch (value) {
        case 0:
          return MODE_UNSPECIFIED;
        case 1:
          return AUTO;
        case 2:
          return ANY;
        case 3:
          return NONE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Mode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Mode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Mode>() {
          public Mode findValueByNumber(int number) {
            return Mode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FunctionCallingConfig.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Mode[] VALUES = values();

    public static Mode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Mode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.FunctionCallingConfig.Mode)
  }

  public static final int MODE_FIELD_NUMBER = 1;
  private int mode_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Function calling mode.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FunctionCallingConfig.Mode mode = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for mode.
   */
  @java.lang.Override
  public int getModeValue() {
    return mode_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Function calling mode.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FunctionCallingConfig.Mode mode = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The mode.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FunctionCallingConfig.Mode getMode() {
    com.google.cloud.aiplatform.v1.FunctionCallingConfig.Mode result =
        com.google.cloud.aiplatform.v1.FunctionCallingConfig.Mode.forNumber(mode_);
    return result == null
        ? com.google.cloud.aiplatform.v1.FunctionCallingConfig.Mode.UNRECOGNIZED
        : result;
  }

  public static final int ALLOWED_FUNCTION_NAMES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList allowedFunctionNames_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. Function names to call. Only set when the Mode is ANY. Function
   * names should match [FunctionDeclaration.name]. With mode set to ANY, model
   * will predict a function call from the set of function names provided.
   * </pre>
   *
   * <code>repeated string allowed_function_names = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the allowedFunctionNames.
   */
  public com.google.protobuf.ProtocolStringList getAllowedFunctionNamesList() {
    return allowedFunctionNames_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Function names to call. Only set when the Mode is ANY. Function
   * names should match [FunctionDeclaration.name]. With mode set to ANY, model
   * will predict a function call from the set of function names provided.
   * </pre>
   *
   * <code>repeated string allowed_function_names = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of allowedFunctionNames.
   */
  public int getAllowedFunctionNamesCount() {
    return allowedFunctionNames_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Function names to call. Only set when the Mode is ANY. Function
   * names should match [FunctionDeclaration.name]. With mode set to ANY, model
   * will predict a function call from the set of function names provided.
   * </pre>
   *
   * <code>repeated string allowed_function_names = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The allowedFunctionNames at the given index.
   */
  public java.lang.String getAllowedFunctionNames(int index) {
    return allowedFunctionNames_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Function names to call. Only set when the Mode is ANY. Function
   * names should match [FunctionDeclaration.name]. With mode set to ANY, model
   * will predict a function call from the set of function names provided.
   * </pre>
   *
   * <code>repeated string allowed_function_names = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the allowedFunctionNames at the given index.
   */
  public com.google.protobuf.ByteString getAllowedFunctionNamesBytes(int index) {
    return allowedFunctionNames_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (mode_
        != com.google.cloud.aiplatform.v1.FunctionCallingConfig.Mode.MODE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, mode_);
    }
    for (int i = 0; i < allowedFunctionNames_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 2, allowedFunctionNames_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (mode_
        != com.google.cloud.aiplatform.v1.FunctionCallingConfig.Mode.MODE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, mode_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < allowedFunctionNames_.size(); i++) {
        dataSize += computeStringSizeNoTag(allowedFunctionNames_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAllowedFunctionNamesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.FunctionCallingConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.FunctionCallingConfig other =
        (com.google.cloud.aiplatform.v1.FunctionCallingConfig) obj;

    if (mode_ != other.mode_) return false;
    if (!getAllowedFunctionNamesList().equals(other.getAllowedFunctionNamesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MODE_FIELD_NUMBER;
    hash = (53 * hash) + mode_;
    if (getAllowedFunctionNamesCount() > 0) {
      hash = (37 * hash) + ALLOWED_FUNCTION_NAMES_FIELD_NUMBER;
      hash = (53 * hash) + getAllowedFunctionNamesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.FunctionCallingConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FunctionCallingConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FunctionCallingConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FunctionCallingConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FunctionCallingConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FunctionCallingConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FunctionCallingConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FunctionCallingConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FunctionCallingConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FunctionCallingConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FunctionCallingConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FunctionCallingConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.FunctionCallingConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Function calling config.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.FunctionCallingConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.FunctionCallingConfig)
      com.google.cloud.aiplatform.v1.FunctionCallingConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_FunctionCallingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_FunctionCallingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.FunctionCallingConfig.class,
              com.google.cloud.aiplatform.v1.FunctionCallingConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.FunctionCallingConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      mode_ = 0;
      allowedFunctionNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_FunctionCallingConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FunctionCallingConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.FunctionCallingConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FunctionCallingConfig build() {
      com.google.cloud.aiplatform.v1.FunctionCallingConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FunctionCallingConfig buildPartial() {
      com.google.cloud.aiplatform.v1.FunctionCallingConfig result =
          new com.google.cloud.aiplatform.v1.FunctionCallingConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.FunctionCallingConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.mode_ = mode_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        allowedFunctionNames_.makeImmutable();
        result.allowedFunctionNames_ = allowedFunctionNames_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.FunctionCallingConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1.FunctionCallingConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.FunctionCallingConfig other) {
      if (other == com.google.cloud.aiplatform.v1.FunctionCallingConfig.getDefaultInstance())
        return this;
      if (other.mode_ != 0) {
        setModeValue(other.getModeValue());
      }
      if (!other.allowedFunctionNames_.isEmpty()) {
        if (allowedFunctionNames_.isEmpty()) {
          allowedFunctionNames_ = other.allowedFunctionNames_;
          bitField0_ |= 0x00000002;
        } else {
          ensureAllowedFunctionNamesIsMutable();
          allowedFunctionNames_.addAll(other.allowedFunctionNames_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                mode_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAllowedFunctionNamesIsMutable();
                allowedFunctionNames_.add(s);
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int mode_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Function calling mode.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FunctionCallingConfig.Mode mode = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for mode.
     */
    @java.lang.Override
    public int getModeValue() {
      return mode_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Function calling mode.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FunctionCallingConfig.Mode mode = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for mode to set.
     * @return This builder for chaining.
     */
    public Builder setModeValue(int value) {
      mode_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Function calling mode.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FunctionCallingConfig.Mode mode = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The mode.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FunctionCallingConfig.Mode getMode() {
      com.google.cloud.aiplatform.v1.FunctionCallingConfig.Mode result =
          com.google.cloud.aiplatform.v1.FunctionCallingConfig.Mode.forNumber(mode_);
      return result == null
          ? com.google.cloud.aiplatform.v1.FunctionCallingConfig.Mode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Function calling mode.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FunctionCallingConfig.Mode mode = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The mode to set.
     * @return This builder for chaining.
     */
    public Builder setMode(com.google.cloud.aiplatform.v1.FunctionCallingConfig.Mode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      mode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Function calling mode.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FunctionCallingConfig.Mode mode = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMode() {
      bitField0_ = (bitField0_ & ~0x00000001);
      mode_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList allowedFunctionNames_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAllowedFunctionNamesIsMutable() {
      if (!allowedFunctionNames_.isModifiable()) {
        allowedFunctionNames_ = new com.google.protobuf.LazyStringArrayList(allowedFunctionNames_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Optional. Function names to call. Only set when the Mode is ANY. Function
     * names should match [FunctionDeclaration.name]. With mode set to ANY, model
     * will predict a function call from the set of function names provided.
     * </pre>
     *
     * <code>repeated string allowed_function_names = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the allowedFunctionNames.
     */
    public com.google.protobuf.ProtocolStringList getAllowedFunctionNamesList() {
      allowedFunctionNames_.makeImmutable();
      return allowedFunctionNames_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Function names to call. Only set when the Mode is ANY. Function
     * names should match [FunctionDeclaration.name]. With mode set to ANY, model
     * will predict a function call from the set of function names provided.
     * </pre>
     *
     * <code>repeated string allowed_function_names = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of allowedFunctionNames.
     */
    public int getAllowedFunctionNamesCount() {
      return allowedFunctionNames_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Function names to call. Only set when the Mode is ANY. Function
     * names should match [FunctionDeclaration.name]. With mode set to ANY, model
     * will predict a function call from the set of function names provided.
     * </pre>
     *
     * <code>repeated string allowed_function_names = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The allowedFunctionNames at the given index.
     */
    public java.lang.String getAllowedFunctionNames(int index) {
      return allowedFunctionNames_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Function names to call. Only set when the Mode is ANY. Function
     * names should match [FunctionDeclaration.name]. With mode set to ANY, model
     * will predict a function call from the set of function names provided.
     * </pre>
     *
     * <code>repeated string allowed_function_names = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allowedFunctionNames at the given index.
     */
    public com.google.protobuf.ByteString getAllowedFunctionNamesBytes(int index) {
      return allowedFunctionNames_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Function names to call. Only set when the Mode is ANY. Function
     * names should match [FunctionDeclaration.name]. With mode set to ANY, model
     * will predict a function call from the set of function names provided.
     * </pre>
     *
     * <code>repeated string allowed_function_names = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The allowedFunctionNames to set.
     * @return This builder for chaining.
     */
    public Builder setAllowedFunctionNames(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowedFunctionNamesIsMutable();
      allowedFunctionNames_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Function names to call. Only set when the Mode is ANY. Function
     * names should match [FunctionDeclaration.name]. With mode set to ANY, model
     * will predict a function call from the set of function names provided.
     * </pre>
     *
     * <code>repeated string allowed_function_names = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The allowedFunctionNames to add.
     * @return This builder for chaining.
     */
    public Builder addAllowedFunctionNames(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowedFunctionNamesIsMutable();
      allowedFunctionNames_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Function names to call. Only set when the Mode is ANY. Function
     * names should match [FunctionDeclaration.name]. With mode set to ANY, model
     * will predict a function call from the set of function names provided.
     * </pre>
     *
     * <code>repeated string allowed_function_names = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The allowedFunctionNames to add.
     * @return This builder for chaining.
     */
    public Builder addAllAllowedFunctionNames(java.lang.Iterable<java.lang.String> values) {
      ensureAllowedFunctionNamesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowedFunctionNames_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Function names to call. Only set when the Mode is ANY. Function
     * names should match [FunctionDeclaration.name]. With mode set to ANY, model
     * will predict a function call from the set of function names provided.
     * </pre>
     *
     * <code>repeated string allowed_function_names = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowedFunctionNames() {
      allowedFunctionNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Function names to call. Only set when the Mode is ANY. Function
     * names should match [FunctionDeclaration.name]. With mode set to ANY, model
     * will predict a function call from the set of function names provided.
     * </pre>
     *
     * <code>repeated string allowed_function_names = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes of the allowedFunctionNames to add.
     * @return This builder for chaining.
     */
    public Builder addAllowedFunctionNamesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAllowedFunctionNamesIsMutable();
      allowedFunctionNames_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.FunctionCallingConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.FunctionCallingConfig)
  private static final com.google.cloud.aiplatform.v1.FunctionCallingConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.FunctionCallingConfig();
  }

  public static com.google.cloud.aiplatform.v1.FunctionCallingConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FunctionCallingConfig> PARSER =
      new com.google.protobuf.AbstractParser<FunctionCallingConfig>() {
        @java.lang.Override
        public FunctionCallingConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FunctionCallingConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FunctionCallingConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FunctionCallingConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
