/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/featurestore_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [FeaturestoreService.DeleteFeatureValues][google.cloud.aiplatform.v1.FeaturestoreService.DeleteFeatureValues].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.DeleteFeatureValuesRequest}
 */
public final class DeleteFeatureValuesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.DeleteFeatureValuesRequest)
    DeleteFeatureValuesRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DeleteFeatureValuesRequest.newBuilder() to construct.
  private DeleteFeatureValuesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DeleteFeatureValuesRequest() {
    entityType_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DeleteFeatureValuesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
        .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
        .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.class,
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.Builder.class);
  }

  public interface SelectEntityOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Selectors choosing feature values of which entity id to be
     * deleted from the EntityType.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EntityIdSelector entity_id_selector = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the entityIdSelector field is set.
     */
    boolean hasEntityIdSelector();
    /**
     *
     *
     * <pre>
     * Required. Selectors choosing feature values of which entity id to be
     * deleted from the EntityType.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EntityIdSelector entity_id_selector = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The entityIdSelector.
     */
    com.google.cloud.aiplatform.v1.EntityIdSelector getEntityIdSelector();
    /**
     *
     *
     * <pre>
     * Required. Selectors choosing feature values of which entity id to be
     * deleted from the EntityType.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EntityIdSelector entity_id_selector = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.aiplatform.v1.EntityIdSelectorOrBuilder getEntityIdSelectorOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Message to select entity.
   * If an entity id is selected, all the feature values corresponding to the
   * entity id will be deleted, including the entityId.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity}
   */
  public static final class SelectEntity extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity)
      SelectEntityOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SelectEntity.newBuilder() to construct.
    private SelectEntity(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SelectEntity() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SelectEntity();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesRequest_SelectEntity_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesRequest_SelectEntity_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity.class,
              com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity.Builder.class);
    }

    private int bitField0_;
    public static final int ENTITY_ID_SELECTOR_FIELD_NUMBER = 1;
    private com.google.cloud.aiplatform.v1.EntityIdSelector entityIdSelector_;
    /**
     *
     *
     * <pre>
     * Required. Selectors choosing feature values of which entity id to be
     * deleted from the EntityType.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EntityIdSelector entity_id_selector = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the entityIdSelector field is set.
     */
    @java.lang.Override
    public boolean hasEntityIdSelector() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Selectors choosing feature values of which entity id to be
     * deleted from the EntityType.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EntityIdSelector entity_id_selector = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The entityIdSelector.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.EntityIdSelector getEntityIdSelector() {
      return entityIdSelector_ == null
          ? com.google.cloud.aiplatform.v1.EntityIdSelector.getDefaultInstance()
          : entityIdSelector_;
    }
    /**
     *
     *
     * <pre>
     * Required. Selectors choosing feature values of which entity id to be
     * deleted from the EntityType.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EntityIdSelector entity_id_selector = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.EntityIdSelectorOrBuilder getEntityIdSelectorOrBuilder() {
      return entityIdSelector_ == null
          ? com.google.cloud.aiplatform.v1.EntityIdSelector.getDefaultInstance()
          : entityIdSelector_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getEntityIdSelector());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEntityIdSelector());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity other =
          (com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity) obj;

      if (hasEntityIdSelector() != other.hasEntityIdSelector()) return false;
      if (hasEntityIdSelector()) {
        if (!getEntityIdSelector().equals(other.getEntityIdSelector())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasEntityIdSelector()) {
        hash = (37 * hash) + ENTITY_ID_SELECTOR_FIELD_NUMBER;
        hash = (53 * hash) + getEntityIdSelector().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Message to select entity.
     * If an entity id is selected, all the feature values corresponding to the
     * entity id will be deleted, including the entityId.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity)
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntityOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesRequest_SelectEntity_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesRequest_SelectEntity_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity.class,
                com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getEntityIdSelectorFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        entityIdSelector_ = null;
        if (entityIdSelectorBuilder_ != null) {
          entityIdSelectorBuilder_.dispose();
          entityIdSelectorBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesRequest_SelectEntity_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity build() {
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity buildPartial() {
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity result =
            new com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.entityIdSelector_ =
              entityIdSelectorBuilder_ == null
                  ? entityIdSelector_
                  : entityIdSelectorBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity other) {
        if (other
            == com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity
                .getDefaultInstance()) return this;
        if (other.hasEntityIdSelector()) {
          mergeEntityIdSelector(other.getEntityIdSelector());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getEntityIdSelectorFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.aiplatform.v1.EntityIdSelector entityIdSelector_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.EntityIdSelector,
              com.google.cloud.aiplatform.v1.EntityIdSelector.Builder,
              com.google.cloud.aiplatform.v1.EntityIdSelectorOrBuilder>
          entityIdSelectorBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Selectors choosing feature values of which entity id to be
       * deleted from the EntityType.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.EntityIdSelector entity_id_selector = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the entityIdSelector field is set.
       */
      public boolean hasEntityIdSelector() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. Selectors choosing feature values of which entity id to be
       * deleted from the EntityType.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.EntityIdSelector entity_id_selector = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The entityIdSelector.
       */
      public com.google.cloud.aiplatform.v1.EntityIdSelector getEntityIdSelector() {
        if (entityIdSelectorBuilder_ == null) {
          return entityIdSelector_ == null
              ? com.google.cloud.aiplatform.v1.EntityIdSelector.getDefaultInstance()
              : entityIdSelector_;
        } else {
          return entityIdSelectorBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Selectors choosing feature values of which entity id to be
       * deleted from the EntityType.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.EntityIdSelector entity_id_selector = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setEntityIdSelector(com.google.cloud.aiplatform.v1.EntityIdSelector value) {
        if (entityIdSelectorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          entityIdSelector_ = value;
        } else {
          entityIdSelectorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Selectors choosing feature values of which entity id to be
       * deleted from the EntityType.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.EntityIdSelector entity_id_selector = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setEntityIdSelector(
          com.google.cloud.aiplatform.v1.EntityIdSelector.Builder builderForValue) {
        if (entityIdSelectorBuilder_ == null) {
          entityIdSelector_ = builderForValue.build();
        } else {
          entityIdSelectorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Selectors choosing feature values of which entity id to be
       * deleted from the EntityType.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.EntityIdSelector entity_id_selector = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeEntityIdSelector(com.google.cloud.aiplatform.v1.EntityIdSelector value) {
        if (entityIdSelectorBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && entityIdSelector_ != null
              && entityIdSelector_
                  != com.google.cloud.aiplatform.v1.EntityIdSelector.getDefaultInstance()) {
            getEntityIdSelectorBuilder().mergeFrom(value);
          } else {
            entityIdSelector_ = value;
          }
        } else {
          entityIdSelectorBuilder_.mergeFrom(value);
        }
        if (entityIdSelector_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Selectors choosing feature values of which entity id to be
       * deleted from the EntityType.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.EntityIdSelector entity_id_selector = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearEntityIdSelector() {
        bitField0_ = (bitField0_ & ~0x00000001);
        entityIdSelector_ = null;
        if (entityIdSelectorBuilder_ != null) {
          entityIdSelectorBuilder_.dispose();
          entityIdSelectorBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Selectors choosing feature values of which entity id to be
       * deleted from the EntityType.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.EntityIdSelector entity_id_selector = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.EntityIdSelector.Builder getEntityIdSelectorBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getEntityIdSelectorFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Selectors choosing feature values of which entity id to be
       * deleted from the EntityType.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.EntityIdSelector entity_id_selector = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.EntityIdSelectorOrBuilder
          getEntityIdSelectorOrBuilder() {
        if (entityIdSelectorBuilder_ != null) {
          return entityIdSelectorBuilder_.getMessageOrBuilder();
        } else {
          return entityIdSelector_ == null
              ? com.google.cloud.aiplatform.v1.EntityIdSelector.getDefaultInstance()
              : entityIdSelector_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Selectors choosing feature values of which entity id to be
       * deleted from the EntityType.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.EntityIdSelector entity_id_selector = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.EntityIdSelector,
              com.google.cloud.aiplatform.v1.EntityIdSelector.Builder,
              com.google.cloud.aiplatform.v1.EntityIdSelectorOrBuilder>
          getEntityIdSelectorFieldBuilder() {
        if (entityIdSelectorBuilder_ == null) {
          entityIdSelectorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.EntityIdSelector,
                  com.google.cloud.aiplatform.v1.EntityIdSelector.Builder,
                  com.google.cloud.aiplatform.v1.EntityIdSelectorOrBuilder>(
                  getEntityIdSelector(), getParentForChildren(), isClean());
          entityIdSelector_ = null;
        }
        return entityIdSelectorBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity)
    private static final com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity();
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SelectEntity> PARSER =
        new com.google.protobuf.AbstractParser<SelectEntity>() {
          @java.lang.Override
          public SelectEntity parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SelectEntity> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SelectEntity> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SelectTimeRangeAndFeatureOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Select feature generated within a half-inclusive time range.
     * The time range is lower inclusive and upper exclusive.
     * </pre>
     *
     * <code>.google.type.Interval time_range = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the timeRange field is set.
     */
    boolean hasTimeRange();
    /**
     *
     *
     * <pre>
     * Required. Select feature generated within a half-inclusive time range.
     * The time range is lower inclusive and upper exclusive.
     * </pre>
     *
     * <code>.google.type.Interval time_range = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The timeRange.
     */
    com.google.type.Interval getTimeRange();
    /**
     *
     *
     * <pre>
     * Required. Select feature generated within a half-inclusive time range.
     * The time range is lower inclusive and upper exclusive.
     * </pre>
     *
     * <code>.google.type.Interval time_range = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    com.google.type.IntervalOrBuilder getTimeRangeOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. Selectors choosing which feature values to be deleted from the
     * EntityType.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the featureSelector field is set.
     */
    boolean hasFeatureSelector();
    /**
     *
     *
     * <pre>
     * Required. Selectors choosing which feature values to be deleted from the
     * EntityType.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The featureSelector.
     */
    com.google.cloud.aiplatform.v1.FeatureSelector getFeatureSelector();
    /**
     *
     *
     * <pre>
     * Required. Selectors choosing which feature values to be deleted from the
     * EntityType.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.aiplatform.v1.FeatureSelectorOrBuilder getFeatureSelectorOrBuilder();

    /**
     *
     *
     * <pre>
     * If set, data will not be deleted from online storage.
     * When time range is older than the data in online storage, setting this to
     * be true will make the deletion have no impact on online serving.
     * </pre>
     *
     * <code>bool skip_online_storage_delete = 3;</code>
     *
     * @return The skipOnlineStorageDelete.
     */
    boolean getSkipOnlineStorageDelete();
  }
  /**
   *
   *
   * <pre>
   * Message to select time range and feature.
   * Values of the selected feature generated within an inclusive time range
   * will be deleted. Using this option permanently deletes the feature values
   * from the specified feature IDs within the specified time range.
   * This might include data from the online storage. If you want to retain
   * any deleted historical data in the online storage, you must re-ingest it.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature}
   */
  public static final class SelectTimeRangeAndFeature extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature)
      SelectTimeRangeAndFeatureOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SelectTimeRangeAndFeature.newBuilder() to construct.
    private SelectTimeRangeAndFeature(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SelectTimeRangeAndFeature() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SelectTimeRangeAndFeature();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesRequest_SelectTimeRangeAndFeature_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesRequest_SelectTimeRangeAndFeature_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
                  .class,
              com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
                  .Builder.class);
    }

    private int bitField0_;
    public static final int TIME_RANGE_FIELD_NUMBER = 1;
    private com.google.type.Interval timeRange_;
    /**
     *
     *
     * <pre>
     * Required. Select feature generated within a half-inclusive time range.
     * The time range is lower inclusive and upper exclusive.
     * </pre>
     *
     * <code>.google.type.Interval time_range = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the timeRange field is set.
     */
    @java.lang.Override
    public boolean hasTimeRange() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Select feature generated within a half-inclusive time range.
     * The time range is lower inclusive and upper exclusive.
     * </pre>
     *
     * <code>.google.type.Interval time_range = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The timeRange.
     */
    @java.lang.Override
    public com.google.type.Interval getTimeRange() {
      return timeRange_ == null ? com.google.type.Interval.getDefaultInstance() : timeRange_;
    }
    /**
     *
     *
     * <pre>
     * Required. Select feature generated within a half-inclusive time range.
     * The time range is lower inclusive and upper exclusive.
     * </pre>
     *
     * <code>.google.type.Interval time_range = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    @java.lang.Override
    public com.google.type.IntervalOrBuilder getTimeRangeOrBuilder() {
      return timeRange_ == null ? com.google.type.Interval.getDefaultInstance() : timeRange_;
    }

    public static final int FEATURE_SELECTOR_FIELD_NUMBER = 2;
    private com.google.cloud.aiplatform.v1.FeatureSelector featureSelector_;
    /**
     *
     *
     * <pre>
     * Required. Selectors choosing which feature values to be deleted from the
     * EntityType.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the featureSelector field is set.
     */
    @java.lang.Override
    public boolean hasFeatureSelector() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Selectors choosing which feature values to be deleted from the
     * EntityType.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The featureSelector.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureSelector getFeatureSelector() {
      return featureSelector_ == null
          ? com.google.cloud.aiplatform.v1.FeatureSelector.getDefaultInstance()
          : featureSelector_;
    }
    /**
     *
     *
     * <pre>
     * Required. Selectors choosing which feature values to be deleted from the
     * EntityType.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureSelectorOrBuilder getFeatureSelectorOrBuilder() {
      return featureSelector_ == null
          ? com.google.cloud.aiplatform.v1.FeatureSelector.getDefaultInstance()
          : featureSelector_;
    }

    public static final int SKIP_ONLINE_STORAGE_DELETE_FIELD_NUMBER = 3;
    private boolean skipOnlineStorageDelete_ = false;
    /**
     *
     *
     * <pre>
     * If set, data will not be deleted from online storage.
     * When time range is older than the data in online storage, setting this to
     * be true will make the deletion have no impact on online serving.
     * </pre>
     *
     * <code>bool skip_online_storage_delete = 3;</code>
     *
     * @return The skipOnlineStorageDelete.
     */
    @java.lang.Override
    public boolean getSkipOnlineStorageDelete() {
      return skipOnlineStorageDelete_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getTimeRange());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getFeatureSelector());
      }
      if (skipOnlineStorageDelete_ != false) {
        output.writeBool(3, skipOnlineStorageDelete_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTimeRange());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getFeatureSelector());
      }
      if (skipOnlineStorageDelete_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, skipOnlineStorageDelete_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature other =
          (com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature) obj;

      if (hasTimeRange() != other.hasTimeRange()) return false;
      if (hasTimeRange()) {
        if (!getTimeRange().equals(other.getTimeRange())) return false;
      }
      if (hasFeatureSelector() != other.hasFeatureSelector()) return false;
      if (hasFeatureSelector()) {
        if (!getFeatureSelector().equals(other.getFeatureSelector())) return false;
      }
      if (getSkipOnlineStorageDelete() != other.getSkipOnlineStorageDelete()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasTimeRange()) {
        hash = (37 * hash) + TIME_RANGE_FIELD_NUMBER;
        hash = (53 * hash) + getTimeRange().hashCode();
      }
      if (hasFeatureSelector()) {
        hash = (37 * hash) + FEATURE_SELECTOR_FIELD_NUMBER;
        hash = (53 * hash) + getFeatureSelector().hashCode();
      }
      hash = (37 * hash) + SKIP_ONLINE_STORAGE_DELETE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSkipOnlineStorageDelete());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
            .SelectTimeRangeAndFeature
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
            .SelectTimeRangeAndFeature
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
            .SelectTimeRangeAndFeature
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
            .SelectTimeRangeAndFeature
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
            .SelectTimeRangeAndFeature
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
            .SelectTimeRangeAndFeature
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
            .SelectTimeRangeAndFeature
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
            .SelectTimeRangeAndFeature
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
            .SelectTimeRangeAndFeature
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
            .SelectTimeRangeAndFeature
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
            .SelectTimeRangeAndFeature
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
            .SelectTimeRangeAndFeature
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Message to select time range and feature.
     * Values of the selected feature generated within an inclusive time range
     * will be deleted. Using this option permanently deletes the feature values
     * from the specified feature IDs within the specified time range.
     * This might include data from the online storage. If you want to retain
     * any deleted historical data in the online storage, you must re-ingest it.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature)
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
            .SelectTimeRangeAndFeatureOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesRequest_SelectTimeRangeAndFeature_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesRequest_SelectTimeRangeAndFeature_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
                    .class,
                com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getTimeRangeFieldBuilder();
          getFeatureSelectorFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        timeRange_ = null;
        if (timeRangeBuilder_ != null) {
          timeRangeBuilder_.dispose();
          timeRangeBuilder_ = null;
        }
        featureSelector_ = null;
        if (featureSelectorBuilder_ != null) {
          featureSelectorBuilder_.dispose();
          featureSelectorBuilder_ = null;
        }
        skipOnlineStorageDelete_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesRequest_SelectTimeRangeAndFeature_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
          build() {
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
          buildPartial() {
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature result =
            new com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
              result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.timeRange_ = timeRangeBuilder_ == null ? timeRange_ : timeRangeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.featureSelector_ =
              featureSelectorBuilder_ == null ? featureSelector_ : featureSelectorBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.skipOnlineStorageDelete_ = skipOnlineStorageDelete_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
              other) {
        if (other
            == com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
                .getDefaultInstance()) return this;
        if (other.hasTimeRange()) {
          mergeTimeRange(other.getTimeRange());
        }
        if (other.hasFeatureSelector()) {
          mergeFeatureSelector(other.getFeatureSelector());
        }
        if (other.getSkipOnlineStorageDelete() != false) {
          setSkipOnlineStorageDelete(other.getSkipOnlineStorageDelete());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getTimeRangeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getFeatureSelectorFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  skipOnlineStorageDelete_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.type.Interval timeRange_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Interval,
              com.google.type.Interval.Builder,
              com.google.type.IntervalOrBuilder>
          timeRangeBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Select feature generated within a half-inclusive time range.
       * The time range is lower inclusive and upper exclusive.
       * </pre>
       *
       * <code>.google.type.Interval time_range = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the timeRange field is set.
       */
      public boolean hasTimeRange() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. Select feature generated within a half-inclusive time range.
       * The time range is lower inclusive and upper exclusive.
       * </pre>
       *
       * <code>.google.type.Interval time_range = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The timeRange.
       */
      public com.google.type.Interval getTimeRange() {
        if (timeRangeBuilder_ == null) {
          return timeRange_ == null ? com.google.type.Interval.getDefaultInstance() : timeRange_;
        } else {
          return timeRangeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Select feature generated within a half-inclusive time range.
       * The time range is lower inclusive and upper exclusive.
       * </pre>
       *
       * <code>.google.type.Interval time_range = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setTimeRange(com.google.type.Interval value) {
        if (timeRangeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timeRange_ = value;
        } else {
          timeRangeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Select feature generated within a half-inclusive time range.
       * The time range is lower inclusive and upper exclusive.
       * </pre>
       *
       * <code>.google.type.Interval time_range = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setTimeRange(com.google.type.Interval.Builder builderForValue) {
        if (timeRangeBuilder_ == null) {
          timeRange_ = builderForValue.build();
        } else {
          timeRangeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Select feature generated within a half-inclusive time range.
       * The time range is lower inclusive and upper exclusive.
       * </pre>
       *
       * <code>.google.type.Interval time_range = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeTimeRange(com.google.type.Interval value) {
        if (timeRangeBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && timeRange_ != null
              && timeRange_ != com.google.type.Interval.getDefaultInstance()) {
            getTimeRangeBuilder().mergeFrom(value);
          } else {
            timeRange_ = value;
          }
        } else {
          timeRangeBuilder_.mergeFrom(value);
        }
        if (timeRange_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Select feature generated within a half-inclusive time range.
       * The time range is lower inclusive and upper exclusive.
       * </pre>
       *
       * <code>.google.type.Interval time_range = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearTimeRange() {
        bitField0_ = (bitField0_ & ~0x00000001);
        timeRange_ = null;
        if (timeRangeBuilder_ != null) {
          timeRangeBuilder_.dispose();
          timeRangeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Select feature generated within a half-inclusive time range.
       * The time range is lower inclusive and upper exclusive.
       * </pre>
       *
       * <code>.google.type.Interval time_range = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.type.Interval.Builder getTimeRangeBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getTimeRangeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Select feature generated within a half-inclusive time range.
       * The time range is lower inclusive and upper exclusive.
       * </pre>
       *
       * <code>.google.type.Interval time_range = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.type.IntervalOrBuilder getTimeRangeOrBuilder() {
        if (timeRangeBuilder_ != null) {
          return timeRangeBuilder_.getMessageOrBuilder();
        } else {
          return timeRange_ == null ? com.google.type.Interval.getDefaultInstance() : timeRange_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Select feature generated within a half-inclusive time range.
       * The time range is lower inclusive and upper exclusive.
       * </pre>
       *
       * <code>.google.type.Interval time_range = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Interval,
              com.google.type.Interval.Builder,
              com.google.type.IntervalOrBuilder>
          getTimeRangeFieldBuilder() {
        if (timeRangeBuilder_ == null) {
          timeRangeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Interval,
                  com.google.type.Interval.Builder,
                  com.google.type.IntervalOrBuilder>(
                  getTimeRange(), getParentForChildren(), isClean());
          timeRange_ = null;
        }
        return timeRangeBuilder_;
      }

      private com.google.cloud.aiplatform.v1.FeatureSelector featureSelector_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.FeatureSelector,
              com.google.cloud.aiplatform.v1.FeatureSelector.Builder,
              com.google.cloud.aiplatform.v1.FeatureSelectorOrBuilder>
          featureSelectorBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Selectors choosing which feature values to be deleted from the
       * EntityType.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the featureSelector field is set.
       */
      public boolean hasFeatureSelector() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. Selectors choosing which feature values to be deleted from the
       * EntityType.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The featureSelector.
       */
      public com.google.cloud.aiplatform.v1.FeatureSelector getFeatureSelector() {
        if (featureSelectorBuilder_ == null) {
          return featureSelector_ == null
              ? com.google.cloud.aiplatform.v1.FeatureSelector.getDefaultInstance()
              : featureSelector_;
        } else {
          return featureSelectorBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Selectors choosing which feature values to be deleted from the
       * EntityType.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setFeatureSelector(com.google.cloud.aiplatform.v1.FeatureSelector value) {
        if (featureSelectorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          featureSelector_ = value;
        } else {
          featureSelectorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Selectors choosing which feature values to be deleted from the
       * EntityType.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setFeatureSelector(
          com.google.cloud.aiplatform.v1.FeatureSelector.Builder builderForValue) {
        if (featureSelectorBuilder_ == null) {
          featureSelector_ = builderForValue.build();
        } else {
          featureSelectorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Selectors choosing which feature values to be deleted from the
       * EntityType.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeFeatureSelector(com.google.cloud.aiplatform.v1.FeatureSelector value) {
        if (featureSelectorBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && featureSelector_ != null
              && featureSelector_
                  != com.google.cloud.aiplatform.v1.FeatureSelector.getDefaultInstance()) {
            getFeatureSelectorBuilder().mergeFrom(value);
          } else {
            featureSelector_ = value;
          }
        } else {
          featureSelectorBuilder_.mergeFrom(value);
        }
        if (featureSelector_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Selectors choosing which feature values to be deleted from the
       * EntityType.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearFeatureSelector() {
        bitField0_ = (bitField0_ & ~0x00000002);
        featureSelector_ = null;
        if (featureSelectorBuilder_ != null) {
          featureSelectorBuilder_.dispose();
          featureSelectorBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Selectors choosing which feature values to be deleted from the
       * EntityType.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.FeatureSelector.Builder getFeatureSelectorBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getFeatureSelectorFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Selectors choosing which feature values to be deleted from the
       * EntityType.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.FeatureSelectorOrBuilder getFeatureSelectorOrBuilder() {
        if (featureSelectorBuilder_ != null) {
          return featureSelectorBuilder_.getMessageOrBuilder();
        } else {
          return featureSelector_ == null
              ? com.google.cloud.aiplatform.v1.FeatureSelector.getDefaultInstance()
              : featureSelector_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Selectors choosing which feature values to be deleted from the
       * EntityType.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.FeatureSelector,
              com.google.cloud.aiplatform.v1.FeatureSelector.Builder,
              com.google.cloud.aiplatform.v1.FeatureSelectorOrBuilder>
          getFeatureSelectorFieldBuilder() {
        if (featureSelectorBuilder_ == null) {
          featureSelectorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.FeatureSelector,
                  com.google.cloud.aiplatform.v1.FeatureSelector.Builder,
                  com.google.cloud.aiplatform.v1.FeatureSelectorOrBuilder>(
                  getFeatureSelector(), getParentForChildren(), isClean());
          featureSelector_ = null;
        }
        return featureSelectorBuilder_;
      }

      private boolean skipOnlineStorageDelete_;
      /**
       *
       *
       * <pre>
       * If set, data will not be deleted from online storage.
       * When time range is older than the data in online storage, setting this to
       * be true will make the deletion have no impact on online serving.
       * </pre>
       *
       * <code>bool skip_online_storage_delete = 3;</code>
       *
       * @return The skipOnlineStorageDelete.
       */
      @java.lang.Override
      public boolean getSkipOnlineStorageDelete() {
        return skipOnlineStorageDelete_;
      }
      /**
       *
       *
       * <pre>
       * If set, data will not be deleted from online storage.
       * When time range is older than the data in online storage, setting this to
       * be true will make the deletion have no impact on online serving.
       * </pre>
       *
       * <code>bool skip_online_storage_delete = 3;</code>
       *
       * @param value The skipOnlineStorageDelete to set.
       * @return This builder for chaining.
       */
      public Builder setSkipOnlineStorageDelete(boolean value) {

        skipOnlineStorageDelete_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, data will not be deleted from online storage.
       * When time range is older than the data in online storage, setting this to
       * be true will make the deletion have no impact on online serving.
       * </pre>
       *
       * <code>bool skip_online_storage_delete = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSkipOnlineStorageDelete() {
        bitField0_ = (bitField0_ & ~0x00000004);
        skipOnlineStorageDelete_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature)
    private static final com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
            .SelectTimeRangeAndFeature
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature();
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
            .SelectTimeRangeAndFeature
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SelectTimeRangeAndFeature> PARSER =
        new com.google.protobuf.AbstractParser<SelectTimeRangeAndFeature>() {
          @java.lang.Override
          public SelectTimeRangeAndFeature parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SelectTimeRangeAndFeature> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SelectTimeRangeAndFeature> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int deleteOptionCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object deleteOption_;

  public enum DeleteOptionCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SELECT_ENTITY(2),
    SELECT_TIME_RANGE_AND_FEATURE(3),
    DELETEOPTION_NOT_SET(0);
    private final int value;

    private DeleteOptionCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DeleteOptionCase valueOf(int value) {
      return forNumber(value);
    }

    public static DeleteOptionCase forNumber(int value) {
      switch (value) {
        case 2:
          return SELECT_ENTITY;
        case 3:
          return SELECT_TIME_RANGE_AND_FEATURE;
        case 0:
          return DELETEOPTION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DeleteOptionCase getDeleteOptionCase() {
    return DeleteOptionCase.forNumber(deleteOptionCase_);
  }

  public static final int SELECT_ENTITY_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Select feature values to be deleted by specifying entities.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity select_entity = 2;
   * </code>
   *
   * @return Whether the selectEntity field is set.
   */
  @java.lang.Override
  public boolean hasSelectEntity() {
    return deleteOptionCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Select feature values to be deleted by specifying entities.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity select_entity = 2;
   * </code>
   *
   * @return The selectEntity.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity getSelectEntity() {
    if (deleteOptionCase_ == 2) {
      return (com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity) deleteOption_;
    }
    return com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Select feature values to be deleted by specifying entities.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity select_entity = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntityOrBuilder
      getSelectEntityOrBuilder() {
    if (deleteOptionCase_ == 2) {
      return (com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity) deleteOption_;
    }
    return com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity
        .getDefaultInstance();
  }

  public static final int SELECT_TIME_RANGE_AND_FEATURE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Select feature values to be deleted by specifying time range and
   * features.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature select_time_range_and_feature = 3;
   * </code>
   *
   * @return Whether the selectTimeRangeAndFeature field is set.
   */
  @java.lang.Override
  public boolean hasSelectTimeRangeAndFeature() {
    return deleteOptionCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Select feature values to be deleted by specifying time range and
   * features.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature select_time_range_and_feature = 3;
   * </code>
   *
   * @return The selectTimeRangeAndFeature.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
      getSelectTimeRangeAndFeature() {
    if (deleteOptionCase_ == 3) {
      return (com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature)
          deleteOption_;
    }
    return com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Select feature values to be deleted by specifying time range and
   * features.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature select_time_range_and_feature = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
          .SelectTimeRangeAndFeatureOrBuilder
      getSelectTimeRangeAndFeatureOrBuilder() {
    if (deleteOptionCase_ == 3) {
      return (com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature)
          deleteOption_;
    }
    return com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
        .getDefaultInstance();
  }

  public static final int ENTITY_TYPE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object entityType_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the EntityType grouping the Features for
   * which values are being deleted from. Format:
   * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
   * </pre>
   *
   * <code>
   * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The entityType.
   */
  @java.lang.Override
  public java.lang.String getEntityType() {
    java.lang.Object ref = entityType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      entityType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the EntityType grouping the Features for
   * which values are being deleted from. Format:
   * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
   * </pre>
   *
   * <code>
   * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for entityType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEntityTypeBytes() {
    java.lang.Object ref = entityType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      entityType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, entityType_);
    }
    if (deleteOptionCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity) deleteOption_);
    }
    if (deleteOptionCase_ == 3) {
      output.writeMessage(
          3,
          (com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature)
              deleteOption_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, entityType_);
    }
    if (deleteOptionCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity)
                  deleteOption_);
    }
    if (deleteOptionCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3,
              (com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature)
                  deleteOption_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest other =
        (com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest) obj;

    if (!getEntityType().equals(other.getEntityType())) return false;
    if (!getDeleteOptionCase().equals(other.getDeleteOptionCase())) return false;
    switch (deleteOptionCase_) {
      case 2:
        if (!getSelectEntity().equals(other.getSelectEntity())) return false;
        break;
      case 3:
        if (!getSelectTimeRangeAndFeature().equals(other.getSelectTimeRangeAndFeature()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ENTITY_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getEntityType().hashCode();
    switch (deleteOptionCase_) {
      case 2:
        hash = (37 * hash) + SELECT_ENTITY_FIELD_NUMBER;
        hash = (53 * hash) + getSelectEntity().hashCode();
        break;
      case 3:
        hash = (37 * hash) + SELECT_TIME_RANGE_AND_FEATURE_FIELD_NUMBER;
        hash = (53 * hash) + getSelectTimeRangeAndFeature().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [FeaturestoreService.DeleteFeatureValues][google.cloud.aiplatform.v1.FeaturestoreService.DeleteFeatureValues].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.DeleteFeatureValuesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.DeleteFeatureValuesRequest)
      com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.class,
              com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (selectEntityBuilder_ != null) {
        selectEntityBuilder_.clear();
      }
      if (selectTimeRangeAndFeatureBuilder_ != null) {
        selectTimeRangeAndFeatureBuilder_.clear();
      }
      entityType_ = "";
      deleteOptionCase_ = 0;
      deleteOption_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest build() {
      com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest buildPartial() {
      com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest result =
          new com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.entityType_ = entityType_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest result) {
      result.deleteOptionCase_ = deleteOptionCase_;
      result.deleteOption_ = this.deleteOption_;
      if (deleteOptionCase_ == 2 && selectEntityBuilder_ != null) {
        result.deleteOption_ = selectEntityBuilder_.build();
      }
      if (deleteOptionCase_ == 3 && selectTimeRangeAndFeatureBuilder_ != null) {
        result.deleteOption_ = selectTimeRangeAndFeatureBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest other) {
      if (other == com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.getDefaultInstance())
        return this;
      if (!other.getEntityType().isEmpty()) {
        entityType_ = other.entityType_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      switch (other.getDeleteOptionCase()) {
        case SELECT_ENTITY:
          {
            mergeSelectEntity(other.getSelectEntity());
            break;
          }
        case SELECT_TIME_RANGE_AND_FEATURE:
          {
            mergeSelectTimeRangeAndFeature(other.getSelectTimeRangeAndFeature());
            break;
          }
        case DELETEOPTION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                entityType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getSelectEntityFieldBuilder().getBuilder(), extensionRegistry);
                deleteOptionCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getSelectTimeRangeAndFeatureFieldBuilder().getBuilder(), extensionRegistry);
                deleteOptionCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int deleteOptionCase_ = 0;
    private java.lang.Object deleteOption_;

    public DeleteOptionCase getDeleteOptionCase() {
      return DeleteOptionCase.forNumber(deleteOptionCase_);
    }

    public Builder clearDeleteOption() {
      deleteOptionCase_ = 0;
      deleteOption_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity,
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity.Builder,
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntityOrBuilder>
        selectEntityBuilder_;
    /**
     *
     *
     * <pre>
     * Select feature values to be deleted by specifying entities.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity select_entity = 2;
     * </code>
     *
     * @return Whether the selectEntity field is set.
     */
    @java.lang.Override
    public boolean hasSelectEntity() {
      return deleteOptionCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Select feature values to be deleted by specifying entities.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity select_entity = 2;
     * </code>
     *
     * @return The selectEntity.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity
        getSelectEntity() {
      if (selectEntityBuilder_ == null) {
        if (deleteOptionCase_ == 2) {
          return (com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity)
              deleteOption_;
        }
        return com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity
            .getDefaultInstance();
      } else {
        if (deleteOptionCase_ == 2) {
          return selectEntityBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Select feature values to be deleted by specifying entities.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity select_entity = 2;
     * </code>
     */
    public Builder setSelectEntity(
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity value) {
      if (selectEntityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deleteOption_ = value;
        onChanged();
      } else {
        selectEntityBuilder_.setMessage(value);
      }
      deleteOptionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Select feature values to be deleted by specifying entities.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity select_entity = 2;
     * </code>
     */
    public Builder setSelectEntity(
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity.Builder
            builderForValue) {
      if (selectEntityBuilder_ == null) {
        deleteOption_ = builderForValue.build();
        onChanged();
      } else {
        selectEntityBuilder_.setMessage(builderForValue.build());
      }
      deleteOptionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Select feature values to be deleted by specifying entities.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity select_entity = 2;
     * </code>
     */
    public Builder mergeSelectEntity(
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity value) {
      if (selectEntityBuilder_ == null) {
        if (deleteOptionCase_ == 2
            && deleteOption_
                != com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity
                    .getDefaultInstance()) {
          deleteOption_ =
              com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity.newBuilder(
                      (com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity)
                          deleteOption_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          deleteOption_ = value;
        }
        onChanged();
      } else {
        if (deleteOptionCase_ == 2) {
          selectEntityBuilder_.mergeFrom(value);
        } else {
          selectEntityBuilder_.setMessage(value);
        }
      }
      deleteOptionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Select feature values to be deleted by specifying entities.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity select_entity = 2;
     * </code>
     */
    public Builder clearSelectEntity() {
      if (selectEntityBuilder_ == null) {
        if (deleteOptionCase_ == 2) {
          deleteOptionCase_ = 0;
          deleteOption_ = null;
          onChanged();
        }
      } else {
        if (deleteOptionCase_ == 2) {
          deleteOptionCase_ = 0;
          deleteOption_ = null;
        }
        selectEntityBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Select feature values to be deleted by specifying entities.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity select_entity = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity.Builder
        getSelectEntityBuilder() {
      return getSelectEntityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Select feature values to be deleted by specifying entities.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity select_entity = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntityOrBuilder
        getSelectEntityOrBuilder() {
      if ((deleteOptionCase_ == 2) && (selectEntityBuilder_ != null)) {
        return selectEntityBuilder_.getMessageOrBuilder();
      } else {
        if (deleteOptionCase_ == 2) {
          return (com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity)
              deleteOption_;
        }
        return com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Select feature values to be deleted by specifying entities.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity select_entity = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity,
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity.Builder,
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntityOrBuilder>
        getSelectEntityFieldBuilder() {
      if (selectEntityBuilder_ == null) {
        if (!(deleteOptionCase_ == 2)) {
          deleteOption_ =
              com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity
                  .getDefaultInstance();
        }
        selectEntityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity,
                com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity.Builder,
                com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntityOrBuilder>(
                (com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity)
                    deleteOption_,
                getParentForChildren(),
                isClean());
        deleteOption_ = null;
      }
      deleteOptionCase_ = 2;
      onChanged();
      return selectEntityBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature,
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
                .Builder,
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
                .SelectTimeRangeAndFeatureOrBuilder>
        selectTimeRangeAndFeatureBuilder_;
    /**
     *
     *
     * <pre>
     * Select feature values to be deleted by specifying time range and
     * features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature select_time_range_and_feature = 3;
     * </code>
     *
     * @return Whether the selectTimeRangeAndFeature field is set.
     */
    @java.lang.Override
    public boolean hasSelectTimeRangeAndFeature() {
      return deleteOptionCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Select feature values to be deleted by specifying time range and
     * features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature select_time_range_and_feature = 3;
     * </code>
     *
     * @return The selectTimeRangeAndFeature.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
        getSelectTimeRangeAndFeature() {
      if (selectTimeRangeAndFeatureBuilder_ == null) {
        if (deleteOptionCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
                  .SelectTimeRangeAndFeature)
              deleteOption_;
        }
        return com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
            .getDefaultInstance();
      } else {
        if (deleteOptionCase_ == 3) {
          return selectTimeRangeAndFeatureBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Select feature values to be deleted by specifying time range and
     * features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature select_time_range_and_feature = 3;
     * </code>
     */
    public Builder setSelectTimeRangeAndFeature(
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature value) {
      if (selectTimeRangeAndFeatureBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deleteOption_ = value;
        onChanged();
      } else {
        selectTimeRangeAndFeatureBuilder_.setMessage(value);
      }
      deleteOptionCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Select feature values to be deleted by specifying time range and
     * features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature select_time_range_and_feature = 3;
     * </code>
     */
    public Builder setSelectTimeRangeAndFeature(
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature.Builder
            builderForValue) {
      if (selectTimeRangeAndFeatureBuilder_ == null) {
        deleteOption_ = builderForValue.build();
        onChanged();
      } else {
        selectTimeRangeAndFeatureBuilder_.setMessage(builderForValue.build());
      }
      deleteOptionCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Select feature values to be deleted by specifying time range and
     * features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature select_time_range_and_feature = 3;
     * </code>
     */
    public Builder mergeSelectTimeRangeAndFeature(
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature value) {
      if (selectTimeRangeAndFeatureBuilder_ == null) {
        if (deleteOptionCase_ == 3
            && deleteOption_
                != com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
                    .SelectTimeRangeAndFeature.getDefaultInstance()) {
          deleteOption_ =
              com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
                  .newBuilder(
                      (com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
                              .SelectTimeRangeAndFeature)
                          deleteOption_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          deleteOption_ = value;
        }
        onChanged();
      } else {
        if (deleteOptionCase_ == 3) {
          selectTimeRangeAndFeatureBuilder_.mergeFrom(value);
        } else {
          selectTimeRangeAndFeatureBuilder_.setMessage(value);
        }
      }
      deleteOptionCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Select feature values to be deleted by specifying time range and
     * features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature select_time_range_and_feature = 3;
     * </code>
     */
    public Builder clearSelectTimeRangeAndFeature() {
      if (selectTimeRangeAndFeatureBuilder_ == null) {
        if (deleteOptionCase_ == 3) {
          deleteOptionCase_ = 0;
          deleteOption_ = null;
          onChanged();
        }
      } else {
        if (deleteOptionCase_ == 3) {
          deleteOptionCase_ = 0;
          deleteOption_ = null;
        }
        selectTimeRangeAndFeatureBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Select feature values to be deleted by specifying time range and
     * features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature select_time_range_and_feature = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
            .Builder
        getSelectTimeRangeAndFeatureBuilder() {
      return getSelectTimeRangeAndFeatureFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Select feature values to be deleted by specifying time range and
     * features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature select_time_range_and_feature = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
            .SelectTimeRangeAndFeatureOrBuilder
        getSelectTimeRangeAndFeatureOrBuilder() {
      if ((deleteOptionCase_ == 3) && (selectTimeRangeAndFeatureBuilder_ != null)) {
        return selectTimeRangeAndFeatureBuilder_.getMessageOrBuilder();
      } else {
        if (deleteOptionCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
                  .SelectTimeRangeAndFeature)
              deleteOption_;
        }
        return com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Select feature values to be deleted by specifying time range and
     * features.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature select_time_range_and_feature = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature,
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
                .Builder,
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
                .SelectTimeRangeAndFeatureOrBuilder>
        getSelectTimeRangeAndFeatureFieldBuilder() {
      if (selectTimeRangeAndFeatureBuilder_ == null) {
        if (!(deleteOptionCase_ == 3)) {
          deleteOption_ =
              com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
                  .getDefaultInstance();
        }
        selectTimeRangeAndFeatureBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature,
                com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
                    .Builder,
                com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
                    .SelectTimeRangeAndFeatureOrBuilder>(
                (com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
                        .SelectTimeRangeAndFeature)
                    deleteOption_,
                getParentForChildren(),
                isClean());
        deleteOption_ = null;
      }
      deleteOptionCase_ = 3;
      onChanged();
      return selectTimeRangeAndFeatureBuilder_;
    }

    private java.lang.Object entityType_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the EntityType grouping the Features for
     * which values are being deleted from. Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
     * </pre>
     *
     * <code>
     * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The entityType.
     */
    public java.lang.String getEntityType() {
      java.lang.Object ref = entityType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entityType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the EntityType grouping the Features for
     * which values are being deleted from. Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
     * </pre>
     *
     * <code>
     * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for entityType.
     */
    public com.google.protobuf.ByteString getEntityTypeBytes() {
      java.lang.Object ref = entityType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entityType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the EntityType grouping the Features for
     * which values are being deleted from. Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
     * </pre>
     *
     * <code>
     * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The entityType to set.
     * @return This builder for chaining.
     */
    public Builder setEntityType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      entityType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the EntityType grouping the Features for
     * which values are being deleted from. Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
     * </pre>
     *
     * <code>
     * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntityType() {
      entityType_ = getDefaultInstance().getEntityType();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the EntityType grouping the Features for
     * which values are being deleted from. Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
     * </pre>
     *
     * <code>
     * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for entityType to set.
     * @return This builder for chaining.
     */
    public Builder setEntityTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      entityType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.DeleteFeatureValuesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.DeleteFeatureValuesRequest)
  private static final com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest();
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DeleteFeatureValuesRequest> PARSER =
      new com.google.protobuf.AbstractParser<DeleteFeatureValuesRequest>() {
        @java.lang.Override
        public DeleteFeatureValuesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DeleteFeatureValuesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DeleteFeatureValuesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeleteFeatureValuesRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
