/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/vizier_service.proto

package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [VizierService.SuggestTrials][google.cloud.aiplatform.v1.VizierService.SuggestTrials].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.SuggestTrialsRequest}
 */
public final class SuggestTrialsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.SuggestTrialsRequest)
    SuggestTrialsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SuggestTrialsRequest.newBuilder() to construct.
  private SuggestTrialsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SuggestTrialsRequest() {
    parent_ = "";
    clientId_ = "";
    contexts_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SuggestTrialsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.VizierServiceProto
        .internal_static_google_cloud_aiplatform_v1_SuggestTrialsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.VizierServiceProto
        .internal_static_google_cloud_aiplatform_v1_SuggestTrialsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.SuggestTrialsRequest.class,
            com.google.cloud.aiplatform.v1.SuggestTrialsRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The project and location that the Study belongs to.
   * Format: `projects/{project}/locations/{location}/studies/{study}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The project and location that the Study belongs to.
   * Format: `projects/{project}/locations/{location}/studies/{study}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUGGESTION_COUNT_FIELD_NUMBER = 2;
  private int suggestionCount_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The number of suggestions requested. It must be positive.
   * </pre>
   *
   * <code>int32 suggestion_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The suggestionCount.
   */
  @java.lang.Override
  public int getSuggestionCount() {
    return suggestionCount_;
  }

  public static final int CLIENT_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clientId_ = "";
  /**
   *
   *
   * <pre>
   * Required. The identifier of the client that is requesting the suggestion.
   *
   * If multiple SuggestTrialsRequests have the same `client_id`,
   * the service will return the identical suggested Trial if the Trial is
   * pending, and provide a new Trial if the last suggested Trial was completed.
   * </pre>
   *
   * <code>string client_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The clientId.
   */
  @java.lang.Override
  public java.lang.String getClientId() {
    java.lang.Object ref = clientId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clientId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The identifier of the client that is requesting the suggestion.
   *
   * If multiple SuggestTrialsRequests have the same `client_id`,
   * the service will return the identical suggested Trial if the Trial is
   * pending, and provide a new Trial if the last suggested Trial was completed.
   * </pre>
   *
   * <code>string client_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for clientId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClientIdBytes() {
    java.lang.Object ref = clientId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clientId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTEXTS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.TrialContext> contexts_;
  /**
   *
   *
   * <pre>
   * Optional. This allows you to specify the "context" for a Trial; a context
   * is a slice (a subspace) of the search space.
   *
   * Typical uses for contexts:
   * 1) You are using Vizier to tune a server for best performance, but there's
   *   a strong weekly cycle.  The context specifies the day-of-week.
   *   This allows Tuesday to generalize from Wednesday without assuming that
   *   everything is identical.
   * 2) Imagine you're optimizing some medical treatment for people.
   *   As they walk in the door, you know certain facts about them
   *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
   *   context, and Vizier will adapt its suggestions to the patient.
   * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
   *   conditions as contexts, and Vizier will generalize between "A" and "B"
   *   conditions.  If they are similar, this will allow Vizier to converge
   *   to the optimum faster than if "A" and "B" were separate Studies.
   *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
   *   CreateTrial() RPC; that's the asynchronous option where you don't need a
   *   close association between contexts and suggestions.
   *
   * NOTE: All the Parameters you set in a context MUST be defined in the
   *   Study.
   * NOTE: You must supply 0 or $suggestion_count contexts.
   *   If you don't supply any contexts, Vizier will make suggestions
   *   from the full search space specified in the StudySpec; if you supply
   *   a full set of context, each suggestion will match the corresponding
   *   context.
   * NOTE: A Context with no features set matches anything, and allows
   *   suggestions from the full search space.
   * NOTE: Contexts MUST lie within the search space specified in the
   *   StudySpec.  It's an error if they don't.
   * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
   *   new suggestions are generated.
   * NOTE: Generation of suggestions involves a match between a Context and
   *   (optionally) a REQUESTED trial; if that match is not fully specified, a
   *   suggestion will be geneated in the merged subspace.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.TrialContext> getContextsList() {
    return contexts_;
  }
  /**
   *
   *
   * <pre>
   * Optional. This allows you to specify the "context" for a Trial; a context
   * is a slice (a subspace) of the search space.
   *
   * Typical uses for contexts:
   * 1) You are using Vizier to tune a server for best performance, but there's
   *   a strong weekly cycle.  The context specifies the day-of-week.
   *   This allows Tuesday to generalize from Wednesday without assuming that
   *   everything is identical.
   * 2) Imagine you're optimizing some medical treatment for people.
   *   As they walk in the door, you know certain facts about them
   *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
   *   context, and Vizier will adapt its suggestions to the patient.
   * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
   *   conditions as contexts, and Vizier will generalize between "A" and "B"
   *   conditions.  If they are similar, this will allow Vizier to converge
   *   to the optimum faster than if "A" and "B" were separate Studies.
   *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
   *   CreateTrial() RPC; that's the asynchronous option where you don't need a
   *   close association between contexts and suggestions.
   *
   * NOTE: All the Parameters you set in a context MUST be defined in the
   *   Study.
   * NOTE: You must supply 0 or $suggestion_count contexts.
   *   If you don't supply any contexts, Vizier will make suggestions
   *   from the full search space specified in the StudySpec; if you supply
   *   a full set of context, each suggestion will match the corresponding
   *   context.
   * NOTE: A Context with no features set matches anything, and allows
   *   suggestions from the full search space.
   * NOTE: Contexts MUST lie within the search space specified in the
   *   StudySpec.  It's an error if they don't.
   * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
   *   new suggestions are generated.
   * NOTE: Generation of suggestions involves a match between a Context and
   *   (optionally) a REQUESTED trial; if that match is not fully specified, a
   *   suggestion will be geneated in the merged subspace.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.TrialContextOrBuilder>
      getContextsOrBuilderList() {
    return contexts_;
  }
  /**
   *
   *
   * <pre>
   * Optional. This allows you to specify the "context" for a Trial; a context
   * is a slice (a subspace) of the search space.
   *
   * Typical uses for contexts:
   * 1) You are using Vizier to tune a server for best performance, but there's
   *   a strong weekly cycle.  The context specifies the day-of-week.
   *   This allows Tuesday to generalize from Wednesday without assuming that
   *   everything is identical.
   * 2) Imagine you're optimizing some medical treatment for people.
   *   As they walk in the door, you know certain facts about them
   *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
   *   context, and Vizier will adapt its suggestions to the patient.
   * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
   *   conditions as contexts, and Vizier will generalize between "A" and "B"
   *   conditions.  If they are similar, this will allow Vizier to converge
   *   to the optimum faster than if "A" and "B" were separate Studies.
   *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
   *   CreateTrial() RPC; that's the asynchronous option where you don't need a
   *   close association between contexts and suggestions.
   *
   * NOTE: All the Parameters you set in a context MUST be defined in the
   *   Study.
   * NOTE: You must supply 0 or $suggestion_count contexts.
   *   If you don't supply any contexts, Vizier will make suggestions
   *   from the full search space specified in the StudySpec; if you supply
   *   a full set of context, each suggestion will match the corresponding
   *   context.
   * NOTE: A Context with no features set matches anything, and allows
   *   suggestions from the full search space.
   * NOTE: Contexts MUST lie within the search space specified in the
   *   StudySpec.  It's an error if they don't.
   * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
   *   new suggestions are generated.
   * NOTE: Generation of suggestions involves a match between a Context and
   *   (optionally) a REQUESTED trial; if that match is not fully specified, a
   *   suggestion will be geneated in the merged subspace.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getContextsCount() {
    return contexts_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. This allows you to specify the "context" for a Trial; a context
   * is a slice (a subspace) of the search space.
   *
   * Typical uses for contexts:
   * 1) You are using Vizier to tune a server for best performance, but there's
   *   a strong weekly cycle.  The context specifies the day-of-week.
   *   This allows Tuesday to generalize from Wednesday without assuming that
   *   everything is identical.
   * 2) Imagine you're optimizing some medical treatment for people.
   *   As they walk in the door, you know certain facts about them
   *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
   *   context, and Vizier will adapt its suggestions to the patient.
   * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
   *   conditions as contexts, and Vizier will generalize between "A" and "B"
   *   conditions.  If they are similar, this will allow Vizier to converge
   *   to the optimum faster than if "A" and "B" were separate Studies.
   *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
   *   CreateTrial() RPC; that's the asynchronous option where you don't need a
   *   close association between contexts and suggestions.
   *
   * NOTE: All the Parameters you set in a context MUST be defined in the
   *   Study.
   * NOTE: You must supply 0 or $suggestion_count contexts.
   *   If you don't supply any contexts, Vizier will make suggestions
   *   from the full search space specified in the StudySpec; if you supply
   *   a full set of context, each suggestion will match the corresponding
   *   context.
   * NOTE: A Context with no features set matches anything, and allows
   *   suggestions from the full search space.
   * NOTE: Contexts MUST lie within the search space specified in the
   *   StudySpec.  It's an error if they don't.
   * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
   *   new suggestions are generated.
   * NOTE: Generation of suggestions involves a match between a Context and
   *   (optionally) a REQUESTED trial; if that match is not fully specified, a
   *   suggestion will be geneated in the merged subspace.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.TrialContext getContexts(int index) {
    return contexts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. This allows you to specify the "context" for a Trial; a context
   * is a slice (a subspace) of the search space.
   *
   * Typical uses for contexts:
   * 1) You are using Vizier to tune a server for best performance, but there's
   *   a strong weekly cycle.  The context specifies the day-of-week.
   *   This allows Tuesday to generalize from Wednesday without assuming that
   *   everything is identical.
   * 2) Imagine you're optimizing some medical treatment for people.
   *   As they walk in the door, you know certain facts about them
   *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
   *   context, and Vizier will adapt its suggestions to the patient.
   * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
   *   conditions as contexts, and Vizier will generalize between "A" and "B"
   *   conditions.  If they are similar, this will allow Vizier to converge
   *   to the optimum faster than if "A" and "B" were separate Studies.
   *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
   *   CreateTrial() RPC; that's the asynchronous option where you don't need a
   *   close association between contexts and suggestions.
   *
   * NOTE: All the Parameters you set in a context MUST be defined in the
   *   Study.
   * NOTE: You must supply 0 or $suggestion_count contexts.
   *   If you don't supply any contexts, Vizier will make suggestions
   *   from the full search space specified in the StudySpec; if you supply
   *   a full set of context, each suggestion will match the corresponding
   *   context.
   * NOTE: A Context with no features set matches anything, and allows
   *   suggestions from the full search space.
   * NOTE: Contexts MUST lie within the search space specified in the
   *   StudySpec.  It's an error if they don't.
   * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
   *   new suggestions are generated.
   * NOTE: Generation of suggestions involves a match between a Context and
   *   (optionally) a REQUESTED trial; if that match is not fully specified, a
   *   suggestion will be geneated in the merged subspace.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.TrialContextOrBuilder getContextsOrBuilder(int index) {
    return contexts_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (suggestionCount_ != 0) {
      output.writeInt32(2, suggestionCount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, clientId_);
    }
    for (int i = 0; i < contexts_.size(); i++) {
      output.writeMessage(4, contexts_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (suggestionCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, suggestionCount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, clientId_);
    }
    for (int i = 0; i < contexts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, contexts_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.SuggestTrialsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.SuggestTrialsRequest other =
        (com.google.cloud.aiplatform.v1.SuggestTrialsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (getSuggestionCount() != other.getSuggestionCount()) return false;
    if (!getClientId().equals(other.getClientId())) return false;
    if (!getContextsList().equals(other.getContextsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + SUGGESTION_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getSuggestionCount();
    hash = (37 * hash) + CLIENT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getClientId().hashCode();
    if (getContextsCount() > 0) {
      hash = (37 * hash) + CONTEXTS_FIELD_NUMBER;
      hash = (53 * hash) + getContextsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.SuggestTrialsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [VizierService.SuggestTrials][google.cloud.aiplatform.v1.VizierService.SuggestTrials].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.SuggestTrialsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.SuggestTrialsRequest)
      com.google.cloud.aiplatform.v1.SuggestTrialsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.VizierServiceProto
          .internal_static_google_cloud_aiplatform_v1_SuggestTrialsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.VizierServiceProto
          .internal_static_google_cloud_aiplatform_v1_SuggestTrialsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.SuggestTrialsRequest.class,
              com.google.cloud.aiplatform.v1.SuggestTrialsRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.SuggestTrialsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      suggestionCount_ = 0;
      clientId_ = "";
      if (contextsBuilder_ == null) {
        contexts_ = java.util.Collections.emptyList();
      } else {
        contexts_ = null;
        contextsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.VizierServiceProto
          .internal_static_google_cloud_aiplatform_v1_SuggestTrialsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SuggestTrialsRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.SuggestTrialsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SuggestTrialsRequest build() {
      com.google.cloud.aiplatform.v1.SuggestTrialsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SuggestTrialsRequest buildPartial() {
      com.google.cloud.aiplatform.v1.SuggestTrialsRequest result =
          new com.google.cloud.aiplatform.v1.SuggestTrialsRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1.SuggestTrialsRequest result) {
      if (contextsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          contexts_ = java.util.Collections.unmodifiableList(contexts_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.contexts_ = contexts_;
      } else {
        result.contexts_ = contextsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.SuggestTrialsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.suggestionCount_ = suggestionCount_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.clientId_ = clientId_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.SuggestTrialsRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1.SuggestTrialsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.SuggestTrialsRequest other) {
      if (other == com.google.cloud.aiplatform.v1.SuggestTrialsRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getSuggestionCount() != 0) {
        setSuggestionCount(other.getSuggestionCount());
      }
      if (!other.getClientId().isEmpty()) {
        clientId_ = other.clientId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (contextsBuilder_ == null) {
        if (!other.contexts_.isEmpty()) {
          if (contexts_.isEmpty()) {
            contexts_ = other.contexts_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureContextsIsMutable();
            contexts_.addAll(other.contexts_);
          }
          onChanged();
        }
      } else {
        if (!other.contexts_.isEmpty()) {
          if (contextsBuilder_.isEmpty()) {
            contextsBuilder_.dispose();
            contextsBuilder_ = null;
            contexts_ = other.contexts_;
            bitField0_ = (bitField0_ & ~0x00000008);
            contextsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getContextsFieldBuilder()
                    : null;
          } else {
            contextsBuilder_.addAllMessages(other.contexts_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                suggestionCount_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                clientId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.aiplatform.v1.TrialContext m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.TrialContext.parser(), extensionRegistry);
                if (contextsBuilder_ == null) {
                  ensureContextsIsMutable();
                  contexts_.add(m);
                } else {
                  contextsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The project and location that the Study belongs to.
     * Format: `projects/{project}/locations/{location}/studies/{study}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The project and location that the Study belongs to.
     * Format: `projects/{project}/locations/{location}/studies/{study}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The project and location that the Study belongs to.
     * Format: `projects/{project}/locations/{location}/studies/{study}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The project and location that the Study belongs to.
     * Format: `projects/{project}/locations/{location}/studies/{study}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The project and location that the Study belongs to.
     * Format: `projects/{project}/locations/{location}/studies/{study}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int suggestionCount_;
    /**
     *
     *
     * <pre>
     * Required. The number of suggestions requested. It must be positive.
     * </pre>
     *
     * <code>int32 suggestion_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The suggestionCount.
     */
    @java.lang.Override
    public int getSuggestionCount() {
      return suggestionCount_;
    }
    /**
     *
     *
     * <pre>
     * Required. The number of suggestions requested. It must be positive.
     * </pre>
     *
     * <code>int32 suggestion_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The suggestionCount to set.
     * @return This builder for chaining.
     */
    public Builder setSuggestionCount(int value) {

      suggestionCount_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The number of suggestions requested. It must be positive.
     * </pre>
     *
     * <code>int32 suggestion_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSuggestionCount() {
      bitField0_ = (bitField0_ & ~0x00000002);
      suggestionCount_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object clientId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The identifier of the client that is requesting the suggestion.
     *
     * If multiple SuggestTrialsRequests have the same `client_id`,
     * the service will return the identical suggested Trial if the Trial is
     * pending, and provide a new Trial if the last suggested Trial was completed.
     * </pre>
     *
     * <code>string client_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The clientId.
     */
    public java.lang.String getClientId() {
      java.lang.Object ref = clientId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clientId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The identifier of the client that is requesting the suggestion.
     *
     * If multiple SuggestTrialsRequests have the same `client_id`,
     * the service will return the identical suggested Trial if the Trial is
     * pending, and provide a new Trial if the last suggested Trial was completed.
     * </pre>
     *
     * <code>string client_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for clientId.
     */
    public com.google.protobuf.ByteString getClientIdBytes() {
      java.lang.Object ref = clientId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clientId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The identifier of the client that is requesting the suggestion.
     *
     * If multiple SuggestTrialsRequests have the same `client_id`,
     * the service will return the identical suggested Trial if the Trial is
     * pending, and provide a new Trial if the last suggested Trial was completed.
     * </pre>
     *
     * <code>string client_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The clientId to set.
     * @return This builder for chaining.
     */
    public Builder setClientId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clientId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The identifier of the client that is requesting the suggestion.
     *
     * If multiple SuggestTrialsRequests have the same `client_id`,
     * the service will return the identical suggested Trial if the Trial is
     * pending, and provide a new Trial if the last suggested Trial was completed.
     * </pre>
     *
     * <code>string client_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClientId() {
      clientId_ = getDefaultInstance().getClientId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The identifier of the client that is requesting the suggestion.
     *
     * If multiple SuggestTrialsRequests have the same `client_id`,
     * the service will return the identical suggested Trial if the Trial is
     * pending, and provide a new Trial if the last suggested Trial was completed.
     * </pre>
     *
     * <code>string client_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for clientId to set.
     * @return This builder for chaining.
     */
    public Builder setClientIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clientId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.TrialContext> contexts_ =
        java.util.Collections.emptyList();

    private void ensureContextsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        contexts_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1.TrialContext>(contexts_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.TrialContext,
            com.google.cloud.aiplatform.v1.TrialContext.Builder,
            com.google.cloud.aiplatform.v1.TrialContextOrBuilder>
        contextsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. This allows you to specify the "context" for a Trial; a context
     * is a slice (a subspace) of the search space.
     *
     * Typical uses for contexts:
     * 1) You are using Vizier to tune a server for best performance, but there's
     *   a strong weekly cycle.  The context specifies the day-of-week.
     *   This allows Tuesday to generalize from Wednesday without assuming that
     *   everything is identical.
     * 2) Imagine you're optimizing some medical treatment for people.
     *   As they walk in the door, you know certain facts about them
     *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
     *   context, and Vizier will adapt its suggestions to the patient.
     * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
     *   conditions as contexts, and Vizier will generalize between "A" and "B"
     *   conditions.  If they are similar, this will allow Vizier to converge
     *   to the optimum faster than if "A" and "B" were separate Studies.
     *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
     *   CreateTrial() RPC; that's the asynchronous option where you don't need a
     *   close association between contexts and suggestions.
     *
     * NOTE: All the Parameters you set in a context MUST be defined in the
     *   Study.
     * NOTE: You must supply 0 or $suggestion_count contexts.
     *   If you don't supply any contexts, Vizier will make suggestions
     *   from the full search space specified in the StudySpec; if you supply
     *   a full set of context, each suggestion will match the corresponding
     *   context.
     * NOTE: A Context with no features set matches anything, and allows
     *   suggestions from the full search space.
     * NOTE: Contexts MUST lie within the search space specified in the
     *   StudySpec.  It's an error if they don't.
     * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
     *   new suggestions are generated.
     * NOTE: Generation of suggestions involves a match between a Context and
     *   (optionally) a REQUESTED trial; if that match is not fully specified, a
     *   suggestion will be geneated in the merged subspace.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.TrialContext> getContextsList() {
      if (contextsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(contexts_);
      } else {
        return contextsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This allows you to specify the "context" for a Trial; a context
     * is a slice (a subspace) of the search space.
     *
     * Typical uses for contexts:
     * 1) You are using Vizier to tune a server for best performance, but there's
     *   a strong weekly cycle.  The context specifies the day-of-week.
     *   This allows Tuesday to generalize from Wednesday without assuming that
     *   everything is identical.
     * 2) Imagine you're optimizing some medical treatment for people.
     *   As they walk in the door, you know certain facts about them
     *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
     *   context, and Vizier will adapt its suggestions to the patient.
     * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
     *   conditions as contexts, and Vizier will generalize between "A" and "B"
     *   conditions.  If they are similar, this will allow Vizier to converge
     *   to the optimum faster than if "A" and "B" were separate Studies.
     *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
     *   CreateTrial() RPC; that's the asynchronous option where you don't need a
     *   close association between contexts and suggestions.
     *
     * NOTE: All the Parameters you set in a context MUST be defined in the
     *   Study.
     * NOTE: You must supply 0 or $suggestion_count contexts.
     *   If you don't supply any contexts, Vizier will make suggestions
     *   from the full search space specified in the StudySpec; if you supply
     *   a full set of context, each suggestion will match the corresponding
     *   context.
     * NOTE: A Context with no features set matches anything, and allows
     *   suggestions from the full search space.
     * NOTE: Contexts MUST lie within the search space specified in the
     *   StudySpec.  It's an error if they don't.
     * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
     *   new suggestions are generated.
     * NOTE: Generation of suggestions involves a match between a Context and
     *   (optionally) a REQUESTED trial; if that match is not fully specified, a
     *   suggestion will be geneated in the merged subspace.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getContextsCount() {
      if (contextsBuilder_ == null) {
        return contexts_.size();
      } else {
        return contextsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This allows you to specify the "context" for a Trial; a context
     * is a slice (a subspace) of the search space.
     *
     * Typical uses for contexts:
     * 1) You are using Vizier to tune a server for best performance, but there's
     *   a strong weekly cycle.  The context specifies the day-of-week.
     *   This allows Tuesday to generalize from Wednesday without assuming that
     *   everything is identical.
     * 2) Imagine you're optimizing some medical treatment for people.
     *   As they walk in the door, you know certain facts about them
     *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
     *   context, and Vizier will adapt its suggestions to the patient.
     * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
     *   conditions as contexts, and Vizier will generalize between "A" and "B"
     *   conditions.  If they are similar, this will allow Vizier to converge
     *   to the optimum faster than if "A" and "B" were separate Studies.
     *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
     *   CreateTrial() RPC; that's the asynchronous option where you don't need a
     *   close association between contexts and suggestions.
     *
     * NOTE: All the Parameters you set in a context MUST be defined in the
     *   Study.
     * NOTE: You must supply 0 or $suggestion_count contexts.
     *   If you don't supply any contexts, Vizier will make suggestions
     *   from the full search space specified in the StudySpec; if you supply
     *   a full set of context, each suggestion will match the corresponding
     *   context.
     * NOTE: A Context with no features set matches anything, and allows
     *   suggestions from the full search space.
     * NOTE: Contexts MUST lie within the search space specified in the
     *   StudySpec.  It's an error if they don't.
     * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
     *   new suggestions are generated.
     * NOTE: Generation of suggestions involves a match between a Context and
     *   (optionally) a REQUESTED trial; if that match is not fully specified, a
     *   suggestion will be geneated in the merged subspace.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.TrialContext getContexts(int index) {
      if (contextsBuilder_ == null) {
        return contexts_.get(index);
      } else {
        return contextsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This allows you to specify the "context" for a Trial; a context
     * is a slice (a subspace) of the search space.
     *
     * Typical uses for contexts:
     * 1) You are using Vizier to tune a server for best performance, but there's
     *   a strong weekly cycle.  The context specifies the day-of-week.
     *   This allows Tuesday to generalize from Wednesday without assuming that
     *   everything is identical.
     * 2) Imagine you're optimizing some medical treatment for people.
     *   As they walk in the door, you know certain facts about them
     *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
     *   context, and Vizier will adapt its suggestions to the patient.
     * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
     *   conditions as contexts, and Vizier will generalize between "A" and "B"
     *   conditions.  If they are similar, this will allow Vizier to converge
     *   to the optimum faster than if "A" and "B" were separate Studies.
     *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
     *   CreateTrial() RPC; that's the asynchronous option where you don't need a
     *   close association between contexts and suggestions.
     *
     * NOTE: All the Parameters you set in a context MUST be defined in the
     *   Study.
     * NOTE: You must supply 0 or $suggestion_count contexts.
     *   If you don't supply any contexts, Vizier will make suggestions
     *   from the full search space specified in the StudySpec; if you supply
     *   a full set of context, each suggestion will match the corresponding
     *   context.
     * NOTE: A Context with no features set matches anything, and allows
     *   suggestions from the full search space.
     * NOTE: Contexts MUST lie within the search space specified in the
     *   StudySpec.  It's an error if they don't.
     * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
     *   new suggestions are generated.
     * NOTE: Generation of suggestions involves a match between a Context and
     *   (optionally) a REQUESTED trial; if that match is not fully specified, a
     *   suggestion will be geneated in the merged subspace.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setContexts(int index, com.google.cloud.aiplatform.v1.TrialContext value) {
      if (contextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContextsIsMutable();
        contexts_.set(index, value);
        onChanged();
      } else {
        contextsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This allows you to specify the "context" for a Trial; a context
     * is a slice (a subspace) of the search space.
     *
     * Typical uses for contexts:
     * 1) You are using Vizier to tune a server for best performance, but there's
     *   a strong weekly cycle.  The context specifies the day-of-week.
     *   This allows Tuesday to generalize from Wednesday without assuming that
     *   everything is identical.
     * 2) Imagine you're optimizing some medical treatment for people.
     *   As they walk in the door, you know certain facts about them
     *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
     *   context, and Vizier will adapt its suggestions to the patient.
     * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
     *   conditions as contexts, and Vizier will generalize between "A" and "B"
     *   conditions.  If they are similar, this will allow Vizier to converge
     *   to the optimum faster than if "A" and "B" were separate Studies.
     *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
     *   CreateTrial() RPC; that's the asynchronous option where you don't need a
     *   close association between contexts and suggestions.
     *
     * NOTE: All the Parameters you set in a context MUST be defined in the
     *   Study.
     * NOTE: You must supply 0 or $suggestion_count contexts.
     *   If you don't supply any contexts, Vizier will make suggestions
     *   from the full search space specified in the StudySpec; if you supply
     *   a full set of context, each suggestion will match the corresponding
     *   context.
     * NOTE: A Context with no features set matches anything, and allows
     *   suggestions from the full search space.
     * NOTE: Contexts MUST lie within the search space specified in the
     *   StudySpec.  It's an error if they don't.
     * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
     *   new suggestions are generated.
     * NOTE: Generation of suggestions involves a match between a Context and
     *   (optionally) a REQUESTED trial; if that match is not fully specified, a
     *   suggestion will be geneated in the merged subspace.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setContexts(
        int index, com.google.cloud.aiplatform.v1.TrialContext.Builder builderForValue) {
      if (contextsBuilder_ == null) {
        ensureContextsIsMutable();
        contexts_.set(index, builderForValue.build());
        onChanged();
      } else {
        contextsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This allows you to specify the "context" for a Trial; a context
     * is a slice (a subspace) of the search space.
     *
     * Typical uses for contexts:
     * 1) You are using Vizier to tune a server for best performance, but there's
     *   a strong weekly cycle.  The context specifies the day-of-week.
     *   This allows Tuesday to generalize from Wednesday without assuming that
     *   everything is identical.
     * 2) Imagine you're optimizing some medical treatment for people.
     *   As they walk in the door, you know certain facts about them
     *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
     *   context, and Vizier will adapt its suggestions to the patient.
     * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
     *   conditions as contexts, and Vizier will generalize between "A" and "B"
     *   conditions.  If they are similar, this will allow Vizier to converge
     *   to the optimum faster than if "A" and "B" were separate Studies.
     *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
     *   CreateTrial() RPC; that's the asynchronous option where you don't need a
     *   close association between contexts and suggestions.
     *
     * NOTE: All the Parameters you set in a context MUST be defined in the
     *   Study.
     * NOTE: You must supply 0 or $suggestion_count contexts.
     *   If you don't supply any contexts, Vizier will make suggestions
     *   from the full search space specified in the StudySpec; if you supply
     *   a full set of context, each suggestion will match the corresponding
     *   context.
     * NOTE: A Context with no features set matches anything, and allows
     *   suggestions from the full search space.
     * NOTE: Contexts MUST lie within the search space specified in the
     *   StudySpec.  It's an error if they don't.
     * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
     *   new suggestions are generated.
     * NOTE: Generation of suggestions involves a match between a Context and
     *   (optionally) a REQUESTED trial; if that match is not fully specified, a
     *   suggestion will be geneated in the merged subspace.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addContexts(com.google.cloud.aiplatform.v1.TrialContext value) {
      if (contextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContextsIsMutable();
        contexts_.add(value);
        onChanged();
      } else {
        contextsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This allows you to specify the "context" for a Trial; a context
     * is a slice (a subspace) of the search space.
     *
     * Typical uses for contexts:
     * 1) You are using Vizier to tune a server for best performance, but there's
     *   a strong weekly cycle.  The context specifies the day-of-week.
     *   This allows Tuesday to generalize from Wednesday without assuming that
     *   everything is identical.
     * 2) Imagine you're optimizing some medical treatment for people.
     *   As they walk in the door, you know certain facts about them
     *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
     *   context, and Vizier will adapt its suggestions to the patient.
     * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
     *   conditions as contexts, and Vizier will generalize between "A" and "B"
     *   conditions.  If they are similar, this will allow Vizier to converge
     *   to the optimum faster than if "A" and "B" were separate Studies.
     *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
     *   CreateTrial() RPC; that's the asynchronous option where you don't need a
     *   close association between contexts and suggestions.
     *
     * NOTE: All the Parameters you set in a context MUST be defined in the
     *   Study.
     * NOTE: You must supply 0 or $suggestion_count contexts.
     *   If you don't supply any contexts, Vizier will make suggestions
     *   from the full search space specified in the StudySpec; if you supply
     *   a full set of context, each suggestion will match the corresponding
     *   context.
     * NOTE: A Context with no features set matches anything, and allows
     *   suggestions from the full search space.
     * NOTE: Contexts MUST lie within the search space specified in the
     *   StudySpec.  It's an error if they don't.
     * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
     *   new suggestions are generated.
     * NOTE: Generation of suggestions involves a match between a Context and
     *   (optionally) a REQUESTED trial; if that match is not fully specified, a
     *   suggestion will be geneated in the merged subspace.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addContexts(int index, com.google.cloud.aiplatform.v1.TrialContext value) {
      if (contextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContextsIsMutable();
        contexts_.add(index, value);
        onChanged();
      } else {
        contextsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This allows you to specify the "context" for a Trial; a context
     * is a slice (a subspace) of the search space.
     *
     * Typical uses for contexts:
     * 1) You are using Vizier to tune a server for best performance, but there's
     *   a strong weekly cycle.  The context specifies the day-of-week.
     *   This allows Tuesday to generalize from Wednesday without assuming that
     *   everything is identical.
     * 2) Imagine you're optimizing some medical treatment for people.
     *   As they walk in the door, you know certain facts about them
     *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
     *   context, and Vizier will adapt its suggestions to the patient.
     * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
     *   conditions as contexts, and Vizier will generalize between "A" and "B"
     *   conditions.  If they are similar, this will allow Vizier to converge
     *   to the optimum faster than if "A" and "B" were separate Studies.
     *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
     *   CreateTrial() RPC; that's the asynchronous option where you don't need a
     *   close association between contexts and suggestions.
     *
     * NOTE: All the Parameters you set in a context MUST be defined in the
     *   Study.
     * NOTE: You must supply 0 or $suggestion_count contexts.
     *   If you don't supply any contexts, Vizier will make suggestions
     *   from the full search space specified in the StudySpec; if you supply
     *   a full set of context, each suggestion will match the corresponding
     *   context.
     * NOTE: A Context with no features set matches anything, and allows
     *   suggestions from the full search space.
     * NOTE: Contexts MUST lie within the search space specified in the
     *   StudySpec.  It's an error if they don't.
     * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
     *   new suggestions are generated.
     * NOTE: Generation of suggestions involves a match between a Context and
     *   (optionally) a REQUESTED trial; if that match is not fully specified, a
     *   suggestion will be geneated in the merged subspace.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addContexts(
        com.google.cloud.aiplatform.v1.TrialContext.Builder builderForValue) {
      if (contextsBuilder_ == null) {
        ensureContextsIsMutable();
        contexts_.add(builderForValue.build());
        onChanged();
      } else {
        contextsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This allows you to specify the "context" for a Trial; a context
     * is a slice (a subspace) of the search space.
     *
     * Typical uses for contexts:
     * 1) You are using Vizier to tune a server for best performance, but there's
     *   a strong weekly cycle.  The context specifies the day-of-week.
     *   This allows Tuesday to generalize from Wednesday without assuming that
     *   everything is identical.
     * 2) Imagine you're optimizing some medical treatment for people.
     *   As they walk in the door, you know certain facts about them
     *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
     *   context, and Vizier will adapt its suggestions to the patient.
     * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
     *   conditions as contexts, and Vizier will generalize between "A" and "B"
     *   conditions.  If they are similar, this will allow Vizier to converge
     *   to the optimum faster than if "A" and "B" were separate Studies.
     *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
     *   CreateTrial() RPC; that's the asynchronous option where you don't need a
     *   close association between contexts and suggestions.
     *
     * NOTE: All the Parameters you set in a context MUST be defined in the
     *   Study.
     * NOTE: You must supply 0 or $suggestion_count contexts.
     *   If you don't supply any contexts, Vizier will make suggestions
     *   from the full search space specified in the StudySpec; if you supply
     *   a full set of context, each suggestion will match the corresponding
     *   context.
     * NOTE: A Context with no features set matches anything, and allows
     *   suggestions from the full search space.
     * NOTE: Contexts MUST lie within the search space specified in the
     *   StudySpec.  It's an error if they don't.
     * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
     *   new suggestions are generated.
     * NOTE: Generation of suggestions involves a match between a Context and
     *   (optionally) a REQUESTED trial; if that match is not fully specified, a
     *   suggestion will be geneated in the merged subspace.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addContexts(
        int index, com.google.cloud.aiplatform.v1.TrialContext.Builder builderForValue) {
      if (contextsBuilder_ == null) {
        ensureContextsIsMutable();
        contexts_.add(index, builderForValue.build());
        onChanged();
      } else {
        contextsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This allows you to specify the "context" for a Trial; a context
     * is a slice (a subspace) of the search space.
     *
     * Typical uses for contexts:
     * 1) You are using Vizier to tune a server for best performance, but there's
     *   a strong weekly cycle.  The context specifies the day-of-week.
     *   This allows Tuesday to generalize from Wednesday without assuming that
     *   everything is identical.
     * 2) Imagine you're optimizing some medical treatment for people.
     *   As they walk in the door, you know certain facts about them
     *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
     *   context, and Vizier will adapt its suggestions to the patient.
     * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
     *   conditions as contexts, and Vizier will generalize between "A" and "B"
     *   conditions.  If they are similar, this will allow Vizier to converge
     *   to the optimum faster than if "A" and "B" were separate Studies.
     *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
     *   CreateTrial() RPC; that's the asynchronous option where you don't need a
     *   close association between contexts and suggestions.
     *
     * NOTE: All the Parameters you set in a context MUST be defined in the
     *   Study.
     * NOTE: You must supply 0 or $suggestion_count contexts.
     *   If you don't supply any contexts, Vizier will make suggestions
     *   from the full search space specified in the StudySpec; if you supply
     *   a full set of context, each suggestion will match the corresponding
     *   context.
     * NOTE: A Context with no features set matches anything, and allows
     *   suggestions from the full search space.
     * NOTE: Contexts MUST lie within the search space specified in the
     *   StudySpec.  It's an error if they don't.
     * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
     *   new suggestions are generated.
     * NOTE: Generation of suggestions involves a match between a Context and
     *   (optionally) a REQUESTED trial; if that match is not fully specified, a
     *   suggestion will be geneated in the merged subspace.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllContexts(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.TrialContext> values) {
      if (contextsBuilder_ == null) {
        ensureContextsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, contexts_);
        onChanged();
      } else {
        contextsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This allows you to specify the "context" for a Trial; a context
     * is a slice (a subspace) of the search space.
     *
     * Typical uses for contexts:
     * 1) You are using Vizier to tune a server for best performance, but there's
     *   a strong weekly cycle.  The context specifies the day-of-week.
     *   This allows Tuesday to generalize from Wednesday without assuming that
     *   everything is identical.
     * 2) Imagine you're optimizing some medical treatment for people.
     *   As they walk in the door, you know certain facts about them
     *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
     *   context, and Vizier will adapt its suggestions to the patient.
     * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
     *   conditions as contexts, and Vizier will generalize between "A" and "B"
     *   conditions.  If they are similar, this will allow Vizier to converge
     *   to the optimum faster than if "A" and "B" were separate Studies.
     *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
     *   CreateTrial() RPC; that's the asynchronous option where you don't need a
     *   close association between contexts and suggestions.
     *
     * NOTE: All the Parameters you set in a context MUST be defined in the
     *   Study.
     * NOTE: You must supply 0 or $suggestion_count contexts.
     *   If you don't supply any contexts, Vizier will make suggestions
     *   from the full search space specified in the StudySpec; if you supply
     *   a full set of context, each suggestion will match the corresponding
     *   context.
     * NOTE: A Context with no features set matches anything, and allows
     *   suggestions from the full search space.
     * NOTE: Contexts MUST lie within the search space specified in the
     *   StudySpec.  It's an error if they don't.
     * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
     *   new suggestions are generated.
     * NOTE: Generation of suggestions involves a match between a Context and
     *   (optionally) a REQUESTED trial; if that match is not fully specified, a
     *   suggestion will be geneated in the merged subspace.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearContexts() {
      if (contextsBuilder_ == null) {
        contexts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        contextsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This allows you to specify the "context" for a Trial; a context
     * is a slice (a subspace) of the search space.
     *
     * Typical uses for contexts:
     * 1) You are using Vizier to tune a server for best performance, but there's
     *   a strong weekly cycle.  The context specifies the day-of-week.
     *   This allows Tuesday to generalize from Wednesday without assuming that
     *   everything is identical.
     * 2) Imagine you're optimizing some medical treatment for people.
     *   As they walk in the door, you know certain facts about them
     *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
     *   context, and Vizier will adapt its suggestions to the patient.
     * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
     *   conditions as contexts, and Vizier will generalize between "A" and "B"
     *   conditions.  If they are similar, this will allow Vizier to converge
     *   to the optimum faster than if "A" and "B" were separate Studies.
     *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
     *   CreateTrial() RPC; that's the asynchronous option where you don't need a
     *   close association between contexts and suggestions.
     *
     * NOTE: All the Parameters you set in a context MUST be defined in the
     *   Study.
     * NOTE: You must supply 0 or $suggestion_count contexts.
     *   If you don't supply any contexts, Vizier will make suggestions
     *   from the full search space specified in the StudySpec; if you supply
     *   a full set of context, each suggestion will match the corresponding
     *   context.
     * NOTE: A Context with no features set matches anything, and allows
     *   suggestions from the full search space.
     * NOTE: Contexts MUST lie within the search space specified in the
     *   StudySpec.  It's an error if they don't.
     * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
     *   new suggestions are generated.
     * NOTE: Generation of suggestions involves a match between a Context and
     *   (optionally) a REQUESTED trial; if that match is not fully specified, a
     *   suggestion will be geneated in the merged subspace.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeContexts(int index) {
      if (contextsBuilder_ == null) {
        ensureContextsIsMutable();
        contexts_.remove(index);
        onChanged();
      } else {
        contextsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This allows you to specify the "context" for a Trial; a context
     * is a slice (a subspace) of the search space.
     *
     * Typical uses for contexts:
     * 1) You are using Vizier to tune a server for best performance, but there's
     *   a strong weekly cycle.  The context specifies the day-of-week.
     *   This allows Tuesday to generalize from Wednesday without assuming that
     *   everything is identical.
     * 2) Imagine you're optimizing some medical treatment for people.
     *   As they walk in the door, you know certain facts about them
     *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
     *   context, and Vizier will adapt its suggestions to the patient.
     * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
     *   conditions as contexts, and Vizier will generalize between "A" and "B"
     *   conditions.  If they are similar, this will allow Vizier to converge
     *   to the optimum faster than if "A" and "B" were separate Studies.
     *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
     *   CreateTrial() RPC; that's the asynchronous option where you don't need a
     *   close association between contexts and suggestions.
     *
     * NOTE: All the Parameters you set in a context MUST be defined in the
     *   Study.
     * NOTE: You must supply 0 or $suggestion_count contexts.
     *   If you don't supply any contexts, Vizier will make suggestions
     *   from the full search space specified in the StudySpec; if you supply
     *   a full set of context, each suggestion will match the corresponding
     *   context.
     * NOTE: A Context with no features set matches anything, and allows
     *   suggestions from the full search space.
     * NOTE: Contexts MUST lie within the search space specified in the
     *   StudySpec.  It's an error if they don't.
     * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
     *   new suggestions are generated.
     * NOTE: Generation of suggestions involves a match between a Context and
     *   (optionally) a REQUESTED trial; if that match is not fully specified, a
     *   suggestion will be geneated in the merged subspace.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.TrialContext.Builder getContextsBuilder(int index) {
      return getContextsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. This allows you to specify the "context" for a Trial; a context
     * is a slice (a subspace) of the search space.
     *
     * Typical uses for contexts:
     * 1) You are using Vizier to tune a server for best performance, but there's
     *   a strong weekly cycle.  The context specifies the day-of-week.
     *   This allows Tuesday to generalize from Wednesday without assuming that
     *   everything is identical.
     * 2) Imagine you're optimizing some medical treatment for people.
     *   As they walk in the door, you know certain facts about them
     *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
     *   context, and Vizier will adapt its suggestions to the patient.
     * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
     *   conditions as contexts, and Vizier will generalize between "A" and "B"
     *   conditions.  If they are similar, this will allow Vizier to converge
     *   to the optimum faster than if "A" and "B" were separate Studies.
     *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
     *   CreateTrial() RPC; that's the asynchronous option where you don't need a
     *   close association between contexts and suggestions.
     *
     * NOTE: All the Parameters you set in a context MUST be defined in the
     *   Study.
     * NOTE: You must supply 0 or $suggestion_count contexts.
     *   If you don't supply any contexts, Vizier will make suggestions
     *   from the full search space specified in the StudySpec; if you supply
     *   a full set of context, each suggestion will match the corresponding
     *   context.
     * NOTE: A Context with no features set matches anything, and allows
     *   suggestions from the full search space.
     * NOTE: Contexts MUST lie within the search space specified in the
     *   StudySpec.  It's an error if they don't.
     * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
     *   new suggestions are generated.
     * NOTE: Generation of suggestions involves a match between a Context and
     *   (optionally) a REQUESTED trial; if that match is not fully specified, a
     *   suggestion will be geneated in the merged subspace.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.TrialContextOrBuilder getContextsOrBuilder(int index) {
      if (contextsBuilder_ == null) {
        return contexts_.get(index);
      } else {
        return contextsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This allows you to specify the "context" for a Trial; a context
     * is a slice (a subspace) of the search space.
     *
     * Typical uses for contexts:
     * 1) You are using Vizier to tune a server for best performance, but there's
     *   a strong weekly cycle.  The context specifies the day-of-week.
     *   This allows Tuesday to generalize from Wednesday without assuming that
     *   everything is identical.
     * 2) Imagine you're optimizing some medical treatment for people.
     *   As they walk in the door, you know certain facts about them
     *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
     *   context, and Vizier will adapt its suggestions to the patient.
     * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
     *   conditions as contexts, and Vizier will generalize between "A" and "B"
     *   conditions.  If they are similar, this will allow Vizier to converge
     *   to the optimum faster than if "A" and "B" were separate Studies.
     *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
     *   CreateTrial() RPC; that's the asynchronous option where you don't need a
     *   close association between contexts and suggestions.
     *
     * NOTE: All the Parameters you set in a context MUST be defined in the
     *   Study.
     * NOTE: You must supply 0 or $suggestion_count contexts.
     *   If you don't supply any contexts, Vizier will make suggestions
     *   from the full search space specified in the StudySpec; if you supply
     *   a full set of context, each suggestion will match the corresponding
     *   context.
     * NOTE: A Context with no features set matches anything, and allows
     *   suggestions from the full search space.
     * NOTE: Contexts MUST lie within the search space specified in the
     *   StudySpec.  It's an error if they don't.
     * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
     *   new suggestions are generated.
     * NOTE: Generation of suggestions involves a match between a Context and
     *   (optionally) a REQUESTED trial; if that match is not fully specified, a
     *   suggestion will be geneated in the merged subspace.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.TrialContextOrBuilder>
        getContextsOrBuilderList() {
      if (contextsBuilder_ != null) {
        return contextsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(contexts_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This allows you to specify the "context" for a Trial; a context
     * is a slice (a subspace) of the search space.
     *
     * Typical uses for contexts:
     * 1) You are using Vizier to tune a server for best performance, but there's
     *   a strong weekly cycle.  The context specifies the day-of-week.
     *   This allows Tuesday to generalize from Wednesday without assuming that
     *   everything is identical.
     * 2) Imagine you're optimizing some medical treatment for people.
     *   As they walk in the door, you know certain facts about them
     *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
     *   context, and Vizier will adapt its suggestions to the patient.
     * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
     *   conditions as contexts, and Vizier will generalize between "A" and "B"
     *   conditions.  If they are similar, this will allow Vizier to converge
     *   to the optimum faster than if "A" and "B" were separate Studies.
     *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
     *   CreateTrial() RPC; that's the asynchronous option where you don't need a
     *   close association between contexts and suggestions.
     *
     * NOTE: All the Parameters you set in a context MUST be defined in the
     *   Study.
     * NOTE: You must supply 0 or $suggestion_count contexts.
     *   If you don't supply any contexts, Vizier will make suggestions
     *   from the full search space specified in the StudySpec; if you supply
     *   a full set of context, each suggestion will match the corresponding
     *   context.
     * NOTE: A Context with no features set matches anything, and allows
     *   suggestions from the full search space.
     * NOTE: Contexts MUST lie within the search space specified in the
     *   StudySpec.  It's an error if they don't.
     * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
     *   new suggestions are generated.
     * NOTE: Generation of suggestions involves a match between a Context and
     *   (optionally) a REQUESTED trial; if that match is not fully specified, a
     *   suggestion will be geneated in the merged subspace.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.TrialContext.Builder addContextsBuilder() {
      return getContextsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.TrialContext.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. This allows you to specify the "context" for a Trial; a context
     * is a slice (a subspace) of the search space.
     *
     * Typical uses for contexts:
     * 1) You are using Vizier to tune a server for best performance, but there's
     *   a strong weekly cycle.  The context specifies the day-of-week.
     *   This allows Tuesday to generalize from Wednesday without assuming that
     *   everything is identical.
     * 2) Imagine you're optimizing some medical treatment for people.
     *   As they walk in the door, you know certain facts about them
     *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
     *   context, and Vizier will adapt its suggestions to the patient.
     * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
     *   conditions as contexts, and Vizier will generalize between "A" and "B"
     *   conditions.  If they are similar, this will allow Vizier to converge
     *   to the optimum faster than if "A" and "B" were separate Studies.
     *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
     *   CreateTrial() RPC; that's the asynchronous option where you don't need a
     *   close association between contexts and suggestions.
     *
     * NOTE: All the Parameters you set in a context MUST be defined in the
     *   Study.
     * NOTE: You must supply 0 or $suggestion_count contexts.
     *   If you don't supply any contexts, Vizier will make suggestions
     *   from the full search space specified in the StudySpec; if you supply
     *   a full set of context, each suggestion will match the corresponding
     *   context.
     * NOTE: A Context with no features set matches anything, and allows
     *   suggestions from the full search space.
     * NOTE: Contexts MUST lie within the search space specified in the
     *   StudySpec.  It's an error if they don't.
     * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
     *   new suggestions are generated.
     * NOTE: Generation of suggestions involves a match between a Context and
     *   (optionally) a REQUESTED trial; if that match is not fully specified, a
     *   suggestion will be geneated in the merged subspace.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.TrialContext.Builder addContextsBuilder(int index) {
      return getContextsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1.TrialContext.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. This allows you to specify the "context" for a Trial; a context
     * is a slice (a subspace) of the search space.
     *
     * Typical uses for contexts:
     * 1) You are using Vizier to tune a server for best performance, but there's
     *   a strong weekly cycle.  The context specifies the day-of-week.
     *   This allows Tuesday to generalize from Wednesday without assuming that
     *   everything is identical.
     * 2) Imagine you're optimizing some medical treatment for people.
     *   As they walk in the door, you know certain facts about them
     *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
     *   context, and Vizier will adapt its suggestions to the patient.
     * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
     *   conditions as contexts, and Vizier will generalize between "A" and "B"
     *   conditions.  If they are similar, this will allow Vizier to converge
     *   to the optimum faster than if "A" and "B" were separate Studies.
     *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
     *   CreateTrial() RPC; that's the asynchronous option where you don't need a
     *   close association between contexts and suggestions.
     *
     * NOTE: All the Parameters you set in a context MUST be defined in the
     *   Study.
     * NOTE: You must supply 0 or $suggestion_count contexts.
     *   If you don't supply any contexts, Vizier will make suggestions
     *   from the full search space specified in the StudySpec; if you supply
     *   a full set of context, each suggestion will match the corresponding
     *   context.
     * NOTE: A Context with no features set matches anything, and allows
     *   suggestions from the full search space.
     * NOTE: Contexts MUST lie within the search space specified in the
     *   StudySpec.  It's an error if they don't.
     * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
     *   new suggestions are generated.
     * NOTE: Generation of suggestions involves a match between a Context and
     *   (optionally) a REQUESTED trial; if that match is not fully specified, a
     *   suggestion will be geneated in the merged subspace.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.TrialContext.Builder>
        getContextsBuilderList() {
      return getContextsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.TrialContext,
            com.google.cloud.aiplatform.v1.TrialContext.Builder,
            com.google.cloud.aiplatform.v1.TrialContextOrBuilder>
        getContextsFieldBuilder() {
      if (contextsBuilder_ == null) {
        contextsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.TrialContext,
                com.google.cloud.aiplatform.v1.TrialContext.Builder,
                com.google.cloud.aiplatform.v1.TrialContextOrBuilder>(
                contexts_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        contexts_ = null;
      }
      return contextsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.SuggestTrialsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.SuggestTrialsRequest)
  private static final com.google.cloud.aiplatform.v1.SuggestTrialsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.SuggestTrialsRequest();
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SuggestTrialsRequest> PARSER =
      new com.google.protobuf.AbstractParser<SuggestTrialsRequest>() {
        @java.lang.Override
        public SuggestTrialsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SuggestTrialsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SuggestTrialsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SuggestTrialsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
