/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/content.proto

package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * A datatype containing media that is part of a multi-part `Content` message.
 *
 * A `Part` consists of data which has an associated datatype. A `Part` can only
 * contain one of the accepted types in `Part.data`.
 *
 * A `Part` must have a fixed IANA MIME type identifying the type and subtype
 * of the media if `inline_data` or `file_data` field is filled with raw bytes.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.Part}
 */
public final class Part extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.Part)
    PartOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Part.newBuilder() to construct.
  private Part(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Part() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Part();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.ContentProto
        .internal_static_google_cloud_aiplatform_v1_Part_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.ContentProto
        .internal_static_google_cloud_aiplatform_v1_Part_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.Part.class,
            com.google.cloud.aiplatform.v1.Part.Builder.class);
  }

  private int dataCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object data_;

  public enum DataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TEXT(1),
    INLINE_DATA(2),
    FILE_DATA(3),
    FUNCTION_CALL(5),
    FUNCTION_RESPONSE(6),
    DATA_NOT_SET(0);
    private final int value;

    private DataCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataCase valueOf(int value) {
      return forNumber(value);
    }

    public static DataCase forNumber(int value) {
      switch (value) {
        case 1:
          return TEXT;
        case 2:
          return INLINE_DATA;
        case 3:
          return FILE_DATA;
        case 5:
          return FUNCTION_CALL;
        case 6:
          return FUNCTION_RESPONSE;
        case 0:
          return DATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DataCase getDataCase() {
    return DataCase.forNumber(dataCase_);
  }

  private int metadataCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object metadata_;

  public enum MetadataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    VIDEO_METADATA(4),
    METADATA_NOT_SET(0);
    private final int value;

    private MetadataCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MetadataCase valueOf(int value) {
      return forNumber(value);
    }

    public static MetadataCase forNumber(int value) {
      switch (value) {
        case 4:
          return VIDEO_METADATA;
        case 0:
          return METADATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public MetadataCase getMetadataCase() {
    return MetadataCase.forNumber(metadataCase_);
  }

  public static final int TEXT_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Optional. Text part (can be code).
   * </pre>
   *
   * <code>string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the text field is set.
   */
  public boolean hasText() {
    return dataCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Optional. Text part (can be code).
   * </pre>
   *
   * <code>string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The text.
   */
  public java.lang.String getText() {
    java.lang.Object ref = "";
    if (dataCase_ == 1) {
      ref = data_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (dataCase_ == 1) {
        data_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Text part (can be code).
   * </pre>
   *
   * <code>string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for text.
   */
  public com.google.protobuf.ByteString getTextBytes() {
    java.lang.Object ref = "";
    if (dataCase_ == 1) {
      ref = data_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (dataCase_ == 1) {
        data_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INLINE_DATA_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Optional. Inlined bytes data.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Blob inline_data = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the inlineData field is set.
   */
  @java.lang.Override
  public boolean hasInlineData() {
    return dataCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Optional. Inlined bytes data.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Blob inline_data = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The inlineData.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Blob getInlineData() {
    if (dataCase_ == 2) {
      return (com.google.cloud.aiplatform.v1.Blob) data_;
    }
    return com.google.cloud.aiplatform.v1.Blob.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Inlined bytes data.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Blob inline_data = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.BlobOrBuilder getInlineDataOrBuilder() {
    if (dataCase_ == 2) {
      return (com.google.cloud.aiplatform.v1.Blob) data_;
    }
    return com.google.cloud.aiplatform.v1.Blob.getDefaultInstance();
  }

  public static final int FILE_DATA_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Optional. URI based data.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FileData file_data = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the fileData field is set.
   */
  @java.lang.Override
  public boolean hasFileData() {
    return dataCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Optional. URI based data.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FileData file_data = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The fileData.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FileData getFileData() {
    if (dataCase_ == 3) {
      return (com.google.cloud.aiplatform.v1.FileData) data_;
    }
    return com.google.cloud.aiplatform.v1.FileData.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. URI based data.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FileData file_data = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FileDataOrBuilder getFileDataOrBuilder() {
    if (dataCase_ == 3) {
      return (com.google.cloud.aiplatform.v1.FileData) data_;
    }
    return com.google.cloud.aiplatform.v1.FileData.getDefaultInstance();
  }

  public static final int FUNCTION_CALL_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Optional. A predicted [FunctionCall] returned from the model that
   * contains a string representing the [FunctionDeclaration.name] with the
   * parameters and their values.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FunctionCall function_call = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the functionCall field is set.
   */
  @java.lang.Override
  public boolean hasFunctionCall() {
    return dataCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Optional. A predicted [FunctionCall] returned from the model that
   * contains a string representing the [FunctionDeclaration.name] with the
   * parameters and their values.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FunctionCall function_call = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The functionCall.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FunctionCall getFunctionCall() {
    if (dataCase_ == 5) {
      return (com.google.cloud.aiplatform.v1.FunctionCall) data_;
    }
    return com.google.cloud.aiplatform.v1.FunctionCall.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. A predicted [FunctionCall] returned from the model that
   * contains a string representing the [FunctionDeclaration.name] with the
   * parameters and their values.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FunctionCall function_call = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FunctionCallOrBuilder getFunctionCallOrBuilder() {
    if (dataCase_ == 5) {
      return (com.google.cloud.aiplatform.v1.FunctionCall) data_;
    }
    return com.google.cloud.aiplatform.v1.FunctionCall.getDefaultInstance();
  }

  public static final int FUNCTION_RESPONSE_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Optional. The result output of a [FunctionCall] that contains a string
   * representing the [FunctionDeclaration.name] and a structured JSON object
   * containing any output from the function call. It is used as context to
   * the model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FunctionResponse function_response = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the functionResponse field is set.
   */
  @java.lang.Override
  public boolean hasFunctionResponse() {
    return dataCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Optional. The result output of a [FunctionCall] that contains a string
   * representing the [FunctionDeclaration.name] and a structured JSON object
   * containing any output from the function call. It is used as context to
   * the model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FunctionResponse function_response = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The functionResponse.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FunctionResponse getFunctionResponse() {
    if (dataCase_ == 6) {
      return (com.google.cloud.aiplatform.v1.FunctionResponse) data_;
    }
    return com.google.cloud.aiplatform.v1.FunctionResponse.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. The result output of a [FunctionCall] that contains a string
   * representing the [FunctionDeclaration.name] and a structured JSON object
   * containing any output from the function call. It is used as context to
   * the model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FunctionResponse function_response = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FunctionResponseOrBuilder getFunctionResponseOrBuilder() {
    if (dataCase_ == 6) {
      return (com.google.cloud.aiplatform.v1.FunctionResponse) data_;
    }
    return com.google.cloud.aiplatform.v1.FunctionResponse.getDefaultInstance();
  }

  public static final int VIDEO_METADATA_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Optional. Video metadata. The metadata should only be specified while the
   * video data is presented in inline_data or file_data.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.VideoMetadata video_metadata = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the videoMetadata field is set.
   */
  @java.lang.Override
  public boolean hasVideoMetadata() {
    return metadataCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Optional. Video metadata. The metadata should only be specified while the
   * video data is presented in inline_data or file_data.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.VideoMetadata video_metadata = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The videoMetadata.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.VideoMetadata getVideoMetadata() {
    if (metadataCase_ == 4) {
      return (com.google.cloud.aiplatform.v1.VideoMetadata) metadata_;
    }
    return com.google.cloud.aiplatform.v1.VideoMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Video metadata. The metadata should only be specified while the
   * video data is presented in inline_data or file_data.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.VideoMetadata video_metadata = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.VideoMetadataOrBuilder getVideoMetadataOrBuilder() {
    if (metadataCase_ == 4) {
      return (com.google.cloud.aiplatform.v1.VideoMetadata) metadata_;
    }
    return com.google.cloud.aiplatform.v1.VideoMetadata.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (dataCase_ == 1) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, data_);
    }
    if (dataCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.aiplatform.v1.Blob) data_);
    }
    if (dataCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.aiplatform.v1.FileData) data_);
    }
    if (metadataCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.aiplatform.v1.VideoMetadata) metadata_);
    }
    if (dataCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.aiplatform.v1.FunctionCall) data_);
    }
    if (dataCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.aiplatform.v1.FunctionResponse) data_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (dataCase_ == 1) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, data_);
    }
    if (dataCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.aiplatform.v1.Blob) data_);
    }
    if (dataCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.aiplatform.v1.FileData) data_);
    }
    if (metadataCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.aiplatform.v1.VideoMetadata) metadata_);
    }
    if (dataCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.aiplatform.v1.FunctionCall) data_);
    }
    if (dataCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.aiplatform.v1.FunctionResponse) data_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.Part)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.Part other = (com.google.cloud.aiplatform.v1.Part) obj;

    if (!getDataCase().equals(other.getDataCase())) return false;
    switch (dataCase_) {
      case 1:
        if (!getText().equals(other.getText())) return false;
        break;
      case 2:
        if (!getInlineData().equals(other.getInlineData())) return false;
        break;
      case 3:
        if (!getFileData().equals(other.getFileData())) return false;
        break;
      case 5:
        if (!getFunctionCall().equals(other.getFunctionCall())) return false;
        break;
      case 6:
        if (!getFunctionResponse().equals(other.getFunctionResponse())) return false;
        break;
      case 0:
      default:
    }
    if (!getMetadataCase().equals(other.getMetadataCase())) return false;
    switch (metadataCase_) {
      case 4:
        if (!getVideoMetadata().equals(other.getVideoMetadata())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (dataCase_) {
      case 1:
        hash = (37 * hash) + TEXT_FIELD_NUMBER;
        hash = (53 * hash) + getText().hashCode();
        break;
      case 2:
        hash = (37 * hash) + INLINE_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getInlineData().hashCode();
        break;
      case 3:
        hash = (37 * hash) + FILE_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getFileData().hashCode();
        break;
      case 5:
        hash = (37 * hash) + FUNCTION_CALL_FIELD_NUMBER;
        hash = (53 * hash) + getFunctionCall().hashCode();
        break;
      case 6:
        hash = (37 * hash) + FUNCTION_RESPONSE_FIELD_NUMBER;
        hash = (53 * hash) + getFunctionResponse().hashCode();
        break;
      case 0:
      default:
    }
    switch (metadataCase_) {
      case 4:
        hash = (37 * hash) + VIDEO_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getVideoMetadata().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.Part parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Part parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Part parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Part parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Part parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Part parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Part parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Part parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Part parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Part parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Part parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Part parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.Part prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A datatype containing media that is part of a multi-part `Content` message.
   *
   * A `Part` consists of data which has an associated datatype. A `Part` can only
   * contain one of the accepted types in `Part.data`.
   *
   * A `Part` must have a fixed IANA MIME type identifying the type and subtype
   * of the media if `inline_data` or `file_data` field is filled with raw bytes.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.Part}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.Part)
      com.google.cloud.aiplatform.v1.PartOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ContentProto
          .internal_static_google_cloud_aiplatform_v1_Part_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ContentProto
          .internal_static_google_cloud_aiplatform_v1_Part_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.Part.class,
              com.google.cloud.aiplatform.v1.Part.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.Part.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (inlineDataBuilder_ != null) {
        inlineDataBuilder_.clear();
      }
      if (fileDataBuilder_ != null) {
        fileDataBuilder_.clear();
      }
      if (functionCallBuilder_ != null) {
        functionCallBuilder_.clear();
      }
      if (functionResponseBuilder_ != null) {
        functionResponseBuilder_.clear();
      }
      if (videoMetadataBuilder_ != null) {
        videoMetadataBuilder_.clear();
      }
      dataCase_ = 0;
      data_ = null;
      metadataCase_ = 0;
      metadata_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.ContentProto
          .internal_static_google_cloud_aiplatform_v1_Part_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Part getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.Part.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Part build() {
      com.google.cloud.aiplatform.v1.Part result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Part buildPartial() {
      com.google.cloud.aiplatform.v1.Part result = new com.google.cloud.aiplatform.v1.Part(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.Part result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1.Part result) {
      result.dataCase_ = dataCase_;
      result.data_ = this.data_;
      if (dataCase_ == 2 && inlineDataBuilder_ != null) {
        result.data_ = inlineDataBuilder_.build();
      }
      if (dataCase_ == 3 && fileDataBuilder_ != null) {
        result.data_ = fileDataBuilder_.build();
      }
      if (dataCase_ == 5 && functionCallBuilder_ != null) {
        result.data_ = functionCallBuilder_.build();
      }
      if (dataCase_ == 6 && functionResponseBuilder_ != null) {
        result.data_ = functionResponseBuilder_.build();
      }
      result.metadataCase_ = metadataCase_;
      result.metadata_ = this.metadata_;
      if (metadataCase_ == 4 && videoMetadataBuilder_ != null) {
        result.metadata_ = videoMetadataBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.Part) {
        return mergeFrom((com.google.cloud.aiplatform.v1.Part) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.Part other) {
      if (other == com.google.cloud.aiplatform.v1.Part.getDefaultInstance()) return this;
      switch (other.getDataCase()) {
        case TEXT:
          {
            dataCase_ = 1;
            data_ = other.data_;
            onChanged();
            break;
          }
        case INLINE_DATA:
          {
            mergeInlineData(other.getInlineData());
            break;
          }
        case FILE_DATA:
          {
            mergeFileData(other.getFileData());
            break;
          }
        case FUNCTION_CALL:
          {
            mergeFunctionCall(other.getFunctionCall());
            break;
          }
        case FUNCTION_RESPONSE:
          {
            mergeFunctionResponse(other.getFunctionResponse());
            break;
          }
        case DATA_NOT_SET:
          {
            break;
          }
      }
      switch (other.getMetadataCase()) {
        case VIDEO_METADATA:
          {
            mergeVideoMetadata(other.getVideoMetadata());
            break;
          }
        case METADATA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                dataCase_ = 1;
                data_ = s;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getInlineDataFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getFileDataFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getVideoMetadataFieldBuilder().getBuilder(), extensionRegistry);
                metadataCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getFunctionCallFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getFunctionResponseFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 6;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int dataCase_ = 0;
    private java.lang.Object data_;

    public DataCase getDataCase() {
      return DataCase.forNumber(dataCase_);
    }

    public Builder clearData() {
      dataCase_ = 0;
      data_ = null;
      onChanged();
      return this;
    }

    private int metadataCase_ = 0;
    private java.lang.Object metadata_;

    public MetadataCase getMetadataCase() {
      return MetadataCase.forNumber(metadataCase_);
    }

    public Builder clearMetadata() {
      metadataCase_ = 0;
      metadata_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * Optional. Text part (can be code).
     * </pre>
     *
     * <code>string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the text field is set.
     */
    @java.lang.Override
    public boolean hasText() {
      return dataCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Optional. Text part (can be code).
     * </pre>
     *
     * <code>string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The text.
     */
    @java.lang.Override
    public java.lang.String getText() {
      java.lang.Object ref = "";
      if (dataCase_ == 1) {
        ref = data_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (dataCase_ == 1) {
          data_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Text part (can be code).
     * </pre>
     *
     * <code>string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for text.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = "";
      if (dataCase_ == 1) {
        ref = data_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (dataCase_ == 1) {
          data_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Text part (can be code).
     * </pre>
     *
     * <code>string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The text to set.
     * @return This builder for chaining.
     */
    public Builder setText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataCase_ = 1;
      data_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Text part (can be code).
     * </pre>
     *
     * <code>string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearText() {
      if (dataCase_ == 1) {
        dataCase_ = 0;
        data_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Text part (can be code).
     * </pre>
     *
     * <code>string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for text to set.
     * @return This builder for chaining.
     */
    public Builder setTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataCase_ = 1;
      data_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Blob,
            com.google.cloud.aiplatform.v1.Blob.Builder,
            com.google.cloud.aiplatform.v1.BlobOrBuilder>
        inlineDataBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Inlined bytes data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Blob inline_data = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the inlineData field is set.
     */
    @java.lang.Override
    public boolean hasInlineData() {
      return dataCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Optional. Inlined bytes data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Blob inline_data = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The inlineData.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Blob getInlineData() {
      if (inlineDataBuilder_ == null) {
        if (dataCase_ == 2) {
          return (com.google.cloud.aiplatform.v1.Blob) data_;
        }
        return com.google.cloud.aiplatform.v1.Blob.getDefaultInstance();
      } else {
        if (dataCase_ == 2) {
          return inlineDataBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.Blob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Inlined bytes data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Blob inline_data = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInlineData(com.google.cloud.aiplatform.v1.Blob value) {
      if (inlineDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        inlineDataBuilder_.setMessage(value);
      }
      dataCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Inlined bytes data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Blob inline_data = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInlineData(com.google.cloud.aiplatform.v1.Blob.Builder builderForValue) {
      if (inlineDataBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        inlineDataBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Inlined bytes data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Blob inline_data = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeInlineData(com.google.cloud.aiplatform.v1.Blob value) {
      if (inlineDataBuilder_ == null) {
        if (dataCase_ == 2 && data_ != com.google.cloud.aiplatform.v1.Blob.getDefaultInstance()) {
          data_ =
              com.google.cloud.aiplatform.v1.Blob.newBuilder(
                      (com.google.cloud.aiplatform.v1.Blob) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 2) {
          inlineDataBuilder_.mergeFrom(value);
        } else {
          inlineDataBuilder_.setMessage(value);
        }
      }
      dataCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Inlined bytes data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Blob inline_data = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearInlineData() {
      if (inlineDataBuilder_ == null) {
        if (dataCase_ == 2) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 2) {
          dataCase_ = 0;
          data_ = null;
        }
        inlineDataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Inlined bytes data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Blob inline_data = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Blob.Builder getInlineDataBuilder() {
      return getInlineDataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Inlined bytes data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Blob inline_data = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.BlobOrBuilder getInlineDataOrBuilder() {
      if ((dataCase_ == 2) && (inlineDataBuilder_ != null)) {
        return inlineDataBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 2) {
          return (com.google.cloud.aiplatform.v1.Blob) data_;
        }
        return com.google.cloud.aiplatform.v1.Blob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Inlined bytes data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Blob inline_data = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Blob,
            com.google.cloud.aiplatform.v1.Blob.Builder,
            com.google.cloud.aiplatform.v1.BlobOrBuilder>
        getInlineDataFieldBuilder() {
      if (inlineDataBuilder_ == null) {
        if (!(dataCase_ == 2)) {
          data_ = com.google.cloud.aiplatform.v1.Blob.getDefaultInstance();
        }
        inlineDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Blob,
                com.google.cloud.aiplatform.v1.Blob.Builder,
                com.google.cloud.aiplatform.v1.BlobOrBuilder>(
                (com.google.cloud.aiplatform.v1.Blob) data_, getParentForChildren(), isClean());
        data_ = null;
      }
      dataCase_ = 2;
      onChanged();
      return inlineDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FileData,
            com.google.cloud.aiplatform.v1.FileData.Builder,
            com.google.cloud.aiplatform.v1.FileDataOrBuilder>
        fileDataBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. URI based data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FileData file_data = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the fileData field is set.
     */
    @java.lang.Override
    public boolean hasFileData() {
      return dataCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Optional. URI based data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FileData file_data = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The fileData.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FileData getFileData() {
      if (fileDataBuilder_ == null) {
        if (dataCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.FileData) data_;
        }
        return com.google.cloud.aiplatform.v1.FileData.getDefaultInstance();
      } else {
        if (dataCase_ == 3) {
          return fileDataBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.FileData.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. URI based data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FileData file_data = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFileData(com.google.cloud.aiplatform.v1.FileData value) {
      if (fileDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        fileDataBuilder_.setMessage(value);
      }
      dataCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. URI based data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FileData file_data = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFileData(com.google.cloud.aiplatform.v1.FileData.Builder builderForValue) {
      if (fileDataBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        fileDataBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. URI based data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FileData file_data = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeFileData(com.google.cloud.aiplatform.v1.FileData value) {
      if (fileDataBuilder_ == null) {
        if (dataCase_ == 3
            && data_ != com.google.cloud.aiplatform.v1.FileData.getDefaultInstance()) {
          data_ =
              com.google.cloud.aiplatform.v1.FileData.newBuilder(
                      (com.google.cloud.aiplatform.v1.FileData) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 3) {
          fileDataBuilder_.mergeFrom(value);
        } else {
          fileDataBuilder_.setMessage(value);
        }
      }
      dataCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. URI based data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FileData file_data = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearFileData() {
      if (fileDataBuilder_ == null) {
        if (dataCase_ == 3) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 3) {
          dataCase_ = 0;
          data_ = null;
        }
        fileDataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. URI based data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FileData file_data = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FileData.Builder getFileDataBuilder() {
      return getFileDataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. URI based data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FileData file_data = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FileDataOrBuilder getFileDataOrBuilder() {
      if ((dataCase_ == 3) && (fileDataBuilder_ != null)) {
        return fileDataBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.FileData) data_;
        }
        return com.google.cloud.aiplatform.v1.FileData.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. URI based data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FileData file_data = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FileData,
            com.google.cloud.aiplatform.v1.FileData.Builder,
            com.google.cloud.aiplatform.v1.FileDataOrBuilder>
        getFileDataFieldBuilder() {
      if (fileDataBuilder_ == null) {
        if (!(dataCase_ == 3)) {
          data_ = com.google.cloud.aiplatform.v1.FileData.getDefaultInstance();
        }
        fileDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.FileData,
                com.google.cloud.aiplatform.v1.FileData.Builder,
                com.google.cloud.aiplatform.v1.FileDataOrBuilder>(
                (com.google.cloud.aiplatform.v1.FileData) data_, getParentForChildren(), isClean());
        data_ = null;
      }
      dataCase_ = 3;
      onChanged();
      return fileDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FunctionCall,
            com.google.cloud.aiplatform.v1.FunctionCall.Builder,
            com.google.cloud.aiplatform.v1.FunctionCallOrBuilder>
        functionCallBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. A predicted [FunctionCall] returned from the model that
     * contains a string representing the [FunctionDeclaration.name] with the
     * parameters and their values.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FunctionCall function_call = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the functionCall field is set.
     */
    @java.lang.Override
    public boolean hasFunctionCall() {
      return dataCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Optional. A predicted [FunctionCall] returned from the model that
     * contains a string representing the [FunctionDeclaration.name] with the
     * parameters and their values.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FunctionCall function_call = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The functionCall.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FunctionCall getFunctionCall() {
      if (functionCallBuilder_ == null) {
        if (dataCase_ == 5) {
          return (com.google.cloud.aiplatform.v1.FunctionCall) data_;
        }
        return com.google.cloud.aiplatform.v1.FunctionCall.getDefaultInstance();
      } else {
        if (dataCase_ == 5) {
          return functionCallBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.FunctionCall.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A predicted [FunctionCall] returned from the model that
     * contains a string representing the [FunctionDeclaration.name] with the
     * parameters and their values.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FunctionCall function_call = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFunctionCall(com.google.cloud.aiplatform.v1.FunctionCall value) {
      if (functionCallBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        functionCallBuilder_.setMessage(value);
      }
      dataCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A predicted [FunctionCall] returned from the model that
     * contains a string representing the [FunctionDeclaration.name] with the
     * parameters and their values.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FunctionCall function_call = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFunctionCall(
        com.google.cloud.aiplatform.v1.FunctionCall.Builder builderForValue) {
      if (functionCallBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        functionCallBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A predicted [FunctionCall] returned from the model that
     * contains a string representing the [FunctionDeclaration.name] with the
     * parameters and their values.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FunctionCall function_call = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeFunctionCall(com.google.cloud.aiplatform.v1.FunctionCall value) {
      if (functionCallBuilder_ == null) {
        if (dataCase_ == 5
            && data_ != com.google.cloud.aiplatform.v1.FunctionCall.getDefaultInstance()) {
          data_ =
              com.google.cloud.aiplatform.v1.FunctionCall.newBuilder(
                      (com.google.cloud.aiplatform.v1.FunctionCall) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 5) {
          functionCallBuilder_.mergeFrom(value);
        } else {
          functionCallBuilder_.setMessage(value);
        }
      }
      dataCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A predicted [FunctionCall] returned from the model that
     * contains a string representing the [FunctionDeclaration.name] with the
     * parameters and their values.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FunctionCall function_call = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearFunctionCall() {
      if (functionCallBuilder_ == null) {
        if (dataCase_ == 5) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 5) {
          dataCase_ = 0;
          data_ = null;
        }
        functionCallBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A predicted [FunctionCall] returned from the model that
     * contains a string representing the [FunctionDeclaration.name] with the
     * parameters and their values.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FunctionCall function_call = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FunctionCall.Builder getFunctionCallBuilder() {
      return getFunctionCallFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. A predicted [FunctionCall] returned from the model that
     * contains a string representing the [FunctionDeclaration.name] with the
     * parameters and their values.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FunctionCall function_call = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FunctionCallOrBuilder getFunctionCallOrBuilder() {
      if ((dataCase_ == 5) && (functionCallBuilder_ != null)) {
        return functionCallBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 5) {
          return (com.google.cloud.aiplatform.v1.FunctionCall) data_;
        }
        return com.google.cloud.aiplatform.v1.FunctionCall.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A predicted [FunctionCall] returned from the model that
     * contains a string representing the [FunctionDeclaration.name] with the
     * parameters and their values.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FunctionCall function_call = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FunctionCall,
            com.google.cloud.aiplatform.v1.FunctionCall.Builder,
            com.google.cloud.aiplatform.v1.FunctionCallOrBuilder>
        getFunctionCallFieldBuilder() {
      if (functionCallBuilder_ == null) {
        if (!(dataCase_ == 5)) {
          data_ = com.google.cloud.aiplatform.v1.FunctionCall.getDefaultInstance();
        }
        functionCallBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.FunctionCall,
                com.google.cloud.aiplatform.v1.FunctionCall.Builder,
                com.google.cloud.aiplatform.v1.FunctionCallOrBuilder>(
                (com.google.cloud.aiplatform.v1.FunctionCall) data_,
                getParentForChildren(),
                isClean());
        data_ = null;
      }
      dataCase_ = 5;
      onChanged();
      return functionCallBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FunctionResponse,
            com.google.cloud.aiplatform.v1.FunctionResponse.Builder,
            com.google.cloud.aiplatform.v1.FunctionResponseOrBuilder>
        functionResponseBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The result output of a [FunctionCall] that contains a string
     * representing the [FunctionDeclaration.name] and a structured JSON object
     * containing any output from the function call. It is used as context to
     * the model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FunctionResponse function_response = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the functionResponse field is set.
     */
    @java.lang.Override
    public boolean hasFunctionResponse() {
      return dataCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Optional. The result output of a [FunctionCall] that contains a string
     * representing the [FunctionDeclaration.name] and a structured JSON object
     * containing any output from the function call. It is used as context to
     * the model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FunctionResponse function_response = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The functionResponse.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FunctionResponse getFunctionResponse() {
      if (functionResponseBuilder_ == null) {
        if (dataCase_ == 6) {
          return (com.google.cloud.aiplatform.v1.FunctionResponse) data_;
        }
        return com.google.cloud.aiplatform.v1.FunctionResponse.getDefaultInstance();
      } else {
        if (dataCase_ == 6) {
          return functionResponseBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.FunctionResponse.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The result output of a [FunctionCall] that contains a string
     * representing the [FunctionDeclaration.name] and a structured JSON object
     * containing any output from the function call. It is used as context to
     * the model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FunctionResponse function_response = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFunctionResponse(com.google.cloud.aiplatform.v1.FunctionResponse value) {
      if (functionResponseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        functionResponseBuilder_.setMessage(value);
      }
      dataCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The result output of a [FunctionCall] that contains a string
     * representing the [FunctionDeclaration.name] and a structured JSON object
     * containing any output from the function call. It is used as context to
     * the model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FunctionResponse function_response = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFunctionResponse(
        com.google.cloud.aiplatform.v1.FunctionResponse.Builder builderForValue) {
      if (functionResponseBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        functionResponseBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The result output of a [FunctionCall] that contains a string
     * representing the [FunctionDeclaration.name] and a structured JSON object
     * containing any output from the function call. It is used as context to
     * the model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FunctionResponse function_response = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeFunctionResponse(com.google.cloud.aiplatform.v1.FunctionResponse value) {
      if (functionResponseBuilder_ == null) {
        if (dataCase_ == 6
            && data_ != com.google.cloud.aiplatform.v1.FunctionResponse.getDefaultInstance()) {
          data_ =
              com.google.cloud.aiplatform.v1.FunctionResponse.newBuilder(
                      (com.google.cloud.aiplatform.v1.FunctionResponse) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 6) {
          functionResponseBuilder_.mergeFrom(value);
        } else {
          functionResponseBuilder_.setMessage(value);
        }
      }
      dataCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The result output of a [FunctionCall] that contains a string
     * representing the [FunctionDeclaration.name] and a structured JSON object
     * containing any output from the function call. It is used as context to
     * the model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FunctionResponse function_response = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearFunctionResponse() {
      if (functionResponseBuilder_ == null) {
        if (dataCase_ == 6) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 6) {
          dataCase_ = 0;
          data_ = null;
        }
        functionResponseBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The result output of a [FunctionCall] that contains a string
     * representing the [FunctionDeclaration.name] and a structured JSON object
     * containing any output from the function call. It is used as context to
     * the model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FunctionResponse function_response = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FunctionResponse.Builder getFunctionResponseBuilder() {
      return getFunctionResponseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The result output of a [FunctionCall] that contains a string
     * representing the [FunctionDeclaration.name] and a structured JSON object
     * containing any output from the function call. It is used as context to
     * the model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FunctionResponse function_response = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FunctionResponseOrBuilder getFunctionResponseOrBuilder() {
      if ((dataCase_ == 6) && (functionResponseBuilder_ != null)) {
        return functionResponseBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 6) {
          return (com.google.cloud.aiplatform.v1.FunctionResponse) data_;
        }
        return com.google.cloud.aiplatform.v1.FunctionResponse.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The result output of a [FunctionCall] that contains a string
     * representing the [FunctionDeclaration.name] and a structured JSON object
     * containing any output from the function call. It is used as context to
     * the model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FunctionResponse function_response = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FunctionResponse,
            com.google.cloud.aiplatform.v1.FunctionResponse.Builder,
            com.google.cloud.aiplatform.v1.FunctionResponseOrBuilder>
        getFunctionResponseFieldBuilder() {
      if (functionResponseBuilder_ == null) {
        if (!(dataCase_ == 6)) {
          data_ = com.google.cloud.aiplatform.v1.FunctionResponse.getDefaultInstance();
        }
        functionResponseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.FunctionResponse,
                com.google.cloud.aiplatform.v1.FunctionResponse.Builder,
                com.google.cloud.aiplatform.v1.FunctionResponseOrBuilder>(
                (com.google.cloud.aiplatform.v1.FunctionResponse) data_,
                getParentForChildren(),
                isClean());
        data_ = null;
      }
      dataCase_ = 6;
      onChanged();
      return functionResponseBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.VideoMetadata,
            com.google.cloud.aiplatform.v1.VideoMetadata.Builder,
            com.google.cloud.aiplatform.v1.VideoMetadataOrBuilder>
        videoMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Video metadata. The metadata should only be specified while the
     * video data is presented in inline_data or file_data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.VideoMetadata video_metadata = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the videoMetadata field is set.
     */
    @java.lang.Override
    public boolean hasVideoMetadata() {
      return metadataCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Optional. Video metadata. The metadata should only be specified while the
     * video data is presented in inline_data or file_data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.VideoMetadata video_metadata = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The videoMetadata.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.VideoMetadata getVideoMetadata() {
      if (videoMetadataBuilder_ == null) {
        if (metadataCase_ == 4) {
          return (com.google.cloud.aiplatform.v1.VideoMetadata) metadata_;
        }
        return com.google.cloud.aiplatform.v1.VideoMetadata.getDefaultInstance();
      } else {
        if (metadataCase_ == 4) {
          return videoMetadataBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.VideoMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Video metadata. The metadata should only be specified while the
     * video data is presented in inline_data or file_data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.VideoMetadata video_metadata = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setVideoMetadata(com.google.cloud.aiplatform.v1.VideoMetadata value) {
      if (videoMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
        onChanged();
      } else {
        videoMetadataBuilder_.setMessage(value);
      }
      metadataCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Video metadata. The metadata should only be specified while the
     * video data is presented in inline_data or file_data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.VideoMetadata video_metadata = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setVideoMetadata(
        com.google.cloud.aiplatform.v1.VideoMetadata.Builder builderForValue) {
      if (videoMetadataBuilder_ == null) {
        metadata_ = builderForValue.build();
        onChanged();
      } else {
        videoMetadataBuilder_.setMessage(builderForValue.build());
      }
      metadataCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Video metadata. The metadata should only be specified while the
     * video data is presented in inline_data or file_data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.VideoMetadata video_metadata = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeVideoMetadata(com.google.cloud.aiplatform.v1.VideoMetadata value) {
      if (videoMetadataBuilder_ == null) {
        if (metadataCase_ == 4
            && metadata_ != com.google.cloud.aiplatform.v1.VideoMetadata.getDefaultInstance()) {
          metadata_ =
              com.google.cloud.aiplatform.v1.VideoMetadata.newBuilder(
                      (com.google.cloud.aiplatform.v1.VideoMetadata) metadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metadata_ = value;
        }
        onChanged();
      } else {
        if (metadataCase_ == 4) {
          videoMetadataBuilder_.mergeFrom(value);
        } else {
          videoMetadataBuilder_.setMessage(value);
        }
      }
      metadataCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Video metadata. The metadata should only be specified while the
     * video data is presented in inline_data or file_data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.VideoMetadata video_metadata = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearVideoMetadata() {
      if (videoMetadataBuilder_ == null) {
        if (metadataCase_ == 4) {
          metadataCase_ = 0;
          metadata_ = null;
          onChanged();
        }
      } else {
        if (metadataCase_ == 4) {
          metadataCase_ = 0;
          metadata_ = null;
        }
        videoMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Video metadata. The metadata should only be specified while the
     * video data is presented in inline_data or file_data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.VideoMetadata video_metadata = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.VideoMetadata.Builder getVideoMetadataBuilder() {
      return getVideoMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Video metadata. The metadata should only be specified while the
     * video data is presented in inline_data or file_data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.VideoMetadata video_metadata = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.VideoMetadataOrBuilder getVideoMetadataOrBuilder() {
      if ((metadataCase_ == 4) && (videoMetadataBuilder_ != null)) {
        return videoMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (metadataCase_ == 4) {
          return (com.google.cloud.aiplatform.v1.VideoMetadata) metadata_;
        }
        return com.google.cloud.aiplatform.v1.VideoMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Video metadata. The metadata should only be specified while the
     * video data is presented in inline_data or file_data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.VideoMetadata video_metadata = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.VideoMetadata,
            com.google.cloud.aiplatform.v1.VideoMetadata.Builder,
            com.google.cloud.aiplatform.v1.VideoMetadataOrBuilder>
        getVideoMetadataFieldBuilder() {
      if (videoMetadataBuilder_ == null) {
        if (!(metadataCase_ == 4)) {
          metadata_ = com.google.cloud.aiplatform.v1.VideoMetadata.getDefaultInstance();
        }
        videoMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.VideoMetadata,
                com.google.cloud.aiplatform.v1.VideoMetadata.Builder,
                com.google.cloud.aiplatform.v1.VideoMetadataOrBuilder>(
                (com.google.cloud.aiplatform.v1.VideoMetadata) metadata_,
                getParentForChildren(),
                isClean());
        metadata_ = null;
      }
      metadataCase_ = 4;
      onChanged();
      return videoMetadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.Part)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.Part)
  private static final com.google.cloud.aiplatform.v1.Part DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.Part();
  }

  public static com.google.cloud.aiplatform.v1.Part getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Part> PARSER =
      new com.google.protobuf.AbstractParser<Part>() {
        @java.lang.Override
        public Part parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Part> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Part> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Part getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
