/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.lib.reflect;

import com.google.ads.googleads.lib.logging.scrub.FieldAccessor;
import com.google.ads.googleads.lib.reflect.ImmutableTreeNode;
import com.google.ads.googleads.lib.reflect.MutableTreeNode;
import com.google.ads.googleads.lib.reflect.ReflectionTraversal;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ReflectionFieldAccessor
implements FieldAccessor {
    private final List<String> fieldNames;

    public ReflectionFieldAccessor(String path) {
        this.fieldNames = Arrays.asList(path.split("\\."));
    }

    @Override
    public Message setFieldIfPresent(Message input, String toSet) {
        Message.Builder builder = input.toBuilder();
        ReflectionTraversal.visitFieldPath(new MutableTreeNode(builder), this.fieldNames, new SetIfPresentVisitor(toSet));
        return builder.build();
    }

    @Override
    public <T> List<T> getValues(Message input) {
        GetValueVisitor visitor = new GetValueVisitor();
        ReflectionTraversal.visitFieldPath(new ImmutableTreeNode((MessageOrBuilder)input), this.fieldNames, visitor);
        return visitor.getValues();
    }

    private static class GetValueVisitor
    implements ReflectionTraversal.Visitor<ImmutableTreeNode> {
        private final List<Object> values = new ArrayList<Object>();

        private GetValueVisitor() {
        }

        @Override
        public void visitUnaryField(ImmutableTreeNode currentBuilder, Descriptors.FieldDescriptor fieldDescriptor) {
            this.values.add(currentBuilder.getFieldValue(fieldDescriptor));
        }

        @Override
        public void visitRepeatedField(ImmutableTreeNode currentBuilder, Descriptors.FieldDescriptor fieldDescriptor) {
            this.values.addAll((Collection)currentBuilder.getFieldValue(fieldDescriptor));
        }

        public List<Object> getValues() {
            return Collections.unmodifiableList(this.values);
        }
    }

    private static class SetIfPresentVisitor
    implements ReflectionTraversal.Visitor<MutableTreeNode> {
        private final String toSet;

        public SetIfPresentVisitor(String toSet) {
            this.toSet = toSet;
        }

        @Override
        public void visitUnaryField(MutableTreeNode currentBuilder, Descriptors.FieldDescriptor fieldDescriptor) {
            currentBuilder.setField(fieldDescriptor, this.toSet);
        }

        @Override
        public void visitRepeatedField(MutableTreeNode currentBuilder, Descriptors.FieldDescriptor fieldDescriptor) {
            int numRepeatedValues = currentBuilder.getRepeatedFieldCount(fieldDescriptor);
            for (int i = 0; i < numRepeatedValues; ++i) {
                currentBuilder.setRepeatedField(fieldDescriptor, i, this.toSet);
            }
        }
    }
}

