// Copyright 2011 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.api.ads.dfp.lib.conf;

import com.google.api.ads.common.lib.conf.ConfigurationModule;
import com.google.common.collect.Lists;

import java.net.URL;

/**
 * Configuration for DFP configuration.
 */
public class DfpConfigurationModule extends ConfigurationModule {

  @Override
  protected void configure() {
    super.configure();
    configureConfigurations(DfpApiConfiguration.class,
        Lists.<URL>newArrayList(DfpConfigurationModule.class
            .getResource("props/dfp-api.properties")),
        null,
        DfpLibConfiguration.class,
        null,
        null,
        Lists.<URL>newArrayList(DfpConfigurationModule.class
            .getResource("props/build.properties")));
  }
}
