/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.agents;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.google.common.base.CaseFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class YamlPreprocessor {
    private static final Logger logger = LoggerFactory.getLogger(YamlPreprocessor.class);

    private YamlPreprocessor() {
    }

    static String preprocessYaml(String yamlContent) {
        if (yamlContent == null || yamlContent.trim().isEmpty()) {
            return yamlContent;
        }
        try {
            ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            Map root = (Map)yamlMapper.readValue(yamlContent, (TypeReference)new TypeReference<Map<String, Object>>(){});
            if (root == null) {
                return yamlContent;
            }
            Map<String, Object> converted = YamlPreprocessor.convertKeysRecursively(root);
            YAMLFactory yamlFactory = YAMLFactory.builder().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).build();
            ObjectMapper outputMapper = new ObjectMapper((JsonFactory)yamlFactory);
            String result = outputMapper.writerWithDefaultPrettyPrinter().writeValueAsString(converted);
            logger.debug("Successfully preprocessed YAML content");
            return result;
        }
        catch (Exception e) {
            logger.warn("Failed to preprocess YAML content, returning original: {}", (Object)e.getMessage());
            return yamlContent;
        }
    }

    private static Map<String, Object> convertKeysRecursively(Map<String, Object> map) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            String camelKey = YamlPreprocessor.convertToCamelCase(key);
            if (value instanceof Map) {
                result.put(camelKey, YamlPreprocessor.convertKeysRecursively((Map)value));
                continue;
            }
            if (value instanceof List) {
                result.put(camelKey, YamlPreprocessor.convertListRecursively((List)value));
                continue;
            }
            result.put(camelKey, value);
        }
        return result;
    }

    private static List<Object> convertListRecursively(List<?> list) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object item : list) {
            if (item instanceof Map) {
                result.add(YamlPreprocessor.convertKeysRecursively((Map)item));
                continue;
            }
            if (item instanceof List) {
                result.add(YamlPreprocessor.convertListRecursively((List)item));
                continue;
            }
            result.add(item);
        }
        return result;
    }

    private static String convertToCamelCase(String key) {
        if (key == null || key.isEmpty()) {
            return key;
        }
        if (!key.contains("_")) {
            return key;
        }
        try {
            return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, key);
        }
        catch (RuntimeException e) {
            logger.debug("Could not convert key '{}' to camelCase, keeping original: {}", (Object)key, (Object)e.getMessage());
            return key;
        }
    }
}

