/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.agents;

import com.google.adk.agents.InvocationContext;
import com.google.adk.events.Event;
import com.google.genai.types.Content;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ReadonlyContext {
    protected final InvocationContext invocationContext;
    private List<Event> eventsView;
    private Map<String, Object> stateView;

    public ReadonlyContext(InvocationContext invocationContext) {
        this.invocationContext = invocationContext;
    }

    public Optional<Content> userContent() {
        return this.invocationContext.userContent();
    }

    public String invocationId() {
        return this.invocationContext.invocationId();
    }

    public Optional<String> branch() {
        return this.invocationContext.branch();
    }

    public String agentName() {
        return this.invocationContext.agent().name();
    }

    public String sessionId() {
        return this.invocationContext.session().id();
    }

    public List<Event> events() {
        if (this.eventsView == null) {
            this.eventsView = Collections.unmodifiableList(this.invocationContext.session().events());
        }
        return this.eventsView;
    }

    public Map<String, Object> state() {
        if (this.stateView == null) {
            this.stateView = Collections.unmodifiableMap(this.invocationContext.session().state());
        }
        return this.stateView;
    }
}

