/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.sessions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.adk.JsonBaseModel;
import com.google.adk.events.Event;
import com.google.adk.events.EventActions;
import com.google.adk.sessions.ApiResponse;
import com.google.adk.sessions.BaseSessionService;
import com.google.adk.sessions.GetSessionConfig;
import com.google.adk.sessions.HttpApiClient;
import com.google.adk.sessions.ListEventsResponse;
import com.google.adk.sessions.ListSessionsResponse;
import com.google.adk.sessions.Session;
import com.google.adk.sessions.SessionUtils;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.genai.types.Content;
import com.google.genai.types.FinishReason;
import com.google.genai.types.GroundingMetadata;
import com.google.genai.types.HttpOptions;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VertexAiSessionService
implements BaseSessionService {
    private final String project;
    private final String location;
    private final HttpApiClient apiClient;
    private String reasoningEngineId;
    private int maxRetryAttempts = 5;
    private Map<String, Object> sessionJsonMap;
    private final ObjectMapper objectMapper = JsonBaseModel.getMapper();
    private static final Logger logger = LoggerFactory.getLogger(VertexAiSessionService.class);
    private static final Pattern APP_NAME_PATTERN = Pattern.compile("^projects/([a-zA-Z0-9-_]+)/locations/([a-zA-Z0-9-_]+)/reasoningEngines/(\\d+)$");

    public VertexAiSessionService(String project, String location, HttpApiClient apiClient) {
        this.project = project;
        this.location = location;
        this.apiClient = apiClient;
    }

    public VertexAiSessionService() {
        this.project = "";
        this.location = "";
        this.apiClient = new HttpApiClient(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public VertexAiSessionService(String project, String location, Optional<GoogleCredentials> credentials, Optional<HttpOptions> httpOptions) {
        this.project = project;
        this.location = location;
        this.apiClient = new HttpApiClient(Optional.of(this.project), Optional.of(this.location), credentials, httpOptions);
    }

    public JsonNode getJsonResponse(ApiResponse apiResponse) {
        try {
            ResponseBody responseBody = apiResponse.getResponseBody();
            return this.objectMapper.readTree(responseBody.string());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Single<Session> createSession(String appName, String userId, @Nullable ConcurrentMap<String, Object> state, @Nullable String sessionId) {
        ApiResponse lroResponse;
        JsonNode jsonResponse;
        String sessId;
        ApiResponse apiResponse;
        this.reasoningEngineId = VertexAiSessionService.parseReasoningEngineId(appName);
        this.sessionJsonMap = new ConcurrentHashMap<String, Object>();
        this.sessionJsonMap.put("userId", userId);
        if (state != null) {
            this.sessionJsonMap.put("sessionState", state);
        }
        try {
            apiResponse = this.apiClient.request("POST", "reasoningEngines/" + this.reasoningEngineId + "/sessions", this.objectMapper.writeValueAsString(this.sessionJsonMap));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        logger.debug("Create Session response {}", (Object)apiResponse.getResponseBody());
        String sessionName = "";
        String operationId = "";
        String string = sessId = sessionId == null ? "" : sessionId;
        if (apiResponse.getResponseBody() != null) {
            JsonNode jsonResponse2 = this.getJsonResponse(apiResponse);
            sessionName = jsonResponse2.get("name").asText();
            List parts = Splitter.on((char)'/').splitToList((CharSequence)sessionName);
            sessId = (String)parts.get(parts.size() - 3);
            operationId = (String)parts.get(parts.size() - 1);
        }
        while (this.maxRetryAttempts >= 0 && (jsonResponse = this.getJsonResponse(lroResponse = this.apiClient.request("GET", "operations/" + operationId, ""))).get("done") == null) {
            try {
                TimeUnit.SECONDS.sleep(1L);
                --this.maxRetryAttempts;
            }
            catch (InterruptedException e) {
                logger.warn("Error during sleep", (Throwable)e);
            }
        }
        ApiResponse getSessionApiResponse = this.apiClient.request("GET", "reasoningEngines/" + this.reasoningEngineId + "/sessions/" + sessId, "");
        JsonNode getSessionResponseMap = this.getJsonResponse(getSessionApiResponse);
        Instant updateTimestamp = Instant.parse(getSessionResponseMap.get("updateTime").asText());
        ConcurrentMap<String, Object> sessionState = new ConcurrentHashMap<String, Object>();
        try {
            JsonNode sessionStateNode;
            if (getSessionResponseMap != null && getSessionResponseMap.has("sessionState") && (sessionStateNode = getSessionResponseMap.get("sessionState")) != null) {
                sessionState = (ConcurrentMap)this.objectMapper.readValue(sessionStateNode.toString(), (TypeReference)new TypeReference<ConcurrentMap<String, Object>>(){});
            }
        }
        catch (JsonProcessingException e) {
            logger.warn("Error while parsing session state: {}", (Object)e.getMessage());
        }
        return Single.just((Object)Session.builder(sessId).appName(appName).userId(userId).lastUpdateTime(updateTimestamp).state(sessionState).build());
    }

    @Override
    public Single<ListSessionsResponse> listSessions(String appName, String userId) {
        List apiSessions;
        this.reasoningEngineId = VertexAiSessionService.parseReasoningEngineId(appName);
        ApiResponse apiResponse = this.apiClient.request("GET", "reasoningEngines/" + this.reasoningEngineId + "/sessions?filter=user_id=" + userId, "");
        if (apiResponse.getResponseBody() == null) {
            return Single.just((Object)ListSessionsResponse.builder().build());
        }
        JsonNode listSessionsResponseMap = this.getJsonResponse(apiResponse);
        try {
            apiSessions = (List)this.objectMapper.readValue(listSessionsResponseMap.get("sessions").toString(), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        }
        catch (JsonProcessingException e) {
            apiSessions = new ArrayList();
        }
        ArrayList<Session> sessions = new ArrayList<Session>();
        for (Map apiSession : apiSessions) {
            String name = (String)apiSession.get("name");
            List parts = Splitter.on((char)'/').splitToList((CharSequence)name);
            String sessionId = (String)parts.get(parts.size() - 1);
            Instant updateTimestamp = Instant.parse((String)apiSession.get("updateTime"));
            Session session = Session.builder(sessionId).appName(appName).userId(userId).state(new ConcurrentHashMap<String, Object>()).lastUpdateTime(updateTimestamp).build();
            sessions.add(session);
        }
        return Single.just((Object)ListSessionsResponse.builder().sessions(sessions).build());
    }

    @Override
    public Single<ListEventsResponse> listEvents(String appName, String userId, String sessionId) {
        List listEventsResponse;
        this.reasoningEngineId = VertexAiSessionService.parseReasoningEngineId(appName);
        ApiResponse apiResponse = this.apiClient.request("GET", "reasoningEngines/" + this.reasoningEngineId + "/sessions/" + sessionId + "/events", "");
        logger.debug("List events response {}", (Object)apiResponse);
        if (apiResponse.getResponseBody() == null) {
            return Single.just((Object)ListEventsResponse.builder().build());
        }
        JsonNode getEventsResponseMap = this.getJsonResponse(apiResponse);
        try {
            listEventsResponse = (List)this.objectMapper.readValue(getEventsResponseMap.get("sessionEvents").toString(), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        }
        catch (JsonProcessingException e) {
            listEventsResponse = new ArrayList();
        }
        ArrayList<Event> events = new ArrayList<Event>();
        for (Map event : listEventsResponse) {
            events.add(this.fromApiEvent(event));
        }
        return Single.just((Object)ListEventsResponse.builder().events(events).build());
    }

    @Override
    public Maybe<Session> getSession(String appName, String userId, String sessionId, Optional<GetSessionConfig> config) {
        ConcurrentHashMap<String, Object> sessionState;
        this.reasoningEngineId = VertexAiSessionService.parseReasoningEngineId(appName);
        ApiResponse apiResponse = this.apiClient.request("GET", "reasoningEngines/" + this.reasoningEngineId + "/sessions/" + sessionId, "");
        JsonNode getSessionResponseMap = this.getJsonResponse(apiResponse);
        String name = getSessionResponseMap.get("name").asText();
        List parts = Splitter.on((char)'/').splitToList((CharSequence)name);
        String sessId = (String)parts.get(parts.size() - 1);
        Instant updateTimestamp = Instant.parse(getSessionResponseMap.get("updateTime").asText());
        try {
            sessionState = (ConcurrentMap)this.objectMapper.readValue(getSessionResponseMap.get("sessionState").toString(), (TypeReference)new TypeReference<ConcurrentMap<String, Object>>(){});
        }
        catch (JsonProcessingException e) {
            sessionState = new ConcurrentHashMap();
        }
        Session session = Session.builder(sessId).appName(appName).userId(userId).lastUpdateTime(updateTimestamp).state(sessionState).build();
        ApiResponse listEventsApiResponse = this.apiClient.request("GET", "reasoningEngines/" + this.reasoningEngineId + "/sessions/" + sessionId + "/events", "");
        if (listEventsApiResponse.getResponseBody() == null) {
            return Maybe.just((Object)session);
        }
        JsonNode getEventsResponseMap = this.getJsonResponse(listEventsApiResponse);
        List listEventsResponse = new ArrayList();
        try {
            JsonNode sessionEventsNode;
            if (getEventsResponseMap != null && getEventsResponseMap.has("sessionEvents") && (sessionEventsNode = getEventsResponseMap.get("sessionEvents")) != null && !sessionEventsNode.isNull()) {
                listEventsResponse = (List)this.objectMapper.readValue(sessionEventsNode.toString(), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
            }
        }
        catch (JsonProcessingException e) {
            logger.warn("Error while parsing session events: {}", (Object)e.getMessage());
        }
        List<Event> events = new ArrayList<Event>();
        for (Map event3 : listEventsResponse) {
            events.add(this.fromApiEvent(event3));
        }
        events.removeIf(event -> Instant.ofEpochMilli(event.timestamp()).isAfter(updateTimestamp));
        events.sort((event1, event2) -> Instant.ofEpochMilli(event1.timestamp()).compareTo(Instant.ofEpochMilli(event2.timestamp())));
        if (config.isPresent()) {
            if (config.get().numRecentEvents().isPresent()) {
                int numRecentEvents = config.get().numRecentEvents().get();
                if (events.size() > numRecentEvents) {
                    events = events.subList(events.size() - numRecentEvents, events.size());
                }
            } else if (config.get().afterTimestamp().isPresent()) {
                int i;
                Instant afterTimestamp = config.get().afterTimestamp().get();
                for (i = events.size() - 1; i >= 0 && !Instant.ofEpochMilli(events.get(i).timestamp()).isBefore(afterTimestamp); --i) {
                }
                if (i >= 0) {
                    events = events.subList(i, events.size());
                }
            }
        }
        session = Session.builder(sessId).appName(appName).userId(userId).lastUpdateTime(updateTimestamp).state(sessionState).events(events).build();
        return Maybe.just((Object)session);
    }

    @Override
    public Completable deleteSession(String appName, String userId, String sessionId) {
        this.reasoningEngineId = VertexAiSessionService.parseReasoningEngineId(appName);
        ApiResponse unused = this.apiClient.request("DELETE", "reasoningEngines/" + this.reasoningEngineId + "/sessions/" + sessionId, "");
        return Completable.complete();
    }

    @Override
    public Single<Event> appendEvent(Session session, Event event) {
        BaseSessionService.super.appendEvent(session, event);
        this.reasoningEngineId = VertexAiSessionService.parseReasoningEngineId(session.appName());
        ApiResponse response = this.apiClient.request("POST", "reasoningEngines/" + this.reasoningEngineId + "/sessions/" + session.id() + ":appendEvent", this.convertEventToJson(event));
        try {
            if (response.getResponseBody().string().contains("com.google.genai.errors.ClientException")) {
                System.err.println("Failed to append event: " + String.valueOf(event));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        response.close();
        return Single.just((Object)event);
    }

    public String convertEventToJson(Event event) {
        HashMap<String, Optional<Boolean>> metadataJson = new HashMap<String, Optional<Boolean>>();
        metadataJson.put("partial", event.partial());
        metadataJson.put("turnComplete", event.turnComplete());
        metadataJson.put("interrupted", event.interrupted());
        metadataJson.put("branch", event.branch().orElse(null));
        metadataJson.put("long_running_tool_ids", event.longRunningToolIds() != null ? event.longRunningToolIds().orElse(null) : null);
        if (event.groundingMetadata() != null) {
            metadataJson.put("grounding_metadata", event.groundingMetadata());
        }
        HashMap<String, Object> eventJson = new HashMap<String, Object>();
        eventJson.put("author", event.author());
        eventJson.put("invocationId", event.invocationId());
        eventJson.put("timestamp", new HashMap(ImmutableMap.of((Object)"seconds", (Object)(event.timestamp() / 1000L), (Object)"nanos", (Object)(event.timestamp() % 1000L * 1000000L))));
        eventJson.put("errorCode", event.errorCode());
        eventJson.put("errorMessage", event.errorMessage());
        eventJson.put("eventMetadata", metadataJson);
        if (event.actions() != null) {
            HashMap<String, Object> actionsJson = new HashMap<String, Object>();
            actionsJson.put("skipSummarization", event.actions().skipSummarization());
            actionsJson.put("stateDelta", event.actions().stateDelta());
            actionsJson.put("artifactDelta", event.actions().artifactDelta());
            actionsJson.put("transferAgent", event.actions().transferToAgent());
            actionsJson.put("escalate", event.actions().escalate());
            actionsJson.put("requestedAuthConfigs", event.actions().requestedAuthConfigs());
            eventJson.put("actions", actionsJson);
        }
        if (event.content().isPresent()) {
            eventJson.put("content", SessionUtils.encodeContent(event.content().get()));
        }
        if (event.errorCode().isPresent()) {
            eventJson.put("errorCode", event.errorCode().get());
        }
        if (event.errorMessage().isPresent()) {
            eventJson.put("errorMessage", event.errorMessage().get());
        }
        try {
            return this.objectMapper.writeValueAsString(eventJson);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    @Nullable
    private Content convertMapToContent(Object rawContentValue) {
        if (rawContentValue == null) {
            return null;
        }
        if (rawContentValue instanceof Map) {
            Map contentMap = (Map)rawContentValue;
            try {
                return (Content)this.objectMapper.convertValue((Object)contentMap, Content.class);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Error converting Map to Content: " + e.getMessage());
                return null;
            }
        }
        System.err.println("Unexpected type for 'content' in apiEvent: " + rawContentValue.getClass().getName());
        return null;
    }

    public static String parseReasoningEngineId(String appName) {
        if (appName.matches("\\d+")) {
            return appName;
        }
        Matcher matcher = APP_NAME_PATTERN.matcher(appName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("App name " + appName + " is not valid. It should either be the full ReasoningEngine resource name, or the reasoning engine id.");
        }
        return matcher.group(matcher.groupCount());
    }

    public Event fromApiEvent(Map<String, Object> apiEvent) {
        EventActions eventActions = new EventActions();
        if (apiEvent.get("actions") != null) {
            Map actionsMap = (Map)apiEvent.get("actions");
            eventActions.setSkipSummarization(Optional.ofNullable(actionsMap.get("skipSummarization")).map(value -> (Boolean)value));
            eventActions.setStateDelta(actionsMap.get("stateDelta") != null ? new ConcurrentHashMap((Map)actionsMap.get("stateDelta")) : new ConcurrentHashMap());
            eventActions.setArtifactDelta(actionsMap.get("artifactDelta") != null ? new ConcurrentHashMap((Map)actionsMap.get("artifactDelta")) : new ConcurrentHashMap());
            eventActions.setTransferToAgent(actionsMap.get("transferAgent") != null ? (String)actionsMap.get("transferAgent") : null);
            eventActions.setEscalate(Optional.ofNullable(actionsMap.get("escalate")).map(value -> (Boolean)value));
            eventActions.setRequestedAuthConfigs(actionsMap.get("requestedAuthConfigs") != null ? (ConcurrentMap)actionsMap.get("requestedAuthConfigs") : new ConcurrentHashMap());
        }
        Event event = Event.builder().id((String)Iterables.get((Iterable)Splitter.on((char)'/').split((CharSequence)apiEvent.get("name").toString()), (int)(apiEvent.get("name").toString().split("/").length - 1))).invocationId((String)apiEvent.get("invocationId")).author((String)apiEvent.get("author")).actions(eventActions).content((Content)Optional.ofNullable(apiEvent.get("content")).map(rawContentValue -> this.convertMapToContent(rawContentValue)).map(contentObject -> SessionUtils.decodeContent(contentObject)).orElse(null)).timestamp(Instant.parse((String)apiEvent.get("timestamp")).toEpochMilli()).errorCode(Optional.ofNullable(apiEvent.get("errorCode")).map(value -> new FinishReason((String)value))).errorMessage(Optional.ofNullable(apiEvent.get("errorMessage")).map(value -> (String)value)).branch(Optional.ofNullable(apiEvent.get("branch")).map(value -> (String)value)).build();
        if (apiEvent.get("eventMetadata") != null) {
            Map eventMetadata = (Map)apiEvent.get("eventMetadata");
            List longRunningToolIdsList = (List)eventMetadata.get("longRunningToolIds");
            GroundingMetadata groundingMetadata = null;
            Object rawGroundingMetadata = eventMetadata.get("groundingMetadata");
            if (rawGroundingMetadata != null) {
                groundingMetadata = (GroundingMetadata)this.objectMapper.convertValue(rawGroundingMetadata, GroundingMetadata.class);
            }
            event = event.toBuilder().partial(Optional.ofNullable((Boolean)eventMetadata.get("partial")).orElse(false)).turnComplete(Optional.ofNullable((Boolean)eventMetadata.get("turnComplete")).orElse(false)).interrupted(Optional.ofNullable((Boolean)eventMetadata.get("interrupted")).orElse(false)).branch(Optional.ofNullable((String)eventMetadata.get("branch"))).groundingMetadata(groundingMetadata).longRunningToolIds(longRunningToolIdsList != null ? new HashSet(longRunningToolIdsList) : null).build();
        }
        return event;
    }
}

