/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.examples;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.adk.examples.BaseExampleProvider;
import com.google.adk.examples.Example;
import com.google.genai.types.Content;
import com.google.genai.types.FunctionCall;
import com.google.genai.types.FunctionResponse;
import com.google.genai.types.Part;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class ExampleUtils {
    private static final String EXAMPLES_INTRO = "<EXAMPLES>\nBegin few-shot\nThe following are examples of user queries and model responses using the available tools.\n\n";
    private static final String EXAMPLES_END = "End few-shot\nNow, try to follow these examples and complete the following conversation\n<EXAMPLES>";
    private static final String EXAMPLE_START = "EXAMPLE %d:\nBegin example\n";
    private static final String EXAMPLE_END = "End example\n\n";
    private static final String USER_PREFIX = "[user]\n";
    private static final String MODEL_PREFIX = "[model]\n";
    private static final String FUNCTION_CALL_PREFIX = "```tool_code\n";
    private static final String FUNCTION_CALL_SUFFIX = "\n```\n";
    private static final String FUNCTION_RESPONSE_PREFIX = "```tool_outputs\n";
    private static final String FUNCTION_RESPONSE_SUFFIX = "\n```\n";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private static String convertExamplesToText(List<Example> examples) {
        StringBuilder examplesStr = new StringBuilder();
        for (int exampleNum = 0; exampleNum < examples.size(); ++exampleNum) {
            Example example = examples.get(exampleNum);
            StringBuilder output = new StringBuilder();
            output.append(String.format(EXAMPLE_START, exampleNum + 1)).append(USER_PREFIX).append((String)((Part)((List)example.input().parts().get()).get(0)).text().get()).append("\n\n");
            for (Content content : example.output()) {
                String rolePrefix = content.role().orElse("").equals("model") ? MODEL_PREFIX : USER_PREFIX;
                for (Part part : content.parts().orElse(Collections.emptyList())) {
                    if (part.functionCall().isPresent()) {
                        Map argsMap = ((FunctionCall)part.functionCall().get()).args().orElse(Collections.emptyMap());
                        List args = argsMap.entrySet().stream().map(entry -> {
                            String key = (String)entry.getKey();
                            Object value = entry.getValue();
                            if (value instanceof String) {
                                return String.format("%s='%s'", key, value);
                            }
                            return String.format("%s=%s", key, value);
                        }).collect(Collectors.toList());
                        output.append(rolePrefix).append(FUNCTION_CALL_PREFIX).append(((FunctionCall)part.functionCall().get()).name().orElse("")).append("(").append(String.join((CharSequence)", ", args)).append(")").append("\n```\n");
                        continue;
                    }
                    if (part.functionResponse().isPresent()) {
                        try {
                            output.append(FUNCTION_RESPONSE_PREFIX).append(OBJECT_MAPPER.writeValueAsString(((FunctionResponse)part.functionResponse().get()).response().orElse(Collections.emptyMap()))).append("\n```\n");
                        }
                        catch (JsonProcessingException e) {
                            output.append(FUNCTION_RESPONSE_PREFIX).append("\n```\n");
                        }
                        continue;
                    }
                    if (!part.text().isPresent()) continue;
                    output.append(rolePrefix).append(part.text().orElse("")).append("\n");
                }
            }
            output.append(EXAMPLE_END);
            examplesStr.append((CharSequence)output);
        }
        return EXAMPLES_INTRO + examplesStr.toString() + EXAMPLES_END;
    }

    public static String buildExampleSi(BaseExampleProvider exampleProvider, String query) {
        return ExampleUtils.convertExamplesToText(exampleProvider.getExamples(query));
    }

    private ExampleUtils() {
    }
}

