/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.artifacts;

import com.google.adk.artifacts.BaseArtifactService;
import com.google.adk.artifacts.ListArtifactsResponse;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.common.base.Splitter;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.genai.types.Blob;
import com.google.genai.types.Part;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

public final class GcsArtifactService
implements BaseArtifactService {
    private final String bucketName;
    private final Storage storageClient;

    public GcsArtifactService(String bucketName, Storage storageClient) {
        this.bucketName = bucketName;
        this.storageClient = storageClient;
    }

    private boolean fileHasUserNamespace(String filename) {
        return filename != null && filename.startsWith("user:");
    }

    private String getBlobPrefix(String appName, String userId, String sessionId, String filename) {
        if (this.fileHasUserNamespace(filename)) {
            return String.format("%s/%s/user/%s/", appName, userId, filename);
        }
        return String.format("%s/%s/%s/%s/", appName, userId, sessionId, filename);
    }

    private String getBlobName(String appName, String userId, String sessionId, String filename, int version) {
        return this.getBlobPrefix(appName, userId, sessionId, filename) + version;
    }

    @Override
    public Single<Integer> saveArtifact(String appName, String userId, String sessionId, String filename, Part artifact) {
        ImmutableList versions = (ImmutableList)this.listVersions(appName, userId, sessionId, filename).blockingGet();
        int nextVersion = versions.isEmpty() ? 0 : (Integer)Collections.max(versions) + 1;
        String blobName = this.getBlobName(appName, userId, sessionId, filename, nextVersion);
        BlobId blobId = BlobId.of((String)this.bucketName, (String)blobName);
        BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)blobId).setContentType((String)((Blob)artifact.inlineData().get()).mimeType().orElse(null)).build();
        try {
            byte[] dataToSave = (byte[])((Blob)artifact.inlineData().get()).data().orElseThrow(() -> new IllegalArgumentException("Saveable artifact data must be non-empty."));
            this.storageClient.create(blobInfo, dataToSave, new Storage.BlobTargetOption[0]);
            return Single.just((Object)nextVersion);
        }
        catch (StorageException e) {
            throw new VerifyException("Failed to save artifact to GCS", (Throwable)e);
        }
    }

    @Override
    public Maybe<Part> loadArtifact(String appName, String userId, String sessionId, String filename, Optional<Integer> version) {
        int versionToLoad;
        if (version.isPresent()) {
            versionToLoad = version.get();
        } else {
            ImmutableList versions = (ImmutableList)this.listVersions(appName, userId, sessionId, filename).blockingGet();
            if (versions.isEmpty()) {
                return Maybe.empty();
            }
            versionToLoad = (Integer)Collections.max(versions);
        }
        String blobName = this.getBlobName(appName, userId, sessionId, filename, versionToLoad);
        BlobId blobId = BlobId.of((String)this.bucketName, (String)blobName);
        try {
            com.google.cloud.storage.Blob blob = this.storageClient.get(blobId);
            if (blob == null || !blob.exists(new Blob.BlobSourceOption[0])) {
                return Maybe.empty();
            }
            byte[] data = blob.getContent(new Blob.BlobSourceOption[0]);
            String mimeType = blob.getContentType();
            return Maybe.just((Object)Part.fromBytes((byte[])data, (String)mimeType));
        }
        catch (StorageException e) {
            return Maybe.empty();
        }
    }

    @Override
    public Single<ListArtifactsResponse> listArtifactKeys(String appName, String userId, String sessionId) {
        HashSet<String> filenames = new HashSet<String>();
        String sessionPrefix = String.format("%s/%s/%s/", appName, userId, sessionId);
        try {
            for (Object blob : this.storageClient.list(this.bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)sessionPrefix)}).iterateAll()) {
                List parts = Splitter.on((char)'/').splitToList((CharSequence)blob.getName());
                filenames.add((String)parts.get(3));
            }
        }
        catch (StorageException e) {
            throw new VerifyException("Failed to list session artifacts from GCS", (Throwable)e);
        }
        String userPrefix = String.format("%s/%s/user/", appName, userId);
        try {
            for (com.google.cloud.storage.Blob blob : this.storageClient.list(this.bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)userPrefix)}).iterateAll()) {
                List parts = Splitter.on((char)'/').splitToList((CharSequence)blob.getName());
                filenames.add((String)parts.get(3));
            }
        }
        catch (StorageException e) {
            throw new VerifyException("Failed to list user artifacts from GCS", (Throwable)e);
        }
        return Single.just((Object)ListArtifactsResponse.builder().filenames((List<String>)ImmutableList.sortedCopyOf(filenames)).build());
    }

    @Override
    public Completable deleteArtifact(String appName, String userId, String sessionId, String filename) {
        ImmutableList versions = (ImmutableList)this.listVersions(appName, userId, sessionId, filename).blockingGet();
        ArrayList<BlobId> blobIdsToDelete = new ArrayList<BlobId>();
        Object object = versions.iterator();
        while (object.hasNext()) {
            int version = (Integer)object.next();
            String blobName = this.getBlobName(appName, userId, sessionId, filename, version);
            blobIdsToDelete.add(BlobId.of((String)this.bucketName, (String)blobName));
        }
        if (!blobIdsToDelete.isEmpty()) {
            try {
                object = this.storageClient.delete(blobIdsToDelete);
            }
            catch (StorageException e) {
                throw new VerifyException("Failed to delete artifact versions from GCS", (Throwable)e);
            }
        }
        return Completable.complete();
    }

    @Override
    public Single<ImmutableList<Integer>> listVersions(String appName, String userId, String sessionId, String filename) {
        String prefix = this.getBlobPrefix(appName, userId, sessionId, filename);
        ArrayList<Integer> versions = new ArrayList<Integer>();
        try {
            for (com.google.cloud.storage.Blob blob : this.storageClient.list(this.bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)prefix)}).iterateAll()) {
                String name = blob.getName();
                int versionDelimiterIndex = name.lastIndexOf(47);
                if (versionDelimiterIndex == -1 || versionDelimiterIndex >= name.length() - 1) continue;
                versions.add(Integer.parseInt(name.substring(versionDelimiterIndex + 1)));
            }
            return Single.just((Object)ImmutableList.sortedCopyOf(versions));
        }
        catch (StorageException e) {
            return Single.just((Object)ImmutableList.of());
        }
    }
}

