/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.web.controller;

import com.google.adk.web.AgentLoader;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AgentController {
    private static final Logger log = LoggerFactory.getLogger(AgentController.class);
    private final AgentLoader agentProvider;

    @Autowired
    public AgentController(AgentLoader agentProvider) {
        this.agentProvider = agentProvider;
        ImmutableList<String> agentNames = this.agentProvider.listAgents();
        log.info("AgentController initialized with {} dynamic agents: {}", (Object)agentNames.size(), agentNames);
        if (agentNames.isEmpty()) {
            log.warn("Agent registry is empty. Check 'adk.agents.source-dir' property and compilation logs.");
        }
    }

    @GetMapping(value={"/list-apps"})
    public List<String> listApps() {
        ImmutableList<String> agentNames = this.agentProvider.listAgents();
        log.info("Listing apps from dynamic registry. Found: {}", agentNames);
        return agentNames.stream().sorted().collect(Collectors.toList());
    }
}

