/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.attach;

import com.gluonhq.attach.AttachServiceDefinition;
import com.gluonhq.utils.MavenArtifactResolver;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.Dependency;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class AttachArtifactResolver {
    private static final String DEPENDENCY_GROUP = "com.gluonhq.attach";
    public static final String UTIL_ARTIFACT = "util";

    public static Map<String, org.apache.maven.artifact.Artifact> findArtifactsForTarget(List<Dependency> dependencies, String target) {
        return dependencies.stream().filter(d -> DEPENDENCY_GROUP.equals(d.getGroupId())).map(d -> {
            if (UTIL_ARTIFACT.equals(d.getArtifactId())) {
                if ("android".equals(target) || "ios".equals(target) || "ios-sim".equals(target)) {
                    return new DefaultArtifact(d.getGroupId(), d.getArtifactId(), target, d.getType(), d.getVersion());
                }
                return null;
            }
            AttachServiceDefinition asd = new AttachServiceDefinition(d.getArtifactId());
            return new DefaultArtifact(d.getGroupId(), d.getArtifactId(), asd.getSupportedPlatform(target), d.getType(), d.getVersion());
        }).filter(Objects::nonNull).flatMap(a -> {
            Set<org.apache.maven.artifact.Artifact> resolve = MavenArtifactResolver.getInstance().resolve((Artifact)a);
            if (resolve == null) {
                return Stream.empty();
            }
            return resolve.stream();
        }).distinct().collect(Collectors.toMap(org.apache.maven.artifact.Artifact::getArtifactId, a -> a));
    }
}

