/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.runtime;

import java.util.HashMap;
import java.util.Map;

final class ValueContext {
    private final ValueContext inheritedContext;
    private final Map<String, Class<?>> symbols;
    private final Map<String, Object> privateContext;
    private Map<String, Object> localContext;

    public ValueContext(ValueContext inheritedContext, Map<String, Class<?>> symbols, Map<String, Object> privateContext) {
        this.inheritedContext = inheritedContext;
        this.symbols = symbols;
        this.privateContext = privateContext;
        this.localContext = null;
    }

    public Class<?> getType(String name, boolean fromInherited) {
        Class<?> type;
        if (this.symbols != null && (type = this.symbols.get(name)) != null) {
            return type;
        }
        if (fromInherited && this.inheritedContext != null) {
            return this.inheritedContext.getType(name, true);
        }
        return null;
    }

    public Object getLocal(String name) {
        if (this.localContext != null) {
            return this.localContext.get(name);
        }
        return null;
    }

    public Object getPrivate(String name) {
        Object value;
        if (this.privateContext != null && (value = this.privateContext.get(name)) != null) {
            return value;
        }
        if (this.inheritedContext != null) {
            value = this.inheritedContext.getLocal(name);
            if (value != null) {
                return value;
            }
            value = this.inheritedContext.getPrivate(name);
            if (value != null) {
                return value;
            }
        }
        return null;
    }

    public void setLocal(String name, Object value) {
        if (this.localContext == null) {
            this.localContext = new HashMap<String, Object>();
        }
        this.localContext.put(name, value);
    }
}

