/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.resolver.property;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jetbrick.bean.FieldInfo;
import jetbrick.bean.KlassInfo;
import jetbrick.bean.PropertyInfo;
import jetbrick.template.resolver.SignatureUtils;
import jetbrick.template.resolver.property.ArrayLengthGetter;
import jetbrick.template.resolver.property.FieldGetter;
import jetbrick.template.resolver.property.Getter;
import jetbrick.template.resolver.property.GetterResolver;
import jetbrick.template.resolver.property.MapGetter;
import jetbrick.template.resolver.property.PropertyGetter;

public final class DefaultGetterResolver
implements GetterResolver {
    private final ConcurrentMap<String, Getter> cache = new ConcurrentHashMap<String, Getter>(256);
    private List<GetterResolver> resolvers;

    public void register(GetterResolver resolver) {
        if (this.resolvers == null) {
            this.resolvers = new ArrayList<GetterResolver>(4);
        }
        this.resolvers.add(resolver);
    }

    @Override
    public Getter resolve(Class<?> clazz, String name) {
        String signature = SignatureUtils.getFieldSignature(clazz, name);
        Getter found = (Getter)this.cache.get(signature);
        if (found != null) {
            return found;
        }
        Getter getter = this.doGetGetter(clazz, name);
        if (getter != null) {
            this.cache.put(signature, getter);
            return getter;
        }
        return null;
    }

    private Getter doGetGetter(Class<?> clazz, String name) {
        if ("length".equals(name) && clazz.isArray()) {
            return ArrayLengthGetter.INSTANCE;
        }
        KlassInfo klass = KlassInfo.create(clazz);
        PropertyInfo property = klass.getProperty(name);
        if (property != null && property.readable()) {
            return new PropertyGetter(property);
        }
        FieldInfo field = klass.getField(name);
        if (field != null && field.isPublic()) {
            return new FieldGetter(field);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return new MapGetter(name);
        }
        if (this.resolvers != null) {
            for (GetterResolver resolver : this.resolvers) {
                Getter getter = resolver.resolve(clazz, name);
                if (getter == null) continue;
                return getter;
            }
        }
        return null;
    }
}

