/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.resolver.method;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jetbrick.bean.ExecutableUtils;
import jetbrick.bean.KlassInfo;
import jetbrick.bean.MethodInfo;
import jetbrick.template.JetAnnotations;
import jetbrick.template.resolver.SignatureUtils;
import jetbrick.template.resolver.method.ClassBuildinMethodInvoker;
import jetbrick.template.resolver.method.ExtensionMethodInvoker;
import jetbrick.template.resolver.method.MethodInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MethodInvokerResolver {
    private static final Logger log = LoggerFactory.getLogger(MethodInvokerResolver.class);
    private final ConcurrentMap<String, MethodInvoker> cache = new ConcurrentHashMap<String, MethodInvoker>(256);
    private final Map<String, List<MethodInfo>> extensionMethodMap = new HashMap<String, List<MethodInfo>>(32);

    public void register(Class<?> cls) {
        KlassInfo klass = KlassInfo.create(cls);
        int i = 0;
        for (MethodInfo method : klass.getDeclaredMethods()) {
            if (!method.isStatic() || !method.isPublic() || method.getParameterCount() <= 0) continue;
            this.register(method);
            ++i;
        }
        log.info("import {} methods from {}", (Object)i, cls);
    }

    public void register(MethodInfo method) {
        List<MethodInfo> methods;
        String name = method.getName();
        JetAnnotations.Name rename = method.getMethod().getAnnotation(JetAnnotations.Name.class);
        if (rename != null && !"".equals(rename.value())) {
            name = rename.value();
        }
        if (log.isInfoEnabled()) {
            Class[] parameterTypes = method.getParameterTypes();
            StringBuffer sb = new StringBuffer();
            sb.append(parameterTypes[0].getSimpleName()).append('.');
            sb.append(name).append('(');
            for (int i = 1; i < parameterTypes.length; ++i) {
                if (i > 1) {
                    sb.append(',');
                }
                sb.append(parameterTypes[i].getName());
            }
            sb.append(')');
            log.debug("import method: {}", (Object)sb.toString());
        }
        if ((methods = this.extensionMethodMap.get(name)) == null) {
            methods = new ArrayList<MethodInfo>(4);
            this.extensionMethodMap.put(name, methods);
        }
        methods.add(method);
    }

    public MethodInvoker resolve(Class<?> clazz, String name, Class<?>[] argumentTypes, boolean isStatic) {
        String signature = SignatureUtils.getMethodSignature(clazz, name, argumentTypes);
        MethodInvoker found = (MethodInvoker)this.cache.get(signature);
        if (found != null) {
            return found;
        }
        MethodInvoker method = this.doGetMethodInvoker(clazz, name, argumentTypes, isStatic);
        if (method != null) {
            this.cache.put(signature, method);
            return method;
        }
        return null;
    }

    private MethodInvoker doGetMethodInvoker(Class<?> clazz, String name, Class<?>[] argumentTypes, boolean isStatic) {
        List<MethodInfo> methods;
        KlassInfo klass = KlassInfo.create(clazz);
        MethodInfo method = klass.searchMethod(name, (Class[])argumentTypes);
        if (method != null && method.isPublic()) {
            if (isStatic && method.isStatic() || !isStatic && !method.isStatic()) {
                return new ClassBuildinMethodInvoker(method);
            }
            return null;
        }
        if (!isStatic && (methods = this.extensionMethodMap.get(name)) != null) {
            int length = argumentTypes.length;
            Class[] extensionTypes = new Class[length + 1];
            extensionTypes[0] = clazz;
            System.arraycopy(argumentTypes, 0, extensionTypes, 1, length);
            method = (MethodInfo)ExecutableUtils.searchExecutable(methods, null, (Class[])extensionTypes);
            if (method != null) {
                return new ExtensionMethodInvoker(method);
            }
        }
        return null;
    }
}

