/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.resolver.clazz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jetbrick.io.finder.FileFinder;
import jetbrick.util.ClassLoaderUtils;
import jetbrick.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassResolver {
    private static final Logger log = LoggerFactory.getLogger(ClassResolver.class);
    private final List<String> importedPackageList = new ArrayList<String>(8);
    private final Map<String, Class<?>> importedClassMap = new ConcurrentHashMap(16);
    private final boolean enableLogger;

    public ClassResolver() {
        this(false);
    }

    public ClassResolver(boolean enableLogger) {
        this.enableLogger = enableLogger;
    }

    public void importClass(String name) {
        if (name.endsWith(".**")) {
            if (this.enableLogger) {
                log.info("import package: {}", (Object)name);
            }
            name = name.substring(0, name.length() - 3);
            for (String pkg : ClassResolver.getPackages(name)) {
                if (this.importedPackageList.contains(pkg)) continue;
                this.importedPackageList.add(pkg);
                if (!this.enableLogger) continue;
                log.info("found package: {}.*", (Object)pkg);
            }
            return;
        }
        if (name.endsWith(".*")) {
            if (!this.importedPackageList.contains(name = name.substring(0, name.length() - 2))) {
                this.importedPackageList.add(name);
                if (this.enableLogger) {
                    log.info("import package: {}.*", (Object)name);
                }
            }
            return;
        }
        try {
            Class cls = ClassLoaderUtils.loadClassEx((String)name);
            if (this.importedClassMap.put(cls.getSimpleName(), cls) == null && this.enableLogger) {
                log.info("import class: " + cls.getName());
            }
        }
        catch (ClassNotFoundException e) {
            if (Package.getPackage(name) != null) {
                throw new IllegalStateException("This is a package name, not a class name. You should use `" + name + ".*` for import classes");
            }
            throw ExceptionUtils.unchecked((Throwable)e);
        }
    }

    public Class<?> resolveClass(String className) {
        Class cls = this.importedClassMap.get(className);
        if (cls != null) {
            return cls;
        }
        cls = ClassLoaderUtils.loadClass((String)className);
        if (cls != null) {
            this.importedClassMap.put(className, cls);
            return cls;
        }
        int lpos = className.indexOf(46);
        if (lpos < 0 || lpos == className.lastIndexOf(46)) {
            String name = className;
            if (lpos > 0) {
                name = className.replace('.', '$');
            }
            for (String pkg : this.importedPackageList) {
                cls = ClassLoaderUtils.loadClass((String)(pkg + '.' + name));
                if (cls == null) continue;
                this.importedClassMap.put(className, cls);
                return cls;
            }
        }
        return null;
    }

    private static List<String> getPackages(String packageName) {
        final ArrayList<String> results = new ArrayList<String>();
        results.add(packageName);
        FileFinder finder = new FileFinder(){

            protected boolean visitDirectory(FileFinder.ResourceEntry dir) {
                results.add(dir.getQualifiedJavaName());
                return true;
            }
        };
        finder.lookupClasspath(Arrays.asList(packageName), true);
        return results;
    }
}

