/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser.ast;

import jetbrick.template.Errors;
import jetbrick.template.JetSecurityManager;
import jetbrick.template.parser.ast.ALU;
import jetbrick.template.parser.ast.AstExpression;
import jetbrick.template.parser.ast.AstExpressionList;
import jetbrick.template.parser.ast.Position;
import jetbrick.template.resolver.ParameterUtils;
import jetbrick.template.resolver.SignatureUtils;
import jetbrick.template.resolver.method.MethodInvoker;
import jetbrick.template.runtime.InterpretContext;
import jetbrick.template.runtime.InterpretException;
import jetbrick.util.ArrayUtils;

public final class AstInvokeMethod
extends AstExpression {
    private final AstExpression objectExpression;
    private final String name;
    private final AstExpressionList argumentList;
    private final boolean nullSafe;
    private MethodInvoker last;
    private boolean unsafe;

    public AstInvokeMethod(AstExpression objectExpression, String name, AstExpressionList argumentList, boolean nullSafe, Position position) {
        super(position);
        this.objectExpression = objectExpression;
        this.name = name;
        this.argumentList = argumentList;
        this.nullSafe = nullSafe;
        this.last = null;
        this.unsafe = true;
    }

    @Override
    public Object execute(InterpretContext ctx) throws InterpretException {
        Object object = this.objectExpression.execute(ctx);
        if (object == null) {
            if (this.nullSafe || ctx.getTemplate().getOption().isSafecall()) {
                return null;
            }
            throw new InterpretException("object is null").set(this.position);
        }
        if (object == ALU.VOID) {
            throw new InterpretException("object is void").set(this.position);
        }
        Object[] arguments = this.argumentList == null ? ArrayUtils.EMPTY_OBJECT_ARRAY : this.argumentList.execute(ctx);
        return this.doInvoke(ctx, this.last, object, arguments);
    }

    private Object doInvoke(InterpretContext ctx, MethodInvoker invoker, Object object, Object[] arguments) throws InterpretException {
        boolean useLatest;
        boolean bl = useLatest = invoker != null;
        if (invoker == null) {
            Class<?> objectClass = this.objectExpression.getResultType(ctx.getValueStack(), object);
            Class<?>[] argumentTypes = ParameterUtils.getParameterTypes(arguments);
            invoker = ctx.getGlobalResolver().resolveMethod(objectClass, this.name, argumentTypes, false);
            if (invoker == null) {
                String signature = SignatureUtils.getMethodSignature(objectClass, this.name, argumentTypes);
                throw new InterpretException("cannot resolve method: %s", signature).set(this.position);
            }
            this.last = invoker;
        }
        if (this.unsafe) {
            JetSecurityManager securityManager = ctx.getSecurityManager();
            if (securityManager != null) {
                try {
                    invoker.checkAccess(securityManager);
                }
                catch (RuntimeException e) {
                    throw new InterpretException(e).set(this.position);
                }
            }
            this.unsafe = false;
        }
        try {
            Object result = invoker.invoke(object, arguments);
            if (result != null) {
                return result;
            }
            return invoker.isVoidResult() ? ALU.VOID : null;
        }
        catch (InterpretException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (useLatest && Errors.isReflectIllegalArgumentException(e)) {
                return this.doInvoke(ctx, null, object, arguments);
            }
            throw new InterpretException("method invoke error: %s", invoker.getSignature()).cause(e).set(this.position);
        }
    }
}

